/*
 * main.c - Main functions config GUI
 * OmniJoy
 * by mike9010
 * Copyright (C) 2003 Michael Shoup
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "interface.h"
#include "support.h"
#include "main.h"

GtkWidget *window;
int use_epsxe;
int use_keyboard;

int
main (int argc, char *argv[])
{
	gtk_set_locale();
	gtk_init( &argc, &argv ); // Initialize GTK

	// Check to show config, or about
	if( argc > 1 && (strcmp( argv[1], "config" ) == 0) ) // if we want config...
	{
		load_conf();
		window = create_config_window(); // ... set the window to the config window
	}
	else // if we don't want config...
		window = create_about_dlg(); // ... then we want about

	gtk_widget_show( window ); // show the window

	gtk_main (); // start gtk
	return 0;
}

static struct cont_cfg cont1, cont2;

void set_conf( int controller, int bit, int value, const char *joydev )
{
	if( joydev != NULL )
	{
		if( controller == 2 )
			strncpy( cont2.jsdev, joydev, 256 );
		else
			strncpy( cont1.jsdev, joydev, 256 );
		return;
	}

	if( controller == 2 )
		cont2.bits[bit] = value;
	else
		cont1.bits[bit] = value;
}

const char *get_dev( int controller )
{
	if( controller == 2 )
		return cont2.jsdev;
	else
		return cont1.jsdev;
}

void save_conf()
{
	FILE *fp;

	fp = fopen( "cfg/omnijoy.cfg", "w" );
	if( fp == NULL )
	{
		perror( "omnijoy: FILE I/O" );
		return;
	}

	fprintf( fp, "1 DEVICE = %s\n",     cont1.jsdev );
	fprintf( fp, "1 BTN_SEL     = %d\n", cont1.bits[OJ_BTN_SEL] );
	fprintf( fp, "1 BTN_R3      = %d\n", cont1.bits[OJ_BTN_R3] );
	fprintf( fp, "1 BTN_L3      = %d\n", cont1.bits[OJ_BTN_L3] );
	fprintf( fp, "1 BTN_START   = %d\n", cont1.bits[OJ_BTN_START] );
	fprintf( fp, "1 BTN_UP      = %d\n", cont1.bits[OJ_BTN_UP] );
	fprintf( fp, "1 BTN_RIGHT   = %d\n", cont1.bits[OJ_BTN_RIGHT] );
	fprintf( fp, "1 BTN_DOWN    = %d\n", cont1.bits[OJ_BTN_DOWN] );
	fprintf( fp, "1 BTN_LEFT    = %d\n", cont1.bits[OJ_BTN_LEFT] );
	fprintf( fp, "1 BTN_L2      = %d\n", cont1.bits[OJ_BTN_L2] );
	fprintf( fp, "1 BTN_R2      = %d\n", cont1.bits[OJ_BTN_R2] );
	fprintf( fp, "1 BTN_L1      = %d\n", cont1.bits[OJ_BTN_L1] );
	fprintf( fp, "1 BTN_R1      = %d\n", cont1.bits[OJ_BTN_R1] );
	fprintf( fp, "1 BTN_TRI     = %d\n", cont1.bits[OJ_BTN_TRI] );
	fprintf( fp, "1 BTN_CIRCLE  = %d\n", cont1.bits[OJ_BTN_CIRCLE] );
	fprintf( fp, "1 BTN_CROSS   = %d\n", cont1.bits[OJ_BTN_CROSS] );
	fprintf( fp, "1 BTN_SQUARE  = %d\n", cont1.bits[OJ_BTN_SQUARE] );

	fprintf( fp, "2 DEVICE = %s\n",     cont2.jsdev );
	fprintf( fp, "2 BTN_SEL     = %d\n", cont2.bits[OJ_BTN_SEL] );
	fprintf( fp, "2 BTN_R3      = %d\n", cont2.bits[OJ_BTN_R3] );
	fprintf( fp, "2 BTN_L3      = %d\n", cont2.bits[OJ_BTN_L3] );
	fprintf( fp, "2 BTN_START   = %d\n", cont2.bits[OJ_BTN_START] );
	fprintf( fp, "2 BTN_UP      = %d\n", cont2.bits[OJ_BTN_UP] );
	fprintf( fp, "2 BTN_RIGHT   = %d\n", cont2.bits[OJ_BTN_RIGHT] );
	fprintf( fp, "2 BTN_DOWN    = %d\n", cont2.bits[OJ_BTN_DOWN] );
	fprintf( fp, "2 BTN_LEFT    = %d\n", cont2.bits[OJ_BTN_LEFT] );
	fprintf( fp, "2 BTN_L2      = %d\n", cont2.bits[OJ_BTN_L2] );
	fprintf( fp, "2 BTN_R2      = %d\n", cont2.bits[OJ_BTN_R2] );
	fprintf( fp, "2 BTN_L1      = %d\n", cont2.bits[OJ_BTN_L1] );
	fprintf( fp, "2 BTN_R1      = %d\n", cont2.bits[OJ_BTN_R1] );
	fprintf( fp, "2 BTN_TRI     = %d\n", cont2.bits[OJ_BTN_TRI] );
	fprintf( fp, "2 BTN_CIRCLE  = %d\n", cont2.bits[OJ_BTN_CIRCLE] );
	fprintf( fp, "2 BTN_CROSS   = %d\n", cont2.bits[OJ_BTN_CROSS] );
	fprintf( fp, "2 BTN_SQUARE  = %d\n", cont2.bits[OJ_BTN_SQUARE] );

	fprintf( fp, "0 USE_EPSXE   = %d\n", use_epsxe );
	fprintf( fp, "0 USE_KEY     = %d\n", use_keyboard );

	fclose(fp);
}

void rezero_cfg()
{
	int i;
	strcpy( cont1.jsdev, "/dev/js0" );
	strcpy( cont2.jsdev, "/dev/js1" );
	for( i=0; i < 16; i++ )
	{
		cont1.bits[i] = -1;
		cont2.bits[i] = -1;
	}
	use_epsxe = 0;
}

void load_conf()
{
	FILE *fp;
	char buffer[256];

	rezero_cfg();

	fp = fopen( "cfg/omnijoy.cfg", "r" );

	if( fp == NULL )
		return;

	while( !feof(fp) )
	{
		int cont_no;
		if( fgets( buffer, 256, fp ) == NULL ) break;
		cont_no = atoi( buffer );
		buffer[(strlen(buffer))-1] = '\0';

		if( strncmp( &buffer[2], "DEVICE", 6 ) == 0 )
		{
			if( cont_no == 2 )
				strcpy( cont2.jsdev, &buffer[11] );
			else if( cont_no == 1 )
				strcpy( cont1.jsdev, &buffer[11] );
		}

		else if( cont_no == 0 )
		{
			if( strncmp( &buffer[2], "USE_EPSXE", 9 ) == 0 )
				use_epsxe = atoi( &buffer[16] );
			if( strncmp( &buffer[2], "USE_KEY", 7 ) == 0 )
				use_keyboard = atoi( &buffer[16] );
		}

		else if( cont_no == 1 )
		{
			if( strncmp( &buffer[2], "BTN_SEL", 7 ) == 0 )
				cont1.bits[OJ_BTN_SEL] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_L3", 6 ) == 0 )
				cont1.bits[OJ_BTN_L3] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_R3", 6 ) == 0 )
				cont1.bits[OJ_BTN_R3] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_START", 9 ) == 0 )
				cont1.bits[OJ_BTN_START] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_UP", 6 ) == 0 )
				cont1.bits[OJ_BTN_UP] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_RIGHT", 9 ) == 0 )
				cont1.bits[OJ_BTN_RIGHT] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_DOWN", 8 ) == 0 )
				cont1.bits[OJ_BTN_DOWN] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_LEFT", 8 ) == 0 )
				cont1.bits[OJ_BTN_LEFT] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_L2", 6 ) == 0 )
				cont1.bits[OJ_BTN_L2] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_R2", 6 ) == 0 )
				cont1.bits[OJ_BTN_R2] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_R1", 6 ) == 0 )
				cont1.bits[OJ_BTN_R1] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_L1", 6 ) == 0 )
				cont1.bits[OJ_BTN_L1] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_TRI", 7 ) == 0 )
				cont1.bits[OJ_BTN_TRI] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_CIRCLE", 10 ) == 0 )
				cont1.bits[OJ_BTN_CIRCLE] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_CROSS", 9 ) == 0 )
				cont1.bits[OJ_BTN_CROSS] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_SQUARE", 10 ) == 0 )
				cont1.bits[OJ_BTN_SQUARE] = atoi( &buffer[16] );
		}
		else if( cont_no == 2 )
		{
			if( strncmp( &buffer[2], "BTN_SEL", 7 ) == 0 )
				cont2.bits[OJ_BTN_SEL] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_L3", 6 ) == 0 )
				cont2.bits[OJ_BTN_L3] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_R3", 6 ) == 0 )
				cont2.bits[OJ_BTN_R3] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_START", 9 ) == 0 )
				cont2.bits[OJ_BTN_START] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_UP", 6 ) == 0 )
				cont2.bits[OJ_BTN_UP] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_RIGHT", 9 ) == 0 )
				cont2.bits[OJ_BTN_RIGHT] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_DOWN", 8 ) == 0 )
				cont2.bits[OJ_BTN_DOWN] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_LEFT", 8 ) == 0 )
				cont2.bits[OJ_BTN_LEFT] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_L2", 6 ) == 0 )
				cont2.bits[OJ_BTN_L2] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_R2", 6 ) == 0 )
				cont2.bits[OJ_BTN_R2] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_R1", 6 ) == 0 )
				cont2.bits[OJ_BTN_R1] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_L1", 6 ) == 0 )
				cont2.bits[OJ_BTN_L1] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_TRI", 7 ) == 0 )
				cont2.bits[OJ_BTN_TRI] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_CIRCLE", 10 ) == 0 )
				cont2.bits[OJ_BTN_CIRCLE] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_CROSS", 9 ) == 0 )
				cont2.bits[OJ_BTN_CROSS] = atoi( &buffer[16] );

			else if( strncmp( &buffer[2], "BTN_SQUARE", 10 ) == 0 )
				cont2.bits[OJ_BTN_SQUARE] = atoi( &buffer[16] );
		}

	}

	fclose(fp);
}
