#pragma once

#include <SDL2/SDL.h>
#ifdef _WIN32
#include <windows.h>
#endif
#include <stdint.h>

void gotoNextMulti(void);
void textMarkerMoveLeft(void);
void textMarkerMoveRight(void);
void textCharPrevious(void);
void textCharNext(void);
void updateKeyModifiers(void);
void handleKeyRepeat(SDL_Scancode scancode);
void keyUpHandler(SDL_Scancode scancode, SDL_Keycode keycode);
void keyDownHandler(SDL_Scancode scancode, SDL_Keycode keycode);
void handleTextEditInputChar(char textChar);

#ifdef _WIN32
LRESULT CALLBACK lowLevelKeyboardProc(int32_t nCode, WPARAM wParam, LPARAM lParam);
#endif
