# 
# Prospect: a developer's system profiler.
# System Tests: symbol discrimination.
#
# COPYRIGHT (C) 2001-2004 Hewlett-Packard Company
#
# Author: Bob Montgomery, HP
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place - Suite 330, Boston, MA 02111-1307, USA.
#

# $Id: symstest.sh,v 1.4 2004/01/09 20:29:28 type2 Exp $

TIME=/usr/bin/time
FACTFILE=fact$$
TIMEFILE=time$$
PROSFILE=pros$$
SUBCOUNT=20
PROSPECT=../../prospect/prospect
total=0

trap "echo test terminated by interrupt ; \
    rm -f $FACTFILE $PROSFILE $TIMEFILE ; exit 1 ;" INT QUIT

# we need the non-built-in version of time
if [ ! -e $TIME ] ; then
    echo "ERROR: $0 requires executable $TIME"
    exit 1
fi

# check for the prospect command
if [ ! -x $PROSPECT ] ; then
        echo "ERROR: $0 requires executable $PROSPECT"
        echo "       Please build that first."
        exit 1
fi

rm -f cmd.log
TESTNUM=0
for FREQ in 128 1024 4096
do
  ###################################################################
  TESTNUM=`expr $TESTNUM + 1`
  COMMAND="syms e 4000"
  rm -f $FACTFILE
  {
  echo fact_description Staticly-linked subroutine discrimination test
  echo fact_good_sym_pat Even_
  echo fact_bad_sym_pat Odd_
  echo fact_subs_count 20
  echo fact_command $COMMAND
  echo fact_frequency $FREQ
  } >>$FACTFILE
  
  $TIME -f "fact_user_time %U\nfact_sys_time %S" -o $TIMEFILE $COMMAND \
      >>cmd.log 2>&1
  $PROSPECT -o $PROSFILE -H $FREQ $COMMAND >>cmd.log 2>&1
  
  cat $FACTFILE $TIMEFILE $PROSFILE | awk -f checktime.awk
  err=$?
  tmp=$err
  cat $FACTFILE $TIMEFILE $PROSFILE | awk -f checksyms.awk
  err=$?
  tmp=`expr $tmp + $err`
  if [ $tmp -gt 0 ]
  then
      total=`expr $total + 1`
      cat $FACTFILE $TIMEFILE $PROSFILE >test${TESTNUM}.out
      echo Error line numbers refer to test${TESTNUM}.out
  fi
  
  ###################################################################
  TESTNUM=`expr $TESTNUM + 1`
  COMMAND="symsd e 4000"
  rm -f $FACTFILE
  {
  echo fact_description Shared library subroutine discrimination test
  echo fact_good_sym_pat Even_
  echo fact_bad_sym_pat Odd_
  echo fact_subs_count 20
  echo fact_command $COMMAND
  echo fact_frequency $FREQ
  } >>$FACTFILE
  
  $TIME -f "fact_user_time %U\nfact_sys_time %S" -o $TIMEFILE $COMMAND \
      >>cmd.log 2>&1
  $PROSPECT -o $PROSFILE -H $FREQ $COMMAND >>cmd.log 2>&1
  
  cat $FACTFILE $TIMEFILE $PROSFILE | awk -f checktime.awk
  err=$?
  tmp=$err
  cat $FACTFILE $TIMEFILE $PROSFILE | awk -f checksyms.awk
  err=$?
  tmp=`expr $tmp + $err`
  if [ $tmp -gt 0 ]
  then
      total=`expr $total + 1`
      cat $FACTFILE $TIMEFILE $PROSFILE >test${TESTNUM}.out
      echo Error line numbers refer to test${TESTNUM}.out
  fi
  
  ###################################################################
  TESTNUM=`expr $TESTNUM + 1`
  COMMAND="symsd e 4000"
  #save a good copy of the shared lib
  cp libsubs.so libsubs.so.save
  strip libsubs.so || { echo "ERROR: failed to strip libsubs.so" ; exit 1; }
  
  rm -f $FACTFILE
  {
  echo fact_description Stripped shared library subroutine discrimination test 
  echo fact_good_sym_pat Even_
  echo fact_bad_sym_pat Odd_
  echo fact_dynamic_syms
  echo fact_subs_count 20
  echo fact_command $COMMAND
  echo fact_frequency $FREQ
  } >>$FACTFILE
  
  $TIME -f "fact_user_time %U\nfact_sys_time %S" -o $TIMEFILE $COMMAND \
      >>cmd.log 2>&1
  $PROSPECT -o $PROSFILE -H $FREQ $COMMAND >>cmd.log 2>&1
  
  cat $FACTFILE $TIMEFILE $PROSFILE | awk -f checktime.awk
  err=$?
  tmp=$err
  cat $FACTFILE $TIMEFILE $PROSFILE | awk -f checksyms.awk
  err=$?
  tmp=`expr $tmp + $err`
  if [ $tmp -gt 0 ]
  then
      total=`expr $total + 1`
      cat $FACTFILE $TIMEFILE $PROSFILE >test${TESTNUM}.out
      cat $FACTFILE $TIMEFILE $PROSFILE >test${TESTNUM}.out
      echo Error line numbers refer to test${TESTNUM}.out
  fi
  # put the library back
  mv libsubs.so.save libsubs.so
  
done
rm $FACTFILE $PROSFILE $TIMEFILE

if [ $total -gt 0 ]
then
    echo errors occurred in $total tests
    exit 1
fi
exit 0
