/***************************************************************************
                          tagger_flac.cpp  -  description
                             -------------------
    begin                : Wed May 9 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#undef QT_NO_ASCII_CAST   // utf8 support not fully implemented. Use taglib instead 

#if HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#if HAVE_FLAC

#include "tagger_flac.h"

#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <qfileinfo.h>

#include <FLAC++/metadata.h>

#include <iostream>
using namespace std;


Tagger_Flac::Tagger_Flac() {}
Tagger_Flac::~Tagger_Flac() {}


bool Tagger_Flac::getInfo(TRACK *track, bool lazyRead) {
    FLAC::Metadata::SimpleIterator *flacIterator =
        new FLAC::Metadata::SimpleIterator();
    
    if (flacIterator->is_valid() == false) 
    {
        delete flacIterator;
        return false;
    }
    if (flacIterator->init(track->path + "/" + track->filename, true, false)
        == false)
    {
        delete flacIterator;
        return false;
    }

    track->artist = "";
    track->title = "";
    track->album = "";
    track->comment = "";
    track->year = "";
    track->genre = 255;
    track->tracknumber = 0; 

    do
    {
        if (flacIterator->get_block_type() ==
            ::FLAC__METADATA_TYPE_VORBIS_COMMENT)
        {
            FLAC::Metadata::VorbisComment *vc =
                (FLAC::Metadata::VorbisComment *)flacIterator->get_block();
            Tagger_VorbisComment vbc(vc);
            delete vc;
            
            QString s;
            track->title   = (s = vbc.getvorbiscomment("title")) ==
                QString::null  ? QString("")  : s;
            track->artist  = (s = vbc.getvorbiscomment("artist")) ==
                QString::null? QString("")  : s;
            track->album   = (s = vbc.getvorbiscomment("album")) ==
                QString::null ? QString("")  : s;
            track->year    = (s = vbc.getvorbiscomment("year")) ==
                QString::null ? QString("")  : s;
            track->comment = (s = vbc.getvorbiscomment("comment")) ==
                QString::null ? QString("")  : s;
            track->genre   = ((s = vbc.getvorbiscomment("genre")) ==
                              QString::null ? QString("255") : s).toInt();
            track->tracknumber = ((s = vbc.getvorbiscomment( "tracknumber")) ==
                                  QString::null ? QString("0")  : s).toInt();

	    Tagger::stripWhiteSpace( track, "Flac");            
            
            track->mimetype = MIMETYPE_FLAC;
            track->layer = 0;
        }
        if (flacIterator->get_block_type() ==
            ::FLAC__METADATA_TYPE_STREAMINFO)
        {
            FLAC::Metadata::StreamInfo *vc =
                (FLAC::Metadata::StreamInfo *)flacIterator->get_block();

            track->mode = vc->get_channels();
            track->samplerate = vc->get_sample_rate();
            
            track->bitrate =
                (long) (vc->get_bits_per_sample()*track->samplerate/1024);
            track->length =
                (long) (vc->get_total_samples()/track->samplerate);
            if (verbose == 6 ) {
                cout << "Streaminfo: (" << track->filename << ")" << endl;
                cout << "  Mode        : " << track->mode << endl;
                cout << "  Samplerate  : " << track->samplerate << endl;
                cout << "  Bitrate     : " << track->bitrate << endl;
                cout << "  Length      : " << track->length << endl;
            }
            delete vc;
        }
    }
    while (flacIterator->next() == true);

    delete flacIterator;
    return true;
}

bool Tagger_Flac::getTagOnly(TRACK *track) {
    FLAC::Metadata::SimpleIterator *flacIterator =
        new FLAC::Metadata::SimpleIterator();
    
    if (flacIterator->is_valid() == false) 
    {
        delete flacIterator;
        return false;
    }
    if (flacIterator->init(track->path + "/" + track->filename, true, false)
        == false)
    {
        delete flacIterator;
        return false;
    }

    do
    {
        if (flacIterator->get_block_type() ==
            ::FLAC__METADATA_TYPE_VORBIS_COMMENT)
        {
            FLAC::Metadata::VorbisComment *vc =
                (FLAC::Metadata::VorbisComment *)flacIterator->get_block();
            Tagger_VorbisComment vbc(vc);
            delete vc;
            
            QString s;
            track->title   = (s = vbc.getvorbiscomment("title")) ==
                QString::null  ? QString("")  : s;
            track->artist  = (s = vbc.getvorbiscomment("artist")) ==
                QString::null? QString("")  : s;
            track->album   = (s = vbc.getvorbiscomment("album")) ==
                QString::null ? QString("")  : s;
            track->year    = (s = vbc.getvorbiscomment("year")) ==
                QString::null ? QString("")  : s;
            track->comment = (s = vbc.getvorbiscomment("comment")) ==
                QString::null ? QString("")  : s;
            track->genre   = ((s = vbc.getvorbiscomment("genre")) ==
                              QString::null ? QString("255") : s).toInt();
            track->tracknumber = ((s = vbc.getvorbiscomment( "tracknumber")) ==
                                  QString::null ? QString("0")  : s).toInt();
            
	    Tagger::stripWhiteSpace( track, "Flac");            

            break;
        }
    }
    while (flacIterator->next() == true);

    delete flacIterator;
    return true;
}

bool Tagger_Flac::writeInfo(TRACK *track) { 
    FLAC::Metadata::SimpleIterator *flacIterator =
        new FLAC::Metadata::SimpleIterator();
    
    if ( verbose==6 )  
        qWarning("flac::writeinfo  starts %s", track->filename.local8Bit().data());

    if (verbose == 6 ) {
        cout << "Flac Tags: (" << track->filename << ")" << endl;
        cout << "  Title   : " << track->title << endl;
        cout << "  Artist  : " << track->artist << endl;
        cout << "  Album   : " << track->album << endl;
        cout << "  Year    : " << track->year << endl;
        cout << "  Track   : " << track->tracknumber << endl;
        cout << "  Comment : " << track->comment << endl;
        cout << "  Genre   : " << track->genre << endl << endl;
    }
    if (flacIterator->is_valid() == false) 
    {
        delete flacIterator;
        return false;
    }
    if (flacIterator->init(track->path + "/" + track->filename, false, false)
        == false)
    {
        delete flacIterator;
        return false;
    }

    do
    {
        if (flacIterator->get_block_type() ==
            ::FLAC__METADATA_TYPE_VORBIS_COMMENT)
        {
            FLAC::Metadata::VorbisComment *vc =
                (FLAC::Metadata::VorbisComment *)flacIterator->get_block();
            /* clear the existing comments */
            enum comments {
                comments_title,
                comments_artist,
                comments_album,
                comments_year,
                comments_comment,
                comments_genre,
                comments_tracknumber,
                comments_num
            };

            char *commentFields[comments_num];

            commentFields[comments_title] =
                strdup( "title=" + track->title.utf8() );
            commentFields[comments_artist] =
                strdup( "artist=" + track->artist.utf8() );
            commentFields[comments_album] =
                strdup( "album=" + track->album.utf8() );
            commentFields[comments_year] =
                strdup( "year=" + track->year.utf8() );
            commentFields[comments_comment] =
                strdup( "comment=" + track->comment.utf8() );
            commentFields[comments_genre] =
                strdup( "genre=" + QString::number( track->genre ).utf8() );
            commentFields[comments_tracknumber] =
                strdup( "tracknumber=" +
                        QString::number(track->tracknumber).utf8() );
                
            bool commentsFilled[comments_num] = {false};
            
            for (int i = 0; i < vc->get_num_comments(); i++)
            {
                FLAC::Metadata::VorbisComment::Entry entry =
                    vc->get_comment(i);
                QString s(entry.get_field_name());

                for (int j = 0; j < comments_num; j++)
                {
                    QString commentField(commentFields[j]);
                                         
                    if (s.lower() == commentField.section('=',0,0))
                    {
                        entry.set_field(commentFields[j],
                                        strlen(commentFields[j]) + 1);
                        commentsFilled[j] = true;
                        vc->set_comment(i, entry);
                        continue;
                    }
                }
            }

            int index = vc->get_num_comments();
            for (int j = 0; j < comments_num; j++)
            {
                if (commentsFilled[j] != true)
                {
                    FLAC::Metadata::VorbisComment::Entry entry
                    (
                       commentFields[j],
                       strlen(commentFields[j]) + 1
                    );

                    vc->insert_comment(index++, entry);
                }
            }

            flacIterator->set_block(vc);
            
            delete vc;
            break;
        }
    }
    while (flacIterator->next() == true);

    delete flacIterator;
    return true;
}
#endif /* HAVE_FLAC */
