/****************************************************************************
** $Id: helpviewer.h,v 1.6 2005/08/04 23:48:27 mkalkbrenner Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#ifndef HELPWINDOW_H
#define HELPWINDOW_H

#include <qmainwindow.h>
#include <qtextbrowser.h>
#include <qstringlist.h>
#include <qmap.h>
#include <qdir.h>

#include <prokyon.h>

#include "finddialog.h"

class QComboBox;
class QPopupMenu;


class TextBrowser : public QTextBrowser
{
  Q_OBJECT
public:
  TextBrowser ( QWidget * parent = 0, const char * name = 0 ): QTextBrowser( parent, name ) {;}
public slots:
    void setSource ( const QString & name );
}; 


class HelpWindow : public QMainWindow
{
    Q_OBJECT
public:
    HelpWindow( const QString& home_,  const QString& path, QWidget* parent = 0, const char *name=0 );
    ~HelpWindow();

private slots:
    void setBackwardAvailable( bool );
    void setForwardAvailable( bool );

    void sourceChanged( const QString& );
    void openFile();
    void newWindow();
    void print();

    void pathSelected( const QString & );
    void histChosen( int );
    void bookmChosen( int );
    void addBookmark();
    void find();

private:
    void readHistory();
    void readBookmarks();

    TextBrowser* browser;
    QComboBox *pathCombo;
    int backwardId, forwardId;
    QStringList history, bookmarks;
    QMap<int, QString> mHistory, mBookmarks;
    QPopupMenu *hist, *bookm;
    FindDialog* findDialog;

};

#endif

