/***************************************************************************
                    guess_dialog.cpp  -  description
                             -------------------
    begin                : Sun Oct 5 2003
    copyright            : (C) 2003 by paul-henri ferme
    email                : pual-henri@users.sourceforge.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "guess_dialog.h"
#include "prokyon.h"

#include <qhbox.h>
#include <qframe.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qstringlist.h>
#include <qregexp.h>
#include <qfileinfo.h>
#include <qtooltip.h>
#include <qdir.h>

// initial position value in filename
int Guess_Dialog::titlespinPath1_v  = 0;
int Guess_Dialog::artistspinPath1_v = 0;
int Guess_Dialog::albumspinPath1_v  = 0;
int Guess_Dialog::trackspinPath1_v  = 0;
int Guess_Dialog::titlespinPath2_v  = 0;
int Guess_Dialog::artistspinPath2_v = 0;
int Guess_Dialog::albumspinPath2_v  = 0;
int Guess_Dialog::trackspinPath2_v  = 0;
int Guess_Dialog::titlespinFileName_v  = 2;
int Guess_Dialog::artistspinFileName_v = 1;
int Guess_Dialog::albumspinFileName_v  = 3;
int Guess_Dialog::trackspinFileName_v  = 0;
QString Guess_Dialog::sepanamePath1_v = "-";
QString Guess_Dialog::sepanamePath2_v = "-";
QString Guess_Dialog::sepanameFileName_v = "-";
	
Guess_Dialog::Guess_Dialog(QWidget *parent, const QString &filename, const QString &path, const char *name)
  : QDialog(parent, name, true)
{
  this->setCaption("prokyon3 - " + QString(_("guess from filename")));
  
  QFileInfo fi( filename );
  Filename = fi.baseName( true );  //up to (but not including) the last '.' character
  
  QDir dir( path );
  Path1 = dir.dirName();
  dir.cdUp();
  Path2 = dir.dirName();
  
  QVBoxLayout *lay = new QVBoxLayout(this);	

  QFrame *editbox = new QFrame(this); 
  QGridLayout *userlay = new QGridLayout(editbox, 9, 5);

  // TRANSLATORS: short form of 'Directory'
  QLabel *path1Label = new QLabel("<b>" + QString(_("Dir")) + " ..:</b> ", editbox); 
  path1Label->setAlignment(Qt::AlignRight);
  userlay->addWidget(path1Label, 0, 0);

  path1Value = new QLineEdit(Path1, editbox); 
  path1Value->setAlignment(Qt::AlignLeft);
  path1Value->setReadOnly( true );
  userlay->addMultiCellWidget(path1Value, 0, 0, 1, 4);

  // TRANSLATORS: short form of 'Directory'
  QLabel *path2Label = new QLabel("<b>" + QString(_("Dir")) + " ../..:</b> ", editbox); 
  path2Label->setAlignment(Qt::AlignRight);
  userlay->addWidget(path2Label, 1, 0);

  path2Value = new QLineEdit(Path2, editbox); 
  path2Value->setAlignment(Qt::AlignLeft);
  path2Value->setReadOnly( true );
  userlay->addMultiCellWidget(path2Value, 1, 1 , 1, 4);

  QLabel *fileNameLabel = new QLabel("<b>" + QString(_("Filename")) + ":</b> ", editbox); 
  fileNameLabel->setAlignment(Qt::AlignRight);
  userlay->addWidget(fileNameLabel, 2, 0);

  fileNameValue = new QLineEdit(Filename, editbox); 
  fileNameValue->setAlignment(Qt::AlignLeft);
  fileNameValue->setReadOnly( true );
  userlay->addMultiCellWidget(fileNameValue, 2, 2, 1, 4);

  QLabel *a0 = new QLabel("<b>" + QString(_("Position in")) + "<br>" + QString(_("Filename")) + "</b>", editbox); 
  a0->setAlignment(Qt::AlignCenter);
  userlay->addWidget(a0, 3, 2);

  // TRANSLATORS: short form of 'Directory'
  QLabel *b0 = new QLabel("<b>" + QString(_("Position in")) + "<br>" + QString(_("Dir")) + " .. </b>", editbox); 
  b0->setAlignment(Qt::AlignCenter);
  userlay->addWidget(b0, 3, 3);

  // TRANSLATORS: short form of 'Directory'
  QLabel *c0 = new QLabel("<b>" + QString(_("Position in")) + "<br>" + QString(_("Dir")) + " ../..</b>", editbox); 
  c0->setAlignment(Qt::AlignCenter);
  userlay->addWidget(c0, 3, 4);

  QLabel *a1 = new QLabel("<b>" + QString(_("Artist")) + ":</b> ", editbox); 
  a1->setAlignment(Qt::AlignRight);
  userlay->addWidget(a1, 4, 0);

  artistname = new QLineEdit("artist", editbox);
  userlay->addWidget(artistname, 4, 1);

  artistspinFileName = new QSpinBox(0,10,1,editbox);
  artistspinFileName->setValue(artistspinFileName_v);
  userlay->addWidget(artistspinFileName, 4, 2);

  artistspinPath1 = new QSpinBox(0,10,1,editbox);
  artistspinPath1->setValue(artistspinPath1_v);
  userlay->addWidget(artistspinPath1, 4, 3);

  artistspinPath2 = new QSpinBox(0,10,1,editbox);
  artistspinPath2->setValue(artistspinPath2_v);
  userlay->addWidget(artistspinPath2, 4, 4);

  QLabel *b1 = new QLabel("<b>" + QString(_("Album")) + ":</b> ", editbox); 
  b1->setAlignment(Qt::AlignRight);
  userlay->addWidget(b1, 5, 0);

  albumname = new QLineEdit("album", editbox);
  userlay->addWidget(albumname, 5, 1);

  albumspinPath1 = new QSpinBox(0,10,1,editbox);
  albumspinPath1->setValue(albumspinPath1_v);
  userlay->addWidget(albumspinPath1, 5, 3);

  albumspinPath2 = new QSpinBox(0,10,1,editbox);
  albumspinPath2->setValue(albumspinFileName_v);
  userlay->addWidget(albumspinPath2, 5, 4);

  albumspinFileName = new QSpinBox(0,10,1,editbox);
  albumspinFileName->setValue(albumspinFileName_v);
  userlay->addWidget(albumspinFileName, 5, 2);

  QLabel *c1 = new QLabel("<b>" + QString(_("Title")) + ":</b> ", editbox); 
  c1->setAlignment(Qt::AlignRight);
  userlay->addWidget(c1, 6, 0);

  titlename = new QLineEdit("titlename", editbox);
  userlay->addWidget(titlename, 6, 1);

  titlespinFileName = new QSpinBox(0,10,1,editbox);
  titlespinFileName->setValue(titlespinFileName_v);
  userlay->addWidget(titlespinFileName, 6, 2);
  
  titlespinPath1 = new QSpinBox(0,10,1,editbox);
  titlespinPath1->setValue(titlespinPath1_v);
  userlay->addWidget(titlespinPath1, 6, 3);
  
  titlespinPath2 = new QSpinBox(0,10,1,editbox);
  titlespinPath2->setValue(titlespinPath2_v);
  userlay->addWidget(titlespinPath2, 6, 4);
  
  QLabel *d1 = new QLabel("<b>" + QString(_("Track")) + ":</b> ", editbox); 
  d1->setAlignment(Qt::AlignRight);
  userlay->addWidget(d1, 7, 0);

  track = new QLineEdit("track", editbox);
  userlay->addWidget(track, 7, 1);

  trackspinFileName = new QSpinBox(0,10,1,editbox);
  trackspinFileName->setValue(trackspinFileName_v);
  userlay->addWidget(trackspinFileName, 7, 2);
  
  trackspinPath1 = new QSpinBox(0,10,1,editbox);
  trackspinPath1->setValue(trackspinPath1_v);
  userlay->addWidget(trackspinPath1, 7, 3);
  
  trackspinPath2 = new QSpinBox(0,10,1,editbox);
  trackspinPath2->setValue(trackspinPath2_v);
  userlay->addWidget(trackspinPath2, 7, 4);
  
  QLabel *e1 = new QLabel("<b>" + QString(_("Separator (as a regular expression)")) + ":</b> ", editbox); 
  userlay->addMultiCellWidget(e1, 8, 8, 0, 1);

  sepanameFileName = new QLineEdit(sepanameFileName_v, editbox);
  sepanameFileName->setAlignment(Qt::AlignCenter);
  userlay->addWidget(sepanameFileName, 8, 2);

  sepanamePath1 = new QLineEdit(sepanamePath1_v, editbox);
  sepanamePath1->setAlignment(Qt::AlignCenter);
  userlay->addWidget(sepanamePath1, 8, 3);

  sepanamePath2 = new QLineEdit(sepanamePath2_v, editbox);
  sepanamePath2->setAlignment(Qt::AlignCenter);
  userlay->addWidget(sepanamePath2, 8, 4);

  connect(artistspinFileName, SIGNAL(valueChanged(int)), this, SLOT(slot_artistspinFileName()));
  connect(artistspinPath1, SIGNAL(valueChanged(int)), this, SLOT(slot_artistspinPath1()));
  connect(artistspinPath2, SIGNAL(valueChanged(int)), this, SLOT(slot_artistspinPath2()));
  connect(albumspinFileName, SIGNAL(valueChanged(int)), this, SLOT(slot_albumspinFileName()));
  connect(albumspinPath1, SIGNAL(valueChanged(int)), this, SLOT(slot_albumspinPath1()));
  connect(albumspinPath2, SIGNAL(valueChanged(int)), this, SLOT(slot_albumspinPath2()));
  connect(titlespinFileName, SIGNAL(valueChanged(int)), this, SLOT(slot_titlespinFileName()));
  connect(titlespinPath1, SIGNAL(valueChanged(int)), this, SLOT(slot_titlespinPath1()));
  connect(titlespinPath2, SIGNAL(valueChanged(int)), this, SLOT(slot_titlespinPath2()));
  connect(trackspinFileName, SIGNAL(valueChanged(int)), this, SLOT(slot_trackspinFileName()));
  connect(trackspinPath1, SIGNAL(valueChanged(int)), this, SLOT(slot_trackspinPath1()));
  connect(trackspinPath2, SIGNAL(valueChanged(int)), this, SLOT(slot_trackspinPath2()));

  QHBox *butbox = new QHBox(this);

  QPushButton *editbutton = new QPushButton(_("Save"), butbox);	
  QPushButton *guessbutton = new QPushButton(_("Update"), butbox);
  QPushButton *cancelbutton = new QPushButton(_("Skip"), butbox);	
  QPushButton *cancelallbutton = new QPushButton(_("Cancel remaining"), butbox);	
	
  connect(guessbutton, SIGNAL(clicked()), this, SLOT(slot_guess()));
  connect(cancelbutton, SIGNAL(clicked()), this, SLOT(slot_cancel()));
  connect(editbutton, SIGNAL(clicked()), this, SLOT(slot_edit()));
  connect(cancelallbutton, SIGNAL(clicked()), this, SLOT(slot_cancelall()));

  lay->addWidget(editbox);
  lay->addWidget(butbox);

  QToolTip::add( editbox, _("Tags value are guessed from track file name,\nusing a configurable regexp as a separator.\n(See QRegexp in QT documentation for more)\n\n An index value of 0 will leave the field unchanged.\n If no parameter, field is forced to \"Unknown\"") );

  slot_guess();
}

void Guess_Dialog::slot_guess() {

  QStringList qsFileName = QStringList::split ( QRegExp(sepanameFileName->text()), Filename, true );
  QStringList qsPath1 = QStringList::split ( QRegExp(sepanamePath1->text()), Path1, true );
  QStringList qsPath2 = QStringList::split ( QRegExp(sepanamePath2->text()), Path2, true );

  artistname->clear();
  albumname->clear();
  titlename->clear();
  track->clear();
  
  if (artistspinFileName->value() || artistspinPath1->value() || artistspinPath2->value()) { // skip if 0
    if (artistspinFileName->value() > 0 && artistspinFileName->value() <= qsFileName.count())
      artistname->setText( qsFileName[artistspinFileName->value()-1].stripWhiteSpace().isEmpty() ? 
			   _("Unknown") : qsFileName[artistspinFileName->value()-1].stripWhiteSpace() );
    else if (artistspinPath1->value() > 0 && artistspinPath1->value() <= qsPath1.count())
      artistname->setText( qsPath1[artistspinPath1->value()-1].stripWhiteSpace().isEmpty() ? 
             _("Unknown") : qsPath1[artistspinPath1->value()-1].stripWhiteSpace() );
    else if (artistspinPath2->value() > 0 && artistspinPath2->value() <= qsPath2.count())
      artistname->setText( qsPath2[artistspinPath2->value()-1].stripWhiteSpace().isEmpty() ? 
             _("Unknown") : qsPath2[artistspinPath2->value()-1].stripWhiteSpace() );
  }
  
  if (albumspinFileName->value() || albumspinPath1->value() || albumspinPath2->value()) { // skip if 0
    if (albumspinFileName->value() > 0 && albumspinFileName->value() <= qsFileName.count()) 
      albumname->setText( qsFileName[albumspinFileName->value()-1].stripWhiteSpace().isEmpty() ?
			  _("Unknown") : qsFileName[albumspinFileName->value()-1].stripWhiteSpace() );
    else if (albumspinPath1->value() > 0 && albumspinPath1->value() <= qsPath1.count()) 
      albumname->setText( qsPath1[albumspinPath1->value()-1].stripWhiteSpace().isEmpty() ?
              _("Unknown") : qsPath1[albumspinPath1->value()-1].stripWhiteSpace() );
    else if (albumspinPath2->value() > 0 && albumspinPath2->value() <= qsPath2.count()) 
      albumname->setText( qsPath2[albumspinPath2->value()-1].stripWhiteSpace().isEmpty() ?
              _("Unknown") : qsPath2[albumspinPath2->value()-1].stripWhiteSpace() );
  }
  
  if (titlespinFileName->value() || titlespinPath1->value() || titlespinPath2->value()) { // skip if 0
    if (titlespinFileName->value() > 0 && titlespinFileName->value() <= qsFileName.count()) 
      titlename->setText(qsFileName[titlespinFileName->value()-1].stripWhiteSpace().isEmpty() ?
			 _("Unknown") : qsFileName[titlespinFileName->value()-1].stripWhiteSpace());
    else if (titlespinPath1->value() > 0 && titlespinPath1->value() <= qsPath1.count()) 
      titlename->setText(qsPath1[titlespinPath1->value()-1].stripWhiteSpace().isEmpty() ?
          _("Unknown") : qsPath1[titlespinPath1->value()-1].stripWhiteSpace());
    else if (titlespinPath2->value() > 0 && titlespinPath2->value() <= qsPath2.count()) 
      titlename->setText(qsPath2[titlespinPath2->value()-1].stripWhiteSpace().isEmpty() ?
          _("Unknown") : qsPath2[titlespinPath2->value()-1].stripWhiteSpace());
  }
  
  if (trackspinFileName->value() || trackspinPath1->value() || trackspinPath2->value()) { // skip if 0
    if (trackspinFileName->value() > 0 && trackspinFileName->value() <= qsFileName.count()) 
      track->setText(qsFileName[trackspinFileName->value()-1].stripWhiteSpace().isEmpty() ?
           _("Unknown") : qsFileName[trackspinFileName->value()-1].stripWhiteSpace());
    else if (trackspinPath1->value() > 0 && trackspinPath1->value() <= qsPath1.count()) 
      track->setText(qsPath1[trackspinPath1->value()-1].stripWhiteSpace().isEmpty() ?
          _("Unknown") : qsPath1[trackspinPath1->value()-1].stripWhiteSpace());
    else if (trackspinPath2->value() > 0 && trackspinPath2->value() <= qsPath2.count()) 
      track->setText(qsPath2[trackspinPath2->value()-1].stripWhiteSpace().isEmpty() ?
          _("Unknown") : qsPath2[trackspinPath2->value()-1].stripWhiteSpace());
    bool ok;
    track->text().toInt(&ok);
    if (!ok)
      track->setText(_("Unknown"));
  }
  
  if (artistspinFileName->value() || artistspinPath1->value() || artistspinPath2->value()) // skip if 0
    if (artistname->text().isEmpty()) artistname->setText(_("Unknown"));  // force if index larger than count
  if (albumspinFileName->value() || albumspinPath1->value() || albumspinPath2->value())
    if (albumname->text().isEmpty()) albumname->setText(_("Unknown"));
  if (titlespinFileName->value() || titlespinPath1->value() || titlespinPath2->value())
    if (titlename->text().isEmpty()) titlename->setText(_("Unknown"));
  if (trackspinFileName->value() || trackspinPath1->value() || trackspinPath2->value())
    if (track->text().isEmpty()) track->setText(_("Unknown"));
}

void Guess_Dialog::slot_cancel() {
  reject();
}

void Guess_Dialog::slot_cancelall() {
  done(Guess_Dialog::SkipRemaining);
}

void Guess_Dialog::slot_edit() {
  accept();
}

void Guess_Dialog::slot_artistspinFileName() {
  artistspinPath1->setValue(0);
  artistspinPath2->setValue(0);
}

void Guess_Dialog::slot_artistspinPath1() {
  artistspinFileName->setValue(0);
  artistspinPath2->setValue(0);
}

void Guess_Dialog::slot_artistspinPath2() {
  artistspinPath1->setValue(0);
  artistspinFileName->setValue(0);
}

void Guess_Dialog::slot_albumspinFileName() {
  albumspinPath1->setValue(0);
  albumspinPath2->setValue(0);
}

void Guess_Dialog::slot_albumspinPath1() {
  albumspinFileName->setValue(0);
  albumspinPath2->setValue(0);
}

void Guess_Dialog::slot_albumspinPath2() {
  albumspinPath1->setValue(0);
  albumspinFileName->setValue(0);
}

void Guess_Dialog::slot_titlespinFileName() {
  titlespinPath1->setValue(0);
  titlespinPath2->setValue(0);
}

void Guess_Dialog::slot_titlespinPath1() {
  titlespinFileName->setValue(0);
  titlespinPath2->setValue(0);
}

void Guess_Dialog::slot_titlespinPath2() {
  titlespinPath1->setValue(0);
  titlespinFileName->setValue(0);
}

void Guess_Dialog::slot_trackspinFileName() {
  trackspinPath1->setValue(0);
  trackspinPath2->setValue(0);
}

void Guess_Dialog::slot_trackspinPath1() {
  trackspinFileName->setValue(0);
  trackspinPath2->setValue(0);
}

void Guess_Dialog::slot_trackspinPath2() {
  trackspinPath1->setValue(0);
  trackspinFileName->setValue(0);
}

Guess_Dialog::~Guess_Dialog()
{
  artistspinFileName_v = artistspinFileName->value();
  titlespinFileName_v = titlespinFileName->value();
  albumspinFileName_v = albumspinFileName->value();
  trackspinFileName_v = albumspinFileName->value();
  sepanameFileName_v = sepanameFileName->text();
  artistspinPath1_v = artistspinPath1->value();
  titlespinPath1_v = titlespinPath1->value();
  albumspinPath1_v = albumspinPath1->value();
  trackspinPath1_v = albumspinPath1->value();
  sepanamePath1_v = sepanamePath1->text();
  artistspinPath2_v = artistspinPath2->value();
  titlespinPath2_v = titlespinPath2->value();
  albumspinPath2_v = albumspinPath2->value();
  trackspinPath2_v = albumspinPath2->value();
  sepanamePath2_v = sepanamePath2->text();
}
	
