/*
    EditingPreferences.m

    Implementation of the EditingPreferences class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "EditingPreferences.h"

#import <Foundation/NSBundle.h>
#import <Foundation/NSString.h>
#import <Foundation/NSUserDefaults.h>

#import <AppKit/NSNibLoading.h>
#import <AppKit/NSView.h>
#import <AppKit/NSButton.h>
#import <AppKit/NSPopUpButton.h>

@implementation EditingPreferences

+ (NSString *) name
{
  return _(@"Code Editing");
}

- (void) dealloc
{
  TEST_RELEASE(view);

  [super dealloc];
}

- (void) awakeFromNib
{
  NSUserDefaults * df = [NSUserDefaults standardUserDefaults];

  [view retain];
  [view removeFromSuperview];
  DESTROY(bogusWindow);

  [tabConversion selectItemAtIndex: [df integerForKey: @"TabConversion"]];
  [autoindent setState: [df boolForKey: @"ReturnDoesAutoindent"]];
  [highlightParentheses setState: ![df boolForKey: @"DontTrackNesting"]];
  [drawCrosshairs setState: [df boolForKey: @"DrawCrosshairs"]];
  [syntaxHighlighting setState: ![df boolForKey:
    @"DisableSyntaxHighlighting"]];
}

- (NSView *) view
{
  if (view == nil)
    {
      [NSBundle loadNibNamed: @"EditingPreferences" owner: self];
    }

  return view;
}

- (void) changeTabConversion: sender
{
  [[NSUserDefaults standardUserDefaults]
    setInteger: [tabConversion indexOfSelectedItem]
        forKey: @"TabConversion"];
}

- (void) changeAutoindent: sender
{
  [[NSUserDefaults standardUserDefaults]
    setBool: [autoindent state] forKey: @"ReturnDoesAutoindent"];
}

- (void) changeHighlightParentheses: sender
{
  [[NSUserDefaults standardUserDefaults]
    setBool: ![highlightParentheses state] forKey: @"DontTrackNesting"];
}

- (void) changeDrawCrosshairs: sender
{
  [[NSUserDefaults standardUserDefaults]
    setBool: [drawCrosshairs state] forKey: @"DrawCrosshairs"];
}

- (void) changeSyntaxHighlighting: sender
{
  [[NSUserDefaults standardUserDefaults]
    setBool: ![syntaxHighlighting state]
     forKey: @"DisableSyntaxHighlighting"];
}

@end
