/*
    ArchivedObject.h

    Interface declaration of the ArchivedObject class for the KeyArcher
    application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef _ARCHIVEDOBJECT_H_
#define _ARCHIVEDOBJECT_H_

#import <Foundation/NSObject.h>

@class ObjectGraph;

@interface ArchivedObject : NSObject
{
  // composite objects
  unsigned int classUID;

  NSDictionary * attributes;
  NSDictionary * relationships;

  NSArray * sortedAttributeNames,
          * sortedRelationshipNames;

  // weak ref
  ObjectGraph * owner;
}

- initWithObjectGraph: (ObjectGraph *) parent;

- initWithDescription: (NSDictionary *) description
          objectGraph: (ObjectGraph *) parent;

- (void) setupRelationships;

- (unsigned int) classUID;
- (void) setClassUID: (unsigned int) aUID;

- (NSArray *) attributeNames;
- valueOfAttribute: (NSString *) attribute;

- (void) setAttributes: (NSDictionary *) attrs;

- (NSArray *) relationshipNames;
- (unsigned int) destinationUIDOfRelationship: (NSString *) relationship;

- (void) setRelationships: (NSDictionary *) attrs;

@end

#endif // _ARCHIVEDOBJECT_H_
