/*
    BundleProjectType.h

    Interface declaration of the BundleProjectType class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>
#import "../../ProjectType.h"

@class NSString, NSDictionary, NSArray, NSMutableArray;
@class ProjectDocument;

@class BundleAttributes;

@interface BundleProjectType : NSObject <ProjectType>
{
  // weak reference
  ProjectDocument * owner;

  NSArray  * authors;
  NSString * bundleExtension;
  NSString * principalClass;
  NSString * bundleDescription;
  NSString * copyright;
  NSString * copyrightDescription;

  BundleAttributes * attributes;
}

- (void) setPrincipalClass: (NSString *) aClass;
- (NSString *) principalClass;

- (void) setAuthors: (NSArray *) anArray;
- (NSArray *) authors;

- (void) setBundleDescription: (NSString *) aDescription;
- (NSString *) bundleDescription;

- (void) setCopyright: (NSString *) aCopyright;
- (NSString *) copyright;

- (void) setCopyrightDescription: (NSString *) aCopyrightDescription;
- (NSString *) copyrightDescription;

- (void) setBundleExtension: (NSString *) anExtension;
- (NSString *) bundleExtension;

@end
