/*
    ApplicationGeneralAttributes.h

    Interface declaration of the ApplicationGeneralAttributes class for
    the ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>

@class ApplicationProjectType;

@class NSView;

@class NSTableView, NSTableColumn;

@interface ApplicationGeneralAttributes : NSObject
{
  // weak reference
  ApplicationProjectType * owner;

  id authors;
  id bogusWindow;
  id copyright;
  id copyrightDescription;
  id description;
  id iconFilename;
  id mainNibFile;
  id view;
  id principalClass;
  id release;
}

- initWithOwner: (ApplicationProjectType *) anOwner;

- (void) addAuthor: (id)sender;
- (void) changeCopyright: (id)sender;
- (void) changeCopyrightDescription: (id)sender;
- (void) changeDescription: (id)sender;
- (void) changeIconFilename: (id)sender;
- (void) changeMainNibFile: (id)sender;
- (void) changePrincipalClass: (id)sender;
- (void) changeRelease: (id)sender;
- (void) moveAuthorUp: (id)sender;
- (void) moveAuthorDown: (id)sender;
- (void) removeAuthor: (id)sender;

- (NSView *) view;

- (int) numberOfRowsInTableView: (NSTableView *)aTableView;
- (id) tableView: (NSTableView *)aTableView 
objectValueForTableColumn: (NSTableColumn *)aTableColumn 
             row: (int)rowIndex;
- (void) tableView: (NSTableView *)aTableView 
    setObjectValue: (id)anObject 
    forTableColumn: (NSTableColumn *)aTableColumn
               row: (int)rowIndex;

@end
