/*
    ProjectNameChecking.m

    Implementations of functions for validating project names.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "ProjectNameChecking.h"

#import <Foundation/NSString.h>
#import <Foundation/NSCharacterSet.h>
#import <Foundation/NSBundle.h>

#import <AppKit/NSPanel.h>

static NSCharacterSet * allowedProjectNameCharacters = nil;

BOOL IsValidProjectName(NSString * projectName, BOOL showAlert)
{
  if (allowedProjectNameCharacters == nil)
    {
      allowedProjectNameCharacters = [[NSCharacterSet
        characterSetWithCharactersInString: @"abcdefghijklmnopqrstuvwxyz"
                                            @"ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                                            @"0123456789"
                                            @"-_"] retain];
    }

  if ([[projectName stringByTrimmingCharactersInSet:
    allowedProjectNameCharacters] length] != 0)
    {
      if (showAlert)
        {
          NSRunAlertPanel(_(@"Project name not valid"),
            _(@"The project name \"%@\" isn't a valid project name.\n"
              @"Project names may only contain non-accented letters a-z,\n"
              @"the digits 0-9 and the characters \"-\" and \"_\"."),
            nil, nil, nil, projectName);
        }

      return NO;
    }
  else
    {
      return YES;
    }
}
