/*
    ProjectNameChecking.h

    Declarations of functions for validating project names.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

@class NSString;

#import <Foundation/NSObject.h>

/**
 * Checks whether `projectName' is a valid project name. If showAlert = YES,
 * then if the project name isn't valid this functiona also runs an alert
 * panel telling the user why the project name isn't valid.
 *
 * @return YES if the provided name is a valid project name, otherwise NO.
 */
BOOL IsValidProjectName(NSString * projectName, BOOL showAlert);
