/*
    Preferences.m

    Implementation of the Preferences class for the ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "Preferences.h"

#import <Foundation/NSBundle.h>
#import <Foundation/NSString.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSDictionary.h>

#import <AppKit/NSNibLoading.h>
#import <AppKit/NSBox.h>
#import <AppKit/NSPopUpButton.h>
#import <AppKit/NSPanel.h>

#import "PreferencesModule.h"

@implementation Preferences

static Preferences * shared = nil;

+ shared
{
  if (shared == nil)
    {
      shared = [self new];
    }

  return shared;
}

- init
{
  if ([super init])
    {
      NSEnumerator * e;
      NSArray * paths;
      NSString * path;
      NSMutableDictionary * modules;

       // find all prefs modules
      paths = [[NSBundle mainBundle]
        pathsForResourcesOfType: @"prefs" inDirectory: nil];

      modules = [NSMutableDictionary dictionaryWithCapacity: [paths count]];

      e = [paths objectEnumerator];
      while ((path = [e nextObject]) != nil)
        {
          Class c;

          c = [[NSBundle bundleWithPath: path] principalClass];
          if (c != Nil &&
            [c conformsToProtocol: @protocol(PreferencesModule)])
            {
              [modules setObject: [[c new] autorelease] forKey: [c name]];
            }
          else
            {
              NSDebugLog(_(@"Failed to load preferences module at %@."), path);
            }
        }

      ASSIGNCOPY(prefsModules, modules);

      [NSBundle loadNibNamed: @"PreferencesPanel" owner: self];

      [self showModule: popup];

      return self;
    }
  else
    {
      return nil;
    }
}

- (void) awakeFromNib
{
  [popup removeAllItems];
  [popup addItemsWithTitles: [[prefsModules allKeys]
    sortedArrayUsingSelector: @selector(caseInsensitiveCompare:)]];
}

- (void) showModule: sender
{
  [box setContentView: [[prefsModules objectForKey: [popup
    titleOfSelectedItem]] view]];
}

- (void) activate
{
  [panel makeKeyAndOrderFront: nil];
}

@end
