/*
    Builder.h

    Interface declaration of the Builder class for the ProjectManager
    application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "InternalProjectModule.h"

@class NSString, NSMutableArray, NSFileHandle, NSNotification;

@class NSView, NSTableView, NSTableColumn, NSTask;

@interface Builder : InternalProjectModule
{
  id buildOutput;
  id buildArgsField;
  id buildArgs;
  id buildButton;
  id buildErrors;
  id buildTarget;
  id cleanButton;
  id distclean;
  id verboseBuild;
  id warnings;
  id allWarnings;

  NSMutableArray * buildArguments;
  NSMutableArray * buildErrorList;
  NSString * lastIncompleteErrorLine;

  BOOL stopOperation;

  NSTask * task;
  NSFileHandle * outputFileHandle, * errorFileHandle;
}

- (void) build: (id)sender;
- (void) clean: (id)sender;

- (void) addBuildArgument: (id)sender;
- (void) removeBuildArgument: (id)sender;
- (void) moveBuildArgumentUp: sender;
- (void) moveBuildArgumentDown: sender;

- (void) openErrorFile: sender;

- (int) numberOfRowsInTableView: (NSTableView *)aTableView;
- (id) tableView: (NSTableView *)aTableView 
objectValueForTableColumn: (NSTableColumn *)aTableColumn 
             row: (int)rowIndex;

- (void) collectOutput: (NSNotification *) notif;
- (void) collectErrorOutput: (NSNotification *) notif;

- (void) buildCompleted: (NSNotification *) notif;
- (void) cleanCompleted: (NSNotification *) notif;

@end
