/*
    ArgumentsInspector.m

    Implementation of the ArgumentInspector class for the ProjectManager
    application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "ArgumentsInspector.h"


#import <AppKit/NSTextField.h>
#import <AppKit/NSNibLoading.h>
#import <AppKit/NSTableView.h>
#import <AppKit/NSTableColumn.h>
#import <AppKit/NSPanel.h>
#import <AppKit/NSScrollView.h>
#import <AppKit/NSScroller.h>

#import <Foundation/NSString.h>
#import <Foundation/NSValue.h>

@implementation ArgumentsInspector

static ArgumentsInspector * shared = nil;

+ shared
{
  if (shared == nil)
    {
      shared = [self new];
    }

  return shared;
}

- (void) dealloc
{
  TEST_RELEASE(arguments);

  [super dealloc];
}

- (void) awakeFromNib
{
  [panel setFrameAutosaveName: @"ArgumentsInspector"];
}

- (void) activateWithProject: (NSString *) aProject
                   arguments: (NSMutableArray *) args
{
  if (panel == nil)
    {
      [NSBundle loadNibNamed: @"ArgumentsInspector" owner: self];
    }

  [project setStringValue: aProject];
  ASSIGN(arguments, args);
  [table reloadData];

  [panel makeKeyAndOrderFront: nil];
}

- (void) addArgument: (id)sender
{
  [arguments addObject: @""];
  [table reloadData];
}


- (void) moveArgumentUp: (id)sender
{
  int row = [table selectedRow];

  if (row > 0)
    {
      id original = [[arguments objectAtIndex: row - 1] retain];

      [arguments replaceObjectAtIndex: row - 1
                           withObject: [arguments objectAtIndex: row]];
      [arguments replaceObjectAtIndex: row withObject: original];
      [table selectRow: row - 1 byExtendingSelection: NO];
      [original release];
    }
}


- (void) moveArgumentDown: (id)sender
{
  int row = [table selectedRow];

  if (row >= 0 && (row + 1) < (int) [arguments count])
    {
      id original = [[arguments objectAtIndex: row + 1] retain];

      [arguments replaceObjectAtIndex: row + 1
                           withObject: [arguments objectAtIndex: row]];
      [arguments replaceObjectAtIndex: row withObject: original];
      [table selectRow: row + 1 byExtendingSelection: NO];
      [original release];
    }
}


- (void) removeArgument: (id)sender
{
  int row = [table selectedRow];

  if (row >= 0)
    {
      [arguments removeObjectAtIndex: row];
      [table reloadData];
    }
}

- (int) numberOfRowsInTableView: (NSTableView *)aTableView
{
  return [arguments count];
}

- (id) tableView: (NSTableView *)aTableView 
objectValueForTableColumn: (NSTableColumn *)aTableColumn 
             row: (int)rowIndex
{
  if ([[aTableColumn identifier] isEqualToString: @"Position"])
    {
      return [NSNumber numberWithInt: rowIndex];
    }
  else
    {
      return [arguments objectAtIndex: rowIndex];
    }
}

- (void) tableView: (NSTableView *)aTableView 
    setObjectValue: (id)anObject 
    forTableColumn: (NSTableColumn *)aTableColumn
               row: (int)rowIndex
{
  [arguments replaceObjectAtIndex: rowIndex withObject: anObject];
}

@end
