/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Cursor;
import java.io.PrintStream;
import javax.swing.JTextArea;
import proguard.Configuration;
import proguard.ProGuard;
import proguard.gui.GUIResources;
import proguard.gui.MessageDialogRunnable;
import proguard.gui.ProGuardGUI;
import proguard.gui.TextAreaOutputStream;

class ProGuardRunnable
implements Runnable {
    private JTextArea consoleTextArea;
    private Configuration configuration;
    private String configurationFileName;

    public ProGuardRunnable(JTextArea jTextArea, Configuration configuration, String string) {
        this.consoleTextArea = jTextArea;
        this.configuration = configuration;
        this.configurationFileName = string;
    }

    public void run() {
        this.consoleTextArea.setCursor(Cursor.getPredefinedCursor(3));
        this.consoleTextArea.setText("");
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        PrintStream printStream3 = new PrintStream(new TextAreaOutputStream(this.consoleTextArea), true);
        System.setOut(printStream3);
        System.setErr(printStream3);
        try {
            ProGuard proGuard = new ProGuard(this.configuration);
            proGuard.execute();
            System.out.println("Processing completed successfully");
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            MessageDialogRunnable.showMessageDialog(this.consoleTextArea, exception.getMessage(), this.msg("errorProcessing"), 0);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            System.out.println(this.msg("outOfMemoryInfo", this.configurationFileName));
            MessageDialogRunnable.showMessageDialog(this.consoleTextArea, this.msg("outOfMemory"), this.msg("errorProcessing"), 0);
        }
        printStream3.flush();
        System.setOut(printStream);
        System.setErr(printStream2);
        this.consoleTextArea.setCursor(Cursor.getPredefinedCursor(0));
        ProGuardGUI.systemOutRedirected = false;
    }

    private String msg(String string) {
        return GUIResources.getMessage(string);
    }

    private String msg(String string, Object object) {
        return GUIResources.getMessage(string, new Object[]{object});
    }
}

