/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation.value;

import proguard.optimize.evaluation.value.DoubleValue;
import proguard.optimize.evaluation.value.DoubleValueFactory;
import proguard.optimize.evaluation.value.FloatValue;
import proguard.optimize.evaluation.value.FloatValueFactory;
import proguard.optimize.evaluation.value.IntegerValue;
import proguard.optimize.evaluation.value.IntegerValueFactory;
import proguard.optimize.evaluation.value.LongValue;
import proguard.optimize.evaluation.value.LongValueFactory;

class SpecificDoubleValue
extends DoubleValue {
    private double value;

    public SpecificDoubleValue(double d) {
        this.value = d;
    }

    public double value() {
        return this.value;
    }

    public DoubleValue generalize(DoubleValue doubleValue) {
        return doubleValue.generalize(this);
    }

    public DoubleValue add(DoubleValue doubleValue) {
        return doubleValue.add(this);
    }

    public DoubleValue subtract(DoubleValue doubleValue) {
        return doubleValue.subtractFrom(this);
    }

    public DoubleValue subtractFrom(DoubleValue doubleValue) {
        return doubleValue.subtract(this);
    }

    public DoubleValue multiply(DoubleValue doubleValue) {
        return doubleValue.multiply(this);
    }

    public DoubleValue divide(DoubleValue doubleValue) {
        return doubleValue.divideOf(this);
    }

    public DoubleValue divideOf(DoubleValue doubleValue) {
        return doubleValue.divide(this);
    }

    public DoubleValue remainder(DoubleValue doubleValue) {
        return doubleValue.remainderOf(this);
    }

    public DoubleValue remainderOf(DoubleValue doubleValue) {
        return doubleValue.remainder(this);
    }

    public IntegerValue compare(DoubleValue doubleValue) {
        return doubleValue.compareReverse(this);
    }

    public DoubleValue negate() {
        return DoubleValueFactory.create(-this.value);
    }

    public IntegerValue convertToInteger() {
        return IntegerValueFactory.create((int)this.value);
    }

    public LongValue convertToLong() {
        return LongValueFactory.create((long)this.value);
    }

    public FloatValue convertToFloat() {
        return FloatValueFactory.create((float)this.value);
    }

    public DoubleValue generalize(SpecificDoubleValue specificDoubleValue) {
        return this.value == specificDoubleValue.value ? this : DoubleValueFactory.create();
    }

    public DoubleValue add(SpecificDoubleValue specificDoubleValue) {
        return DoubleValueFactory.create(this.value + specificDoubleValue.value);
    }

    public DoubleValue subtract(SpecificDoubleValue specificDoubleValue) {
        return DoubleValueFactory.create(this.value - specificDoubleValue.value);
    }

    public DoubleValue subtractFrom(SpecificDoubleValue specificDoubleValue) {
        return DoubleValueFactory.create(specificDoubleValue.value - this.value);
    }

    public DoubleValue multiply(SpecificDoubleValue specificDoubleValue) {
        return DoubleValueFactory.create(this.value * specificDoubleValue.value);
    }

    public DoubleValue divide(SpecificDoubleValue specificDoubleValue) {
        return DoubleValueFactory.create(this.value / specificDoubleValue.value);
    }

    public DoubleValue divideOf(SpecificDoubleValue specificDoubleValue) {
        return DoubleValueFactory.create(specificDoubleValue.value / this.value);
    }

    public DoubleValue remainder(SpecificDoubleValue specificDoubleValue) {
        return DoubleValueFactory.create(this.value % specificDoubleValue.value);
    }

    public DoubleValue remainderOf(SpecificDoubleValue specificDoubleValue) {
        return DoubleValueFactory.create(specificDoubleValue.value % this.value);
    }

    public IntegerValue compare(SpecificDoubleValue specificDoubleValue) {
        return this.value < specificDoubleValue.value ? IntegerValueFactory.create(-1) : (this.value == specificDoubleValue.value ? IntegerValueFactory.create(0) : IntegerValueFactory.create(1));
    }

    public boolean isSpecific() {
        return true;
    }

    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && this.value == ((SpecificDoubleValue)object).value;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ (int)Double.doubleToLongBits(this.value);
    }

    public String toString() {
        return "d:" + this.value;
    }
}

