/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.editor.CodeAttrInfoEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;

public class MethodInvocationFixer
implements InstructionVisitor,
CpInfoVisitor,
MemberInfoVisitor {
    private static final boolean DEBUG = false;
    private CodeAttrInfoEditor codeAttrInfoEditor;
    private boolean isMethodInvocation;
    private int accessFlags;
    private boolean isInitializer;
    private boolean isInterfaceMethod;
    private int parameterSize;

    public MethodInvocationFixer(CodeAttrInfoEditor codeAttrInfoEditor) {
        this.codeAttrInfoEditor = codeAttrInfoEditor;
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
        int n2 = cpInstruction.cpIndex;
        int n3 = cpInstruction.constant;
        this.isMethodInvocation = false;
        this.isInterfaceMethod = false;
        this.accessFlags = 0;
        this.parameterSize = n3;
        classFile.constantPoolEntryAccept(n2, this);
        if (this.isMethodInvocation) {
            byte by = cpInstruction.opcode;
            if ((this.accessFlags & 8) != 0) {
                if (by != -72) {
                    Instruction instruction = new CpInstruction(-72, n2).shrink();
                    this.codeAttrInfoEditor.replaceInstruction(n, instruction);
                }
            } else if ((this.accessFlags & 2) != 0 || this.isInitializer) {
                if (by != -73) {
                    Instruction instruction = new CpInstruction(-73, n2).shrink();
                    this.codeAttrInfoEditor.replaceInstruction(n, instruction);
                }
            } else if (this.isInterfaceMethod) {
                if (by != -71 || this.parameterSize != n3) {
                    Instruction instruction = new CpInstruction(-71, n2, this.parameterSize).shrink();
                    this.codeAttrInfoEditor.replaceInstruction(n, instruction);
                }
            } else if (by != -74 && by != -73) {
                Instruction instruction = new CpInstruction(-74, n2).shrink();
                this.codeAttrInfoEditor.replaceInstruction(n, instruction);
            }
        }
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
        classFile.constantPoolEntryAccept(interfaceMethodrefCpInfo.u2classIndex, this);
        interfaceMethodrefCpInfo.referencedMemberInfoAccept(this);
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
        classFile.constantPoolEntryAccept(methodrefCpInfo.u2classIndex, this);
        methodrefCpInfo.referencedMemberInfoAccept(this);
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
        if (ClassUtil.isInternalArrayType(classCpInfo.getName(classFile))) {
            this.isInterfaceMethod = false;
        } else {
            ClassFile classFile2 = classCpInfo.referencedClassFile;
            if (classFile2 != null) {
                this.isInterfaceMethod = (classFile2.getAccessFlags() & 0x200) != 0;
            }
        }
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.visitMethodInfo(programClassFile, programMethodInfo);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        this.visitMethodInfo(libraryClassFile, libraryMethodInfo);
    }

    private void visitMethodInfo(ClassFile classFile, MethodInfo methodInfo) {
        this.isMethodInvocation = true;
        this.accessFlags = methodInfo.getAccessFlags();
        this.isInitializer = methodInfo.getName(classFile).equals("<init>");
        if (this.isInterfaceMethod) {
            this.parameterSize = ClassUtil.internalMethodParameterSize(methodInfo.getDescriptor(classFile)) + 1 << 8;
        }
    }

    private void debug(ClassFile classFile, MethodInfo methodInfo, int n, CpInstruction cpInstruction, Instruction instruction) {
        System.out.println("MethodInvocationFixer:");
        System.out.println("  Class file       = " + classFile.getName());
        System.out.println("  Method           = " + methodInfo.getName(classFile) + methodInfo.getDescriptor(classFile));
        System.out.println("  Instruction      = " + cpInstruction.toString(n));
        System.out.println("  Interface method = " + this.isInterfaceMethod);
        if (this.isInterfaceMethod) {
            System.out.println("  Parameter size   = " + this.parameterSize);
        }
        System.out.println("  Replacement instruction = " + instruction.toString(n));
    }
}

