/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.attribute.AttrInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.visitor.ClassFileVisitor;

public class SignatureAttrInfo
extends AttrInfo {
    private static final int CONSTANT_FIELD_SIZE = 2;
    public int u2signatureIndex;
    public ClassFile[] referencedClassFiles;

    protected SignatureAttrInfo() {
    }

    public void referencedClassesAccept(ClassFileVisitor classFileVisitor) {
        if (this.referencedClassFiles != null) {
            for (int i = 0; i < this.referencedClassFiles.length; ++i) {
                if (this.referencedClassFiles[i] == null) continue;
                this.referencedClassFiles[i].accept(classFileVisitor);
            }
        }
    }

    protected int getLength() {
        return 2;
    }

    protected void readInfo(DataInput dataInput, ClassFile classFile) throws IOException {
        this.u2signatureIndex = dataInput.readUnsignedShort();
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.u2signatureIndex);
    }

    public void accept(ClassFile classFile, AttrInfoVisitor attrInfoVisitor) {
        attrInfoVisitor.visitSignatureAttrInfo(classFile, this);
    }
}

