/*
 * Decompiled with CFR 0.152.
 */
package proguard.ant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import proguard.ClassPath;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.ParseException;
import proguard.ant.ClassPathElement;
import proguard.ant.ClassSpecificationElement;
import proguard.ant.ConfigurationElement;
import proguard.ant.KeepAttributeElement;

public class ConfigurationTask
extends Task {
    protected Configuration configuration = new Configuration();

    public void appendTo(Configuration configuration) {
        configuration.programJars = this.extendClassPath(configuration.programJars, this.configuration.programJars);
        configuration.libraryJars = this.extendClassPath(configuration.libraryJars, this.configuration.libraryJars);
        configuration.keep = this.extendClassSpecifications(configuration.keep, this.configuration.keep);
        configuration.keepNames = this.extendClassSpecifications(configuration.keepNames, this.configuration.keepNames);
        configuration.keepAttributes = this.extendAttributes(configuration.keepAttributes, this.configuration.keepAttributes);
    }

    public void addConfiguredInjar(ClassPathElement classPathElement) {
        this.configuration.programJars = this.extendClassPath(this.configuration.programJars, classPathElement, false);
    }

    public void addConfiguredOutjar(ClassPathElement classPathElement) {
        this.configuration.programJars = this.extendClassPath(this.configuration.programJars, classPathElement, true);
    }

    public void addConfiguredLibraryjar(ClassPathElement classPathElement) {
        this.configuration.libraryJars = this.extendClassPath(this.configuration.libraryJars, classPathElement, false);
    }

    public void addConfiguredKeep(ClassSpecificationElement classSpecificationElement) {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, classSpecificationElement, true, false);
    }

    public void addConfiguredKeepclassmembers(ClassSpecificationElement classSpecificationElement) {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, classSpecificationElement, false, false);
    }

    public void addConfiguredKeepclasseswithmembers(ClassSpecificationElement classSpecificationElement) {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, classSpecificationElement, true, true);
    }

    public void addConfiguredKeepnames(ClassSpecificationElement classSpecificationElement) {
        this.configuration.keepNames = this.extendClassSpecifications(this.configuration.keepNames, classSpecificationElement, true, false);
    }

    public void addConfiguredKeepclassmembernames(ClassSpecificationElement classSpecificationElement) {
        this.configuration.keepNames = this.extendClassSpecifications(this.configuration.keepNames, classSpecificationElement, false, false);
    }

    public void addConfiguredKeepclasseswithmembernames(ClassSpecificationElement classSpecificationElement) {
        this.configuration.keepNames = this.extendClassSpecifications(this.configuration.keepNames, classSpecificationElement, true, true);
    }

    public void addConfiguredWhyareyoukeeping(ClassSpecificationElement classSpecificationElement) {
        this.configuration.whyAreYouKeeping = this.extendClassSpecifications(this.configuration.whyAreYouKeeping, classSpecificationElement, true, false);
    }

    public void addConfiguredAssumenosideeffects(ClassSpecificationElement classSpecificationElement) {
        this.configuration.assumeNoSideEffects = this.extendClassSpecifications(this.configuration.assumeNoSideEffects, classSpecificationElement, false, false);
    }

    public void addConfiguredKeepattribute(KeepAttributeElement keepAttributeElement) {
        this.configuration.keepAttributes = this.extendAttributes(this.configuration.keepAttributes, keepAttributeElement);
    }

    public void addConfiguredConfiguration(ConfigurationElement configurationElement) {
        configurationElement.appendTo(this.configuration);
    }

    public void addText(String string) throws BuildException {
        try {
            String string2 = this.getProject().replaceProperties(string);
            ConfigurationParser configurationParser = new ConfigurationParser(new String[]{string2}, this.getProject().getBaseDir());
            try {
                configurationParser.parse(this.configuration);
            }
            catch (ParseException parseException) {
                throw new BuildException(parseException.getMessage());
            }
            finally {
                configurationParser.close();
            }
        }
        catch (IOException iOException) {
            throw new BuildException(iOException.getMessage());
        }
    }

    private String optionalFileName(String string) {
        return string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("off") ? null : (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("on") ? "" : string);
    }

    private ClassPath extendClassPath(ClassPath classPath, ClassPathElement classPathElement, boolean bl) {
        if (classPath == null) {
            classPath = new ClassPath();
        }
        classPathElement.appendClassPathEntriesTo(classPath, bl);
        return classPath;
    }

    private ClassPath extendClassPath(ClassPath classPath, ClassPath classPath2) {
        if (classPath2 != null) {
            if (classPath == null) {
                classPath = new ClassPath();
            }
            classPath.addAll(classPath2);
        }
        return classPath;
    }

    private List extendClassSpecifications(List arrayList, ClassSpecificationElement classSpecificationElement, boolean bl, boolean bl2) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        classSpecificationElement.appendTo(arrayList, bl, bl2);
        return arrayList;
    }

    private List extendClassSpecifications(List arrayList, List list) {
        if (list != null) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private List extendAttributes(List arrayList, KeepAttributeElement keepAttributeElement) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        keepAttributeElement.appendTo(arrayList);
        return arrayList;
    }

    private List extendAttributes(List arrayList, List list) {
        if (list != null) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            arrayList.addAll(list);
        }
        return arrayList;
    }
}

