require.scopes.multiDomainFP = (function () {

/**
 * 2d array of related domains (etld+1), all domains owned by the same entity go into
 * an array, this is later transformed for efficient lookups.
 */
let multiDomainFirstPartiesArray = [
  ["1800contacts.com", "800contacts.com"],
  ["37signals.com", "basecamp.com", "basecamphq.com", "highrisehq.com"],
  ["9gag.com", "9cache.com"],
  ["accountonline.com", "citi.com", "citibank.com", "citicards.com", "citibankonline.com"],
  [
    "adidas-group.com",

    "adidas.ae",
    "adidas.at",
    "adidas.be",
    "adidas.ca",
    "adidas.ch",
    "adidas.cl",
    "adidas.cn",
    "adidas.co",
    "adidas.co.id",
    "adidas.co.in",
    "adidas.co.kr",
    "adidas.com",
    "adidas.com.ar",
    "adidas.com.au",
    "adidas.com.br",
    "adidas.com.co",
    "adidas.com.hk",
    "adidas.com.my",
    "adidas.com.om",
    "adidas.com.pe",
    "adidas.com.ph",
    "adidas.com.qa",
    "adidas.com.sa",
    "adidas.com.sg",
    "adidas.com.tr",
    "adidas.com.tw",
    "adidas.com.vn",
    "adidas.co.nz",
    "adidas.co.th",
    "adidas.co.uk",
    "adidas.co.za",
    "adidas.cz",
    "adidas.de",
    "adidas.dk",
    "adidas.es",
    "adidas.fi",
    "adidas.fr",
    "adidas.gr",
    "adidas.hu",
    "adidas.ie",
    "adidas.it",
    "adidas.jp",
    "adidas.mx",
    "adidas.nl",
    "adidas.no",
    "adidas.pe",
    "adidas.pl",
    "adidas.pt",
    "adidas.ru",
    "adidas.se",
    "adidas.sk",
    "adidas.us",
  ],
  [
    "adobe.com",
    "adobeexchange.com",
    "adobe.io",
    "adobelogin.com",
    "behance.net",
    "mixamo.com",
    "myportfolio.com",
    "typekit.com",
  ],
  [
    "airbnb.com",

    "airbnb.ae",
    "airbnb.al",
    "airbnb.am",
    "airbnb.at",
    "airbnb.az",
    "airbnb.ba",
    "airbnb.be",
    "airbnb.ca",
    "airbnb.cat",
    "airbnb.ch",
    "airbnb.cl",
    "airbnb.co.cr",
    "airbnb.co.id",
    "airbnb.co.il",
    "airbnb.co.in",
    "airbnb.co.kr",
    "airbnb.com.ar",
    "airbnb.com.au",
    "airbnb.com.bo",
    "airbnb.com.br",
    "airbnb.com.bz",
    "airbnb.com.co",
    "airbnb.com.ec",
    "airbnb.com.ee",
    "airbnb.com.gt",
    "airbnb.com.hk",
    "airbnb.com.hn",
    "airbnb.com.hr",
    "airbnb.com.kh",
    "airbnb.com.mt",
    "airbnb.com.my",
    "airbnb.com.ni",
    "airbnb.com.pa",
    "airbnb.com.pe",
    "airbnb.com.ph",
    "airbnb.com.py",
    "airbnb.com.ro",
    "airbnb.com.sg",
    "airbnb.com.sv",
    "airbnb.com.tr",
    "airbnb.com.tw",
    "airbnb.com.ua",
    "airbnb.com.vn",
    "airbnb.co.nz",
    "airbnb.co.uk",
    "airbnb.co.ve",
    "airbnb.co.za",
    "airbnb.cz",
    "airbnb.de",
    "airbnb.dk",
    "airbnb.es",
    "airbnb.fi",
    "airbnb.fr",
    "airbnb.gr",
    "airbnb.gy",
    "airbnb.hu",
    "airbnb.ie",
    "airbnb.is",
    "airbnb.it",
    "airbnb.jp",
    "airbnb.la",
    "airbnb.lt",
    "airbnb.lu",
    "airbnb.lv",
    "airbnb.me",
    "airbnb.mx",
    "airbnb.nl",
    "airbnb.no",
    "airbnb.pl",
    "airbnb.pt",
    "airbnb.rs",
    "airbnb.ru",
    "airbnb.se",
    "airbnb.si",

    "muscache.com",
  ],
  [
    "airfranceklm.com",

    "airfrance.cg",
    "airfrance.ci",
    "airfrance.com.cn",
    "airfrance.com.do",
    "airfrance.com.gh",
    "airfrance.dz",
    "airfrance.id",
    "airfrance.in",
    "airfrance.my",
    "airfrance.ng",
    "airfrance.pa",
    "airfrance.tn",
    "airfrance.vn",

    "klm.ae",
    "klm.at",
    "klm.aw",
    "klm.be",
    "klm.bg",
    "klm.by",
    "klm.bz",
    "klm.ca",
    "klm.ch",
    "klm.cl",
    "klm.co.ao",
    "klm.co.cr",
    "klm.co.id",
    "klm.co.il",
    "klm.co.in",
    "klm.co.jp",
    "klm.co.ke",
    "klm.co.kr",
    "klm.com",
    "klm.com.ar",
    "klm.com.au",
    "klm.com.bh",
    "klm.com.br",
    "klm.com.co",
    "klm.com.cy",
    "klm.com.ec",
    "klm.com.eg",
    "klm.com.gh",
    "klm.com.hk",
    "klm.com.mt",
    "klm.com.mx",
    "klm.com.my",
    "klm.com.na",
    "klm.com.ng",
    "klm.com.pa",
    "klm.com.pe",
    "klm.com.ph",
    "klm.com.py",
    "klm.com.qa",
    "klm.com.tr",
    "klm.com.tw",
    "klm.com.uy",
    "klm.co.nz",
    "klm.co.th",
    "klm.co.tz",
    "klm.co.ug",
    "klm.co.uk",
    "klm.co.za",
    "klm.co.zm",
    "klm.cw",
    "klm.cz",
    "klm.de",
    "klm.dk",
    "klm.do",
    "klm.es",
    "klm.fi",
    "klm.fr",
    "klm.ge",
    "klm.gr",
    "klm.hr",
    "klm.hu",
    "klm.ie",
    "klm.it",
    "klm.kz",
    "klm.lk",
    "klm.lt",
    "klm.lu",
    "klm.lv",
    "klm.mu",
    "klm.mw",
    "klm.nc",
    "klm.nl",
    "klm.no",
    "klm.pl",
    "klm.pt",
    "klm.ro",
    "klm.ru",
    "klm.se",
    "klm.sg",
    "klm.sk",
    "klm.sr",
    "klm.sx",
    "klm.ua",
    "klm.us",

    "static-af.com",
    "static-kl.com",
  ],
  [
    "alibaba.com",

    "1688.com",
    "95095.com",
    "9game.cn",
    "aliapp.org",
    "alibabacloud.co.in",
    "alibabacloud.com",
    "alibabacloud.com.au",
    "alibabacloud.com.hk",
    "alibabacloud.com.my",
    "alibabacloud.com.sg",
    "alibabacloud.com.tw",
    "alibabacorp.com",
    "alibabagroup.com",
    "alibaba-inc.com",
    "alicdn.com",
    "alicdn.net",
    "alicloud.com",
    "aliexpress.com",
    "aliexpress.ru",
    "alifanyi.com",
    "aligames.com",
    "alihealth.cn",
    "alihive.com",
    "aliimg.com",
    "alimama.com",
    "alimei.com",
    "aliplus.com",
    "alitrip.com",
    "alitrip.hk",
    "aliyun.com",
    "aliyuncs.com",
    "aliyun-iot-share.com",
    "amap.com",
    "cainiao.com",
    "cainiao.com.cn",
    "cibntv.net",
    "cnzz.com",
    "dayu.com",
    "dingtalkapps.com",
    "dingtalk.com",
    "dongting.com",
    "ele.me",
    "elenet.me",
    "etao.com",
    "feizhu.cn",
    "feizhu.com",
    "fliggy.com",
    "fliggy.hk",
    "i52hz.com",
    "jiaoyimao.com",
    "jingguan.ai",
    "jiyoujia.com",
    "juhuasuan.com",
    "kumiao.com",
    "laifeng.com",
    "liangxinyao.com",
    "mappcloud.com",
    "mei.com",
    "mmstat.com",
    "mobmore.com",
    "paike.com",
    "phpwind.com",
    "phpwind.net",
    "puata.info",
    "soku.com",
    "sparenode.com",
    "supet.com",
    "tanx.com",
    "taobao.com",
    "taopiaopiao.com",
    "tbcdn.cn",
    "tburl.in",
    "teambitionapis.com",
    "teambition.com",
    "teambition.net",
    "tianchi-global.com",
    "tmail.com",
    "tmall.com",
    "tmall.hk",
    "ttpod.com",
    "tudou.com",
    "uc.cn",
    "ucweb.com",
    "um0.cn",
    "umengcloud.com",
    "umeng.co",
    "umeng.com",
    "umindex.com",
    "umsns.com",
    "umtrack.com",
    "wasu.tv",
    "whalecloud.com",
    "www.net.cn",
    "xiami.com",
    "ykimg.com",
    "youku.com",
    "youkutv.com",
    "yousuode.cn",


    "alipay.com",

    "aliloan.com",
    "alipay-cloud.com",
    "alipay.cn",
    "alipay-eco.com",
    "alipay.hk",
    "alipayobjects.com",
    "alipayplus.com",
    "ant-biz.com",
    "ant-financial.com",
    "antfin.com",
    "antfin-inc.com",
    "antfortune.com",
    "antgroup.com",
    "ant-open.com",
    "antsdaq.com",
    "ebuckler.com",
    "fund123.cn",
    "huijucai.com",
    "koubei.com",
    "mayiyunbao.com",
    "mybank.cn",
    "sinopayment.com.cn",
    "ssdata.com",
    "xin.xin",
    "yidun.com",
    "zamcs.com",
    "zhisheng.com",
    "zmxy.com.cn",

    "lazada.com",

    "lazada.co.id",
    "lazada.com.my",
    "lazada.com.ph",
    "lazada.co.th",
    "lazada.sg",
    "lazada.vn",
  ],
  ["allstate.com", "myallstate.com"],
  ["altra.org", "altraonline.org"],
  [
    "amazon.com",

    "amazon.ae",
    "amazon.ca",
    "amazon.cn",
    "amazon.co.jp",
    "amazon.com.au",
    "amazon.com.br",
    "amazon.com.mx",
    "amazon.com.sg",
    "amazon.com.tr",
    "amazon.co.uk",
    "amazon.de",
    "amazon.es",
    "amazon.fr",
    "amazon.in",
    "amazon.it",
    "amazon.nl",

    "audible.com",
    "audible.co.jp",
    "audible.com.au",
    "audible.co.uk",
    "audible.de",
    "audible.fr",
    "audible.in",
    "audible.it",

    "6pm.com",
    "acx.com",
    "amazoninspire.com",
    "aws.training",
    "brilliancepublishing.com",
    "comixology.com",
    "createspace.com",
    "dpreview.com",
    "eastdane.com",
    "fabric.com",
    "goodreads.com",
    "imdb.com",
    "pillpack.com",
    "primevideo.com",
    "shopbop.com",
    "wholefoodsmarket.com",
    "woot.com",
    "zappos.com",

    "twitch.tv",
    "ext-twitch.tv",
    "jtvnw.net",
    "ttvnw.net",

    "amazonpay.com",
    "media-amazon.com",
    "ssl-images-amazon.com",
  ],
  [
    "americanexpress.com",

    "americanexpress.ca",
    "americanexpress.ch",
    "americanexpress.com.au",
    "americanexpress.co.uk",
    "americanexpress.no",

    "membershiprewards.ca",
    "membershiprewards.com.ar",
    "membershiprewards.com.au",
    "membershiprewards.com.sg",
    "membershiprewards.co.uk",
    "membershiprewards.de",

    "aetclocator.com",
    "americanexpressfhr.com",
    "amexnetwork.com",
    "amextravel.com",
    "amextravelresources.com",
    "thecenturionlounge.com",
    "yourcarrentalclaim.com",

    "aexp-static.com",
  ],
  ["ameritrade.com", "tdameritrade.com"],
  [
    "ancestry.com",

    "ancestry.ca",
    "ancestry.com.au",
    "ancestry.co.uk",
    "ancestry.de",
    "ancestry.fr",
    "ancestry.ie",
    "ancestry.it",
    "ancestry.mx",
    "ancestry.nl",
    "ancestry.no",
    "ancestry.pl",
    "ancestry.se",

    "ancestrylibrary.com",
    "archives.com",
    "findagrave.com",
    "fold3.com",
    "newspapers.com",
    "progenealogists.com",
    "rootsweb.com",

    "ancestrylibrary.ca",

    "mfcreative.com",
    "ancestrycdn.com",
  ],
  ["androidcentral.com", "mobilenations.com"],
  [
    "apa.at",
    "apa-it.at",
    "apa-defacto.at",
    "ots.at",

    "orf.at",
    "oe24.at",
    "wienerzeitung.at",
    "kleinezeitung.at",
    "vn.at",
    "kurier.at",
    "schautv.at",
    "nachrichten.at",
    "derstandard.at",
    "sn.at",
    "volksblatt.at",
    "neue.at",

    "tt.com",
    "diepresse.com",
  ],
  ["apple.com", "icloud.com", "icloud.com.cn", "cdn-apple.com"],
  ["applefcu.org", "applefcuonline.org"],
  ["archive.org", "openlibrary.org"],
  ["asos.com", "asosservices.com"],
  [
    "atlassian.com",

    "atlassian.io",
    "atlassian.net",
    "bitbucket.org",
    "customercase.com",
    "enso.me",
    "hipchat.com",
    "jira.com",
    "statuspage.io",
    "stride.com",
    "trello.com",

    "atl-paas.net",
  ],
  [
    "att.com",

    "att.tv",
    "atttvnow.com",
    "attwatchtv.com",
    "directv.com",
    "directvnow.com",
  ],
  [
    "autodesk.com",

    "autodesk.io",
    "autodesk.net",
    "circuits.io",
    "tinkercad.com",

    "autodesk.ae",
    "autodesk.be",
    "autodesk.ca",
    "autodesk.ch",
    "autodesk.co.jp",
    "autodesk.co.kr",
    "autodesk.com.au",
    "autodesk.com.br",
    "autodesk.com.cn",
    "autodesk.com.hk",
    "autodesk.com.my",
    "autodesk.com.sg",
    "autodesk.com.tr",
    "autodesk.com.tw",
    "autodesk.co.nz",
    "autodesk.co.uk",
    "autodesk.co.za",
    "autodesk.cz",
    "autodesk.de",
    "autodesk.dk",
    "autodesk.es",
    "autodesk.eu",
    "autodesk.fi",
    "autodesk.fr",
    "autodesk.hu",
    "autodesk.in",
    "autodesk.it",
    "autodesk.mx",
    "autodesk.nl",
    "autodesk.no",
    "autodesk.pl",
    "autodesk.pt",
    "autodesk.ru",
    "autodesk.se",
  ],
  ["avito.ru", "avito.st"],
  ["avon.com", "youravon.com"],
  [
    "baidu.com",

    "hao123.com",
    "tieba.com",

    "baidustatic.com",
    "bdimg.com",
    "bdstatic.com",
  ],
  ["balsamiq.com", "balsamiq.cloud"],
  ["bancomer.com", "bancomer.com.mx", "bbvanet.com.mx"],
  ["bankofamerica.com", "bofa.com", "mbna.com", "usecfo.com"],
  ["bank-yahav.co.il", "bankhapoalim.co.il"],
  [
    "bauermedia.co.uk",

    "carmagazine.co.uk",
    "motorcyclenews.com",
    "parkers.co.uk",

    "bauersecure.com",
  ],
  ["bbc.co.uk", "bbc.com", "bbci.co.uk"],
  ["belkin.com", "seedonk.com"],
  ["bhphotovideo.com", "bandh.com", "bhphoto.com", "bnh.com"],
  ["bilibili.com", "acgvideo.com", "biliapi.net", "biliapi.com", "biligame.com", "hdslb.com"],
  ["binance.com", "binance.cloud", "binance.vision", "bnbstatic.com"],
  ["blizzard.com", "battle.net", "worldofwarcraft.com"],
  ["bloomberg.com", "bbthat.com", "bwbx.io"],
  ["boardgamearena.com", "boardgamearena.net"],
  ["booking.com", "bstatic.com"],
  ["box.com", "boxcdn.net"],
  [
    "bustle.company",

    "bustle.com",
    "elitedaily.com",
    "inputmag.com",
    "inverse.com",
    "mic.com",
    "nylon.com",
    "romper.com",
    "thezoereport.com",
  ],
  [
    "canalplus.com",

    "canal.fr",
    "canalplay.com",
    "canalplus-bo.net",
    "canal-plus.com",
    "canalplus.fr",
    "canalplusinternational.com",
    "canal-plus.net",
    "canal-plus.pro",
    "canalplus.pro",
    "canalpro.fr",
    "clique.tv",
    "cstar.fr",
    "mycanal.fr",
  ],
  ["capitalone.com", "capitalone360.com"],
  [
    "cbs.com",

    "cbsi.com",
    "cbsig.net",
    "cbsimg.net",
    "cbsinteractive.com",
    "cbsistatic.com",
    "cbslocal.com",
    "cbsnews.com",
    "cbssports.com",
    "cbsstatic.com",
    "chow.com",
    "chowhound.com",
    "chowmagazine.com",
    "chowstatic.com",
    "cnet.com",
    "cnetcontent.com",
    "cnettv.com",
    "collegesports.com",
    "com.com",
    "comicvine.com",
    "download.com",
    "etonline.com",
    "fansonly.com",
    "gamespot.com",
    "giantbomb.com",
    "insideedition.com",
    "last.fm",
    "metacritic.com",
    "news.com",
    "scout.com",
    "search.com",
    "sho.com",
    "sportsline.com",
    "techrepublic.com",
    "tv.com",
    "tvgcdn.net",
    "tvguide.com",
    "upload.com",
    "zdnet.com",
  ],
  ["cb2.com", "crateandbarrel.com"],
  [
    "ccmbenchmark.com",

    "linternaute.com",
    "journaldesfemmes.fr",
    "journaldunet.com",
    "commentcamarche.net",

    "ccmbg.com",
  ],
  ["century21.com", "21online.com"],
  ["chart.io", "chartio.com"],
  ["chaturbate.com", "highwebmedia.com"],
  ["cms.gov", "medicare.gov", "mymedicare.gov"],
  ["codepen.io", "cdpn.io"],
  ["concur.com", "concursolutions.com"],
  [
    "cornell.edu",

    "birdsna.org",
    "birdsoftheworld.com",
    "birdsoftheworld.org",
    "ebird.org",
    "hbw.com",
    "macaulaylibrary.org",
  ],
  ["cox.com", "cox.net"],
  ["cricketwireless.com", "aiowireless.com"],
  ["ctrip.com", "c-ctrip.com", "trip.com"],
  ["dcu.org", "dcu-online.org"],
  ["dictionary.com", "thesaurus.com", "sfdict.com"],
  [
    "digikey.com",

    "digikey.ae",
    "digikey.am",
    "digikey.at",
    "digikey.ba",
    "digikey.be",
    "digikey.bg",
    "digikey.bo",
    "digikey.by",
    "digikey.ca",
    "digikey.ch",
    "digikey.cl",
    "digikey.cn",
    "digikey.co.id",
    "digikey.co.il",
    "digikey.com.ar",
    "digikey.com.au",
    "digikey.com.br",
    "digikey.com.cn",
    "digikey.com.co",
    "digikey.com.cy",
    "digikey.com.eg",
    "digikey.com.gt",
    "digikey.com.hr",
    "digikey.com.jm",
    "digikey.com.lb",
    "digikey.com.mk",
    "digikey.com.mx",
    "digikey.com.pa",
    "digikey.com.tr",
    "digikey.com.ua",
    "digikey.com.uy",
    "digikey.com.ve",
    "digikey.co.nz",
    "digikey.co.th",
    "digikey.co.uk",
    "digikey.co.za",
    "digikey.cr",
    "digikey.cz",
    "digikey.de",
    "digikey.dk",
    "digikey.do",
    "digikey.ec",
    "digikey.ee",
    "digikey.es",
    "digikey.fi",
    "digikey.fr",
    "digikey.gr",
    "digikey.hk",
    "digikey.hu",
    "digikey.ie",
    "digikey.in",
    "digikey.is",
    "digikey.it",
    "digikey.jp",
    "digikey.kr",
    "digikey.lk",
    "digikey.lt",
    "digikey.lu",
    "digikey.lv",
    "digikey.ma",
    "digikey.md",
    "digikey.my",
    "digikey.nl",
    "digikey.no",
    "digikey.pe",
    "digikey.ph",
    "digikey.pk",
    "digikey.pl",
    "digikey.pr",
    "digikey.pt",
    "digikey.ro",
    "digikey.rs",
    "digikey.ru",
    "digikey.se",
    "digikey.sg",
    "digikey.si",
    "digikey.sk",
    "digikey.tn",
    "digikey.tw",
    "digikey.vn",
  ],
  [
    "digitec.ch",

    "galaxus.ch",
    "galaxus.de",
    "galaxus.fr",

    "digitecgalaxus.ch",
  ],
  [
    "directferries.com",

    "directferries.at",
    "directferries.be",
    "directferries.ca",
    "directferries.ch",
    "directferries.cn",
    "directferries.co.id",
    "directferries.co.kr",
    "directferries.com.au",
    "directferries.com.tr",
    "directferries.com.ua",
    "directferries.co.nz",
    "directferries.co.uk",
    "directferries.cz",
    "directferries.de",
    "directferries.dk",
    "directferries.es",
    "directferries.fi",
    "directferries.fr",
    "directferries.gr",
    "directferries.ie",
    "directferries.it",
    "directferries.jp",
    "directferries.kr",
    "directferries.ma",
    "directferries.nl",
    "directferries.no",
    "directferries.nz",
    "directferries.pl",
    "directferries.pt",
    "directferries.ro",
    "directferries.ru",
    "directferries.se",
    "directferries.sk",
    "directferries.xyz",
  ],
  ["discountbank.co.il", "telebank.co.il"],
  ["discord.com", "discordapp.com", "discordapp.net"],
  ["discover.com", "discovercard.com"],
  ["disqus.com", "disquscdn.com"],
  [
    "dpgmediagroup.com",

    "persgroep.net",
    "persgroep.cloud",

    "7sur7.be",
    "ad.nl",
    "bd.nl",
    "beursrally.be",
    "beurswijzer.com",
    "bndestem.nl",
    "demorgen.be",
    "destentor.nl",
    "dpgmedia.be",
    "ed.nl",
    "gelderlander.nl",
    "hln.be",
    "humo.be",
    "parool.nl",
    "persgroepinternational.be",
    "persgroepinternational.com",
    "persgroep.nl",
    "pzc.nl",
    "tijd.be",
    "topics.be",
    "topics.nl",
    "trouw.nl",
    "tubantia.nl",
    "volkskrant.nl",
  ],
  ["dropbox.com", "dropboxstatic.com", "dropboxusercontent.com", "getdropbox.com"],
  ["d.rip", "kickstarter.com"],
  [
    "ea.com",

    "bioware.com",
    "masseffect.com",
    "origin.com",
    "play4free.com",
    "tiberiumalliance.com",
  ],
  [
    "ebay.com",
    "ebayinc.com",

    "ebay.at",
    "ebay.be",
    "ebay.ca",
    "ebay.ch",
    "ebay.com.au",
    "ebay.com.hk",
    "ebay.com.my",
    "ebay.com.sg",
    "ebay.co.uk",
    "ebay.de",
    "ebay.es",
    "ebay.fr",
    "ebay.ie",
    "ebay.in",
    "ebay.it",
    "ebay.nl",
    "ebay.ph",
    "ebay.pl",
    "vivanuncios.com.mx",

    "ebaydesc.com",
    "ebayimg.com",
    "ebayrtm.com",
    "ebaystatic.com",
    "ebay-us.com",
  ],
  ["elsevier.com", "sciencedirect.com", "sciencedirectassets.com"],
  [
    "enterprise.com",

    "alamo.ca",
    "alamo.com",

    "autoshare.com",
    "autoshare.biz",
    "autoshare.ca",
    "autoshare.net",
    "autoshare.org",

    "cars.info",
    "carsharing.ca",
    "carsharingtoronto.com",
    "citer.fr",

    "ehi.com",
    "ehiaws.com",

    "enterprise.ca",
    "enterprise.ch",
    "enterprise.com.jm",
    "enterprise.co.uk",
    "enterprise.de",
    "enterprise.dk",
    "enterprise.ec",
    "enterprise.es",
    "enterprise.fr",
    "enterprise.gr",
    "enterprise.hr",
    "enterprise.hu",
    "enterprise.ie",
    "enterprise.lv",
    "enterprise.nl",
    "enterprise.no",
    "enterprise.pt",
    "enterprise.se",

    "enterprisecarclub.co.uk",
    "enterprisecarclub.ie",

    "enterprisecarshare.ca",
    "enterprisecarshare.com",
    "enterprisecarshare.co.uk",

    "enterpriserideshare.com",

    "enterpriserentacar.at",
    "enterpriserentacar.be",
    "enterpriserentacar.bg",
    "enterpriserentacar.ca",
    "enterpriserentacar.com.au",
    "enterpriserentacar.co.nz",
    "enterpriserentacar.cz",
    "enterpriserentacar.is",
    "enterpriserentacar.it",
    "enterpriserentacar.pl",
    "enterpriserentacar.se",

    "nationalcar.ca",
    "nationalcar.com",
    "nationalcar.co.uk",
    "nationalcar.de",
    "nationalcar.es",
    "nationalcar.fr",
    "nationalcar.ie",
    "nationalcar.it",
    "nationalcar.mobi",

    "onewaygo.de",

    "alamo-np.ca",
    "alamo-np.com",
    "alamo-np.co.uk",
    "alamo-np.de",
    "alamo-np.es",
    "alamo-np.fr",
    "alamo-np.ie",
  ],
  ["epicgames.com", "unrealengine.com"],
  [
    "expedia.com",

    "carrentals.com",
    "cheaptickets.com",
    "ebookers.com",
    "hotels.com",
    "hotwire.com",
    "mrjet.se",
    "orbitz.com",
    "travelocity.com",
    "wotif.com",

    "expedia-aarp.com",
    "expedia-barclays.co.uk",
    "expedia-cn.com",
    "expedia.at",
    "expedia.be",
    "expedia.ca",
    "expedia.ch",
    "expedia.cn",
    "expedia.co.id",
    "expedia.co.in",
    "expedia.co.jp",
    "expedia.co.kr",
    "expedia.co.nz",
    "expedia.co.th",
    "expedia.co.uk",
    "expedia.com.ar",
    "expedia.com.au",
    "expedia.com.br",
    "expedia.com.hk",
    "expedia.com.my",
    "expedia.com.ph",
    "expedia.com.sg",
    "expedia.com.tw",
    "expedia.com.vn",
    "expedia.de",
    "expedia.dk",
    "expedia.es",
    "expedia.fi",
    "expedia.fr",
    "expedia.ie",
    "expedia.it",
    "expedia.mx",
    "expedia.nl",
    "expedia.no",
    "expedia.ru",
    "expedia.se",
    "expediacorporate.eu",

    "expedia.net",

    "travel-assets.com",
    "trvl-media.com",

    "lastminute.com.au",
    "lastminute.co.nz",
    "wotif.com.au",
    "wotif.co.nz",

    "cdn-hotels.com",
    "hotels.cn",

    "hotwirestatic.com",

    "ebookers.at",
    "ebookers.be",
    "ebookers.ch",
    "ebookers.co.uk",
    "ebookers.de",
    "ebookers.fi",
    "ebookers.fr",
    "ebookers.ie",
    "ebookers.nl",
    "ebookers.no",

    "mrjet.dk",

    "vrbo.com",

    "abritel.fr",
    "aluguetemporada.com.br",
    "fewo-direkt.de",
    "homeaway.at",
    "homeaway.ca",
    "homeaway.com",
    "homeaway.com.au",
    "homeaway.com.mx",
    "homeaway.co.nz",
    "homeaway.co.uk",
    "homeaway.dk",
    "homeaway.es",
    "homeaway.fi",
    "homeaway.gr",
    "homeaway.it",
    "homeaway.nl",
    "homeaway.no",
    "homeaway.pl",
    "homeaway.pt",
    "homeaway.se",
    "homelidays.com",
    "homelidays.es",
    "homelidays.fr",
    "homelidays.it",
    "ownersdirect.co.uk",
    "stayz.com.au",
    "vacationrentals.com",
  ],
  ["express-scripts.com", "medcohealth.com"],
  [
    "facebook.com",

    "messenger.com",
    "workplace.com",

    "oculus.com",
    "oculuscdn.com",
    "oculusrift.com",
    "oculusvr.com",
    "powersunitedvr.com",

    "facebook.net",
    "fbcdn.com",
    "fbcdn.net",
    "fbsbx.com",
  ],
  [
    "faithlife.com",

    "biblescreen.com",
    "biblestudymagazine.com",
    "biblia.com",
    "didaktikosjournal.com",
    "faithlifetv.com",
    "kirkdalepress.com",
    "lexhampress.com",
    "logos.com",
    "ministrytracker.com",
    "proclaimonline.com",
    "verbum.com",

    "bibliacdn.com",
    "faithlifecdn.com",
    "faithlifesitescdn.com",
    "logoscdn.com",
  ],
  [
    "fandom.com",
    "fandom-dev.pl",
    "fandom-dev.us",
    "nocookie.net",
    "wikia.com",
    "wikia-dev.com",
    "wikia-dev.pl",
    "wikia-dev.us",
    "wikiafanstudio.com",
    "wikia-inc.com",
    "wikia.net",
    "wikia.org",
    "wikia-services.com",
    "wikia-staging.com",
  ],
  [
    "fastcompany.com",

    "fastcocreate.com",
    "fastcodesign.com",
    "fastcoexist.com",
    "fastcolabs.com",
    "fast-co.net",
    "fcimpactcouncil.com",
    "inc.com",
    "innovationuncensored.com",
    "mansueto.com",
    "mvdigitalmedia.com",
    "mvlicensing.com",
    "nativguard.com",
    "retirementcomm.com",

    "fastcompany.net",
  ],
  ["fastmail.com", "fastmailusercontent.com"],
  ["firefox.com", "firefoxusercontent.com", "mozilla.org"],
  ["foxnews.com", "foxbusiness.com", "fncstatic.com"],
  [
    "futureplc.com",

    "creativebloq.com",
    "cyclingnews.com",
    "digitalcameraworld.com",
    "gamesradar.com",
    "gizmodo.co.uk",
    "guitarworld.com",
    "kotaku.co.uk",
    "laptopmag.com",
    "lifehacker.co.uk",
    "livescience.com",
    "loudersound.com",
    "musicradar.com",
    "pcgamer.com",
    "space.com",
    "t3.com",
    "techradar.com",
    "tomsguide.com",
    "tomshardware.com",
    "toptenreviews.com",
    "whathifi.com",

    "futurecdn.net",
    "future-fie-assets.co.uk",
    "future-fie.co.uk",
    "future.net.uk",
  ],
  ["gamestar.de", "gamepro.de", "cgames.de"],
  [
    "gap.com",

    "bananarepublic.com",
    "gapfactory.com",
    "gapinc.com",
    "oldnavy.com",
    "piperlime.com",

    "bananarepublic.ca",
    "bananarepublic.co.jp",
    "bananarepublic.co.uk",
    "bananarepublic.eu",
    "gapcanada.ca",
    "gap.co.jp",
    "gap.co.uk",
    "gap.eu",
    "gap.hk",
    "oldnavy.ca",

    "assets-gap.com",
  ],
  [
    "gedispa.it",

    "capital.it",
    "deejay.it",
    "gelocal.it",
    "ilsecoloxix.it",
    "kataweb.it",
    "lastampa.it",
    "lescienze.it",
    "limesonline.com",
    "m2o.it",
    "mymovies.it",
    "repubblica.it",

    "gedidigital.it",
    "repstatic.it",
  ],
  [
    "gettyimages.com",

    "gettyimages.ca",
    "gettyimages.com.au",
    "gettyimages.co.uk",
    "gettyimages.dk",
    "gettyimages.fi",
    "gettyimages.nl",

    "istockphoto.com",

    "thinkstockphotos.com",
    "thinkstockphotos.ca",
  ],
  ["github.com", "githubapp.com"],
  ["gitlab.com", "gitlab-static.net"],
  [
    "gizmodo.com",

    "avclub.com",
    "deadspin.com",
    "jalopnik.com",
    "jezebel.com",
    "kinja.com",
    "kinja-img.com",
    "kinja-static.com",
    "kotaku.com",
    "lifehacker.com",
    "technoratimedia.com",
    "theinventory.com",
    "theonion.com",
    "theroot.com",
    "thetakeout.com",
  ],
  [
    "glassdoor.com",

    "glassdoor.be",
    "glassdoor.ca",
    "glassdoor.co.in",
    "glassdoor.com.au",
    "glassdoor.co.uk",
    "glassdoor.de",
    "glassdoor.fr",
    "glassdoor.ie",
    "glassdoor.nl",
  ],
  ["gogoair.com", "gogoinflight.com"],
  [
    "google.com",
    "youtube.com",
    "gmail.com",
    "blogger.com",
    "blog.google",
    "googleblog.com",
    "chromium.org",

    "ggpht.com",
    "googleusercontent.com",
    "googlevideo.com",
    "gstatic.com",
    "youtube-nocookie.com",
    "ytimg.com",

    "google.ad",
    "google.ae",
    "google.al",
    "google.am",
    "google.as",
    "google.at",
    "google.az",
    "google.ba",
    "google.be",
    "google.bf",
    "google.bg",
    "google.bi",
    "google.bj",
    "google.bs",
    "google.bt",
    "google.by",
    "google.ca",
    "google.cat",
    "google.cd",
    "google.cf",
    "google.cg",
    "google.ch",
    "google.ci",
    "google.cl",
    "google.cm",
    "google.cn",
    "google.com.af",
    "google.com.ag",
    "google.com.ai",
    "google.com.ar",
    "google.com.au",
    "google.com.bd",
    "google.com.bh",
    "google.com.bn",
    "google.com.bo",
    "google.com.br",
    "google.com.bz",
    "google.com.co",
    "google.com.cu",
    "google.com.cy",
    "google.com.do",
    "google.com.ec",
    "google.com.eg",
    "google.com.et",
    "google.com.fj",
    "google.com.gh",
    "google.com.gi",
    "google.com.gt",
    "google.com.hk",
    "google.com.jm",
    "google.com.kh",
    "google.com.kw",
    "google.com.lb",
    "google.com.ly",
    "google.com.mm",
    "google.com.mt",
    "google.com.mx",
    "google.com.my",
    "google.com.na",
    "google.com.ng",
    "google.com.ni",
    "google.com.np",
    "google.com.om",
    "google.com.pa",
    "google.com.pe",
    "google.com.pg",
    "google.com.ph",
    "google.com.pk",
    "google.com.pr",
    "google.com.py",
    "google.com.qa",
    "google.com.sa",
    "google.com.sb",
    "google.com.sg",
    "google.com.sl",
    "google.com.sv",
    "google.com.tj",
    "google.com.tr",
    "google.com.tw",
    "google.com.ua",
    "google.com.uy",
    "google.com.vc",
    "google.com.vn",
    "google.co.ao",
    "google.co.bw",
    "google.co.ck",
    "google.co.cr",
    "google.co.id",
    "google.co.il",
    "google.co.in",
    "google.co.jp",
    "google.co.ke",
    "google.co.kr",
    "google.co.ls",
    "google.co.ma",
    "google.co.mz",
    "google.co.nz",
    "google.co.th",
    "google.co.tz",
    "google.co.ug",
    "google.co.uk",
    "google.co.uz",
    "google.co.ve",
    "google.co.vi",
    "google.co.za",
    "google.co.zm",
    "google.co.zw",
    "google.cv",
    "google.cz",
    "google.de",
    "google.dj",
    "google.dk",
    "google.dm",
    "google.dz",
    "google.ee",
    "google.es",
    "google.fi",
    "google.fm",
    "google.fr",
    "google.ga",
    "google.ge",
    "google.gg",
    "google.gl",
    "google.gm",
    "google.gr",
    "google.gy",
    "google.hn",
    "google.hr",
    "google.ht",
    "google.hu",
    "google.ie",
    "google.im",
    "google.iq",
    "google.is",
    "google.it",
    "google.je",
    "google.jo",
    "google.kg",
    "google.ki",
    "google.kz",
    "google.la",
    "google.li",
    "google.lk",
    "google.lt",
    "google.lu",
    "google.lv",
    "google.md",
    "google.me",
    "google.mg",
    "google.mk",
    "google.ml",
    "google.mn",
    "google.ms",
    "google.mu",
    "google.mv",
    "google.mw",
    "google.ne",
    "google.nl",
    "google.no",
    "google.nr",
    "google.nu",
    "google.pl",
    "google.pn",
    "google.ps",
    "google.pt",
    "google.ro",
    "google.rs",
    "google.ru",
    "google.rw",
    "google.sc",
    "google.se",
    "google.sh",
    "google.si",
    "google.sk",
    "google.sm",
    "google.sn",
    "google.so",
    "google.sr",
    "google.st",
    "google.td",
    "google.tg",
    "google.tl",
    "google.tm",
    "google.tn",
    "google.to",
    "google.tt",
    "google.vg",
    "google.vu",
    "google.ws",

    "fonts.googleapis.com",
    "storage.googleapis.com",
    "www.googleapis.com",

    "nest.com",
    "nestpowerproject.withgoogle.com",
  ],
  ["www.gov.uk", "cabinet-office.gov.uk", "publishing.service.gov.uk"],
  [
    "gray.tv",

    "1011northplatte.com",
    "1011now.com",
    "13abc.com",
    "26nbc.com",
    "abc12.com",
    "blackhillsfox.com",
    "cbs7.com",
    "graydc.com",
    "kalb.com",
    "kbtx.com",
    "kcrg.com",
    "kcwy13.com",
    "kfyrtv.com",
    "kgns.tv",
    "kgwn.tv",
    "kkco11news.com",
    "kktv.com",
    "kmot.com",
    "kmvt.com",
    "knoe.com",
    "knopnews2.com",
    "kolotv.com",
    "kotatv.com",
    "kqcd.com",
    "ksfy.com",
    "ksnblocal4.com",
    "kspr.com",
    "ktuu.com",
    "kumv.com",
    "kwch.com",
    "kwqc.com",
    "kwtx.com",
    "kxii.com",
    "ky3.com",
    "nbc15.com",
    "newsplex.com",
    "thenewscenter.tv",
    "uppermichigansource.com",
    "valleynewslive.com",
    "wabi.tv",
    "wagmtv.com",
    "wbay.com",
    "wbko.com",
    "wcax.com",
    "wcjb.com",
    "wctv.tv",
    "wdbj7.com",
    "wdtv.com",
    "weau.com",
    "webcenter11.com",
    "whsv.com",
    "wibw.com",
    "wifr.com",
    "wilx.com",
    "witn.com",
    "wjhg.com",
    "wkyt.com",
    "wndu.com",
    "wowt.com",
    "wrdw.com",
    "wsaw.com",
    "wsaz.com",
    "wswg.tv",
    "wtok.com",
    "wtvy.com",
    "wvlt.tv",
    "wymt.com",

    "graytvinc.com",
  ],
  ["guardian.co.uk", "guim.co.uk", "guardianapps.co.uk", "theguardian.com", "gu-web.net"],
  [
    "habr.com",
    "habr.ru",
    "habrahabr.ru",
    "freelansim.ru",
    "geektimes.com",
    "geektimes.ru",
    "moikrug.ru",
    "toster.ru",

    "habracdn.net",
    "habrastorage.org",
    "hsto.org",
  ],
  ["healthfusion.com", "healthfusionclaims.com"],
  [
    "hearst.com",

    "25ans.jp",
    "autoweek.com",
    "bazaar.com",
    "beaumontenterprise.com",
    "bestproducts.com",
    "bicycling.com",
    "caranddriver.com",
    "chron.com",
    "cosmopolitan.com",
    "countryliving.com",
    "crfashionbook.com",
    "ctnews.com",
    "ctpost.com",
    "dariennewsonline.com",
    "delish.com",
    "drozthegoodlife.com",
    "elle.com",
    "elledecor.com",
    "esquire.com",
    "expressnews.com",
    "fairfieldcitizenonline.com",
    "foothillstrader.com",
    "fujingaho.jp",
    "gametimect.com",
    "gearpatrol.com",
    "ghsealapplication.com",
    "goodhouse.com",
    "goodhousekeeping.com",
    "greenwichtime.com",
    "harpersbazaar.com",
    "housebeautiful.com",
    "houstonchronicle.com",
    "lmtonline.com",
    "marieclaire.com",
    "menshealth.com",
    "michigansthumb.com",
    "middletownpress.com",
    "mrt.com",
    "myjournalcourier.com",
    "mylo.id",
    "myplainview.com",
    "mysanantonio.com",
    "newcanaannewsonline.com",
    "newmilfordspectrum.com",
    "newstimes.com",
    "nhregister.com",
    "oprahmag.com",
    "ourmidland.com",
    "popularmechanics.com",
    "prevention.com",
    "redbookmag.com",
    "registercitizen.com",
    "roadandtrack.com",
    "rodalesorganiclife.com",
    "runnersworld.com",
    "seattlepi.com",
    "seventeen.com",
    "sfchronicle.com",
    "sfgate.com",
    "shondaland.com",
    "stamfordadvocate.com",
    "s-w-e-e-t.com",
    "thehour.com",
    "theintelligencer.com",
    "thepioneerwoman.com",
    "thepioneerwomancooks.com",
    "thetelegraph.com",
    "timesunion.com",
    "todays-rewards.com",
    "townandcountrymag.com",
    "veranda.com",
    "wearesweet.co",
    "westport-news.com",
    "womansday.com",
    "womenshealthmag.com",
    "yourconroenews.com",

    "h-cdn.co",
    "hdmtech.net",
    "hdmtools.com",
    "hdnux.com",
    "hearst3pcc.com",
    "hearstapps.com",
    "hearstapps.net",
    "hearstdigitalstudios.com",
    "hearstdigitalstudios.net",
    "hearst.io",
    "hearstlabs.com",
    "hearstmags.com",
    "hearstmobile.com",
    "hearstnp.com",
  ],
  [
    "houzz.com",

    "houzz.at",
    "houzz.be",
    "houzz.ca",
    "houzz.ch",
    "houzz.co.jp",
    "houzz.com.au",
    "houzz.com.sg",
    "houzz.co.nz",
    "houzz.co.uk",
    "houzz.de",
    "houzz.dk",
    "houzz.es",
    "houzz.fi",
    "houzz.fr",
    "houzz.ie",
    "houzz.in",
    "houzz.it",
    "houzz.jp",
    "houzz.no",
    "houzz.nz",
    "houzz.pt",
    "houzz.ru",
    "houzz.se",
    "houzz.sg",
    "houzz.uk",

    "gardenweb.com",
    "gwhouzz3.com",
    "gwhouzz.com",
    "houzz2.com",
    "houzz2.com.au",
    "houzz2.co.uk",
    "houzz3.com",
    "houzz3.com.au",
    "houzz3.co.uk",
    "hzcdn.com",
    "stghouzz.com",
    "thathomesite.com",
  ],
  [
    "huobi.com",

    "hbfile.net",
    "hbg.com",
    "huobiasia.vip",
    "huobi.br.com",
    "huobi.me",
  ],
  ["hvfcu.org", "hvfcuonline.org"],
  [
    "idealo.de",

    "idealo.at",
    "idealo.co.uk",
    "idealo.es",
    "idealo.fr",
    "idealo.it",
    "idealo.com",
  ],
  [
    "ign.fr",

    "cartoradio.fr",
    "culture.fr",
    "duministeredelaculture.fr",
    "gouvernement.fr",
    "ignrando.fr",

    "ants.gouv.fr",
    "culture.gouv.fr",
    "data.gouv.fr",
    "education.gouv.fr",
    "etalab.gouv.fr",
    "geoportail.gouv.fr",
    "geoportail-urbanisme.gouv.fr",
    "impots.gouv.fr",
    "premier-ministre.gouv.fr",
    "service-civique.gouv.fr",
    "yvelines.gouv.fr",

    "ac-grenoble.fr",
    "ac-versailles.fr",
    "ac-bordeaux.fr",
    "ac-montpellier.fr",
    "ac-lille.fr",
  ],
  [
    "impresa.pt",

    "blitz.pt",
    "expresso.pt",
    "famashow.pt",
    "impresamediacriativa.pt",
    "sapo.pt",
    "siccaras.pt",
    "sickapa.pt",
    "sicmulher.pt",
    "sicnoticias.pt",
    "sic.pt",
    "sicradical.pt",
    "smack.pt",
    "tribunaexpresso.pt",
    "volantesic.pt",
  ],
  [
    "immobilienscout24.de",
    "static-immobilienscout24.de",
  ],
  ["independent.co.uk", "indy100.com"],
  [
    "iu.edu",

    "indiana.edu",
    "iue.edu",
    "iufw.edu",
    "iuk.edu",
    "iun.edu",
    "iupuc.edu",
    "iupui.edu",
    "iusb.edu",
    "ius.edu",
    "myiu.org",
  ],
  [
    "jd.com",
    "3.cn",
    "360buy.com",
    "360buyimg.com",
    "7fresh.com",
    "baitiao.com",
    "caiyu.com",
    "chinabank.com.cn",
    "jd.co.th",
    "jd.hk",
    "jd.id",
    "jd.ru",
    "jdpay.com",
    "jdwl.com",
    "jdx.com",
    "jkcsjd.com",
    "joybuy.com",
    "joybuy.es",
    "ocwms.com",
    "paipai.com",
    "toplife.com",
    "wangyin.com",
    "yhd.com",
    "yihaodianimg.com",
    "yiyaojd.com",
    "yizhitou.com",
  ],
  ["jpmorganchase.com", "jpmorgan.com", "chase.com"],
  ["jobware.de", "jobware.com", "jobware.net"],
  [
    "kayak.com",

    "kayak.ae",
    "kayak.cat",
    "kayak.ch",
    "kayak.cl",
    "kayak.co.id",
    "kayak.co.in",
    "kayak.co.jp",
    "kayak.co.kr",
    "kayak.com.ar",
    "kayak.com.au",
    "kayak.com.br",
    "kayak.com.co",
    "kayak.com.hk",
    "kayak.com.mx",
    "kayak.com.my",
    "kayak.com.pe",
    "kayak.com.ph",
    "kayak.com.tr",
    "kayak.co.th",
    "kayak.co.uk",
    "kayak.de",
    "kayak.dk",
    "kayak.es",
    "kayak.eu",
    "kayak.fr",
    "kayak.ie",
    "kayak.it",
    "kayak.nl",
    "kayak.no",
    "kayak.ph",
    "kayak.pl",
    "kayak.pt",
    "kayak.qa",
    "kayak.ru",
    "kayak.se",
    "kayak.sg",

    "checkfelix.com",
    "checkfelix.co.uk",
    "checkfelix.es",
    "checkfelix.fr",
    "checkfelix.it",

    "momondo.at",
    "momondo.be",
    "momondo.by",
    "momondo.ca",
    "momondo.ch",
    "momondo.cl",
    "momondo.com",
    "momondo.com.ar",
    "momondo.com.au",
    "momondo.com.br",
    "momondo.com.cn",
    "momondo.com.co",
    "momondo.com.pe",
    "momondo.com.tr",
    "momondo.co.nz",
    "momondo.co.uk",
    "momondo.co.za",
    "momondo.cz",
    "momondo.de",
    "momondo.dk",
    "momondo.ee",
    "momondo.es",
    "momondo.fi",
    "momondo.fr",
    "momondogroup.com",
    "momondo.hk",
    "momondo.ie",
    "momondo.in",
    "momondo.it",
    "momondo.kz",
    "momondo.lt",
    "momondo.mx",
    "momondo.net",
    "momondo.nl",
    "momondo.no",
    "momondo.pl",
    "momondo.pro",
    "momondo.pt",
    "momondo.ro",
    "momondo.ru",
    "momondo.se",
    "momondo.tw",
    "momondo.ua",

    "mundi.com.br",

    "speedfares.com",

    "swoodoo.at",
    "swoodoo.ch",
    "swoodoo.com",

    "r9cdn.net",
  ],
  ["kiwi.com", "skypicker.com"],
  [
    "kogan.com",

    "dicksmith.com.au",
    "dicksmith.co.nz",
    "koganinternet.com.au",
    "koganmobile.co.nz",
    "kogansuper.com.au",
    "kogantravel.com",
    "mattblatt.com.au",
    "tandy.com.au",
    "zazz.com.au",
  ],
  ["linkedin.com", "licdn.com"],
  ["livejournal.com", "livejournal.net", "lj-toys.com"],
  ["lnk.to", "tix.to", "tck.to", "ticket.to", "linkfire.com", "assetlab.io", "linkfire.co", "lnkfi.re"],
  [
    "logmeininc.com",

    "citrixonline.com",
    "gotomeeting.com",
    "gotomeet.me",
    "gotomypc.com",
    "gotostage.com",
    "gotowebinar.com",
    "logme.in",
    "logmein.com",

    "getgo.com",
  ],
  [
    "loveholidays.com",
    "loveholidays.be",
    "loveholidays.dk",
    "loveholidays.es",
    "loveholidays.fi",
    "loveholidays.fr",
    "loveholidays.ie",
    "loveholidays.nl",
    "loveholidays.no",
    "loveholidays.co.nz",
    "loveholidays.pt",
    "loveholidays.se",
    "lovevacations.com",
  ],
  ["macys.com", "macysassets.com"],
  [
    "mafra.cz",

    "idnes.cz",
    "lidovky.cz",
    "expres.cz",

    "1gr.cz",
  ],
  [
    "mail.ru",
    "imgsmail.ru",

    "ok.ru",
    "mycdn.me",
    "odnoklassniki.ru",
    "oklive.app",
    "ok.me",
    "tamtam.chat",
    "tt.me",

    "vk.com",
    "vk.me",
    "vkontakte.ru",
  ],
  ["mandtbank.com", "mtb.com"],
  ["mathletics.com", "mathletics.com.au", "mathletics.co.uk"],
  ["mdsol.com", "imedidata.com"],
  [
    "mediamarktsaturn.com",

    "mediamarkt.at",
    "mediamarkt.be",
    "mediamarkt.ch",
    "mediamarkt.com.tr",
    "mediamarkt.de",
    "mediamarkt.es",
    "mediamarkt.gr",
    "mediamarkt.hu",
    "mediamarkt.nl",
    "mediamarkt.se",

    "saturn.at",
    "saturn.de",
    "saturn.lu",

    "redblue.de",

    "mediamarkt.pl",
    "redcoon.pl",
    "saturn.pl",
    "ms-online.pl",
  ],
  ["meetup.com", "meetupstatic.com"],
  [
    "mercadolibre.com",

    "mercadolibre.cl",
    "mercadolibre.co.cr",
    "mercadolibre.com.ar",
    "mercadolibre.com.bo",
    "mercadolibre.com.co",
    "mercadolibre.com.do",
    "mercadolibre.com.ec",
    "mercadolibre.com.gt",
    "mercadolibre.com.hn",
    "mercadolibre.com.mx",
    "mercadolibre.com.ni",
    "mercadolibre.com.pa",
    "mercadolibre.com.pe",
    "mercadolibre.com.py",
    "mercadolibre.com.sv",
    "mercadolibre.com.uy",
    "mercadolibre.com.ve",
    "mercadolivre.com",
    "mercadolivre.com.br",

    "mercadopago.com",
    "mercadopago.com.ar",
    "mercadopago.com.br",
    "mercadopago.com.co",
    "mercadopago.com.mx",

    "mercadoshops.com",
    "mercadoshops.cl",
    "mercadoshops.com.ar",
    "mercadoshops.com.br",
    "mercadoshops.com.co",
    "mercadoshops.com.mx",
    "mercadoshops.com.ve",

    "mercadoclics.com",
    "mlstatic.com",
  ],
  [
    "mercedes-benz.com",

    "mercedes-benz-africa.com",
    "mercedes-benz-asia.com",
    "mercedes-benz.at",
    "mercedes-benz.ba",
    "mercedes-benz.be",
    "mercedes-benz.bg",
    "mercedes-benz.ca",
    "mercedes-benz.ch",
    "mercedes-benz.cl",
    "mercedes-benz.co.id",
    "mercedes-benz.co.in",
    "mercedes-benz.co.jp",
    "mercedes-benz.co.kr",
    "mercedes-benz.com.ar",
    "mercedes-benz.com.au",
    "mercedes-benz.com.br",
    "mercedes-benz.com.cn",
    "mercedes-benz.com.co",
    "mercedes-benz.com.cy",
    "mercedes-benz.com.eg",
    "mercedes-benz.com.gt",
    "mercedes-benz.com.hk",
    "mercedes-benz.com.lk",
    "mercedes-benz.com.mt",
    "mercedes-benz.com.mx",
    "mercedes-benz.com.my",
    "mercedes-benz.com.pe",
    "mercedes-benz.com.ph",
    "mercedes-benz.com.sg",
    "mercedes-benz.com.tr",
    "mercedes-benz.com.tt",
    "mercedes-benz.com.tw",
    "mercedes-benz.com.uy",
    "mercedes-benz.com.vn",
    "mercedes-benz.co.nz",
    "mercedes-benz.co.th",
    "mercedes-benz.co.uk",
    "mercedes-benz.co.ve",
    "mercedes-benz.co.za",
    "mercedes-benz.cz",
    "mercedes-benz.de",
    "mercedes-benz.dk",
    "mercedes-benz-eastern-europe.com",
    "mercedes-benz.ee",
    "mercedes-benz.es",
    "mercedes-benz.fi",
    "mercedes-benz.fr",
    "mercedes-benz.gr",
    "mercedes-benz.hr",
    "mercedes-benz.hu",
    "mercedes-benz.ie",
    "mercedes-benz.is",
    "mercedes-benz.it",
    "mercedes-benz.li",
    "mercedes-benz.lt",
    "mercedes-benz.lu",
    "mercedes-benz.lv",
    "mercedes-benz-mena.com",
    "mercedes-benz.nl",
    "mercedes-benz.no",
    "mercedes-benz-north-cyprus.com",
    "mercedes-benz.pl",
    "mercedes-benz.pt",
    "mercedes-benz.ro",
    "mercedes-benz.rs",
    "mercedes-benz.ru",
    "mercedes-benz.se",
    "mercedes-benz.si",
    "mercedes-benz.sk",
    "mercedes-benz.ua",
  ],
  ["mi.com", "xiaomi.com"],
  [
    "microsoft.com",

    "1drv.ms",
    "aadrm.com",
    "acompli.net",
    "adbureau.net",
    "adecn.com",
    "aka.ms",
    "aquantive.com",
    "aspnetcdn.com",
    "assets-yammer.com",
    "azure.com",
    "azureedge.net",
    "azure.net",
    "azurerms.com",
    "bing.com",
    "bing.net",
    "cloudappsecurity.com",
    "dynamics.com",
    "gamesforwindows.com",
    "getgamesmart.com",
    "gfx.ms",
    "healthvault.com",
    "hockeyapp.net",
    "hotmail.com",
    "ieaddons.com",
    "iegallery.com",
    "live.com",
    "live.net",
    "lync.com",
    "microsoftalumni.com",
    "microsoftalumni.org",
    "microsoftazuread-sso.com",
    "microsoftedgeinsiders.com",
    "microsoftonline.com",
    "microsoftonline-p.com",
    "microsoftonline-p.net",
    "microsoftstore.com",
    "microsoftstream.com",
    "msads.net",
    "msappproxy.net",
    "msauthimages.net",
    "msecnd.net",
    "msedge.net",
    "msftidentity.com",
    "msft.net",
    "msidentity.com",
    "msn.com",
    "msndirect.com",
    "msocdn.com",
    "netconversions.com",
    "o365weve.com",
    "oaspapps.com",
    "office365.com",
    "office.com",
    "officelive.com",
    "office.net",
    "olsvc.com",
    "onedrive.com",
    "onenote.com",
    "onenote.net",
    "onestore.ms",
    "onmicrosoft.com",
    "outlook.com",
    "outlookmobile.com",
    "passport.net",
    "phonefactor.net",
    "powerapps.com",
    "roiservice.com",
    "sfbassets.com",
    "sfx.ms",
    "sharepoint.com",
    "sharepoint-df.com",
    "sharept.ms",
    "skypeassets.com",
    "skype.com",
    "skypeforbusiness.com",
    "s-microsoft.com",
    "s-msn.com",
    "staffhub.ms",
    "svc.ms",
    "sway-cdn.com",
    "sway.com",
    "sway-extensions.com",
    "trafficmanager.net",
    "virtualearth.net",
    "visualstudio.com",
    "vsallin.net",
    "vsassets.io",
    "windowsazure.com",
    "windows.com",
    "windows.net",
    "windowsphone.com",
    "worldwidetelescope.org",
    "wunderlist.com",
    "xbox.com",
    "xboxlive.com",
    "yammer.com",
    "yammerusercontent.com",
  ],
  ["mobilism.org.in", "mobilism.org"],
  ["morganstanley.com", "morganstanleyclientserv.com", "stockplanconnect.com", "ms.com"],
  [
    "morningstar.com",

    "morningstar.at",
    "morningstar.be",
    "morningstarbr.com",
    "morningstar.ca",
    "morningstar.ch",
    "morningstar.cl",
    "morningstar.co.il",
    "morningstar.com.mx",
    "morningstar.co.uk",
    "morningstar.de",
    "morningstar.dk",
    "morningstar.es",
    "morningstar.fi",
    "morningstar.fr",
    "morningstarfunds.ie",
    "morningstar.it",
    "morningstar.nl",
    "morningstar.no",
    "morningstar.pt",
    "morningstar.se",
    "morningstarthailand.com",
  ],
  [
    "mtv.fi",

    "cmore.fi",
    "lumijapyry.fi",
    "luukku.com",
    "mtvuutiset.fi",
    "salatutelamat.fi",
    "studio55.fi",
    "suomiareena.fi",
  ],
  ["my-bookings.org", "my-bookings.cc"],
  [
    "myheritage.com",

    "myheritageadn.be",
    "myheritageadn.fr",
    "myheritageadn.it",
    "myheritageadn.pt",
    "myheritage.am",
    "myheritage.at",
    "myheritage.be",
    "myheritage.cat",
    "myheritage.ch",
    "myheritage.cn",
    "myheritage.co.il",
    "myheritage.co.in",
    "myheritage.co.kr",
    "myheritage.com.br",
    "myheritage.com.hr",
    "myheritage.com.pt",
    "myheritage.com.tr",
    "myheritage.com.ua",
    "myheritage.cz",
    "myheritage.de",
    "myheritage.dk",
    "myheritagedna.be",
    "myheritagedna.com",
    "myheritagedna.fr",
    "myheritagedna.it",
    "myheritagedna.pt",
    "myheritage.ee",
    "myheritage.es",
    "myheritage.fi",
    "myheritage.fr",
    "myheritage.gr",
    "myheritage.hu",
    "myheritage.it",
    "myheritage.jp",
    "myheritagelibraryedition.com",
    "myheritage.lt",
    "myheritage.lv",
    "myheritage.mk",
    "myheritage.nl",
    "myheritage.no",
    "myheritage.pl",
    "myheritage.pt",
    "myheritage.ro",
    "myheritage.rs",
    "myheritage.se",
    "myheritage.si",
    "myheritage.sk",
    "myheritage.tw",

    "dnaquest.org",
    "familygraph.com",
    "familygraphql.com",
    "familytreebuilder.com",
    "tribalquest.org",

    "mhcache.com",
    "myheritage-container.com",
    "myheritagefiles.com",
    "myheritageimages.com",
  ],
  ["mymerrill.com", "ml.com", "merrilledge.com"],
  ["mynortonaccount.com", "norton.com"],
  ["mysmartedu.com", "mysmartabc.com"],
  ["mysql.com", "oracle.com"],
  ["myuv.com", "uvvu.com"],
  [
    "nbcnews.com",

    "msnbc.com",
    "today.com",

    "newsvine.com",
    "s-nbcnews.com",
  ],
  ["nefcuonline.com", "nefcu.com"],
  [
    "netease.com",

    "126.com",
    "126.net",
    "127.net",
    "163.com",

    "icourse163.org",
    "kada.com",
    "kaola.com",
    "kaola.com.hk",
  ],
  ["netflix.com", "nflxext.com", "nflximg.net", "nflxvideo.net"],
  [
    "nettix.fi",

    "nettiauto.com",
    "nettikaravaani.com",
    "nettikone.com",
    "nettimarkkina.com",
    "nettimokki.com",
    "nettimoto.com",
    "nettivaraosa.com",
    "nettivene.com",
    "nettivuokraus.com",
  ],
  ["newegg.com", "neweggbusiness.com", "neweggimages.com", "newegg.ca"],
  [
    "newscorpaustralia.com",

    "1degree.com.au",
    "adelaidenow.com.au",
    "api.news",
    "bestrecipes.com.au",
    "bodyandsoul.com.au",
    "brisbanenews.com.au",
    "cairnspost.com.au",
    "couriermail.com.au",
    "dailytelegraph.com.au",
    "delicious.com.au",
    "escape.com.au",
    "foxsports.com.au",
    "geelongadvertiser.com.au",
    "goldcoastbulletin.com.au",
    "gq.com.au",
    "heraldsun.com.au",
    "homelife.com.au",
    "insideout.com.au",
    "kidspot.com.au",
    "nativeincolour.com.au",
    "newsadds.com.au",
    "newsapi.com.au",
    "newscdn.com.au",
    "news.com.au",
    "news.net.au",
    "newsprestigenetwork.com.au",
    "newsxtend.com.au",
    "nlm.io",
    "ntnews.com.au",
    "supercoach.com.au",
    "taste.com.au",
    "theaustralian.com.au",
    "themercury.com.au",
    "townsvillebulletin.com.au",
    "vogue.com.au",
    "weeklytimesnow.com.au",
    "whereilive.com.au",
    "whimn.com.au",
  ],
  [
    "nintendo.com",
    "nintendo.net",
    "nintendo-europe.com",
    "nintendonyc.com",

    "nintendo.at",
    "nintendo.be",
    "nintendo.ch",
    "nintendo.co.uk",
    "nintendo.co.za",
    "nintendo.de",
    "nintendo.es",
    "nintendo.eu",
    "nintendo.fr",
    "nintendo.it",
    "nintendo.nl",
    "nintendo.pt",
    "nintendo.ru",

    "animal-crossing.com",
    "smashbros.com",
    "zelda.com",
  ],
  ["norsk-tipping.no", "buypass.no"],
  [
    "npo.nl",

    "2doc.nl",
    "3fm.nl",
    "avrotros.nl",
    "bnnvara.nl",
    "brainwash.nl",
    "delagarde.nl",
    "eo.nl",
    "funx.nl",
    "human.nl",
    "jeugdjournaal.nl",
    "joop.nl",
    "kro-ncrv.nl",
    "kro.nl",
    "npo3fm.nl",
    "npo3.nl",
    "npoplus.nl",
    "nporadio1.nl",
    "nporadio2.nl",
    "nporadio4.nl",
    "nporadio5.nl",
    "npostart.nl",
    "ntr.nl",
    "omroep.nl",
    "powned.tv",
    "publiekeomroep.nl",
    "radio4.nl",
    "schooltv.nl",
    "vara.nl",
    "vpro.nl",
    "zappelin.nl",
    "zapp.nl",
  ],
  ["nymag.com", "vulture.com", "grubstreet.com", "thecut.com"],
  [
    "nypublicradio.org",

    "newsounds.org",
    "radiolab.org",
    "thegreenespace.org",
    "wnycstudios.org",
    "wqxr.org",

    "wnyc.org",
  ],
  ["nytimes.com", "newyorktimes.com", "thewirecutter.com", "nyt.com"],
  ["nyu.edu", "nyupress.org"],
  [
    "nvidia.com",

    "nvidia.at",
    "nvidia.be",
    "nvidia.ch",
    "nvidia.co.at",
    "nvidia.co.in",
    "nvidia.co.jp",
    "nvidia.co.kr",
    "nvidia.com.au",
    "nvidia.com.br",
    "nvidia.com.mx",
    "nvidia.com.pe",
    "nvidia.com.pl",
    "nvidia.com.tr",
    "nvidia.com.tw",
    "nvidia.com.ua",
    "nvidia.com.ve",
    "nvidia.co.uk",
    "nvidia.cz",
    "nvidia.de",
    "nvidia.dk",
    "nvidia.es",
    "nvidia.eu",
    "nvidia.fi",
    "nvidia.fr",
    "nvidia.in",
    "nvidia.it",
    "nvidia.jp",
    "nvidia.lu",
    "nvidia.mx",
    "nvidia.nl",
    "nvidia.no",
    "nvidia.pl",
    "nvidia.ro",
    "nvidia.ru",
    "nvidia.se",
    "nvidia.tw",

    "geforce.com",
    "geforce.cn",
    "geforce.co.uk",
  ],
  ["onlineatnsb.com", "norwaysavingsbank.com"],
  ["openstreetmap.org", "osmfoundation.org"],
  ["orange.fr", "sosh.fr", "woopic.com"],
  [
    "osf.io",

    "agrixiv.org",
    "arabixiv.org",
    "eartharxiv.org",
    "ecsarxiv.org",
    "engrxiv.org",
    "frenxiv.org",
    "marxiv.org",
    "mindrxiv.org",
    "paleorxiv.org",
    "psyarxiv.com",
    "thesiscommons.org"
  ],
  ["osu.edu", "osumc.edu", "ohio-state.edu"],
  [
    "ovh.com",

    "kimsufi.com",
    "ovhcloud.com",
    "ovhtelecom.fr",
    "soyoustart.com",

    "ovh.com.au",
    "ovh.co.uk",
    "ovh.cz",
    "ovh.de",
    "ovh.es",
    "ovh-hosting.fi",
    "ovh.ie",
    "ovh.it",
    "ovh.lt",
    "ovh.nl",
    "ovh.pl",
    "ovh.pt",
    "ovh.sn",

    "ovh.net",
  ],
  ["paypal.com", "paypal-search.com", "paypalobjects.com"],
  ["pcworld.com", "staticworld.net", "idg.com", "idg.net", "infoworld.com", "macworld.com", "techhive.com", "idg.tv"],
  [
    "pearson.com",

    "connexus.com",
    "ecollege.com",
    "english.com",
    "masteringchemistry.com",
    "masteringengineering.com",
    "masteringgeography.com",
    "masteringhealthandnutrition.com",
    "masteringphysics.com",
    "mathxl.com",
    "mathxlforschool.com",
    "mypearson.com",
    "pearsonassessments.com",
    "pearsoned.com",
    "pearsonelt.com",
    "pearsonhighered.com",
    "pearsonmylabandmastering.com",

    "pearsoncmg.com",
  ],
  ["pepco.com", "pepcoholdings.com"],
  ["philips.com", "philips.nl"],
  [
    "pinterest.com",

    "pinterest.at",
    "pinterest.be",
    "pinterest.ca",
    "pinterest.ch",
    "pinterest.cl",
    "pinterest.co",
    "pinterest.co.at",
    "pinterest.co.in",
    "pinterest.co.kr",
    "pinterest.com.au",
    "pinterest.com.bo",
    "pinterest.com.ec",
    "pinterest.com.mx",
    "pinterest.com.pe",
    "pinterest.com.py",
    "pinterest.com.uy",
    "pinterest.com.vn",
    "pinterest.co.nz",
    "pinterest.co.uk",
    "pinterest.de",
    "pinterest.dk",
    "pinterest.ec",
    "pinterest.engineering",
    "pinterest.es",
    "pinterest.fr",
    "pinterest.hu",
    "pinterest.id",
    "pinterest.ie",
    "pinterest.in",
    "pinterest.info",
    "pinterest.it",
    "pinterest.jp",
    "pinterest.kr",
    "pinterestmail.com",
    "pinterest.mx",
    "pinterest.nz",
    "pinterest.pe",
    "pinterest.ph",
    "pinterest.pt",
    "pinterest.ru",
    "pinterest.se",
    "pinterest.th",
    "pinterest.tw",
    "pinterest.uk",
    "pinterest.vn",

    "pinimg.com",
    "pin.it",
  ],
  ["plex.tv", "plex.direct"],
  ["pokemon-gl.com", "pokemon.com"],
  ["pornhub.com", "phncdn.com"],
  ["postepay.it", "poste.it"],
  ["postimees.ee", "city24.ee", "city24.lv", "pmo.ee"],
  [
    "pricerunner.com",

    "pricerunner.co.uk",
    "pricerunner.de",
    "pricerunner.dk",
    "pricerunner.net",
    "pricerunner.se",
    "pricerunner.uk",
  ],
  [
    "prosiebensat1.de",
    "prosiebensat1.com",

    "atv.at",
    "atv2.at",
    "galileo.tv",
    "kabeleins.at",
    "kabeleins.ch",
    "kabeleins.de",
    "kabeleinsdoku.at",
    "kabeleinsdoku.ch",
    "kabeleinsdoku.de",
    "prosieben.at",
    "prosieben.ch",
    "prosieben.de",
    "prosiebenmaxx.at",
    "prosiebenmaxx.ch",
    "prosiebenmaxx.de",
    "puls24.at",
    "puls4.com",
    "puls8.ch",
    "ran.de",
    "sat1.at",
    "sat1.ch",
    "sat1.de",
    "sat1gold.at",
    "sat1gold.ch",
    "sat1gold.de",
    "sixx.at",
    "sixx.ch",
    "sixx.de",
    "the-voice-of-germany.at",
    "the-voice-of-germany.ch",
    "the-voice-of-germany.de",

    "p7s1.io",
  ],
  [
    "qantas.com",

    "jetstar.com",
    "qantas.com.au",
    "qantascourier.com.au",
    "qantasfutureplanet.com.au",
    "qantasgrouptravel.com",
    "qfcrew.com",
    "qfflightcrew.com",

    "aquire.com.au",
    "qantasassure.com",
    "qantasbusinessrewards.com",
    "qantasbusinessrewards.com.au",
    "qantasepiqure.com",
    "qantasepiqure.com.au",
    "qantasgolfclub.com",
    "qantasgolfclub.com.au",
    "qantasloyalty.com",
    "qantasloyalty.net",
    "qantasmall.com",
    "qantasmall.com.au",
    "qantasmall.co.nz",
    "qantaspoints.com",
    "qantaspoints.com.au",
    "qantasshopping.com",
    "qantasshopping.com.au",
    "qantasshopping.co.nz",
    "qantasstore.com.au",
    "qantasstore.co.nz",
    "redplanetgroup.com.au",
    "redplanetportal.com.au",

    "qantascash.com",
    "qantascash.com.au",
    "qantasmoney.com",
    "qantastravelmoney.com",
  ],
  [
    "qq.com",

    "aitangyou.com",
    "cdntips.com",
    "dnspod.cn",
    "extqq.com",
    "gdtimg.com",
    "gtimg.cn",
    "gtimg.com",
    "idqqimg.com",
    "imqq.com",
    "myapp.com",
    "myqcloud.com",
    "qcloud.com",
    "qpic.cn",
    "qqmail.com",
    "qzone.com",
    "tencent.com",
    "tenpay.com",
    "ugdtimg.com",
    "url.cn",
    "wechat.com",
    "wegame.com",
    "weiyun.com",
  ],
  [
    "rai.it",

    "comunitaitalofona.org",
    "raicinema.it",
    "raicultura.it",
    "raimemo.it",
    "rainews24.it",
    "rainews.it",
    "raiplay.it",
    "raiplayradio.it",
    "raiplayyoyo.it",
    "raipubblicita.it",
    "raisport.it",
    "raitalia.it",
    "rai.tv",
    "raiway.it",
  ],
  ["railnation.ru", "railnation.de", "rail-nation.com", "railnation.gr", "railnation.us", "trucknation.de", "traviangames.com"],
  ["rakuten.com", "buy.com"],
  [
    "realestate.com.au",

    "property.com.au",
    "realcommercial.com.au",
    "spacely.com.au",

    "reastatic.net",
  ],
  ["reddit.com", "redditmedia.com", "redditstatic.com", "redd.it", "redditenhancementsuite.com", "reddituploads.com", "imgur.com"],
  ["redhat.com", "openshift.com", "openshift.org", "okd.io"],
  [
    "reebok.at",
    "reebok.be",
    "reebok.ca",
    "reebok.ch",
    "reebok.cl",
    "reebok.co",
    "reebok.com",
    "reebok.com.ar",
    "reebok.com.br",
    "reebok.com.tr",
    "reebok.co.uk",
    "reebok.cz",
    "reebok.de",
    "reebok.dk",
    "reebok.es",
    "reebok.fi",
    "reebok.fr",
    "reebok.ie",
    "reebok.it",
    "reebok.mx",
    "reebok.nl",
    "reebok.pe",
    "reebok.pl",
    "reebok.ru",
    "reebok.se",
    "reebok.sk",
  ],
  [
    "reuters.com",
    "reuters.tv",
    "reutersmedia.net",
    "thomsonreuters.com",

    "reutersagency.cn",

    "thomsonreuters.ca",
    "thomsonreuters.cn",
    "thomsonreuters.co.jp",
    "thomsonreuters.co.kr",
    "thomsonreuters.com.ar",
    "thomsonreuters.com.au",
    "thomsonreuters.com.br",
    "thomsonreuters.com.hk",
    "thomsonreuters.com.my",
    "thomsonreuters.com.pe",
    "thomsonreuters.com.sg",
    "thomsonreuters.com.tr",
    "thomsonreuters.co.uk",
    "thomsonreuters.es",
    "thomsonreuters.in",
    "thomsonreuters.ru",
  ],
  [
    "riotgames.com",

    "leagueoflegends.com",
    "lolesports.com",
    "lolstatic.com",
    "lolusercontent.com",

    "playruneterra.com",

    "riotcdn.net",
    "rdatasrv.net",
  ],
  [
    "rtl.nl",

    "bright.nl",
    "buienradar.nl",
    "healthyfest.nl",
    "rtlboulevard.nl",
    "rtllatenight.nl",
    "rtlnieuws.nl",
    "rtlxl.nl",
    "rtlz.nl",
    "videoland.com",
    "vtbl.nl",
  ],
  [
    "s-kanava.fi",

    "abcasemat.fi",
    "raflaamo.fi",
    "s-mobiili.fi",
    "sokoshotels.fi",
    "yhteishyva.fi",

    "sok.fi",
    "s-palvelut.fi",
  ],
  [
    "salesforce.com",

    "documentforce.com",
    "einstein.com",
    "force.com",
    "pardot.com",
    "salesforceliveagent.com",
    "visualforce.com",
  ],
  ["sanguosha.com", "bianfeng.com"],
  ["schwab.com", "schwabplan.com"],
  ["scmp.com", "i-scmp.com"],
  ["sears.com", "shld.net"],
  [
    "seznam.cz",

    "firmy.cz",
    "garaz.cz",
    "kupi.cz",
    "lide.cz",
    "mapy.cz",
    "novinky.cz",
    "prozeny.cz",
    "sauto.cz",
    "sbazar.cz",
    "sdovolena.cz",
    "seznamzpravy.cz",
    "sport.cz",
    "sreality.cz",
    "stream.cz",
    "super.cz",
    "sweb.cz",
    "televizeseznam.cz",
    "volnamista.cz",
    "zbozi.cz",

    "szn.cz",
  ],
  [
    "shopify.com",
    "myshopify.com",
    "shopifycdn.com",
    "shopifyapps.com",
    "shopifycloud.com",
    "shopifyadmin.com",
    "shopifypreview.com",
  ],
  ["siriusxm.com", "sirius.com"],
  ["skygo.co.nz", "skytv.co.nz"],
  ["skysports.com", "skybet.com", "skyvegas.com"],
  ["slashdot.org", "sourceforge.net", "fsdn.com"],
  ["slickdeals.net", "slickdealscdn.com"],
  [
    "smh.com.au",

    "afr.com",
    "brisbanetimes.com.au",
    "canberratimes.com.au",
    "fairfaxmedia.com.au",
    "theage.com.au",
    "watoday.com.au",

    "ffx.io",
  ],
  ["snapfish.com", "snapfish.ca"],
  [
    "sony.com",

    "sonyentertainmentnetwork.com",
    "sonyrewards.com",

    "playstation.com",
    "playstation.net",

    "sony-africa.com",
    "sony-asia.com",
    "sony.at",
    "sony.ba",
    "sony.be",
    "sony.bg",
    "sony.ca",
    "sony.ch",
    "sony.cl",
    "sony.co.cr",
    "sony.co.id",
    "sony.co.in",
    "sony.co.kr",
    "sony.com.ar",
    "sony.com.au",
    "sony.com.bo",
    "sony.com.br",
    "sony.com.co",
    "sony.com.do",
    "sony.com.ec",
    "sony.com.gt",
    "sony.com.hk",
    "sony.com.hn",
    "sony.com.mk",
    "sony.com.mx",
    "sony.com.my",
    "sony.com.ni",
    "sony.com.pa",
    "sony.com.pe",
    "sony.com.ph",
    "sony.com.sg",
    "sony.com.sv",
    "sony.com.tr",
    "sony.com.tw",
    "sony.com.vn",
    "sony.co.nz",
    "sony.co.th",
    "sony.co.uk",
    "sony.cz",
    "sony.de",
    "sony.dk",
    "sony.ee",
    "sony.es",
    "sony.eu",
    "sony-europe.com",
    "sony.fi",
    "sony.fr",
    "sony.gr",
    "sony.hr",
    "sony.hu",
    "sony.ie",
    "sony.it",
    "sony.kz",
    "sony-latin.com",
    "sonylatvija.com",
    "sony.lt",
    "sony.lu",
    "sony.lv",
    "sony-mea.com",
    "sony.nl",
    "sony.no",
    "sony.pl",
    "sony-promotion.eu",
    "sony.pt",
    "sony.ro",
    "sony.rs",
    "sony.ru",
    "sony.se",
    "sony.si",
    "sony.sk",
    "sony.ua",

    "sony.net",
  ],
  ["soundcloud.com", "sndcdn.com"],
  ["soundcu.com", "netteller.com"],
  ["southerncompany.com", "southernco.com"],
  ["southparkstudios.com", "cc.com", "comedycentral.com"],
  ["spiceworks.com", "spiceworksstatic.com"],
  [
    "spotify.com",

    "scdn.co",
    "spotifyforbrands.com",
    "spotifyforartists.com",
    "spotify.net",
  ],
  [
    "springernature.com",

    "adis.com",
    "apress.com",
    "biomedcentral.com",
    "bsl.nl",
    "dgim-eakademie.de",
    "kardiologie.org",
    "macmillaneducation.com",
    "macmillanexplorers.com",
    "medengine.com",
    "medicinematters.com",
    "medicinematters.in",
    "medwirenews.com",
    "metzlerverlag.de",
    "nature.com",
    "natureindex.com",
    "palgrave.com",
    "scientificamerican.com",
    "springer.com",
    "springeraesthetik.de",
    "springerhealthcare.com",
    "springermedizin.at",
    "springermedizin.de",
    "springeropen.com",
    "springerpflege.de",
    "springerprofessional.de",
  ],
  ["sprint.com", "sprintpcs.com", "nextel.com"],
  ["squareup.com", "cash.app", "mkt.com", "squarecdn.com"],
  ["steampowered.com", "steamstatic.com", "steamcommunity.com"],
  ["suning.com", "suning.cn", "hksuning.com"],
  ["techdata.com", "techdata.ch"],
  ["telegram.org", "telegram.me", "t.me"],
  ["telekom.com", "t-online.de"],
  ["tesla.com", "teslamotors.com"],
  [
    "toyota.com",

    "lexus.com",

    "toyota.am",
    "toyota.at",
    "toyota.az",
    "toyota.ba",
    "toyota.be",
    "toyota.bg",
    "toyota-canarias.es",
    "toyotacg.me",
    "toyota.ch",
    "toyota.co.il",
    "toyota.com.cy",
    "toyota.com.mk",
    "toyota.com.mt",
    "toyota.com.tr",
    "toyota.co.uk",
    "toyota.cz",
    "toyota.de",
    "toyota.dk",
    "toyota.ee",
    "toyota.es",
    "toyota.fi",
    "toyota.fr",
    "toyota.ge",
    "toyota-gib.com",
    "toyota.gr",
    "toyota.hr",
    "toyota.hu",
    "toyota.ie",
    "toyota.is",
    "toyota.it",
    "toyota-kosovo.com",
    "toyota.kz",
    "toyota.lt",
    "toyota.lu",
    "toyota.lv",
    "toyota.md",
    "toyota.nl",
    "toyota.no",
    "toyota.pl",
    "toyota.pt",
    "toyota.ro",
    "toyota.rs",
    "toyota.ru",
    "toyota.se",
    "toyota.si",
    "toyota.sk",
    "toyota.ua",

    "toyota-europe.com",
  ],
  [
    "tripadvisor.com",

    "tripadvisor.at",
    "tripadvisor.be",
    "tripadvisor.ca",
    "tripadvisor.ch",
    "tripadvisor.co.hu",
    "tripadvisor.co.id",
    "tripadvisor.com.ar",
    "tripadvisor.com.au",
    "tripadvisor.com.br",
    "tripadvisor.com.gr",
    "tripadvisor.com.hk",
    "tripadvisor.com.mx",
    "tripadvisor.com.my",
    "tripadvisor.com.pe",
    "tripadvisor.com.ph",
    "tripadvisor.com.sg",
    "tripadvisor.com.tr",
    "tripadvisor.com.tw",
    "tripadvisor.co.nz",
    "tripadvisor.co.uk",
    "tripadvisor.co.za",
    "tripadvisor.de",
    "tripadvisor.dk",
    "tripadvisor.es",
    "tripadvisor.fi",
    "tripadvisor.fr",
    "tripadvisor.ie",
    "tripadvisor.in",
    "tripadvisor.it",
    "tripadvisor.jp",
    "tripadvisor.nl",
    "tripadvisor.pt",
    "tripadvisor.ru",
    "tripadvisor.se",
    "tripadvisor.sk",

    "seatguru.com",

    "tacdn.com",
    "tamgrt.com",
  ],
  [
    "trivago.com",

    "trivago.ae",
    "trivago.at",
    "trivago.be",
    "trivago.bg",
    "trivago.ca",
    "trivago.ch",
    "trivago.cl",
    "trivago.co.id",
    "trivago.co.il",
    "trivago.co.kr",
    "trivago.com.ar",
    "trivago.com.au",
    "trivago.com.br",
    "trivago.com.co",
    "trivago.com.ec",
    "trivago.com.mx",
    "trivago.com.my",
    "trivago.com.ph",
    "trivago.com.tr",
    "trivago.com.tw",
    "trivago.com.uy",
    "trivago.co.nz",
    "trivago.co.th",
    "trivago.co.uk",
    "trivago.co.za",
    "trivago.cz",
    "trivago.dk",
    "trivago.es",
    "trivago.fi",
    "trivago.fr",
    "trivago.gr",
    "trivago.hk",
    "trivago.hr",
    "trivago.hu",
    "trivago.ie",
    "trivago.in",
    "trivago.it",
    "trivago.jp",
    "trivago.nl",
    "trivago.no",
    "trivago.pe",
    "trivago.pl",
    "trivago.pt",
    "trivago.ro",
    "trivago.rs",
    "trivago.ru",
    "trivago.se",
    "trivago.sg",
    "trivago.si",
    "trivago.sk",
    "trivago.vn",
    "youzhan.com",
  ],
  ["trsretire.com", "divinvest.com"],
  ["turbotax.com", "intuit.com"],
  [
    "tvn.pl",

    "player.pl",
    "tvn24bis.pl",
    "tvn24.pl",

    "cdntvn.pl",
  ],
  ["tvp.pl", "tvp.info"],
  ["twitter.com", "twimg.com", "t.co", "periscope.tv", "pscp.tv"],
  ["ua2go.com", "ual.com", "united.com", "unitedwifi.com"],
  ["ubisoft.com", "ubi.com", "anno-union.com", "thesettlers-alliance.com"],
  ["ui.com", "ubnt.com"],
  [
    "unitedhealthgroup.com",

    "myprotectwell.com",
    "protectwellapp.com",
    "protectwell.org",
    "uhg.com",
    "unitedhealthgroup.net",
    "unitedhealthgroup.org",
    "weprotectwell.com",

    "healthyourway.com",
    "healthyourwaynow.com",
    "joinatyourbest.com",
    "mypersonalizedsupport.com",
    "myrenewactive.com",
    "mywellbeingsolution.com",
    "optummessenger.co",
    "personalhealthmessagecenter.com",
    "phs.com",
    "pwrfitness.com",
    "takechargeatwork.com",
    "wellnesscoachingnow.com",

    "aarpmedicareplans.com",
    "careimprovementplus.com",
    "health4me.com",
    "healthsafe-id.com",
    "myaarpmedicare.com",
    "myaarpmedicareplans.com",
    "myaarprenew.com",
    "myaarprenewma.com",
    "myaarprenewmapd.com",
    "myaarprenewpdp.com",
    "myaarpsupplementalhealthinsurance.com",
    "mymedicamedicare.com",
    "mymedicareaccount.com",
    "mypcpmedicare.com",
    "myuhc.com",
    "myuhcdental.com",
    "myuhcmedicare.com",
    "uhc.com",
    "uhcmedicaresolutions.com",
    "uhcmycarepath.com",
    "uhcretiree.com",
    "uhcservices.com",
    "yourdentalplan.com",

    "werally.com",

    "liveandworkwell.com",
    "myoptum.com",
    "optum.com",
    "optumrx.com",
    "ppconline.info",
    "ppconlineinfo.com",
    "wellbeing-4life.com",
  ],
  ["vanguard.com", "investornews.vanguard", "vanguardblog.com", "vanguardcanada.ca", "vanguardinvestor.co.uk", "vgcontent.info"],
  [
    "verizonmedia.com",

    "verizon.com",
    "verizon.net",
    "verizonwireless.com",
    "vzw.com",

    "aol.com",
    "autoblog.com",
    "engadget.com",
    "oath.com",
    "overture.com",
    "techcrunch.com",
    "yahoo.com",

    "huffpost.com",
    "huffingtonpost.ca",
    "huffingtonpost.com",
    "huffingtonpost.com.au",
    "huffingtonpost.com.mx",
    "huffingtonpost.co.uk",
    "huffingtonpost.co.za",
    "huffingtonpost.de",
    "huffingtonpost.es",
    "huffingtonpost.fr",
    "huffingtonpost.gr",
    "huffingtonpost.in",
    "huffingtonpost.it",
    "huffingtonpost.jp",
    "huffingtonpost.kr",
    "huffpostarabi.com",
    "huffpostbrasil.com",
    "huffpostmaghreb.com",

    "yahooapis.com",
    "yimg.com",
  ],
  ["vimeo.com", "vimeocdn.com"],
  [
    "vinted.com",

    "kleiderkreisel.de",
    "mamikreisel.de",

    "vinted.co.uk",
    "vinted.cz",
    "vinted.es",
    "vinted.fr",
    "vinted.lt",
    "vinted.nl",
    "vinted.pl",
  ],
  ["volvooceanrace.com", "virtualregatta.com"],
  ["vonage.com", "vonagebusiness.com"],
  [
    "vrt.be",

    "canvas.be",
    "een.be",
    "ketnet.be",
    "klara.be",
    "mnm.be",
    "radio1.be",
    "radio2.be",
    "sporza.be",
    "stubru.be",
  ],
  ["wa.gov", "wsdot.com", "wsdot.gov"],
  ["walmart.com", "wal.co", "walmartimages.com", "walmart.ca"],
  [
    "thewaltdisneycompany.com",

    "6abc.com",
    "abc7.com",
    "abc7ny.com",
    "abc.com",
    "abcnews.com",

    "go.com",

    "espn.com",
    "espncdn.com",

    "espn.com.au",
    "espn.com.br",
    "espn.co.uk",

    "espncricinfo.com",

    "espnfc.com",
    "espnfc.us",

    "fivethirtyeight.com",

    "babble.com",
    "dadt.com",
    "disneybaby.com",
    "disneyinteractive.com",
    "disneyinternationalhd.com",
    "disneymoviesanywhere.com",
    "disneyplus.com",
    "ilm.com",
    "marvel.com",
    "readriordan.com",
    "skysound.com",
    "starwars.com",

    "disney.asia",
    "disney.be",
    "disney.bg",
    "disney.co.il",
    "disney.com",
    "disney.com.au",
    "disney.com.br",
    "disney.com.hk",
    "disney.com.tw",
    "disney.co.th",
    "disney.co.uk",
    "disney.co.za",
    "disney.cz",
    "disney.de",
    "disney.dk",
    "disney.es",
    "disney.fi",
    "disney.fr",
    "disney.gr",
    "disney.hu",
    "disney.id",
    "disney.in",
    "disney.it",
    "disneylatino.com",
    "disneyme.com",
    "disney.my",
    "disney.nl",
    "disney.no",
    "disney.ph",
    "disney.pl",
    "disney.pt",
    "disney.ro",
    "disney.se",
    "disney.sg",
    "disneyturkiye.com.tr",

    "dilcdn.com",
    "disney.io",
  ],
  [
    "wargaming.com",
    "wargaming.net",
    "worldoftanks.asia",
    "worldoftanks.com",
    "worldoftanks.eu",
    "worldoftanks.kr",
    "worldoftanks.ru",
    "worldofwarplanes.com",
    "worldofwarplanes.eu",
    "worldofwarplanes.ru",
    "worldofwarships.com",
    "worldofwarships.eu",
    "worldofwarships.ru",
    "wotblitz.com",
  ],
  [
    "warnermediagroup.com",

    "adultswim.com",
    "adventuretime.com",
    "atgamewiz.com",
    "ben10.com",
    "bleacherreport.com",
    "bleacherreportlive.com",
    "br.live",
    "brlive.com",
    "brlive.io",
    "cartoonnetwork.asia",
    "cartoonnetworkasia.com",
    "cartoonnetwork.com",
    "cartoonnetworkhotel.com",
    "cartoonnetworkpr.com",
    "catchsports.com",
    "chasingthecurelive.com",
    "cnn.com",
    "cnn.io",
    "cnnmoney.ch",
    "cnn.net",
    "d2c-ott.com",
    "d-league.com",
    "e-league.com",
    "eleague.com",
    "filmstruck.com",
    "greatbig.com",
    "greatbigstory.com",
    "hbo.com",
    "hbogo.com",
    "hbomax.com",
    "hbonow.com",
    "heaveninc.com",
    "hlntv.com",
    "iamthenight.com",
    "juniorrydercup.com",
    "maxgo.com",
    "nba.com",
    "nba.net",
    "ncaa.com",
    "ngtv.io",
    "penis-map.com",
    "pgachampionship.com",
    "pga.com",
    "pga-events.com",
    "pga.net",
    "powerpuffgirls.com",
    "powerpufftheworld.com",
    "robotunicornattack.com",
    "rydercup.com",
    "samanthabee.com",
    "sambee.com",
    "shaqtoons.com",
    "stevenuniverseselfesteem.com",
    "stevenuniversethemovie.com",
    "summercampisland.com",
    "superstation.com",
    "suspensecollection.com",
    "tbs.com",
    "tcm.com",
    "teamcococdn.com",
    "thealienist.com",
    "thesuspensecollection.com",
    "ti-platform.com",
    "tntdrama.com",
    "tnt.tv",
    "trutv.com",
    "vgtf.net",
    "warnermediacdn.com",
    "warnermediafitnation.com",
    "warnermediaready.com",
    "warnermediasupplierdiversity.com",
    "warnermediaupfront.com",
    "wbtvd.com",
    "webarebears.com",
    "wnba.com",
    "yzzerdd.com",

    "turner.com",
    "ugdturner.com",
  ],
  [
    "weather.com",
    "wunderground.com",

    "imwx.com",
    "wfxtriggers.com",
    "wsi.com",
    "w-x.co",
    "wxug.com",
  ],
  [
    "webmd.com",

    "emedicinehealth.com",
    "medicinenet.com",
    "medscape.com",
    "medscape.org",
    "onhealth.com",
    "rxlist.com",

    "medscapestatic.com",
  ],
  ["weebly.com", "editmysite.com"],
  [
    "weibo.com",

    "sina.cn",
    "sina.com",
    "sina.com.cn",
    "sinaedge.com",
    "sinaimg.cn",
    "sinaimg.com",
    "sinaimg.com.cn",
    "sinajs.cn",
    "sina.net",
    "wbimg.cn",
    "wbimg.com",
    "wcdn.cn",
    "weibocdn.com",
    "weibo.cn",
    "weibopay.com",
  ],
  ["wellsfargo.com", "wf.com"],
  ["wetter.com", "tiempo.es", "wettercomassets.com"],
  ["wikipedia.org", "wikimedia.org", "wikimediafoundation.org", "wiktionary.org",
    "wikiquote.org", "wikibooks.org", "wikisource.org", "wikinews.org",
    "wikiversity.org", "mediawiki.org", "wikidata.org", "wikivoyage.org",
    "wmfusercontent.org", "tools.wmflabs.org"],
  ["wisconsin.gov", "wi.gov"],
  ["wix.com", "wixapps.net", "wixstatic.com", "parastorage.com"],
  ["wordpress.com", "wp.com"],
  [
    "wp.pl",

    "abczdrowie.pl",
    "allani.pl",
    "autokult.pl",
    "dobreprogramy.pl",
    "domodi.pl",
    "eholiday.pl",
    "finansowysupermarket.pl",
    "fotoblogia.pl",
    "gadzetomania.pl",
    "homebook.pl",
    "jedenwniosek.pl",
    "komorkomania.pl",
    "money.pl",
    "nocowanie.pl",
    "o2.pl",
    "open.fm",
    "parenting.pl",
    "pudelek.pl",
    "pudelek.tv",
    "totalmoney.pl",
    "wakacje.pl",
    "wawalove.pl",
    "wp.tv",

    "wpcdn.pl",
    "wpimg.pl",
  ],
  ["wpcu.coop", "wpcuonline.com"],
  ["wsj.com", "wsj.net", "barrons.com", "dowjones.com", "marketwatch.com"],
  ["xda-developers.com", "xda-cdn.com"],
  ["xfinity.com", "comcast.net", "comcast.com"],
  ["xhamster.com", "xhcdn.com"],
  ["yahoo.co.jp", "yimg.jp"],
  [
    "yandex.com",

    "auto.ru",
    "beru.ru",
    "bringly.ru",
    "kinopoisk.ru",
    "mykp.ru",
    "yadi.sk",

    "yandex.net",
    "yastatic.net",

    "yandex.az",
    "yandex.by",
    "yandex.co.il",
    "yandex.com.am",
    "yandex.com.ge",
    "yandex.com.tr",
    "yandex.com.ua",
    "yandex.ee",
    "yandex.fr",
    "yandex.kg",
    "yandex.kz",
    "yandex.lt",
    "yandex.lv",
    "yandex.md",
    "yandex.ru",
    "yandex.tj",
    "yandex.tm",
    "yandex.ua",
    "yandex.uz",
    "ya.ru",
  ],
  ["zendesk.com", "zopim.com"],
  ["zhaopin.com", "zhaopin.cn"],
  ["zillow.com", "zillowstatic.com", "zillowcloud.com", "zg-api.com"],
  [
    "zoho.com",

    "zoho.com.au",
    "zoho.eu",

    "zohositescontent.com",
    "zohositescontent.com.au",
    "zohositescontent.eu",

    "manageengine.com",

    "zohocdn.com",
    "zohocorp.com",
    "zohocreator.com",
    "zohopublic.com",
    "zohostatic.com",
  ],
  ["zonealarm.com", "zonelabs.com"],
];

/**
 * Make a data structure for quick lookups of whether two domains are the same first party
 */
function makeDomainLookup(mdfpArray) {
  let out = {},
    arrLength = mdfpArray.length;
  for (let i = 0; i < arrLength; i++) {
    let inner = new Set(mdfpArray[i]);
    for (let domain of inner) {
      out[domain] = inner;
    }
  }
  return out;
}

function makeIsMultiDomainFirstParty(domainLookup) {
  return function (domain1, domain2) {
    if (domain1 in domainLookup) {
      return (domainLookup[domain1].has(domain2));
    }
    return false;
  };
}

let _domainLookup = makeDomainLookup(multiDomainFirstPartiesArray);
/**
 * Check if two domains belong to the same effective first party
 * @param {String} domain1 a base doamin
 * @param {String} domain2 a second base doamin
 *
 * @return boolean true if the domains are the same first party
 */
let isMultiDomainFirstParty = makeIsMultiDomainFirstParty(_domainLookup);
/************************************** exports */
return {
  isMultiDomainFirstParty,
  makeDomainLookup,
  makeIsMultiDomainFirstParty,
  multiDomainFirstPartiesArray,
};
})(); //require scopes
