#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

	GtkWidget *fMain, *btn;

void
show_message(GtkWidget *parent,GtkMessageType type, char* message)
{
	GtkWidget* dialog;
	
	dialog = gtk_message_dialog_new (GTK_WINDOW(parent),
					 GTK_DIALOG_DESTROY_WITH_PARENT,
					 type,
					 GTK_BUTTONS_OK,
					 message);
	g_signal_connect_swapped (G_OBJECT (dialog),
				  "response",
				  G_CALLBACK (gtk_widget_destroy),
				  G_OBJECT (dialog));
	gtk_widget_show (dialog);
}

void
on_bRecGPSD_clicked (GtkButton *button, gpointer user_data)
{
}


void
on_bRedetect_clicked (GtkButton *button, gpointer user_data)
{
	GtkWidget *parent = user_data;
	if (!GTK_IS_WINDOW(parent))
	{
		fprintf(stderr,"err parent window\n");
		return;		
	}	
		show_message(parent,GTK_MESSAGE_WARNING,"No wireless LAN cards detected.");
	
}


int
ps_do_setup()
{
	GtkWidget *dialog;
	GtkWidget *cbLogPackets;
	GtkWidget *lDelay, *sbDelay;
	GtkWidget *lWPFile, *eWPFile;	
	GtkWidget *lDumpFile, *eDumpFile;
	GtkWidget *bRecGPSD, *bRedetect;

	void
	create_setup_widgets(GtkWidget *dlgbox)
	{
		GtkWidget *table, *tw;
		
		table = gtk_table_new(6,3,FALSE);
		gtk_table_set_col_spacings(GTK_TABLE(table),3);
		gtk_table_set_row_spacings(GTK_TABLE(table),3);
		gtk_box_pack_start(GTK_BOX(dlgbox),table,TRUE,TRUE,0);
		
		tw = gtk_label_new(NULL);
		gtk_label_set_markup(GTK_LABEL(tw),"<b>Global Parameters</b>");
		gtk_misc_set_alignment(GTK_MISC(tw),0.0,0.5);
		gtk_table_attach(GTK_TABLE(table),tw,0,2,0,1,GTK_FILL,GTK_FILL,0,2);
		
		cbLogPackets = gtk_check_button_new_with_label("Log Data Packets");
		gtk_widget_set_sensitive(cbLogPackets,FALSE);
		gtk_table_attach(GTK_TABLE(table),cbLogPackets,0,2,1,2,GTK_FILL,GTK_FILL,0,0);
		
		lDelay = gtk_label_new("Slope Delay / us");
		gtk_misc_set_alignment(GTK_MISC(lDelay),0.0,0.5);
		gtk_table_attach(GTK_TABLE(table),lDelay,0,1,2,3,GTK_FILL,GTK_FILL,0,0);
		sbDelay = gtk_spin_button_new_with_range(2000,2000000,100);
		gtk_table_attach(GTK_TABLE(table),sbDelay,1,2,2,3,GTK_FILL,GTK_FILL,0,0);
		
		lWPFile = gtk_label_new("Waypoint file");
		gtk_misc_set_alignment(GTK_MISC(lWPFile),0.0,0.5);
		gtk_table_attach(GTK_TABLE(table),lWPFile,0,1,3,4,GTK_FILL,GTK_FILL,0,0);
		eWPFile = gtk_entry_new_with_max_length(255);
		gtk_table_attach(GTK_TABLE(table),eWPFile,1,2,3,4,GTK_FILL,GTK_FILL,0,0);
		
		lDumpFile = gtk_label_new("Package dump file");
		gtk_misc_set_alignment(GTK_MISC(lDumpFile),0.0,0.5);
		gtk_table_attach(GTK_TABLE(table),lDumpFile,0,1,4,5,GTK_FILL,GTK_FILL,0,0);
		eDumpFile = gtk_entry_new_with_max_length(255);
		gtk_table_attach(GTK_TABLE(table),eDumpFile,1,2,4,5,GTK_FILL,GTK_FILL,0,0);

		bRecGPSD = gtk_button_new();
		gtk_button_set_label(GTK_BUTTON(bRecGPSD),"Connect GPS");
		gtk_table_attach(GTK_TABLE(table),bRecGPSD,0,1,5,6,GTK_FILL,GTK_FILL,3,3);
		g_signal_connect(G_OBJECT(bRecGPSD),"clicked",G_CALLBACK(on_bRecGPSD_clicked),dialog);		
		bRedetect = gtk_button_new();
		gtk_button_set_label(GTK_BUTTON(bRedetect),"Find WLAN interfaces");
		gtk_table_attach(GTK_TABLE(table),bRedetect,1,2,5,6,GTK_FILL,GTK_FILL,3,3);
		g_signal_connect(G_OBJECT(bRedetect),"clicked",G_CALLBACK(on_bRedetect_clicked),dialog);		

		/* populate values */
		gtk_widget_show_all(table);
	}


	dialog = gtk_dialog_new_with_buttons("Preferences",GTK_WINDOW(fMain),
	           GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
	           GTK_STOCK_OK,
	           GTK_RESPONSE_ACCEPT,
	           GTK_STOCK_CANCEL,
	           GTK_RESPONSE_REJECT,
	           NULL);

	create_setup_widgets(GTK_DIALOG(dialog)->vbox);
	if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_ACCEPT)
	{
		/* grab values */
		gtk_widget_destroy(dialog);
		return TRUE;
	}
	else
	{		
		gtk_widget_destroy(dialog);
		return FALSE;
	}
}

int
main (int argc, char *argv[])
{

	gtk_init (&argc, &argv);
	fMain = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	btn = gtk_button_new();
	gtk_container_add(GTK_CONTAINER(fMain),btn);
	g_signal_connect(G_OBJECT(btn),"clicked",G_CALLBACK(ps_do_setup),NULL);		
	
	gtk_widget_show_all (fMain);
	gtk_main ();

	
	
	
	
	return 0;
}
