;;;; prime-fund-mode.el: Fundamental submode of PRIME mode.
;;;; $Id: prime-fund-mode.el,v 1.3 2004/03/19 17:56:09 komatsu Exp $
;;;;
;;;; Copyright (C) 2003 Hiroyuki Komatsu <komatsu@taiyaki.org>
;;;;     All rights reserved.
;;;;     This is free software with ABSOLUTELY NO WARRANTY.
;;;;
;;;; You can redistribute it and/or modify it under the terms of 
;;;; the GNU General Public License version 2.

(require 'insparens)

(defun prime-fund-mode (&optional arg)
  (setq prime-fund-mode 
	(if (null arg) (not prime-fund-mode)
	  (> (prefix-numeric-value arg) 0)))
  (if prime-fund-mode
      (prime-fund-mode-on t)
    (prime-fund-mode-off t)
    ))

(defun prime-fund-mode-on (&optional forcep)
  (if (or forcep (not prime-fund-mode))
      (progn
	(prime-input-mode-off)
	(setq prime-fund-mode t)
	)))

(defun prime-fund-mode-off (&optional forcep)
  (if (or forcep prime-fund-mode)
      (progn
	(setq prime-fund-mode nil)
	)))

;;;; ------------------------------------------------------------
;;;; $B4X?tDj5A(B
;;;; ------------------------------------------------------------
(defun prime-fund-keyin (&optional arg)
  (interactive "P")
  (if arg
      (self-insert-command (prefix-numeric-value arg))
    (prime-keyin arg)
    ))

(defun prime-fund-convert-region ()
  (interactive)
  (if (mell-transient-region-active-p)
      (prime-convert-region (region-beginning) (region-end))
    (call-interactively (mell-key-binding-next prime-fund-mode-map))
    ))

;(defun prime-fund-convert-region ()
;  (interactive)
;  (if (mell-transient-region-active-p)
;      (let ((pattern (suikyo-convert-kana-romaji
;		      (buffer-substring (region-beginning) (region-end)))))
;	(if (string-match "\\cj" pattern)
;	    (message (concat "$B:FJQ49$KBP1~$7$F$$$J$$J8;zNs$,4^$^$l$F$$$^$9(B. ("
;			     pattern ")"))
;	  (setq prime-pat pattern)
;	  (delete-region (region-beginning) (region-end))
;	  (prime-input-mode-on t)
;	  (prime-disp-input)))
;    (call-interactively (mell-key-binding-next prime-fund-mode-map))
;    ))

(defun prime-fund-undo ()
  (interactive)
  (undo)
  (if (member last-command '(prime-conv-decide prime-keyin))
      (progn
	(setq prime-pat      prime-pat-for-undo)
	(if prime-conv-mode-for-undo
	    (progn
	      (prime-conv-mode-on)
	      (setq prime-nth-cand prime-nth-cand-for-undo)
	      (prime-disp-conv))
	  (prime-input-mode-on)
	  (setq prime-nth-cand prime-nth-cand-for-undo)
	  (prime-disp-input))
	)))

;; Insertion of space.
(defun prime-fund-space ()
  "Insert a space character or convert the region again.
If the region is active, this command executes prime-convert-region,
or else insert prime-style-space."
  (interactive)
  (if (mell-transient-region-active-p)
      (prime-convert-region (region-beginning) (region-end))
    (prime-style-space-insert)
    ))

(defun prime-fund-space-alternative ()
  "Insert a alternative space character or convert the region again.
If the region is active, this command executes prime-convert-region,
or else insert prime-style-space-alternative."
  (interactive)
  (if (mell-transient-region-active-p)
      (prime-convert-region (region-beginning) (region-end))
    (prime-style-space-insert t)
    ))

;; insparens for PRIME
(defvar prime-insparens-insert-function-list
  '(prime-fund-insparens-insert-parens
    prime-fund-insparens-insert-parens-reverse)
  "List of functions dealt as prime-insparens-insert-parens functions.")

(defun prime-fund-insparens-insert-parens ()
  (interactive)
  (prime-fund-insparens-insert-parens-internal 1)
  )

(defun prime-fund-insparens-insert-parens-reverse ()
  (interactive)
  (prime-fund-insparens-insert-parens-internal -1)
  )

(defun prime-fund-insparens-insert-parens-internal (steps)
  (let ((insparens-template-list        prime-insparens-template-list)
	(insparens-insert-function-list prime-insparens-insert-function-list))
    (insparens-insert-parens-internal steps))
  )

(provide 'prime-fund-mode)
