;;;; ------------------------------------------------------------
;;;; Server $BMQ4X?t(B
;;;; ------------------------------------------------------------
;; open, close, init $B$NMQ8l$,$"$$$^$$$@$+$i(B, $B$O$C$-$j$5$;$h$&(B.

(defvar prime-server-dict-register-refine-p nil
  "non-nil $B$N>l9g(B, prime-pat $B$r=$@5$9$k(B (dabbrev $BMQ(B)")

(defcustom prime-engine-list
  '((prime-engine-prime . t))
  "$BJQ49%(%s%8%s$NM%@h=g0L$*$h$S=i4|;HMQ%U%i%0(B")

(defun prime-prepend-engine (engine &optional load-only)
  (or (assoc engine prime-engine-list)
      (progn
	(setq prime-engine-list (cons (cons engine (not load-only))
				      prime-engine-list))
	(prime-engine-init (list engine))
	)))

(defun prime-append-engine (engine &optional load-only)
  (or (assoc engine prime-engine-list)
      (progn
	(setq prime-engine-list (append prime-engine-list
					(list (cons engine (not load-only)))))
	(prime-engine-init (list engine))
	)))

(defun prime-engine-value (engine symbol &optional forcep)
  (and (or (cdr engine) forcep)
       (cdr (assoc symbol (eval (car engine))))
       ))

(defun prime-engine-id (engine)
  "Return an id property of ENGINE"
  (or (prime-engine-value engine 'id t) "")
  )

(defun prime-engine-name (engine)
  (or (prime-engine-value engine 'name t) "")
  )

(defun prime-engine-comment (engine)
  (or (prime-engine-value engine 'comment t) "")
  )

(defun prime-engine-status (engine)
  (if (prime-engine-value engine 'status)
      (funcall (prime-engine-value engine 'status))
    'none
    ))

(defun prime-engine-init (engine &optional forcep)
  (and (prime-engine-value engine 'init)
       (funcall (prime-engine-value engine 'init) forcep)
       ))

(defun prime-server-init (&optional forcep)
  (mapcar 
   (lambda (engine)
     (prime-engine-init engine forcep))
   prime-engine-list
   ))

(defun prime-engine-open (engine &optional forcep)
  (and (member (prime-engine-status engine) '(run open none))
       (prime-engine-value engine 'open)
       (funcall (prime-engine-value engine 'open) forcep)
       ))

(defun prime-server-open (&optional forcep)
  (mapcar 
   (lambda (engine)
     (prime-engine-open engine forcep))
   prime-engine-list
   ))

(defun prime-engine-close (engine &optional forcep)
  (and (member (prime-engine-status engine) '(run open none))
       (prime-engine-value engine 'close)
       (funcall (prime-engine-value engine 'close) forcep)
       ))

(defun prime-server-close (&optional forcep)
  (mapcar 
   (lambda (engine)
     (prime-engine-close engine forcep))
   prime-engine-list
   ))

(defun prime-engine-register-word (engine word pattern &optional context)
  (and (member (prime-engine-status engine) '(run open none))
       (prime-engine-value engine 'register-word)
       (funcall (prime-engine-value engine 'register-word)
		word pattern context)
       ))

(defun prime-server-dict-register-word (word pattern &optional context)
  (mapcar 
   (lambda (engine)
     (prime-engine-register-word engine word pattern context))
   prime-engine-list
   ))

(defun prime-server-select (word)
  (if prime-learn-p
      (let ((prime-server-dict-register-refine-p t))
	(prime-server-dict-register-word word prime-pat prime-context)
	)))

(defun prime-engine-dict-delete-word (engine word pattern &optional context)
  (and (member (prime-engine-status engine) '(run open none))
       (prime-engine-value engine 'delete-word)
       (funcall (prime-engine-value engine 'delete-word)
		word pattern context)
       ))

(defun prime-server-dict-delete-word (word pattern &optional context)
  (mapcar 
   (lambda (engine)
     (prime-engine-dict-delete-word engine word pattern context))
   prime-engine-list
   ))

(defun prime-engine-dict-forget-phrase (engine word context)
  (and (member (prime-engine-status engine) '(run open none))
       (prime-engine-value engine 'forget-phrase)
       (funcall (prime-engine-value engine 'forget-phrase) word context)
       ))

(defun prime-server-dict-forget-phrase (word context)
  (mapcar 
   (lambda (engine)
     (prime-engine-dict-forget-phrase engine word context))
   prime-engine-list
   ))

(defun prime-engine-exit (engine &optional forcep)
  (and (member (prime-engine-status engine) '(run open none))
       (prime-engine-value engine 'close)
       (funcall (prime-engine-value engine 'close)
		forcep)
       ))

(defun prime-server-exit (&optional forcep)
  (mapcar 
   (lambda (engine)
     (prime-engine-exit engine forcep))
   prime-engine-list
   ))

(defun prime-engine-get-cands (engine pattern &optional context)
  (and (member (prime-engine-status engine) '(run open none))
       (prime-engine-value engine 'get-cands)
       (funcall (prime-engine-value engine 'get-cands)
		pattern context)
       ))

(defun prime-server-get-label (pattern)
  ;; Only for PRIME server.
  ;; In other word, this function isn't considered other servers.
  (prime-prime-get-label pattern))

(defun prime-server-get-env (key)
  ;; Only for PRIME server.
  ;; In other word, this function isn't considered other servers.
  (prime-engine-get-env (assoc 'prime-engine-prime prime-engine-list) key))
;   (mapcar 
;    (lambda (engine)
;      (cons engine
; 	   (prime-engine-get-env engine key)))
;    prime-engine-list
;    ))

(defun prime-engine-get-env (engine key)
  (and (member (prime-engine-status engine) '(run open none))
       (prime-engine-value engine 'get-env)
       (funcall (prime-engine-value engine 'get-env) key)
       ))

(defun prime-server-search (pattern &optional context)
  (catch 'searching
    (mell-list-uniq
     (apply 'append
	    (mapcar 
	     (lambda (engine)
	       ;; $B<!$NJ8;z$,F~NO$5$l$F$$$?$i8!:w$rCfCG$9$k(B
	       (and (mell-event-pending-command-p '(prime-keyin))
		    (throw 'searching nil))
	       (prime-engine-get-cands engine pattern context))
	     prime-engine-list
	     )))))

(provide 'prime-engine)

(require 'prime-process)
;; $BJQ49%(%s%8%s$NFI$_9~$_(B ($B$b$&>/$7%9%^!<%H$JJ}K!$K$7$h$&(B)
(require 'prime-engine-prime    nil t)

(require 'prime-engine-mode nil t)

