//
//  MyDocument.m
//  PRICE
//
//  Created by Riccardo Mottola on Thu Dec 12 2002.
//  Copyright (c) 2003 Carduus. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it under the terms of the version 2 of the GNU General Public License as published by the Free Software Foundation.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import "MyDocument.h"

@implementation MyDocument

// eliminated windowNibName since we use makeWindowControllers


- (void)windowControllerDidLoadNib:(NSWindowController *) aController
{
    [super windowControllerDidLoadNib:aController];
    // Add any code here that need to be executed once the windowController has loaded the document's window.
}

- (NSData *)dataRepresentationOfType:(NSString *)aType
{
    // Insert code here to write your document from the given data.  You can also choose to override -fileWrapperRepresentationOfType: or -writeToFile:ofType: instead.
//    return nil;
    return [activeImage TIFFRepresentation];
}

- (BOOL)loadDataRepresentation:(NSData *)data ofType:(NSString *)aType
{
    // Insert code here to read your document from the given data.  You can also choose to override -loadFileWrapperRepresentation:ofType: or -readFromFile:ofType: instead.
    activeImage = [[NSImage alloc] initWithData:data];
    if (activeImage)
    {
        NSBitmapImageRep *actImageRep;
        NSImage *newImage;
        NSBitmapImageRep *newImageRep;
        unsigned char *dataPtr;
        unsigned char *dataPtr2;
        unsigned int k;
        unsigned int w, h, s;
        
//        actImageRep = [NSBitmapImageRep imageRepWithData:[activeImage TIFFRepresentation]];
        actImageRep = [[activeImage representations] objectAtIndex: 0];
        if ([[actImageRep colorSpaceName] isEqualToString: NSCalibratedBlackColorSpace] || [[actImageRep colorSpaceName] isEqualToString: NSDeviceBlackColorSpace])
        {
            NSLog(@"Converting color space...");
            w = [actImageRep pixelsWide];
            h = [actImageRep pixelsHigh];
            newImage = [[NSImage alloc] initWithSize:NSMakeSize(w, h)];
            newImageRep = [[[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:1
                    hasAlpha:NO
                    isPlanar:NO
                    colorSpaceName:NSCalibratedWhiteColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0]
                autorelease];
            s = w * h;
            dataPtr = [actImageRep bitmapData];
            dataPtr2 = [newImageRep bitmapData];
            for (k = 0; k < s; k++)
                *dataPtr2++ = UCHAR_MAX - *dataPtr++;
            [newImageRep setColorSpaceName:NSCalibratedWhiteColorSpace];
            [newImage addRepresentation:newImageRep];
            [newImageRep release];
            [activeImage release];
            activeImage = newImage;
        }
    }
    return (activeImage != nil); /* returns nil to be able to know if loading was successul */
}


- (IBAction)saveDocumentAs:(id)sender
/* we override the super class to change the extensionand type of the file */
{
    NSString *filepath;
    
    filepath = [self fileName];
    filepath = [[filepath stringByDeletingPathExtension] stringByAppendingString: @".tiff"];
    [self setFileName:filepath];
    [self setFileType: @"tiff"];
    [super saveDocumentAs: sender];
}

- (void)makeWindowControllers
/* instantiate PRWindowController */
{
    windowController = [[PRWindowController alloc] initWithWindowNibName:@"PRWindow"];
    [self addWindowController:windowController];
    [windowController release];
}

- (NSImage *)activeImage
/* method to access the active image */
{
    return activeImage;
}

- (void)makeGrayscale:(id)sender
{
    PRGrayscaleFilter *filter = [[PRGrayscaleFilter alloc] init];
    [activeImage autorelease];
    activeImage = [[filter filterImage:activeImage] retain];
    NSLog (@"done greyscale converting");
    [windowController setImageToDraw:activeImage];
    [filter release];
}

- (void)makeConvolve55:(int[5][5])mat: (int)offset :(float)scale :(BOOL)autoScale
{
    PRConvolve55 *conv;
    
    /* some trace */
    NSLog(@"inside %@.%@ - first", [self className], NSStringFromSelector(_cmd));
    
    conv = [[PRConvolve55 alloc] init];
    [activeImage autorelease];

    /* some trace */
    NSLog(@"inside %@.%@ - after autorelease", [self className], NSStringFromSelector(_cmd));
    
    activeImage = [[conv convolveImage:activeImage :mat :offset :scale :autoScale] retain];
    [windowController setImageToDraw:activeImage];
    [conv release];
}

- (void)makeDFT:(id)sender
{
    PRFourier *fourier = [[PRFourier alloc] init];
    [activeImage autorelease];
    activeImage = [[fourier transformImage:activeImage] retain];
    [windowController setImageToDraw:activeImage];
    [fourier release];
}

- (void)makeDFTLowPass :(BOOL)autoRange :(float) bandPassFreq :(float) bandStopFreq
{
    PRDFTLowPass *dftLP;
    
    dftLP = [[PRDFTLowPass alloc] init];
    [activeImage autorelease];
    
    activeImage = [[dftLP transformImage:activeImage :autoRange :bandPassFreq :bandStopFreq] retain];
    [windowController setImageToDraw:activeImage];
    [dftLP release];
}

- (void)makeDFTHighPass :(BOOL)autoRange :(float) bandPassFreq :(float) bandStopFreq
{
    PRDFTHighPass *dftHP;
    
    dftHP = [[PRDFTHighPass alloc] init];
    [activeImage autorelease];
    
    activeImage = [[dftHP transformImage:activeImage :autoRange :bandPassFreq :bandStopFreq] retain];
    [windowController setImageToDraw:activeImage];
    [dftHP release];
}

- (void)makeTransposed:(id)sender
{
    PRTransforms *tr = [[PRTransforms alloc] init];
    [activeImage autorelease];
    activeImage = [[tr transposeImage:activeImage] retain];
    [windowController setImageToDraw:activeImage];
    [tr release];
//    [[windowController view] setNeedsDisplay:YES];
}

- (void)makeRotated90 :(id)sender
{
    PRTransforms *tr = [[PRTransforms alloc] init];
    [activeImage autorelease];
    activeImage = [[tr rotateImage90:activeImage] retain];
    [windowController setImageToDraw:activeImage];
    [tr release];
}

- (void)makeRotated180 :(id)sender
{
    PRTransforms *tr = [[PRTransforms alloc] init];
    [activeImage autorelease];
    activeImage = [[tr rotateImage180:activeImage] retain];
    [windowController setImageToDraw:activeImage];
    [tr release];
}

- (void)makeRotated270 :(id)sender
{
    PRTransforms *tr = [[PRTransforms alloc] init];
    [activeImage autorelease];
    activeImage = [[tr rotateImage270:activeImage] retain];
    [windowController setImageToDraw:activeImage];
    [tr release];
}

- (void)makeFlippedVert :(id)sender
{
    PRTransforms *tr = [[PRTransforms alloc] init];
    [activeImage autorelease];
    activeImage = [[tr flipImageVert:activeImage] retain];
    [windowController setImageToDraw:activeImage];
    [tr release];
}

- (void)makeFlippedHoriz :(id)sender
{
    PRTransforms *tr = [[PRTransforms alloc] init];
    [activeImage autorelease];
    activeImage = [[tr flipImageHoriz:activeImage] retain];
    [windowController setImageToDraw:activeImage];
    [tr release];
}

- (void)makeEqualization :(id)sender
{
    PREqualize *equal;
    /* some trace */
    NSLog(@"inside %@.%@", [self className], NSStringFromSelector(_cmd));
    
    equal = [[PREqualize alloc] init];
    [activeImage autorelease];
    
    activeImage = [[equal equalizeImage:activeImage] retain];
    [windowController setImageToDraw:activeImage];
    [equal release];
}

- (void)makeTraceEdges :(int)filterType :(BOOL)useTh :(float)thLev :(BOOL)doZeroC
{
    PRTraceEdges *traceEdges;
    /* some trace */
    NSLog(@"inside %@.%@", [self className], NSStringFromSelector(_cmd));
    
    traceEdges = [[PRTraceEdges alloc] init];
    [activeImage autorelease];
    
    activeImage = [[traceEdges edgeImage :activeImage :filterType :useTh :thLev :doZeroC] retain];
    [windowController setImageToDraw:activeImage];
    [traceEdges release];
}

- (void)makeCustTraceEdges
{
    PRCustTraceEdges *traceEdges;
    /* some trace */
    NSLog(@"inside %@.%@", [self className], NSStringFromSelector(_cmd));
    
    traceEdges = [[PRCustTraceEdges alloc] init];
    [activeImage autorelease];
    
    activeImage = [[traceEdges edgeImage :activeImage] retain];
    [windowController setImageToDraw:activeImage];
    [traceEdges release];
}

-(void)makeMedian :(enum medianForms)form :(int)size :(BOOL)sep
{
    PRMedian *median;
    median = [[PRMedian alloc] init];
    [activeImage autorelease];
    
    activeImage = [[median medianImage :activeImage :form :size :sep] retain];
    [windowController setImageToDraw:activeImage];
    [median release];
}

- (void) dealloc
{
    NSLog(@"Should dealloc NSDocument!!!");
    [activeImage release];
    [super dealloc];
}

@end
