//
//  PRCEqualize.m
//  PRICE
//  Image Equalization Controller
//
//  Created by Riccardo Mottola on Fri Dec 05 2003.
//  Copyright (c) 2003 Carduus. All rights reserved.
//
// This application is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import "PRCEqualize.h"
#import "PREqualize.h"
#import "MyDocument.h"

@implementation PRCEqualize

- (IBAction)showEqualize:(id)sender
{
    if (!equalWindow)
        [NSBundle loadNibNamed:@"Equalize" owner:self];
    [equalWindow makeKeyAndOrderFront:nil];
}

- (IBAction)equalizeOK:(id)sender
{
    int index;
    int space;
    
    index = [colorSpaceChoice indexOfSelectedItem];
    if (index == 0)
        space = COLOR_SPACE_RGB;
    else if (index == 1)
        space = COLOR_SPACE_YUV;

    [[[NSDocumentController sharedDocumentController] currentDocument] makeEqualization :space :nil];
    if ([[NSApp delegate] prefClosePanels])
        [equalWindow performClose:nil];
}

- (IBAction)equalizeCancel:(id)sender
{
    [equalWindow performClose:nil];
}

@end
