Summary: Adaptive readahead daemon
Name: preload
Version: 0.2
Release: 1
License: GPL
Group: System Environment/Daemons
Source: http://prdownloads.sourceforge.net/preload/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root
URL: http://preload.sourceforge.net/
Prereq: /sbin/chkconfig, /sbin/service


%description
preload is an adaptive readahead daemon that prefetches files mapped by
applications from the disk to reduce application startup time.


%prep
%setup -q


%build
%configure
make


%install
rm -rf $RPM_BUILD_ROOT
%makeinstall


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root)
%doc README AUTHORS COPYING ChangeLog TODO THANKS NEWS
%doc doc/*.txt
%{_sbindir}/preload
%config %{_sysconfdir}/preload.conf
%{_datadir}/man/man8/preload.8.gz
%config %{_sysconfdir}/sysconfig/preload
%attr(0755,root,root) %{_sysconfdir}/rc.d/init.d/preload
%attr(0644,root,root) %{_sysconfdir}/logrotate.d/preload
%attr(0600,root,root) %verify(not md5 size mtime) %config(missingok,noreplace) %{_localstatedir}/log/preload.log
%attr(0660,root,root) %dir %{_localstatedir}/preload
%attr(0660,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) %{_localstatedir}/preload/preload.state


%post
/sbin/chkconfig --add preload

%preun
if [ "$1" = "0" ]; then
	/sbin/service preload stop >/dev/null 2>&1
	/sbin/chkconfig --del preload
fi

%postun
if [ "$1" -ge "1" ]; then
	/sbin/service preload condrestart >/dev/null 2>&1
fi

%changelog

* Tue Aug 23 2005  Behdad Esfahbod <behdad@gnu.org>
  - initial edition, copied from acpid.spec

