#
#
#
#

set bent_proc(get)		bent:get
set bent_proc(delete)		bent:delete
set bent_proc(index)		bent:index
set bent_proc(insert)		bent:insert
set bent_proc(subwidget)	bent:subwidget

Widget:DefineClass ButtonEntry {} bent:create bent:config bent_proc

proc bent:create {w a} {
    entry $w.entry
    button $w.button -padx 0 -pady 0 -takefocus 0 -highlightthickness 0

    bent:set_state $w normal

    pack $w.entry -side left -fill x -expand yes
    pack $w.button -side left

    return $w
}

proc bent:set_state {w state} {
    switch $state {
	disabled {
	    set entry_state disabled
	    set button_state disabled
	    set mouse_action {}
	}
	readonly -
	buttononly {
	    set entry_state readonly
	    set button_state normal
	    set mouse_action [list $w.button invoke]
	}
	normal -
	editable -
	default {
	    set entry_state normal
	    set button_state normal
	    set mouse_action {}
	}
    }
    Widget:SetEntryState $w.entry $entry_state
    $w.button configure -state $button_state
    bind $w.entry <ButtonRelease-1> $mouse_action
}

proc bent:config {w opt val} {
    global bent_conf

    switch -- $opt {
	-width {
	    $w.entry configure -width $val
	}
	-height {
	    $w.entry configure -width $val
	}
	-variable {
	    $w.entry configure -textvariable $val
	}
	-buttonimage {
	    $w.button configure -image $val
	}
	-buttontext {
	    $w.button configure -text $val
	}
	-buttoncommand {
	    $w.button configure -command $val
	}
	-state {
	    bent:set_state $w $val
	}
	default {
	    return 1
	}
    }
    return 0
}

proc bent:get {w a} {
    $w.entry get
}

proc bent:delete {w a} {
    eval $w.entry delete $a
}

proc bent:index {w a} {
    eval $w.entry insert $a
}

proc bent:insert {w a} {
    eval $w.entry insert $a
}

proc bent:subwidget {w a} {
    switch [shift a] {
	entry {return $w.entry}
	button {return $w.button}
	default {return ""}
    }
}
