/***************************************************************************
 *                                                                         *
 *                         Powersave Daemon                                *
 *                                                                         *
 *          Copyright (C) 2004,2005 SUSE Linux Products GmbH               *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at you   *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA                  *
 *                                                                         *
 ***************************************************************************/

#include "config.h"
#include <fcntl.h>
#include <sys/ioctl.h>
#include <dirent.h>

#include <unistd.h>
#include <stdlib.h>

#include "powerlib_local.h"
#include "powerlib.h"
#include "errno.h"

#define ACPI_FAN_DIR "/proc/acpi/fan"

int getFanNum()
{
	/* differ between several kernel implementations (where is the proc entry) here */
	return getDevicesNum(ACPI_FAN_DIR);
}

int getFanStatus(const int device_num)
{
	char file[MAX_FILE_PATH + 1] = "";
	char value[MAX_LINE_SIZE + 1] = "";
	char def[MAX_LINE_SIZE + 1] = "";
	DIR *dir;
	struct dirent *dirent;
	FILE *rdFile;
	int dir_count = 0;
	int ret_val;

	if (checkACPI() != ACPI) {
		pDebug(DBG_INFO, "no ACPI system => no fan control");
		return NO_ACPI_ERROR;
	}

	/* check whether module has been loaded and device is available */
	ret_val = check_ACPI_dir(ACPI_FAN_DIR);
	if (ret_val < 0)
		/* returns either NO_DEVICE_ERROR or NO_MODULE_ERROR */
		return ret_val;

	dir = opendir(ACPI_FAN_DIR);
	/* jump no of times in getting a new valid directory */
	/* expect that dirent will always give back the same order of files(directories) */
	while (1) {
		dirent = readdir(dir);
		if (dirent <= 0) {
			closedir(dir);
			return -3;
		}
		if (dirent->d_name[0] == '.')
			continue;	/* skip dotfiles */
		if (dir_count == device_num)
			break;
		dir_count++;
	}
	snprintf(file, MAX_FILE_PATH, "%s/%s/state", ACPI_FAN_DIR, dirent->d_name);
	rdFile = fopen(file, "r");
	if (!rdFile)
		ret_val = -4;
	else {
		int ret = getColonValue(rdFile, value, sizeof(value), def, sizeof(def));
		fclose(rdFile);
		if (ret < 0)
			ret_val = -5;
		else {
			if (!memcmp(value, "on", 2))
				ret_val = 0;
			else if (!memcmp(value, "off", 3))
				ret_val = 1;
			else
				ret_val = -5;
		}
	}
	closedir(dir);
	return ret_val;
}
