/***************************************************************************
 *                                                                         *
 *                         Powersave Daemon                                *
 *                                                                         *
 *          Copyright (C) 2004,2005,2006 SUSE Linux Products GmbH          *
 *                                                                         *
 *               Author(s): Holger Macht <hmacht@suse.de>                  *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at you   *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA                  *
 *                                                                         *
 ***************************************************************************/

#include "clientConnection.h"
#include "powerlib.h"

using namespace std;

ClientConnection::~ClientConnection()
{
	_clients.clear();
}

bool ClientConnection::addClient(const char *name, int capabilities)
{
	cNode client;

	/* unique name of the client */
	client.name = name;

	client.capabilities = capabilities;

	// add the client to the list
	_clients.push_back(client);

	return true;
}

bool ClientConnection::checkClientRemoval(const char *name)
{
	for (list < cNode >::iterator i = _clients.begin(); i != _clients.end(); ++i) {

		if (i->name == name) {
			_clients.erase(i);
			pDebug(DBG_INFO, "Removed client %s", name);
			return true;
		}
	}

	return false;
}

bool ClientConnection::checkClientCapabilities(int capability)
{
	for (list < cNode >::iterator i = _clients.begin(); i != _clients.end(); ++i) {

		if (i->capabilities & capability) {
			return true;
		}
	}

	return false;
}

int ClientConnection::count()
{
	//return how much clients are connected
	return _clients.size();
}

void ClientConnection::getClients(std::list< std::string > &names,
				  std::list< int > &caps)
{
	for (list < cNode >::iterator i = _clients.begin(); i != _clients.end(); ++i) {
		names.push_back(i->name);
		caps.push_back(i->capabilities);
	}
}
