#ifndef INCLUDE_INIT_H
#define INCLUDE_INIT_H
/* ----------------------------------------------------------------------------
 * init.h
 * prototypes and definitions for init.c.
 *
 * Copyright 2002 Matthias Grimm (joker@cymes.de).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#define TAGBUFFERLEN	2048
#define TAGBUFFERINCR	512
#define TAGBUFFERMAX	16384
#define MAXINPUTS	8

#ifdef HAVE_OLDLIBPBB
#  define E_NOMEM	23     /* support for older libpbb.a */
#endif

/* short options for optarg */
#define ARG_ALL		"hv"
#define ARG_HELP	'h'	/* no arg */
#define ARG_VERSION	'v'	/* no arg */

#define BITS_PER_LONG (sizeof(long) * 8)
#define NBITS(x) ((((x)-1)/BITS_PER_LONG)+1)
#define OFF(x) ((x)%BITS_PER_LONG)
#define LONG(x) ((x)/BITS_PER_LONG)
#define test_bit(bit, array) ((array[LONG(bit)] >> OFF(bit)) & 1)

struct powerprofile_flags {
  unsigned int sleep:1;
  unsigned int dim:1;
  unsigned int coversleep:1;
  unsigned int :0;
};

struct powerprofile {
  struct powerprofile_flags flags;
  unsigned int Tsleep;
  unsigned int Tdim;
  unsigned int Thdoff;
};

struct basedata {
	GtkWidget *mainwindow;		/* GtkWidget of main window */
	int winpos_x;
	int winpos_y;
	GtkWidget *learnwindow;      /* small popup during key learning */
	struct tagitem *taglist;      /* pointer to taglist buffer */
	char *strptr;				     /* pointer to string area in that buffer */
	int	bufferlen;		 		      /* length of tag & stringbuffer */
	struct GUIControlItem *GUIControl; /* tab to easily control the GUI */
	int GUIControlCount;
	struct {
		int fd;
		int gdktag;
	} kbds[MAXINPUTS+1];   /* handles for additional input streams */
	struct {
		unsigned int learn_activated:1;
		unsigned int learn_in_progress:1;
		unsigned int shift:1;
		unsigned int ctrl:1;
		unsigned int alt:1;
		unsigned int :0;
	} flags;
	GtkWidget *learnbutton;  /* learn buttons that triggered learn mode */
	GtkWidget *learnentry;   /* text entry to write the key definition to */
	struct powerprofile ac;
	struct powerprofile battery;
	struct powerprofile *profile;
};

/* flag definitions for  GUIControlItem and GTItem */
#define GCF_RONLY	1<<0      /* read only */
#define GCF_ROOT	1<<1      /* only accesible by root */
#define GCF_LEARN   1<<2      /* learn button */

struct GUIControlItem {
	long tag;
	GtkWidget *widget;
	GtkWidget *linked;
	long (*handler) ();
	int flags;
};

struct GTItem {
  long tag;
  char *widgetname;
  char *linkedname;
  long (*handler)();
  int  flags;
};

/* prototypes */
int init_powerprefs(struct basedata *base);
void exit_powerprefs(struct basedata *base);
void signalhandler (int signum);
int install_sighandler();
int evaluate_args(int argc, char *argv[]);
int init_guicontrol (struct basedata *base);
void gui_finetuning (struct basedata *base);
int collect_kbd_devices(struct basedata *base);
GtkWidget *create_learnwindow();

#endif    /* INCLUDE_INIT_H */
