/* ----------------------------------------------------------------------------
 * callbacks.c
 * funtions that are called by the GTK GUI
 *
 * Copyright 2002 Matthias Grimm (joker@cymes.de).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <gtk/gtk.h>
#include <linux/input.h>

#include <pbb.h>

#include "init.h"
#include "callbacks.h"
#include "taghandler.h"
#include "msghandler.h"
#include "gettext_macros.h"

extern struct basedata masterdata;

void
cb_apply_clicked (GtkWidget *window, gpointer user_data)
{
	set_server_config((struct basedata *) user_data);
}

void
cb_save_clicked (GtkWidget *window, gpointer user_data)
{
	set_server_config((struct basedata *) user_data);
	singletag_to_server (CHANGEVALUE, TAG_SAVECONFIG, 0);
}

void
cb_reset_clicked (GtkButton *button, gpointer user_data)
{
	get_server_config((struct basedata *) user_data);
}

void
cb_hidewidget (GtkWidget *widget, gpointer user_data)
{
	gboolean state;

	state = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(user_data));
	gtk_widget_set_sensitive (widget, state);
}

void
cb_profile_changed (GtkWidget *window, gpointer user_data)
{
	struct basedata *base = (struct basedata*) &masterdata;

	if (strcasecmp(gtk_entry_get_text (GTK_ENTRY (user_data)), _("AC")) == 0)
		base->profile = &base->ac;
	else
		base->profile = &base->battery;
	update_profile_gui();
}

void
cb_update_profile (GtkWidget *widget, gpointer user_data)
{
	struct basedata *base = (struct basedata*) &masterdata;
	int val, action = (int) user_data;

	switch (action) {
	case 0:
	case 2:
		val = th_radiobutton (THMODE_GET, 0, widget, 0);
		break;
	case 1:
		val = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget));
		break;
	case 3:
	case 4:
	case 5:
		val = (int) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(widget));
		break;
	}

	switch (action) {
		case 0:	base->profile->flags.sleep      = (!val) & 1; break;
		case 1:	base->profile->flags.dim        = val;        break;
		case 2:	base->profile->flags.coversleep = (!val) & 1; break;
		case 3: base->profile->Tsleep           = val;        break;
		case 4: base->profile->Tdim             = val;        break;
		case 5: base->profile->Thdoff           = val;        break;
	}
}

void
cb_start_learn (GtkWidget *widget, struct basedata *base)
{
	int n;

	if ((gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget))) == TRUE)
		for (n=0; n < base->GUIControlCount; n++)
			if (base->GUIControl[n].widget == widget) {
				base->learnbutton = widget;
				base->learnentry = base->GUIControl[n].linked;
				base->flags.learn_in_progress = 1;
				gtk_widget_show (base->learnwindow);
			}
}

gboolean
cb_mainwindow_moved (GtkWidget *widget, GdkEventConfigure *event, struct basedata *base)
{
	int difx, dify, learn_x, learn_y;

	difx = event->x - base->winpos_x;
	dify = event->y - base->winpos_y;

	if (base->learnwindow)
		if (GTK_WIDGET_VISIBLE(base->learnwindow)) {
			gtk_window_get_position (GTK_WINDOW(base->learnwindow), &learn_x, &learn_y);
			gtk_window_move (GTK_WINDOW(base->learnwindow), learn_x + difx, learn_y + dify);
		}

	base->winpos_x = event->x;
	base->winpos_y = event->y;
	return 0;
}

void
cb_learnwindow_show (GtkWidget *widget, struct basedata *base)
{
	int parent_x, parent_y, child_x, child_y;

	gtk_window_get_position (GTK_WINDOW(base->mainwindow), &parent_x, &parent_y);
	gtk_window_get_position (GTK_WINDOW(base->learnwindow), &child_x, &child_y);
	gtk_window_move (GTK_WINDOW(base->learnwindow), child_x, parent_y + 25);
}

void
cb_keyboard_handler (struct basedata *base, int fd, GdkInputCondition ic)
{
	struct input_event inp;
	int code, mod;

	if (read(fd, &inp, sizeof(inp)) == sizeof(inp)) {
		mod =  track_modifier (base, inp.code, inp.value);
  		if (inp.value == 1 && base->flags.learn_in_progress) {
    		code = filter_keycode(inp.code);
			gtk_entry_set_text(GTK_ENTRY(base->learnentry), code_key_and_modifier(code, mod));
			if (code) {
				base->flags.learn_in_progress = 0;
				gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (base->learnbutton), FALSE);
				gtk_widget_hide (base->learnwindow);
			}
		}
	}
}

int
track_modifier(struct basedata *base, unsigned short code, unsigned int value)
{
	if (value > 1) value = 1;   /* key repeated = pressed */
	switch (code)
	{
		case KEY_RIGHTSHIFT:
		case KEY_LEFTSHIFT:
			base->flags.shift = value;
			break;
		case KEY_RIGHTCTRL:
		case KEY_LEFTCTRL:
			base->flags.ctrl = value;
			break;
		case KEY_RIGHTALT:
		case KEY_LEFTALT:
			base->flags.alt = value;
			break;
	}
	return (base->flags.ctrl << 2) | (base->flags.alt << 1) | (base->flags.shift << 0);
}

int
filter_keycode(unsigned short code)
{
	switch (code)
	{
		case KEY_RIGHTSHIFT:
		case KEY_LEFTSHIFT:
		case KEY_RIGHTCTRL:
		case KEY_LEFTCTRL:
		case KEY_RIGHTALT:
		case KEY_LEFTALT:
			code = 0;
			break;
	}
	return code;
}

