/*
 * Potamus: an audio player
 * Copyright (C) 2004, 2005, 2006, 2007 Adam Sampson <ats@offog.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef FORMAT_H
#define FORMAT_H

enum endianness {
	END_LITTLE,
	END_BIG,
	END_NATIVE,
};

#define BITS_FLOAT (-1)

typedef struct sample_format {
	int bits;
	int rate;
	int channels;
	enum endianness byte_format;
} sample_format;

int bytes_per_sample(int bits);
int convert_format(buffer *in, sample_format *in_fmt, buffer *out, sample_format *out_fmt, int processing, const char **error);
void copy_format(sample_format *out, const sample_format *in);
int format_same(const sample_format *a, const sample_format *b);
void append_format_str(GString *s, const sample_format *fmt);

#endif
