/*
 * Potamus: an audio player
 * Copyright (C) 2004, 2005, 2006, 2007 Adam Sampson <ats@offog.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <gtk/gtk.h>
#include "util.h"

gchar *escape_for_markup(const gchar *s) {
	GString *out = g_string_new("");

	while (*s != '\0') {
		if (*s == '<')
			g_string_append(out, "&lt;");
		else if (*s == '>')
			g_string_append(out, "&gt;");
		else if (*s == '&')
			g_string_append(out, "&amp;");
		else
			g_string_append_c(out, *s);

		++s;
	}

	gchar *ret = out->str;
	g_string_free(out, FALSE);
	return ret;
}

void ensure_path_visible(GtkTreeView *view, GtkTreePath *path) {
	GdkRectangle row;
	gtk_tree_view_get_cell_area(view, path, NULL, &row);
	gtk_tree_view_widget_to_tree_coords(view, row.x, row.y, &row.x, &row.y);

	GdkRectangle vis;
	gtk_tree_view_get_visible_rect(view, &vis);

	if ((row.y < vis.y) || (row.y + row.height >= vis.y + vis.height))
		gtk_tree_view_scroll_to_cell(view, path, NULL, TRUE, 0.5, 0.0);
}
