/*
 * Potamus: an audio player
 * Copyright (C) 2004, 2005, 2006, 2007 Adam Sampson <ats@offog.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include "stock.h"
#include "main.h"

static GtkStockItem items[] = {
	{ POTAMUS_STOCK_PREVIOUS, "Previous" },
	{ POTAMUS_STOCK_PLAY, "Play" },
	{ POTAMUS_STOCK_PAUSE, "Pause" },
	{ POTAMUS_STOCK_NEXT, "Next" },
	{ POTAMUS_STOCK_STOP, "Stop" },
	{ POTAMUS_STOCK_CLEAR, "Clear" },
	{ POTAMUS_STOCK_SHUFFLE, "Shuffle" },
	{ POTAMUS_STOCK_PLAYING, "Playing" }
};

void stock_init() {
	// This approach taken from Jamboree.

	gtk_stock_add(items, G_N_ELEMENTS(items));

	GtkIconFactory *factory = gtk_icon_factory_new();
	gtk_icon_factory_add_default(factory);

	for (int i = 0; i < G_N_ELEMENTS(items); i++) {
		gchar *path = g_strdup_printf(DATADIR "/%s.png",
		                              items[i].stock_id);
		GdkPixbuf *pixbuf = gdk_pixbuf_new_from_file(path, NULL);
		if (pixbuf == NULL)
			g_error("Cannot open stock image: %s", path);
		g_free(path);

		gtk_icon_factory_add(factory, items[i].stock_id,
		                     gtk_icon_set_new_from_pixbuf(pixbuf));
	}
}

