
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 1

/* Substitute the variable and function names.  */
#define yyparse         base_yyparse
#define yylex           base_yylex
#define yyerror         base_yyerror
#define yylval          base_yylval
#define yychar          base_yychar
#define yydebug         base_yydebug
#define yynerrs         base_yynerrs
#define yylloc          base_yylloc

/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 5 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include "ecpg_config.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int 	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (yyin)
				fclose(yyin);
			if (yyout)
				fclose(yyout);

			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
			        fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), mm_strdup(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in other functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn's cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = mm_strdup("");
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char temp[20];
			char *original_var;
			bool skip_set_var = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(temp, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable) && (!strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement"))))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char && ptr->variable->type->type != ECPGt_string) && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, mm_strdup("1"), ptr->variable->type->u.element->counter), ptr->variable->type->size), 0);
				sprintf(temp, "%d, (", ecpg_internal_var++);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char || ptr->variable->type->type == ECPGt_string) && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->counter), 0);
				if (ptr->variable->type->type == ECPGt_varchar)
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				else
					sprintf(temp, "%d, (", ecpg_internal_var++);
			}
			else if (ptr->variable->type->type == ECPGt_struct || ptr->variable->type->type == ECPGt_union)
			{
				sprintf(temp, "%d)))", ecpg_internal_var);
				newvar = new_variable(cat_str(4, mm_strdup("(*("), mm_strdup(ptr->variable->type->type_name), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->variable->type->u.members, ptr->variable->type->type, ptr->variable->type->type_name, ptr->variable->type->struct_sizeof), 0);
				sprintf(temp, "%d, &(", ecpg_internal_var++);
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct || ptr->variable->type->u.element->type == ECPGt_union)
				{
					sprintf(temp, "%d)))", ecpg_internal_var);
					newvar = new_variable(cat_str(4, mm_strdup("(*("), mm_strdup(ptr->variable->type->u.element->type_name), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->variable->type->u.element->u.members, ptr->variable->type->u.element->type, ptr->variable->type->u.element->type_name, ptr->variable->type->u.element->struct_sizeof), 0);
					sprintf(temp, "%d, (", ecpg_internal_var++);
				}
				else
				{
					newvar = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, ptr->variable->type->u.element->size, ptr->variable->type->u.element->counter), ptr->variable->type->size), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, mm_strdup("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->counter), 0);
				sprintf(temp, "%d, &(", ecpg_internal_var++);
			}

			/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
			if (!skip_set_var)
				result = cat_str(5, result, mm_strdup("ECPGset_var("), mm_strdup(temp), mm_strdup(original_var), mm_strdup("), __LINE__);\n"));

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(temp, "%d))", ecpg_internal_var);

				if (ptr->indicator->type->type == ECPGt_struct || ptr->indicator->type->type == ECPGt_union)
				{
					sprintf(temp, "%d)))", ecpg_internal_var);
					newind = new_variable(cat_str(4, mm_strdup("(*("), mm_strdup(ptr->indicator->type->type_name), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->indicator->type->u.members, ptr->indicator->type->type, ptr->indicator->type->type_name, ptr->indicator->type->struct_sizeof), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct || ptr->indicator->type->u.element->type == ECPGt_union)
					{
						sprintf(temp, "%d)))", ecpg_internal_var);
						newind = new_variable(cat_str(4, mm_strdup("(*("), mm_strdup(ptr->indicator->type->u.element->type_name), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->indicator->type->u.element->u.members, ptr->indicator->type->u.element->type, ptr->indicator->type->u.element->type_name, ptr->indicator->type->u.element->struct_sizeof), 0);
						sprintf(temp, "%d, (", ecpg_internal_var++);
					}
					else
					{
						newind = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type, ptr->indicator->type->u.element->size, ptr->indicator->type->u.element->counter), ptr->indicator->type->size), 0);
						sprintf(temp, "%d, &(", ecpg_internal_var++);
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, mm_strdup("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->counter), 0);
					sprintf(temp, "%d, (", ecpg_internal_var++);
				}
				else
				{
					newind = new_variable(cat_str(4, mm_strdup("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), mm_strdup(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->counter), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				result = cat_str(5, result, mm_strdup("ECPGset_var("), mm_strdup(temp), mm_strdup(original_var), mm_strdup("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && !strcmp(cur->function, current_function)))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;
	int (* strcmp_fn)(const char *, const char *) = (name[0] == ':' ? strcmp : pg_strcasecmp);

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp_fn(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}


/* Line 189 of yacc.c  */
#line 536 "preproc.c"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_COUNT = 265,
     SQL_DATETIME_INTERVAL_CODE = 266,
     SQL_DATETIME_INTERVAL_PRECISION = 267,
     SQL_DESCRIBE = 268,
     SQL_DESCRIPTOR = 269,
     SQL_DISCONNECT = 270,
     SQL_FOUND = 271,
     SQL_FREE = 272,
     SQL_GET = 273,
     SQL_GO = 274,
     SQL_GOTO = 275,
     SQL_IDENTIFIED = 276,
     SQL_INDICATOR = 277,
     SQL_KEY_MEMBER = 278,
     SQL_LENGTH = 279,
     SQL_LONG = 280,
     SQL_NULLABLE = 281,
     SQL_OCTET_LENGTH = 282,
     SQL_OPEN = 283,
     SQL_OUTPUT = 284,
     SQL_REFERENCE = 285,
     SQL_RETURNED_LENGTH = 286,
     SQL_RETURNED_OCTET_LENGTH = 287,
     SQL_SCALE = 288,
     SQL_SECTION = 289,
     SQL_SHORT = 290,
     SQL_SIGNED = 291,
     SQL_SQL = 292,
     SQL_SQLERROR = 293,
     SQL_SQLPRINT = 294,
     SQL_SQLWARNING = 295,
     SQL_START = 296,
     SQL_STOP = 297,
     SQL_STRUCT = 298,
     SQL_UNSIGNED = 299,
     SQL_VAR = 300,
     SQL_WHENEVER = 301,
     S_ADD = 302,
     S_AND = 303,
     S_ANYTHING = 304,
     S_AUTO = 305,
     S_CONST = 306,
     S_DEC = 307,
     S_DIV = 308,
     S_DOTPOINT = 309,
     S_EQUAL = 310,
     S_EXTERN = 311,
     S_INC = 312,
     S_LSHIFT = 313,
     S_MEMPOINT = 314,
     S_MEMBER = 315,
     S_MOD = 316,
     S_MUL = 317,
     S_NEQUAL = 318,
     S_OR = 319,
     S_REGISTER = 320,
     S_RSHIFT = 321,
     S_STATIC = 322,
     S_SUB = 323,
     S_VOLATILE = 324,
     S_TYPEDEF = 325,
     CSTRING = 326,
     CVARIABLE = 327,
     CPP_LINE = 328,
     IP = 329,
     DOLCONST = 330,
     ECONST = 331,
     NCONST = 332,
     UCONST = 333,
     UIDENT = 334,
     IDENT = 335,
     FCONST = 336,
     SCONST = 337,
     BCONST = 338,
     XCONST = 339,
     Op = 340,
     ICONST = 341,
     PARAM = 342,
     TYPECAST = 343,
     DOT_DOT = 344,
     COLON_EQUALS = 345,
     ABORT_P = 346,
     ABSOLUTE_P = 347,
     ACCESS = 348,
     ACTION = 349,
     ADD_P = 350,
     ADMIN = 351,
     AFTER = 352,
     AGGREGATE = 353,
     ALL = 354,
     ALSO = 355,
     ALTER = 356,
     ALWAYS = 357,
     ANALYSE = 358,
     ANALYZE = 359,
     AND = 360,
     ANY = 361,
     ARRAY = 362,
     AS = 363,
     ASC = 364,
     ASSERTION = 365,
     ASSIGNMENT = 366,
     ASYMMETRIC = 367,
     AT = 368,
     ATTRIBUTE = 369,
     AUTHORIZATION = 370,
     BACKWARD = 371,
     BARRIER = 372,
     BEFORE = 373,
     BEGIN_P = 374,
     BETWEEN = 375,
     BIGINT = 376,
     BINARY = 377,
     BIT = 378,
     BOOLEAN_P = 379,
     BOTH = 380,
     BY = 381,
     CACHE = 382,
     CALLED = 383,
     CASCADE = 384,
     CASCADED = 385,
     CASE = 386,
     CAST = 387,
     CATALOG_P = 388,
     CHAIN = 389,
     CHAR_P = 390,
     CHARACTER = 391,
     CHARACTERISTICS = 392,
     CHECK = 393,
     CHECKPOINT = 394,
     CLASS = 395,
     CLEAN = 396,
     CLOSE = 397,
     CLUSTER = 398,
     COALESCE = 399,
     COLLATE = 400,
     COLLATION = 401,
     COLUMN = 402,
     COMMENT = 403,
     COMMENTS = 404,
     COMMIT = 405,
     COMMITTED = 406,
     CONCURRENTLY = 407,
     CONFIGURATION = 408,
     CONNECTION = 409,
     CONSTRAINT = 410,
     CONSTRAINTS = 411,
     CONTENT_P = 412,
     CONTINUE_P = 413,
     CONVERSION_P = 414,
     COORDINATOR = 415,
     COPY = 416,
     COST = 417,
     CREATE = 418,
     CROSS = 419,
     CSV = 420,
     CURRENT_P = 421,
     CURRENT_CATALOG = 422,
     CURRENT_DATE = 423,
     CURRENT_ROLE = 424,
     CURRENT_SCHEMA = 425,
     CURRENT_TIME = 426,
     CURRENT_TIMESTAMP = 427,
     CURRENT_USER = 428,
     CURSOR = 429,
     CYCLE = 430,
     DATA_P = 431,
     DATABASE = 432,
     DAY_P = 433,
     DEALLOCATE = 434,
     DEC = 435,
     DECIMAL_P = 436,
     DECLARE = 437,
     DEFAULT = 438,
     DEFAULTS = 439,
     DEFERRABLE = 440,
     DEFERRED = 441,
     DEFINER = 442,
     DELETE_P = 443,
     DELIMITER = 444,
     DELIMITERS = 445,
     DESC = 446,
     DICTIONARY = 447,
     DIRECT = 448,
     DISABLE_P = 449,
     DISCARD = 450,
     DISTINCT = 451,
     DISTRIBUTE = 452,
     DO = 453,
     DOCUMENT_P = 454,
     DOMAIN_P = 455,
     DOUBLE_P = 456,
     DROP = 457,
     EACH = 458,
     ELSE = 459,
     ENABLE_P = 460,
     ENCODING = 461,
     ENCRYPTED = 462,
     END_P = 463,
     ENUM_P = 464,
     ESCAPE = 465,
     EXCEPT = 466,
     EXCLUDE = 467,
     EXCLUDING = 468,
     EXCLUSIVE = 469,
     EXECUTE = 470,
     EXISTS = 471,
     EXPLAIN = 472,
     EXTENSION = 473,
     EXTERNAL = 474,
     EXTRACT = 475,
     FALSE_P = 476,
     FAMILY = 477,
     FETCH = 478,
     FIRST_P = 479,
     FLOAT_P = 480,
     FOLLOWING = 481,
     FOR = 482,
     FORCE = 483,
     FOREIGN = 484,
     FORWARD = 485,
     FREEZE = 486,
     FROM = 487,
     FULL = 488,
     FUNCTION = 489,
     FUNCTIONS = 490,
     GLOBAL = 491,
     GRANT = 492,
     GRANTED = 493,
     GREATEST = 494,
     GROUP_P = 495,
     HANDLER = 496,
     HASH = 497,
     HAVING = 498,
     HEADER_P = 499,
     HOLD = 500,
     HOUR_P = 501,
     IDENTITY_P = 502,
     IF_P = 503,
     ILIKE = 504,
     IMMEDIATE = 505,
     IMMUTABLE = 506,
     IMPLICIT_P = 507,
     IN_P = 508,
     INCLUDING = 509,
     INCREMENT = 510,
     INDEX = 511,
     INDEXES = 512,
     INHERIT = 513,
     INHERITS = 514,
     INITIALLY = 515,
     INLINE_P = 516,
     INNER_P = 517,
     INOUT = 518,
     INPUT_P = 519,
     INSENSITIVE = 520,
     INSERT = 521,
     INSTEAD = 522,
     INT_P = 523,
     INTEGER = 524,
     INTERSECT = 525,
     INTERVAL = 526,
     INTO = 527,
     INVOKER = 528,
     IS = 529,
     ISNULL = 530,
     ISOLATION = 531,
     JOIN = 532,
     KEY = 533,
     LABEL = 534,
     LANGUAGE = 535,
     LARGE_P = 536,
     LAST_P = 537,
     LC_COLLATE_P = 538,
     LC_CTYPE_P = 539,
     LEADING = 540,
     LEAST = 541,
     LEFT = 542,
     LEVEL = 543,
     LIKE = 544,
     LIMIT = 545,
     LISTEN = 546,
     LOAD = 547,
     LOCAL = 548,
     LOCALTIME = 549,
     LOCALTIMESTAMP = 550,
     LOCATION = 551,
     LOCK_P = 552,
     MAPPING = 553,
     MATCH = 554,
     MAXVALUE = 555,
     MINUTE_P = 556,
     MINVALUE = 557,
     MODE = 558,
     MODULO = 559,
     MONTH_P = 560,
     MOVE = 561,
     NAME_P = 562,
     NAMES = 563,
     NATIONAL = 564,
     NATURAL = 565,
     NCHAR = 566,
     NEXT = 567,
     NO = 568,
     NODE = 569,
     NONE = 570,
     NOT = 571,
     NOTHING = 572,
     NOTIFY = 573,
     NOTNULL = 574,
     NOWAIT = 575,
     NULL_P = 576,
     NULLIF = 577,
     NULLS_P = 578,
     NUMERIC = 579,
     OBJECT_P = 580,
     OF = 581,
     OFF = 582,
     OFFSET = 583,
     OIDS = 584,
     ON = 585,
     ONLY = 586,
     OPERATOR = 587,
     OPTION = 588,
     OPTIONS = 589,
     OR = 590,
     ORDER = 591,
     OUT_P = 592,
     OUTER_P = 593,
     OVER = 594,
     OVERLAPS = 595,
     OVERLAY = 596,
     OWNED = 597,
     OWNER = 598,
     PARSER = 599,
     PARTIAL = 600,
     PARTITION = 601,
     PASSING = 602,
     PASSWORD = 603,
     PLACING = 604,
     PLANS = 605,
     POSITION = 606,
     PRECEDING = 607,
     PRECISION = 608,
     PREFERRED = 609,
     PRESERVE = 610,
     PREPARE = 611,
     PREPARED = 612,
     PRIMARY = 613,
     PRIOR = 614,
     PRIVILEGES = 615,
     PROCEDURAL = 616,
     PROCEDURE = 617,
     QUOTE = 618,
     RANGE = 619,
     READ = 620,
     REAL = 621,
     REASSIGN = 622,
     RECHECK = 623,
     RECURSIVE = 624,
     REF = 625,
     REFERENCES = 626,
     REINDEX = 627,
     RELATIVE_P = 628,
     RELEASE = 629,
     RENAME = 630,
     REPEATABLE = 631,
     REPLACE = 632,
     REPLICA = 633,
     REPLICATION = 634,
     RESET = 635,
     RESTART = 636,
     RESTRICT = 637,
     RETURNING = 638,
     RETURNS = 639,
     REVOKE = 640,
     RIGHT = 641,
     ROBIN = 642,
     ROLE = 643,
     ROLLBACK = 644,
     ROUND = 645,
     ROW = 646,
     ROWS = 647,
     RULE = 648,
     SAVEPOINT = 649,
     SCHEMA = 650,
     SCROLL = 651,
     SEARCH = 652,
     SECOND_P = 653,
     SECURITY = 654,
     SELECT = 655,
     SEQUENCE = 656,
     SEQUENCES = 657,
     SERIALIZABLE = 658,
     SERVER = 659,
     SESSION = 660,
     SESSION_USER = 661,
     SET = 662,
     SETOF = 663,
     SHARE = 664,
     SHOW = 665,
     SIMILAR = 666,
     SIMPLE = 667,
     SMALLINT = 668,
     SOME = 669,
     STABLE = 670,
     STANDALONE_P = 671,
     START = 672,
     STATEMENT = 673,
     STATISTICS = 674,
     STDIN = 675,
     STDOUT = 676,
     STORAGE = 677,
     STRICT_P = 678,
     STRIP_P = 679,
     SUBSTRING = 680,
     SYMMETRIC = 681,
     SYSID = 682,
     SYSTEM_P = 683,
     TABLE = 684,
     TABLES = 685,
     TABLESPACE = 686,
     TEMP = 687,
     TEMPLATE = 688,
     TEMPORARY = 689,
     TEXT_P = 690,
     THEN = 691,
     TIME = 692,
     TIMESTAMP = 693,
     TO = 694,
     TRAILING = 695,
     TRANSACTION = 696,
     TREAT = 697,
     TRIGGER = 698,
     TRIM = 699,
     TRUE_P = 700,
     TRUNCATE = 701,
     TRUSTED = 702,
     TYPE_P = 703,
     UNBOUNDED = 704,
     UNCOMMITTED = 705,
     UNENCRYPTED = 706,
     UNION = 707,
     UNIQUE = 708,
     UNKNOWN = 709,
     UNLISTEN = 710,
     UNLOGGED = 711,
     UNTIL = 712,
     UPDATE = 713,
     USER = 714,
     USING = 715,
     VACUUM = 716,
     VALID = 717,
     VALIDATE = 718,
     VALIDATOR = 719,
     VALUE_P = 720,
     VALUES = 721,
     VARCHAR = 722,
     VARIADIC = 723,
     VARYING = 724,
     VERBOSE = 725,
     VERSION_P = 726,
     VIEW = 727,
     VOLATILE = 728,
     WHEN = 729,
     WHERE = 730,
     WHITESPACE_P = 731,
     WINDOW = 732,
     WITH = 733,
     WITHOUT = 734,
     WORK = 735,
     WRAPPER = 736,
     WRITE = 737,
     XML_P = 738,
     XMLATTRIBUTES = 739,
     XMLCONCAT = 740,
     XMLELEMENT = 741,
     XMLEXISTS = 742,
     XMLFOREST = 743,
     XMLPARSE = 744,
     XMLPI = 745,
     XMLROOT = 746,
     XMLSERIALIZE = 747,
     YEAR_P = 748,
     YES_P = 749,
     ZONE = 750,
     NULLS_FIRST = 751,
     NULLS_LAST = 752,
     WITH_TIME = 753,
     POSTFIXOP = 754,
     UMINUS = 755
   };
#endif



#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 463 "preproc.y"

	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;



/* Line 214 of yacc.c  */
#line 1089 "preproc.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif

#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 264 of yacc.c  */
#line 1114 "preproc.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
	     && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   102418

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  520
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  704
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2741
/* YYNRULES -- Number of states.  */
#define YYNSTATES  4925

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   755

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   507,     2,     2,
     512,   513,   505,   503,   515,   504,   514,   506,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   517,   516,
     500,   499,   501,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   510,     2,   511,   508,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   518,     2,   519,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   502,   509
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    29,    31,    33,    35,    37,
      39,    41,    43,    45,    47,    49,    51,    53,    55,    57,
      59,    61,    63,    65,    67,    69,    71,    73,    75,    77,
      79,    81,    83,    85,    87,    89,    91,    93,    95,    97,
      99,   101,   103,   105,   107,   109,   111,   113,   115,   117,
     119,   121,   123,   125,   127,   129,   131,   133,   135,   137,
     139,   141,   143,   145,   147,   149,   151,   153,   155,   157,
     159,   161,   163,   165,   167,   169,   171,   173,   175,   177,
     179,   181,   183,   185,   187,   189,   191,   193,   195,   197,
     199,   201,   203,   205,   207,   209,   211,   213,   215,   217,
     219,   221,   223,   225,   227,   229,   231,   233,   235,   237,
     239,   241,   243,   245,   247,   249,   251,   253,   255,   257,
     259,   261,   263,   265,   267,   269,   271,   273,   275,   277,
     279,   280,   286,   288,   289,   292,   293,   296,   297,   300,
     303,   307,   311,   313,   317,   321,   324,   326,   328,   330,
     333,   336,   339,   343,   347,   353,   359,   360,   364,   370,
     376,   381,   385,   391,   395,   401,   407,   414,   416,   418,
     422,   428,   435,   440,   442,   443,   446,   447,   449,   451,
     453,   455,   457,   459,   462,   466,   470,   474,   478,   482,
     486,   490,   494,   497,   503,   506,   509,   512,   515,   519,
     523,   527,   529,   533,   535,   539,   541,   543,   546,   549,
     552,   554,   556,   558,   560,   562,   564,   566,   570,   577,
     579,   581,   583,   585,   587,   588,   590,   592,   595,   599,
     604,   608,   611,   614,   616,   620,   625,   631,   636,   639,
     644,   646,   648,   650,   652,   654,   657,   660,   663,   666,
     671,   676,   681,   686,   688,   692,   695,   699,   704,   711,
     718,   725,   731,   737,   744,   751,   756,   765,   768,   772,
     779,   784,   788,   792,   796,   800,   804,   809,   814,   818,
     822,   826,   830,   834,   838,   843,   848,   852,   855,   859,
     862,   865,   869,   873,   876,   879,   881,   885,   888,   890,
     892,   893,   896,   897,   900,   901,   905,   908,   909,   911,
     915,   919,   921,   927,   931,   936,   938,   942,   947,   954,
     959,   968,   971,   974,   985,   992,   994,   996,   998,  1000,
    1002,  1004,  1008,  1011,  1012,  1014,  1016,  1020,  1024,  1026,
    1028,  1032,  1036,  1040,  1044,  1049,  1052,  1054,  1055,  1058,
    1059,  1063,  1064,  1066,  1067,  1069,  1073,  1076,  1078,  1080,
    1082,  1086,  1087,  1089,  1093,  1095,  1109,  1126,  1139,  1155,
    1157,  1159,  1162,  1165,  1168,  1171,  1173,  1174,  1176,  1177,
    1181,  1182,  1184,  1188,  1190,  1194,  1196,  1198,  1200,  1202,
    1204,  1208,  1213,  1216,  1217,  1221,  1223,  1225,  1228,  1231,
    1233,  1237,  1242,  1247,  1250,  1256,  1258,  1261,  1264,  1267,
    1271,  1275,  1279,  1280,  1282,  1284,  1286,  1288,  1290,  1292,
    1296,  1298,  1304,  1312,  1316,  1325,  1330,  1340,  1352,  1356,
    1357,  1359,  1363,  1365,  1368,  1371,  1374,  1375,  1377,  1381,
    1385,  1392,  1397,  1398,  1400,  1402,  1405,  1408,  1409,  1413,
    1417,  1420,  1422,  1424,  1427,  1430,  1435,  1436,  1439,  1442,
    1445,  1446,  1450,  1455,  1460,  1461,  1464,  1465,  1468,  1472,
    1477,  1484,  1488,  1493,  1494,  1498,  1502,  1503,  1508,  1509,
    1513,  1521,  1525,  1526,  1528,  1532,  1534,  1537,  1541,  1542,
    1548,  1553,  1555,  1556,  1558,  1561,  1564,  1566,  1569,  1573,
    1576,  1579,  1582,  1585,  1589,  1593,  1595,  1599,  1601,  1602,
    1604,  1607,  1609,  1611,  1615,  1622,  1633,  1635,  1636,  1638,
    1641,  1644,  1645,  1648,  1651,  1653,  1654,  1660,  1668,  1670,
    1671,  1678,  1681,  1682,  1686,  1692,  1698,  1707,  1710,  1711,
    1714,  1717,  1720,  1726,  1729,  1730,  1733,  1741,  1752,  1759,
    1766,  1773,  1780,  1788,  1796,  1806,  1816,  1823,  1830,  1839,
    1848,  1857,  1866,  1873,  1880,  1888,  1897,  1904,  1911,  1919,
    1922,  1925,  1928,  1931,  1933,  1936,  1938,  1939,  1946,  1955,
    1963,  1970,  1975,  1976,  1978,  1982,  1987,  1989,  1993,  1995,
    1998,  2001,  2004,  2007,  2009,  2011,  2022,  2025,  2026,  2029,
    2032,  2034,  2035,  2040,  2047,  2053,  2058,  2063,  2072,  2084,
    2088,  2091,  2093,  2097,  2099,  2105,  2114,  2116,  2118,  2120,
    2128,  2138,  2147,  2163,  2184,  2186,  2188,  2191,  2193,  2197,
    2199,  2201,  2203,  2207,  2209,  2213,  2214,  2216,  2217,  2219,
    2221,  2226,  2227,  2229,  2233,  2234,  2236,  2238,  2240,  2242,
    2245,  2246,  2247,  2250,  2253,  2255,  2258,  2261,  2264,  2271,
    2280,  2289,  2294,  2300,  2305,  2310,  2315,  2319,  2327,  2336,
    2343,  2350,  2357,  2364,  2369,  2375,  2379,  2381,  2385,  2389,
    2391,  2393,  2395,  2397,  2399,  2401,  2405,  2409,  2413,  2415,
    2419,  2423,  2425,  2426,  2428,  2432,  2439,  2448,  2457,  2471,
    2473,  2477,  2483,  2490,  2495,  2503,  2506,  2508,  2509,  2512,
    2513,  2516,  2521,  2522,  2524,  2525,  2532,  2541,  2550,  2552,
    2556,  2562,  2568,  2576,  2586,  2594,  2604,  2610,  2617,  2624,
    2629,  2631,  2633,  2635,  2637,  2640,  2642,  2644,  2646,  2648,
    2650,  2652,  2656,  2660,  2664,  2668,  2670,  2674,  2676,  2679,
    2682,  2686,  2692,  2695,  2698,  2699,  2706,  2714,  2722,  2730,
    2739,  2748,  2755,  2764,  2774,  2784,  2792,  2803,  2811,  2820,
    2829,  2838,  2847,  2849,  2851,  2853,  2855,  2857,  2859,  2861,
    2863,  2865,  2867,  2869,  2871,  2873,  2875,  2878,  2880,  2884,
    2886,  2888,  2897,  2907,  2917,  2927,  2937,  2940,  2941,  2943,
    2946,  2948,  2950,  2952,  2954,  2956,  2958,  2960,  2962,  2965,
    2968,  2972,  2977,  2983,  2988,  2994,  2998,  3003,  3007,  3012,
    3014,  3017,  3021,  3025,  3029,  3033,  3038,  3043,  3047,  3051,
    3056,  3061,  3066,  3071,  3073,  3075,  3077,  3078,  3086,  3094,
    3105,  3107,  3109,  3112,  3117,  3123,  3125,  3129,  3132,  3135,
    3138,  3141,  3143,  3146,  3149,  3154,  3158,  3161,  3164,  3167,
    3171,  3174,  3177,  3183,  3189,  3195,  3197,  3201,  3203,  3206,
    3210,  3211,  3213,  3217,  3220,  3227,  3234,  3244,  3248,  3249,
    3253,  3254,  3260,  3263,  3264,  3268,  3272,  3276,  3284,  3292,
    3303,  3305,  3307,  3309,  3324,  3326,  3327,  3329,  3330,  3332,
    3333,  3336,  3337,  3339,  3343,  3349,  3355,  3363,  3366,  3367,
    3369,  3372,  3373,  3375,  3377,  3378,  3380,  3382,  3383,  3393,
    3406,  3414,  3417,  3418,  3422,  3425,  3427,  3431,  3435,  3438,
    3440,  3444,  3448,  3452,  3455,  3458,  3460,  3462,  3464,  3466,
    3469,  3471,  3473,  3475,  3477,  3482,  3488,  3490,  3494,  3498,
    3500,  3503,  3508,  3514,  3516,  3518,  3520,  3522,  3526,  3530,
    3533,  3536,  3539,  3542,  3544,  3547,  3550,  3552,  3554,  3556,
    3560,  3563,  3564,  3567,  3569,  3573,  3579,  3581,  3584,  3586,
    3587,  3593,  3601,  3607,  3615,  3621,  3629,  3633,  3639,  3645,
    3651,  3653,  3657,  3660,  3662,  3665,  3667,  3670,  3682,  3693,
    3704,  3707,  3710,  3711,  3721,  3724,  3725,  3730,  3735,  3740,
    3742,  3744,  3746,  3747,  3755,  3762,  3769,  3776,  3783,  3790,
    3798,  3808,  3818,  3825,  3832,  3839,  3846,  3853,  3861,  3870,
    3880,  3889,  3896,  3903,  3910,  3916,  3922,  3931,  3940,  3949,
    3958,  3965,  3975,  3977,  3978,  3981,  3982,  3990,  3997,  4004,
    4011,  4018,  4025,  4033,  4043,  4053,  4060,  4069,  4078,  4087,
    4096,  4103,  4110,  4118,  4125,  4133,  4140,  4147,  4154,  4161,
    4168,  4176,  4184,  4192,  4202,  4212,  4219,  4226,  4233,  4242,
    4251,  4260,  4267,  4281,  4283,  4285,  4289,  4293,  4295,  4297,
    4299,  4301,  4303,  4305,  4307,  4308,  4310,  4312,  4314,  4316,
    4318,  4320,  4321,  4328,  4337,  4341,  4344,  4345,  4348,  4351,
    4354,  4357,  4361,  4365,  4368,  4371,  4374,  4377,  4381,  4384,
    4390,  4395,  4399,  4403,  4407,  4409,  4411,  4412,  4416,  4419,
    4422,  4424,  4427,  4429,  4433,  4436,  4438,  4439,  4448,  4459,
    4463,  4468,  4473,  4474,  4477,  4483,  4486,  4487,  4491,  4495,
    4499,  4503,  4507,  4511,  4515,  4519,  4523,  4527,  4531,  4535,
    4539,  4544,  4548,  4552,  4554,  4555,  4561,  4568,  4573,  4576,
    4577,  4582,  4586,  4592,  4599,  4604,  4611,  4618,  4624,  4632,
    4634,  4635,  4642,  4654,  4666,  4678,  4692,  4702,  4714,  4725,
    4730,  4733,  4739,  4742,  4743,  4748,  4754,  4760,  4765,  4772,
    4774,  4778,  4780,  4782,  4784,  4786,  4789,  4794,  4796,  4798,
    4800,  4801,  4803,  4804,  4806,  4807,  4811,  4812,  4816,  4818,
    4819,  4824,  4826,  4828,  4832,  4834,  4839,  4843,  4850,  4855,
    4858,  4863,  4867,  4873,  4875,  4877,  4879,  4881,  4883,  4885,
    4887,  4889,  4893,  4896,  4898,  4900,  4902,  4904,  4906,  4907,
    4913,  4915,  4923,  4931,  4939,  4943,  4946,  4947,  4951,  4954,
    4955,  4961,  4966,  4970,  4971,  4973,  4975,  4977,  4979,  4984,
    4993,  4997,  4998,  5005,  5007,  5012,  5015,  5017,  5021,  5024,
    5028,  5029,  5037,  5040,  5041,  5047,  5051,  5052,  5055,  5058,
    5061,  5065,  5067,  5071,  5073,  5076,  5078,  5079,  5088,  5090,
    5094,  5096,  5098,  5102,  5108,  5111,  5113,  5117,  5125,  5127,
    5129,  5130,  5134,  5137,  5140,  5143,  5144,  5147,  5150,  5152,
    5154,  5158,  5162,  5164,  5167,  5172,  5177,  5180,  5184,  5190,
    5196,  5198,  5200,  5210,  5212,  5215,  5220,  5225,  5230,  5233,
    5237,  5239,  5243,  5250,  5252,  5253,  5256,  5258,  5259,  5263,
    5267,  5272,  5277,  5282,  5287,  5291,  5294,  5296,  5298,  5299,
    5301,  5303,  5304,  5306,  5312,  5314,  5315,  5317,  5318,  5322,
    5324,  5328,  5333,  5337,  5340,  5343,  5345,  5347,  5349,  5350,
    5353,  5358,  5364,  5367,  5371,  5373,  5375,  5377,  5379,  5383,
    5384,  5386,  5388,  5390,  5392,  5394,  5398,  5399,  5402,  5403,
    5405,  5409,  5411,  5412,  5414,  5417,  5422,  5427,  5430,  5431,
    5434,  5438,  5441,  5442,  5444,  5448,  5450,  5453,  5455,  5458,
    5464,  5471,  5477,  5479,  5482,  5484,  5489,  5493,  5498,  5504,
    5509,  5515,  5520,  5526,  5529,  5534,  5536,  5539,  5542,  5545,
    5547,  5549,  5550,  5555,  5558,  5560,  5563,  5566,  5571,  5573,
    5577,  5579,  5582,  5586,  5588,  5591,  5592,  5595,  5600,  5601,
    5603,  5604,  5606,  5610,  5614,  5617,  5621,  5627,  5634,  5637,
    5641,  5645,  5650,  5651,  5653,  5655,  5657,  5659,  5661,  5664,
    5670,  5672,  5674,  5676,  5678,  5681,  5685,  5689,  5690,  5692,
    5694,  5696,  5698,  5700,  5703,  5706,  5709,  5712,  5715,  5717,
    5721,  5722,  5724,  5726,  5728,  5730,  5736,  5739,  5741,  5743,
    5745,  5747,  5753,  5756,  5759,  5762,  5764,  5768,  5772,  5775,
    5777,  5778,  5782,  5783,  5789,  5792,  5798,  5801,  5803,  5806,
    5810,  5811,  5813,  5815,  5817,  5819,  5821,  5823,  5827,  5831,
    5835,  5839,  5843,  5847,  5851,  5852,  5854,  5859,  5861,  5865,
    5869,  5875,  5878,  5881,  5885,  5889,  5893,  5897,  5901,  5905,
    5909,  5913,  5917,  5921,  5924,  5927,  5931,  5935,  5938,  5942,
    5948,  5953,  5960,  5964,  5970,  5975,  5982,  5987,  5994,  6000,
    6008,  6012,  6015,  6020,  6023,  6027,  6031,  6036,  6040,  6045,
    6049,  6054,  6060,  6067,  6074,  6082,  6089,  6097,  6104,  6112,
    6116,  6121,  6126,  6133,  6136,  6140,  6145,  6147,  6151,  6154,
    6157,  6161,  6165,  6169,  6173,  6177,  6181,  6185,  6189,  6193,
    6197,  6200,  6203,  6209,  6216,  6223,  6231,  6235,  6240,  6242,
    6244,  6247,  6252,  6254,  6256,  6258,  6261,  6264,  6267,  6269,
    6274,  6280,  6287,  6296,  6303,  6311,  6319,  6325,  6327,  6329,
    6334,  6336,  6341,  6343,  6348,  6350,  6355,  6357,  6359,  6361,
    6363,  6365,  6367,  6374,  6379,  6384,  6389,  6394,  6401,  6407,
    6413,  6419,  6424,  6431,  6436,  6441,  6446,  6451,  6457,  6465,
    6473,  6483,  6489,  6494,  6501,  6507,  6515,  6523,  6531,  6534,
    6538,  6542,  6546,  6551,  6552,  6557,  6559,  6563,  6567,  6569,
    6571,  6573,  6576,  6579,  6580,  6583,  6588,  6593,  6600,  6603,
    6604,  6606,  6610,  6614,  6617,  6620,  6621,  6628,  6630,  6631,
    6635,  6636,  6639,  6642,  6643,  6645,  6650,  6653,  6656,  6659,
    6662,  6665,  6670,  6674,  6680,  6682,  6684,  6686,  6688,  6690,
    6692,  6694,  6696,  6698,  6700,  6702,  6704,  6706,  6708,  6710,
    6715,  6717,  6722,  6724,  6729,  6731,  6734,  6736,  6739,  6741,
    6745,  6747,  6751,  6753,  6757,  6759,  6763,  6767,  6771,  6774,
    6776,  6780,  6784,  6785,  6787,  6789,  6791,  6793,  6795,  6797,
    6799,  6801,  6806,  6810,  6813,  6817,  6818,  6822,  6826,  6829,
    6832,  6834,  6835,  6838,  6841,  6845,  6848,  6850,  6852,  6856,
    6862,  6864,  6867,  6872,  6875,  6876,  6878,  6879,  6881,  6884,
    6887,  6890,  6894,  6900,  6902,  6905,  6906,  6909,  6911,  6912,
    6914,  6916,  6918,  6922,  6926,  6928,  6932,  6936,  6939,  6941,
    6943,  6945,  6949,  6951,  6954,  6956,  6960,  6962,  6964,  6966,
    6968,  6970,  6972,  6974,  6977,  6979,  6981,  6983,  6985,  6987,
    6990,  6996,  6999,  7003,  7010,  7012,  7014,  7016,  7018,  7020,
    7022,  7024,  7026,  7028,  7031,  7034,  7036,  7038,  7040,  7042,
    7044,  7046,  7048,  7050,  7052,  7054,  7056,  7058,  7060,  7062,
    7064,  7066,  7068,  7070,  7072,  7074,  7076,  7078,  7080,  7082,
    7084,  7086,  7088,  7090,  7092,  7094,  7096,  7098,  7100,  7102,
    7104,  7106,  7108,  7110,  7112,  7114,  7116,  7118,  7120,  7122,
    7124,  7126,  7128,  7130,  7132,  7134,  7136,  7138,  7140,  7142,
    7144,  7146,  7148,  7150,  7152,  7154,  7156,  7158,  7160,  7162,
    7164,  7166,  7168,  7170,  7172,  7174,  7176,  7178,  7180,  7182,
    7184,  7186,  7188,  7190,  7192,  7194,  7196,  7198,  7200,  7202,
    7204,  7206,  7208,  7210,  7212,  7214,  7216,  7218,  7220,  7222,
    7224,  7226,  7228,  7230,  7232,  7234,  7236,  7238,  7240,  7242,
    7244,  7246,  7248,  7250,  7252,  7254,  7256,  7258,  7260,  7262,
    7264,  7266,  7268,  7270,  7272,  7274,  7276,  7278,  7280,  7282,
    7284,  7286,  7288,  7290,  7292,  7294,  7296,  7298,  7300,  7302,
    7304,  7306,  7308,  7310,  7312,  7314,  7316,  7318,  7320,  7322,
    7324,  7326,  7328,  7330,  7332,  7334,  7336,  7338,  7340,  7342,
    7344,  7346,  7348,  7350,  7352,  7354,  7356,  7358,  7360,  7362,
    7364,  7366,  7368,  7370,  7372,  7374,  7376,  7378,  7380,  7382,
    7384,  7386,  7388,  7390,  7392,  7394,  7396,  7398,  7400,  7402,
    7404,  7406,  7408,  7410,  7412,  7414,  7416,  7418,  7420,  7422,
    7424,  7426,  7428,  7430,  7432,  7434,  7436,  7438,  7440,  7442,
    7444,  7446,  7448,  7450,  7452,  7454,  7456,  7458,  7460,  7462,
    7464,  7466,  7468,  7470,  7472,  7474,  7476,  7478,  7480,  7482,
    7484,  7486,  7488,  7490,  7492,  7494,  7496,  7498,  7500,  7502,
    7504,  7506,  7508,  7510,  7512,  7514,  7516,  7518,  7520,  7522,
    7524,  7526,  7528,  7530,  7532,  7534,  7536,  7538,  7540,  7542,
    7544,  7546,  7548,  7550,  7552,  7554,  7556,  7558,  7560,  7562,
    7564,  7566,  7568,  7570,  7572,  7574,  7576,  7578,  7580,  7582,
    7584,  7586,  7588,  7590,  7592,  7594,  7596,  7598,  7600,  7602,
    7604,  7606,  7608,  7610,  7612,  7614,  7616,  7618,  7620,  7622,
    7624,  7626,  7628,  7630,  7632,  7634,  7636,  7638,  7640,  7642,
    7644,  7646,  7648,  7650,  7652,  7654,  7656,  7658,  7660,  7662,
    7664,  7666,  7668,  7670,  7672,  7674,  7676,  7678,  7680,  7682,
    7684,  7686,  7688,  7690,  7692,  7694,  7696,  7698,  7700,  7702,
    7704,  7706,  7708,  7710,  7712,  7714,  7716,  7718,  7720,  7722,
    7724,  7726,  7728,  7730,  7732,  7734,  7736,  7738,  7740,  7742,
    7744,  7746,  7748,  7750,  7752,  7754,  7756,  7758,  7760,  7762,
    7764,  7766,  7768,  7770,  7772,  7774,  7776,  7778,  7780,  7782,
    7784,  7786,  7788,  7790,  7792,  7794,  7796,  7798,  7800,  7802,
    7804,  7806,  7808,  7810,  7812,  7814,  7816,  7817,  7820,  7825,
    7829,  7832,  7834,  7836,  7838,  7840,  7842,  7843,  7852,  7855,
    7861,  7865,  7868,  7871,  7875,  7883,  7885,  7887,  7889,  7890,
    7893,  7896,  7898,  7899,  7901,  7905,  7907,  7910,  7911,  7914,
    7915,  7918,  7919,  7921,  7925,  7930,  7934,  7936,  7938,  7940,
    7942,  7945,  7946,  7949,  7954,  7955,  7958,  7961,  7964,  7966,
    7968,  7976,  7980,  7982,  7984,  7986,  7988,  7991,  7992,  7994,
    7998,  8002,  8006,  8010,  8011,  8016,  8022,  8028,  8029,  8031,
    8033,  8035,  8038,  8041,  8043,  8046,  8047,  8055,  8056,  8062,
    8063,  8068,  8071,  8074,  8075,  8078,  8080,  8082,  8084,  8086,
    8088,  8090,  8092,  8094,  8096,  8098,  8100,  8106,  8109,  8111,
    8115,  8118,  8121,  8125,  8126,  8132,  8134,  8135,  8141,  8144,
    8147,  8149,  8151,  8153,  8156,  8159,  8163,  8165,  8168,  8171,
    8175,  8179,  8184,  8187,  8189,  8192,  8194,  8196,  8199,  8202,
    8206,  8208,  8210,  8212,  8214,  8215,  8217,  8221,  8227,  8228,
    8231,  8232,  8234,  8237,  8241,  8244,  8246,  8248,  8250,  8251,
    8253,  8255,  8257,  8259,  8261,  8264,  8267,  8271,  8272,  8274,
    8277,  8279,  8284,  8288,  8293,  8297,  8300,  8302,  8306,  8308,
    8310,  8312,  8314,  8317,  8320,  8322,  8325,  8328,  8330,  8332,
    8334,  8339,  8344,  8349,  8354,  8359,  8361,  8362,  8366,  8370,
    8375,  8377,  8381,  8385,  8390,  8392,  8396,  8400,  8402,  8404,
    8406,  8413,  8415,  8419,  8423,  8430,  8432,  8436,  8440,  8442,
    8444,  8447,  8450,  8452,  8454,  8456,  8458,  8460,  8462,  8464,
    8466,  8468,  8470,  8472,  8474,  8476,  8478,  8480,  8482,  8487,
    8492,  8494,  8496,  8501,  8506,  8510,  8511,  8519,  8521,  8522,
    8523,  8531,  8535,  8540,  8544,  8546,  8548,  8550,  8553,  8557,
    8563,  8566,  8572,  8575,  8577,  8579,  8581,  8583,  8585,  8587,
    8589,  8591,  8593,  8595,  8597,  8599,  8601,  8603,  8605,  8607,
    8609,  8611,  8613,  8615,  8617,  8619,  8621,  8623,  8625,  8627,
    8629,  8631,  8633,  8635,  8637,  8639,  8641,  8643,  8645,  8647,
    8649,  8651,  8653,  8655,  8657,  8659,  8661,  8663,  8665,  8667,
    8669,  8671,  8673,  8675,  8677,  8679,  8681,  8683,  8685,  8687,
    8689,  8691,  8693,  8695,  8697,  8699,  8701,  8703,  8705,  8707,
    8709,  8711,  8713,  8715,  8717,  8719,  8721,  8723,  8725,  8727,
    8729,  8731,  8733,  8735,  8737,  8739,  8741,  8743,  8745,  8747,
    8749,  8751,  8753,  8755,  8757,  8759,  8761,  8763,  8765,  8767,
    8769,  8771,  8775,  8777,  8778,  8780,  8783,  8785,  8788,  8790,
    8792,  8794,  8797,  8800,  8802,  8804,  8806,  8808,  8810,  8812,
    8814,  8816,  8818,  8820,  8822,  8824,  8826,  8828,  8830,  8832,
    8835,  8839,  8841,  8844,  8846,  8850,  8852,  8856,  8858,  8860,
    8862,  8864,  8866,  8868,  8870,  8872,  8874,  8876,  8878,  8880,
    8882,  8884,  8886,  8888,  8890,  8892,  8894,  8896,  8898,  8900,
    8902,  8904,  8906,  8908,  8910,  8912,  8914,  8916,  8918,  8920,
    8922,  8924,  8926,  8928,  8930,  8932,  8934,  8936,  8938,  8940,
    8942,  8944,  8946,  8948,  8950,  8952,  8954,  8956,  8958,  8960,
    8962,  8964,  8966,  8968,  8970,  8972,  8974,  8976,  8978,  8981,
    8985,  8988,  8992,  8994,  8998,  9002,  9006,  9010,  9014,  9018,
    9020,  9022,  9023,  9026,  9029,  9031,  9033,  9036,  9038,  9040,
    9042,  9043
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     521,     0,    -1,  1075,    -1,   850,    -1,   851,    -1,   768,
      -1,   856,    -1,   719,    -1,   659,    -1,   662,    -1,   668,
      -1,   682,    -1,   687,    -1,   803,    -1,   538,    -1,   878,
      -1,   824,    -1,   825,    -1,   638,    -1,   563,    -1,   574,
      -1,   532,    -1,   530,    -1,   859,    -1,   858,    -1,   691,
      -1,   534,    -1,   533,    -1,   866,    -1,   872,    -1,   561,
      -1,   890,    -1,   577,    -1,   861,    -1,   742,    -1,   558,
      -1,   578,    -1,  1077,    -1,   706,    -1,   814,    -1,   860,
      -1,   855,    -1,   656,    -1,   663,    -1,   677,    -1,   683,
      -1,   784,    -1,   537,    -1,   880,    -1,   874,    -1,   720,
      -1,   727,    -1,   728,    -1,   645,    -1,   541,    -1,   637,
      -1,   593,    -1,   653,    -1,   692,    -1,   523,    -1,   529,
      -1,   688,    -1,   846,    -1,  1218,    -1,   916,    -1,   708,
      -1,   903,    -1,   562,    -1,   811,    -1,   707,    -1,   816,
      -1,   667,    -1,   681,    -1,   540,    -1,   881,    -1,   879,
      -1,   731,    -1,   732,    -1,   733,    -1,   651,    -1,   833,
      -1,   735,    -1,   655,    -1,   705,    -1,   535,    -1,   536,
      -1,   690,    -1,   854,    -1,   896,    -1,   888,    -1,   882,
      -1,   749,    -1,   753,    -1,   764,    -1,   773,    -1,   898,
      -1,   836,    -1,   845,    -1,   905,    -1,   834,    -1,   893,
      -1,   734,    -1,   818,    -1,   807,    -1,   806,    -1,   808,
      -1,   821,    -1,   754,    -1,   765,    -1,   826,    -1,   745,
      -1,   920,    -1,   838,    -1,   740,    -1,   837,    -1,   909,
      -1,   863,    -1,   555,    -1,   545,    -1,   557,    -1,   843,
      -1,  1154,    -1,  1080,    -1,  1097,    -1,  1155,    -1,  1137,
      -1,  1152,    -1,  1138,    -1,  1098,    -1,  1142,    -1,  1164,
      -1,  1156,    -1,  1143,    -1,  1172,    -1,  1174,    -1,  1167,
      -1,  1159,    -1,  1175,    -1,  1178,    -1,  1180,    -1,    -1,
     163,   388,  1069,   524,   525,    -1,   478,    -1,    -1,   525,
     528,    -1,    -1,   526,   527,    -1,    -1,   348,  1208,    -1,
     348,   321,    -1,   207,   348,  1208,    -1,   451,   348,  1208,
      -1,   258,    -1,   154,   290,  1070,    -1,   462,   457,  1208,
      -1,   459,  1059,    -1,   379,    -1,  1210,    -1,   527,    -1,
     427,  1068,    -1,    96,  1059,    -1,   388,  1059,    -1,   253,
     388,  1059,    -1,   253,   240,  1059,    -1,   163,   459,  1069,
     524,   525,    -1,   101,   388,  1069,   524,   526,    -1,    -1,
     253,   177,  1061,    -1,   101,   388,  1069,   531,   556,    -1,
     101,   459,  1069,   524,   526,    -1,   101,   459,  1069,   556,
      -1,   202,   388,  1059,    -1,   202,   388,   248,   216,  1059,
      -1,   202,   459,  1059,    -1,   202,   459,   248,   216,  1059,
      -1,   163,   240,  1069,   524,   525,    -1,   101,   240,  1069,
     539,   459,  1059,    -1,    95,    -1,   202,    -1,   202,   240,
    1059,    -1,   202,   240,   248,   216,  1059,    -1,   163,   395,
     542,   115,  1069,   543,    -1,   163,   395,  1188,   543,    -1,
    1188,    -1,    -1,   543,   544,    -1,    -1,   593,    -1,   773,
      -1,   637,    -1,   692,    -1,   753,    -1,   843,    -1,   407,
     546,    -1,   407,   293,   546,    -1,   407,   405,   546,    -1,
     547,   439,   548,    -1,   547,   499,   548,    -1,   547,   439,
     183,    -1,   547,   499,   183,    -1,   547,   232,   166,    -1,
     437,   495,   552,    -1,   441,   841,    -1,   405,   137,   108,
     441,   841,    -1,   133,  1208,    -1,   395,  1208,    -1,   308,
     553,    -1,   388,   554,    -1,   405,   115,   554,    -1,   405,
     115,   183,    -1,   483,   333,  1006,    -1,  1187,    -1,   547,
     514,  1188,    -1,   549,    -1,   548,   515,   549,    -1,   551,
      -1,   643,    -1,   365,   450,    -1,   365,   151,    -1,   376,
     365,    -1,   403,    -1,   445,    -1,   221,    -1,   330,    -1,
     554,    -1,  1208,    -1,  1210,    -1,   993,  1208,   995,    -1,
     993,   512,  1068,   513,  1208,   995,    -1,   643,    -1,   183,
      -1,   293,    -1,  1208,    -1,   183,    -1,    -1,  1188,    -1,
    1208,    -1,   380,   547,    -1,   380,   437,   495,    -1,   380,
     441,   276,   288,    -1,   380,   405,   115,    -1,   380,    99,
      -1,   407,   546,    -1,   555,    -1,   410,   547,  1221,    -1,
     410,   437,   495,  1221,    -1,   410,   441,   276,   288,  1221,
      -1,   410,   405,   115,  1221,    -1,   410,    99,    -1,   407,
     156,   559,   560,    -1,    99,    -1,  1057,    -1,   186,    -1,
     250,    -1,   139,    -1,   195,    99,    -1,   195,   432,    -1,
     195,   434,    -1,   195,   350,    -1,   101,   429,   964,   564,
      -1,   101,   256,  1058,   564,    -1,   101,   401,  1058,   564,
      -1,   101,   472,  1058,   564,    -1,   565,    -1,   564,   515,
     565,    -1,    95,   601,    -1,    95,   147,   601,    -1,   101,
     822,  1188,   566,    -1,   101,   822,  1188,   202,   316,   321,
      -1,   101,   822,  1188,   407,   316,   321,    -1,   101,   822,
    1188,   407,   419,  1070,    -1,   101,   822,  1188,   407,   570,
      -1,   101,   822,  1188,   380,   570,    -1,   101,   822,  1188,
     407,   422,  1188,    -1,   202,   822,   248,   216,  1188,   567,
      -1,   202,   822,  1188,   567,    -1,   101,   822,  1188,   823,
     448,   973,   568,   569,    -1,    95,   610,    -1,   463,   155,
    1060,    -1,   202,   155,   248,   216,  1060,   567,    -1,   202,
     155,  1060,   567,    -1,   407,   478,   329,    -1,   407,   479,
     329,    -1,   143,   330,  1060,    -1,   407,   479,   143,    -1,
     205,   443,  1060,    -1,   205,   102,   443,  1060,    -1,   205,
     378,   443,  1060,    -1,   205,   443,    99,    -1,   205,   443,
     459,    -1,   194,   443,  1060,    -1,   194,   443,    99,    -1,
     194,   443,   459,    -1,   205,   393,  1060,    -1,   205,   102,
     393,  1060,    -1,   205,   378,   393,  1060,    -1,   194,   393,
    1060,    -1,   258,  1058,    -1,   313,   258,  1058,    -1,   326,
     738,    -1,   316,   326,    -1,   343,   439,  1069,    -1,   407,
     431,  1060,    -1,   407,   570,    -1,   380,   570,    -1,   671,
      -1,   407,   183,   997,    -1,   202,   183,    -1,   129,    -1,
     382,    -1,    -1,   145,   738,    -1,    -1,   460,   997,    -1,
      -1,   512,   572,   513,    -1,   478,   570,    -1,    -1,   573,
      -1,   572,   515,   573,    -1,  1190,   499,   712,    -1,  1190,
      -1,  1190,   514,  1190,   499,   712,    -1,  1190,   514,  1190,
      -1,   101,   448,   738,   575,    -1,   576,    -1,   575,   515,
     576,    -1,    95,   114,   972,   567,    -1,   202,   114,   248,
     216,  1188,   567,    -1,   202,   114,  1188,   567,    -1,   101,
     114,  1188,   823,   448,   973,   568,   567,    -1,   142,   917,
      -1,   142,    99,    -1,   161,   584,  1058,   612,   585,   579,
     580,   586,   524,   581,    -1,   161,   921,   439,   580,   524,
     581,    -1,   232,    -1,   439,    -1,  1208,    -1,   420,    -1,
     421,    -1,   582,    -1,   512,   588,   513,    -1,   582,   583,
      -1,    -1,   122,    -1,   329,    -1,   189,   857,  1208,    -1,
     321,   857,  1208,    -1,   165,    -1,   244,    -1,   363,   857,
    1208,    -1,   210,   857,  1208,    -1,   228,   363,   613,    -1,
     228,   363,   505,    -1,   228,   316,   321,   613,    -1,   206,
    1208,    -1,   122,    -1,    -1,   478,   329,    -1,    -1,   587,
     190,  1208,    -1,    -1,   460,    -1,    -1,   589,    -1,   588,
     515,   589,    -1,  1190,   590,    -1,   551,    -1,   643,    -1,
     505,    -1,   512,   591,   513,    -1,    -1,   592,    -1,   591,
     515,   592,    -1,   551,    -1,   163,   594,   429,  1058,   512,
     595,   513,   623,   624,   625,   626,   628,   629,    -1,   163,
     594,   429,   248,   316,   216,  1058,   512,   595,   513,   623,
     624,   625,   626,   628,   629,    -1,   163,   594,   429,  1058,
     326,   738,   596,   624,   625,   626,   628,   629,    -1,   163,
     594,   429,   248,   316,   216,  1058,   326,   738,   596,   624,
     625,   626,   628,   629,    -1,   434,    -1,   432,    -1,   293,
     434,    -1,   293,   432,    -1,   236,   434,    -1,   236,   432,
      -1,   456,    -1,    -1,   597,    -1,    -1,   512,   598,   513,
      -1,    -1,   599,    -1,   597,   515,   599,    -1,   600,    -1,
     598,   515,   600,    -1,   601,    -1,   607,    -1,   610,    -1,
     602,    -1,   610,    -1,  1188,   973,   603,    -1,  1188,   478,
     334,   603,    -1,   603,   604,    -1,    -1,   155,  1060,   605,
      -1,   605,    -1,   606,    -1,   145,   738,    -1,   316,   321,
      -1,   321,    -1,   453,   800,   630,    -1,   358,   278,   800,
     630,    -1,   138,   512,   997,   513,    -1,   183,   998,    -1,
     371,  1058,   612,   615,   619,    -1,   185,    -1,   316,   185,
      -1,   260,   186,    -1,   260,   250,    -1,   289,  1058,   608,
      -1,   608,   254,   609,    -1,   608,   213,   609,    -1,    -1,
     184,    -1,   156,    -1,   257,    -1,   422,    -1,   149,    -1,
      99,    -1,   155,  1060,   611,    -1,   611,    -1,   138,   512,
     997,   513,   703,    -1,   453,   512,   613,   513,   800,   630,
     703,    -1,   453,   631,   703,    -1,   358,   278,   512,   613,
     513,   800,   630,   703,    -1,   358,   278,   631,   703,    -1,
     212,   777,   512,   616,   513,   800,   630,   618,   703,    -1,
     229,   278,   512,   613,   513,   371,  1058,   612,   615,   619,
     703,    -1,   512,   613,   513,    -1,    -1,   614,    -1,   613,
     515,   614,    -1,  1188,    -1,   299,   233,    -1,   299,   345,
      -1,   299,   412,    -1,    -1,   617,    -1,   616,   515,   617,
      -1,   779,   478,   810,    -1,   779,   478,   332,   512,   810,
     513,    -1,   475,   512,   997,   513,    -1,    -1,   620,    -1,
     621,    -1,   620,   621,    -1,   621,   620,    -1,    -1,   330,
     458,   622,    -1,   330,   188,   622,    -1,   313,    94,    -1,
     382,    -1,   129,    -1,   407,   321,    -1,   407,   183,    -1,
     259,   512,  1057,   513,    -1,    -1,   478,   570,    -1,   478,
     329,    -1,   479,   329,    -1,    -1,   330,   150,   202,    -1,
     330,   150,   188,   392,    -1,   330,   150,   355,   392,    -1,
      -1,   431,  1060,    -1,    -1,   197,   126,    -1,   197,   126,
     242,    -1,   627,   512,  1060,   513,    -1,   197,   126,   304,
     512,  1060,   513,    -1,   197,   126,   379,    -1,   197,   126,
     390,   387,    -1,    -1,   439,   314,   877,    -1,   439,   240,
     876,    -1,    -1,   460,   256,   431,  1060,    -1,    -1,   460,
     256,  1064,    -1,  1058,   633,   624,   625,   626,   628,   629,
      -1,   512,   634,   513,    -1,    -1,   635,    -1,   634,   515,
     635,    -1,  1188,    -1,   478,   176,    -1,   478,   313,   176,
      -1,    -1,   163,   594,   401,  1058,   639,    -1,   101,   401,
    1058,   640,    -1,   640,    -1,    -1,   641,    -1,   640,   641,
      -1,   127,   643,    -1,   175,    -1,   313,   175,    -1,   255,
     642,   643,    -1,   300,   643,    -1,   302,   643,    -1,   313,
     300,    -1,   313,   302,    -1,   342,   126,   738,    -1,   417,
     524,   643,    -1,   381,    -1,   381,   524,   643,    -1,   126,
      -1,    -1,  1207,    -1,   504,  1207,    -1,  1070,    -1,   643,
      -1,   644,   515,   643,    -1,   163,   785,   646,   652,   280,
     554,    -1,   163,   785,   646,   652,   280,   554,   241,   647,
     648,   650,    -1,   447,    -1,    -1,  1060,    -1,  1060,   739,
      -1,   261,   647,    -1,    -1,   464,   647,    -1,   313,   464,
      -1,   649,    -1,    -1,   202,   652,   280,   554,   567,    -1,
     202,   652,   280,   248,   216,   554,   567,    -1,   361,    -1,
      -1,   163,   431,  1060,   654,   296,  1208,    -1,   343,  1060,
      -1,    -1,   202,   431,  1060,    -1,   202,   431,   248,   216,
    1060,    -1,   163,   218,  1060,   524,   657,    -1,   163,   218,
     248,   316,   216,  1060,   524,   657,    -1,   657,   658,    -1,
      -1,   395,  1060,    -1,   471,   554,    -1,   232,   554,    -1,
     101,   218,  1060,   458,   660,    -1,   660,   661,    -1,    -1,
     439,   554,    -1,   101,   218,  1060,   539,    98,  1066,   713,
      -1,   101,   218,  1060,   539,   132,   512,   973,   108,   973,
     513,    -1,   101,   218,  1060,   539,   146,   738,    -1,   101,
     218,  1060,   539,   159,   738,    -1,   101,   218,  1060,   539,
     200,   738,    -1,   101,   218,  1060,   539,   234,   763,    -1,
     101,   218,  1060,   539,   652,   280,  1060,    -1,   101,   218,
    1060,   539,   332,   810,   809,    -1,   101,   218,  1060,   539,
     332,   140,   738,   460,  1062,    -1,   101,   218,  1060,   539,
     332,   222,   738,   460,  1062,    -1,   101,   218,  1060,   539,
     395,  1060,    -1,   101,   218,  1060,   539,   429,   738,    -1,
     101,   218,  1060,   539,   435,   397,   344,   738,    -1,   101,
     218,  1060,   539,   435,   397,   192,   738,    -1,   101,   218,
    1060,   539,   435,   397,   433,   738,    -1,   101,   218,  1060,
     539,   435,   397,   153,   738,    -1,   101,   218,  1060,   539,
     401,   738,    -1,   101,   218,  1060,   539,   472,   738,    -1,
     101,   218,  1060,   539,   229,   429,   738,    -1,   101,   218,
    1060,   539,   229,   176,   481,  1060,    -1,   101,   218,  1060,
     539,   404,  1060,    -1,   101,   218,  1060,   539,   448,   738,
      -1,   163,   229,   176,   481,  1060,   666,   669,    -1,   241,
     647,    -1,   313,   241,    -1,   464,   647,    -1,   313,   464,
      -1,   664,    -1,   665,   664,    -1,   665,    -1,    -1,   202,
     229,   176,   481,  1060,   567,    -1,   202,   229,   176,   481,
     248,   216,  1060,   567,    -1,   101,   229,   176,   481,  1060,
     666,   671,    -1,   101,   229,   176,   481,  1060,   665,    -1,
     334,   512,   670,   513,    -1,    -1,   674,    -1,   670,   515,
     674,    -1,   334,   512,   672,   513,    -1,   673,    -1,   672,
     515,   673,    -1,   674,    -1,   407,   674,    -1,    95,   674,
      -1,   202,   675,    -1,   675,   676,    -1,  1190,    -1,  1208,
      -1,   163,   404,  1060,   678,   680,   229,   176,   481,  1060,
     669,    -1,   448,  1208,    -1,    -1,   471,  1208,    -1,   471,
     321,    -1,   679,    -1,    -1,   202,   404,  1060,   567,    -1,
     202,   404,   248,   216,  1060,   567,    -1,   101,   404,  1060,
     679,   671,    -1,   101,   404,  1060,   679,    -1,   101,   404,
    1060,   671,    -1,   163,   229,   429,  1058,   684,   404,  1060,
     669,    -1,   163,   229,   429,   248,   316,   216,  1058,   684,
     404,  1060,   669,    -1,   512,   685,   513,    -1,   512,   513,
      -1,   686,    -1,   685,   515,   686,    -1,   601,    -1,   101,
     229,   429,   964,   564,    -1,   163,   459,   298,   227,   689,
     404,  1060,   669,    -1,   173,    -1,   459,    -1,  1069,    -1,
     202,   459,   298,   227,   689,   404,  1060,    -1,   202,   459,
     298,   248,   216,   227,   689,   404,  1060,    -1,   101,   459,
     298,   227,   689,   404,  1060,   671,    -1,   163,   443,  1060,
     693,   694,   330,  1058,   696,   699,   215,   362,  1066,   512,
     700,   513,    -1,   163,   155,   443,  1060,    97,   694,   330,
    1058,   702,   703,   227,   203,   391,   699,   215,   362,  1066,
     512,   700,   513,    -1,   118,    -1,    97,    -1,   267,   326,
      -1,   695,    -1,   694,   335,   695,    -1,   266,    -1,   188,
      -1,   458,    -1,   458,   326,   613,    -1,   446,    -1,   227,
     697,   698,    -1,    -1,   203,    -1,    -1,   391,    -1,   418,
      -1,   474,   512,   997,   513,    -1,    -1,   701,    -1,   700,
     515,   701,    -1,    -1,  1068,    -1,  1207,    -1,  1208,    -1,
    1190,    -1,   232,  1058,    -1,    -1,    -1,   703,   704,    -1,
     316,   185,    -1,   185,    -1,   260,   250,    -1,   260,   186,
      -1,   316,   462,    -1,   202,   443,  1060,   330,  1058,   567,
      -1,   202,   443,   248,   216,  1060,   330,  1058,   567,    -1,
     163,   110,  1060,   138,   512,   997,   513,   703,    -1,   202,
     110,  1060,   567,    -1,   163,    98,  1066,   713,   709,    -1,
     163,    98,  1066,   714,    -1,   163,   332,   810,   709,    -1,
     163,   448,   738,   709,    -1,   163,   448,   738,    -1,   163,
     448,   738,   108,   512,   970,   513,    -1,   163,   448,   738,
     108,   209,   512,   717,   513,    -1,   163,   435,   397,   344,
     738,   709,    -1,   163,   435,   397,   192,   738,   709,    -1,
     163,   435,   397,   433,   738,   709,    -1,   163,   435,   397,
     153,   738,   709,    -1,   163,   146,   738,   709,    -1,   163,
     146,   738,   232,   738,    -1,   512,   710,   513,    -1,   711,
      -1,   710,   515,   711,    -1,  1190,   499,   712,    -1,  1190,
      -1,   794,    -1,  1074,    -1,  1024,    -1,   643,    -1,  1208,
      -1,   512,  1029,   513,    -1,   512,   505,   513,    -1,   512,
     715,   513,    -1,   716,    -1,   715,   515,   716,    -1,  1210,
     499,   712,    -1,   718,    -1,    -1,  1208,    -1,   718,   515,
    1208,    -1,   101,   448,   738,    95,   465,  1208,    -1,   101,
     448,   738,    95,   465,  1208,   118,  1208,    -1,   101,   448,
     738,    95,   465,  1208,    97,  1208,    -1,   163,   332,   140,
     738,   723,   227,   448,   973,   460,  1062,   724,   108,   721,
      -1,   722,    -1,   721,   515,   722,    -1,   332,  1068,   810,
     725,   726,    -1,   332,  1068,   810,   809,   725,   726,    -1,
     234,  1068,  1066,   786,    -1,   234,  1068,   512,  1029,   513,
    1066,   786,    -1,   422,   973,    -1,   183,    -1,    -1,   222,
     738,    -1,    -1,   227,   397,    -1,   227,   336,   126,   738,
      -1,    -1,   368,    -1,    -1,   163,   332,   222,   738,   460,
    1062,    -1,   101,   332,   222,   738,   460,  1062,    95,   721,
      -1,   101,   332,   222,   738,   460,  1062,   202,   729,    -1,
     730,    -1,   729,   515,   730,    -1,   332,  1068,   512,  1029,
     513,    -1,   234,  1068,   512,  1029,   513,    -1,   202,   332,
     140,   738,   460,  1062,   567,    -1,   202,   332,   140,   248,
     216,   738,   460,  1062,   567,    -1,   202,   332,   222,   738,
     460,  1062,   567,    -1,   202,   332,   222,   248,   216,   738,
     460,  1062,   567,    -1,   202,   342,   126,  1059,   567,    -1,
     367,   342,   126,  1059,   439,  1060,    -1,   202,   736,   248,
     216,   737,   567,    -1,   202,   736,   737,   567,    -1,   429,
      -1,   401,    -1,   472,    -1,   256,    -1,   229,   429,    -1,
     448,    -1,   200,    -1,   146,    -1,   159,    -1,   395,    -1,
     218,    -1,   435,   397,   344,    -1,   435,   397,   192,    -1,
     435,   397,   433,    -1,   435,   397,   153,    -1,   738,    -1,
     737,   515,   738,    -1,  1188,    -1,  1188,   739,    -1,   514,
    1063,    -1,   739,   514,  1063,    -1,   446,   931,   965,   741,
     567,    -1,   158,   247,    -1,   381,   247,    -1,    -1,   148,
     330,   743,   738,   274,   744,    -1,   148,   330,    98,  1066,
     713,   274,   744,    -1,   148,   330,   234,  1066,   786,   274,
     744,    -1,   148,   330,   332,   810,   809,   274,   744,    -1,
     148,   330,   155,  1060,   330,   738,   274,   744,    -1,   148,
     330,   393,  1060,   330,   738,   274,   744,    -1,   148,   330,
     393,  1060,   274,   744,    -1,   148,   330,   443,  1060,   330,
     738,   274,   744,    -1,   148,   330,   332,   140,   738,   460,
    1062,   274,   744,    -1,   148,   330,   332,   222,   738,   460,
    1062,   274,   744,    -1,   148,   330,   281,   325,   643,   274,
     744,    -1,   148,   330,   132,   512,   973,   108,   973,   513,
     274,   744,    -1,   148,   330,   652,   280,   738,   274,   744,
      -1,   148,   330,   435,   397,   344,   738,   274,   744,    -1,
     148,   330,   435,   397,   192,   738,   274,   744,    -1,   148,
     330,   435,   397,   433,   738,   274,   744,    -1,   148,   330,
     435,   397,   153,   738,   274,   744,    -1,   147,    -1,   177,
      -1,   395,    -1,   256,    -1,   401,    -1,   429,    -1,   200,
      -1,   448,    -1,   472,    -1,   146,    -1,   159,    -1,   431,
      -1,   218,    -1,   388,    -1,   229,   429,    -1,   404,    -1,
     229,   176,   481,    -1,  1208,    -1,   321,    -1,   399,   279,
     746,   330,   747,   738,   274,   748,    -1,   399,   279,   746,
     330,    98,  1066,   713,   274,   748,    -1,   399,   279,   746,
     330,   234,  1066,   786,   274,   748,    -1,   399,   279,   746,
     330,   281,   325,   643,   274,   748,    -1,   399,   279,   746,
     330,   652,   280,   738,   274,   748,    -1,   227,   554,    -1,
      -1,   147,    -1,   229,   429,    -1,   395,    -1,   401,    -1,
     429,    -1,   200,    -1,   448,    -1,   472,    -1,  1208,    -1,
     321,    -1,   223,   750,    -1,   306,   750,    -1,   223,   750,
    1222,    -1,   223,   230,   917,  1223,    -1,   223,   230,   751,
     917,  1223,    -1,   223,   116,   917,  1223,    -1,   223,   116,
     751,   917,  1223,    -1,   306,   230,   917,    -1,   306,   230,
     751,   917,    -1,   306,   116,   917,    -1,   306,   116,   751,
     917,    -1,   917,    -1,   751,   917,    -1,   312,   752,   917,
      -1,   359,   752,   917,    -1,   224,   752,   917,    -1,   282,
     752,   917,    -1,    92,  1070,   752,   917,    -1,   373,  1070,
     752,   917,    -1,  1070,   752,   917,    -1,    99,   752,   917,
      -1,   230,  1070,   752,   917,    -1,   230,    99,   752,   917,
      -1,   116,  1070,   752,   917,    -1,   116,    99,   752,   917,
      -1,   232,    -1,   253,    -1,   751,    -1,    -1,   237,   755,
     330,   758,   439,   759,   761,    -1,   385,   755,   330,   758,
     232,   759,   567,    -1,   385,   237,   333,   227,   755,   330,
     758,   232,   759,   567,    -1,   756,    -1,    99,    -1,    99,
     360,    -1,    99,   512,   613,   513,    -1,    99,   360,   512,
     613,   513,    -1,   757,    -1,   756,   515,   757,    -1,   400,
     612,    -1,   371,   612,    -1,   163,   612,    -1,  1188,   612,
      -1,  1057,    -1,   429,  1057,    -1,   401,  1057,    -1,   229,
     176,   481,  1059,    -1,   229,   404,  1059,    -1,   234,   762,
      -1,   177,  1059,    -1,   280,  1059,    -1,   281,   325,   644,
      -1,   395,  1059,    -1,   431,  1059,    -1,    99,   430,   253,
     395,  1059,    -1,    99,   402,   253,   395,  1059,    -1,    99,
     235,   253,   395,  1059,    -1,   760,    -1,   759,   515,   760,
      -1,  1069,    -1,   240,  1069,    -1,   478,   237,   333,    -1,
      -1,   763,    -1,   762,   515,   763,    -1,  1066,   786,    -1,
     237,   756,   439,  1059,   766,   767,    -1,   385,   756,   232,
    1059,   767,   567,    -1,   385,    96,   333,   227,   756,   232,
    1059,   767,   567,    -1,   478,    96,   333,    -1,    -1,   238,
     126,  1069,    -1,    -1,   101,   183,   360,   769,   771,    -1,
     769,   770,    -1,    -1,   253,   395,  1059,    -1,   227,   388,
    1059,    -1,   227,   459,  1059,    -1,   237,   755,   330,   772,
     439,   759,   761,    -1,   385,   755,   330,   772,   232,   759,
     567,    -1,   385,   237,   333,   227,   755,   330,   772,   232,
     759,   567,    -1,   430,    -1,   235,    -1,   402,    -1,   163,
     774,   256,   775,   776,   330,  1058,   777,   512,   778,   513,
     571,   626,   968,    -1,   453,    -1,    -1,   152,    -1,    -1,
    1064,    -1,    -1,   460,  1062,    -1,    -1,   779,    -1,   778,
     515,   779,    -1,  1188,   780,   781,   782,   783,    -1,  1000,
     780,   781,   782,   783,    -1,   512,   997,   513,   780,   781,
     782,   783,    -1,   145,   738,    -1,    -1,   738,    -1,   460,
     738,    -1,    -1,   109,    -1,   191,    -1,    -1,   496,    -1,
     497,    -1,    -1,   163,   785,   234,  1066,   788,   384,   793,
     796,   800,    -1,   163,   785,   234,  1066,   788,   384,   429,
     512,   802,   513,   796,   800,    -1,   163,   785,   234,  1066,
     788,   796,   800,    -1,   335,   377,    -1,    -1,   512,   787,
     513,    -1,   512,   513,    -1,   790,    -1,   787,   515,   790,
      -1,   512,   789,   513,    -1,   512,   513,    -1,   795,    -1,
     789,   515,   795,    -1,   791,   792,   794,    -1,   792,   791,
     794,    -1,   792,   794,    -1,   791,   794,    -1,   794,    -1,
     253,    -1,   337,    -1,   263,    -1,   253,   337,    -1,   468,
      -1,  1189,    -1,   794,    -1,   973,    -1,  1189,   739,   507,
     448,    -1,   408,  1189,   739,   507,   448,    -1,   790,    -1,
     790,   183,   997,    -1,   790,   499,   997,    -1,   798,    -1,
     796,   798,    -1,   128,   330,   321,   264,    -1,   384,   321,
     330,   321,   264,    -1,   423,    -1,   251,    -1,   415,    -1,
     473,    -1,   219,   399,   187,    -1,   219,   399,   273,    -1,
     399,   187,    -1,   399,   273,    -1,   162,   643,    -1,   392,
     643,    -1,   556,    -1,   108,   799,    -1,   280,   554,    -1,
     477,    -1,   797,    -1,  1208,    -1,  1208,   515,  1208,    -1,
     478,   709,    -1,    -1,   792,   794,    -1,   801,    -1,   802,
     515,   801,    -1,   101,   234,   763,   804,   805,    -1,   797,
      -1,   804,   797,    -1,   382,    -1,    -1,   202,   234,  1066,
     786,   567,    -1,   202,   234,   248,   216,  1066,   786,   567,
      -1,   202,    98,  1066,   713,   567,    -1,   202,    98,   248,
     216,  1066,   713,   567,    -1,   202,   332,   810,   809,   567,
      -1,   202,   332,   248,   216,   810,   809,   567,    -1,   512,
     973,   513,    -1,   512,   973,   515,   973,   513,    -1,   512,
     315,   515,   973,   513,    -1,   512,   973,   515,   315,   513,
      -1,  1021,    -1,  1188,   514,   810,    -1,   198,   812,    -1,
     813,    -1,   812,   813,    -1,  1208,    -1,   280,   554,    -1,
     163,   132,   512,   973,   108,   973,   513,   478,   234,   763,
     815,    -1,   163,   132,   512,   973,   108,   973,   513,   479,
     234,   815,    -1,   163,   132,   512,   973,   108,   973,   513,
     478,   263,   815,    -1,   108,   252,    -1,   108,   111,    -1,
      -1,   202,   132,   817,   512,   973,   108,   973,   513,   567,
      -1,   248,   216,    -1,    -1,   372,   819,  1058,   820,    -1,
     372,   428,  1060,   820,    -1,   372,   177,  1060,   820,    -1,
     256,    -1,   429,    -1,   228,    -1,    -1,   101,    98,  1066,
     713,   375,   439,  1060,    -1,   101,   146,   738,   375,   439,
    1060,    -1,   101,   159,   738,   375,   439,  1060,    -1,   101,
     177,  1061,   375,   439,  1061,    -1,   101,   234,   763,   375,
     439,  1060,    -1,   101,   240,  1069,   375,   439,  1069,    -1,
     101,   652,   280,  1060,   375,   439,  1060,    -1,   101,   332,
     140,   738,   460,  1062,   375,   439,  1060,    -1,   101,   332,
     222,   738,   460,  1062,   375,   439,  1060,    -1,   101,   395,
    1060,   375,   439,  1060,    -1,   101,   429,   964,   375,   439,
    1060,    -1,   101,   401,  1058,   375,   439,  1060,    -1,   101,
     472,  1058,   375,   439,  1060,    -1,   101,   256,  1058,   375,
     439,  1060,    -1,   101,   229,   429,   964,   375,   439,  1060,
      -1,   101,   429,   964,   375,   822,  1060,   439,  1060,    -1,
     101,   229,   429,   964,   375,   822,  1060,   439,  1060,    -1,
     101,   443,  1060,   330,  1058,   375,   439,  1060,    -1,   101,
     388,  1069,   375,   439,  1069,    -1,   101,   459,  1069,   375,
     439,  1069,    -1,   101,   431,  1060,   375,   439,  1060,    -1,
     101,   431,  1060,   407,   570,    -1,   101,   431,  1060,   380,
     570,    -1,   101,   435,   397,   344,   738,   375,   439,  1060,
      -1,   101,   435,   397,   192,   738,   375,   439,  1060,    -1,
     101,   435,   397,   433,   738,   375,   439,  1060,    -1,   101,
     435,   397,   153,   738,   375,   439,  1060,    -1,   101,   448,
     738,   375,   439,  1060,    -1,   101,   448,   738,   375,   114,
    1060,   439,  1060,   567,    -1,   147,    -1,    -1,   407,   176,
      -1,    -1,   101,    98,  1066,   713,   407,   395,  1060,    -1,
     101,   146,   738,   407,   395,  1060,    -1,   101,   159,   738,
     407,   395,  1060,    -1,   101,   200,   738,   407,   395,  1060,
      -1,   101,   218,   738,   407,   395,  1060,    -1,   101,   234,
     763,   407,   395,  1060,    -1,   101,   332,   810,   809,   407,
     395,  1060,    -1,   101,   332,   140,   738,   460,  1062,   407,
     395,  1060,    -1,   101,   332,   222,   738,   460,  1062,   407,
     395,  1060,    -1,   101,   429,   964,   407,   395,  1060,    -1,
     101,   435,   397,   344,   738,   407,   395,  1060,    -1,   101,
     435,   397,   192,   738,   407,   395,  1060,    -1,   101,   435,
     397,   433,   738,   407,   395,  1060,    -1,   101,   435,   397,
     153,   738,   407,   395,  1060,    -1,   101,   401,  1058,   407,
     395,  1060,    -1,   101,   472,  1058,   407,   395,  1060,    -1,
     101,   229,   429,   964,   407,   395,  1060,    -1,   101,   448,
     738,   407,   395,  1060,    -1,   101,    98,  1066,   713,   343,
     439,  1069,    -1,   101,   146,   738,   343,   439,  1069,    -1,
     101,   159,   738,   343,   439,  1069,    -1,   101,   177,  1061,
     343,   439,  1069,    -1,   101,   200,   738,   343,   439,  1069,
      -1,   101,   234,   763,   343,   439,  1069,    -1,   101,   652,
     280,  1060,   343,   439,  1069,    -1,   101,   281,   325,   643,
     343,   439,  1069,    -1,   101,   332,   810,   809,   343,   439,
    1069,    -1,   101,   332,   140,   738,   460,  1062,   343,   439,
    1069,    -1,   101,   332,   222,   738,   460,  1062,   343,   439,
    1069,    -1,   101,   395,  1060,   343,   439,  1069,    -1,   101,
     448,   738,   343,   439,  1069,    -1,   101,   431,  1060,   343,
     439,  1069,    -1,   101,   435,   397,   192,   738,   343,   439,
    1069,    -1,   101,   435,   397,   153,   738,   343,   439,  1069,
      -1,   101,   229,   176,   481,  1060,   343,   439,  1069,    -1,
     101,   404,  1060,   343,   439,  1069,    -1,   163,   785,   393,
    1060,   108,   330,   831,   439,  1058,   968,   198,   832,   827,
      -1,   317,    -1,   829,    -1,   512,   828,   513,    -1,   828,
     516,   830,    -1,   830,    -1,   920,    -1,   898,    -1,   909,
      -1,   903,    -1,   834,    -1,   829,    -1,    -1,   400,    -1,
     458,    -1,   188,    -1,   266,    -1,   267,    -1,   100,    -1,
      -1,   202,   393,  1060,   330,  1058,   567,    -1,   202,   393,
     248,   216,  1060,   330,  1058,   567,    -1,   318,  1188,   835,
      -1,   515,  1208,    -1,    -1,   291,  1188,    -1,   455,  1188,
      -1,   455,   505,    -1,    91,   839,    -1,   119,   839,   842,
      -1,   417,   441,   842,    -1,   150,   839,    -1,   208,   839,
      -1,   389,   839,    -1,   394,  1188,    -1,   374,   394,  1188,
      -1,   374,  1188,    -1,   389,   839,   439,   394,  1188,    -1,
     389,   839,   439,  1188,    -1,   356,   441,  1208,    -1,   150,
     357,  1208,    -1,   389,   357,  1208,    -1,   480,    -1,   441,
      -1,    -1,   276,   288,   550,    -1,   365,   331,    -1,   365,
     482,    -1,   185,    -1,   316,   185,    -1,   840,    -1,   841,
     515,   840,    -1,   841,   840,    -1,   841,    -1,    -1,   163,
     594,   472,  1058,   612,   108,   920,   844,    -1,   163,   335,
     377,   594,   472,  1058,   612,   108,   920,   844,    -1,   478,
     138,   333,    -1,   478,   130,   138,   333,    -1,   478,   293,
     138,   333,    -1,    -1,   292,  1065,    -1,   163,   177,  1061,
     524,   847,    -1,   847,   848,    -1,    -1,   431,   849,  1060,
      -1,   431,   849,   183,    -1,   296,   849,  1208,    -1,   296,
     849,   183,    -1,   433,   849,  1060,    -1,   433,   849,   183,
      -1,   206,   849,  1208,    -1,   206,   849,  1068,    -1,   206,
     849,   183,    -1,   283,   849,  1208,    -1,   283,   849,   183,
      -1,   284,   849,  1208,    -1,   284,   849,   183,    -1,   154,
     290,   849,  1070,    -1,   343,   849,  1060,    -1,   343,   849,
     183,    -1,   499,    -1,    -1,   101,   177,  1061,   524,   852,
      -1,   101,   177,  1061,   407,   431,  1060,    -1,   101,   177,
    1061,   556,    -1,   852,   853,    -1,    -1,   154,   290,   849,
    1070,    -1,   202,   177,  1061,    -1,   202,   177,   248,   216,
    1061,    -1,   163,   200,   738,   857,   973,   603,    -1,   101,
     200,   738,   566,    -1,   101,   200,   738,   202,   316,   321,
      -1,   101,   200,   738,   407,   316,   321,    -1,   101,   200,
     738,    95,   610,    -1,   101,   200,   738,   202,   155,  1060,
     567,    -1,   108,    -1,    -1,   101,   435,   397,   192,   738,
     709,    -1,   101,   435,   397,   153,   738,    95,   298,   227,
    1059,   478,   737,    -1,   101,   435,   397,   153,   738,   101,
     298,   227,  1059,   478,   737,    -1,   101,   435,   397,   153,
     738,   101,   298,   377,   738,   478,   738,    -1,   101,   435,
     397,   153,   738,   101,   298,   227,  1059,   377,   738,   478,
     738,    -1,   101,   435,   397,   153,   738,   202,   298,   227,
    1059,    -1,   101,   435,   397,   153,   738,   202,   298,   248,
     216,   227,  1059,    -1,   163,   723,   159,   738,   227,  1208,
     439,  1208,   232,   738,    -1,   143,   868,  1058,   862,    -1,
     143,   868,    -1,   143,   868,  1064,   330,  1058,    -1,   460,
    1064,    -1,    -1,   461,   869,   870,   868,    -1,   461,   869,
     870,   868,  1058,    -1,   461,   869,   870,   868,   866,    -1,
     461,   512,   864,   513,    -1,   461,   512,   864,   513,  1058,
     871,    -1,   865,    -1,   864,   515,   865,    -1,   867,    -1,
     470,    -1,   231,    -1,   233,    -1,   867,   868,    -1,   867,
     868,  1058,   871,    -1,   104,    -1,   103,    -1,   470,    -1,
      -1,   233,    -1,    -1,   231,    -1,    -1,   512,  1059,   513,
      -1,    -1,   163,   117,   873,    -1,  1208,    -1,    -1,   163,
     314,   875,   624,    -1,  1188,    -1,  1188,    -1,   877,   515,
     875,    -1,   875,    -1,   101,   314,   875,   624,    -1,   202,
     314,   875,    -1,   163,   314,   240,   876,   478,   877,    -1,
     202,   314,   240,   876,    -1,   217,   883,    -1,   217,   867,
     868,   883,    -1,   217,   470,   883,    -1,   217,   512,   884,
     513,   883,    -1,   920,    -1,   898,    -1,   909,    -1,   903,
      -1,   916,    -1,  1077,    -1,   896,    -1,   885,    -1,   884,
     515,   885,    -1,   886,   887,    -1,  1188,    -1,   867,    -1,
     470,    -1,   551,    -1,   643,    -1,    -1,   215,   193,   330,
     877,   889,    -1,  1208,    -1,   141,   154,   439,   160,   877,
     891,   892,    -1,   141,   154,   439,   314,   877,   891,   892,
      -1,   141,   154,   439,    99,   820,   891,   892,    -1,   227,
     177,  1061,    -1,   227,  1061,    -1,    -1,   439,   459,  1069,
      -1,   439,  1069,    -1,    -1,   356,  1096,   894,   108,   895,
      -1,   356,  1096,   232,  1141,    -1,   512,  1029,   513,    -1,
      -1,   920,    -1,   898,    -1,   909,    -1,   903,    -1,   215,
    1096,   897,  1220,    -1,   163,   594,   429,   632,   108,   215,
    1096,   897,    -1,   512,  1026,   513,    -1,    -1,   928,   266,
     272,  1058,   899,   902,    -1,   920,    -1,   512,   900,   513,
     920,    -1,   183,   466,    -1,   901,    -1,   900,   515,   901,
      -1,  1188,  1050,    -1,   383,  1055,  1221,    -1,    -1,   928,
     188,   232,   966,   904,   969,   902,    -1,   460,   957,    -1,
      -1,   297,   931,   965,   906,   908,    -1,   253,   907,   303,
      -1,    -1,    93,   409,    -1,   391,   409,    -1,   391,   214,
      -1,   409,   458,   214,    -1,   409,    -1,   409,   391,   214,
      -1,   214,    -1,    93,   214,    -1,   320,    -1,    -1,   928,
     458,   966,   407,   910,   956,   969,   902,    -1,   911,    -1,
     910,   515,   911,    -1,   912,    -1,   913,    -1,   914,   499,
    1052,    -1,   512,   915,   513,   499,  1054,    -1,  1188,  1050,
      -1,   914,    -1,   915,   515,   914,    -1,   182,   917,   918,
     174,   919,   227,   920,    -1,  1060,    -1,  1201,    -1,    -1,
     918,   313,   396,    -1,   918,   396,    -1,   918,   122,    -1,
     918,   265,    -1,    -1,   478,   245,    -1,   479,   245,    -1,
     922,    -1,   921,    -1,   512,   922,   513,    -1,   512,   921,
     513,    -1,   924,    -1,   923,   935,    -1,   923,   934,   950,
     939,    -1,   923,   934,   938,   951,    -1,   925,   923,    -1,
     925,   923,   935,    -1,   925,   923,   934,   950,   939,    -1,
     925,   923,   934,   938,   951,    -1,   924,    -1,   921,    -1,
     400,   933,  1055,   929,   956,   968,   948,   949,  1009,    -1,
     955,    -1,   429,   964,    -1,   923,   452,   932,   923,    -1,
     923,   270,   932,   923,    -1,   923,   211,   932,   923,    -1,
     478,   926,    -1,   478,   369,   926,    -1,   927,    -1,   926,
     515,   927,    -1,  1060,   871,   108,   512,   895,   513,    -1,
     925,    -1,    -1,   272,   930,    -1,  1221,    -1,    -1,   434,
     931,  1058,    -1,   432,   931,  1058,    -1,   293,   434,   931,
    1058,    -1,   293,   432,   931,  1058,    -1,   236,   434,   931,
    1058,    -1,   236,   432,   931,  1058,    -1,   456,   931,  1058,
      -1,   429,  1058,    -1,  1058,    -1,   429,    -1,    -1,    99,
      -1,   196,    -1,    -1,   196,    -1,   196,   330,   512,  1026,
     513,    -1,    99,    -1,    -1,   935,    -1,    -1,   336,   126,
     936,    -1,   937,    -1,   936,   515,   937,    -1,   997,   460,
    1024,   783,    -1,   997,   782,   783,    -1,   940,   941,    -1,
     941,   940,    -1,   940,    -1,   941,    -1,   938,    -1,    -1,
     290,   942,    -1,   290,   942,   515,   943,    -1,   223,   947,
     944,   946,   331,    -1,   328,   943,    -1,   328,   945,   946,
      -1,   997,    -1,    99,    -1,   997,    -1,  1070,    -1,   512,
     997,   513,    -1,    -1,   999,    -1,   391,    -1,   392,    -1,
     224,    -1,   312,    -1,   240,   126,  1026,    -1,    -1,   243,
     997,    -1,    -1,   952,    -1,   227,   365,   331,    -1,   950,
      -1,    -1,   953,    -1,   952,   953,    -1,   227,   458,   954,
     908,    -1,   227,   409,   954,   908,    -1,   326,  1057,    -1,
      -1,   466,  1054,    -1,   955,   515,  1054,    -1,   232,   957,
      -1,    -1,   958,    -1,   957,   515,   958,    -1,   964,    -1,
     964,   960,    -1,   967,    -1,   967,   960,    -1,   967,   108,
     512,   971,   513,    -1,   967,   108,  1188,   512,   971,   513,
      -1,   967,  1188,   512,   971,   513,    -1,   921,    -1,   921,
     960,    -1,   959,    -1,   512,   959,   513,   960,    -1,   512,
     959,   513,    -1,   958,   164,   277,   958,    -1,   958,   961,
     277,   958,   963,    -1,   958,   277,   958,   963,    -1,   958,
     310,   961,   277,   958,    -1,   958,   310,   277,   958,    -1,
     108,  1188,   512,  1059,   513,    -1,   108,  1188,    -1,  1188,
     512,  1059,   513,    -1,  1188,    -1,   233,   962,    -1,   287,
     962,    -1,   386,   962,    -1,   262,    -1,   338,    -1,    -1,
     460,   512,  1059,   513,    -1,   330,   997,    -1,  1058,    -1,
    1058,   505,    -1,   331,  1058,    -1,   331,   512,  1058,   513,
      -1,   964,    -1,   965,   515,   964,    -1,   964,    -1,   964,
    1188,    -1,   964,   108,  1188,    -1,  1000,    -1,   475,   997,
      -1,    -1,   475,   997,    -1,   475,   166,   326,   917,    -1,
      -1,   971,    -1,    -1,   972,    -1,   971,   515,   972,    -1,
    1188,   973,   568,    -1,   975,   974,    -1,   408,   975,   974,
      -1,   975,   107,   510,  1068,   511,    -1,   408,   975,   107,
     510,  1068,   511,    -1,   975,   107,    -1,   408,   975,   107,
      -1,   974,   510,   511,    -1,   974,   510,  1219,   511,    -1,
      -1,   977,    -1,   979,    -1,   981,    -1,   985,    -1,   992,
      -1,   993,   995,    -1,   993,   512,  1068,   513,   995,    -1,
     979,    -1,   982,    -1,   986,    -1,   992,    -1,  1189,   978,
      -1,  1189,   739,   978,    -1,   512,  1026,   513,    -1,    -1,
     268,    -1,   269,    -1,   413,    -1,   121,    -1,   366,    -1,
     225,   980,    -1,   201,   353,    -1,   181,   978,    -1,   180,
     978,    -1,   324,   978,    -1,   124,    -1,   512,  1068,   513,
      -1,    -1,   983,    -1,   984,    -1,   983,    -1,   984,    -1,
     123,   990,   512,  1026,   513,    -1,   123,   990,    -1,   987,
      -1,   988,    -1,   987,    -1,   988,    -1,   989,   512,  1068,
     513,   991,    -1,   989,   991,    -1,   136,   990,    -1,   135,
     990,    -1,   467,    -1,   309,   136,   990,    -1,   309,   135,
     990,    -1,   311,   990,    -1,   469,    -1,    -1,   136,   407,
    1188,    -1,    -1,   438,   512,  1068,   513,   994,    -1,   438,
     994,    -1,   437,   512,  1068,   513,   994,    -1,   437,   994,
      -1,   271,    -1,   498,   495,    -1,   479,   437,   495,    -1,
      -1,   493,    -1,   305,    -1,   178,    -1,   246,    -1,   301,
      -1,   996,    -1,   493,   439,   305,    -1,   178,   439,   246,
      -1,   178,   439,   301,    -1,   178,   439,   996,    -1,   246,
     439,   301,    -1,   246,   439,   996,    -1,   301,   439,   996,
      -1,    -1,   398,    -1,   398,   512,  1068,   513,    -1,   999,
      -1,   997,    88,   973,    -1,   997,   145,   738,    -1,   997,
     113,   437,   495,   997,    -1,   503,   997,    -1,   504,   997,
      -1,   997,   503,   997,    -1,   997,   504,   997,    -1,   997,
     505,   997,    -1,   997,   506,   997,    -1,   997,   507,   997,
      -1,   997,   508,   997,    -1,   997,   500,   997,    -1,   997,
     501,   997,    -1,   997,   499,   997,    -1,   997,  1023,   997,
      -1,  1023,   997,    -1,   997,  1023,    -1,   997,   105,   997,
      -1,   997,   335,   997,    -1,   316,   997,    -1,   997,   289,
     997,    -1,   997,   289,   997,   210,   997,    -1,   997,   316,
     289,   997,    -1,   997,   316,   289,   997,   210,   997,    -1,
     997,   249,   997,    -1,   997,   249,   997,   210,   997,    -1,
     997,   316,   249,   997,    -1,   997,   316,   249,   997,   210,
     997,    -1,   997,   411,   439,   997,    -1,   997,   411,   439,
     997,   210,   997,    -1,   997,   316,   411,   439,   997,    -1,
     997,   316,   411,   439,   997,   210,   997,    -1,   997,   274,
     321,    -1,   997,   275,    -1,   997,   274,   316,   321,    -1,
     997,   319,    -1,  1019,   340,  1019,    -1,   997,   274,   445,
      -1,   997,   274,   316,   445,    -1,   997,   274,   221,    -1,
     997,   274,   316,   221,    -1,   997,   274,   454,    -1,   997,
     274,   316,   454,    -1,   997,   274,   196,   232,   997,    -1,
     997,   274,   316,   196,   232,   997,    -1,   997,   274,   326,
     512,  1029,   513,    -1,   997,   274,   316,   326,   512,  1029,
     513,    -1,   997,   120,  1051,   998,   105,   998,    -1,   997,
     316,   120,  1051,   998,   105,   998,    -1,   997,   120,   426,
     998,   105,   998,    -1,   997,   316,   120,   426,   998,   105,
     998,    -1,   997,   253,  1041,    -1,   997,   316,   253,  1041,
      -1,   997,  1025,  1020,   921,    -1,   997,  1025,  1020,   512,
     997,   513,    -1,   453,   921,    -1,   997,   274,   199,    -1,
     997,   274,   316,   199,    -1,   999,    -1,   998,    88,   973,
      -1,   503,   998,    -1,   504,   998,    -1,   998,   503,   998,
      -1,   998,   504,   998,    -1,   998,   505,   998,    -1,   998,
     506,   998,    -1,   998,   507,   998,    -1,   998,   508,   998,
      -1,   998,   500,   998,    -1,   998,   501,   998,    -1,   998,
     499,   998,    -1,   998,  1023,   998,    -1,  1023,   998,    -1,
     998,  1023,    -1,   998,   274,   196,   232,   998,    -1,   998,
     274,   316,   196,   232,   998,    -1,   998,   274,   326,   512,
    1029,   513,    -1,   998,   274,   316,   326,   512,  1029,   513,
      -1,   998,   274,   199,    -1,   998,   274,   316,   199,    -1,
    1047,    -1,  1067,    -1,  1205,  1050,    -1,   512,   997,   513,
    1050,    -1,  1042,    -1,  1000,    -1,   921,    -1,   216,   921,
      -1,   107,   921,    -1,   107,  1030,    -1,  1019,    -1,  1066,
     512,   513,  1012,    -1,  1066,   512,  1027,   513,  1012,    -1,
    1066,   512,   468,  1028,   513,  1012,    -1,  1066,   512,  1027,
     515,   468,  1028,   513,  1012,    -1,  1066,   512,  1027,   935,
     513,  1012,    -1,  1066,   512,    99,  1027,   934,   513,  1012,
      -1,  1066,   512,   196,  1027,   934,   513,  1012,    -1,  1066,
     512,   505,   513,  1012,    -1,   168,    -1,   171,    -1,   171,
     512,  1068,   513,    -1,   172,    -1,   172,   512,  1068,   513,
      -1,   294,    -1,   294,   512,  1068,   513,    -1,   295,    -1,
     295,   512,  1068,   513,    -1,   169,    -1,   173,    -1,   406,
      -1,   459,    -1,   167,    -1,   170,    -1,   132,   512,   997,
     108,   973,   513,    -1,   220,   512,  1032,   513,    -1,   341,
     512,  1034,   513,    -1,   351,   512,  1036,   513,    -1,   425,
     512,  1037,   513,    -1,   442,   512,   997,   108,   973,   513,
      -1,   444,   512,   125,  1040,   513,    -1,   444,   512,   285,
    1040,   513,    -1,   444,   512,   440,  1040,   513,    -1,   444,
     512,  1040,   513,    -1,   322,   512,   997,   515,   997,   513,
      -1,   144,   512,  1026,   513,    -1,   239,   512,  1026,   513,
      -1,   286,   512,  1026,   513,    -1,   485,   512,  1026,   513,
      -1,   486,   512,   307,  1190,   513,    -1,   486,   512,   307,
    1190,   515,  1003,   513,    -1,   486,   512,   307,  1190,   515,
    1026,   513,    -1,   486,   512,   307,  1190,   515,  1003,   515,
    1026,   513,    -1,   487,   512,   999,  1008,   513,    -1,   488,
     512,  1004,   513,    -1,   489,   512,  1006,   997,  1007,   513,
      -1,   490,   512,   307,  1190,   513,    -1,   490,   512,   307,
    1190,   515,   997,   513,    -1,   491,   512,   997,   515,  1001,
    1002,   513,    -1,   492,   512,  1006,   997,   108,   975,   513,
      -1,   471,   997,    -1,   471,   313,   465,    -1,   515,   416,
     494,    -1,   515,   416,   313,    -1,   515,   416,   313,   465,
      -1,    -1,   484,   512,  1004,   513,    -1,  1005,    -1,  1004,
     515,  1005,    -1,   997,   108,  1190,    -1,   997,    -1,   199,
      -1,   157,    -1,   355,   476,    -1,   424,   476,    -1,    -1,
     347,   999,    -1,   347,   999,   126,   370,    -1,   347,   126,
     370,   999,    -1,   347,   126,   370,   999,   126,   370,    -1,
     477,  1010,    -1,    -1,  1011,    -1,  1010,   515,  1011,    -1,
    1188,   108,  1013,    -1,   339,  1013,    -1,   339,  1188,    -1,
      -1,   512,  1014,  1015,   934,  1016,   513,    -1,  1188,    -1,
      -1,   346,   126,  1026,    -1,    -1,   364,  1017,    -1,   392,
    1017,    -1,    -1,  1018,    -1,   120,  1018,   105,  1018,    -1,
     449,   352,    -1,   449,   226,    -1,   166,   391,    -1,   997,
     352,    -1,   997,   226,    -1,   391,   512,  1026,   513,    -1,
     391,   512,   513,    -1,   512,  1026,   515,   997,   513,    -1,
     106,    -1,   414,    -1,    99,    -1,    85,    -1,  1022,    -1,
     503,    -1,   504,    -1,   505,    -1,   506,    -1,   507,    -1,
     508,    -1,   500,    -1,   501,    -1,   499,    -1,    85,    -1,
     332,   512,   810,   513,    -1,  1021,    -1,   332,   512,   810,
     513,    -1,  1021,    -1,   332,   512,   810,   513,    -1,   289,
      -1,   316,   289,    -1,   249,    -1,   316,   249,    -1,   997,
      -1,  1026,   515,   997,    -1,  1028,    -1,  1027,   515,  1028,
      -1,   997,    -1,   792,    90,   997,    -1,   973,    -1,  1029,
     515,   973,    -1,   510,  1026,   511,    -1,   510,  1031,   511,
      -1,   510,   511,    -1,  1030,    -1,  1031,   515,  1030,    -1,
    1033,   232,   997,    -1,    -1,  1210,    -1,   493,    -1,   305,
      -1,   178,    -1,   246,    -1,   301,    -1,   398,    -1,  1208,
      -1,   997,  1035,  1038,  1039,    -1,   997,  1035,  1038,    -1,
     349,   997,    -1,   998,   253,   998,    -1,    -1,   997,  1038,
    1039,    -1,   997,  1039,  1038,    -1,   997,  1038,    -1,   997,
    1039,    -1,  1026,    -1,    -1,   232,   997,    -1,   227,   997,
      -1,   997,   232,  1026,    -1,   232,  1026,    -1,  1026,    -1,
     921,    -1,   512,  1026,   513,    -1,   131,  1046,  1043,  1045,
     208,    -1,  1044,    -1,  1043,  1044,    -1,   474,   997,   436,
     997,    -1,   204,   997,    -1,    -1,   997,    -1,    -1,  1188,
      -1,  1188,  1049,    -1,   514,  1063,    -1,   514,   505,    -1,
     510,   997,   511,    -1,   510,   997,   517,   997,   511,    -1,
    1048,    -1,  1049,  1048,    -1,    -1,  1050,  1048,    -1,   112,
      -1,    -1,   997,    -1,   183,    -1,  1052,    -1,  1053,   515,
    1052,    -1,   512,  1053,   513,    -1,  1056,    -1,  1055,   515,
    1056,    -1,   997,   108,  1190,    -1,   997,  1210,    -1,   997,
      -1,   505,    -1,  1058,    -1,  1057,   515,  1058,    -1,  1188,
      -1,  1188,  1049,    -1,  1060,    -1,  1059,   515,  1060,    -1,
    1188,    -1,  1188,    -1,  1188,    -1,  1190,    -1,  1188,    -1,
    1208,    -1,  1189,    -1,  1188,  1049,    -1,  1068,    -1,  1207,
      -1,  1208,    -1,  1206,    -1,    84,    -1,  1066,  1208,    -1,
    1066,   512,  1027,   513,  1208,    -1,   976,  1208,    -1,   993,
    1208,   995,    -1,   993,   512,  1068,   513,  1208,   995,    -1,
     445,    -1,   221,    -1,   321,    -1,  1202,    -1,  1200,    -1,
      86,    -1,  1188,    -1,  1068,    -1,  1202,    -1,   503,  1068,
      -1,   504,  1068,    -1,    91,    -1,    92,    -1,    93,    -1,
      94,    -1,    95,    -1,    96,    -1,    97,    -1,    98,    -1,
     100,    -1,   101,    -1,   102,    -1,   110,    -1,   111,    -1,
     113,    -1,   114,    -1,   116,    -1,   117,    -1,   118,    -1,
     119,    -1,   126,    -1,   127,    -1,   128,    -1,   129,    -1,
     130,    -1,   133,    -1,   134,    -1,   137,    -1,   139,    -1,
     140,    -1,   141,    -1,   142,    -1,   143,    -1,   146,    -1,
     148,    -1,   149,    -1,   150,    -1,   151,    -1,   153,    -1,
     156,    -1,   157,    -1,   158,    -1,   159,    -1,   160,    -1,
     161,    -1,   162,    -1,   165,    -1,   174,    -1,   175,    -1,
     176,    -1,   177,    -1,   179,    -1,   182,    -1,   184,    -1,
     186,    -1,   187,    -1,   188,    -1,   189,    -1,   190,    -1,
     192,    -1,   193,    -1,   194,    -1,   195,    -1,   197,    -1,
     199,    -1,   200,    -1,   201,    -1,   202,    -1,   203,    -1,
     205,    -1,   206,    -1,   207,    -1,   209,    -1,   210,    -1,
     212,    -1,   213,    -1,   214,    -1,   215,    -1,   217,    -1,
     218,    -1,   219,    -1,   222,    -1,   224,    -1,   226,    -1,
     228,    -1,   230,    -1,   234,    -1,   235,    -1,   236,    -1,
     238,    -1,   241,    -1,   242,    -1,   244,    -1,   245,    -1,
     247,    -1,   248,    -1,   250,    -1,   251,    -1,   252,    -1,
     254,    -1,   255,    -1,   256,    -1,   257,    -1,   258,    -1,
     259,    -1,   261,    -1,   265,    -1,   266,    -1,   267,    -1,
     273,    -1,   276,    -1,   278,    -1,   279,    -1,   280,    -1,
     281,    -1,   282,    -1,   283,    -1,   284,    -1,   288,    -1,
     291,    -1,   292,    -1,   293,    -1,   296,    -1,   297,    -1,
     298,    -1,   299,    -1,   300,    -1,   302,    -1,   303,    -1,
     304,    -1,   306,    -1,   307,    -1,   308,    -1,   312,    -1,
     313,    -1,   314,    -1,   317,    -1,   318,    -1,   320,    -1,
     323,    -1,   325,    -1,   326,    -1,   327,    -1,   329,    -1,
     332,    -1,   333,    -1,   334,    -1,   342,    -1,   343,    -1,
     344,    -1,   345,    -1,   346,    -1,   347,    -1,   348,    -1,
     350,    -1,   352,    -1,   354,    -1,   356,    -1,   357,    -1,
     355,    -1,   359,    -1,   360,    -1,   361,    -1,   362,    -1,
     363,    -1,   364,    -1,   365,    -1,   367,    -1,   368,    -1,
     369,    -1,   370,    -1,   372,    -1,   373,    -1,   374,    -1,
     375,    -1,   376,    -1,   377,    -1,   378,    -1,   379,    -1,
     380,    -1,   381,    -1,   382,    -1,   384,    -1,   385,    -1,
     387,    -1,   388,    -1,   389,    -1,   390,    -1,   392,    -1,
     393,    -1,   394,    -1,   395,    -1,   396,    -1,   397,    -1,
     399,    -1,   401,    -1,   402,    -1,   403,    -1,   404,    -1,
     405,    -1,   407,    -1,   409,    -1,   410,    -1,   412,    -1,
     415,    -1,   416,    -1,   417,    -1,   418,    -1,   419,    -1,
     420,    -1,   421,    -1,   422,    -1,   423,    -1,   424,    -1,
     427,    -1,   428,    -1,   430,    -1,   431,    -1,   432,    -1,
     433,    -1,   434,    -1,   435,    -1,   441,    -1,   443,    -1,
     446,    -1,   447,    -1,   448,    -1,   449,    -1,   450,    -1,
     451,    -1,   454,    -1,   455,    -1,   456,    -1,   457,    -1,
     458,    -1,   461,    -1,   462,    -1,   463,    -1,   464,    -1,
     465,    -1,   469,    -1,   471,    -1,   472,    -1,   473,    -1,
     476,    -1,   479,    -1,   480,    -1,   481,    -1,   482,    -1,
     483,    -1,   494,    -1,   495,    -1,   120,    -1,   121,    -1,
     123,    -1,   124,    -1,   136,    -1,   144,    -1,   180,    -1,
     181,    -1,   216,    -1,   220,    -1,   225,    -1,   239,    -1,
     263,    -1,   269,    -1,   271,    -1,   286,    -1,   309,    -1,
     311,    -1,   315,    -1,   322,    -1,   324,    -1,   337,    -1,
     341,    -1,   351,    -1,   353,    -1,   366,    -1,   391,    -1,
     408,    -1,   413,    -1,   425,    -1,   437,    -1,   438,    -1,
     442,    -1,   444,    -1,   467,    -1,   484,    -1,   485,    -1,
     486,    -1,   487,    -1,   488,    -1,   489,    -1,   490,    -1,
     491,    -1,   492,    -1,   115,    -1,   122,    -1,   152,    -1,
     164,    -1,   170,    -1,   231,    -1,   233,    -1,   249,    -1,
     262,    -1,   274,    -1,   275,    -1,   277,    -1,   287,    -1,
     289,    -1,   310,    -1,   319,    -1,   338,    -1,   339,    -1,
     340,    -1,   386,    -1,   411,    -1,   470,    -1,    99,    -1,
     103,    -1,   104,    -1,   105,    -1,   106,    -1,   107,    -1,
     108,    -1,   109,    -1,   112,    -1,   125,    -1,   131,    -1,
     132,    -1,   138,    -1,   145,    -1,   147,    -1,   155,    -1,
     163,    -1,   167,    -1,   168,    -1,   169,    -1,   171,    -1,
     172,    -1,   173,    -1,   183,    -1,   185,    -1,   191,    -1,
     196,    -1,   198,    -1,   204,    -1,   208,    -1,   211,    -1,
     221,    -1,   223,    -1,   227,    -1,   229,    -1,   232,    -1,
     237,    -1,   240,    -1,   243,    -1,   253,    -1,   260,    -1,
     270,    -1,   272,    -1,   285,    -1,   290,    -1,   294,    -1,
     295,    -1,   316,    -1,   321,    -1,   328,    -1,   330,    -1,
     331,    -1,   335,    -1,   336,    -1,   349,    -1,   358,    -1,
     371,    -1,   383,    -1,   400,    -1,   406,    -1,   414,    -1,
     426,    -1,   429,    -1,   436,    -1,   440,    -1,   445,    -1,
     453,    -1,   459,    -1,   460,    -1,   468,    -1,   474,    -1,
     475,    -1,   477,    -1,   478,    -1,    -1,  1075,  1076,    -1,
    1197,  1079,   522,   516,    -1,  1197,   522,   516,    -1,  1197,
    1099,    -1,  1104,    -1,  1216,    -1,    73,    -1,   518,    -1,
     519,    -1,    -1,   163,   594,   429,   632,   108,  1078,   920,
     636,    -1,   113,  1140,    -1,     9,   439,  1081,  1088,  1089,
      -1,     9,   439,   183,    -1,     9,  1090,    -1,   177,  1081,
      -1,  1082,  1085,  1087,    -1,  1083,   517,  1084,  1087,   506,
    1082,  1093,    -1,  1092,    -1,  1208,    -1,  1061,    -1,    -1,
    1210,  1204,    -1,    85,  1086,    -1,  1084,    -1,    -1,  1188,
      -1,  1188,   514,  1086,    -1,    74,    -1,   517,  1068,    -1,
      -1,   108,  1140,    -1,    -1,   459,  1090,    -1,    -1,  1091,
      -1,  1091,   506,  1091,    -1,  1091,    21,   126,  1091,    -1,
    1091,   460,  1091,    -1,  1069,    -1,  1208,    -1,  1202,    -1,
    1204,    -1,    85,  1094,    -1,    -1,  1188,  1095,    -1,  1188,
    1095,    85,  1094,    -1,    -1,   499,  1068,    -1,   499,  1210,
      -1,   499,  1202,    -1,  1060,    -1,  1092,    -1,   182,   917,
     918,   174,   919,   227,  1096,    -1,   215,   250,  1141,    -1,
    1100,    -1,  1111,    -1,  1113,    -1,   643,    -1,   515,   643,
      -1,    -1,   995,    -1,   493,   439,   301,    -1,   493,   439,
     398,    -1,   178,   439,   178,    -1,   305,   439,   305,    -1,
      -1,  1106,  1105,  1108,  1107,    -1,  1197,   119,   182,    34,
     516,    -1,  1197,   208,   182,    34,   516,    -1,    -1,  1109,
      -1,  1100,    -1,    73,    -1,  1109,  1100,    -1,  1109,    73,
      -1,  1113,    -1,  1110,  1113,    -1,    -1,    70,  1112,  1120,
    1136,  1192,   974,   516,    -1,    -1,  1117,  1120,  1114,  1133,
     516,    -1,    -1,  1120,  1115,  1133,   516,    -1,  1123,   516,
      -1,   517,  1068,    -1,    -1,  1118,  1119,    -1,  1118,    -1,
    1119,    -1,    56,    -1,    67,    -1,    65,    -1,    50,    -1,
      51,    -1,    69,    -1,  1129,    -1,  1125,    -1,  1121,    -1,
    1192,   512,  1101,  1102,   513,    -1,  1192,  1103,    -1,  1127,
      -1,   209,  1186,  1122,    -1,   209,  1122,    -1,   209,  1186,
      -1,   518,  1214,   519,    -1,    -1,  1127,  1124,   518,  1110,
     519,    -1,  1123,    -1,    -1,  1128,  1126,   518,  1110,   519,
      -1,    43,  1186,    -1,   452,  1186,    -1,    43,    -1,   452,
      -1,  1130,    -1,  1132,  1131,    -1,    44,    35,    -1,    44,
      35,   268,    -1,    44,    -1,    44,   268,    -1,    44,    25,
      -1,    44,    25,   268,    -1,    44,    25,    25,    -1,    44,
      25,    25,   268,    -1,    44,   135,    -1,    35,    -1,    35,
     268,    -1,   268,    -1,    25,    -1,    25,   268,    -1,    25,
      25,    -1,    25,    25,   268,    -1,     5,    -1,   135,    -1,
     201,    -1,    36,    -1,    -1,  1134,    -1,  1133,   515,  1134,
      -1,  1136,  1191,   974,  1116,  1135,    -1,    -1,   499,  1215,
      -1,    -1,   505,    -1,   505,   505,    -1,   182,   418,  1210,
      -1,    15,  1139,    -1,  1140,    -1,   166,    -1,    99,    -1,
      -1,  1061,    -1,   183,    -1,  1092,    -1,  1092,    -1,    71,
      -1,    17,   917,    -1,    17,    99,    -1,    28,   917,  1144,
      -1,    -1,  1145,    -1,   460,  1149,    -1,  1146,    -1,   460,
      37,    14,  1211,    -1,   460,    14,  1060,    -1,   272,    37,
      14,  1211,    -1,   272,    14,  1060,    -1,   272,  1060,    -1,
    1150,    -1,  1150,   515,  1149,    -1,  1151,    -1,  1202,    -1,
    1200,    -1,  1068,    -1,   503,  1068,    -1,   504,  1068,    -1,
    1207,    -1,   503,  1207,    -1,   504,  1207,    -1,  1208,    -1,
    1206,    -1,  1209,    -1,    13,   264,  1096,  1146,    -1,    13,
    1153,  1096,  1146,    -1,    13,  1153,  1096,  1147,    -1,    13,
     264,  1096,  1148,    -1,    13,  1153,  1096,  1148,    -1,    29,
      -1,    -1,     3,    14,  1211,    -1,   179,    14,  1211,    -1,
      18,    14,  1211,  1157,    -1,  1158,    -1,  1157,   515,  1158,
      -1,  1204,   499,  1163,    -1,   407,    14,  1211,  1160,    -1,
    1161,    -1,  1160,   515,  1161,    -1,  1163,   499,  1162,    -1,
    1068,    -1,  1204,    -1,    10,    -1,    18,    14,  1211,   465,
    1162,  1165,    -1,  1166,    -1,  1165,   515,  1166,    -1,  1204,
     499,  1171,    -1,   407,    14,  1211,   465,  1162,  1168,    -1,
    1169,    -1,  1168,   515,  1169,    -1,  1171,   499,  1170,    -1,
    1207,    -1,  1162,    -1,   504,  1207,    -1,   504,  1068,    -1,
    1208,    -1,     8,    -1,   176,    -1,    11,    -1,    12,    -1,
      22,    -1,    23,    -1,    24,    -1,   307,    -1,    26,    -1,
      27,    -1,   353,    -1,    31,    -1,    32,    -1,    33,    -1,
     448,    -1,   407,     4,   499,  1173,    -1,   407,     4,   439,
    1173,    -1,   330,    -1,   327,    -1,   407,   154,   439,  1140,
      -1,   407,   154,   499,  1140,    -1,   407,   154,  1140,    -1,
      -1,   448,  1176,  1192,   274,  1120,   974,  1177,    -1,    30,
      -1,    -1,    -1,    45,  1179,  1190,   274,  1120,   974,  1177,
      -1,    46,    38,  1181,    -1,    46,   316,    16,  1181,    -1,
      46,    40,  1181,    -1,   158,    -1,    39,    -1,    42,    -1,
      20,  1060,    -1,    19,   439,  1060,    -1,   198,  1060,   512,
    1198,   513,    -1,   198,     6,    -1,     7,  1060,   512,  1198,
     513,    -1,     7,  1060,    -1,  1183,    -1,  1184,    -1,     6,
      -1,     7,    -1,     8,    -1,    10,    -1,    11,    -1,    12,
      -1,    16,    -1,    19,    -1,    20,    -1,    21,    -1,    22,
      -1,    23,    -1,    24,    -1,    26,    -1,    27,    -1,    31,
      -1,    32,    -1,    33,    -1,    34,    -1,    37,    -1,    38,
      -1,    39,    -1,    40,    -1,    42,    -1,     9,    -1,    13,
      -1,    15,    -1,    28,    -1,    45,    -1,    46,    -1,     5,
      -1,    25,    -1,    29,    -1,    35,    -1,    43,    -1,    36,
      -1,    44,    -1,  1190,    -1,  1210,    -1,  1071,    -1,  1072,
      -1,  1195,    -1,  1182,    -1,  1193,    -1,   135,    -1,   466,
      -1,  1210,    -1,  1194,    -1,  1072,    -1,  1182,    -1,  1193,
      -1,   135,    -1,   466,    -1,  1210,    -1,  1194,    -1,  1073,
      -1,  1182,    -1,  1193,    -1,  1185,    -1,  1191,    -1,  1185,
      -1,   135,    -1,   166,    -1,   264,    -1,   268,    -1,   439,
      -1,   452,    -1,   466,    -1,  1193,    -1,  1195,    -1,  1192,
      -1,  1071,    -1,  1074,    -1,  1184,    -1,   154,    -1,  1210,
      -1,  1072,    -1,  1073,    -1,  1183,    -1,    50,    -1,    51,
      -1,    56,    -1,    65,    -1,    67,    -1,    70,    -1,    69,
      -1,  1071,    -1,  1195,    -1,   154,    -1,   178,    -1,   246,
      -1,   301,    -1,   305,    -1,   398,    -1,   493,    -1,  1199,
      -1,  1196,   515,  1199,    -1,    41,    -1,    -1,  1214,    -1,
    1204,  1203,    -1,  1204,    -1,  1204,  1203,    -1,  1092,    -1,
    1204,    -1,  1204,    -1,    22,  1204,    -1,    22,  1060,    -1,
      72,    -1,    87,    -1,    83,    -1,    81,    -1,    82,    -1,
      76,    -1,    77,    -1,    78,    -1,    75,    -1,    84,    -1,
      80,    -1,    71,    -1,    79,    -1,  1060,    -1,  1092,    -1,
    1217,    -1,   512,   513,    -1,   512,  1213,   513,    -1,  1212,
      -1,  1213,  1212,    -1,  1215,    -1,  1214,   515,  1215,    -1,
    1213,    -1,   518,  1214,   519,    -1,  1217,    -1,   512,    -1,
     513,    -1,   515,    -1,   516,    -1,  1210,    -1,  1068,    -1,
    1207,    -1,  1208,    -1,   505,    -1,   503,    -1,   504,    -1,
     506,    -1,   507,    -1,   321,    -1,    47,    -1,    48,    -1,
      49,    -1,    50,    -1,    51,    -1,    52,    -1,    53,    -1,
      54,    -1,    55,    -1,    56,    -1,    57,    -1,    58,    -1,
      60,    -1,    59,    -1,    61,    -1,    62,    -1,    63,    -1,
      64,    -1,    65,    -1,    66,    -1,    67,    -1,    68,    -1,
      70,    -1,    69,    -1,     5,    -1,   209,    -1,   246,    -1,
     268,    -1,    25,    -1,   301,    -1,   305,    -1,   398,    -1,
      35,    -1,    36,    -1,    43,    -1,    44,    -1,   493,    -1,
     135,    -1,   225,    -1,   439,    -1,   452,    -1,   467,    -1,
     510,    -1,   511,    -1,   499,    -1,   517,    -1,   179,  1096,
      -1,   179,   356,  1096,    -1,   179,    99,    -1,   179,   356,
      99,    -1,  1068,    -1,   512,  1219,   513,    -1,  1219,   503,
    1219,    -1,  1219,   504,  1219,    -1,  1219,   505,  1219,    -1,
    1219,   506,  1219,    -1,  1219,   507,  1219,    -1,  1208,    -1,
    1188,    -1,    -1,  1145,  1221,    -1,  1221,  1145,    -1,  1145,
      -1,  1221,    -1,   272,  1196,    -1,  1147,    -1,  1221,    -1,
    1146,    -1,    -1,  1222,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1393,  1393,  1396,  1398,  1400,  1402,  1404,  1406,  1408,
    1410,  1412,  1414,  1416,  1418,  1420,  1422,  1424,  1426,  1428,
    1430,  1432,  1434,  1436,  1438,  1440,  1442,  1444,  1446,  1448,
    1450,  1452,  1454,  1472,  1474,  1476,  1478,  1480,  1482,  1484,
    1486,  1488,  1490,  1492,  1494,  1496,  1498,  1500,  1502,  1504,
    1506,  1508,  1510,  1512,  1514,  1516,  1518,  1520,  1522,  1524,
    1526,  1528,  1530,  1532,  1536,  1538,  1540,  1542,  1544,  1546,
    1548,  1550,  1552,  1554,  1556,  1558,  1560,  1562,  1564,  1566,
    1568,  1570,  1572,  1574,  1576,  1578,  1580,  1582,  1584,  1586,
    1588,  1590,  1592,  1594,  1596,  1598,  1600,  1602,  1604,  1606,
    1608,  1615,  1617,  1619,  1621,  1623,  1625,  1627,  1629,  1631,
    1633,  1635,  1637,  1643,  1645,  1647,  1649,  1651,  1653,  1655,
    1657,  1659,  1665,  1675,  1679,  1685,  1689,  1699,  1709,  1710,
    1724,  1731,  1737,  1748,  1754,  1763,  1770,  1776,  1785,  1792,
    1800,  1805,  1813,  1818,  1824,  1829,  1835,  1840,  1846,  1850,
    1854,  1858,  1862,  1866,  1870,  1874,  1878,  1882,  1890,  1894,
    1898,  1902,  1906,  1910,  1918,  1926,  1935,  1937,  1945,  1953,
    1961,  1969,  1973,  1981,  1985,  1993,  2001,  2009,  2013,  2021,
    2025,  2033,  2037,  2045,  2050,  2056,  2061,  2067,  2071,  2075,
    2079,  2083,  2087,  2095,  2099,  2103,  2111,  2115,  2119,  2123,
    2127,  2131,  2135,  2139,  2143,  2148,  2152,  2156,  2160,  2164,
    2168,  2176,  2180,  2188,  2192,  2200,  2204,  2218,  2222,  2226,
    2230,  2238,  2242,  2246,  2250,  2258,  2262,  2266,  2270,  2274,
    2278,  2282,  2290,  2294,  2299,  2305,  2309,  2317,  2321,  2325,
    2329,  2333,  2341,  2345,  2353,  2357,  2361,  2365,  2369,  2378,
    2386,  2390,  2398,  2402,  2410,  2418,  2422,  2426,  2430,  2438,
    2442,  2446,  2450,  2458,  2462,  2470,  2474,  2478,  2482,  2486,
    2490,  2494,  2498,  2502,  2506,  2510,  2514,  2518,  2522,  2526,
    2530,  2534,  2538,  2542,  2546,  2550,  2554,  2558,  2562,  2566,
    2570,  2574,  2578,  2582,  2586,  2590,  2594,  2598,  2602,  2606,
    2610,  2614,  2618,  2622,  2626,  2630,  2638,  2642,  2650,  2654,
    2659,  2665,  2670,  2676,  2681,  2687,  2695,  2700,  2706,  2710,
    2718,  2722,  2726,  2730,  2738,  2746,  2750,  2758,  2762,  2766,
    2770,  2778,  2783,  2791,  2802,  2813,  2817,  2825,  2829,  2833,
    2841,  2845,  2853,  2858,  2864,  2868,  2872,  2876,  2880,  2884,
    2888,  2892,  2896,  2900,  2904,  2908,  2916,  2921,  2927,  2932,
    2938,  2943,  2949,  2954,  2960,  2964,  2972,  2980,  2984,  2988,
    2992,  2997,  3003,  3007,  3015,  3023,  3027,  3031,  3035,  3043,
    3047,  3051,  3055,  3059,  3063,  3067,  3072,  3078,  3083,  3089,
    3094,  3100,  3104,  3112,  3116,  3124,  3128,  3132,  3140,  3144,
    3152,  3160,  3168,  3173,  3179,  3183,  3187,  3191,  3199,  3203,
    3207,  3211,  3215,  3219,  3223,  3231,  3235,  3239,  3243,  3251,
    3259,  3263,  3268,  3274,  3278,  3282,  3286,  3290,  3294,  3302,
    3306,  3314,  3318,  3322,  3326,  3330,  3334,  3338,  3346,  3351,
    3357,  3361,  3369,  3377,  3381,  3386,  3391,  3397,  3401,  3409,
    3413,  3421,  3426,  3432,  3436,  3440,  3444,  3449,  3455,  3463,
    3471,  3475,  3479,  3483,  3487,  3495,  3500,  3506,  3510,  3514,
    3519,  3525,  3529,  3533,  3538,  3544,  3549,  3555,  3559,  3567,
    3571,  3575,  3579,  3584,  3590,  3594,  3599,  3605,  3610,  3616,
    3624,  3632,  3637,  3643,  3647,  3655,  3663,  3667,  3672,  3678,
    3686,  3694,  3699,  3705,  3709,  3717,  3721,  3725,  3729,  3733,
    3737,  3741,  3745,  3749,  3753,  3757,  3761,  3769,  3774,  3780,
    3784,  3788,  3796,  3800,  3808,  3812,  3820,  3825,  3831,  3835,
    3843,  3848,  3854,  3858,  3866,  3871,  3877,  3881,  3889,  3894,
    3900,  3908,  3913,  3919,  3923,  3931,  3935,  3943,  3948,  3954,
    3958,  3962,  3970,  3978,  3983,  3989,  3997,  4001,  4005,  4009,
    4013,  4017,  4021,  4025,  4029,  4033,  4037,  4041,  4045,  4049,
    4053,  4057,  4061,  4065,  4069,  4073,  4077,  4081,  4089,  4097,
    4101,  4105,  4109,  4117,  4121,  4129,  4134,  4140,  4144,  4152,
    4156,  4164,  4169,  4175,  4179,  4187,  4195,  4199,  4207,  4211,
    4215,  4219,  4227,  4235,  4243,  4251,  4259,  4264,  4270,  4274,
    4282,  4287,  4293,  4297,  4305,  4309,  4313,  4321,  4325,  4333,
    4337,  4345,  4349,  4357,  4365,  4373,  4381,  4385,  4389,  4397,
    4401,  4409,  4417,  4421,  4429,  4433,  4437,  4445,  4449,  4457,
    4461,  4465,  4469,  4473,  4481,  4486,  4492,  4497,  4503,  4507,
    4515,  4520,  4526,  4530,  4535,  4541,  4545,  4549,  4553,  4561,
    4566,  4573,  4575,  4583,  4587,  4591,  4595,  4599,  4607,  4611,
    4619,  4628,  4637,  4641,  4645,  4649,  4653,  4657,  4661,  4665,
    4669,  4673,  4677,  4681,  4685,  4693,  4701,  4705,  4713,  4717,
    4725,  4729,  4733,  4737,  4741,  4749,  4753,  4761,  4769,  4773,
    4781,  4789,  4794,  4800,  4804,  4812,  4816,  4820,  4828,  4836,
    4840,  4848,  4852,  4856,  4860,  4864,  4872,  4877,  4883,  4888,
    4894,  4898,  4903,  4909,  4915,  4921,  4929,  4933,  4941,  4945,
    4953,  4957,  4965,  4969,  4977,  4981,  4989,  4997,  5005,  5009,
    5017,  5021,  5025,  5029,  5033,  5037,  5041,  5045,  5049,  5053,
    5057,  5061,  5065,  5069,  5073,  5081,  5085,  5093,  5097,  5105,
    5109,  5117,  5125,  5129,  5134,  5140,  5144,  5148,  5152,  5156,
    5160,  5164,  5168,  5172,  5176,  5180,  5184,  5188,  5192,  5196,
    5200,  5204,  5212,  5216,  5220,  5224,  5228,  5232,  5236,  5240,
    5244,  5248,  5252,  5256,  5260,  5264,  5268,  5272,  5276,  5284,
    5288,  5296,  5300,  5304,  5308,  5312,  5320,  5325,  5331,  5335,
    5339,  5343,  5347,  5351,  5355,  5359,  5367,  5371,  5379,  5383,
    5387,  5391,  5397,  5403,  5409,  5415,  5421,  5427,  5433,  5443,
    5454,  5465,  5476,  5487,  5498,  5509,  5525,  5541,  5557,  5568,
    5584,  5595,  5611,  5626,  5630,  5638,  5643,  5649,  5657,  5661,
    5669,  5673,  5677,  5681,  5685,  5693,  5697,  5705,  5709,  5713,
    5717,  5725,  5729,  5733,  5737,  5741,  5745,  5749,  5753,  5757,
    5761,  5765,  5769,  5773,  5777,  5785,  5789,  5797,  5801,  5809,
    5814,  5820,  5824,  5832,  5840,  5848,  5852,  5860,  5865,  5871,
    5876,  5882,  5890,  5895,  5901,  5905,  5909,  5917,  5921,  5925,
    5933,  5937,  5941,  5949,  5957,  5962,  5968,  5973,  5979,  5984,
    5990,  5995,  6001,  6005,  6013,  6017,  6021,  6029,  6034,  6040,
    6044,  6049,  6055,  6059,  6064,  6070,  6074,  6079,  6085,  6089,
    6093,  6101,  6106,  6112,  6116,  6124,  6128,  6136,  6140,  6148,
    6152,  6160,  6164,  6168,  6172,  6176,  6184,  6188,  6192,  6196,
    6200,  6208,  6216,  6224,  6228,  6232,  6240,  6244,  6248,  6256,
    6260,  6268,  6272,  6276,  6280,  6284,  6288,  6292,  6296,  6300,
    6304,  6308,  6312,  6316,  6324,  6328,  6332,  6336,  6344,  6348,
    6356,  6361,  6367,  6375,  6379,  6387,  6395,  6399,  6407,  6412,
    6418,  6422,  6430,  6434,  6442,  6446,  6454,  6458,  6462,  6466,
    6474,  6478,  6486,  6494,  6498,  6506,  6510,  6518,  6522,  6526,
    6534,  6538,  6543,  6549,  6557,  6562,  6568,  6572,  6576,  6584,
    6588,  6596,  6601,  6607,  6611,  6615,  6619,  6623,  6627,  6631,
    6635,  6639,  6643,  6647,  6651,  6655,  6659,  6663,  6667,  6671,
    6675,  6679,  6683,  6687,  6691,  6695,  6699,  6703,  6707,  6711,
    6715,  6719,  6727,  6732,  6738,  6743,  6749,  6753,  6757,  6761,
    6765,  6769,  6773,  6777,  6781,  6785,  6789,  6793,  6797,  6801,
    6805,  6809,  6813,  6817,  6825,  6829,  6833,  6837,  6841,  6845,
    6849,  6853,  6857,  6861,  6865,  6869,  6873,  6877,  6881,  6885,
    6889,  6893,  6901,  6909,  6913,  6917,  6925,  6929,  6937,  6941,
    6945,  6949,  6953,  6961,  6966,  6972,  6976,  6980,  6984,  6992,
    6996,  7001,  7007,  7011,  7019,  7027,  7032,  7038,  7046,  7050,
    7058,  7062,  7066,  7070,  7074,  7078,  7082,  7086,  7090,  7094,
    7098,  7102,  7106,  7110,  7118,  7122,  7127,  7133,  7137,  7141,
    7145,  7149,  7157,  7161,  7165,  7173,  7178,  7184,  7188,  7196,
    7201,  7206,  7212,  7218,  7226,  7234,  7239,  7245,  7249,  7253,
    7257,  7261,  7265,  7269,  7273,  7277,  7281,  7285,  7289,  7293,
    7297,  7301,  7305,  7313,  7318,  7324,  7328,  7336,  7344,  7349,
    7355,  7363,  7367,  7375,  7383,  7387,  7391,  7395,  7399,  7407,
    7412,  7418,  7426,  7430,  7434,  7438,  7442,  7446,  7454,  7462,
    7466,  7470,  7478,  7483,  7489,  7493,  7497,  7501,  7505,  7513,
    7517,  7525,  7529,  7533,  7537,  7545,  7549,  7557,  7561,  7569,
    7574,  7580,  7585,  7591,  7596,  7602,  7607,  7613,  7621,  7626,
    7632,  7640,  7648,  7656,  7660,  7668,  7676,  7684,  7692,  7700,
    7704,  7708,  7712,  7720,  7724,  7728,  7732,  7736,  7740,  7744,
    7752,  7756,  7764,  7772,  7776,  7780,  7788,  7792,  7797,  7803,
    7811,  7819,  7823,  7827,  7835,  7839,  7844,  7850,  7854,  7859,
    7865,  7871,  7881,  7886,  7892,  7896,  7900,  7904,  7912,  7914,
    7922,  7927,  7933,  7941,  7945,  7949,  7957,  7961,  7969,  7977,
    7982,  7988,  7996,  8001,  8007,  8015,  8020,  8026,  8030,  8034,
    8038,  8042,  8046,  8050,  8054,  8062,  8067,  8073,  8081,  8085,
    8093,  8097,  8105,  8113,  8121,  8129,  8133,  8141,  8194,  8198,
    8211,  8213,  8217,  8221,  8225,  8234,  8240,  8244,  8252,  8256,
    8264,  8268,  8276,  8280,  8284,  8288,  8292,  8296,  8300,  8304,
    8312,  8316,  8324,  8328,  8332,  8336,  8340,  8344,  8352,  8356,
    8364,  8368,  8376,  8384,  8389,  8395,  8400,  8402,  8408,  8412,
    8416,  8420,  8424,  8428,  8432,  8436,  8440,  8448,  8453,  8459,
    8463,  8468,  8474,  8478,  8482,  8487,  8493,  8498,  8504,  8512,
    8516,  8524,  8528,  8536,  8540,  8544,  8548,  8556,  8561,  8567,
    8571,  8576,  8584,  8588,  8596,  8600,  8608,  8616,  8620,  8625,
    8631,  8639,  8643,  8651,  8655,  8663,  8668,  8674,  8679,  8685,
    8689,  8697,  8702,  8708,  8712,  8720,  8724,  8732,  8737,  8743,
    8747,  8755,  8760,  8766,  8770,  8778,  8782,  8786,  8790,  8794,
    8798,  8802,  8806,  8812,  8816,  8820,  8828,  8832,  8836,  8840,
    8844,  8848,  8856,  8860,  8864,  8868,  8876,  8880,  8884,  8888,
    8896,  8901,  8907,  8911,  8919,  8923,  8927,  8931,  8939,  8943,
    8951,  8955,  8959,  8967,  8975,  8980,  8986,  8990,  8996,  9002,
    9007,  9013,  9017,  9025,  9033,  9035,  9037,  9041,  9045,  9049,
    9057,  9067,  9078,  9087,  9091,  9095,  9099,  9103,  9107,  9111,
    9119,  9123,  9127,  9131,  9139,  9143,  9151,  9156,  9162,  9166,
    9170,  9174,  9178,  9182,  9186,  9190,  9194,  9198,  9202,  9210,
    9215,  9221,  9225,  9233,  9237,  9245,  9253,  9261,  9265,  9273,
    9277,  9285,  9293,  9301,  9305,  9309,  9313,  9317,  9321,  9329,
    9334,  9340,  9345,  9351,  9355,  9359,  9363,  9371,  9379,  9383,
    9388,  9394,  9398,  9402,  9406,  9410,  9414,  9418,  9422,  9426,
    9430,  9434,  9438,  9442,  9447,  9453,  9457,  9465,  9469,  9473,
    9477,  9481,  9485,  9489,  9493,  9497,  9501,  9505,  9509,  9513,
    9517,  9521,  9525,  9529,  9533,  9537,  9541,  9545,  9549,  9553,
    9557,  9561,  9565,  9569,  9573,  9577,  9581,  9585,  9589,  9593,
    9597,  9601,  9605,  9609,  9613,  9617,  9621,  9625,  9629,  9633,
    9637,  9641,  9645,  9649,  9653,  9657,  9661,  9665,  9669,  9673,
    9677,  9681,  9685,  9689,  9694,  9698,  9706,  9710,  9714,  9718,
    9722,  9726,  9730,  9734,  9738,  9742,  9746,  9750,  9754,  9758,
    9762,  9766,  9770,  9774,  9778,  9782,  9786,  9790,  9798,  9802,
    9806,  9810,  9814,  9818,  9822,  9826,  9830,  9834,  9838,  9846,
    9850,  9854,  9858,  9862,  9866,  9870,  9874,  9878,  9882,  9886,
    9890,  9894,  9898,  9902,  9906,  9910,  9914,  9918,  9922,  9926,
    9930,  9934,  9938,  9942,  9946,  9950,  9954,  9958,  9962,  9966,
    9970,  9974,  9978,  9982,  9986,  9990,  9994,  9998, 10002, 10006,
   10010, 10014, 10018, 10022, 10026, 10030, 10034, 10038, 10046, 10050,
   10058, 10062, 10066, 10071, 10077, 10085, 10089, 10097, 10101, 10109,
   10113, 10121, 10125, 10130, 10136, 10140, 10144, 10148, 10156, 10161,
   10167, 10171, 10179, 10187, 10191, 10196, 10202, 10210, 10214, 10221,
   10226, 10232, 10237, 10242, 10248, 10252, 10260, 10264, 10268, 10272,
   10276, 10284, 10288, 10292, 10300, 10304, 10308, 10316, 10320, 10328,
   10332, 10336, 10340, 10344, 10348, 10352, 10356, 10360, 10368, 10372,
   10380, 10384, 10392, 10396, 10400, 10404, 10408, 10412, 10420, 10424,
   10432, 10436, 10444, 10448, 10456, 10460, 10468, 10472, 10476, 10484,
   10488, 10496, 10501, 10507, 10511, 10515, 10519, 10523, 10527, 10531,
   10535, 10543, 10547, 10555, 10563, 10568, 10574, 10578, 10582, 10586,
   10590, 10595, 10601, 10609, 10617, 10621, 10625, 10633, 10637, 10645,
   10653, 10657, 10665, 10673, 10678, 10684, 10689, 10695, 10699, 10707,
   10711, 10715, 10719, 10727, 10731, 10740, 10742, 10750, 10755, 10761,
   10765, 10773, 10777, 10785, 10793, 10797, 10805, 10809, 10813, 10817,
   10825, 10829, 10837, 10841, 10849, 10853, 10861, 10869, 10877, 10885,
   10893, 10901, 10909, 10913, 10921, 10925, 10929, 10933, 10937, 10941,
   10945, 10949, 10953, 10957, 10961, 10965, 10969, 10973, 10974, 10979,
   10985, 10993, 10997, 10998, 11002, 11010, 11014, 11018, 11022, 11026,
   11030, 11034, 11038, 11042, 11046, 11050, 11054, 11058, 11062, 11066,
   11070, 11074, 11078, 11082, 11086, 11090, 11094, 11098, 11102, 11106,
   11110, 11114, 11118, 11122, 11126, 11130, 11134, 11138, 11142, 11146,
   11150, 11154, 11158, 11162, 11166, 11170, 11174, 11178, 11182, 11186,
   11190, 11194, 11198, 11202, 11206, 11210, 11214, 11218, 11222, 11226,
   11230, 11234, 11238, 11242, 11246, 11250, 11254, 11258, 11262, 11266,
   11270, 11274, 11278, 11282, 11286, 11290, 11294, 11298, 11302, 11306,
   11310, 11314, 11318, 11322, 11326, 11330, 11334, 11338, 11342, 11346,
   11350, 11354, 11358, 11362, 11366, 11370, 11374, 11378, 11382, 11386,
   11390, 11394, 11398, 11402, 11406, 11410, 11414, 11418, 11422, 11426,
   11430, 11434, 11438, 11442, 11446, 11450, 11454, 11458, 11462, 11466,
   11470, 11474, 11478, 11482, 11486, 11490, 11494, 11498, 11502, 11506,
   11510, 11514, 11518, 11522, 11526, 11530, 11534, 11538, 11542, 11546,
   11550, 11554, 11558, 11562, 11566, 11570, 11574, 11578, 11582, 11586,
   11590, 11594, 11598, 11602, 11606, 11610, 11614, 11618, 11622, 11626,
   11630, 11634, 11638, 11642, 11646, 11650, 11654, 11658, 11662, 11666,
   11670, 11674, 11678, 11682, 11686, 11690, 11694, 11698, 11702, 11706,
   11710, 11714, 11718, 11722, 11726, 11730, 11734, 11738, 11742, 11746,
   11750, 11754, 11758, 11762, 11766, 11770, 11774, 11778, 11782, 11786,
   11790, 11794, 11798, 11802, 11806, 11810, 11814, 11818, 11822, 11826,
   11830, 11834, 11838, 11842, 11846, 11850, 11854, 11858, 11862, 11866,
   11870, 11874, 11878, 11882, 11886, 11890, 11894, 11898, 11902, 11906,
   11910, 11914, 11918, 11922, 11926, 11930, 11934, 11938, 11942, 11946,
   11950, 11954, 11958, 11962, 11966, 11970, 11974, 11978, 11982, 11986,
   11990, 11994, 11998, 12002, 12006, 12010, 12018, 12022, 12026, 12030,
   12034, 12038, 12042, 12046, 12050, 12054, 12058, 12062, 12066, 12070,
   12074, 12078, 12082, 12086, 12090, 12094, 12098, 12102, 12106, 12110,
   12114, 12118, 12122, 12126, 12130, 12134, 12138, 12142, 12146, 12150,
   12154, 12158, 12162, 12166, 12170, 12174, 12178, 12182, 12186, 12190,
   12198, 12202, 12206, 12210, 12214, 12218, 12222, 12226, 12230, 12234,
   12238, 12242, 12246, 12250, 12254, 12258, 12262, 12266, 12270, 12274,
   12278, 12282, 12290, 12294, 12298, 12302, 12306, 12310, 12314, 12318,
   12322, 12326, 12330, 12334, 12338, 12342, 12346, 12350, 12354, 12358,
   12362, 12366, 12370, 12374, 12378, 12382, 12386, 12390, 12394, 12398,
   12402, 12406, 12410, 12414, 12418, 12422, 12426, 12430, 12434, 12438,
   12442, 12446, 12450, 12454, 12458, 12462, 12466, 12470, 12474, 12478,
   12482, 12486, 12490, 12494, 12498, 12502, 12506, 12510, 12514, 12518,
   12522, 12526, 12530, 12534, 12538, 12542, 12546, 12550, 12554, 12558,
   12562, 12566, 12570, 12574, 12578, 12582, 12592, 12593, 12596, 12597,
   12598, 12604, 12605, 12606, 12607, 12608, 12621, 12621, 12630, 12646,
   12648, 12651, 12653, 12657, 12669, 12685, 12689, 12700, 12701, 12704,
   12716, 12725, 12726, 12729, 12730, 12731, 12734, 12735, 12738, 12739,
   12742, 12743, 12746, 12748, 12750, 12752, 12756, 12763, 12770, 12786,
   12820, 12830, 12833, 12835, 12848, 12849, 12851, 12853, 12857, 12870,
   12877, 12938, 12947, 12949, 12950, 12953, 12955, 12956, 12959, 12960,
   12961, 12962, 12963, 12970, 12969, 12979, 12981, 12983, 12984, 12987,
   12988, 12989, 12990, 12993, 12994, 12998, 12997, 13014, 13012, 13028,
   13027, 13041, 13047, 13048, 13051, 13053, 13054, 13057, 13058, 13059,
   13060, 13063, 13064, 13067, 13075, 13092, 13100, 13123, 13229, 13263,
   13265, 13267, 13271, 13275, 13274, 13325, 13327, 13326, 13341, 13347,
   13354, 13359, 13362, 13363, 13366, 13367, 13368, 13369, 13370, 13371,
   13372, 13380, 13388, 13391, 13392, 13393, 13394, 13395, 13396, 13404,
   13412, 13413, 13414, 13417, 13418, 13421, 13423, 13427, 13515, 13516,
   13523, 13524, 13525, 13531, 13540, 13543, 13544, 13545, 13546, 13549,
   13550, 13551, 13554, 13556, 13564, 13565, 13571, 13579, 13580, 13583,
   13584, 13587, 13592, 13599, 13604, 13611, 13618, 13618, 13620, 13627,
   13628, 13631, 13632, 13633, 13634, 13635, 13636, 13637, 13638, 13639,
   13645, 13652, 13664, 13670, 13677, 13685, 13686, 13698, 13709, 13720,
   13724, 13725, 13728, 13733, 13737, 13738, 13741, 13747, 13755, 13758,
   13765, 13769, 13770, 13773, 13776, 13780, 13781, 13784, 13790, 13798,
   13799, 13808, 13817, 13829, 13830, 13831, 13832, 13833, 13834, 13835,
   13836, 13837, 13838, 13839, 13840, 13841, 13842, 13843, 13850, 13851,
   13854, 13855, 13862, 13863, 13864, 13871, 13870, 13887, 13888, 13895,
   13894, 13964, 13970, 13976, 13984, 13990, 13996, 14002, 14008, 14014,
   14020, 14026, 14032, 14043, 14044, 14047, 14048, 14049, 14050, 14051,
   14052, 14053, 14054, 14055, 14056, 14057, 14058, 14059, 14060, 14061,
   14062, 14063, 14064, 14065, 14066, 14067, 14068, 14069, 14070, 14073,
   14074, 14075, 14076, 14077, 14078, 14082, 14083, 14084, 14085, 14086,
   14087, 14088, 14091, 14094, 14095, 14096, 14097, 14098, 14099, 14100,
   14101, 14114, 14115, 14116, 14117, 14118, 14119, 14120, 14125, 14126,
   14127, 14128, 14129, 14130, 14136, 14137, 14138, 14139, 14140, 14141,
   14142, 14143, 14144, 14145, 14146, 14149, 14150, 14151, 14152, 14153,
   14156, 14157, 14158, 14159, 14162, 14163, 14164, 14165, 14166, 14167,
   14168, 14185, 14186, 14187, 14190, 14191, 14192, 14193, 14194, 14195,
   14199, 14199, 14202, 14208, 14209, 14212, 14214, 14219, 14229, 14240,
   14247, 14248, 14249, 14252, 14285, 14287, 14289, 14292, 14302, 14312,
   14322, 14323, 14326, 14328, 14329, 14330, 14333, 14335, 14343, 14344,
   14345, 14349, 14350, 14354, 14355, 14358, 14359, 14362, 14363, 14364,
   14365, 14366, 14369, 14370, 14371, 14372, 14373, 14374, 14375, 14376,
   14377, 14378, 14379, 14380, 14381, 14382, 14383, 14384, 14385, 14386,
   14387, 14388, 14389, 14390, 14391, 14392, 14393, 14394, 14395, 14396,
   14397, 14398, 14399, 14400, 14401, 14402, 14403, 14404, 14405, 14406,
   14407, 14408, 14409, 14410, 14411, 14412, 14413, 14414, 14415, 14416,
   14417, 14418, 14419, 14420, 14421, 14422, 14423, 14424, 14427, 14428,
   14429, 14430, 14433, 14434, 14435, 14436, 14437, 14438, 14439, 14440,
   14441, 14444, 14445, 14446, 14447, 14448, 14451, 14452, 14455, 14456,
   14467, 14468
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT",
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT",
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE",
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR",
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO",
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER",
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN",
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH",
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT",
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT",
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED",
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO",
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN",
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL",
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB",
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP",
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST",
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST",
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION",
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS",
  "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION",
  "ASSIGNMENT", "ASYMMETRIC", "AT", "ATTRIBUTE", "AUTHORIZATION",
  "BACKWARD", "BARRIER", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT",
  "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE",
  "CASCADED", "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", "CHARACTER",
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLEAN", "CLOSE",
  "CLUSTER", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMENT",
  "COMMENTS", "COMMIT", "COMMITTED", "CONCURRENTLY", "CONFIGURATION",
  "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P",
  "CONVERSION_P", "COORDINATOR", "COPY", "COST", "CREATE", "CROSS", "CSV",
  "CURRENT_P", "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_ROLE",
  "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER",
  "CURSOR", "CYCLE", "DATA_P", "DATABASE", "DAY_P", "DEALLOCATE", "DEC",
  "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED",
  "DEFINER", "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY",
  "DIRECT", "DISABLE_P", "DISCARD", "DISTINCT", "DISTRIBUTE", "DO",
  "DOCUMENT_P", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", "ENABLE_P",
  "ENCODING", "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE", "EXCEPT",
  "EXCLUDE", "EXCLUDING", "EXCLUSIVE", "EXECUTE", "EXISTS", "EXPLAIN",
  "EXTENSION", "EXTERNAL", "EXTRACT", "FALSE_P", "FAMILY", "FETCH",
  "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE", "FOREIGN", "FORWARD",
  "FREEZE", "FROM", "FULL", "FUNCTION", "FUNCTIONS", "GLOBAL", "GRANT",
  "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HASH", "HAVING",
  "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", "IMMEDIATE",
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX",
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INLINE_P", "INNER_P",
  "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P",
  "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL",
  "ISOLATION", "JOIN", "KEY", "LABEL", "LANGUAGE", "LARGE_P", "LAST_P",
  "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAST", "LEFT", "LEVEL",
  "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME",
  "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "MAPPING", "MATCH", "MAXVALUE",
  "MINUTE_P", "MINVALUE", "MODE", "MODULO", "MONTH_P", "MOVE", "NAME_P",
  "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NODE", "NONE",
  "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF",
  "NULLS_P", "NUMERIC", "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "ON",
  "ONLY", "OPERATOR", "OPTION", "OPTIONS", "OR", "ORDER", "OUT_P",
  "OUTER_P", "OVER", "OVERLAPS", "OVERLAY", "OWNED", "OWNER", "PARSER",
  "PARTIAL", "PARTITION", "PASSING", "PASSWORD", "PLACING", "PLANS",
  "POSITION", "PRECEDING", "PRECISION", "PREFERRED", "PRESERVE", "PREPARE",
  "PREPARED", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE",
  "QUOTE", "RANGE", "READ", "REAL", "REASSIGN", "RECHECK", "RECURSIVE",
  "REF", "REFERENCES", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME",
  "REPEATABLE", "REPLACE", "REPLICA", "REPLICATION", "RESET", "RESTART",
  "RESTRICT", "RETURNING", "RETURNS", "REVOKE", "RIGHT", "ROBIN", "ROLE",
  "ROLLBACK", "ROUND", "ROW", "ROWS", "RULE", "SAVEPOINT", "SCHEMA",
  "SCROLL", "SEARCH", "SECOND_P", "SECURITY", "SELECT", "SEQUENCE",
  "SEQUENCES", "SERIALIZABLE", "SERVER", "SESSION", "SESSION_USER", "SET",
  "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME",
  "STABLE", "STANDALONE_P", "START", "STATEMENT", "STATISTICS", "STDIN",
  "STDOUT", "STORAGE", "STRICT_P", "STRIP_P", "SUBSTRING", "SYMMETRIC",
  "SYSID", "SYSTEM_P", "TABLE", "TABLES", "TABLESPACE", "TEMP", "TEMPLATE",
  "TEMPORARY", "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING",
  "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE",
  "TRUSTED", "TYPE_P", "UNBOUNDED", "UNCOMMITTED", "UNENCRYPTED", "UNION",
  "UNIQUE", "UNKNOWN", "UNLISTEN", "UNLOGGED", "UNTIL", "UPDATE", "USER",
  "USING", "VACUUM", "VALID", "VALIDATE", "VALIDATOR", "VALUE_P", "VALUES",
  "VARCHAR", "VARIADIC", "VARYING", "VERBOSE", "VERSION_P", "VIEW",
  "VOLATILE", "WHEN", "WHERE", "WHITESPACE_P", "WINDOW", "WITH", "WITHOUT",
  "WORK", "WRAPPER", "WRITE", "XML_P", "XMLATTRIBUTES", "XMLCONCAT",
  "XMLELEMENT", "XMLEXISTS", "XMLFOREST", "XMLPARSE", "XMLPI", "XMLROOT",
  "XMLSERIALIZE", "YEAR_P", "YES_P", "ZONE", "NULLS_FIRST", "NULLS_LAST",
  "WITH_TIME", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'",
  "'/'", "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "','",
  "';'", "':'", "'{'", "'}'", "$accept", "prog", "stmt", "CreateRoleStmt",
  "opt_with", "OptRoleList", "AlterOptRoleList", "AlterOptRoleElem",
  "CreateOptRoleElem", "CreateUserStmt", "AlterRoleStmt",
  "opt_in_database", "AlterRoleSetStmt", "AlterUserStmt",
  "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", "CreateGroupStmt",
  "AlterGroupStmt", "add_drop", "DropGroupStmt", "CreateSchemaStmt",
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt",
  "set_rest", "var_name", "var_list", "var_value", "iso_level",
  "opt_boolean_or_string", "zone_value", "opt_encoding", "ColId_or_Sconst",
  "VariableResetStmt", "SetResetClause", "VariableShowStmt",
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode",
  "CheckPointStmt", "DiscardStmt", "AlterTableStmt", "alter_table_cmds",
  "alter_table_cmd", "alter_column_default", "opt_drop_behavior",
  "opt_collate_clause", "alter_using", "reloptions", "opt_reloptions",
  "reloption_list", "reloption_elem", "AlterCompositeTypeStmt",
  "alter_type_cmds", "alter_type_cmd", "ClosePortalStmt", "CopyStmt",
  "copy_from", "copy_file_name", "copy_options", "copy_opt_list",
  "copy_opt_item", "opt_binary", "opt_oids", "copy_delimiter", "opt_using",
  "copy_generic_opt_list", "copy_generic_opt_elem", "copy_generic_opt_arg",
  "copy_generic_opt_arg_list", "copy_generic_opt_arg_list_item",
  "CreateStmt", "OptTemp", "OptTableElementList",
  "OptTypedTableElementList", "TableElementList", "TypedTableElementList",
  "TableElement", "TypedTableElement", "columnDef", "columnOptions",
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr",
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption",
  "TableConstraint", "ConstraintElem", "opt_column_list", "columnList",
  "columnElem", "key_match", "ExclusionConstraintList",
  "ExclusionConstraintElem", "ExclusionWhereClause", "key_actions",
  "key_update", "key_delete", "key_action", "OptInherit", "OptWith",
  "OnCommitOption", "OptTableSpace", "DistributeByHash", "OptDistributeBy",
  "OptSubCluster", "OptConsTableSpace", "ExistingIndex",
  "create_as_target", "OptCreateAs", "CreateAsList", "CreateAsElement",
  "opt_with_data", "CreateSeqStmt", "AlterSeqStmt", "OptSeqOptList",
  "SeqOptList", "SeqOptElem", "opt_by", "NumericOnly", "NumericOnly_list",
  "CreatePLangStmt", "opt_trusted", "handler_name", "opt_inline_handler",
  "validator_clause", "opt_validator", "DropPLangStmt", "opt_procedural",
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt",
  "CreateExtensionStmt", "create_extension_opt_list",
  "create_extension_opt_item", "AlterExtensionStmt",
  "alter_extension_opt_list", "alter_extension_opt_item",
  "AlterExtensionContentsStmt", "CreateFdwStmt", "fdw_option",
  "fdw_options", "opt_fdw_options", "DropFdwStmt", "AlterFdwStmt",
  "create_generic_options", "generic_option_list", "alter_generic_options",
  "alter_generic_option_list", "alter_generic_option_elem",
  "generic_option_elem", "generic_option_name", "generic_option_arg",
  "CreateForeignServerStmt", "opt_type", "foreign_server_version",
  "opt_foreign_server_version", "DropForeignServerStmt",
  "AlterForeignServerStmt", "CreateForeignTableStmt",
  "OptForeignTableElementList", "ForeignTableElementList",
  "ForeignTableElement", "AlterForeignTableStmt", "CreateUserMappingStmt",
  "auth_ident", "DropUserMappingStmt", "AlterUserMappingStmt",
  "CreateTrigStmt", "TriggerActionTime", "TriggerEvents",
  "TriggerOneEvent", "TriggerForSpec", "TriggerForOptEach",
  "TriggerForType", "TriggerWhen", "TriggerFuncArgs", "TriggerFuncArg",
  "OptConstrFromTable", "ConstraintAttributeSpec",
  "ConstraintAttributeElem", "DropTrigStmt", "CreateAssertStmt",
  "DropAssertStmt", "DefineStmt", "definition", "def_list", "def_elem",
  "def_arg", "aggr_args", "old_aggr_definition", "old_aggr_list",
  "old_aggr_elem", "opt_enum_val_list", "enum_val_list", "AlterEnumStmt",
  "CreateOpClassStmt", "opclass_item_list", "opclass_item", "opt_default",
  "opt_opfamily", "opclass_purpose", "opt_recheck", "CreateOpFamilyStmt",
  "AlterOpFamilyStmt", "opclass_drop_list", "opclass_drop",
  "DropOpClassStmt", "DropOpFamilyStmt", "DropOwnedStmt",
  "ReassignOwnedStmt", "DropStmt", "drop_type", "any_name_list",
  "any_name", "attrs", "TruncateStmt", "opt_restart_seqs", "CommentStmt",
  "comment_type", "comment_text", "SecLabelStmt", "opt_provider",
  "security_label_type", "security_label", "FetchStmt", "fetch_args",
  "from_in", "opt_from_in", "GrantStmt", "RevokeStmt", "privileges",
  "privilege_list", "privilege", "privilege_target", "grantee_list",
  "grantee", "opt_grant_grant_option", "function_with_argtypes_list",
  "function_with_argtypes", "GrantRoleStmt", "RevokeRoleStmt",
  "opt_grant_admin_option", "opt_granted_by", "AlterDefaultPrivilegesStmt",
  "DefACLOptionList", "DefACLOption", "DefACLAction",
  "defacl_privilege_target", "IndexStmt", "opt_unique", "opt_concurrently",
  "opt_index_name", "access_method_clause", "index_params", "index_elem",
  "opt_collate", "opt_class", "opt_asc_desc", "opt_nulls_order",
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list",
  "func_args_with_defaults", "func_args_with_defaults_list", "func_arg",
  "arg_class", "param_name", "func_return", "func_type",
  "func_arg_with_default", "createfunc_opt_list", "common_func_opt_item",
  "createfunc_opt_item", "func_as", "opt_definition", "table_func_column",
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list",
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt",
  "oper_argtypes", "any_operator", "DoStmt", "dostmt_opt_list",
  "dostmt_opt_item", "CreateCastStmt", "cast_context", "DropCastStmt",
  "opt_if_exists", "ReindexStmt", "reindex_type", "opt_force",
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt",
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti",
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead",
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt",
  "UnlistenStmt", "TransactionStmt", "opt_transaction",
  "transaction_mode_item", "transaction_mode_list",
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option",
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item",
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt",
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", "CreateDomainStmt",
  "AlterDomainStmt", "opt_as", "AlterTSDictionaryStmt",
  "AlterTSConfigurationStmt", "CreateConversionStmt", "ClusterStmt",
  "cluster_index_specification", "VacuumStmt", "vacuum_option_list",
  "vacuum_option_elem", "AnalyzeStmt", "analyze_keyword", "opt_verbose",
  "opt_full", "opt_freeze", "opt_name_list", "BarrierStmt",
  "opt_barrier_id", "CreateNodeStmt", "pgxcnode_name", "pgxcgroup_name",
  "pgxcnode_list", "AlterNodeStmt", "DropNodeStmt", "CreateNodeGroupStmt",
  "DropNodeGroupStmt", "ExplainStmt", "ExplainableStmt",
  "explain_option_list", "explain_option_elem", "explain_option_name",
  "explain_option_arg", "ExecDirectStmt", "DirectStmt", "CleanConnStmt",
  "CleanConnDbName", "CleanConnUserName", "PrepareStmt",
  "prep_type_clause", "PreparableStmt", "ExecuteStmt",
  "execute_param_clause", "InsertStmt", "insert_rest",
  "insert_column_list", "insert_column_item", "returning_clause",
  "DeleteStmt", "using_clause", "LockStmt", "opt_lock", "lock_type",
  "opt_nowait", "UpdateStmt", "set_clause_list", "set_clause",
  "single_set_clause", "multiple_set_clause", "set_target",
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options",
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens",
  "select_clause", "simple_select", "with_clause", "cte_list",
  "common_table_expr", "opt_with_clause", "into_clause",
  "OptTempTableName", "opt_table", "opt_all", "opt_distinct",
  "opt_sort_clause", "sort_clause", "sortby_list", "sortby",
  "select_limit", "opt_select_limit", "limit_clause", "offset_clause",
  "select_limit_value", "select_offset_value",
  "opt_select_fetch_first_value", "select_offset_value2", "row_or_rows",
  "first_or_next", "group_clause", "having_clause", "for_locking_clause",
  "opt_for_locking_clause", "for_locking_items", "for_locking_item",
  "locked_rels_list", "values_clause", "from_clause", "from_list",
  "table_ref", "joined_table", "alias_clause", "join_type", "join_outer",
  "join_qual", "relation_expr", "relation_expr_list",
  "relation_expr_opt_alias", "func_table", "where_clause",
  "where_or_current_clause", "OptTableFuncElementList",
  "TableFuncElementList", "TableFuncElement", "Typename",
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType",
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit",
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter",
  "CharacterWithLength", "CharacterWithoutLength", "character",
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval",
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr",
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone",
  "xml_attributes", "xml_attribute_list", "xml_attribute_el",
  "document_or_content", "xml_whitespace_option", "xmlexists_argument",
  "window_clause", "window_definition_list", "window_definition",
  "over_clause", "window_specification", "opt_existing_window_name",
  "opt_partition_clause", "opt_frame_clause", "frame_extent",
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op",
  "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list",
  "func_arg_expr", "type_list", "array_expr", "array_expr_list",
  "extract_list", "extract_arg", "overlay_list", "overlay_placing",
  "position_list", "substr_list", "substr_from", "substr_for", "trim_list",
  "in_expr", "case_expr", "when_clause_list", "when_clause",
  "case_default", "case_arg", "columnref", "indirection_el", "indirection",
  "opt_indirection", "opt_asymmetric", "ctext_expr", "ctext_expr_list",
  "ctext_row", "target_list", "target_el", "qualified_name_list",
  "qualified_name", "name_list", "name", "database_name", "access_method",
  "attr_name", "index_name", "file_name", "func_name", "AexprConst",
  "Iconst", "RoleId", "SignedIconst", "unreserved_keyword",
  "col_name_keyword", "type_func_name_keyword", "reserved_keyword",
  "statements", "statement", "CreateAsStmt", "$@1", "at", "ECPGConnect",
  "connection_target", "opt_database_name", "db_prefix", "server",
  "opt_server", "server_name", "opt_port", "opt_connection_name",
  "opt_user", "ora_user", "user_name", "char_variable", "opt_options",
  "connect_options", "opt_opt_value", "prepared_name", "ECPGCursorStmt",
  "ECPGExecuteImmediateStmt", "ECPGVarDeclaration",
  "single_vt_declaration", "precision", "opt_scale", "ecpg_interval",
  "ECPGDeclaration", "$@2", "sql_startdeclare", "sql_enddeclare",
  "var_type_declarations", "vt_declarations", "variable_declarations",
  "type_declaration", "$@3", "var_declaration", "$@4", "$@5",
  "opt_bit_field", "storage_declaration", "storage_clause",
  "storage_modifier", "var_type", "enum_type", "enum_definition",
  "struct_union_type_with_symbol", "$@6", "struct_union_type", "$@7",
  "s_struct_union_symbol", "s_struct_union", "simple_type",
  "unsigned_type", "signed_type", "opt_signed", "variable_list",
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare",
  "ECPGDisconnect", "dis_name", "connection_object", "execstring",
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using",
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list",
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output",
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader",
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem",
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems",
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item",
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem",
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem",
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off",
  "ECPGSetConnection", "ECPGTypedef", "$@8", "opt_reference", "ECPGVar",
  "$@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames",
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId",
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon",
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval",
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind",
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param",
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", "ecpg_ident",
  "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", "c_term",
  "c_thing", "c_anything", "DeallocateStmt", "Iresult", "execute_rest",
  "ecpg_into", "ecpg_fetch_into", "opt_ecpg_fetch_into", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,    61,
      60,    62,   754,    43,    45,    42,    47,    37,    94,   755,
      91,    93,    40,    41,    46,    44,    59,    58,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   520,   521,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   522,   522,   522,   522,   522,   522,   522,   522,   522,
     522,   523,   524,   524,   525,   525,   526,   526,   527,   527,
     527,   527,   527,   527,   527,   527,   527,   527,   528,   528,
     528,   528,   528,   528,   529,   530,   531,   531,   532,   533,
     534,   535,   535,   536,   536,   537,   538,   539,   539,   540,
     540,   541,   541,   542,   542,   543,   543,   544,   544,   544,
     544,   544,   544,   545,   545,   545,   546,   546,   546,   546,
     546,   546,   546,   546,   546,   546,   546,   546,   546,   546,
     546,   547,   547,   548,   548,   549,   549,   550,   550,   550,
     550,   551,   551,   551,   551,   552,   552,   552,   552,   552,
     552,   552,   553,   553,   553,   554,   554,   555,   555,   555,
     555,   555,   556,   556,   557,   557,   557,   557,   557,   558,
     559,   559,   560,   560,   561,   562,   562,   562,   562,   563,
     563,   563,   563,   564,   564,   565,   565,   565,   565,   565,
     565,   565,   565,   565,   565,   565,   565,   565,   565,   565,
     565,   565,   565,   565,   565,   565,   565,   565,   565,   565,
     565,   565,   565,   565,   565,   565,   565,   565,   565,   565,
     565,   565,   565,   565,   565,   565,   566,   566,   567,   567,
     567,   568,   568,   569,   569,   570,   571,   571,   572,   572,
     573,   573,   573,   573,   574,   575,   575,   576,   576,   576,
     576,   577,   577,   578,   578,   579,   579,   580,   580,   580,
     581,   581,   582,   582,   583,   583,   583,   583,   583,   583,
     583,   583,   583,   583,   583,   583,   584,   584,   585,   585,
     586,   586,   587,   587,   588,   588,   589,   590,   590,   590,
     590,   590,   591,   591,   592,   593,   593,   593,   593,   594,
     594,   594,   594,   594,   594,   594,   594,   595,   595,   596,
     596,   597,   597,   598,   598,   599,   599,   599,   600,   600,
     601,   602,   603,   603,   604,   604,   604,   604,   605,   605,
     605,   605,   605,   605,   605,   606,   606,   606,   606,   607,
     608,   608,   608,   609,   609,   609,   609,   609,   609,   610,
     610,   611,   611,   611,   611,   611,   611,   611,   612,   612,
     613,   613,   614,   615,   615,   615,   615,   616,   616,   617,
     617,   618,   618,   619,   619,   619,   619,   619,   620,   621,
     622,   622,   622,   622,   622,   623,   623,   624,   624,   624,
     624,   625,   625,   625,   625,   626,   626,   627,   627,   628,
     628,   628,   628,   628,   629,   629,   629,   630,   630,   631,
     632,   633,   633,   634,   634,   635,   636,   636,   636,   637,
     638,   639,   639,   640,   640,   641,   641,   641,   641,   641,
     641,   641,   641,   641,   641,   641,   641,   642,   642,   643,
     643,   643,   644,   644,   645,   645,   646,   646,   647,   647,
     648,   648,   649,   649,   650,   650,   651,   651,   652,   652,
     653,   654,   654,   655,   655,   656,   656,   657,   657,   658,
     658,   658,   659,   660,   660,   661,   662,   662,   662,   662,
     662,   662,   662,   662,   662,   662,   662,   662,   662,   662,
     662,   662,   662,   662,   662,   662,   662,   662,   663,   664,
     664,   664,   664,   665,   665,   666,   666,   667,   667,   668,
     668,   669,   669,   670,   670,   671,   672,   672,   673,   673,
     673,   673,   674,   675,   676,   677,   678,   678,   679,   679,
     680,   680,   681,   681,   682,   682,   682,   683,   683,   684,
     684,   685,   685,   686,   687,   688,   689,   689,   689,   690,
     690,   691,   692,   692,   693,   693,   693,   694,   694,   695,
     695,   695,   695,   695,   696,   696,   697,   697,   698,   698,
     699,   699,   700,   700,   700,   701,   701,   701,   701,   702,
     702,   703,   703,   704,   704,   704,   704,   704,   705,   705,
     706,   707,   708,   708,   708,   708,   708,   708,   708,   708,
     708,   708,   708,   708,   708,   709,   710,   710,   711,   711,
     712,   712,   712,   712,   712,   713,   713,   714,   715,   715,
     716,   717,   717,   718,   718,   719,   719,   719,   720,   721,
     721,   722,   722,   722,   722,   722,   723,   723,   724,   724,
     725,   725,   725,   726,   726,   727,   728,   728,   729,   729,
     730,   730,   731,   731,   732,   732,   733,   734,   735,   735,
     736,   736,   736,   736,   736,   736,   736,   736,   736,   736,
     736,   736,   736,   736,   736,   737,   737,   738,   738,   739,
     739,   740,   741,   741,   741,   742,   742,   742,   742,   742,
     742,   742,   742,   742,   742,   742,   742,   742,   742,   742,
     742,   742,   743,   743,   743,   743,   743,   743,   743,   743,
     743,   743,   743,   743,   743,   743,   743,   743,   743,   744,
     744,   745,   745,   745,   745,   745,   746,   746,   747,   747,
     747,   747,   747,   747,   747,   747,   748,   748,   749,   749,
     749,   749,   749,   749,   749,   749,   749,   749,   749,   750,
     750,   750,   750,   750,   750,   750,   750,   750,   750,   750,
     750,   750,   750,   751,   751,   752,   752,   753,   754,   754,
     755,   755,   755,   755,   755,   756,   756,   757,   757,   757,
     757,   758,   758,   758,   758,   758,   758,   758,   758,   758,
     758,   758,   758,   758,   758,   759,   759,   760,   760,   761,
     761,   762,   762,   763,   764,   765,   765,   766,   766,   767,
     767,   768,   769,   769,   770,   770,   770,   771,   771,   771,
     772,   772,   772,   773,   774,   774,   775,   775,   776,   776,
     777,   777,   778,   778,   779,   779,   779,   780,   780,   781,
     781,   781,   782,   782,   782,   783,   783,   783,   784,   784,
     784,   785,   785,   786,   786,   787,   787,   788,   788,   789,
     789,   790,   790,   790,   790,   790,   791,   791,   791,   791,
     791,   792,   793,   794,   794,   794,   795,   795,   795,   796,
     796,   797,   797,   797,   797,   797,   797,   797,   797,   797,
     797,   797,   797,   797,   798,   798,   798,   798,   799,   799,
     800,   800,   801,   802,   802,   803,   804,   804,   805,   805,
     806,   806,   807,   807,   808,   808,   809,   809,   809,   809,
     810,   810,   811,   812,   812,   813,   813,   814,   814,   814,
     815,   815,   815,   816,   817,   817,   818,   818,   818,   819,
     819,   820,   820,   821,   821,   821,   821,   821,   821,   821,
     821,   821,   821,   821,   821,   821,   821,   821,   821,   821,
     821,   821,   821,   821,   821,   821,   821,   821,   821,   821,
     821,   821,   822,   822,   823,   823,   824,   824,   824,   824,
     824,   824,   824,   824,   824,   824,   824,   824,   824,   824,
     824,   824,   824,   824,   825,   825,   825,   825,   825,   825,
     825,   825,   825,   825,   825,   825,   825,   825,   825,   825,
     825,   825,   826,   827,   827,   827,   828,   828,   829,   829,
     829,   829,   829,   830,   830,   831,   831,   831,   831,   832,
     832,   832,   833,   833,   834,   835,   835,   836,   837,   837,
     838,   838,   838,   838,   838,   838,   838,   838,   838,   838,
     838,   838,   838,   838,   839,   839,   839,   840,   840,   840,
     840,   840,   841,   841,   841,   842,   842,   843,   843,   844,
     844,   844,   844,   845,   846,   847,   847,   848,   848,   848,
     848,   848,   848,   848,   848,   848,   848,   848,   848,   848,
     848,   848,   848,   849,   849,   850,   850,   851,   852,   852,
     853,   854,   854,   855,   856,   856,   856,   856,   856,   857,
     857,   858,   859,   859,   859,   859,   859,   859,   860,   861,
     861,   861,   862,   862,   863,   863,   863,   863,   863,   864,
     864,   865,   865,   865,   865,   866,   866,   867,   867,   868,
     868,   869,   869,   870,   870,   871,   871,   872,   873,   873,
     874,   875,   876,   877,   877,   878,   879,   880,   881,   882,
     882,   882,   882,   883,   883,   883,   883,   883,   883,   883,
     884,   884,   885,   886,   886,   886,   887,   887,   887,   888,
     889,   890,   890,   890,   891,   891,   891,   892,   892,   892,
     893,   893,   894,   894,   895,   895,   895,   895,   896,   896,
     897,   897,   898,   899,   899,   899,   900,   900,   901,   902,
     902,   903,   904,   904,   905,   906,   906,   907,   907,   907,
     907,   907,   907,   907,   907,   908,   908,   909,   910,   910,
     911,   911,   912,   913,   914,   915,   915,   916,   917,   917,
     918,   918,   918,   918,   918,   919,   919,   919,   920,   920,
     921,   921,   922,   922,   922,   922,   922,   922,   922,   922,
     923,   923,   924,   924,   924,   924,   924,   924,   925,   925,
     926,   926,   927,   928,   928,   929,   929,   929,   930,   930,
     930,   930,   930,   930,   930,   930,   930,   931,   931,   932,
     932,   932,   933,   933,   933,   933,   934,   934,   935,   936,
     936,   937,   937,   938,   938,   938,   938,   939,   939,   940,
     940,   940,   941,   941,   942,   942,   943,   944,   944,   944,
     945,   946,   946,   947,   947,   948,   948,   949,   949,   950,
     950,   951,   951,   952,   952,   953,   953,   954,   954,   955,
     955,   956,   956,   957,   957,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   959,   959,   959,   959,
     959,   959,   960,   960,   960,   960,   961,   961,   961,   961,
     962,   962,   963,   963,   964,   964,   964,   964,   965,   965,
     966,   966,   966,   967,   968,   968,   969,   969,   969,   970,
     970,   971,   971,   972,   973,   973,   973,   973,   973,   973,
     974,   974,   974,   975,   975,   975,   975,   975,   975,   975,
     976,   976,   976,   976,   977,   977,   978,   978,   979,   979,
     979,   979,   979,   979,   979,   979,   979,   979,   979,   980,
     980,   981,   981,   982,   982,   983,   984,   985,   985,   986,
     986,   987,   988,   989,   989,   989,   989,   989,   989,   990,
     990,   991,   991,   992,   992,   992,   992,   993,   994,   994,
     994,   995,   995,   995,   995,   995,   995,   995,   995,   995,
     995,   995,   995,   995,   995,   996,   996,   997,   997,   997,
     997,   997,   997,   997,   997,   997,   997,   997,   997,   997,
     997,   997,   997,   997,   997,   997,   997,   997,   997,   997,
     997,   997,   997,   997,   997,   997,   997,   997,   997,   997,
     997,   997,   997,   997,   997,   997,   997,   997,   997,   997,
     997,   997,   997,   997,   997,   997,   997,   997,   997,   997,
     997,   997,   997,   997,   997,   997,   998,   998,   998,   998,
     998,   998,   998,   998,   998,   998,   998,   998,   998,   998,
     998,   998,   998,   998,   998,   998,   998,   998,   999,   999,
     999,   999,   999,   999,   999,   999,   999,   999,   999,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1001,  1001,
    1002,  1002,  1002,  1002,  1003,  1004,  1004,  1005,  1005,  1006,
    1006,  1007,  1007,  1007,  1008,  1008,  1008,  1008,  1009,  1009,
    1010,  1010,  1011,  1012,  1012,  1012,  1013,  1014,  1014,  1015,
    1015,  1016,  1016,  1016,  1017,  1017,  1018,  1018,  1018,  1018,
    1018,  1019,  1019,  1019,  1020,  1020,  1020,  1021,  1021,  1022,
    1022,  1022,  1022,  1022,  1022,  1022,  1022,  1022,  1023,  1023,
    1024,  1024,  1025,  1025,  1025,  1025,  1025,  1025,  1026,  1026,
    1027,  1027,  1028,  1028,  1029,  1029,  1030,  1030,  1030,  1031,
    1031,  1032,  1032,  1033,  1033,  1033,  1033,  1033,  1033,  1033,
    1033,  1034,  1034,  1035,  1036,  1036,  1037,  1037,  1037,  1037,
    1037,  1037,  1038,  1039,  1040,  1040,  1040,  1041,  1041,  1042,
    1043,  1043,  1044,  1045,  1045,  1046,  1046,  1047,  1047,  1048,
    1048,  1048,  1048,  1049,  1049,  1050,  1050,  1051,  1051,  1052,
    1052,  1053,  1053,  1054,  1055,  1055,  1056,  1056,  1056,  1056,
    1057,  1057,  1058,  1058,  1059,  1059,  1060,  1061,  1062,  1063,
    1064,  1065,  1066,  1066,  1067,  1067,  1067,  1067,  1067,  1067,
    1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1067,  1068,
    1069,  1070,  1070,  1070,  1070,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,  1071,
    1071,  1071,  1071,  1071,  1071,  1071,  1072,  1072,  1072,  1072,
    1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,
    1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,
    1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,
    1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,  1072,
    1073,  1073,  1073,  1073,  1073,  1073,  1073,  1073,  1073,  1073,
    1073,  1073,  1073,  1073,  1073,  1073,  1073,  1073,  1073,  1073,
    1073,  1073,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,
    1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,
    1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,
    1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,
    1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,
    1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,
    1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,  1074,
    1074,  1074,  1074,  1074,  1074,  1074,  1075,  1075,  1076,  1076,
    1076,  1076,  1076,  1076,  1076,  1076,  1078,  1077,  1079,  1080,
    1080,  1080,  1080,  1081,  1081,  1081,  1081,  1082,  1082,  1083,
    1084,  1085,  1085,  1086,  1086,  1086,  1087,  1087,  1088,  1088,
    1089,  1089,  1090,  1090,  1090,  1090,  1091,  1091,  1091,  1092,
    1093,  1093,  1094,  1094,  1095,  1095,  1095,  1095,  1096,  1096,
    1097,  1098,  1099,  1100,  1100,  1101,  1102,  1102,  1103,  1103,
    1103,  1103,  1103,  1105,  1104,  1106,  1107,  1108,  1108,  1109,
    1109,  1109,  1109,  1110,  1110,  1112,  1111,  1114,  1113,  1115,
    1113,  1113,  1116,  1116,  1117,  1117,  1117,  1118,  1118,  1118,
    1118,  1119,  1119,  1120,  1120,  1120,  1120,  1120,  1120,  1121,
    1121,  1121,  1122,  1124,  1123,  1125,  1126,  1125,  1127,  1127,
    1128,  1128,  1129,  1129,  1130,  1130,  1130,  1130,  1130,  1130,
    1130,  1130,  1130,  1131,  1131,  1131,  1131,  1131,  1131,  1131,
    1131,  1131,  1131,  1132,  1132,  1133,  1133,  1134,  1135,  1135,
    1136,  1136,  1136,  1137,  1138,  1139,  1139,  1139,  1139,  1140,
    1140,  1140,  1141,  1141,  1142,  1142,  1143,  1144,  1144,  1145,
    1145,  1146,  1146,  1147,  1147,  1148,  1149,  1149,  1150,  1150,
    1150,  1151,  1151,  1151,  1151,  1151,  1151,  1151,  1151,  1151,
    1152,  1152,  1152,  1152,  1152,  1153,  1153,  1154,  1155,  1156,
    1157,  1157,  1158,  1159,  1160,  1160,  1161,  1162,  1162,  1163,
    1164,  1165,  1165,  1166,  1167,  1168,  1168,  1169,  1170,  1170,
    1170,  1170,  1170,  1171,  1171,  1171,  1171,  1171,  1171,  1171,
    1171,  1171,  1171,  1171,  1171,  1171,  1171,  1171,  1172,  1172,
    1173,  1173,  1174,  1174,  1174,  1176,  1175,  1177,  1177,  1179,
    1178,  1180,  1180,  1180,  1181,  1181,  1181,  1181,  1181,  1181,
    1181,  1181,  1181,  1182,  1182,  1183,  1183,  1183,  1183,  1183,
    1183,  1183,  1183,  1183,  1183,  1183,  1183,  1183,  1183,  1183,
    1183,  1183,  1183,  1183,  1183,  1183,  1183,  1183,  1183,  1184,
    1184,  1184,  1184,  1184,  1184,  1185,  1185,  1185,  1185,  1185,
    1185,  1185,  1186,  1187,  1187,  1187,  1187,  1187,  1187,  1187,
    1187,  1188,  1188,  1188,  1188,  1188,  1188,  1188,  1189,  1189,
    1189,  1189,  1189,  1189,  1190,  1190,  1190,  1190,  1190,  1190,
    1190,  1190,  1190,  1190,  1190,  1191,  1191,  1191,  1191,  1191,
    1192,  1192,  1192,  1192,  1193,  1193,  1193,  1193,  1193,  1193,
    1193,  1194,  1194,  1194,  1195,  1195,  1195,  1195,  1195,  1195,
    1196,  1196,  1197,  1198,  1198,  1199,  1199,  1200,  1201,  1202,
    1203,  1203,  1203,  1204,  1205,  1206,  1207,  1208,  1208,  1208,
    1208,  1208,  1209,  1210,  1210,  1210,  1211,  1211,  1212,  1212,
    1212,  1213,  1213,  1214,  1214,  1215,  1215,  1216,  1216,  1216,
    1216,  1216,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,
    1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,
    1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,
    1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,
    1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,
    1217,  1217,  1217,  1217,  1217,  1217,  1217,  1217,  1218,  1218,
    1218,  1218,  1219,  1219,  1219,  1219,  1219,  1219,  1219,  1219,
    1219,  1220,  1220,  1220,  1220,  1220,  1221,  1221,  1222,  1222,
    1223,  1223
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     5,     1,     0,     2,     0,     2,     0,     2,     2,
       3,     3,     1,     3,     3,     2,     1,     1,     1,     2,
       2,     2,     3,     3,     5,     5,     0,     3,     5,     5,
       4,     3,     5,     3,     5,     5,     6,     1,     1,     3,
       5,     6,     4,     1,     0,     2,     0,     1,     1,     1,
       1,     1,     1,     2,     3,     3,     3,     3,     3,     3,
       3,     3,     2,     5,     2,     2,     2,     2,     3,     3,
       3,     1,     3,     1,     3,     1,     1,     2,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     3,     6,     1,
       1,     1,     1,     1,     0,     1,     1,     2,     3,     4,
       3,     2,     2,     1,     3,     4,     5,     4,     2,     4,
       1,     1,     1,     1,     1,     2,     2,     2,     2,     4,
       4,     4,     4,     1,     3,     2,     3,     4,     6,     6,
       6,     5,     5,     6,     6,     4,     8,     2,     3,     6,
       4,     3,     3,     3,     3,     3,     4,     4,     3,     3,
       3,     3,     3,     3,     4,     4,     3,     2,     3,     2,
       2,     3,     3,     2,     2,     1,     3,     2,     1,     1,
       0,     2,     0,     2,     0,     3,     2,     0,     1,     3,
       3,     1,     5,     3,     4,     1,     3,     4,     6,     4,
       8,     2,     2,    10,     6,     1,     1,     1,     1,     1,
       1,     3,     2,     0,     1,     1,     3,     3,     1,     1,
       3,     3,     3,     3,     4,     2,     1,     0,     2,     0,
       3,     0,     1,     0,     1,     3,     2,     1,     1,     1,
       3,     0,     1,     3,     1,    13,    16,    12,    15,     1,
       1,     2,     2,     2,     2,     1,     0,     1,     0,     3,
       0,     1,     3,     1,     3,     1,     1,     1,     1,     1,
       3,     4,     2,     0,     3,     1,     1,     2,     2,     1,
       3,     4,     4,     2,     5,     1,     2,     2,     2,     3,
       3,     3,     0,     1,     1,     1,     1,     1,     1,     3,
       1,     5,     7,     3,     8,     4,     9,    11,     3,     0,
       1,     3,     1,     2,     2,     2,     0,     1,     3,     3,
       6,     4,     0,     1,     1,     2,     2,     0,     3,     3,
       2,     1,     1,     2,     2,     4,     0,     2,     2,     2,
       0,     3,     4,     4,     0,     2,     0,     2,     3,     4,
       6,     3,     4,     0,     3,     3,     0,     4,     0,     3,
       7,     3,     0,     1,     3,     1,     2,     3,     0,     5,
       4,     1,     0,     1,     2,     2,     1,     2,     3,     2,
       2,     2,     2,     3,     3,     1,     3,     1,     0,     1,
       2,     1,     1,     3,     6,    10,     1,     0,     1,     2,
       2,     0,     2,     2,     1,     0,     5,     7,     1,     0,
       6,     2,     0,     3,     5,     5,     8,     2,     0,     2,
       2,     2,     5,     2,     0,     2,     7,    10,     6,     6,
       6,     6,     7,     7,     9,     9,     6,     6,     8,     8,
       8,     8,     6,     6,     7,     8,     6,     6,     7,     2,
       2,     2,     2,     1,     2,     1,     0,     6,     8,     7,
       6,     4,     0,     1,     3,     4,     1,     3,     1,     2,
       2,     2,     2,     1,     1,    10,     2,     0,     2,     2,
       1,     0,     4,     6,     5,     4,     4,     8,    11,     3,
       2,     1,     3,     1,     5,     8,     1,     1,     1,     7,
       9,     8,    15,    20,     1,     1,     2,     1,     3,     1,
       1,     1,     3,     1,     3,     0,     1,     0,     1,     1,
       4,     0,     1,     3,     0,     1,     1,     1,     1,     2,
       0,     0,     2,     2,     1,     2,     2,     2,     6,     8,
       8,     4,     5,     4,     4,     4,     3,     7,     8,     6,
       6,     6,     6,     4,     5,     3,     1,     3,     3,     1,
       1,     1,     1,     1,     1,     3,     3,     3,     1,     3,
       3,     1,     0,     1,     3,     6,     8,     8,    13,     1,
       3,     5,     6,     4,     7,     2,     1,     0,     2,     0,
       2,     4,     0,     1,     0,     6,     8,     8,     1,     3,
       5,     5,     7,     9,     7,     9,     5,     6,     6,     4,
       1,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     3,     3,     3,     3,     1,     3,     1,     2,     2,
       3,     5,     2,     2,     0,     6,     7,     7,     7,     8,
       8,     6,     8,     9,     9,     7,    10,     7,     8,     8,
       8,     8,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     3,     1,
       1,     8,     9,     9,     9,     9,     2,     0,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       3,     4,     5,     4,     5,     3,     4,     3,     4,     1,
       2,     3,     3,     3,     3,     4,     4,     3,     3,     4,
       4,     4,     4,     1,     1,     1,     0,     7,     7,    10,
       1,     1,     2,     4,     5,     1,     3,     2,     2,     2,
       2,     1,     2,     2,     4,     3,     2,     2,     2,     3,
       2,     2,     5,     5,     5,     1,     3,     1,     2,     3,
       0,     1,     3,     2,     6,     6,     9,     3,     0,     3,
       0,     5,     2,     0,     3,     3,     3,     7,     7,    10,
       1,     1,     1,    14,     1,     0,     1,     0,     1,     0,
       2,     0,     1,     3,     5,     5,     7,     2,     0,     1,
       2,     0,     1,     1,     0,     1,     1,     0,     9,    12,
       7,     2,     0,     3,     2,     1,     3,     3,     2,     1,
       3,     3,     3,     2,     2,     1,     1,     1,     1,     2,
       1,     1,     1,     1,     4,     5,     1,     3,     3,     1,
       2,     4,     5,     1,     1,     1,     1,     3,     3,     2,
       2,     2,     2,     1,     2,     2,     1,     1,     1,     3,
       2,     0,     2,     1,     3,     5,     1,     2,     1,     0,
       5,     7,     5,     7,     5,     7,     3,     5,     5,     5,
       1,     3,     2,     1,     2,     1,     2,    11,    10,    10,
       2,     2,     0,     9,     2,     0,     4,     4,     4,     1,
       1,     1,     0,     7,     6,     6,     6,     6,     6,     7,
       9,     9,     6,     6,     6,     6,     6,     7,     8,     9,
       8,     6,     6,     6,     5,     5,     8,     8,     8,     8,
       6,     9,     1,     0,     2,     0,     7,     6,     6,     6,
       6,     6,     7,     9,     9,     6,     8,     8,     8,     8,
       6,     6,     7,     6,     7,     6,     6,     6,     6,     6,
       7,     7,     7,     9,     9,     6,     6,     6,     8,     8,
       8,     6,    13,     1,     1,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     1,     1,     1,     1,
       1,     0,     6,     8,     3,     2,     0,     2,     2,     2,
       2,     3,     3,     2,     2,     2,     2,     3,     2,     5,
       4,     3,     3,     3,     1,     1,     0,     3,     2,     2,
       1,     2,     1,     3,     2,     1,     0,     8,    10,     3,
       4,     4,     0,     2,     5,     2,     0,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       4,     3,     3,     1,     0,     5,     6,     4,     2,     0,
       4,     3,     5,     6,     4,     6,     6,     5,     7,     1,
       0,     6,    11,    11,    11,    13,     9,    11,    10,     4,
       2,     5,     2,     0,     4,     5,     5,     4,     6,     1,
       3,     1,     1,     1,     1,     2,     4,     1,     1,     1,
       0,     1,     0,     1,     0,     3,     0,     3,     1,     0,
       4,     1,     1,     3,     1,     4,     3,     6,     4,     2,
       4,     3,     5,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     2,     1,     1,     1,     1,     1,     0,     5,
       1,     7,     7,     7,     3,     2,     0,     3,     2,     0,
       5,     4,     3,     0,     1,     1,     1,     1,     4,     8,
       3,     0,     6,     1,     4,     2,     1,     3,     2,     3,
       0,     7,     2,     0,     5,     3,     0,     2,     2,     2,
       3,     1,     3,     1,     2,     1,     0,     8,     1,     3,
       1,     1,     3,     5,     2,     1,     3,     7,     1,     1,
       0,     3,     2,     2,     2,     0,     2,     2,     1,     1,
       3,     3,     1,     2,     4,     4,     2,     3,     5,     5,
       1,     1,     9,     1,     2,     4,     4,     4,     2,     3,
       1,     3,     6,     1,     0,     2,     1,     0,     3,     3,
       4,     4,     4,     4,     3,     2,     1,     1,     0,     1,
       1,     0,     1,     5,     1,     0,     1,     0,     3,     1,
       3,     4,     3,     2,     2,     1,     1,     1,     0,     2,
       4,     5,     2,     3,     1,     1,     1,     1,     3,     0,
       1,     1,     1,     1,     1,     3,     0,     2,     0,     1,
       3,     1,     0,     1,     2,     4,     4,     2,     0,     2,
       3,     2,     0,     1,     3,     1,     2,     1,     2,     5,
       6,     5,     1,     2,     1,     4,     3,     4,     5,     4,
       5,     4,     5,     2,     4,     1,     2,     2,     2,     1,
       1,     0,     4,     2,     1,     2,     2,     4,     1,     3,
       1,     2,     3,     1,     2,     0,     2,     4,     0,     1,
       0,     1,     3,     3,     2,     3,     5,     6,     2,     3,
       3,     4,     0,     1,     1,     1,     1,     1,     2,     5,
       1,     1,     1,     1,     2,     3,     3,     0,     1,     1,
       1,     1,     1,     2,     2,     2,     2,     2,     1,     3,
       0,     1,     1,     1,     1,     5,     2,     1,     1,     1,
       1,     5,     2,     2,     2,     1,     3,     3,     2,     1,
       0,     3,     0,     5,     2,     5,     2,     1,     2,     3,
       0,     1,     1,     1,     1,     1,     1,     3,     3,     3,
       3,     3,     3,     3,     0,     1,     4,     1,     3,     3,
       5,     2,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     2,     2,     3,     3,     2,     3,     5,
       4,     6,     3,     5,     4,     6,     4,     6,     5,     7,
       3,     2,     4,     2,     3,     3,     4,     3,     4,     3,
       4,     5,     6,     6,     7,     6,     7,     6,     7,     3,
       4,     4,     6,     2,     3,     4,     1,     3,     2,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       2,     2,     5,     6,     6,     7,     3,     4,     1,     1,
       2,     4,     1,     1,     1,     2,     2,     2,     1,     4,
       5,     6,     8,     6,     7,     7,     5,     1,     1,     4,
       1,     4,     1,     4,     1,     4,     1,     1,     1,     1,
       1,     1,     6,     4,     4,     4,     4,     6,     5,     5,
       5,     4,     6,     4,     4,     4,     4,     5,     7,     7,
       9,     5,     4,     6,     5,     7,     7,     7,     2,     3,
       3,     3,     4,     0,     4,     1,     3,     3,     1,     1,
       1,     2,     2,     0,     2,     4,     4,     6,     2,     0,
       1,     3,     3,     2,     2,     0,     6,     1,     0,     3,
       0,     2,     2,     0,     1,     4,     2,     2,     2,     2,
       2,     4,     3,     5,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     4,
       1,     4,     1,     4,     1,     2,     1,     2,     1,     3,
       1,     3,     1,     3,     1,     3,     3,     3,     2,     1,
       3,     3,     0,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     3,     2,     3,     0,     3,     3,     2,     2,
       1,     0,     2,     2,     3,     2,     1,     1,     3,     5,
       1,     2,     4,     2,     0,     1,     0,     1,     2,     2,
       2,     3,     5,     1,     2,     0,     2,     1,     0,     1,
       1,     1,     3,     3,     1,     3,     3,     2,     1,     1,
       1,     3,     1,     2,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     2,
       5,     2,     3,     6,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     2,     4,     3,
       2,     1,     1,     1,     1,     1,     0,     8,     2,     5,
       3,     2,     2,     3,     7,     1,     1,     1,     0,     2,
       2,     1,     0,     1,     3,     1,     2,     0,     2,     0,
       2,     0,     1,     3,     4,     3,     1,     1,     1,     1,
       2,     0,     2,     4,     0,     2,     2,     2,     1,     1,
       7,     3,     1,     1,     1,     1,     2,     0,     1,     3,
       3,     3,     3,     0,     4,     5,     5,     0,     1,     1,
       1,     2,     2,     1,     2,     0,     7,     0,     5,     0,
       4,     2,     2,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     2,     1,     3,
       2,     2,     3,     0,     5,     1,     0,     5,     2,     2,
       1,     1,     1,     2,     2,     3,     1,     2,     2,     3,
       3,     4,     2,     1,     2,     1,     1,     2,     2,     3,
       1,     1,     1,     1,     0,     1,     3,     5,     0,     2,
       0,     1,     2,     3,     2,     1,     1,     1,     0,     1,
       1,     1,     1,     1,     2,     2,     3,     0,     1,     2,
       1,     4,     3,     4,     3,     2,     1,     3,     1,     1,
       1,     1,     2,     2,     1,     2,     2,     1,     1,     1,
       4,     4,     4,     4,     4,     1,     0,     3,     3,     4,
       1,     3,     3,     4,     1,     3,     3,     1,     1,     1,
       6,     1,     3,     3,     6,     1,     3,     3,     1,     1,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     4,
       1,     1,     4,     4,     3,     0,     7,     1,     0,     0,
       7,     3,     4,     3,     1,     1,     1,     2,     3,     5,
       2,     5,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     1,     0,     1,     2,     1,     2,     1,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       3,     1,     2,     1,     3,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     3,
       2,     3,     1,     3,     3,     3,     3,     3,     3,     1,
       1,     0,     2,     2,     1,     1,     2,     1,     1,     1,
       0,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
    2266,     0,     2,     1,  2696,  2700,  2704,  2705,  2622,  2706,
    2707,  2672,  2673,  2674,  2675,  2676,  2677,  2678,  2679,  2680,
    2681,  2682,  2683,  2685,  2684,  2686,  2687,  2688,  2689,  2690,
    2691,  2692,  2693,  2695,  2694,  2644,  2273,  2641,  2638,  2639,
    2640,  2645,  2643,  2636,  2637,  1869,  2709,  2697,  2710,  2698,
    2699,  2701,  2702,  2671,  2703,  2711,  2712,  2713,  2708,  2716,
    2667,  2668,  2666,  2669,  2670,  2714,  2715,  2658,  2659,  2660,
    2661,  2717,  2274,  2275,  2663,  2267,  2271,  2333,  2404,  2664,
    2665,  2662,  2272,  2657,  2404,     0,  2525,  2526,  2527,     0,
    2528,  2529,  2530,  2456,  2418,  2531,     0,     0,  2532,  2533,
    2534,  2535,  2536,  2537,  2538,  2539,     0,  2540,  2541,  2542,
    2543,  2403,  2544,  2545,  2546,  2547,  2548,  2380,  2386,  2509,
       0,  2360,  2361,  2357,  2359,  2358,  2362,  2345,  1136,   539,
    1218,  1217,     0,  2170,  1136,  2126,  2127,  2171,  2128,  2129,
    2130,   254,     0,     0,  1220,  2131,     0,  1136,  2172,   357,
     932,  2173,  2174,  2288,     0,  2132,  2133,     0,     0,     0,
     539,  1136,     0,     0,  2134,  1354,  2135,     0,  2136,  2175,
    2176,     0,  2137,  2177,  2178,  2138,  2139,  2140,  2179,  2180,
    2181,  2141,  2182,  2183,     0,     0,  1368,     0,  2142,  2184,
    2143,  2144,     0,  2185,  2145,  2146,  2147,  2186,  2187,  2188,
    2148,  2149,  2150,     0,  2151,     0,     0,     0,     0,     0,
    2189,  1136,  2152,     0,     0,  1375,     0,  2153,     0,  2190,
    2154,     0,  2155,     0,  2156,  2157,  2158,  2159,  1368,  2505,
    2381,     0,  1222,     0,  2160,  2191,     0,  2161,  2162,  2163,
    2164,  2165,  2166,  2167,  2168,  2169,     0,     0,    59,    60,
      22,    21,    27,    26,    84,    85,    47,    14,    73,    54,
     118,   117,   119,    35,    30,    67,    19,    20,    32,    36,
      56,    55,    18,    53,    79,    57,    82,    42,     8,     9,
      43,    71,    10,    44,    72,    11,    45,    12,    61,    86,
      25,    58,    83,    38,    69,    65,     7,    50,    51,    52,
      76,    77,    78,   101,    81,   113,    34,   110,    91,    92,
     107,    93,   108,     5,    94,    46,    13,   104,   103,   105,
      68,    39,    70,   102,   106,    16,    17,   109,    80,    99,
      96,   114,   112,   120,    97,    62,     3,     4,    87,    41,
       6,    24,    23,    40,    33,   116,    28,  1220,    29,    49,
      15,    75,    48,    74,    90,    89,    31,   100,    88,    95,
      66,    98,   115,    64,   111,  1341,  1328,  1377,  1340,  1353,
       0,  1343,  2601,  2602,    37,  1354,   122,   123,   128,  2270,
    2322,  2323,  2324,  2404,  2355,  2356,  2349,  2365,  2375,  2364,
    2368,  2376,  2363,  2382,     0,   125,   127,   129,   132,   126,
     121,   124,   131,   136,   130,   135,   133,   134,   137,   138,
     139,  2603,  1554,  2600,    63,  2340,  2339,     0,  2404,     0,
    2549,  2550,  2551,  2552,  2553,  2554,  2604,  2605,  2606,  2607,
    2608,  2610,  2609,  2633,  1875,  1876,  1877,  1878,  1879,  1880,
    1881,  1882,  1883,  1884,  1885,  1886,  1887,  1888,  1889,  1890,
    1891,  1892,  1893,  1894,  1895,  1896,  1897,  1898,  1899,  1900,
    2576,  1901,  1902,  1903,  1904,  1905,  1906,  1907,  1908,  1909,
    1910,  1911,  1912,  2613,  1913,  1914,  1915,  1916,  1917,  1918,
    1919,  1920,  1921,  1922,  1923,  1924,  2614,  1925,  1926,  1927,
    1928,  1929,  1930,  1931,  1932,  1933,  1934,  1935,  1936,  1937,
    1938,  1939,  1940,  1941,  1942,  1943,  1944,  1945,  1946,  1947,
    1948,  1949,  1950,  1951,  1952,  1953,  1954,  1955,  1956,  1957,
    1958,  1959,  1960,  1961,  1962,  1963,  1964,  1965,  1966,  1967,
    2615,  1968,  1969,  1970,  1971,  1972,  1973,  1974,  1975,  1976,
    1977,  1978,  1979,  1980,  1981,  1982,  1983,  1984,  1985,  1986,
    1987,  1988,  1989,  1990,  1991,  1992,  1993,  1994,  1995,  1996,
    1997,  1998,  1999,  2000,  2616,  2001,  2002,  2003,  2617,  2004,
    2005,  2006,  2007,  2008,  2009,  2010,  2011,  2012,  2013,  2014,
    2015,  2016,  2017,  2018,  2019,  2020,  2021,  2022,  2023,  2024,
    2025,  2026,  2027,  2028,  2029,  2030,  2033,  2031,  2032,  2034,
    2035,  2036,  2037,  2038,  2039,  2040,  2041,  2042,  2043,  2044,
    2045,  2046,  2047,  2048,  2049,  2050,  2051,  2052,  2053,  2054,
    2055,  2056,  2057,  2058,  2059,  2060,  2061,  2062,  2063,  2064,
    2065,  2066,  2067,  2618,  2068,  2069,  2070,  2071,  2072,  2073,
    2074,  2075,  2076,  2077,  2078,  2079,  2080,  2081,  2082,  2083,
    2084,  2085,  2086,  2087,  2088,  2089,  2090,  2091,  2092,  2093,
    2094,  2095,  2288,  2096,  2097,  2098,  2099,  2100,  2101,  2102,
    2103,  2104,  2105,  2106,  2107,  2108,  2109,  2110,  2111,  2112,
    2113,  2577,  2114,  2115,  2116,  2117,  2118,  2119,  2120,  2121,
    2122,  2123,  2619,  2124,  2125,  2306,  2611,  2573,  2281,  2302,
    2574,  2523,  2524,  1870,  2575,  2572,  2612,  2308,  2629,  2307,
    2571,  2455,     0,     0,  2417,  2416,  2420,  2419,  2421,  2414,
    2415,  1847,  2309,  2425,  2424,  1318,  2628,  1846,  1319,     0,
    2427,  2555,  2556,  2557,  2558,  2560,  2559,  2561,  2192,  2193,
    2194,  2195,  2196,  2197,  2198,  2199,  2200,  2201,  2202,  2203,
    2586,  2204,  2205,  2206,  2599,  2207,  2208,  2587,  2209,  2210,
    2211,  2212,  2213,  2214,  2215,  2216,  2217,  2218,  2219,  2220,
    2221,  2222,  2223,  2224,  2225,  2226,  2227,  2228,  2229,  2230,
    2231,  2232,  2588,  2589,  2233,  2234,  2235,  2236,  2237,  2238,
    2239,  2240,  2241,  2242,  2243,  2244,  2245,  2246,  2247,  2248,
    2249,  2250,  2251,  2252,  2253,  2254,  2255,  2590,  2256,  2257,
    2591,  2258,  2259,  2260,  2592,  2261,  2262,  2263,  2264,  2265,
    2596,  2597,  2598,  2585,  2378,  2562,  2584,  2595,  2593,  2594,
    2388,  2384,  2392,  2387,     0,     0,     0,     0,  2404,  1135,
    1134,  1120,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   538,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2278,
       0,  1146,     0,   332,   331,  1219,  1200,   539,     0,  1123,
     356,     0,     0,     0,     0,  1229,     0,     0,     0,     0,
     716,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   184,     0,     0,   380,   379,     0,     0,     0,   904,
     385,     0,     0,     0,     0,   527,  2287,  2282,  2292,     0,
    2285,  2286,  2571,     0,  2720,  2031,  2318,  2319,  2718,  2081,
    1320,   255,   258,   256,   257,     0,  1002,  1003,  1005,     0,
       0,  1015,   747,   748,     0,   746,   750,     0,     0,     0,
     743,     0,     0,     0,     0,     0,   749,   741,     0,   740,
       0,     0,     0,   745,     0,   742,     0,     0,  1124,     0,
    2370,  2371,  1934,  1970,  1281,   386,     0,     0,  1354,     0,
    1220,  1239,  1249,  1244,  1246,  1245,  1247,  1243,  1248,  1876,
     846,  1890,   846,  1959,   843,   844,   846,   846,   846,  2046,
       0,     0,   818,     0,   829,  1871,   846,  1872,  2629,   851,
     439,   439,   439,     0,   850,   855,   439,  1117,  1153,  1851,
    1367,     0,  1890,  1959,   819,  1116,  2096,  1273,     0,     0,
    1019,     0,  1020,     0,  2064,  1128,   241,  2569,  2073,  2156,
    2096,  2570,   237,  2564,  2565,  2567,   211,  2568,  2566,  2563,
    1880,     0,     0,   850,     0,  1125,  1126,   807,  1374,  1372,
       0,     0,     0,  1899,     0,  1913,  1995,   234,  2059,  2065,
    2073,  2156,  2096,  2123,   193,     0,   248,  2073,  2156,  2096,
       0,  1146,     0,  1344,  1454,  1842,     0,     0,  2379,  1119,
    1118,  1221,     0,  1224,     0,  1419,  2043,  1348,  1350,  1226,
    1341,     0,     0,  2269,  1215,  1371,  1371,     0,  1371,     0,
    1333,  1341,  1336,  1340,     0,     0,     0,     0,  1136,     0,
    2347,  2375,  2354,  2410,  2351,     0,     0,  2400,  2396,  2393,
    2401,  2402,  2395,  2383,  1543,  1544,  1545,  1542,  1555,  1541,
       0,  2328,  1546,  2367,  2334,     0,  2342,  2341,  2646,  2647,
    2457,  2280,  2299,     0,     0,     0,     0,     0,     0,     0,
    2426,  2428,  2430,  2390,  2389,  2385,     0,     0,     0,     0,
    2515,  2516,  2514,     0,  2511,  2513,     0,  2410,     0,  2580,
    2574,  2583,     0,  1852,  2575,  2572,  2571,     0,   757,     0,
     143,   893,     0,     0,     0,  1846,     0,     0,     0,     0,
       0,     0,     0,   470,  1231,  1747,  1903,  1955,  1757,  1755,
    1756,  1749,  1750,  1751,  1752,  1753,  1754,     0,  1000,  1748,
       0,   143,     0,     0,     0,     0,     0,     0,     0,     0,
    1998,   143,     0,     0,     0,  1140,     0,     0,     0,  1142,
    1145,  1121,     0,  1203,     0,  1842,     0,     0,   791,   782,
       0,   792,   783,   788,   794,     0,     0,   785,     0,     0,
     795,     0,   784,   786,   797,   787,   793,     0,     0,   789,
     790,     0,     0,  1132,   439,     0,     0,     0,  1227,  1228,
       0,     0,     0,   143,  1190,  1969,   143,     0,     0,   384,
     383,   143,   382,   381,     0,   470,  1903,  1955,     0,   931,
     143,     0,   186,   607,   542,     0,     0,   676,  1998,   143,
       0,     0,     0,     0,   907,     0,     0,   526,   539,     0,
    2291,  2297,     0,  2289,  2458,  2721,  2719,  2413,     0,  1006,
     235,   236,  1004,  1969,     0,   310,     0,     0,  1969,  1181,
       0,   744,  1969,     0,  1969,   179,  1844,     0,  1236,  1903,
    1955,  1969,     0,     0,  1969,   171,  1969,     0,  1969,   310,
    1969,   543,     0,  1969,     0,  1969,  1998,   173,     0,  1969,
     310,   755,     0,     0,  2651,  2655,     0,  2653,  2648,  2369,
       0,  2423,  2422,  2321,     0,  2731,     0,  1320,  1241,  2577,
    1255,  1254,     0,  1250,  1258,  1253,  1354,   846,   845,     0,
     846,     0,  2740,   846,     0,   846,     0,  2740,   846,     0,
       0,     0,   846,  1873,  1874,     0,     0,  2739,  2737,  2738,
     820,   830,     0,   852,     0,     0,   859,   858,   857,     0,
       0,     0,   860,  1458,  1296,     0,   827,     0,   825,     0,
    1114,  1131,     0,     0,     0,     0,  1022,  1022,  1022,  1127,
     240,   238,     0,     0,     0,     0,     0,     0,  1133,     0,
       0,     0,     0,  2635,  1858,  1758,  2634,     0,  2127,  2128,
    2129,  1816,     0,  2576,  2130,  2131,  1670,  1657,  1666,  1671,
    1658,  1660,  1667,  2132,  2133,  1940,  2134,  2135,  1865,  2136,
    2137,  1498,  2139,  2140,  2141,  1662,  1664,  2142,  2143,     0,
    1866,  2145,  2146,  2018,  2148,  2149,  2151,  2152,  1668,  2154,
    2155,  2156,  2157,  2158,  2159,  1864,     0,  1669,  2160,  2162,
    2163,  2164,  2165,  2166,  2167,  2168,  2169,     0,     0,  1839,
       0,  1644,     0,  1490,  1491,  1513,  1514,  1492,  1519,  1520,
    1532,  1493,     0,  1838,  1557,  1643,  1648,     0,  1642,  1638,
    1357,  1834,     0,  1639,  1854,  1817,  1868,  1867,  2629,  1825,
    1857,  1855,  1856,     0,     0,     0,   204,     0,     0,  2504,
     250,     0,   251,  1840,  2073,   194,   233,   206,   232,   207,
     205,     0,  1901,   195,     0,   202,     0,     0,     0,     0,
       0,     0,     0,   244,  1122,     0,  1456,  1455,     0,     0,
    1823,  1843,   764,     0,  1213,  1214,  1212,     0,  1209,  1211,
    1223,  1220,  1830,  1829,  1831,     0,  1349,     0,     0,     0,
    1331,  1330,  1226,  1369,  1370,     0,     0,     0,     0,     0,
       0,     0,     0,  1412,  1385,  1386,  1388,  1409,  1413,     0,
    1337,     0,     0,  1460,     0,  1420,  2268,  2410,  2411,     0,
    2405,     0,  2404,  2404,  2398,  2397,  2394,     0,     0,     0,
       0,     0,     0,     0,  2325,   521,  2327,   519,     0,     0,
    2301,     0,  2305,  2303,     0,  2450,  2453,     0,  2451,  2452,
    2454,     0,  2459,  2460,     0,     0,     0,  2642,     0,     0,
    2441,  2429,  2436,  2438,  2440,  2439,  2448,  2444,  2447,  2449,
    2391,  2404,  2522,     0,  2517,  2520,     0,  2512,     0,     0,
       0,  1853,     0,     0,     0,     0,   758,     0,     0,     0,
       0,     0,     0,   142,  1179,   243,  1177,     0,     0,     0,
       0,     0,  1184,     0,   177,   178,   554,   539,     0,     0,
       0,     0,     0,   964,     0,     0,     0,     0,     0,     0,
     965,   963,   966,   973,   986,   989,     0,   883,     0,     0,
       0,  1053,     0,     0,  1053,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   260,   263,   305,     0,
       0,     0,  1235,     0,     0,     0,     0,     0,     0,     0,
     147,     0,     0,     0,     0,   506,   518,     0,     0,     0,
       0,     0,   515,     0,   143,   261,   500,   503,     0,     0,
     616,   615,  1053,     0,   259,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     324,   325,     0,     0,     0,   147,   170,     0,     0,   262,
       0,  2335,     0,  1141,  1138,  1139,     0,  1144,  1022,     0,
       0,     0,  1199,     0,     0,     0,     0,     0,   796,     0,
       0,  1903,  1955,     0,     0,     0,     0,     0,     0,   359,
     338,   339,   143,   337,     0,     0,   673,     0,  1501,  1530,
    1508,  1530,  1530,  1497,  1497,  1510,  1499,  1537,     0,  1530,
    1497,  1502,     0,  1500,  1540,  1540,  1525,     0,  1482,  1483,
    1484,  1485,  1511,  1512,  1486,  1517,  1518,  1487,  1554,  2581,
    1497,  2582,  2579,  2578,     0,     0,   683,     0,  1156,  1189,
       0,     0,   548,     0,  1969,     0,   145,     0,  1232,  1230,
     717,     0,   674,     0,   145,     0,   182,     0,   611,     0,
       0,     0,     0,     0,     0,   635,   634,     0,     0,     0,
     675,     0,   145,   502,  1969,     0,   492,   439,     0,   906,
     909,     0,     0,     0,  2295,  2290,  2293,     0,  2283,  2297,
    1323,  1325,  1324,     0,  1322,     0,   310,   308,   309,   671,
    1014,     0,     0,     0,     0,   310,     0,     0,  1238,  1969,
       0,  1969,     0,     0,   310,   310,     0,     0,     0,     0,
     612,     0,   754,   752,   751,   753,     0,     0,     0,     0,
       0,  1969,   310,     0,     0,   739,  2649,     0,     0,  2652,
       0,  2372,  1234,     0,  1768,     0,  2734,  1278,  2735,     0,
       0,  1354,     0,   222,   223,   221,  1256,   224,  1257,  1252,
    1240,     0,   838,     0,  2740,  2741,   823,     0,   833,     0,
    2740,   821,     0,   834,   831,   832,     0,     0,     0,  2736,
    2620,  2626,   837,     0,     0,   440,   442,     0,     0,  1924,
       0,  1960,  1987,  1988,  2065,  2069,     0,  2091,     0,   861,
     888,   856,     0,     0,  1306,   828,   826,  1115,  1271,  1774,
       0,  1354,     0,  1021,  1018,  1017,  1016,   239,   212,     0,
       0,     0,   890,  2064,  1130,   806,   539,     0,     0,  1646,
    1647,  1529,  1516,  1815,     0,     0,  1524,  1523,     0,     0,
       0,     0,  1506,  1505,  1504,  1645,  1782,     0,  1503,     0,
       0,     0,     0,  1530,  1530,  1528,  1577,     0,  1507,     0,
       0,  1795,     0,  1801,     0,     0,     0,  1536,     0,  1534,
       0,     0,  1613,     0,     0,     0,     0,     0,     0,     0,
       0,  1561,  1562,  1644,  1768,     0,  1861,     0,     0,  1522,
       0,  1554,  1758,     0,     0,     0,     0,  1828,     0,  1766,
       0,     0,  1591,  1764,     0,  1593,     0,     0,     0,  1757,
    1755,  1756,  1749,  1750,  1751,  1752,  1753,  1754,  1762,  1574,
       0,  1837,     0,  1573,     0,     0,  1422,  1356,     0,  1859,
    1818,     0,  2627,  2630,  1640,  2501,  2500,  2499,  2498,  2469,
       0,  2463,  2464,     0,  2502,  2503,   252,   253,   249,     0,
       0,   209,   208,     0,   230,   231,   201,   229,     0,   225,
     226,  1710,  1709,   210,   200,   198,   196,   213,   215,   216,
     199,   197,   247,   245,     0,     0,     0,  1820,  1819,  1849,
    1824,     0,     0,   310,  2404,  1207,     0,  1204,  1833,     0,
    1351,     0,     0,  1216,  1347,  1346,  1378,  1379,   924,  1345,
    1403,  1404,  1399,     0,  1418,  1418,  1395,  1389,  1394,  1392,
       0,  1396,  1557,  1411,  1335,  1383,  1384,  1387,  1334,     0,
    1414,  1412,  1388,  1293,     0,     0,  1461,     0,     0,  2412,
    2410,  2350,  1482,  2404,  2343,  2404,  2399,  2331,  1548,  1549,
    1550,  1551,  1552,  1553,  2332,     0,  2329,  1547,  2330,   520,
       0,     0,     0,  2298,     0,  2279,  2304,  2435,  2544,  2467,
       0,  2468,     0,     0,  2432,     0,  2442,  2445,  2443,  2446,
       0,  1482,  2623,  2518,  2623,  1482,     0,     0,     0,     0,
       0,     0,     0,     0,   759,     0,     0,     0,     0,     0,
       0,  2091,   242,  1175,     0,     0,     0,     0,   892,   891,
       0,     0,   911,     0,     0,     0,  1187,   430,     0,   307,
       0,     0,     0,     0,     0,     0,   552,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   586,  1053,     0,   624,     0,   971,     0,
       0,     0,     0,   972,   969,   970,  2065,   988,   987,   985,
     946,   948,   947,     0,   950,   934,     0,   935,     0,     0,
     945,   953,   951,     0,     0,     0,  1948,   265,   277,     0,
    1052,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   297,     0,   300,   299,     0,     0,     0,     0,   304,
       0,     0,     0,   303,     0,     0,     0,   468,   467,   469,
       0,     0,     0,     0,     0,     0,  1001,     0,     0,   165,
     168,     0,     0,   505,   517,     0,   509,   510,   507,   511,
     512,     0,     0,     0,     0,     0,     0,   504,     0,   609,
     608,   614,     0,     0,     0,     0,     0,  1045,  1044,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   626,   627,     0,   628,     0,   169,     0,
       0,     0,     0,     0,     0,   220,  1137,  1143,  1266,  1266,
    1266,  1202,  1850,  1201,     0,     0,     0,   798,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,     0,   698,  2578,   672,     0,
    1482,     0,  1478,  1474,  1543,  1542,  1541,     0,  1488,  1497,
    1494,   684,     0,   686,   689,     0,  1154,   403,     0,   545,
     586,     0,     0,     0,   175,     0,     0,     0,     0,   141,
     186,   386,     0,   185,   187,   189,   190,   191,   188,   192,
     606,   610,     0,   541,     0,     0,     0,     0,     0,   636,
     640,   639,   643,   641,     0,   637,     0,  1470,     0,   164,
     499,   501,     0,  2276,     0,   388,   470,     0,     0,     0,
     908,     0,     0,     0,     0,     0,  2296,     0,     0,     0,
       0,  1321,     0,   992,     0,  1182,  1969,   310,     0,   990,
     180,  1845,     0,     0,     0,     0,     0,   994,   736,   172,
       0,   310,   310,   544,     0,   310,   174,     0,     0,     0,
     536,   310,   756,  2650,  2656,  2654,     0,  1259,  1260,  1280,
       0,  2732,  2733,   492,  1325,  1242,  1251,   835,   842,   824,
     841,   840,   822,   839,   836,  2434,     0,     0,  2625,     0,
     853,     0,   438,     0,     0,     0,   867,     0,     0,   866,
     881,   868,     0,   870,   863,   862,   871,     0,     0,   890,
       0,  1303,     0,  1301,     0,  1459,  1305,  1294,  1272,     0,
    1270,  1275,  1277,  1276,  1274,     0,     0,     0,   850,     0,
       0,   310,  1129,     0,   808,   813,     0,     0,     0,   810,
     811,   812,   814,   815,     0,     0,     0,  1778,     0,  1779,
       0,     0,     0,  1814,  1810,     0,     0,     0,     0,     0,
    1786,  1787,  1788,  1785,  1789,  1784,     0,     0,  1790,  1783,
       0,     0,     0,     0,     0,  1527,  1526,     0,     0,     0,
       0,     0,     0,     0,  1616,  1648,     0,     0,  1742,     0,
    1768,  1800,     0,     0,  1538,     0,     0,     0,     0,     0,
       0,     0,  1768,  1806,     0,     0,     0,     0,  1708,     0,
    1705,     0,     0,     0,     0,  1825,     0,     0,     0,     0,
    1862,  1558,  1575,  1836,     0,  1827,     0,     0,  1559,  1582,
       0,  1807,  1609,     0,  1614,  1597,     0,  1590,     0,  1595,
    1599,  1578,  1828,  1767,     0,  1765,     0,     0,  1576,     0,
    1571,  1569,  1570,  1563,  1564,  1565,  1566,  1567,  1568,  1572,
    1746,  1744,  1745,     0,     0,     0,  1594,  1962,  1995,     0,
    1368,  1368,  1368,  1355,  1366,  1835,     0,  1465,     0,     0,
       0,     0,  1725,     0,  1772,     0,  1770,  1852,  2632,  2631,
    1826,     0,     0,     0,  1841,     0,     0,  1554,     0,   246,
    1457,  1821,     0,   762,   763,   761,  1482,  1226,  1210,  1206,
    1205,  1832,  1225,  1354,     0,   922,   923,     0,   927,     0,
       0,  1397,  1410,     0,  1306,  1306,     0,  1401,  1402,  1393,
    1339,  1338,     0,  1468,     0,     0,  1290,  1283,  1462,     0,
    1422,  1308,  1310,  1311,     0,  1825,  2348,  2406,  2353,  2374,
    2344,  2377,  1556,  2326,  2366,     0,  2300,  2470,  2471,     0,
    2461,  2462,  2431,  2437,  2508,     0,  2624,     0,     0,   696,
     695,     0,     0,     0,  1075,  1024,  1057,   760,  1076,  1025,
    1058,  1077,  1026,  1176,     0,  1178,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     661,   310,  1185,  1078,   306,  1186,  1059,  1060,     0,   553,
       0,     0,   558,   559,   560,     0,     0,   561,  1903,  1955,
       0,   566,   572,   576,   567,     0,   577,   573,     0,     0,
       0,     0,     0,   583,   585,     0,     0,     0,     0,     0,
     967,   968,  1079,  1027,     0,  1061,   949,  1497,   933,     0,
       0,   944,     0,   943,  1497,  1497,  1028,   176,   266,   403,
    1055,   283,   296,   291,   292,   290,  1969,   310,  1969,   310,
       0,     0,     0,     0,   293,   288,   289,   285,   298,  1879,
    1941,  2074,     0,   596,   598,     0,   603,   301,  1036,     0,
     318,   321,   302,   281,   284,   282,   278,   264,     0,     0,
    1848,     0,     0,   996,     0,     0,     0,   167,  1041,     0,
       0,   152,     0,   156,     0,     0,     0,   146,   157,  1085,
    1032,   508,   513,  1034,   516,  1070,   514,  1091,  1033,     0,
    1065,  1087,  1043,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1191,     0,     0,     0,     0,     0,   310,     0,
     705,  1055,  1969,   310,  1086,     0,  1050,  1073,     0,   326,
       0,  1042,  1035,  1071,     0,     0,   218,   217,   219,     0,
    1269,  1269,  1269,     0,     0,     0,     0,     0,     0,     0,
       0,   800,   771,   799,     0,     0,     0,     0,     0,     0,
       0,   765,   358,   335,   336,     0,     0,   334,   340,   697,
       0,     0,     0,  1479,  1475,     0,     0,     0,     0,     0,
       0,  1495,   685,     0,     0,     0,     0,  1174,  1174,  1174,
    1174,  1174,  1174,  1174,  1155,  1183,   143,     0,     0,     0,
     547,   585,   592,     0,   620,   623,     0,   621,     0,     0,
       0,     0,     0,   158,   144,  1237,     0,   725,   439,   181,
       0,     0,     0,   540,   682,   680,   679,   681,     0,     0,
       0,   702,     0,  1469,  1471,     0,     0,     0,     0,   390,
       0,     0,   387,   391,   395,   396,   397,     0,   493,   495,
     474,     0,     0,     0,   938,     0,   956,   939,     0,     0,
       0,   976,   981,   977,   959,     0,   524,  2294,  2288,  1326,
    1327,     0,   310,     0,     0,   587,   310,     0,   310,     0,
     310,   310,     0,  1112,   613,     0,   668,     0,     0,   310,
     738,  1233,  1769,     0,     0,  2433,  2621,   854,   441,     0,
       0,     0,     0,   865,     0,   522,   869,     0,   880,   875,
     877,     0,   884,  1304,  1297,  1299,  1298,     0,     0,  1295,
    1775,   737,     0,     0,   310,     0,   885,     0,   809,     0,
       0,     0,     0,  1373,  1776,  1777,     0,     0,     0,     0,
    1811,     0,     0,  1683,  1659,  1661,  1496,  1673,     0,  1509,
    1684,  1685,  1663,  1665,     0,  1759,     0,     0,  1674,  1618,
    1619,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1631,  1630,  1675,  1741,     0,     0,
    1798,  1799,  1676,  1539,  1540,  1540,     0,     0,  1805,     0,
       0,     0,  1681,  1686,     0,     0,     0,     0,  1692,     0,
    1713,     0,     0,     0,  1641,  1769,  1531,  1532,     0,     0,
       0,     0,     0,     0,     0,     0,  1615,  1598,  1592,     0,
    1596,  1600,     0,     0,     0,     0,  1584,  1610,  1580,     0,
       0,  1586,     0,  1611,  1368,  1368,  1368,  1368,  1365,     0,
       0,     0,     0,  1432,  1421,  1423,  1434,  1425,  1427,  1463,
       0,  1842,     0,  1406,  1377,  1377,     0,  1725,     0,  1649,
       0,  1725,     0,     0,  2483,  2485,  2486,  2487,  2488,  2489,
    2491,  2492,  2494,  2495,  2496,  2484,  2490,  2493,  2497,  2474,
    2475,     0,  2465,  2466,   203,     0,   227,   214,     0,  2508,
    1208,     0,  1380,     0,  1760,   927,   925,   926,  1382,     0,
       0,  1417,  1416,  1415,  1390,  1292,     0,  1290,  1285,     0,
    1286,  1825,     0,  1282,  1315,     0,     0,  1468,     0,  1314,
       0,  2408,  2336,     0,     0,  2507,  2510,  2521,  2519,  2346,
    1074,  1023,  1056,  1174,   895,   896,     0,   894,     0,     0,
       0,   429,   910,     0,     0,     0,   661,     0,     0,   433,
    1188,   555,   556,     0,     0,   574,     0,     0,   563,     0,
       0,     0,     0,   562,   579,   528,   580,   582,     0,   581,
     584,   589,  1037,     0,  1072,   961,     0,  1497,   936,   941,
     942,     0,   400,     0,     0,     0,   267,     0,     0,   280,
       0,   275,   294,   286,   295,   287,   600,   601,   599,   595,
       0,   602,   604,   315,     0,     0,     0,  1081,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1082,
    1062,     0,     0,   149,   148,     0,   155,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   327,   312,     0,     0,     0,     0,     0,
     329,     0,     0,  1080,  1029,  1924,  1265,     0,  1263,  1261,
    1262,   766,     0,     0,   767,   775,     0,     0,   768,     0,
       0,     0,     0,     0,     0,   777,   361,     0,   364,   371,
     344,   348,  1190,     0,  1190,     0,   349,  1190,   345,  1190,
     342,   699,     0,  2018,  1749,  1750,   693,   700,   690,   692,
     691,   694,   661,     0,     0,     0,  1480,     0,  2722,  2730,
    2729,     0,  1554,   687,   688,     0,  1174,  1173,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   415,
       0,     0,   409,     0,     0,   981,   402,   405,   406,   548,
     551,   549,   550,     0,   578,     0,   619,     0,   592,   160,
       0,     0,   161,   159,     0,     0,   386,     0,     0,   642,
     645,   638,     0,   701,   703,   677,     0,   592,     0,  1281,
     498,     0,   470,   422,   466,     0,   491,     0,     0,   476,
    1152,     0,   911,   937,     0,     0,     0,   974,   978,   975,
       0,     0,   952,     0,   960,   930,  1107,  1108,  1105,  1106,
       0,     0,  2311,  1317,  2320,   993,     0,   310,   991,     0,
     732,     0,   734,   995,   310,   310,   629,     0,   537,   495,
       0,     0,     0,     0,   864,   882,     0,   878,     0,     0,
     847,   887,  1302,  1300,   890,     0,   848,   889,     0,     0,
       0,     0,     0,  1780,  1515,     0,  1813,  1809,     0,  1781,
       0,  1793,  1792,  1617,  1794,     0,  1636,     0,     0,  1628,
    1626,  1627,  1620,  1621,  1622,  1623,  1624,  1625,  1629,  1803,
    1802,  1796,  1797,  1535,  1533,     0,  1678,  1679,  1680,  1804,
    1687,     0,  1894,  1714,  1691,  1707,  1706,     0,     0,     0,
    1694,     0,     0,  1703,     0,  1743,  1521,  1554,  1560,     0,
       0,  1583,  1808,  1601,     0,     0,     0,  1579,     0,     0,
       0,     0,  1588,  1759,     0,     0,     0,     0,     0,     0,
    1359,  1358,  1364,  1341,     0,  1434,     0,  1433,  1445,     0,
       0,  1451,  1449,     0,  1451,     0,  1451,     0,  1426,     0,
    1428,  1445,     0,  1843,  1464,     0,  1408,     0,     0,  1376,
       0,  1725,  1656,  1728,  1723,  1724,  1773,  1650,  1860,     0,
    1771,  1725,     0,     0,     0,  1822,  2506,  1352,     0,  1381,
    1398,  1391,     0,  1466,  1291,     0,     0,  1288,     0,     0,
       0,  1309,  1290,  1312,  2352,     0,  2407,  2472,  2473,     0,
     901,   902,   900,     0,     0,     0,   661,     0,     0,   447,
       0,   918,   918,     0,     0,   435,   489,   981,   664,     0,
       0,   662,     0,   575,     0,     0,   571,   569,   568,   570,
     529,  1090,     0,   962,     0,   954,     0,   272,  1054,     0,
       0,     0,   271,     0,   310,   310,   597,   319,   320,   323,
       0,     0,     0,     0,     0,     0,   726,   709,     0,     0,
     727,   728,     0,     0,     0,   998,   999,   997,   153,   150,
     151,   154,  1038,     0,     0,     0,     0,     0,  1089,  1049,
    1069,  1088,  1047,  1067,  1046,  1066,  1048,  1068,  1040,     0,
    1473,   707,   706,     0,   310,   310,   631,  1264,     0,  1268,
       0,   769,     0,     0,   770,   781,   779,   778,   780,   772,
     362,   143,     0,   341,     0,   369,     0,   367,   366,   368,
       0,   355,     0,     0,     0,     0,     0,   670,     0,     0,
       0,  1476,     0,     0,     0,     0,     0,     0,  1481,  1489,
     660,     0,  1165,  1164,  1163,  1167,  1166,  1169,  1168,  1160,
    1159,  1172,  1171,  1158,  1157,  1162,  1161,     0,   407,     0,
     413,   417,   418,   416,   408,   981,   439,   488,   546,     0,
       0,   622,   617,   163,   162,     0,     0,     0,     0,   647,
     651,   678,     0,  1472,   625,     0,   388,  1279,     0,  2277,
       0,   393,   398,   399,     0,   474,   419,     0,   470,   392,
     494,     0,     0,   483,     0,  1147,     0,     0,   940,   957,
     958,     0,     0,   981,   980,     0,   531,     0,  2284,   310,
     588,   310,   310,  1113,   669,     0,   874,   873,   872,   523,
       0,   876,   310,     0,     0,     0,     0,     0,   817,   801,
     816,  1812,  1672,  1682,  1791,     0,     0,  1637,     0,     0,
    1677,  2161,     0,     0,     0,     0,  1711,  1712,  1693,     0,
    2008,  1698,     0,     0,     0,  1863,  1607,  1605,  1602,     0,
    1603,     0,     0,  1585,  1581,     0,  1587,  1612,  1363,  1362,
    1361,  1360,  1436,  1443,     0,  1424,     0,  1450,  1446,     0,
    1447,     0,     0,  1448,     0,     0,  1443,     0,     0,     0,
       0,  1719,  1725,  1725,  1651,  1730,  1727,     0,  1653,  2476,
       0,  2479,  2477,  2478,  2482,  1554,     0,     0,  1284,  1287,
    1289,     0,  1316,  1307,  2409,  1180,     0,     0,     0,   431,
       0,   981,     0,     0,     0,   921,   921,     0,   981,   488,
     666,   665,   663,   667,     0,   564,   565,  1039,   955,   268,
     269,   270,   273,   312,   279,   274,     0,  1083,  1030,  1063,
       0,     0,   715,     0,     0,     0,     0,  1084,  1031,  1064,
       0,     0,     0,  1196,     0,   311,   312,   328,  1051,  1267,
       0,   773,   774,   343,     0,   365,   374,     0,   372,   346,
     351,     0,   353,   352,   347,   350,  1477,     0,  1012,  1012,
    2723,  2724,  2725,  2726,  2727,  2728,     0,   661,  1170,     0,
       0,   404,   488,   446,     0,   410,     0,   593,     0,     0,
    1152,   388,   592,   646,     0,     0,     0,   704,   390,     0,
     496,     0,   389,     0,     0,   476,     0,     0,     0,   474,
       0,   471,     0,   475,     0,     0,   486,     0,     0,     0,
       0,     0,   979,     0,   983,     0,   951,   928,  1465,     0,
     535,  2310,  2314,  1013,   733,   735,   630,   879,   886,   310,
     802,   803,   804,   805,  1632,     0,     0,     0,     0,  1688,
       0,  1689,  1716,  1715,  1695,  1699,     0,  1696,  1697,  1604,
    1608,  1606,  1589,  1435,     0,     0,  1437,     0,     0,  1439,
    1441,     0,     0,     0,     0,     0,  1846,  1725,  1405,  1407,
       0,  1342,  1654,  1655,     0,  1377,  1725,  2481,  2480,   228,
    1761,  1467,  1313,   880,     0,   310,   918,   488,   448,  2018,
     449,   917,     0,   919,   924,   924,     0,   488,   661,   557,
     314,   322,     0,     0,   722,   710,     0,     0,   729,     0,
       0,     0,     0,     0,   310,   776,   333,   360,   370,     0,
     354,  1012,     0,  1009,  1008,   659,     0,   412,   411,     0,
     457,     0,   591,     0,   592,   719,  1148,   605,   648,   649,
     644,     0,     0,   470,   466,   497,   394,   403,   483,   428,
     427,   424,   423,   425,   426,   421,   420,     0,   476,   472,
     473,   477,     0,     0,   490,     0,  1149,     0,  1198,     0,
     912,   982,     0,     0,     0,   530,     0,     0,   534,   525,
       0,  2312,   849,  1633,     0,  1634,     0,     0,     0,  1701,
    1700,     0,  1444,  1453,     0,  1440,  1438,  1429,     0,  1431,
    1718,  1720,     0,     0,  1733,  1652,   897,     0,   898,   921,
     452,     0,   920,   927,   927,   439,   661,   432,     0,   276,
       0,   713,     0,   724,   722,     0,     0,  1192,     0,  1193,
    1194,  1197,   330,   373,  1007,  1011,  1010,     0,   443,   444,
     445,     0,   414,   453,   454,     0,   594,   618,     0,     0,
       0,     0,   474,   470,   401,   486,   465,   483,   478,     0,
     481,     0,     0,     0,     0,  1150,  1151,   317,     0,   981,
     984,  1111,   533,   532,  2315,  2317,  2316,     0,  1635,  1704,
    1690,  1717,  1702,  1442,     0,  1430,     0,     0,  1729,     0,
       0,     0,     0,   924,     0,   661,     0,   915,   914,   446,
     434,   313,     0,     0,   720,   723,   711,   724,   731,   730,
       0,     0,     0,     0,     0,   455,     0,   456,   487,   718,
       0,   650,     0,   476,   474,   377,   486,     0,   482,   479,
     485,   484,     0,   476,   913,   929,  1110,  1109,  1354,  2313,
    1452,  1721,  1722,  2126,     0,  2101,     0,  1731,  1734,  1732,
    1726,   310,   927,     0,   436,   450,   457,     0,     0,   712,
    1195,   651,   462,     0,   461,     0,   459,   458,   708,   654,
     483,   476,   375,     0,   316,  1465,  1093,  1354,  1092,  1094,
    1102,  1099,  1101,  1100,  1098,     0,  1738,  1737,  1736,  1740,
    1739,   899,   916,     0,   661,   714,   721,     0,   460,   464,
     463,     0,   652,   655,   658,   656,   657,   486,   483,   480,
     903,     0,  1103,  1097,  1341,  1328,     0,   451,   437,     0,
     632,     0,   378,   486,  1095,  1354,  1735,     0,   653,   376,
    1096,     0,   654,     0,   633
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,   247,   248,  1724,  2604,  2489,  3273,  3274,   249,
     250,  1791,   251,   252,   253,   254,   255,   256,   257,  1737,
     258,   259,  1301,  1936,  2613,   260,  2372,  1075,  2246,  2247,
    2546,  2248,  2236,  1577,  2037,  1725,  1753,   262,   263,  1571,
    2228,   264,   265,   266,  1776,  1777,  1732,  1979,  4140,  4709,
    2473,  4823,  3119,  3120,   267,  1830,  1831,   268,   269,  3225,
    1872,  3227,  3228,  3750,   881,  2573,  4161,  4162,  3737,  3738,
    4168,  4437,  4438,   270,  1933,  3301,  3832,  3302,  4240,  3303,
    4241,  3304,  4242,  3255,  3796,  3797,  3798,  3305,  4246,  4645,
    3306,  2387,  1426,  2064,  2065,  4620,  4058,  4059,  4785,  4732,
    4733,  4734,  4856,  4248,  1782,  3839,  4253,  4495,  4496,  4654,
    4465,  3030,  1955,  2646,  3307,  3308,  4239,   271,   272,  2640,
    1806,  1807,  2495,  3756,  3366,   273,  1318,  3624,  4510,  4668,
    4669,   274,   868,   275,  1940,   276,   277,  2599,  3260,   278,
    2396,  3039,   279,   280,  3063,  3064,  3065,   281,   282,  3804,
    4466,  1778,  3112,  3113,  3114,  3115,  3661,   283,  1938,  1811,
    2622,   284,   285,   286,  2603,  3266,  3267,   287,   288,  2535,
     289,   290,   291,  1948,  2634,  2635,  4230,  4474,  4630,  4476,
    4891,  4892,  4457,  3609,  4071,   292,   293,   294,   295,  1916,
    2592,  2593,  3757,  1710,  1876,  2575,  2576,  3822,  3823,   296,
     297,  4106,  4107,   913,  4739,  4713,  4796,   298,   299,  4110,
    4111,   300,   301,   302,   303,   304,   967,  1370,  1371,  1716,
     305,  2263,   306,  1272,  3212,   307,  1461,  2775,  4289,   308,
    1002,  1398,  1399,   309,   310,  1013,  2758,  1015,  2078,  3368,
    3369,  3890,  2729,  1198,   311,   312,  2739,  2761,   313,  1727,
    2378,  2379,  4053,   314,   914,  1960,  2649,  3025,  4659,  4060,
    4385,  4584,  2948,  3558,   315,   915,  1757,  2436,  2652,  3315,
    3316,  2438,  2913,  3851,  2440,  3317,  3322,  3323,  3324,  3847,
    3855,  4504,  4505,   316,  1755,  2429,   317,   318,   319,  1786,
    1217,   320,   936,   937,   321,  4613,   322,  1337,   323,  1033,
    2094,   324,  2451,  3647,   325,   326,   327,  4868,  4901,  4902,
    4903,  3860,  4828,   328,  4870,  1440,   330,   331,   332,   871,
    1239,  1240,  1241,   333,  4255,   334,   335,  2596,  3254,  3778,
     336,   337,  2373,  3015,   338,   339,   340,  1920,   341,   342,
     343,   344,  1852,   345,  1607,  1608,   346,   347,   876,  1093,
    1611,  1619,   348,  1278,   349,  2022,  1927,  2023,   350,   351,
     352,   353,   354,   981,  1392,  1393,  1394,  2039,   355,  2697,
     356,  3200,  3718,   357,  1444,  2750,   982,  1385,   983,  2966,
    3569,  3570,  3573,   984,  2963,   361,  2084,  2744,  2747,   985,
    2970,  2971,  2972,  2973,  2974,  3575,   986,  1004,  1328,  2660,
     987,  1531,   366,   367,   368,  1102,  1097,  1098,   370,  2206,
    2903,  1021,  1625,  1060,  1109,  4009,  2276,  2277,  2297,  2298,
    1634,  1635,  2287,  2289,  2950,  2290,  2959,  2282,  4006,  4351,
    2293,  2294,  1637,  1638,  2954,   371,  2907,  3504,  3505,  3506,
    3987,  3997,  4338,  4549,  3507,  1434,  1644,  3508,  3513,  3567,
    3292,  3293,  3294,  2441,  2583,  1898,  1532,  1899,  2590,  1533,
    2128,  1901,  1534,  1535,  1536,  1904,  1537,  1538,  1539,  1540,
    2112,  2169,  1541,  1542,  2147,  1141,  1142,  2024,  2813,  1544,
    1545,  3953,  4313,  4302,  2839,  2840,  2243,  3949,  3456,  4561,
    4690,  4691,  4017,  4014,  4355,  4565,  4781,  4837,  4838,  1546,
    2893,  2198,  1219,  1547,  3759,  2200,  2833,  2915,  2916,  2357,
    2110,  2780,  2796,  2797,  2810,  3417,  2817,  2822,  3440,  3441,
    2834,  2862,  1548,  2783,  2784,  3401,  2114,  1549,  1600,  1601,
    2214,  2857,  1614,  1615,  1095,  1550,  1551,  2079,  1084,  4545,
    1346,   717,  3129,  2258,  1244,  1018,  1552,  1553,  1554,  3370,
    1665,   696,   697,  1179,   821,     2,    75,   988,  3298,   375,
     376,   917,   918,   919,  1320,  1321,  1965,  1968,  1670,  2335,
     698,   699,   726,  4268,  4511,  4671,   974,   377,   378,   379,
     380,  1666,  2331,  1143,    76,    84,    77,  1144,   417,   418,
    2313,   381,   838,   382,  1647,  1123,  3581,   383,   384,   385,
     386,   387,   970,   388,  1125,   389,  1126,   390,   391,   392,
     393,  1133,   394,  1649,  1650,  4046,  1651,   395,   396,   719,
     720,  1383,   397,   398,  1160,  1161,  1417,  1418,  1676,  1691,
    1692,  1693,   399,   713,   400,   401,   402,  1682,  1683,   403,
    2221,  2222,  2340,  2223,   404,  2987,  2988,   405,  3539,  3540,
    4362,  3541,   406,  2217,   407,   408,  1087,  3586,   409,   834,
     410,  1174,   700,   701,   702,  1181,   824,  1046,   727,  1183,
    3116,   826,   827,   704,   705,   706,  2059,    78,  2995,  2060,
    1556,   728,  1557,  2212,  1558,  1559,  1560,  1561,  1562,  1699,
     710,  1150,  1374,  1375,  2996,  1377,    82,  1378,   414,  3771,
    2027,  1419,  2045,  2046
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -4438
static const int yypact[] =
{
   -4438,   464, 16377, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, 21817, -4438,
   -4438, -4438, -4438, -4438, 99978,   754, -4438, -4438, -4438, 61758,
   -4438, -4438, -4438,   505, 67148, -4438, 70578,   922, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, 74498, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, 54396,   814, -4438,
     481, -4438, -4438, -4438, -4438, -4438, -4438, -4438,   931,  8157,
   -4438, -4438, 71068, -4438,   181, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438,   697, 71558,   642, -4438,   911,   853, -4438,   126,
   10019, -4438, -4438, 62738, 68128, -4438, -4438, 74988,   138,  2576,
    4867,   931, 21324, 75478, -4438,  1482, -4438, 50924, -4438, -4438,
   -4438, 67638, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, 83318,  2696,   821, 51423, -4438, -4438,
   -4438, -4438, 83318, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, 75968, -4438,  1134,   883, 83808, 84298, 64698,
   -4438,  1183, -4438, 83318,  1130,   318, 53414, -4438, 84788, -4438,
   -4438,  1088, -4438, 76458, -4438, -4438, -4438, -4438,   821, -4438,
   54396, 48445,   166,  1025, -4438, -4438, 85278, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438,  1978,  1156, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438,   642, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438,   635, -4438,   706,   947,  1411,
     645,  1065, -4438, -4438, -4438, 10182, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438,101439,  2063, -4438, -4438, -4438,  1338, -4438,
    1212, -4438, -4438, -4438,  1790, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438,  1375, -4438, -4438, -4438, -4438,  1832,100465, 74498,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, 62248, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,   184,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, 74498, 74498, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, 74498,
    1503, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
     431,  1730, -4438, -4438, 54396,  2384,  2384,  1998,101439, -4438,
   -4438, -4438, 55378, 83318, 83318, 83318,  1724, 83318, 83318,   213,
   55378, 83318, 83318,  1822, 83318, 43941, -4438, 83318, 83318, 83318,
   83318, 76458, 83318,  1779, 83318, 83318, 85768, 83318,  1902, -4438,
    2164,  1267,  1808, -4438, -4438, -4438, 83318,  9746,  2696, -4438,
   -4438, 83318,  1831, 55378, 83318,  2696,  1708, 83318,  1783, 83318,
   -4438, 83318, 86258,   309,  1669, 83318,  1987, 76948, 44444,  1979,
   83318, 83318, 83318, 83318, -4438, -4438,  1864, 83318, 83318, -4438,
   -4438, 86748,  1485,  2125,  2035,   975, -4438, -4438,  2260,  1842,
   -4438, -4438,  2292, 74498, -4438, 72048, -4438, -4438, -4438,  1921,
   -4438, -4438, -4438, -4438, -4438, 65188,  2576, -4438, -4438, 55869,
   83318,  2127, -4438, -4438, 87238, -4438, -4438,   371, 56360, 87728,
   -4438, 77438, 44947,  2279, 88218, 88708, -4438, -4438, 89198, -4438,
   89688,  2014, 90178, -4438, 90668, -4438,  2136, 91158, -4438,  5312,
   -4438,  1944,  2090,  1752,  1920,   845, 74498, 74498,   695, 39486,
     642, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,   145,
    1702, 51922,  1215, 52421, -4438, -4438,  1264,  1428,  1521,   145,
    2396,  2396,   651, 74498, -4438, -4438,  1702, -4438,   644,   787,
    1960,  1960,  1960,  2156,   -14, -4438,  1960, -4438, -4438, -4438,
   -4438, 76458, 51922, 52421, -4438,  1985,  2696,   165,  2367, 83318,
   -4438, 83318, -4438, 83318, 83318, -4438, -4438, -4438,  2394,  2010,
    2249, -4438,  2015, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
    2226,  2234,  2213,    61,  2696,  2131, -4438,  2349, -4438,  2254,
   26911,   489, 74498,  2696, 52920, 77928, 98018,   243, 65188,  2696,
   91648,  2085,  1267,  2288, -4438,   531, -4438,  2513,  2140,  2355,
      95,  1267, 41462, -4438,  2151,  1204, 76458,101926, -4438, -4438,
   -4438, -4438,   857,  2431, 27419, -4438, 83318,  2157, -4438,  2169,
    2205,  2214,  1411, -4438, 83318,   735,   735,  2586,   735,  1715,
    1884, -4438,  2296, -4438,  2483,  2459, 76458,  1025,   931,  2229,
   -4438, -4438, -4438,  2241, -4438,  2232,  2239, -4438,   472,  2495,
   -4438, -4438, -4438, -4438,  2328,  2329,  2336,  2337,  2270,  2346,
     283, -4438, -4438, -4438, -4438,  2582, -4438, -4438, -4438, -4438,
   -4438, -4438,  2688,  2679, 62738, 62738,   667,   694,   147,   257,
   -4438, -4438, -4438,  2531, -4438, -4438,  2532, 83318,  2376, 83318,
   -4438, -4438, -4438, 92138, -4438, -4438,  2384,  2241,  2308, -4438,
     316, -4438,  1204, -4438,   356,   414,   440,  1803,  2307,  1853,
    1691, -4438,   743,  2417,   233,    -4,  2344, 76458,  2638,  2320,
     327,  4030,   283,  1571, -4438, -4438, 83318, 83318, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438,  2335, -4438, -4438,
    2339,   999,  1486,  7799,  1300,  4374,  1862,   690,  2520,  1213,
    2633,  1681,  6261, 83318,  2353, -4438,  2594,  2690,   662, -4438,
     183, -4438,  1032,  2432,  2561,  1013, 55378,  2383, -4438, -4438,
   83318, -4438, -4438, -4438, -4438,   378, 55378, -4438,  2571, 45450,
   -4438, 83318, -4438, -4438, -4438, -4438, -4438,  2504, 83318, -4438,
   -4438,  2625, 83318, -4438,  1960,  1099,  2398,  2773, -4438, -4438,
   58815,   195, 83318,  2438,  2821,  2618,  2438,  2454, 92628, -4438,
   -4438,  2438, -4438, -4438, 83318,  1571, 83318, 83318,  2429,  1276,
    2438,  2841,  2850,  2521,  2623,   785,   290,   125,  2734,  2438,
   83318, 93118, 83318, 83318,  2840, 55378, 83318, -4438,  2641, 78418,
   -4438,  2456,  2260, -4438, -4438, -4438, -4438, -4438,  1420, -4438,
   -4438, -4438, -4438,  2770,  2308,   377,  2792,  2505,  2807, -4438,
    2546, -4438,  2812,  2320,  2818,  2539, -4438, 83318, -4438, 93608,
   94098,  2819,  2335, 83318,  2830,  2539,  2831,  2725,  2843,   377,
    2852, -4438,   948,  2853,  2732,  2858,  1781,  2539, 65678,  2865,
     149, -4438, 19077,  5312, -4438, 22866,  1815, -4438, -4438, -4438,
   83318, -4438, -4438, -4438, 30975,   738,  2655, -4438, -4438,  1025,
   -4438, -4438,  1914, -4438, 50425, -4438,   695,  1702, -4438, 74498,
    1702, 74498,   651,  1702, 74498,  1702, 74498,   651,  1702, 74498,
   74498, 74498,  1702, -4438, -4438,  1775,   893, -4438, -4438, -4438,
   -4438, -4438, 74498,  2593, 83318, 83318, -4438, -4438, -4438, 68618,
   83318, 69108, -4438, -4438,   156, 74498, -4438, 74498, -4438,  2696,
   -4438, -4438,  1752, 58815,  2984, 83318,  2868,  2868,  2868, -4438,
   -4438, -4438,  2838, 83318,  2879,  2909, 68618, 83318, -4438, 94588,
   65188,  2799,  2628, -4438, -4438, -4438, -4438,  1941,  2808,   396,
    2862, 30975,  2662,   176,   176,  2663, -4438, -4438, -4438,   520,
    2666,  2670, -4438,   727,   727,  2790,  2698,  2701, -4438,   798,
    2705, -4438,  2902,   823,  2707,  2708,  2709,  2250,   176, 30975,
   -4438,  2710,   727,  2711,  2713,  2715,  2934,  2719, -4438,  2989,
    2720,   227,   298,  2727,  2728, -4438,  2698, -4438,   553,  2731,
    2737,  2739,  2740,  2741,  2743,  2744,  2747, 30975, 30975, -4438,
   25895, -4438,  2696, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
      91, -4438,   837,  4377, -4438, -4438,  2813, 30975, -4438, -4438,
     267, -4438,   865, -4438, -4438,  1204, -4438, -4438,   393, -4438,
   -4438, -4438, -4438,  1658,  1658,   202, -4438, 71068, 71068, -4438,
   -4438,  1244,  2676, -4438,  1813, -4438, -4438, -4438, -4438, -4438,
   -4438, 63228,  3088, -4438,  2217,   183,  1490,  3034, 49427, 49926,
    2965,  2965,  2918, -4438, -4438, 83318, -4438, -4438, 30975, 47463,
   -4438,  1204,   226,  2964, -4438, -4438, -4438,  1968, -4438, -4438,
   -4438,   642, -4438, 13031, -4438,  1981,  2157, 83318, 83318,  3136,
   -4438, -4438,  2169, -4438, -4438,  1411,  1411, 30975,  1411,  1171,
     886, 27927, 30975,  3035,  2933,  1127,  1546,  3037, -4438,  1715,
    1884, 76458, 83318, 95078,  2867, -4438, -4438,  2241,  2764,  1645,
   -4438, 60778,100952,100952,  3007, -4438, -4438,  1415,  1028,  2880,
    2972,  2396,  1353,  1873, -4438, -4438,  2765, -4438,  3099, 71068,
    2823, 62738, -4438, -4438, 83318, -4438, -4438, 78908, -4438, -4438,
   -4438,  1792,  2768, -4438,  2785, 83318,  3271, -4438,  1873,  1873,
   -4438, -4438,  2772, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438,101439,  2776, 83318, -4438,  2781,  2782, -4438,101926, 47954,
    1856,  1204,  2856,  2859,  2904, 54396,  2783,  2861,  2866,  2906,
    2869,  2870, 98508, -4438, -4438, -4438, -4438,  1657,   906,  1053,
    2872,   178, -4438,  2917, -4438, -4438, -4438,  3507, 83318,  6916,
    2983,   283,  2915, -4438,  2876,  2877,  2996,   283,   913, 98998,
   -4438, -4438, -4438, -4438, -4438,  2753, 24397, -4438,  2881,  2860,
   63718,  3174,  2992,  1112,  1907,   162, 83318,  3065,  2998, 83318,
    2814,  2891,  2897,  2825,  1898,  3183,  2824, -4438, -4438,  3000,
      75,  3012, -4438,  2884,  2885, 57833,    96, 45953,  3169,  2908,
   -4438,   833,  2910,  2911,   283, -4438,  3225,   283,   283,  1787,
    3226,  2914,   338,  1771,  2438,  2824,  1462, -4438,  2916,  1732,
   -4438,  3020,   276,  1890,  2824,  2922,  2924,  2825,  2825, 83318,
   83318, 83318, 83318, 83318,   146,  3242,  3243,  2925,   160,  2970,
    2851, -4438, 72538,  2928, 98018, -4438, -4438,  2929,  2199,  2824,
    1600, -4438,  1637, -4438, -4438, -4438,  1267, -4438,  2868, 83318,
   83318, 83318, -4438, 83318,  2308, 58815,  3039,  2890, -4438,  2320,
     283, 83318, 83318,  2335,   175,   961,  3042, 83318,  3100,  2898,
   -4438, -4438,  2438, -4438, 47954,  2429, -4438,  2863, -4438,  2912,
   -4438,  2912,  2912,  2873,  2873,  2882, -4438, -4438,  2250,  2912,
    2873, -4438, 59797, -4438,  1010,  1540, -4438,  3272,  3285, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,  1477, -4438,
    2012, -4438, -4438, -4438, 83318, 54396, -4438,  3298, -4438, -4438,
   58815,  3182, -4438, 83318,  3080,  2889, -4438,  2921, -4438, -4438,
    3219,  2943, -4438,  2935, -4438, 83318,  1072,  2696,  2937, 83318,
    3109, 83318, 83318, 83318, 83318, -4438, -4438,  3083,   737,    52,
   -4438, 72538, -4438,  1462,  3094,  3303,    31,  1960,  3189, -4438,
   83318,  2905,  3310,  3142, -4438, -4438,  2919,  2396, -4438,  2456,
   -4438,  1915, -4438,  3044, -4438, 55378,   377, -4438, -4438, -4438,
   -4438, 58815, 83318, 95568, 55378,   377, 83318, 83318, -4438,  3222,
    2975,  3227,  2981, 45953,   377,   151, 83318, 83318, 83318, 83318,
   -4438, 83318, -4438, -4438, -4438, -4438, 83318, 83318, 83318, 72538,
    3229,  3231,   377, 83318, 83318, -4438, -4438, 22777,  1843, -4438,
    5312, -4438, -4438,   148, 13031,  2026,  2965, -4438,  1503, 83318,
    1493,   695, 69598, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, 74498, -4438, 74498,   651, -4438, -4438, 74498, -4438, 74498,
     651, -4438, 74498, -4438, -4438, -4438, 74498, 83318,  3434,  2936,
   -4438,   393, -4438, 83318,  2033, -4438, -4438,  2072,   739, 83318,
     366, 55378, 83318,  3125, 83318, 83318, 83318, 83318,  3013,  2676,
     311, -4438,   355, 76458,  3134, -4438, -4438, -4438, -4438, -4438,
    2083,  1978,     8, -4438, -4438, -4438, -4438, -4438, -4438, 69108,
   67638,  3224,    60, 83318, -4438, -4438,  2733, 30975, 26403, -4438,
   -4438, -4438,  2948, 13031,  2987, 30975, -4438, -4438, 30975,  2396,
    2396, 30975, -4438, -4438, -4438, -4438,  1424,  2396, -4438, 30975,
   30975,  2396,  2396,  2912,  2912, -4438,  5984, 30975, -4438, 45953,
   30975, 32499, 23888, 30975,  3026,  2969,  2396, -4438,  2396, -4438,
   30975, 25387, -4438, 30975,  3158, 33515, 30975,  1490,  3161, 30975,
    1490,  3381,  3381,  1885,  6584,  2956, -4438,  3066,  2396, -4438,
    2396,   182,   218, 58815, 30975, 54396,  3040,   224, 83318, 30975,
    2962,  1810, -4438, 30975,  1346, -4438,  2966, 30975,  3046, 30975,
   30975, 30975, 30975, 30975, 30975, 30975, 30975, 30975, -4438, 34503,
     271, -4438,   478,  1235, 70088, 26911,  3244, -4438, 23379, -4438,
     191, 74498, -4438, -4438,  1204, -4438, -4438, -4438, -4438, -4438,
    1792,  2974, -4438,  2980, -4438, -4438, -4438, -4438, -4438, 83318,
    3088, -4438, -4438,  3050, -4438, -4438, -4438, -4438,   880, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438,  2978, -4438, -4438, -4438,
   -4438,  2978, -4438, -4438,  2965,  2982,  5637, -4438, -4438, -4438,
   -4438,  3249,  3250,   377,101439, 83318,   857, 73028, -4438, 27419,
   -4438,  2095,  2986, -4438,  3232, -4438,  2991, -4438, 10681,  3232,
   -4438, -4438,   143,  3168,  3175,  3175, -4438,  2993, 13031, -4438,
    2076, 13031,  2126, -4438, -4438, -4438, -4438, -4438, -4438,  1361,
   -4438,  3035,  1546,  3047,   596, 83318, -4438, 41956,  2039, -4438,
    2241, -4438, -4438, 20642, -4438, 22304, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438,  2999, -4438, -4438, -4438, -4438,
     283,  3002,  3475, -4438, 62738, -4438, -4438, -4438,  3434, -4438,
    2292, -4438,  2292,  3503, -4438, 74498, -4438, -4438, -4438, -4438,
     971, -4438,  5312, -4438,  5312, -4438,  3003,  2112,  3078,  3082,
    3124, 83318, 83318, 83318, -4438, 54396, 83318, 83318, 83318, 83318,
   83318, 83318, -4438,  3368,   790, 67638,  3128, 66168, -4438, -4438,
    3025, 83318,  3084,  3247,  3265,   757, -4438, -4438, 83318, -4438,
    3228, 83318, 30975,  3230, 83318, 83318,  3106, 55378,  3036, 83318,
   83318, 83318,   384, 55378, 46456, 83318, 83318, 83318, 83318,  3149,
   83318, 83318,  3267,  1015,   315,  2210,  2824,  3233, -4438,  1137,
   83318, 83318,  3220, -4438, -4438, -4438, 65188, -4438, -4438, -4438,
    3215, -4438, -4438, 59797, -4438, -4438,  2121, -4438, 59306, 56851,
   -4438, -4438,  1104, 83318, 83318, 83318,  1064, -4438, -4438, 58815,
   -4438, 83318, 83318, 83318, 73518, 96058, 96548,  1260,  1309, 83318,
   74008, -4438, 83318, -4438, -4438, 54887, 83318, 83318, 54396, -4438,
   83318,  3234,   778, -4438, 83318,  4642,  3116, -4438, -4438, -4438,
   83318, 83318,  3041,  2142,  3119,  3164, -4438, 83318, 83318,  2390,
   -4438, 83318, 83318, -4438, -4438,   283, -4438, -4438, -4438, -4438,
   -4438, 83318, 83318,   283, 83318,   283,  1591, -4438, 83318, -4438,
   -4438, -4438, 83318, 83318, 83318, 83318, 83318, -4438, -4438,  1603,
    1459,  1570,  1933,  3185, 83318,  2696, 83318, 97038, 83318, 83318,
   83318, 83318,  1626, -4438, -4438,  3157, -4438, 83318,  2390, 83318,
   83318,  3123,  3126,   208,  3201, -4438, -4438, -4438,  3340,    99,
      99, -4438, -4438, -4438,  3294,  3463, 83318, -4438,  3299,  3300,
    3112,  3115,  3304,  1774, 83318, 83318, 83318, 83318, 83318, 83318,
    3307,  1774,  3248,   599,  3071,  2158, -4438,  3085, -4438, 30975,
    3478, 58815,  3079,  3086,  3151, -4438,  3154,  2396, -4438,  2172,
   -4438, -4438,  2179, -4438,  3089,   737,  2386, -4438, 83318,   722,
     620,  3379, 37990,  3194,  3577, 83318,  3372, 83318, 83318,  3577,
   -4438,  2046, 67638, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438,  3371, -4438,  2696,  2429,  2429,  2429,  2429, -4438,
   -4438, -4438, -4438,  3276,  1990, -4438,  3092, 83318,  3202,  3577,
   -4438,  1462,  3392,  3394, 83318, 64208,  1571,  3502,  2696,  3282,
   -4438, 24892,  4114,  3284, 65188, 78418, -4438,  3111,  3370,  3373,
    3395, -4438,  2308, -4438,  3513, -4438,  3407,   377,  2320, -4438,
    2539, -4438, 83318, 83318, 83318, 83318,  2335, -4438, -4438,  2539,
    3297,   377,   377, -4438,  3302,   377,  2539,  3237,  3397, 65188,
   -4438,   149, -4438, -4438, -4438, -4438, 83318, -4438, -4438, -4438,
   30975, -4438, -4438,  3117,  1915, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, 74498,  2292, -4438,  2211,
   -4438, 83318, -4438,  3375,  3377,  3380,  2539,  3153, 83318,  3120,
   -4438,  2539,   283,  2539,  2676,  2676,  2539, 79398,  3542,  3404,
     597, -4438,   750,    23,  3341, -4438, -4438, -4438, -4438, 58815,
   -4438, -4438, -4438, -4438, -4438, 83318,   105,  3313,  3130, 79398,
    3520,   377, -4438, 55378, -4438, -4438,  3218, 55378,  3324, -4438,
   -4438, -4438, -4438, -4438,  3374, 83318,  2215, -4438,  1872, -4438,
    1903, 30975, 30975,   198, -4438, 11432,  2219,  3137,  3139,  2224,
   -4438, -4438, -4438, -4438, -4438, -4438,  3146,  3428, -4438, -4438,
    3148,  2236,  2273,  3152,  3156, -4438, -4438,  5912,  3162, 12044,
    3163, 32499, 32499,  1772, -4438, -4438, 32499,  3166, -4438,  2278,
   10986,  3155,  3167,  3172, -4438,  3170,  3171, 12433, 28435, 30975,
   28435, 28435, 12331,  3155,  3173,  2282, 54396,  3327, 12642,  2303,
   -4438, 30975, 54396,  6112, 30975, -4438, 30975, 83318,  3176,  3177,
   -4438, -4438,  5984, -4438,  3187, -4438, 32499, 32499, -4438,  4096,
   25895, -4438, -4438,  3439, -4438, -4438,  2020, -4438,  3165, -4438,
   -4438,  5456,   239, 30975,  2962, 30975,  3246, 45953,  1067, 30975,
    6040,  3506,  3506,   380,   380,   168,   168,   168,  2247,  1235,
   -4438, -4438, -4438,  3179,  2719, 30975, -4438,  2401,  2404, 83318,
    8778, 12838, 13337, -4438, -4438, -4438, 36013,  3212, 30975, 30975,
   30975,  3181,  3349,  3602, 13031,   949, -4438,  3603, -4438, -4438,
   -4438,   264,  3503,  1792, -4438,  1267,  2396,   182, 50425, -4438,
   -4438, -4438, 30975, -4438, -4438, -4438, -4438,  2169, -4438, -4438,
   -4438, -4438, -4438,  1978, 30975, -4438, -4438,   572,  2092, 30975,
    2076, -4438, -4438, 83318,  3134,  3134, 30975, -4438, -4438, -4438,
   -4438, -4438, 36013,  3221,  3236, 40968,  3312, -4438, -4438, 83318,
     154, -4438, -4438, -4438,  3198, -4438, -4438, -4438,  1582, -4438,
   -4438, -4438, -4438, -4438, -4438,  3184, -4438,  3188, -4438,  3199,
   -4438, -4438, -4438, -4438,   177,  3186,  3190,  3191,   -55, -4438,
   -4438, 83318, 83318, 83318, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438,  3418, -4438, 83318, 83318,  3382, 83318,
    3376,  3383, 30975,  1128, 83318,  3203,  3204,  1214,  3454, 83318,
   -4438,   377, -4438, -4438, 13031, -4438, -4438, -4438, 65188, -4438,
    2308, 58815, -4438, -4438, -4438,  3238, 83318, -4438, 83318, 83318,
    2335, -4438, -4438, -4438, -4438,  1144, -4438, -4438, 83318, 83318,
     308,  3275, 83318, -4438,   652,  3020, 83318, 83318, 83318,  3447,
   -4438, -4438, -4438, -4438,  3396, -4438, -4438,  2012, -4438, 56851,
   59306, -4438, 59306, -4438,  2012,  1793, -4438,  2539, -4438, -4438,
     621, -4438, -4438, -4438, -4438, -4438,  3504,   377,  3505,   377,
   83318, 83318, 83318, 83318, -4438, -4438, -4438, -4438, -4438, 54396,
   54396, 54396,  2330, -4438, -4438,  2696, -4438, -4438, -4438,  2333,
   -4438,  1366, -4438, -4438, -4438, -4438, -4438, -4438, 83318,  1963,
   -4438,   839, 58815, -4438, 58324, 83318, 83318, -4438, -4438,  3432,
    3378, -4438,  2176, -4438,  3384, 83318,  3261, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,  3288,
   -4438, -4438, -4438,  3425,  3426,  3430,  3290,  3291,  3338,  3295,
    3296,  3342, -4438,  3301,  3343,  3306,  3344,  3308,   377, 58815,
    1967,  3336,  3530,   377, -4438,  3314, -4438, -4438,  3635, -4438,
   83318, -4438, -4438, -4438, 83318, 83318, -4438, -4438, -4438, 97528,
    3315,  3315,  3315,  1774, 58815,  3477,  1774,  1774, 83318, 83318,
    1774, -4438, -4438, -4438,  3482,  3483,  3486,  3488,  3491,  3492,
    1774, -4438, -4438, -4438, -4438,  1099, 54396, -4438,  2362, -4438,
    1921, 43438,  6917,  3258,  3086,  3239,  2396, 38992,  1358,  3464,
    3257, -4438, -4438, 54396, 43438,  2019,  3481,  3273,  3273,  3273,
    3273,  3273,  3273,  3273, -4438,  2887,  2438, 65188, 83318, 65188,
   -4438,   620,  3440, 83318, -4438, -4438,  2351, -4438, 83318, 83318,
     220, 83318,  2396, -4438, -4438,  3260,  3325, -4438,  1960,  1072,
    3399,  1539,  3601, -4438, -4438, -4438, -4438, -4438, 83318, 83318,
     737,  2696,  3269,  3263, -4438, 83318, 83318, 74498,  1978,  3277,
   83318,  3274,  3270, -4438, -4438, -4438, -4438,  2352, -4438, 58815,
    3460,  1978,  3352, 83318, -4438,  2357,    80, -4438,  2696, 65188,
   57342, -4438,  4809, -4438, -4438,   868,  3551, -4438, 83318, -4438,
   -4438, 40474,   377, 58815, 83318, -4438,   377,  3333,   377,  3334,
     377,   377, 83318, -4438, -4438, 83318, -4438, 83318, 72538,   377,
   -4438, -4438, 13031, 83318,  3569, -4438, -4438, -4438, -4438,  3405,
    3406,  3408, 83318,  2539, 55378, -4438,  3287, 83318,  1133, -4438,
   -4438,  3466, -4438, -4438, -4438, -4438, -4438,  3591,  3592, -4438,
   -4438, -4438, 83318, 68618,   155, 83318, -4438,  2308, -4438,  2320,
     283, 83318,  3534, -4438, -4438, -4438,  3309,  2387, 11516, 30975,
   -4438,  3605, 58815, -4438, -4438, -4438, -4438, -4438, 30975, -4438,
   -4438, -4438, -4438, -4438, 30975, -4438, 30975,  3578, -4438,  3723,
    3723, 58815, 32499,  1472,  2711, 32499, 32499, 32499, 32499, 32499,
   32499, 32499, 32499, 32499, 35011,   718, -4438, -4438, 30975, 30975,
    3589,  3578, -4438, -4438,  1286,  1286, 58815,  3305,  3155,  3311,
    3316, 30975, -4438, -4438,  2412, 34009,  3318, 54396, -4438, 30975,
   10952,  2442,  3350, 12907,  1204,  7214, -4438,  3686,  2696, 30975,
    2057,  2160, 30975,  2461, 30975,  3594, -4438, -4438, -4438,  3320,
   -4438, -4438, 58815, 30975, 32499, 32499,  6485, -4438,  6950, 30975,
    3321,  7068, 25895, -4438,   821,   821,   821,   821, -4438, 83318,
   83318, 83318, 35519, 79888,  3326,  1946, -4438, 79888, 80378, -4438,
    3328,  1204, 30975,  3583,   852,   852,  3323,  3349, 42450, -4438,
   30975,  1530, 28943,  3332, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,  3331,
   -4438,  3329, -4438, -4438,   183,  3335, -4438, -4438,  7571,   177,
   -4438,  3337, -4438,  3345, -4438,  2092, -4438, -4438, -4438,  7791,
    3496,  2676, -4438, -4438, -4438,  3326, 29451,  3312, -4438,  2472,
   -4438, -4438, 26911, -4438, -4438,  2488, 41956,  3221, 27419,  1204,
    2396,  3348, -4438,  2292,   264, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438,  3273,  2539,  2539,  1063,  2539,  3606,  1063,
    8168, -4438, -4438, 36507, 83318, 83318, -4438, 83318,  2492,  1611,
   -4438, -4438, -4438,  3741, 83318, -4438,  3398,  3400, -4438, 83318,
   83318, 83318, 83318, -4438, -4438,  2307, -4438, -4438, 83318, -4438,
   -4438, -4438, -4438,  3415, -4438, -4438,  3595,  1812, -4438, -4438,
   -4438,  3414,  2887,   237,  2825,   196, -4438,  3416, 83318, -4438,
   83318, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   54887, -4438, -4438, -4438, 54396, 43438, 54396, -4438,  3417,  3427,
    3474,   915,   970,  3433,  3435,  3476,  3360,  3362,  3364, -4438,
   -4438,   145,  2696, -4438, -4438,  2696,  2539,  2696, 83318,  3651,
     639,  1849, 83318, 83318, 83318, 83318, 83318, 83318, 83318, 83318,
   83318, 83318, 83318, -4438,  3734,  2696,  2696,  3704,  3436, 83318,
   -4438, 83318,  3020, -4438, -4438, 83318, -4438, 80868, -4438, -4438,
   -4438, -4438,  3369,  1774, -4438, -4438,  3607,  3611, -4438,  1774,
    1774,  1774,  1774,  1774,  1774, -4438,   253,  2518, -4438, 38485,
   -4438, -4438,  2821,  2696,  2821,   137, -4438,  2821, -4438,  2821,
   -4438, -4438,  3085,  3345,  2396,  1873, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438,  2396,  2138,  3385, -4438, 39980, -4438, -4438,
   -4438,  1935,   182, -4438, -4438, 83318,  3273, -4438,  2846,  1997,
    2678,  2726, 81358, 81848, 82338,  3389, 83318, 83318, 32499, -4438,
    1372,   203, -4438,  3610, 83318,  3413, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438,  3393, -4438,  2889, -4438, 83318,  3440,  2539,
   83318, 83318,  2539, -4438, 58815,  3784,   845, 93118,  3412,  3391,
    3667, -4438,  3401,  3403, -4438, -4438, 83318,  3440,   653,  1920,
    3429, 66658,  1571, -4438,  3636, 64208, -4438, 83318,  3754,  3485,
    3441,  2696,  3084, -4438, 56851, 30975, 30975, -4438,  3409, -4438,
    3410,  5023, -4438,  2429, -4438, -4438, -4438, -4438, -4438, -4438,
    3473, 83318,  3836, -4438, -4438, -4438,  3422,   377, -4438, 83318,
   -4438, 83318, -4438, -4438,   377,   377, -4438,  3519, -4438, -4438,
    1978, 83318, 83318, 83318,  2539, -4438,   283, -4438,  3689, 79398,
   -4438, -4438, -4438, -4438,    60,  3695, -4438, -4438,  3655,  3656,
    3657,  3666,  2382, -4438, -4438, 30975, 13031, -4438,  3431, 13031,
    8320, 13031,  3589, -4438,  2139,  3709, -4438,  1155,  3442,  2139,
    2445,  2445,   228,   228,   133,   133,   133,  3723,   718, 13031,
   13031, -4438, -4438, -4438, -4438,  3446, -4438, -4438, -4438,  3155,
   -4438, 31483,  3573,  3819, -4438, -4438, -4438,  3470,  3471,  3448,
   -4438, 30975, 31991,  3438, 59797, -4438, -4438,   182,  1577, 32499,
   32499,  2202, -4438,  1044, 30975, 58815,  2525,  2202,  2490,  2883,
   30975, 30975,  7289,   330, 30975,  8389, 83318, 83318, 83318, 83318,
   -4438, -4438, -4438, 37495,  1946,  3451, 83318, -4438,  3455, 36013,
    3671,  3622, -4438, 36013,  3622,  1770,  3622,  3694, -4438, 42944,
   -4438,  3461, 23379,  1697, 13031,  3840,  3732, 30975,  3465, -4438,
    3467,  3349, -4438, 99488, -4438, -4438, 13031, -4438, -4438, 30975,
   -4438,  3349,   264,   272,  2696, -4438, -4438, -4438, 45953, -4438,
   -4438, -4438,  3650, 13031, -4438,  1978, 83318,  1204,   278,  3487,
   83318, -4438,  3312, -4438, -4438,  5312, -4438, -4438, -4438,   145,
   -4438, -4438, -4438,  3538, 67638,  3753, -4438, 30975,  2528, -4438,
    3510,  3844,   200,  2537,  2560,  1611, -4438,  3413, -4438,  1455,
     281, -4438, 58815, -4438, 83318, 83318, -4438, -4438, -4438, -4438,
    2783, -4438, 83318, -4438,  3544, -4438,  3669, -4438, -4438,  3672,
     145, 83318, -4438, 58815,   377,   377, -4438, -4438, -4438,  3495,
   83318, 83318, 83318,  2396,  2396, 58815,  3480, -4438,  2396,  2396,
    3484, -4438, 83318, 83318, 83318, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, 83318, 83318, 83318, 83318,  3780, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, 83318,
   -4438, -4438, -4438, 58815,   377,   377, -4438, -4438, 83318, -4438,
    3724, -4438,  1774,  1774, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438,  2438,  3807, -4438, 54396, -4438, 61268, -4438, -4438, -4438,
    2696, -4438,  2696,  3680, 48936,  2696,  2696,  1611,  3497,  1379,
    3768, -4438,  2009, 39980, 39980, 39980, 39980, 39980, -4438, -4438,
    3771,   145, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, 30975, -4438,   932,
    2139, -4438, -4438, -4438, -4438,  3413,  1960,  3556,   722, 54396,
    3614, -4438, -4438,  2539,  2539,  3559,  1978,   673, 83318,  3817,
    3547, -4438,  2696, -4438, -4438, 83318, 64208, -4438,   668, -4438,
    2574, -4438, -4438, -4438,  3545,  3460,  1563,  3515,  1571, -4438,
   -4438,  1561, 83318,  3825,  1107, -4438,  3793,  3517, -4438, 13031,
   13031,  2696, 60288,  4809, -4438, 83318,  3769, 83318, -4438,   377,
   -4438,   377,   377, -4438, -4438, 83318,  2539,  2539,  2539, -4438,
    3698, -4438,   377, 79398,  2382,  2382,  2382,  2382, -4438, -4438,
   -4438, 13031, -4438, -4438, -4438, 32499,  3801, -4438,  3522, 58815,
   -4438,  3523,  2575,  2580, 33515,  3668, -4438, -4438, -4438,  8684,
    3572, 13031,  3624,  3528,  3529, -4438,  1057,  1057,  1044,  2584,
   -4438, 32499, 32499,  2202,  2202, 30975,  2202, -4438, -4438, -4438,
   -4438, -4438, 79888,  3532, 83318,  1946, 36013, -4438, -4438,  1674,
   -4438, 36013,  3770, -4438, 36013, 83318,  3533, 83318,  1175, 30975,
   30975,  3574,  3349,  3349, -4438,  3700, -4438,  3536, -4438, -4438,
    1873, -4438, -4438, -4438, -4438,   182,  3537, 74498, -4438, -4438,
   -4438,  1025, -4438, -4438, -4438, -4438, 79398,  3726, 79398,  1611,
    9192,  3413, 36507, 46959, 83318, 82828, 82828,  3682,  3413,  3556,
   -4438, -4438, -4438, -4438,  3546, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438,  3734, -4438, -4438, 43438, -4438, -4438, -4438,
   37001, 45953, -4438,   915,  3552,  3553,   970, -4438, -4438, -4438,
    1434,   728,  3579,  2539,  3839, -4438,  3734, -4438, -4438, -4438,
    1774, -4438, -4438,  3071,  2696, -4438, -4438,  2587, -4438, -4438,
   -4438, 83318, -4438,  3391, -4438, -4438, -4438, 55378,  3955,  3955,
   -4438,  1121,  1121, -4438, -4438, -4438, 83318, -4438, -4438,  9299,
    3746, -4438,  3556,  3772,  3812, -4438,  2588, -4438, 83318, 83318,
    3441, 64208,  3440, -4438,  1467,  3557,  3857, -4438,  3277,  3560,
   -4438,  3898, -4438, 66658,  3742,  3485,   910,   910, 83318,  3460,
    3683, -4438,  3685, -4438,  3953,  3570,  3642,  3945,  3752,  3948,
   83318, 36507, -4438, 59306, -4438,  2600, -4438, -4438,  3212, 83318,
     756, -4438,  3588, -4438, -4438, -4438, -4438, -4438, -4438,   155,
   -4438, -4438, -4438, -4438,   726, 32499, 58815,  2605, 30975, -4438,
   30975, -4438,  3962, -4438, -4438, -4438,    14, -4438, -4438, -4438,
    1057,  1057,  2202, -4438, 83318,  2608, -4438, 30975,  3580, -4438,
   -4438, 36013,  1674,  2609, 83318,  2612, 58815,  3349,  3155, 13031,
   83318, -4438, -4438, -4438,  3964,  3761,  3349, -4438, -4438, -4438,
   -4438, -4438, -4438,  1133,  1063,   155,  3844,  3556, -4438,  3587,
   -4438, -4438, 83318, -4438,   860,   860, 83318,  3556, -4438, -4438,
    3641, -4438, 58815,  2320,    55, -4438, 58815, 58815, -4438, 83318,
   83318, 83318, 83318, 83318,   377, -4438, -4438, -4438, -4438, 61268,
    3391,  3955,   307, -4438, -4438, -4438,  1714, -4438, -4438,  1234,
    3774,  3674, -4438, 54396,  3440,  3880, -4438, -4438, -4438, -4438,
   -4438, 30975,  3744,  1571,  3636, -4438, -4438, -4438,  3825, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438,  2626,  3485, -4438,
   -4438,  1451, 83318,  1046, -4438,  3775, -4438,  3776, -4438,  2631,
   -4438, -4438,  5023, 60288,  3909, -4438,  3646, 83318, -4438, -4438,
    2540,  4027, -4438,   726,  2635, -4438,  2636,  2643,  3743,  3649,
   -4438,  2648, -4438, 13031, 83318, -4438, -4438, -4438,  2651, -4438,
    3600, -4438,  4008, 30975,    88, -4438, -4438,  3885, -4438, 82828,
    3643, 45953, -4438,  2092,  2092,  1960, -4438,  1611, 30975, -4438,
    2656, -4438,   858,  3751,  3893,  2657,  2673,  3608,  3644,  3608,
   -4438,  2539, -4438, -4438, -4438, -4438, -4438,  3921, -4438, -4438,
   -4438,   270, -4438,  3796,  3797, 83318, -4438, -4438, 83318,  4020,
    9455, 55378,  3460,  1571,  2887,  3642, -4438,  3825, -4438,  3617,
   -4438,  3745,  3620, 83318, 83318, -4438, -4438,  3652, 36507,  4809,
   -4438,   242, -4438, -4438, -4438, -4438, -4438, 83318, -4438, -4438,
   -4438, -4438, -4438, -4438,  2674, -4438, 83318,  3623,  3155, 29959,
   29959,  3621, 79398,   860,  3625, -4438,  3626, -4438, -4438,  3772,
    1611, 13031, 55378,  4010, -4438, -4438, -4438,  3751, -4438, -4438,
   83318,  3747,   622,   622,  3952, -4438,  3684, -4438, -4438, -4438,
     915, -4438,  3632,  3485,  3460, -4438,  3642, 83318, -4438, -4438,
   -4438,  3260,  2825,  3485, -4438, -4438, -4438, -4438,  2025, -4438,
   -4438, -4438, -4438, 33007,  3755,  1036, 11821, -4438, -4438, -4438,
   -4438,   155,  2092, 30975,  1611, -4438,  3774,  2320, 83318, -4438,
   -4438,  3547, -4438,  4051, -4438,   199, -4438, -4438,  3480, 53905,
    3825,  3485, -4438,  3637, -4438,  3212, -4438,  2570, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438,  4043, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438,  9492, -4438, -4438, -4438,  3934, -4438, -4438,
   -4438,  2684, -4438, -4438, -4438, -4438, -4438,  3642,  3825, -4438,
   -4438,  1607, -4438, -4438,  1719,  2214, 30467, -4438,  1611,  3789,
   -4438, 53905, -4438,  3642, -4438,  2570, -4438, 55378, -4438, -4438,
   -4438,  3640, 53905,  2694, -4438
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4438, -4438,  3778, -4438, -1179,   352,  2319,  -712, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,  2955,
   -4438, -4438, -4438,  1547, -4438, -4438,   -68,  1729,  2567,  1231,
   -4438, -1374, -4438, -4438,  -886,   211,  -999, -4438, -4438, -4438,
   -4438, -4438, -4438, -4438, -1012,  1685,  1073,  3180, -2367, -4438,
   -1743, -4438, -4438,   500, -4438, -4438,  1633, -4438, -4438, -4438,
     942,  -265, -4438, -4438, -4438, -4438, -4438, -4438, -4438,     5,
   -4438, -4438,  -438, -1859,  -116,   -62,  -306, -4438, -4438,   340,
    -307, -1713, -4438, -3004, -4438,   -32, -4438, -4438, -4438,  -309,
   -1702,  1159, -1004, -1390,  1458,  -606, -4438,  -196, -4438,  -657,
    -544,  -542,  -611,  -439, -1285, -4048, -4235, -4438, -3545, -2901,
   -2977,  1169, -4438, -4438, -4438,   360, -4438, -1855, -4438, -4438,
    2246, -1652, -4438, -1023, -4438, -4438, -4438, -2952, -4438, -4438,
   -4438, -4438,   -99, -4438, -4438, -4438, -4438,   401, -4438, -4438,
   -4438, -4438, -4438, -4438, -2733,  1604,  1608, -4438, -4438, -3637,
   -4438, -1184, -4438,   543, -3022,  1100, -4438, -4438, -4438,  2274,
   -4438, -4438, -4438, -4438,   406, -4438,   408, -4438, -4438, -1850,
   -4438, -4438, -1834, -4438,  1618,   928, -4438, -4438, -4438,  -632,
    -702,  -690, -4438, -3479, -4438, -4438, -4438, -4438, -4438, -1262,
   -4438,   980, -3113, -1220, -4438, -4438,   995, -4438, -4438, -4438,
   -4438,  -584,  -186,  2298, -4438,  -485,  -567, -4438, -4438, -4438,
    -183, -4438, -4438, -4438, -4438, -4438, -4438, -1986,  8121, -1788,
   -4438, -4438, -4438, -4438, -2458, -4438, -4438, -4438, -1585, -4438,
    4047,   -11,  -275, -1830, -4438,  -191,  -104,  2805, -1386, -2699,
     348,  -333, -4438, -2025, -4438, -4438, -4438, -2603, -4438, -4438,
   -4438, -4438, -3455, -1825, -4438, -4438, -4438,   402, -4438, -4200,
   -3860, -4109, -3421, -3423, -4438, -4438, -1321, -4438, -4438, -4438,
   -1661,  1804, -1727, -4438, -2281,   403, -3687, -1000, -3226, -4438,
   -3623,  -418, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -1331,
    -897, -4438, -4438,  3317, -4438, -4049, -4438, -4438, -4438, -4438,
   -1212, -4438, -1594,  1068, -4438, -4438, -4438, -4438, -4438,  -578,
    -664, -4438, -4438, -4438,   214, -4438, -4438, -4438, -4438,  1939,
   -1178,  -993,  3178, -1820,  -218, -4438, -4438, -4438, -4438, -3009,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -1579, -4438, -4438,
   -4438, -4438, -4438, -4438, -4438,  1988,  1989,  -108,  -224, -4438,
   -4438, -1514, -4438, -4438, -4438,  -757, -1332, -1811, -4438, -4438,
   -4438, -4438, -4438,  -828, -4438,  2223, -4438, -4438, -4438, -4438,
   -4438,    50,  -526, -4438, -4438,  1314,   244,   432,   -69, -4438,
   -4438,   230, -3345,   -67, -4438, -4438, -4438, -4438,  -214,   -64,
   -4438,   686, -4438, -4438, -2824, -4438,   287,    -8,  2886,  1559,
     -65,   305,  -242,  -182,  -170,   -75,  3196,  2650, -4438, -4438,
   -4438,  -205,  1811, -4438, -1106,  -365, -4438,  1324,  -913,  1969,
    2637,  2640, -4438,  1319, -4438, -4438,  1320, -4438, -4438, -4438,
    -909,  1976, -4438,  2649,  1995, -4438,  1317,  1328, -3350,   793,
   -3324,   301,  -778,  -253,  -157,  3214,  2660, -4438, -4249,   731,
   -4438, -3518, -2405,  -659, -2117, -1833, -4438, -4438, -1433, 11159,
   -4438, -4438, -4438, 12176, 16028, -4438, -4438, 16035, 16290, -4438,
   -1288,   838, 16816,  7774, -1458, -1864, -1565, 14457,  1382,   102,
   -2823, -4438, -4438, -4438,  -219,   851,   157, -4438, -4438, -4438,
   -4438,  -472, -2821,  -466, -4438, -4438, -4438,  -468, -4437, -1994,
   -4438,  -814, -4438, 15485,  1367, -4438, -1251, -2742, -2737, -1412,
   -1988, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -1599, -3231,
    -257,  1439, -4438, -4438,  1533, -4438, -4438, -4438, -1558, -1150,
   -2676,  1445, -2128, -4438, -1098,   746,  2116, -1049,  7170,  2834,
   10732,  -136, -2418, -1540, -1780, -4438,  -527, -4438,    98,  2149,
    -139,   -53,   268,    84, -3102, -4438, -4438,   317, -4438, -4438,
   -4438,  3660,   996, -4438,  3004, -4438,  1670,  2358, -4438, -4438,
    1994,  -951,   -29, -4438,  -437, -4438,  -130, -4438, -4438, -4438,
     163, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,
    2682, -4438, -4438, -1460, -4438, -4438, -4438, -4438, -4438,  3947,
    -311, -4438,  3358,  -297, -4438, -4438, -4438, -4438, -4438, -4438,
   -4438, -4438, -4438,  2685,  2027, -4438,  3159, -4438, -4438, -4438,
     -33,  2896, -4438, -4438, -4438, -1204,  -612,  3193,  3195,  1991,
   -4438, -4438, -4438, -4438, -4438, -4438, -4438, -4438,  2002, -4438,
   -4438,  1429, -2140,  2011, -4438, -4438,   770, -4438, -4438,   333,
   -4438,   773, -4438,  2794, -4438, -4438, -4438,   811, -4438, -4438,
   -4438,  -591, 11320,   429,   249,   394,  1029, -4438,  4739,  9381,
     -84,  2716,    59,  7901, 14150,   789, -4438,  3944,  2008,  1649,
   -1033, -4438,  4091,  2311, 13472, -4438, -1031,     3,  1744, -4438,
      -2,  -661, -1187,  2997,  -720, -1967, -4438,  4372, -4438, -3163,
   -4438, -1055,  3386, -1229
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2583
static const yytype_int16 yytable[] =
{
      81,  1298,  1110,   369,  1101,    79,  1639,  1427,  1428,   359,
    1929,   360,  1432,   364,   362,  1988,  1572,   916,  1052,  1645,
    2036,  1994,  1985,  1086,   928,  1593,  2386,  2691,  1006,  2439,
    2469,  2090,  1711,   825,   912,  2067,  1932,  2478,  2549,  2550,
    1810,  1218,  1790,  2260,  2588,  1950,  2730,  2447,  1006,  1329,
    2122,  2123,  1835,  2695,  2149,  1352,  1875,   980,  2448,  2580,
    3384,   966,  1847,  3131,   820,   718,  1083,  1014,  1158,  2138,
    2101,  2551,  1120,  1027,  2517,  2518,   413,  2614,   825,  1585,
    2921,  2615,   413,  3509,  1218,  3642,  1121,  3656,   724,  3658,
     369,  3519,  2320,  2322,  2323,  2437,  3854,  1203,   730,   869,
      74,  2638,  2616,   718,  1918,  1053,  2617,  1922,  2273,   820,
    3629,  2618,  1926,  3221,  1976,   413,  2619,  1664,  1162,  3178,
    2779,  1934,  2589,  1104,   920,   927,  1694,  4065,  1696,  3760,
    1952,  3774,  4029,  2025,   927,   874,  3372,   412,  1218,  3509,
    1295,  2941,  3760,   412,  4055,  3574,   825,  2815,  1074,   930,
    1388,   922,  3984,  2260,  2507,  1043,  1003,  3081,  3083,  2687,
     413,  2815,   373,  1043,  4263,  1043,  3514,  3515,   373,  3464,
    2456,  4222,  4217,  3516,   927,  2364,  1003,   820,  2051,  1779,
    2650,  2026,  1579,  3998,  4000,  2116,  2117,  1112,  2019,  3277,
    4234,  1726,  2314,  2314,  1348,  2978,  1633,  4485,  1754,  1113,
    1636,   373,  4386,  1672,  1673,  1153,  1049,  3585,  2896,  3931,
    2135,  1805,  2219,  1814,  1049,   433,  1049,   433,  2513,   433,
    1839,  3421,  4034,    37,    38,    39,    40,  2167,   413,    45,
      44,    45,  1836,  1949,  2994,  2095,  2096,   931,  2998,  3779,
    3780,  3781,  3782,  3783,  3784,  1175,   373,   416,   880,  1376,
    4638, -1530, -1530, -1530, -1530,  3338,  2173,  3340, -1530,  4664,
    2524,  2636,  1324,  3845,  2457,  1005, -1853, -1853, -1853, -1853,
    1869,  1685,  3524, -1853,  2529,  3525,  3526,  4585,  1977,  2165,
    1977,  2176,  4712,  4177,  1977,  1005,  3527,  3528,  3529,   261,
    3530,  3531,   329,  1457,  1686,  3532,  3533,  3534,  2760,  3579,
     369,  4660, -1540, -1540, -1540, -1540,   359,  2850,   360, -1540,
     364,   362, -1530,  2178,   373,  1178,  3421, -1747,    37,    38,
      39,    40,   358,  1199, -1747,    44,  3199,  4679,  1734,   433,
    2028,  3630,    37,    38,    39,    40,  2855,  3382,    43,    44,
    1463,  1687,  4826,    45,   433,  4384,   372,    37,    38,    39,
      40,  2855,   372,    43,    44,   433,  1276,  2644,    45,  3196,
    2584,  2392,  1863,   870,    43,   363,   822,  1415,  1235,    45,
    2890,  2038,  4088, -1540, -1540, -1540, -1540,  2891,  3047,  2392,
   -1540,   413,  4889,   365,  2261,   372,  2906,  1945,  4213,  1196,
    1149, -2581, -2581, -2581, -2581,   374,  4875,  1442, -2581,  1091,
    4614,  1565,  3399,  -757,  2477,  2210, -2581,  1847,  1946,  2082,
    -143,   822,  1334,  4747,  3377,  2211,   413,  1058,  4725,  -143,
    2389,  1343,  1734,  2450,  -143,  1430,  1576,  1914,  1135, -1763,
     372, -2582, -2582, -2582, -2582,  1735, -1763,  2149, -2582,  2484,
    3535,  4648,   412,  -363,  4389,  1218, -2582,  2755,  2740,  2563,
    2122,  2123,  4779,  4173,   882,  3237,  1163,  2138,  4802,  1236,
    3810,  3589,  2450,  3234,     3,   433,  4392,   373,  2173,  4916,
     365, -1530, -1530, -1530, -1530, -2006,  1044,   412, -1530,   822,
    4780,  3378,  2012,  1136,  1044,  1287,  1044,  2585,   932, -2579,
   -2579, -2579, -2579,  2176,  2393,  2207, -2579,  1654,   372,  1237,
    4174,  1431,   373,  2485, -2579,  2564,  1977,   411,  4680,  4827,
    1715,   823,  4089,   411,  1059, -2578, -2578, -2578, -2578,   835,
    4890,   836, -2578,  1987,  4214,  2178,   916,  1177,  3630,  1735,
   -2578,  1978,  2562,  1978,   711,  2252,  2253,  1978,  2558,  2204,
    2458,  1121,  2727,  2645,  1675,  1678,   411,  1340,  1238,  3626,
    1415,  1100,  4098,  4086,  1857,  2459,   823,  1947,  4824,  4726,
    3045,  2237,  4724,  3760,  2637,  2249,  2249,  1785,  2040,  2741,
     933,  3536,   934,  2394,  2105,  1987,  1431,  4379,  4860,  3846,
    1138,  1147,  1156,  1157,  4049,  1707,   261,  2468,  4865,   329,
    4783,   411,  4462,  2116,  2117, -2174, -2174, -2174, -2174,  2530,
    2580,  2135, -2174,  2168,  4182,  2460,  3602,  2262,  3811,  1453,
   -2174,  2525,  1681,  2578,  2696,  4090,  4900,  3537,  4091,   358,
    1431,  1897,   839,  2503,   823,  2505,  4898,  2511, -1525, -1525,
   -1525, -1525, -1747,   920,  2554, -1525,  2548,  1915,   246,  4335,
    4507,  3433,  1197,  4339,  1154,  2111,  1000,  1001,  1000,  1001,
    2856,   372,  2260,  2018,  3085,  2949,  2920,  1205,  3197,   411,
     922,   840,   363,  2696,  2014,  3484,  1987,  2220,  2547,  3576,
    3889,  2083,  2782,  2719,  1111,  2586,  2197,  1443,  1092,  3509,
     365,  4294, -2006,   927,   927,  2892,   372,  3237, -1530, -1525,
    1155,  1736,   374,  2574,  4813,  2232,  4012,  4373,  1846,  1164,
    1149,  1598,  1758, -1853,  1225,  1599,  2144,  1915,  2468,  1190,
    1598,  3080,  3538,  4160,  1599,  2512,  4699,  1404,  2418,  1854,
    2336,  1409,  1410,  1411,  2423,  2145,  2301,  2416,  4803,  1859,
    2302,  1422,  3088,  3430,  3431,  3432,  3433,  1101,  1288,  2146,
    1655,  2083, -2006,  4393, -1763,  3721,  2742,  1640,  3724,  3725,
    1166,  4852,  3728,  1283,  3066,  2428,  1396, -2006,  4577,  1978,
    1688,  1689,  3735,  1587,  2743,  4587,  4861,  4191,   419,   712,
    2728,  2493,  3627,  1162,  2496,  2497,  4360,  2144,  1271,  2964,
    4061,   820,  2205,  3543,  2089,  4020,  1000,  1663,  1961,  2738,
    3726,  3727,  2490,  2205,  3275,  1326,  2145,   837, -1329,  3639,
    1341,  3640, -1497, -1497, -1497, -1497,  3421,  1858,  1339, -1497,
    2148,  3373,   411,  3046,  3421,  2709,  1723,  2815,  2815,  3549,
    3067,  2712,  2815,  3643,  2702,  3007,  1987,  4553, -2581,  4555,
    2019,  3223,   413,  1114,  1623,  4627,   413,  2559,  1728,   830,
    1186,  -143,  -143,  1819,  4480,  2805,  2806,   411,  1186,   831,
    1397,   872,  1403,  2980,  1408,  2980,  2776,  2778,   975,  1386,
    1412,  3059,  2815,  2815,  1433,  2111,  4124,  2786, -2582,  2894,
    2789,  1391, -1329, -1510, -1510, -1510, -1510,   976,  2801,  2802,
   -1510,  1186,  1820,  1403,  1408,  2194,  2195,  2196,  2197,  3265,
    2486,  2819,  2821,  3059,  1149,  4037,   927,   412, -1537, -1537,
   -1537, -1537,  2835,   369,  3553, -1537,   829,  1685, -1530,  4266,
     977,  1115,    37,    38,    39,    40, -2309,  1105,   373,    44,
    1112,  3124,   373,  1415,  2439,  2630, -2579,  1327,  1563,  1433,
    1686,  1624,  1113,  3060,  3671,  4853,   729,  1186,  1941,  1674,
      37,    38,    39,    40,  1382,  1729,  1186,    44,   927,   832,
    3758,   829, -2578,  2647,  3257,    37,    38,    39,    40,  1643,
     130,   131,    44,  3758,  3375,  3060,  1677,    81,  1387,  2945,
    1588,  2701,    79,  1218,  2723,  4759,  1106,  1942,  4616,  4235,
    1401,  4481,  1406,  1402,  1609,  1407,  4546,  4737,  1564,  2507,
    2895,  4550,  3423,  1844,  4552,  1421,   215,  1048,  1575,  2644,
   -2583,  3644,  1583,  2631,  4854,  1048,  3374,  1048,  4543,  4639,
    1415,  1435,  1437,  1043,  1436,  1438,  4125,  1043, -1329,   829,
    4451,  4452,  4453,  4454,  4455,   223,  2734,  2735,  3645,  4855,
    1589,  1569, -2174,  1149,  1821,   718,  4688,  3854,  3224,  3852,
    1739,  3672,  1107,   433,  2380,  1453,    37,    38,    39,    40,
    2089,  2946,    43,    44,  1463,  1687,  3856,    45,  1186,  4640,
    1029,  2381,   233,  3546,  1049, -1525,  4641,    74,  1049,  4666,
    3785,  1208,  1209,  1210,   236,  1211,  1212,  1213,  1214,  1215,
    1216,   894,   833,   822,  3062,   413,  1730,  1005,  1604,  1005,
    1605,  1005,  1186,  4745,  4642,   215,  2676,  1005,  1413,  1414,
    2424,  2002,   372,  1116, -2309,  4600,   372,  3125,  2965,  4707,
   -1332,  1416,   875, -1329,  2565,  3788,  3062,  3258,  2382,  4697,
    1005,  1005,  2041,  1822,   223,  2043,  2483,  1416,  2047,  1943,
    2049,  1848,  2173,  2052,  3857,  2383,  4825,  2056,   896,  1030,
    2003,  2724,  1465,  1667,  1845,  3421,  1603,  1423, -1329,  4103,
    1731, -1329,  2172,  2566,  1416,  2173,  3241,  2176,  1108,  3376,
   -2309,   233,  1697,  4703,  4704,  4236,  3509,  4643,  -590,  2725,
    3509,   373,  2174,   236,    37,    38,    39,    40,  3016,  1218,
    2176,    44,  3673,  2632, -1332,  4471,  2425,  2177,  1107,  2178,
    4354,   971,  1849,  3259,  4793,  2633,  2555,  4467,  1159,  2929,
    4358,  4685,  4816,  2705,  4108,  1667,  4601,   246,  2388,  1315,
     878, -1497,  2178,   208,  3674,  2089,  4372,  3028,  1944,  1963,
    4667,  3428,  3429,  3430,  3431,  3432,  3433,  4790,   823,  3428,
    3429,  3430,  3431,  3432,  3433,  2611,  2389,  4497,  1005,  2121,
    1834,   877,  2808,  1987,  1186,  4498,  3675,  4104,  4460,  3017,
    1020,  2283,  1788,  3792,  1186,  4794,  3059,  1690,  3172,  1088,
    4348,  2597,  4877,   411,  2384,  4151,  2380,   411,  3858,  3029,
    4020,  4154,  4155,  4156,  4157,  4158,  4159,   904,  1913,   905,
    4787,  4788,  4357,   365,  1100,  1107,  4753, -1497,  1101,  3637,
    3793,  4282,  2004,  4591,   839,  2284,  3085,  3619,  4050,  1424,
    1005,   910,  4109,  3794,  3760,  2567,  4844,  2983,  1824,  2612,
    2127,  1031,  1032,  1186,  1825,  4897,  2179,  1694, -2583,  1696,
    2180,   369,  2664,  2173,  3070,  1218,  3859,  1606,  3060,  2321,
   -1332,  3423,  4644,   840,  1044, -1537,  3620,  4105,  1044,  3885,
    2382,  2181,  2182, -1850,  2285,  3341,  1850,  3336,  2176,  2170,
    1629,  4296,  2439,  4913,  4297,   372,  2183,  2383,  3061,  2385,
    4754,  3310,  4842,  3284,  3285,  3286,  3287,  4007,  1316,  2390,
      81,    81,   839,    81,  1789,    79,    79,  2208,    79,  -166,
    2178,  2005,  1186,  2184,  3758,  3795,  2185,  2267,  4878,  3424,
    2351,  2042,  2926,  2044,  2568,  2280,  2048,  1667,  2050,  2186,
    4499,  2053,  2054,  2055,  1121,  4908,  -166,  1111,  3903,  1057,
    3071,   840,  4588,  1382,  2062,  1826,  1162,  1631,  3638,  4882,
    2614,  4233,  1317,  3550,  2615, -1332,  1138,  2085,  2815,  2086,
    2226,  2815,  2815,  2815,  2815,  2815,  2815,  2815,  2815,  2815,
    2815,  1913,  3332,  2274,  2275,  2616,  2279,   994,  2662,  2617,
    4043,  4271,  1235,  4272,  2618,  1113,  1113,  2668,  1113,  2619,
   -1332,  2815,  3521, -1332,  3522,  4051,  2872,  4728,   995,  1186,
      74,    74,  3151,    74,  1688,  1689,  1028,  1723,  2188,  3062,
    3154,  4298,  3156,  2281,  1643,  4618,  2384, -1956,  3621,  2144,
    2815,  2815,  1005,  4052,  2227,    35,   994,  1186,  3877,    37,
      38,    39,    40,    41,    42,  2453,    44,  3050,  2145,  2181,
    2182,  1107,   894,  3509,  2851,  2259,   411,   995,  3509,  1870,
    1871,  3509,  2146,  1598,  3024,  1186,  1186,  1599,  1186,  1081,
    3397,  4562,  4563,  3854,  2224,  2225, -1989,  1094,   718,   718,
    1054,  2201,  1970,  1236,  1199,  1186,   820,  2192,  2193,  2194,
    2195,  2196,  2197,  1134,  2185,  2454,  1827,  4665,  4211,  4061,
    3428,  3429,  3430,  3431,  3432,  3433,  2189,  2190,  2191,   896,
    2192,  2193,  2194,  2195,  2196,  2197,  -911,  3622,  3448,  4729,
    1117,  2385,  2240,  1237,  4519,   130,   131,  1667,  1828,  1794,
    1218,  1667,  1667,  2317,  1971,  2873,  1186,   413,   820,  2874,
    4700,  4736,  2790, -1497,  2318,    37,    38,    39,    40,  3473,
    4706,  3888,    44,  4447, -1497,  1970,  2121, -1497,  1715, -1497,
    1829,  1135,  4212,   829,   839,  1186,  4185,  4186,  4187,  1186,
    1186,  2259,  1238,  4744,  1770,  2875,  2333,  1795,  2412,  3608,
     718,  4390,  4448,  1808,  2165,   975,  4730,  2241,  3889,   413,
     413,   413,  3241,  3100,  2326,  2584,  4395,  4396,  2327,  2319,
     994,  2318,   820,   840,   976,  2173,  2329,  2704,  3915,  1043,
    2791,  3916,  1103,  2320,  3028, -1956,  1136,  4573,  4061,  4575,
    1137,   995,  1005,   373,  2992,  1972,  1005,  1005,  4557,  2242,
    3522,  2347,  2349,  4748,  4431,  4432,  1043,   977,  3163,   413,
   -2007,   365,  3102,  3101,  3164,  4391,   413,  1913,   904,  3365,
     905,   412,   412,   413,  1598,  4763,  2319,  1796,  1599,  3618,
    1049,  3188,  2178,  1135, -1989,  2792,  3605,  1825,  3509,  2793,
   -2373, -1956,   910,  1973,  2292,   373,   373,   373,  2192,  2193,
    2194,  2195,  2196,  2197,  1667,  4695,    80,  1049,  -386,  4490,
    1667,  2328,  3103,   994,  1913,  4749,  1138,  2876,  1972,  2325,
     412,  1414,  1797,  4491,  1798,  2144,  2498,  2355,  3326,  1629,
    2284,  1809,  2109,  1138,   995,  2506,  4486,  3147,  1136,  2339,
   -1989,  1043,  2585,  1913,  2145,   373,  2346,  2348,  3917,  2057,
    3089,  2125,   373, -2034,  2815,  1127,  4068,  1667,  3918,   373,
    1667,  1667,  3169,  3349,  1800,  3165,  1973,    37,    38,    39,
      40,   215,  2058,  1138,    44,  1128,  1974,  4487,  3912,  2285,
    3612,  2152,  2794,  1381,   433,  1129,  3147,  4066,  1826,  1792,
    4750,  2594,  1049,   709,  3170,  2163,  1631,  4080,  3990,  1005,
     223,  4751,  3932,  1802,  4815,  1005,  2665,   433,   822,    37,
      38,    39,    40,  1913,  1124,  1048,    44,  1465,  4628,  1048,
    3421,  1793,   820,  1667,   433,  3665,  3171,   372,  1139,  3518,
    3040,  4069,  2577,     8,  1632,  1138,  1199,   233,    45,  1804,
    3666,  3631,   215,  4361,  2374,  4629,  1310,  1140, -2007,  1974,
    1913,  2499,  1005,  2500,  2375,  1005,  1005,   921,  3819,  4068,
     822,  4087,  4092,   938,  3561,  2249,  2920,  3991,  4189,  2757,
    2376,   223,  4599,   413,  1311,  4862,  4492,  2795,  1913,   372,
     372,   372,  3235,   246,  1391,  1130,  2745,  4070,  1581,  1019,
    1111,  1111,  3544,  1111,   994,  4061,  3992,  1042,  1629,  3351,
    1310,  4727,  1630,  2541, -2007,  3173,  3166,  1080,   233,  1987,
    2230,  3993,   978,  2936,    43,   995,   369,  1312,  1005,    45,
     236,  3994,  2498,  1159,   822,  2815,  2815,  1121,  3817,   372,
    2586,  1915,  4605,  1186,  4069,  2542,   372,  3174,  3167,  1913,
    3490, -2034,  1186,   372,  3995,  2215,  3933,  3934,  2216,  2587,
    1044,  1131,    35,   823,   979,  2756,  4912,  3895,  1165,   373,
      41,    42,  2543,  3991,  4547,  1631,  2863,  2774,  2009,  2864,
    3168,  1312,  4919,  2544,  1176,    81,   369,  1044,    81,  2144,
      79,  2920,  2751,    79,  2752,  3422,  2754,  2753,   411,  2010,
    4070,  2865,  3992,  2707,  1720,  2708,  4590, -2034,  2145,  2710,
    2545,  2711,  2377,  1632,  2713,  2462,  3423,  4341,  2714,  1780,
    1781,  4625,  2148,  2509,  2450,  3355,  1833,  3994,  1132,  4604,
    3996,   208,  2455,  1218,  3705,  2656,  1721,   841,  3899,  1186,
    3966,   208,    37,    38,    39,    40,  4126,  3799,  4374,    44,
     411,   411,   411,  4841,  1191,  3706,   879,  2499,  1834,  2500,
    3380,  2853,  3237,  4315,  3265,  3211, -1341,  4127,  1722,  3580,
     968,  1289,  1044,  1290,  3424,  1186,  1186, -1376, -1341,   823,
    3990, -1376, -1341,  1186,   122,    74,  1186,  2439,    74,  1186,
    4914,  4314,   820,  4915,  2799,  3758,  2866,  1186,  1186,  4243,
     411,  2867,   126,  3554,  4548,  1186,  2868,   411,  1186,  1186,
    1186,  1186,  1465,  2951,   411,  3421,  1712,  1202,  1186,  1186,
    1055,  1186,  3611,  1186,  1186, -1341,  3996,  1186,  1609,  1723,
    2310,  2311,  3959,  4170,   822,  4172,  2504,  3898,  4175,  1723,
    4176,  1913,  1186,   413, -1376, -1341,  1227,  1186,  1713,  3991,
    4195,  1186,  1233,   372,  3018,  1186,  3021,  1186,  1186,  1186,
    1186,  1186,  1186,  1186,  1186,  1186,  1717,  1186,  1234,  2358,
    3939,   888,  2470,  1186,  3241,  1815,  1186,  1598,  3992, -1853,
    1714,  1599, -1376, -1341,  4063,  4064,  3475,  2787,  2788,  3476,
    1280, -1341,  4661,  3993,  1465,  2800,  1282,  3421,  1718,  2803,
    2804,  2359,  1620,  3994,  3012, -1329,  3387,  1816,   695,  2967,
    3389,  3477,  1817,  2814,  2825,  1465,  2826,  1242,  3421,  2471,
    2472,    37,    38,    39,    40,  2869,  3995,  2837,    44,   373,
    1719,  1305,   413,  2360,  2870,  3960,  2848,  1186,  2849,  1818,
    1275,  3425,  3426,  3427,  3815,  3428,  3429,  3430,  3431,  3432,
    3433,  2259,   894,  2468,  1313,  2514,  2609,  2172,    35,   433,
    2173,  1314,    37,    38,    39,    40,    41,    42,    43,    44,
    3641,  2815,  -905,    45,  2639,  2121,  3668,  2365,  3175,   823,
    2815,   413,   820,   413,  2841,  2176,  1149,  2844,  2339,  4084,
    3289,  2470,  2177,   412,  2121,  3290,  2365,  2815,  2815,  2470,
    2020,  3423,  3996,  1667,  2021,  2173,   365, -1341,  3669,   896,
    3176,  3478,  4866,   192,   411,  1319,  3479,  2178,   373,  3775,
      81,  3137,    81,  1697,  3290,    79,  1299,    79,  2020,  1322,
    2176,  4003,  2694,   413,   433,  4167,  1847,  3900,  2471,  2472,
    3670,  3800,   412,  3802,   412,  1336,  2471,  2472,   215,  3510,
    1005,  3280,  3613,  3394,  3121,  2133,  2134,  2700,   829,  3424,
    1186,  1167,  2178,  2658,  2659,  1186,   365,   373,  1620,   373,
    2234,  1186,  2468,  1168,  1169,  1353,   921,   223,  4008,  4010,
    2468,  1362,   820,  3423,  3395,   820,  1368,  3554,  3396,  1292,
    1380,  1293,  4611,  1170,   822,   215,  1171,  2031,  1005,  2032,
    3554,  1913,  1384,  3849,  3423,  3510,  1913,  1913,  4183,  4184,
    4185,  4186,  4187,   372,   233,  2260,  4188,  1913,  1690,   373,
      74,  2108,    74,   246,   223,  2180,   236,    37,    38,    39,
      40,    35,   969,   413,    44,  3480,   413,  2957,  2958,    41,
      42,  3424,  1425,  3676,  3481,  3678,  2181,  2182,   904,  2920,
     905,  2265,    45,  2266,  3740,  2861,  1429,  3148,  1887,   907,
     246,   233,  3424,  1445,  2268,  3281,  2269,  3683,  1667,   909,
    1439,  4569,   910,   236,   829,  1451,  1667,  1105,  1667,  1450,
    2235,  1048,  4183,  4184,  4185,  4186,  4187, -1400, -1400, -1377,
    3704,  2185,  4450, -1377,  2121,  1452,  1715,  3741,  4146,  1453,
    1465,  2815,   372,  3421,  2186,  4503,  3148,  4867,  1048,  2699,
    3246,  2700,  1172,  1456,  3139,  3722,  2720,  4245,  2721,   373,
    3523,  3742,   373,  4319,  2310,  2976,  3425,  3426,  3427,  1454,
    3428,  3429,  3430,  3431,  3432,  3433,  1106,  1455,  3743,   823,
    1459,  3447,  3744,  3449,  3450,  1465,  1460,  1186,  3421,  1913,
    1584,   372,  1173,   372,  1462,  2722, -1377,  2721,  3556,  3557,
    3745,  4264,  3247,  1005,  2540,  4321,  2748,  3140,  2749,  3201,
    3202,  1005,  3148,  1005,   411,  3068,  3746,  3148,  2942,   365,
    1987,    35,   433,  4717,   822,  4719,  4179,  4180,  1101,    41,
      42,  1586,  1273,  1048, -1377,  3000,    45,  2749,  1590,  1279,
    2470,  1592,  1107,   372,  3078,  1591,  3079,  3148,  3425,  3426,
    3427,  2470,  3428,  3429,  3430,  3431,  3432,  3433,  3141,  1913,
    3089,    37,    38,    39,    40,  3133,  1597,  3134,    44,  3425,
    3426,  3427,  1610,  3428,  3429,  3430,  3431,  3432,  3433,  3248,
    3249,  3229,  1617,  3230,  3866,  3719,  3720,  2471,  2472,  1331,
     938,  1618,  3250,  3747,  2121,  3240,  2365,  1149,  2471,  2472,
    4303,  3748,  3242,   411,  3243,  3499,  3500,  3501,  1186,  4520,
    4521,  4522,  4523,  4288,   829,  2192,  2193,  2194,  2195,  2196,
    2197,  2468,  1627,    80,   822,  1641,  4169,   822,  1620,  3423,
    1000,  1663,  2468,  1101,  3357,  3749,  2721,  1621,  3393,  3251,
    2700,  1642,  3403,   372,  2700,  1667,   372,  3406,  3142,  2700,
    3562,  3563,   411,  3908,   411,  1646,  1648,  1913,  1108,  3410,
    1652,  2700,  3454,    37,    38,    39,    40,  1653,  3461,   823,
      44,  1186,  3913,  1656,  3423,  1186,  1740,  1657,  1658,  3143,
    1441,    37,    38,    39,    40,  1659,  1660,  3424,    44,  1186,
    1186,  4243,  1661,   820,  4443,  1662,  3411,  3935,  2700,   820,
    1668,  3437,  4436,  2700,   411,  3453,  1669,  2700,  1458,  1700,
    1741,    37,    38,    39,    40,  1671,  1701,  1566,    44,  1186,
    1186,  1578,  1331,  1580,  1186,  1703,  3458,  3252,  3459,  3253,
    1709,  1715,  3424,  2089,  1733,  1738,  1186,  1186,  1186,  1186,
    1005,  2763,  1756,  3494,   413,  3495,  3496,  1199,  3497,  1186,
     413,  3144,  1186,  3659,  1186,  3660,  3663,  1785,  3664,  3145,
    1823,  3554,  3146,  1787,  1186,  1186,   935,  1742,  1186,   823,
    1832,  4197,   823,  4279,  3806,  3836,  3807,  3837,   369,  1841,
    3843,  1186,  3844,  1186,  2751,  1843,  2752,  1186,  2754,  2753,
    2764,  1740,  1842, -1501, -1501, -1501, -1501,  4527,   192,  1743,
   -1501,  1853,  1851,  1186,   411,  1855,  1860,   411,   709,   709,
    3904,  1865,  2700,  1698,  1186,  1867,  1186,  1186,  1186,  4199,
    1874,  1877,  1711,  2814,  2814,  1741,  1723,  1626,  2814,  1628,
     373,    37,    38,    39,    40,  3940,   373,  3941,    44,  1919,
    1186,  1667,    45,  2765,  1921,  1923,  4503, -1508, -1508, -1508,
   -1508,  1915,  1186,  4821, -1508, -2583, -2583,  1186,  3428,  3429,
    3430,  3431,  3432,  3433,  1186,  3950,  1935,  3951,  2814,  2814,
    1186,  1951,  2766,  4489,   829,  -183,  1939,  2767,  1465,  1937,
     215,  3421,  1742,  1967,  3962,  3510,  2700, -1499, -1499, -1499,
   -1499,  1744,  4433,  4370, -1499,  4035,  1975,  4036,  4322,  3425,
    3426,  3427,  1959,  3428,  3429,  3430,  3431,  3432,  3433,   223,
    1200,  4039,   856,  4040,  1743,  4067,  1221,  2721,  1980, -1502,
   -1502, -1502, -1502,  1745,  2768,  1231, -1502,  1981,   208,  1873,
    1186,  2339,  1746,  1982,  3545,  3785,  1005,  1983,  1984,  4192,
    1747,  4163,  3786,  4164,  1986,  1993,   233,  1748,  4320,  1913,
    2749,  4381,  3787,  4382,  1291,  1749,  1996,  1997,   236,  1300,
    4387,  4610,  2721,  1750,  1987,  1998,   820,   820,   820,  1999,
    1309,  1751,  2007,  3716, -1500, -1500, -1500, -1500,  2001,  2006,
    3788, -1500,  3789,  4388,  2008,  2721,  3510,  1913,  1913,  4864,
    1913,  2013,   246, -1104,  2029,   822, -1104,  4482,  4529,  4483,
    4530,   822,  2091,  4531,   856,  2700,  2093,  4539,  4558,  2749,
    4608,  4622,  4609,  4623,   372,  2063,  2099,   413,   413,   413,
     372,  1752,  1331,  4662,  4674,  4663,    80,    80,  4675,    80,
    2749,  4682,  4687,  1987,  3826,  4689,  2097,  3826,  2769,  2106,
    1913,  4366,  1913,   208,  2770,  2427,  2100,  1746,  1331,  4746,
    2107,  2229,  3739,  2124,  4757,  1747,  4758,  3790,  4768,  4769,
    2749,  3459,  1748,  2202,   829,  4225,  4770,  3423,  2700,  2594,
    1834,  4773,  2771,  1987,  4775,  2163,  3826,  3829,  1750,  4792,
    4798,  2749,  2749,   820,  2115,  2118,  1751,  1913,  2119,  2861,
    4710,  2772,  2120,  2087,  4715,  4716,  4799,  4830,  2749,  1987,
     820,  2229,   916,   373,   373,   373,  2233,  4910,  3493,  4911,
    2244,  3864,  1913,  3791,  1331,  2773,  2254,  4924,  3792,  4911,
     246,  3503,  4463,  2126,  1218,  3424,  4340,  2129,  4343,  2130,
    2131,  2132,  2137,  2139,   413,  2140,  1752,  2141,  3752,  1913,
     823,  2142,  2143,  3830,  1667,  4436,   823,  1415,  2264,  2150,
    2151,   413,  1913,  2153,  2272,  3793,  3840,  1667,   365,  2154,
    1101,  2155,  2156,  2157,   829,  2158,  2159,   829,  3794,  2160,
    1101,  1632,  1630,  4714,  2299,   411,  3863,  3503,   927,  2309,
    1100,   411,  4711,  4572,  2307,  2316,  2166,  2324,  1138,  4677,
    2330,  2332,  2334,  2342,  2343,  2345,  2171,  2350,  2352,  3976,
    3977,  3978,  3979, -2525,  2354,  2361,  2209,  2365,  2362,  2363,
    2366,  2368,   927,   695,   695,  2367,  2089,  1913,  2369,  2370,
     373,  2391,  2395,  2417,  2419,  2420,  2421,  2422,  1913,  2444,
    2443,  2450,  2452,  2462,  2463,  1331,  2465,   373,  2239,  1005,
    2466,  1913,  1331,  1331,  3765,  3768,  2467,  2468,  2474,  2475,
    3795,  2479,  1005,  2476,  2480,  2481,  2487,  2488,  4742,  2491,
    2492,  2494,  2501,  2502,  1770,  2508,  2526,  2527,   822,   822,
     822,  2515,  1186,  2516,  2528,  2531,  2532,  2537,  2539,  2556,
    3813,  2557,  2569,  3945,  2571,  2579,  2572,   372,   372,   372,
    2581,  2111,  3425,  3426,  3427,  2121,  3428,  3429,  3430,  3431,
    3432,  3433,  2582,  1667,  2127,  2595,  2601,  1186,  2598,  2605,
    1913,  2602,   890,  2607,   820,  2624,  1186,  2608,  1809,  2629,
    2642,  2643,  1186,  4394,  1186,   709,  2648,  2651,  2653,  1913,
    1186,  4820,  2654,  1186,  1186,  1186,  1186,  1186,  1186,  1186,
    1186,  1186,  1186,  2655,  4403,  2673,  1186,  1186,  2672,  4647,
    2661,  2675,  4778,  2674,  1913,  2688,  4412,  2689,  2716,  1186,
    2732,  2717,  2737,  1186,  2746,   413,  2759,  1186,  4814,  4694,
    2781,  2782,  3510,  2823,  2824,  2836,  3510,  1186,  2842,  2173,
    1186,  2846,  1186,  2847,  2860,   822,  2906,  2854,  2877,  2923,
    1913,  1186,  1186,  1186,  4426,  2879,  4580,  1186,  1005,  2922,
    1186,  2925,   822,  2928,   372,  2930,  2933,  2934,  2943,  2952,
    1186,  2953,  1106,   823,   823,   823,  2944,  2962,  2956,  2985,
    1186,   372,  2982,  2219,  4594,  2984,  2999,  3001,  1186,  3003,
    1186,  3002,  3014,  3019,  2814,  3026,  4885,  2814,  2814,  2814,
    2814,  2814,  2814,  2814,  2814,  2814,  2814,  3022,   411,   411,
     411,   373,  4118,  3027,  3024,  3038,  3055,  3058,  3041,  3032,
    3074,  3035,  3076,  2510,  3069,  3128,  3132,  3943,  3135,  3136,
    3177,  3190,  3194,  3123,  1186,  3195,  3198,  3199,  3203,  1218,
    1186,  3204,  3208,  3206,  3207,  3209,  1186,  3222,  3210,  4147,
    3121,  3220,  4099,  3226,  3231,  3233,  2814,  2814,  3244,  3236,
    3238,  2172,  3554,  3239,  2173,  3263,  3237,  1218,  3268,  3276,
    3282,  1186,  3288,   365,  3291,  2397,  3295,   820,  3296,  3297,
    3311,   820,  3313,   820,  3325,  3329,   365,  3328,  3330,  2176,
     823,  3333,  3331,  3334,  3348,   829,  2177,  3342,  3359,  3353,
    3360,   829,  3345,  3361,  3362,  3364,   365,   823,  3371,  2398,
    2089,  3347,  2760,  3383,  3379,  1431,  3385,  3388,    35,  3390,
    3404,  2178,  3405,  2399,  3391,   411,    41,    42,   413,  3407,
    3408,  3409,   413,  1913,   413,  3412,  2400,  3443,  1667,  3413,
    2700,  3474,   411,  3269,  3455,  3415,  3418,  3482,  4044,  3436,
    3442,  2620,  3469,  3444,  3445,  3489,  3452,  3512,  3518,  3467,
    3468,  3492,  3520,  -951,  3517,  3572,  3566,  3578,  3584,  3587,
    3582,  4789,  3568,  3583,  3588,  2020,   822,  2401,  3593,  3598,
    3607,  3635,  3596,  3599,  3628,  3603,  3604,  3636,  3687,  3614,
    3648,  3650,  3681,  3689,  3690,   372,  3682,  3688,  3691,  3692,
    3693,  3139,  3685,  3694,  3695,  3696,  2402,  3697,  3699,  3701,
    3698,  2403,  1667,  3707,   373,  3700,  3709,  3702,   373,  2524,
     373,  3723,  3764,  3711,  3717,  2179,  3729,  3730,  2329,  2180,
    3731,    80,  3732,  1005,    80,  3733,  3734,  2698,  3763,  2327,
    3772,  3776,  3777,  3814,  3803,  2696,  3816,  3818,  3826,  1005,
    2181,  2182,  3825,  1345,  3140,  3835,  1186,  3834,  1355,  3831,
    3838,  3841,  3861,  3869,  3871,  2183,  3880,  2163,  1367,  3891,
    3881,  3882,  3886,  3883,  4786,  3892,  3893,  3983,  3902,  3510,
    3439,  3421,  1913,  3907,  3510,  3863,  3438,  3510,  3936,  2108,
     695,  3952,  2167,  4005,  3937,  2185,  3964,  4031,  4023,  3938,
    3270,  3944,  3965,  4054,  3973,  3141,  4011,  1005,  2186,  2404,
    4002,  3989,  1913,  1186,  1186,  4021,  4022,  4045,  4024,  4072,
    4027,   823,  1413,  1414,  4082,  3510,  4100,  4028,  4074,  4083,
    4075,  4178,  4085,  4377,  4093,  3768,  4101,  2089,   856,  4102,
    2798,  4114,  4112,  4115,  4113,  4116,  4193,  4117,  4123,  4139,
    4088,  4152,  4150,  4593,  4143,  4153,   411,  1218,  4215,  1667,
    2814,  3853,  4226,  4228,  4229,  4247,  4181,  3704,   829,   829,
     829,  4207,  2405,  1186,  4251,  4219,  2721,  4238,  2406,   822,
    4375,  2407,  4265,   822,  4231,   822,  4252,  2188,  4232,  4254,
    1199,  4267,  4262,  4275,  4261,  3142,  4280,  4283,   372,  4284,
    4285,  4286,   372,  2089,   372,  4269,  2408,  2089,  2089,  1186,
    4287,  4295,  2409,  4304,  4292,  4305,  4306,  4307,  4336,  1186,
    1186,  4401,  1913,  4312,  4299,  2410,  3143,  1186,  1186,  4300,
    4337,  4308,  1186,  1913,  4332,  3271,  4349,  4334,  1186,  1186,
    4368,  4344,  1186,  4347,  3510,  4350,  4367,  4376,  4352,  2411,
    4353,  2536,  2927,  3523,  1005,  4378,  4371,  1186,  4383,  4384,
    4399,  1186,  4398,  4400,  4406,  4413,  4424,  4434,  4430,  4416,
    1186,  4441,  4449,  4456,  3272,  1186, -2583, -2583,  4446,  2192,
    2193,  2194,  2195,  2196,  2197,   829,  4464,  1186,  4468,  4469,
    4473,  4475,  4494,  4484,  3510,  4500,  4363,  4488,  3144,  4501,
    4509,  4517,   829,  4525,  4526,  4528,  3145,  4535,  4533,  3146,
    4536,  4537,  4538,    81,  4544,  4554,  4564,  4551,    79,  4566,
    4570,  4560,  4458,  4586,   823,  1186,  4574,  4602,   823,  4589,
     823,  2814,  2814,  4612,  4596,  4597,  4603,  4214,  4621,  4631,
    1913,  4619,  4632,  4634,  4635,  4649,  4637,  4650,   709,  4651,
    3739,  4653,  4652,  4655,  2610,  4656,  4657,  4670,  4678,   411,
    4693,  1913,  4684,   411,  1698,   411,    80,  1107,    80,  4701,
    2536,  4708,  4738,  1913,  4731,  4735,  4741,  4761,  4755,  4756,
    4762,   820,  4767,  4771,  4772,  4776,  4777,  4782,  4784,  4795,
    4712,  2339,  4800,  2014,  4801,  1760,  4804,  4806,  4810,  4817,
    4822,  1761,  4818,  4819,  4840,  4013,  4848,  4843,  4851,  4845,
    4802,  1913,  4803,    74,  4859,  4888,  4876,  1005,  4906,  4909,
    4899,  4917,  4922,  1119,  2538,  1759,  2251,  3279,  2536,  3547,
    3127,  4470,   413,  3646,  4097,  3189,   820,  3736,  4606,  4435,
    1580,  4723,  4633,  1762,  4479,  4249,  4636,  4461,  4646,  3358,
     707,  2172,  3601,  4846,  2173,   365,  4578,  1995,  1005,  4884,
    4807,  4805,  4857,  3419,  3420,  4743,  3606,  4250,  3435,  2641,
    4218,  4410,  4411,  4096,  3261,  1186,  4414,  4415,  3262,  2176,
    3657,  4220,  2621,  3245,  4812,  4221,  2177,   413,  3821,  4887,
    4923,  4918,  3318,  3773,  1763,  3751,  4858,  4595,  2606,  4797,
    4849,  3510,  1764,  4598,  1024,  1765,  2081,  4281,  3470,  3471,
    4696,  2178,  1740,  3082,  4257,  4760,   829,  4258,   373,  3708,
    4869,  4920,  4626,  1332,  2938,  2706,  2939,  3551,  1007,  1594,
    1913,  4237,  4041,  3354,  2080,  4847,  4369,  2270,  3552,  3180,
    3560,  2961,  2296,  2030,  2295,  3564,  1741,  2960,  1007,  2092,
    2955,  3768,  3768,  3768,  3768,  3768,  2300,  3577,  1766,  1005,
    3565,  2102,  1616,  1186,  3503,  3985,  4342,  1913,  3503,  4686,
    1602,  2303,  1186,   373,  4831,  3956,  3472,  3213,  4042,  4676,
    3946,  4832,  4839,  3487,  3555,  3213,  3400,  3485,  4038,  1186,
    1186,  2905,  1152,  1186,  3862,  3327,  1969,  2657,  2986,  1379,
    4829,  1122,  2308,  1742,  1186,  2315,  1708,  2977,  2088,  1186,
     365,  2993,  1186,  1767,  2990, -2583,  1768,  1186,  1186,  2180,
    1679,  3542,  1680,  4047,  2991,  4359,  1769,  4048,  2218,  4571,
    4026,  1145,  2997,  4568,  1770,  1743,  3356,  2312,  3283,  2017,
    2181,  2182,  2718,  1771,    83,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,     0, -2583,     0,     0,  1420,     0,
    4921,     0,  3312,     0,  3319,     0,     0,  2814,  1331,     0,
       0,     0,     0,     0,  1913,  1772,  4532,     0,  1186,  1667,
    1773,     0,     0,   822,     0,  2185,     0,     0,     0,     0,
       0,     0,     0,  2814,  2814,     0,     0,     0,  2186,     0,
       0,     0,   372,  1331,     0,     0,     0,  1774,     0,     0,
       0,     0,     0,     0,     0,  1186,     0,     0,    35,   829,
       0,     0,  2271,   829,     0,   829,    41,    42,  4567,     0,
       0,     0,  2172,     0,     0,  2173,     0,     0,   822,  1760,
       0,     0,     0,     0,     0,  1761,     0,     0,     0,     0,
       0,     0,  2174,   695,     0,  2175,     0,   372,     0,     0,
    2176,     0,     0,  1775,   208,     0,     0,  2177,  3320,  1186,
       0,  1913,     0,     0,  1005,     0,  1747, -2583,     0,     0,
    3004,     0,     0,  1748,     0,  3008,     0,  1762,  3011,     0,
       0,  1834,  2178,  1186,  1913,     0,  1186,     0,  1186,  1750,
       0,   365,     0,     0,     0,     0,     0,  1751,     0,  2000,
    3033,     0,     0,     0,     0,  1186,     0,     0,     0,  1186,
    2015,     0,     0,     0,  1913,     0,     0,     0,   823,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1763,  3072,
     820,     0,     0,     0,     0,     0,  1764,     0,     0,  1765,
       0,     0,     0,     0,     0,     0,     0,  1752,     0,     0,
    1913,  3321,  3086,   411,  1913,  1913,     0,     0,     0,  2192,
    2193,  2194,  2195,  2196,  2197,     0,     0,     0,     0,     0,
       0,     0,     0,   823,     0,  3117,     0,     0,     0,     0,
       0,   413,     0,     0,     0,  4905,  2179,  2814,     0,  1186,
    2180,     0,  1766,     0,     0,     0,     0,  3138,     0,     0,
    3149,  3503,     0,     0,     0,     0,  3503,     0,   411,  3503,
       0,  2181,  2182,     0,     0,     0,     0,  3157,     0,     0,
       0,  1913,     0,     0,  3161,     0,  2183,     0,  4766,     0,
       0,     0,  1331,     0,     0,     0,     0,  3184,     0,     0,
       0,     0,     0,     0,     0,     0,  3191,  1767,     0,     0,
    1768,  1186,     0,  2184,     0,     0,  2185,     0,     0,     0,
    1769,     0,     0,     0,     0,     0,  1186,   373,  1770,  2186,
       0,     0,  2187,     0,     0,     0,     0,  1771,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1760,     0,  1186,
       0,     0,     0,  1761,     0,     0,     0,     0,     0,  1812,
       0,     0,     0,   369,  1773,     0,  1186,     0,     0,  4871,
       0,  4872,     0,  4874,  4873,     0,     0,     0,  4764,     0,
       0,     0,     0,     0,     0,  4894,     0,  1186,  1186,     0,
       0,  1813,  1331,     0,     0,  1762,     0,     0,  2188,     0,
    1186,     0,   369,     0,     0,     0,     0,     0,  4871,     0,
    4872,     0,  4874,  4873,  3914,     0,   820,  3919,  3920,  3921,
    3922,  3923,  3924,  3925,  3926,  3927,  3928,     0,     0,     0,
    2670,     0,     0,     0,     0,     0,     0,  4894,   703,     0,
    2679,  1186,     0,   721,     0,     0,  1763,  1775,  4894,     0,
     369,  1186,  2686,     0,  1764,     0,  4871,  1765,  4872,     0,
    4874,  4873,     0,     0,     0,     0,  3503,   413,   820,  3662,
       0,     0,  4895,     0,     0,     0,  3968,  3969,     0,   820,
       0,   721,   822,     0,     0,     0,  2189,  2190,  2191,     0,
    2192,  2193,  2194,  2195,  2196,  2197,  3684,     0,     0,     0,
       0,   372,   721,     0,     0,     0,     0,     0,     0,     0,
    1766,     0,     0,  2726,  1186,     0,  2731,     0,  2733,   413,
    1016,  2736,     0,     0,  4895,  1186,     0,  3318,     0,     0,
     413,     0,     0,  1017,     0,  4895,     0,     0,     0,     0,
       0,  1025,     0,     0,     0,     0,     0,  1740,     0,     0,
       0,     0,     0,   373,     0,     0,  1035,  3213,  1016,     0,
    3213,  3213,  1056,   829,  3213,  1767,     0,  4893,  1768,     0,
       0,     0,  1085,     0,  3213,   939,     0,     0,  1769,  1873,
    1090,  1741,     0,     0,     0,  3761,  1770,   940,     0,     0,
       0,  3770,     0,     0,     0,  1771,     0,     0,  3761,     0,
       0,     0,     0,     0,     0,   373,     0,     0,     0,   941,
       0,  1331,     0,  1331,     0,     0,   373,     0,   829,  4893,
       0,     0,     0,   942,     0,     0,     0,   823,     0,     0,
    4893,     0,  1773,     0,     0,     0,   943,     0,  1742,     0,
       0,     0,     0,     0,     0,  3824,     0,     0,     0,     0,
       0,     0,     0,     0,   944,     0,     0,     0,     0,  1774,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
    1743,     0,  3848,  1331,     0,     0,     0,   945,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1007,     0,  1007,     0,  1007,   946,     0,     0,     0,  3319,
    1007,     0,     0,     0,     0,     0,   947,     0,     0,     0,
       0,   948,     0,     0,     0,  1775,     0,   949,   822,     0,
       0,     0,     0,  1007,  1007,     0,     0,     0,     0,     0,
       0,     0,     0,   950,     0,     0,     0,   372,     0,     0,
       0,  3318,     0,   365,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3590,  1740,     0,     0,     0,     0,  2663,     0,     0,     0,
     822,     0,     0,     0,     0,  2669,     0,     0,     0,     0,
    4210,   822,  4904,     0,  2677,  2678,     0,     0,     0,   372,
       0,   951,     0,     0,     0,  1741,     0,     0,     0,   208,
     372,     0,  2690,  1746,     0,     0,     0,     0,     0,   952,
       0,  1747,     0,     0,     0,     0,     0,     0,  1748,   953,
       0,     0,  3957,     0,     0,     0,  1834,     0,     0,     0,
     365,     0,     0,     0,  1750,     0,     0,     0,   856,     0,
       0,  1007,  1751,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1742,     0,     0,   707,   707,     0,     0,     0,
    1695,     0,     0,   823,     0,   954,     0,     0,     0,     0,
     955,     0,   956,     0,     0,  4018,     0,     0,   957,     0,
       0,   958,     0,     0,  1743,     0,     0,  3667,  3087,     0,
       0,     0,  1752,     0,  3679,     0,  3321,  3853,   411,     0,
       0,     0,     0,  1007,     0,     0,   959,     0,   960,     0,
       0,     0,   961,  3319,     0,   823,     0,     0,     0,     0,
     962,     0,     0,     0,     0,   963,   823,     4,     0,     0,
       0,     0,     0,     0,     0,     0,   964,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     0,   965,
     411,  4316,  4317,  3713,     0,     0,     0,     6,     7,     0,
       0,   411,     0,     0,     0,     9,    10,     0,     0,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,     0,     0,     0,    45,     0,
       0,   721,     0,   208,     0,     0,     0,  1746,     0,  3761,
       0,     0,   829,     0,     0,  1747,     0,     0,     0,     0,
       0,     0,  1748,     0,     0,     0,  4119,     0,     0,  4120,
    1834,  4121,     0,     0,     0,     0,     0,     0,  1750,     0,
       0,     0,     0,  2935,     0,     0,  1751,    46,     0,  4141,
    4142,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3213,     0,     0,
       0,     0,     0,  3213,  3213,  3213,  3213,  3213,  3213,     0,
       0,     0,     0,  1331,     0,  1007,     0,  4171,     0,     0,
       0,     0,     0,     0,     0,     0,  1752,  2536,     0,     0,
    3321,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3770,     0,     0,     0,     0,  3887,     0,     0,     0,
       0,    47,  4194,  4196,  4198,  4200,     0,     0,     0,     0,
       0,     0,     0,     0,  3897,     0,     0,    48,     0,     0,
       0,  2172,     0,     0,  2173,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    49,     0,
       0,     0,  3363,     0,     0,     0,     0,     0,     0,  2176,
       0,     0,     0,     0,     0,     0,  2177,     0,     0,     0,
      50,  1182,  1188,  1188,   721,  4256,  1188,  1195,     0,  1182,
     703,  1085,     0,  1204,  1220,     0,   703,     0,  1085,     0,
    1085,  2178,     0,     0,  1188,   703,  1085,     0,     0,     0,
       0,     0,     0,    51,     0,  1245,     0,    52,     0,     0,
    1085,     0,  1182,     0,     0,     0,  1188,     0,   721,     0,
    1188,     0,     0,    53,   703,     0,  1204,  1220,     0,   703,
    1302,     0,     0,     0,     0,     0,  4290,  1188,   829,     0,
     703,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3483,     0,     0,     0,
       0,     0,     0,     0,  1330,  1007,     0,  4524,  1182,  1007,
    1007,     0,     0,   721,     0,     0,     0,  1182,     0,     0,
    1204,  1220,     0,     0,     0,     0,     0,     0,     0,     0,
     829,     0,     0,  4540,  4541, -2583,  1188,     0,     0,  2180,
      54,   829,     0,     0,     0,     0,     0,     0,  1395,     0,
       0,     0,  2172,     0,     0,  2173,     0,     0,     0,     0,
    2181,  2182,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2174,     0,     0, -2583,     0,     0,     0,     0,
    2176,    55,     0,     0,     0,     0,     0,  2177,     0,     0,
    1085,     0,   707,     0,    56,     0,     0,  4364,  4365,     0,
       0,     0,  1085,  1449,     0,  2185,     0,  4081,     0,    57,
       0,     0,  2178,     0,     0,     0,     0,     0,  2186,    80,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1555,
       0,     0,     0,   721,  1085,    58,     0,  1330,     0,     0,
       0,    59,     0,     0,     0,    60,    61,    62,    63,    64,
       0,  1085,    65,    66,  1372,  1085,     0,     0,     0,    71,
    1373,     0,  1007,  1555,     0,     0,     0,     0,  1007,     0,
       0,  4128,     0,  1085,  4131,     0,     0,  3335,     0,     0,
    3594,  3595,     0,  3597,     0,  1085,     0,     0,     0,     0,
       0,  3343,  3344,     0,     0,  3346,  4149, -2583,     0,     0,
       0,  3350,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1007,  2179,     0,  1007,  1007,
    2180,     0,     0,   703,   703,     0,  3213,  3213,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4673,     0,     0,
    1331,  2181,  2182,     0,  4439,     0,  4440,     0,     0,  4444,
    4445,     0,     0,     0,     0,     0,  2183,  3770,  3770,  3770,
    3770,  3770,     0,     0,     0,     0,  1085,     0,     0,     0,
       0,  3386,     0,     0,     0,  1188,  1188,     0,     0,     0,
       0,  1007,     0,  2184,     0,     0,  2185,     0,     0,  2192,
    2193,  2194,  2195,  2196,  2197,     0,     0,     0,     0,  2186,
       0,     0,  2187,     0,     0,     0,  4477,     0,     0,  3686,
       0,     0,     0,     0,     0,  1182,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1182,     0,  2172,  1220,     0,
    2173,     0,     0,     0,     0,  4502,     0,     0,     0,     0,
       0,  1188,     0,     0,     0,     0,     0,  2174,     0,     0,
       0,     0,     0,     0,     0,  2176,     0,  1085,  4290,  4290,
    4290,  4290,  2177,  1928,     0,  1188,  1188,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2188,  1085,
    1085,  1085,  1188,     0,  1182,     0,     0,  2178,  1966,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2172,
       0,     0,  2173,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1928,     0,  1188,  1188,
       0,     0,     0,     0,     0,     0,     0,  2176,     0,     0,
       0,     0,     0,  3809,  2177,  3812,     0,  1330,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1204,
       0,     0,     0,  1555,     0,  2172,     0,     0,  2173,  2178,
       0,     0,     0,  1330,     0,     0,  2189,  2190,  2191,     0,
    2192,  2193,  2194,  2195,  2196,  2197,     0,     0,  2931,     0,
    3761,     0,     0,  2176,  2932,     0,     0,     0,     0,     0,
    2177,  2179,     0,  2066,  2066,  2180,     0,     0,  1085,     0,
    1016,     0,     0,     0,  3213,     0,     0,     0,  4607,     0,
       0,     0,     0,     0,     0,  2178,  2181,  2182,     0,     0,
       0,     0,  2098,     0,     0,  1085,  3884,  2172,  2104,  1330,
    2173,  2183,     0,     0,     0,     0,     0,     0,     0,     0,
    1555,  3610,     0,     0,     0,     0,  3894,  2174,     0,     0,
       0,     0,     0,     0,     0,  2176,     0,     0,  2184,     0,
       0,  2185,  2177,  2179,     0,     0,     0,  2180,  1555,     0,
       0,     0,     0,     0,  2186,     0,     0,  2187,     0,  4407,
       0,     0,     0,     0,     0,     0,     0,  2178,  2181,  2182,
       0,  4417,     0,     0,     0,     0,  1555,  1555,     0,  1555,
       0,     0,     0,  2183,     0,     0,     0,  3649,     0,  3651,
       0,     0,     0,     0,     0,     0,  1555,     0,     0,  2179,
       0,     0,     0,  2180,     0,     0,     0,  4429,     0,     0,
    2184,     0,     0,  2185,     0,     0,   721,   721,     0,     0,
       0,     0,     0,     0,  2181,  2182,  2186,     0,     0,     0,
    1330,     0,     0,  2188,     0,     0,     0,  1330,  1330,  2183,
       0,     0,     0,     0,  1085,     0,     0,  1555,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1331,     0,     0,  1760,     0,  3703,  2185,
       0,  2179,  1761,  3710,     0,  2180,  1555,     0,     0,     0,
    1555,  1555,  2186,  1007,     0,     0,     0,     0,     0,     0,
    1085,  1085,  2306,     0,     0,     0,  2181,  2182,     0,     0,
       0,     0,     0,     0,     0,  2188,     0,     0,     0,     0,
       0,  2183,     0,     0,  1762,     0,     0,     0,   721,     0,
     703,  2189,  2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,
    2197,  1007,     0,     0,     0,   707,     0,  3414,  2184,     0,
       0,  2185,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1695,     0,     0,  2186,     0,     0,  2187,     0,     0,
       0,  2188,     0,     0,     0,  1763,     0,     0,     0,     0,
       0,     0,     0,  1764,     0,     0,  1765,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2189,  2190,  2191,     0,  2192,  2193,  2194,
    2195,  2196,  2197,     0,     0,     0,     0,     0,     0,  2449,
       0,     0,     0,     0,     0,  1085,     0,     0,  1188,     0,
       0,     0,  3865,     0,     0,     0,  3868,     0,  3870,  1766,
    3872,  3873,     0,  2188,     0,     0,  1220,     0,     0,  3878,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2189,
    2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1188,  1188,
    1188,  1188,  1085,     0,  3896,     0,     0,     0,     0,     0,
    2172,   703,     0,  2173,  1767,     0,     0,  1768,     0,     0,
       0,     0,     0,     0,     0,     0,  1007,  1769,  1204,  1204,
    2552,     0,  1085,     0,  1007,  1770,  1007,     0,  2176,     0,
    1188,  1188,     0,  4896,  1771,  2177,  1188,     0,     0,     0,
       0,  2189,  2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,
    2197,     0,     0,     0,     0,     0,     0,  3462,     0,     0,
    2178,     0,     0,     0,     0,     0,  1837,     0,     0,     0,
       0,  1773,     0,     0,  4223,  4224,     0,     0,     0,     0,
       0,     0,     0,  1188,     0,  4896,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4896,     0,  1838,  2172,
       0,     0,  2173,     0,   703,     0,     0,     0,     0,     0,
    1188,  1188,  1188,  1188,     0,     0,     0,     0,     0,  2174,
     703,     0,     0,     0,     0,  3970,     0,  2176,     0,  2552,
       0,     0,     0,     0,  2177,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1182,  4276,  4277,  4278,     0,     0,
       0,   721,     0,  1182,  1775,     0,     0,     0,     0,  2178,
       0,     0,  1220,     0, -2583,     0,     0,  1085,  2180,     0,
       0,     0,     0,     0,     0,     0,  1085,     0,   703,     0,
       0,     0,  1188,  1188,     0,     0,     0,     0,     0,  2181,
    2182,     0,     0,     0,     0,     0,     0,     0,  1085,     0,
       0,  1395,     0,     0, -2583,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2066,     0,  2185,     0,     0,     0,     0,     0,
    1182,     0,     0,     0,  1085,  1085,     0,  2186,     0,     0,
       0,     0,  1085,  1007,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2179,     0,     0,     0,  2180,  1016,  1016,
       0,     0,  2762,     0,     0,     0,  1555,  1555,     0,     0,
       0,     0,     0,     0,  1555,     0,     0,  1555,  2181,  2182,
    1555,     0,     0,     0,     0,     0,     0,     0,  1555,  1555,
       0,     0,     0,  2183,     0,     0,  1555,     0,  1220,  1555,
    1555,  1555,  1555,     0,     0,     0,     0,     0,     0,  1555,
    1555,     0,  1555,     0,  1555,  1555, -2583,     0,  1555,     0,
    2184,     0,     0,  2185,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1555,     0,     0,  2186,  1188,  1555,  2187,
       0,     0,  1555,     0,     0,     0,  1555,     0,  1555,  1555,
    1555,  1555,  1555,  1555,  1555,  1555,  1555,     0,  1555,     0,
       0,     0,     0,  1085,  1555,     0,     0,  1555,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4420,  4421,     0,
    4423,     0,     0,     0,     0,     0,     0,     0,  1085,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2192,  2193,
    2194,  2195,  2196,  2197,     0,  2188,     0,     0,     0,     0,
       0,     0,  2172,     0,  1085,  2173,  1085,     0,  1555,     0,
       0,  1760,     0,     0,     0,     0,     0,  1761,     0,  1007,
       0,     0,  2174,     0,     0,     0,     0,     0,     0,     0,
    2176,     0,     0,     0,     0,  2172,     0,  2177,  2173,     0,
       0,     0,     0,     0,  2968,     0,  2975,  4270,     0,     0,
       0,     0,     0,     0,  4273,  4274,     0,     0,     0,  1762,
       0,     0,  2178,  2176,     0,     0,     0,     0,     0,     0,
    2177,     0,     0,   703,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2189,  2190,  2191,     0,  2192,  2193,  2194,
    2195,  2196,  2197,     0,     0,  2178,     0,  2845,     0,     0,
     703,     0,     0,     0,     0,   703,     0,     0,   703,   721,
    1763,     0,     0,     0,  1016,     0,  1016,     0,  1764,     0,
       0,  1765,     0,     0,     0,     0,     0,     0,     0,     0,
     703,  1555,     0,     0,     0,     0,  1182,     0,  1188,  1188,
    1188,     0,  1182,  1220,     0,  1188,     0,  1188,     0,  1188,
    1188,     0,     0,  2172,     0,     0,  2173,     0,     0,   703,
    3971,     0,     0,     0,     0,     0,  2179,     0,     0,     0,
    2180,     0,     0,     0,  1766,     0,     0,     0,     0,     0,
       0,  2176,   703,     0,  2449,     0,     0,     0,  2177,     0,
    3090,  2181,  2182,     0,     0,  3099,     0,     0,     0, -2583,
       0,  1085,     0,  2180,     0,   703,  2183,     0,     0,     0,
       0,     0,     0,  2178,     0,     0,     0,     0,     0,  3130,
    3130,     0,     0,     0,  2181,  2182,   721,   703,     0,  1767,
     703,     0,  1768,  2184,     0,     0,  2185,     0,     0, -2583,
    1188,     0,  1769,     0,     0,     0,     0,   703,     0,  2186,
    1770,     0,  2187,     0,   703,     0,     0,     0,     0,  1771,
       0,     0,     0,  3179,     0,  3181,  3183,   703,     0,  2185,
       0,     0,     0,     0,  4404,  4405,   703,     0,  3974,     0,
       0,     0,  2186,     0,     0,     0,     0,     0,     0,     0,
       0,  2414,     0,     0,     0,  1188,  1773,     0,     0,  2172,
       0,     0,  2173,  1188,  1188,  1188,  1188,  1188,  1188,     0,
       0,     0,     0,     0,     0,     0,     0, -2583,  1555,  2174,
       0,  2180,  1007,  2415,  4427,  4428,     0,  2176,  2188,     0,
       0,     0,     0,     0,  2177,  1007,     0,     0,     0,     0,
       0,  2449,  2181,  2182,  1204,     0,  3130,  1085,     0,     0,
       0,  1016,     0,     0,     0,     0,     0, -2583,     0,  2178,
       0, -2583,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2172,     0,  3179,  2173,  4681,  1775,
       0,     0,     0,  1188,  3309,     0,     0,  2185,  4681,     0,
       0,     0,     0,  1330,  1966,     0,     0,     0,     0,     0,
    2186,     0,  2176,     0,     0,     0,     0,     0,     0,  2177,
       0,  1188,  3130,  1188,  3130,     0,  2189,  2190,  2191,     0,
    2192,  2193,  2194,  2195,  2196,  2197,     0,     0,  1330,     0,
    3762,     0,     0,     0,  2178,  1204,     0,  4721,     0,  1555,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4513,
       0,  4514,  4515,  2192,  2193,  2194,  2195,  2196,  2197,     0,
    2066,     0,  4518,  2179,     0,     0,     0,  2180,     0,     0,
       0,     0,     0,     0,     0,     0,   703,     0,     0, -2583,
       0,  1007,     0,     0,     0,     0,     0,     0,  2181,  2182,
       0,     0,     0,     0,     0,     0,     0,     0,   703,  4325,
       0,     0,  1182,  2183,     0,     0,  1182,     0,     0,     0,
       0,     0,     0,     0,  1188,     0,     0,     0,  4774,     0,
    1555,  1555,     0,     0,     0,     0,     0,     0,     0,     0,
    2184,     0,     0,  2185,     0,     0,     0,     0, -2583,     0,
       0,     0,  2180,     0,     0,     0,  2186,     0,     0,  2187,
    1555,  1555,     0,     0,     0,  1555,     0,     0,     0,     0,
       0,     0,     0,  2181,  2182,     0,     0,  1555,  1555,  1555,
    1555,  2192,  2193,  2194,  2195,  2196,  2197,     0, -2583,     0,
    1555,     0,     0,  1555,     0,  1555,  3466,     0,     0,     0,
       0,     0,     0,     0,     0,  1555,  1555,     0,     0,  1555,
       0,     0,     0,     0,     0,     0,     0,     0,  2185,     0,
       0,     0,  1555,     0,  1555,     0,  1220,     0,  1555,     0,
       0,  2186,     0,     0,     0,  2188,     0,     0,     0,     0,
       0,     0,     0,     0,  1555,     0,     0,     0,  1085,     0,
       0,     0,     0,     0,     0,  3511,     0,  1555,  1555,  1555,
       0,     0,     0,     0,     0,     0,  2172,     0,     0,  2173,
       0,     0,     0,     0,     0,     0,     0,  1330,     0,     0,
       0,  1555,     0,     0,     0,     0,  2174,     0,     0,     0,
       0,     0,     0,  1555,  2176,     0,     0,     0,  1555,     0,
       0,  2177,  1085,     0,     0,  1555,     0,     0,     0,  4672,
   -2583,  3511,     0,     0,  3571,     0,     0,     0,  2975,     0,
       0,     0,     0,  2189,  2190,  2191,  2178,  2192,  2193,  2194,
    2195,  2196,  2197,     0,     0,     0,     0,  3955,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     703,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4698,  1007,     0,     0,     0,
       0,  1555,     0,  3130,     0,     0,     0,     0,  2066,     0,
       0,     0,  1007,     0,     0,     0,     0,  1330,     0,     0,
       0,     0,     0,     0,  4722,  1188,     0,  1188,  1188,     0,
       0,     0,  2192,  2193,  2194,  2195,  2196,  2197,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2179,     0,     0,     0,  2180,     0,     0,     0,     0,     0,
    1007,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2181,  2182,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2183,     0,     0,     0,     0,     0,     0,   703,     0,     0,
       0,     0,     0,     0,   703,     0,  2172,     0,     0,  2173,
       0,     0,     0,     0,     0,     0,     0,  2184,     0,     0,
    2185,     0,     0,     0,  1760,     0,  2174,     0,     0,     0,
    1761,     0,     0,  2186,  2176,     0,  2187,     0,     0,     0,
       0,  2177,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1794,     0,     0,     0,
       0,     0,     0,   703,     0,     0,  2178,     0,   721,     0,
       0,     0,  1762,     0,     0,     0,     0,  3130,  3130,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1795,     0,  3769,  1007,     0,     0,
       0,     0,  2188,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1763,     0,     0,  1330,     0,  1330,     0,
       0,  1764,  1085,     0,  1765,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   828,     0,
       0,  4881,  1201,     0,     0,     0,     0,  2066,  1085,  1223,
       0,     0,     0,     0,     0,  1085,     0,  1232,     0,  1085,
    2179,     0,     0,     0,  2180,     0,  1243,     0,     0,     0,
       0,  1274,  1085,     0,  1796,     0,     0,  1766,  1330,     0,
       0,     0,     0,   828,     0,  2181,  2182,   721,     0,     0,
    2189,  2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,
    2183,  1085,  4025,     0,  1085,     0,     0,   703,     0,     0,
       0,     0,  3879,     0,     0,     0,     0,     0,     0,  1797,
       0,  1798,     0,  1182,     0,     0,   703,  2184,     0,  1047,
    2185,     0,  1799,     0,     0,  1768,     0,  1047,     0,  1047,
       0,     0,  1085,  2186,   703,  1769,  2187,     0,     0,     0,
    1188,   828,     0,  1770,     0,     0,     0,     0,  1555,     0,
    1007,  1800,  1771,     0,     0,     0,     0,  1555,     0,     0,
       0,     0,     0,  1555,     0,  1555,     0,     0,     0,     0,
       0,  1555,     0,     0,  1555,  1555,  1555,  1555,  1555,  1555,
    1555,  1555,  1555,  1555,  1801,     0,     0,  1555,  1555,  1773,
    1802,  1007,     0,     0,     0,     0,     0,     0,     0,     0,
    1555,     0,     0,     0,  1555,     0,     0,     0,  1555,     0,
       0,     0,  2188,  1448,     0,     0,  1803,     0,  1555,     0,
       0,  1555,     0,  1555,     0,     0,  1804,     0,     0,     0,
       0,     0,  1555,  1555,  1555,     0,     0,     0,  1555,     0,
       0,  1555,     0,     0,     0,  1573,     0,     0,  1085,  1085,
    1085,  3511,  3988,     0,     0,     0,  3988,  4001,     0,     0,
       0,  1555,  1596,  2172,     0,   842,  2173,  4015,     0,  1555,
       0,  1555,  1775,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2174,  1622,     0,     0,     0,     0,     0,
       0,  2176,  1007,     0,     0,     0,     0,     0,  2177,     0,
    2189,  2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,
       0,     0,     0,   843,  4030,  1555,     0,     0,     0,     0,
       0,  1555,     0,  2178,     0,  2975,   844,  1555,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   845,     0,     0,     0,     0,     0,
     846,     0,  4062,  2066,  2066,     0,  2552,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   847,  1188,  1188,
    1188,  1188,     0,     0,     0,     0,     0,   703,     0,     0,
       0,     0,     0,     0,     0,   848,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   849,     0,     0,  4095,
       0,   850,     0,     0,     0,     0,     0,   851,     0,     0,
       0,     0,     0,     0,     0,  2172,     0,     0,  2173,     0,
       0,     0,     0,   852,     0,     0,     0,  2179,     0,     0,
       0,  2180,     0,     0,     0,  2174,     0,     0,     0,     0,
       0,   703,     0,  2176,   703,     0,     0,     0,   853,     0,
    2177,     0,  2181,  2182,     0,     0,     0,     0,  4144,     0,
       0,     0,     0,     0,   721,     0,   703,  2183,  1925,     0,
       0,     0,     0,     0,     0,  2178,     0,     0,     0,     0,
       0,   854,     0,     0,  2172,     0,     0,  2173,  1330,     0,
    1953,  1956,  1957,     0,  2184,     0,     0,  2185,     0,   855,
       0,     0,     0,     0,  2174,     0,     0,  1007,     0,     0,
    2186,     0,  2176,  2187,     0,     0,  3769,     0,     0,  2177,
       0,     0,     0,     0,  1085,     0,     0,     0,   856,     0,
       0,     0,     0,     0,     0,  1188,     0,  1555,     0,     0,
       0,     0,     0,  1085,  2178,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   857,  2449,     0,     0,     0,
       0,     0,   858,     0,     0,     0,  1085,     0,   859,     0,
       0,   860,     0,     0,     0,  3179,     0,     0,     0,  2179,
    4244,     0,     0,  2180,  2449,     0,  3879,     0,     0,  2188,
       0,     0,     0,     0,  1555,  1555,   861,     0,   862,     0,
       0,     0,   863,     0,  2181,  2182,     0,     0,     0,  1573,
     864,     0,     0,     0,     0,   865,     0,     0,  3130,  2183,
    3130,     0,     0,     0,     0,     0,   866,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1573,     0,   703,   867,
       0,     0,     0,     0,     0,     0,  2184,     0,  2179,  2185,
       0,     0,  2180,     0,  1555,     0,     0,     0,     0,     0,
       0,     0,  2186,     0,     0,  2187,     0,     0,     0,     0,
       0,     0,     0,  2181,  2182,     0,     0,  2189,  2190,  2191,
       0,  2192,  2193,  2194,  2195,  2196,  2197,     0,  2183,     0,
    1555,  4056,     0,     0,     0,     0,     0,     0,     0,     0,
    1555,  1555,     0,     0,     0,     0,     0,     0,  1555,  1555,
       0,     0,     0,  1555,     0,  2184,     0,     0,  2185,  1555,
    1555,     0,     0,  1555,     0,  1085,  1085,  1085,  1085,     0,
       0,  2186,  3988,     0,  2187,  4333,     0,     0,  3511,     0,
       0,  2188,  3511,     0,     0,   828,     0,     0,  4346,     0,
       0,  1555,     0,  1184,     0,     0,  1555,     0,     0,     0,
       0,  1184,  4356,     0,     0,     0,     0,     0,  1555,     0,
       0,  4765,     0,     0,     0,  2255,     0,  1220,     0,  2172,
       0,     0,  2173,     0,     0,  3571,     0,     0,     0,  2975,
       0,     0,     0,     0,  1184,     0,     0,     0,     0,  2174,
       0,     0,     0,  1016,     0,     0,  1555,  2176,     0,     0,
    2188,     0,     0,     0,  2177,     0,     0,     0,     0,     0,
       0,     0,  2304,  3130,  3130,     0,     0,     0,     0,  2189,
    2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,  2178,
    4402,     0,     0,  4293,     0,     0,     0,     0,     0,   703,
    1184,     0,     0,     0,     0,     0,     0,     0,     0,  1184,
       0,   703,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1188,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1188,     0,
       0,     0,     0,     0,     0,     0,     0,   703,  2189,  2190,
    2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,     0,     0,
       0,     0,  4327,     0,     0,  1330,     0,     0,     0,     0,
       0,     0,     0,  2066,     0,     0,     0,     0,     0,     0,
       0,     0,  3769,  3769,  3769,  3769,  3769,     0,     0,     0,
       0,     0,     0,  2179,     0,     0,  2461,  2180,     0,     0,
       0, -2092,     0,     0,     0,     0,  1555,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2181,  2182,
       0,  1184,     0,     0,  1187,  1189,     0,  1047,  1192,  1193,
       0,  1047,     0,  2183,  1188,  2449,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1229,     0,     0, -2092,
       0,     0,     0,  2523,     0,  1184,     0,     0,     0,     0,
    2184, -2092,     0,  2185,  1085, -2092,  4512,     0,  1281,     0,
   -2092,     0,  1284,     0,     0, -2092,  2186,     0, -2092,  2187,
       0, -2092,   703,  2553,     0,     0,     0,     0,     0,  1307,
       0,     0,     0,     0,  1555,     0,     0,     0,     0,     0,
       0,     0,     0,  1555,     0,     0,     0,     0, -2092,     0,
       0,     0,     0,     0,  1908,     0,     0,     0,     0,     0,
    1555,  1555,     0,     0,  1555,     0,     0,     0, -2092,     0,
       0,  3988,     0,     0,     0,  3511,     0,     0,     0,     0,
    3511,     0,     0,  3511,  3179,     0,  4556,     0,  1555,  1555,
       0,     0,     0,     0,     0,  2188,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2092,     0,     0,     0,
       0,     0,     0,     0, -2092,   703,     0,   703,     0,     0,
       0,  4062,  1220,  1188,  1188,  1188,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1184,     0,  1182,
    1220,     0,     0,     0,     0,     0,     0,  1184,     0,     0,
       0, -2092,     0,     0,     0,     0,     0,     0,  2681,     0,
       0,     0,     0,     0,     0,     0,     0,  2685,     0,     0,
    2066,  1911,     0,  2189,  2190,  2191,  1182,  2192,  2193,  2194,
    2195,  2196,  2197,     0,     0,  1085,     0,  4534,     0,  2703,
       0,     0,     0,     0,     0,     0,     0,  1020,  3130,     0,
    2449,     0,     0,     0,     0,     0,  1184,  1908,     0,     0,
       0,     0,  4244,     0,     0,     0,     0,  1085,     0,     0,
   -2092,     0,     0,     0,     0,     0,     0,     0,     0,  1188,
    4062,     0,     0,     0,     0,  1573,  1573,     0,     0,     0,
       0,     0,     0, -2092,     0, -2092, -2092,     0,     0,     0,
       0,     0,     0,     0,  1555,     0,     0,  1555,     0,  1555,
       0,     0,     0,     0,     0,     0,     0,  2172,     0,     0,
    2173,     0,     0,     0,     0,  1184,  1555,     0, -2092,     0,
    3511, -2092, -2092,  4556, -2092,     0,     0,  2174,     0,  4692,
       0,     0,     0,     0,     0,  2176,     0,     0,     0,     0,
       0,     0,  2177,     0,     0,     0,     0,     0,     0,     0,
       0,  1188,     0,     0,     0,  1085,     0,  1783,  1784,     0,
       0,     0,     0,     0,     0,     0,     0,  2178,  1188,  1188,
    1188,  1188,     0,     0,  1911,     0,     0,     0,  1330,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2238,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1555,     0,  1184,     0,  2904,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2172,     0,     0,  2173,     0,     0,
       0,     0,     0,  1868,     0,     0,     0,     0,     0,  2924,
    1184,     0,     0,     0,  2174,     0,     0,     0,     0,     0,
       0,     0,  2176,     0,     0,     0,     0,  1930,  1931,  2177,
       0,     0,     0,     0,     0,     0,     0,     0,  1184,  1184,
       0,  1184,  1555,     0,  1958,  2937,     0,  2940,  1188,     0,
    1220,  2179,     0,     0,  2178,  2180,     0,  1555,  1184,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2181,  2182,     0,     0,
    1990,  1992,     0,     0,     0,     0,     0,  1188,     0,     0,
    1182,  2183,     0,  1908,     0,     0,     0,     0,     0,     0,
       0,     0,  1928,  1204,     0,     0,     0,  4062,     0,  1184,
     828,     0,     0,     0,     0,     0,  4512,     0,  2184,     0,
       0,  2185,     0,     0,     0,  4692,     0,     0,  1555,  1555,
       0,   703,     0,     0,  2186,     0,     0,  2187,  1184,     0,
    1908,  1182,  1184,  1184,     0,     0,     0,     0,     0,  1188,
    2172,     0,     0,  2173,     0,     0,     0,     0,  2179,     0,
       0,     0,  2180,     0,     0,     0,     0,     0,     0,  1908,
    2174,     0,     0,     0,     0,     0,     0,     0,  2176,     0,
       0,     0,  1555,  2181,  2182,  2177,     0,  2172,     0,     0,
    2173,     0,  1555,     0,     0,     0,     0,  1188,  2183,     0,
       0,     0,     0,     0,     0,     0,     0,  2174,     0,     0,
    2178,     0,     0,  2188,     0,  2176,     0,     0,     0,     0,
    1911,     0,  2177,     0,     0,  2184,   828,     0,  2185,     0,
       0,     0,     0,  1047,     0,     0,     0,     0,     0,  1908,
       0,  2186,  3108,     0,  2187,     0,     0,  2178,     0,     0,
       0,     0,     0,     0,     0,  1555,     0,     0,  1908,     0,
    1047,     0,     0,     0,     0,     0,  1182,  1911,     0,     0,
       0,     0,     0,     0,     0,     0,  1908,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1911,     0,     0,     0,
       0,  2189,  2190,  2191,  1908,  2192,  2193,  2194,  2195,  2196,
    2197,     0,     0,     0,  2179,  4576,     0,     0,  2180,     0,
    2188,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2181,
    2182,     0,     0,     0,     0,  1047,     0,     0,     0,     0,
       0,  2179,     0,     0,  2183,  2180,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1908,  1911,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2181,  2182,     0,     0,
       0,  2184,     0,     0,  2185,  1911,     0,     0,  3278,     0,
       0,  2183,     0,     0,     0,     0,     0,  2186,     0,     0,
    2187,     0,     0,  1911,     0,     0,     0,     0,  2189,  2190,
    2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,  2184,     0,
       0,  2185,  4617,     0,     0,     0,   828,     0,     0,     0,
       0,  1911,     0,     0,  2186,     0,     0,  2187,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1246,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2188,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1184,     0,  1247,     0,
       0,     0,  1911,     0,     0,  1184,     0,     0,     0,     0,
    2464,     0,  1248,  1249,     0,     0,     0,     0,     0,     0,
       0,  1250,     0,  2188,     0,  1251,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1252,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2519,  2520,  2521,  2522,     0,     0,  1253,  1908,     0,     0,
       0,     0,     0,     0,  2189,  2190,  2191,     0,  2192,  2193,
    2194,  2195,  2196,  2197,  1254,     0,     0,     0,  4811,     0,
       0,     0,  1184,     0,     0,  1255,     0,     0,     0,     0,
    1256,     0,  2560,  2561,     0,     0,     0,     0,  2570,     0,
       0,  2189,  2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,
    2197,     0,  1257,     0,     0,  4907,     0,     0,  1184,  1184,
       0,     0,     0,     0,     0,     0,  1184,     0,     0,  1184,
       0,     0,  1184,     0,     0,     0,     0,  1258,     0,     0,
    1184,  1184,     0,     0,     0,  2591,     0,     0,  1184,     0,
       0,  1184,  1184,  1184,  1184,     0,     0,     0,     0,     0,
       0,  1184,  1184,     0,  1184,     0,  1184,  1184,     0,     0,
    1184,     0,  2625,  2626,  2627,  2628,     0,     0,     0,  3498,
       0,     0,     0,     0,  1911,  1184,   828,     0,  1259,     0,
    1184,     0,     0,     0,  1184,     0,     0,     0,  1184,     0,
    1184,  1184,  1184,  1184,  1184,  1184,  1184,  1184,  1184,     0,
    1184,     0,     0,     0,     0,     0,  1184,   856,     0,  1184,
       0,     0,     0,     0,     0,     0,     0,   883,     0,     0,
       0,     0,     0,  1573,     0,     0,     0,     0,     0,   884,
       0,     0,     0,     0,  1260,  2692,   885,     0,     0,  1261,
       0,  1262,     0,     0,     0,     0,     0,  1263,     0,     0,
    1264,   886,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   887,     0,     0,     0,     0,
    1184,     0,     0,     0,   888,  1265,     0,  1266,  -717,     0,
       0,  1267,     0,     0,     0,    85,     0,     0,     0,  1268,
       0,    89,     0,     0,  1269,    93,   889,    94,     0,    96,
      97,     0,   890,     0,     0,     0,     0,  1908,     0,     0,
     106,     0,  1908,  1908,     0,     0,     0,     0,  1270,   891,
       0,     0,     0,  1908,     0,     0,     0,   119,   120,     0,
       0,     0,     0,     0,     0,     0,     0,   892,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   893,     0,
       0,     0,     0,     0,     0,   894,     0,     0,     0,   895,
       0,     0,     0,     0,     0,     0,   828,     0,     0,     0,
       0,     0,     0,   128,     0,  -905,     0,     0,     0,     0,
       0,     0,     0,   129,     0,   130,   131,     0,     0,     0,
       0,     0,     0,  1184,     0,     0,     0,     0,  1184,  2858,
       0,  1118,     0,     0,  1184,     0,     0,     0,     0,     0,
       0,     0,   896,     0,     0,     0,     0,     0,     0,     0,
       0,   141,     0,   142,   143,   144,     0,     0,     0,     0,
     146,     0,   147,   897,  1911,     0,     0,     0,     0,  1911,
    1911,     0,     0,   149,     0,   150,     0,     0,     0,     0,
    1911,   898,     0,     0,   899,  1908,     0,     0,     0,   153,
       0,   154,     0,     0,   157,     0,   828,     0,     0,   828,
       0,     0,     0,     0,     0,     0,     0,   158,     0,     0,
     159,     0,     0,     0,   160,     0,     0,     0,     0,     0,
     161,     0,     0,     0,     0,     0,     0,   163,     0,   165,
       0,     0,     0,     0,     0,   167,     0,   900,     0,     0,
       0,     0,     0,     0,   901,     0,     0,     0,     0,   171,
    -386,     0,     0,   902,     0,  1908,     0,     0,     0,     0,
       0,     0,     0,  3805,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -386,     0,
     903,   904,     0,   905,   906,     0,     0,     0,     0,  3820,
       0,     0,   907,     0,     0,     0,  3828,   908,     0,     0,
    3833,     0,   909,   184,   185,   910,     0,     0,   911,   186,
    1184,     0,  1911,  3842,     0,     0,     0,     0,   187,     0,
       0,  -386,     0,     0,     0,     0,     0,     0,     0,     0,
     192,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3874,     0,     0,  3875,     0,     0,     0,     0,
    3042,  3043,  3044,  1908,     0,     0,     0,  3052,     0,  3054,
       0,  3056,  3057,     0,     0,     0,     0,     0,   203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
       0,     0,  1911,  1573,   206,     0,   207,     0,     0,     0,
       0,     0,   208,     0,     0,     0,     0,   209,     0,     0,
       0,   211,     0,     0,     0,     0,   213,     0,     0,     0,
       0,   214,   215,     0,     0,     0,     0,     0,     0,   216,
       0,     0,   218,     0,     0,     0,     0,     0,     0,   221,
       0,  1184,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   223,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3152,     0,     0,     0,     0,     0,   228,     0,
     229,     0,     0,     0,     0,     0,     0,   231,     0,     0,
       0,     0,     0,   232,     0,     0,     0,     0,   233,     0,
    1911,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     236,  1910,     0,     0,  1184,     0,     0,     0,  1184,  3980,
    3981,  3982,     0,     0,     0,     0,     0,  3205,     0,     0,
       0,     0,  1184,  1184,     0,  3214,  3215,  3216,  3217,  3218,
    3219,     0,     0,     0,   246,     0,     0,     0,  -140,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1184,  1184,     0,     0,     0,  1184,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1184,
    1184,  1184,  1184,     0,     0,     0,     0,   828,     0,     0,
       0,     0,  1184,   828,     0,  1184,     0,  1184,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1184,  1184,     0,
       0,  1184,     0,     0,     0,  3299,  2172,     0,     0,  2173,
       0,     0,     0,     0,  1184,     0,  1184,     0,     0,     0,
    1184,     0,     0,     0,     0,     0,  2174,     0,     0,     0,
    2945,     0,     0,  3337,  2176,  3339,  1184,     0,     0,     0,
       0,  2177,     0,     0,     0,     0,     0,  1184,     0,  1184,
    1184,  1184,     0,     0,     0,  1908,     0,     0,     0,     0,
       0,     0,     0,     0,  1910,     0,  2178,     0,   725,     0,
       0,     0,     0,  1184,     0,     0,     0,     0,   725,     0,
       0,     0,     0,     0,     0,  1184,     0,     0,     0,     0,
    1184,     0,     0,  1908,  1908,     0,  1908,  1184,     0,     0,
       0,     0,     0,  1184,     0,     0,     0,     0,     0,     0,
       0,     0,  2946,     0,     0,   725,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   926,     0,     0,   725,
       0,     0,     0,     0,     0,   926,  3392,     0,     0,   725,
       0,     0,     0,     0,     0,     0,  1908,     0,  1908,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   725,
       0,     0,     0,  1184,     0,     0,     0,     0,     0,     0,
    2179,     0,     0,     0,  2180,   926,     0,     0,     0,     0,
       0,     0,  1911,     0,     0,  4190,     0,     0,     0,     0,
       0,     0,     0,  1908,     0,  2181,  2182,     0,     0,     0,
       0,     0,     0,     0,  4216,     0,     0,     0,  1099,     0,
    2183,     0,     0,     0,     0,     0,     0,     0,  1908,     0,
    1911,  1911,     0,  1911,     0,     0,     0,  4227,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2184,     0,     0,
    2185,     0,     0,     0,     0,  1908,     0,     0,     0,     0,
     828,   828,   828,  2186,     0,     0,  2187,     0,  1908,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1911,     0,  1911,     0,  2172,     0,     0,
    2173,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2174,     0,     0,
       0,     0,     0,     0,     0,  2176,     0,     0,     0,     0,
       0,  2172,  2177,     0,  2173,     0,     0,     0,     0,     0,
    1911,     0,     0,  1908,     0,     0,     0,     0,     0,     0,
    1910,  2174,  2188,     0,  1908,     0,     0,  2178,     0,  2176,
       0,     0,     0,     0,     0,  1911,  2177,  1908,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   828,     0,     0,
       0,  2178,  1911,     0,     0,     0,     0,  2442,     0,     0,
       0,  2947,     0,     0,   828,  1911,  4328,  4329,  4330,  4331,
       0,  1148,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1910,  3615,     0,  3616,
    3617,     0,     0,     0,     0,     0,  1908,     0,     0,     0,
    2189,  2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,
       0,     0,     0,     0,     0,  1908,     0,     0,     0,     0,
       0,  2179,     0,     0,     0,  2180,     0,     0,     0,     0,
    1911,     0,     0,  3438,     0,     0,     0,     0,  3439,     0,
    1908,  1911,     0,     0,     0,     0,  2181,  2182,     0,     0,
       0,     0,     0,     0,  1911,  2179,  1910,     0,     0,  2180,
       0,  2183,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1910,  1908,     0,     0,     0,
    2181,  2182,     0,     0,     0,  1184,     0,     0,  2184,     0,
       0,  2185,     0,  1910,     0,  2183,     0,     0,     0,     0,
       0,     0,     0,     0,  2186,     0,     0,  2187,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1184,  1910,  2184,  1911,     0,  2185,     0,  3947,     0,  1184,
       0,     0,     0,     0,     0,  1184,     0,  1184,  2186,     0,
       0,  2187,  1911,  1184,     0,     0,  1184,  1184,  1184,  1184,
    1184,  1184,  1184,  1184,  1184,  1184,     0,     0,     0,  1184,
    1184,     0,     0,     0,     0,     0,     0,  1911,     0,     0,
       0,     0,  1184,     0,     0,     0,  1184,     0,   828,     0,
    1184,     0,  1910,  2188,     0,     0,     0,     0,     0,     0,
    1184,     0,     0,  1184,     0,  1184,  3948,     0,     0,     0,
       0,     0,     0,  1911,  1184,  1184,  1184,     0,     0,     0,
    1184,     0,     0,  1184,     0,     0,     0,  2188,     0,     0,
       0,     0,     0,  1184,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1184,     0,     0,     0,     0,     0,     0,
       0,  1184,     0,  1184,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4508,     0,     0,     0,  1908,
       0,     0,     0,     0,   926,   926,     0,     0,     0,     0,
       0,  2189,  2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,
    2197,  1148,     0,     0,     0,     0,     0,  1184,     0,     0,
       0,     0,     0,  1184,     0,     0,     0,     0,     0,  1184,
       0,     0,     0,     0,     0,  2189,  2190,  2191,     0,  2192,
    2193,  2194,  2195,  2196,  2197,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1184,     0,     0,     0,     0,     0,
       0,     0,  3901,     0,     0,     0,     0,  2172,     0,     0,
    2173,     0,     0,     0,     0,     0,     0,     0,  1045,     0,
       0,     0,     0,     0,     0,     0,  1045,  2174,  1045,     0,
    3402,     0,     0,     0,     0,  2176,     0,     0,     0,     0,
       0,     0,  2177,     0,  1910,     0,     0,     0,     0,     0,
       0,   828,     0,     0,     0,   828,  1911,   828,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2178,     0,     0,
    1194,     0,     0,     0,     0,     0,     0,     0,  1908,  2917,
    1222,     0,  1224,     0,  1226,     0,  1228,     0,     0,     0,
       0,  2172,     0,     0,  2173,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1277,     0,  1908,     0,
       0,  2174,     0,     0,  1286,     0,  4615,     0,     0,  2176,
       0,     0,     0,     0,  1303,  1304,  2177,     0,     0,  1306,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1148,     0,   926,  1573,     0,
       0,  2178,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1335,     0,     0,     0,     0,     0,     0,     0,
       0,  2179,     0,     0,     0,  2180,     0,  1357,     0,  1184,
    1359,     0,  1361,     0,  1364,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2181,  2182,   725,   926,
       0,     0,     0,     0,     0,  1911,     0,     0,     0,     0,
       0,  2183,     0,   725,     0,   725,     0,     0,  1908,     0,
       0,     0,     0,     0,     0,   725,     0,     0,     0,  1908,
    4076,  4077,  4078,  4079,     0,  1911,  1184,  1184,  2184,     0,
       0,  2185,     0,     0,   725,   725,  4705,     0,     0,     0,
       0,  1446,     0,  1447,  2186,  2179,     0,  2187,     0,  2180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2181,  2182,     0,     0,  1148,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2183,  1184,     0,     0,     0,
       0,     0,     0,     0,  3077,     0,     0,     0,     0,  2442,
    3084,     0,     0,     0,     0,     0,     0,     0,  1099,     0,
    1910,     0,  2184,     0,     0,  2185,     0,     0,     0,     0,
       0,     0,  1184,  2188,     0,     0,  1908,     0,  2186,     0,
       0,  2187,  1184,  1184,     0,  1911,     0,     0,     0,     0,
    1184,  1184,     0,     0,     0,  1184,  1911,  1908,     0,     0,
       0,  1184,  1184,     0,     0,  1184,     0,     0,     0,  1908,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1184,     0,     0,     0,  1184,     0,     0,     0,     0,  1702,
       0,  1704,     0,  1184,     0,  1706,  2172,  4208,  1184,  2173,
       0,     0,     0,     0,     0,     0,     0,  1908,     0,     0,
    1184,     0,     0,     0,     0,     0,  2174,  2188,     0,     0,
       0,  2189,  2190,  2191,  2176,  2192,  2193,  2194,  2195,  2196,
    2197,  2177,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3905,     0,     0,     0,     0,     0,  1184,     0,
       0,     0,  1910,     0,     0,  1840,  2178,     0,     0,     0,
       0,     0,     0,  1911,     0,     0,     0,     0,     0,     0,
       0,     0,  1856,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1864,  1911,     0,     0,     0,     0,     0,
    1866,     0,     0,     0,     0,     0,  1911,     0,     0,     0,
       0,     0,     0,     0,  1917,  2189,  2190,  2191,     0,  2192,
    2193,  2194,  2195,  2196,  2197,     0,     0,     0,     0,     0,
       0,     0,  2442,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1911,     0,     0,  4879,  1962,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   828,     0,     0,     0,     0,
    2179,     0,     0,  1908,  2180,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2181,  2182,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1184,     0,
    2183,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     828,     0,     0,     0,     0,     0,     0,     0,     0,  2172,
    1910,   725,  2173,   725,     0,     0,   725,  2184,   725,     0,
    2185,   725,   725,   725,     0,     0,     0,     0,     0,  2174,
       0,     0,     0,  2186,   725,     0,  2187,  2176,     0,     0,
       0,     0,  1180,  1911,  2177,     0,     0,   725,     0,   725,
    1180,     0,     0,  4880,     0,     0,     0,     0,     0,     0,
    1908,     0,     0,     0,     0,     0,     0,     0,     0,  2178,
       0,     0,     0,     0,     0,     0,  1184,     0,     0,     0,
    1911,     0,     0,  1180,     0,  1184,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1184,  1184,     0,     0,  1184,     0,     0,     0,
       0,     0,  2188,     0,     0,     0,     0,  1184,     0,     0,
       0,     0,  1184,     0,     0,  1184,  4422,     0,     0,     0,
    1184,  1184,     0,     0,     0,     0,     0,     0,     0,  1180,
    4425,     0,     0,     0,     0,     0,     0,     0,  1180,     0,
       0,     0,     0,     0,     0,     0,     0,  1908,     0,     0,
       0,     0,     0,  1184,     0,     0,     0,     0,     0,  2917,
    2917,  2917,     0,  2179,     0,     0,     0,  2180,     0,     0,
    1908,     0,     0,     0,     0,     0,     0,  1911,     0,     0,
       0,  1184,     0,     0,     0,     0,     0,     0,  2181,  2182,
    2189,  2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,
    1908,     0,     0,  2183,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1184,  1099,
       0,     0,     0,     0,     0,     0,  4478,     0,     0,     0,
    2184,     0,     0,  2185,     0,     0,  1908,     0,     0,     0,
    1908,  1908,     0,     0,     0,     0,  2186,     0,     0,  2187,
    1180,     0,     0,     0,     0,     0,  1045,     0,     0,     0,
    1045,     0,     0,  3416,     0,     0,     0,     0,     0,     0,
       0,     0,  1184,     0,  1911,     0,  2337,     0,     0,  2337,
       0,     0,     0,     0,  1180,     0,  2172,  2344,     0,  2173,
       0,     0,  1910,     0,     0,     0,  1184,  1911,     0,  1184,
       0,  1184,     0,     0,     0,  2353,  2174,     0,     0,  1900,
       0,     0,     0,     0,  2176,     0,     0,     0,  1184,     0,
       0,  2177,  1184,     0,     0,  2188,     0,  1911,     0,     0,
    2442,  3084,     0,  3084,     0,     0,     0,     0,     0,     0,
    2413,     0,     0,     0,     0,     0,  2178,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1911,     0,     0,     0,  1911,  1911,     0,
       0,     0,     0,     0,     0,  4581,  4583,  4583,     0,     0,
       0,     0,     0,  1910,     0,  1910,     0,     0,  2172,     0,
       0,  2173,     0,     0,   828,     0,     0,     0,     0,     0,
       0,     0,  1184,     0,     0,     0,     0,     0,  2174,     0,
       0,  3446,     0,  2189,  2190,  2191,  2176,  2192,  2193,  2194,
    2195,  2196,  2197,  2177,     0,     0,     0,     0,     0,     0,
    1910,     0,     0,  3451,  1911,     0,  1180,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1180,     0,  2178,     0,
    2179,     0,     0,     0,  2180,  1910,     0,     0,     0,     0,
       0,     0,     0,     0,  1184,     0,     0,     0,     0,     0,
    1909,     0,  1900,     0,     0,  2181,  2182,     0,     0,  1184,
       0,     0,  3084,     0,     0,     0,     0,     0,     0,     0,
    2183,  4658,     0,     0,     0,  3084,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1180,     0,     0,     0,     0,
       0,     0,  1184,     0,     0,     0,     0,  2184,     0,     0,
    2185,     0,     0,     0,     0,  2600,     0,     0,     0,  1184,
       0,     0,     0,  2186,     0,     0,  2187,     0,     0,     0,
       0,  2623,     0,     0,     0,     0,     0,     0,     0,     0,
    1184,  1184,  2179,     0,     0,     0,  2180,     0,     0,     0,
    1910,     0,     0,  1184,     0,     0,     0,     0,     0,     0,
       0,  3084,     0,  4702,  1180,     0,     0,  2181,  2182,     0,
       0,     0,     0,     0,  1910,  2667,     0,     0,     0,  2671,
       0,  4718,  2183,  4720,     0,     0,     0,  2172,     0,  2680,
    2173,  2682,     0,  2683,  1184,     0,     0,     0,  2684,     0,
       0,     0,  2188,     0,  1184,     0,     0,  2174,     0,  2184,
    3457,     0,  2185,     0,     0,  2176,     0,     0,     0,     0,
     828,     0,  2177,  1909,     0,  2186,     0,     0,  2187,     0,
       0,     0,     0,   725,     0,   725,     0,     0,     0,   725,
       0,   725,     0,  1910,   725,     0,     0,  2178,   725,  2715,
       0,  1180,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1910,     0,     0,     0,     0,  1184,     0,     0,
       0,     0,   828,     0,     0,     0,     0,     0,  1184,  1180,
    4583,     0,     0,   828,     0,     0,     0,  1910,     0,     0,
    2189,  2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,
       0,     0,     0,     0,  2188,     0,     0,  1180,  1180,     0,
    1180,     0,     0,     0,     0,     0,     0,     0,     0,  4809,
       0,     0,     0,  1910,     0,     0,     0,  1180,  1900,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2179,     0,     0,     0,  2180,     0,     0,     0,     0,
       0,     0,     0,  2917,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1900,  2181,  2182,  1180,     0,
       0,  4850,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2183,  2189,  2190,  2191,     0,  2192,  2193,  2194,  2195,
    2196,  2197,     0,  2918,  1900,     0,     0,  1180,     0,     0,
       0,  1180,  1180,     0,     0,     0,     0,     0,  2184,     0,
       0,  2185,     0,     0,     0,     0,     0,     0,     0,  4886,
       0,     0,     0,     0,  2186,     0,     0,  2187,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2172,     0,     0,  2173,     0,     0,     0,     0,
       0, -2094,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2174,     0,  1900,  3954,     0,     0,     0,     0,
    2176,     0,     0,     0,     0,     0,     0,  2177,     0,  1909,
       0,     0,     0,  1900,     0,     0,     0,     0,     0,     0,
       0,     0,  1045,     0,     0,     0,  3084,     0,     0, -2094,
       0,  1900,  2178,  2188,     0,     0,     0,     0,     0,     0,
       0, -2094,     0,     0,     0, -2094,     0,     0,     0,  1045,
   -2094,     0,     0,     0,     0, -2094,  1909,  1148, -2094,  1900,
       0, -2094,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3005,  3006,     0,     0,     0,  3009,
    3010,     0,     0,  3013,     0,  1909,     0,     0, -2094,     0,
       0,     0,     0,  3023,     0,     0,  2172,     0,     0,  2173,
    3031,     0,     0,     0,     0,     0,  3036,  3037, -2094,     0,
       0,     0,     0,     0,     0,     0,  2174,  3051,     0,  3053,
    1900,  2189,  2190,  2191,  2176,  2192,  2193,  2194,  2195,  2196,
    2197,  2177,     0,  3073,  1045,     0,  2179,     0,  3075,     0,
    2180,     0,     0,     0,     0,     0, -2094,     0,     0,     0,
       0,     0,     0,     0, -2094,  1909,  2178,     0,     0,     0,
       0,  2181,  2182,     0,  3091,  3092,  3095,  3097,     0,     0,
       0,  3104,  3107,     0,  1909,  1910,  2183,     0,     0,  3118,
       0,     0,  3122,     0,     0,     0,  3126,     0,     0,     0,
       0,     0,  1909,     0,     0,     0,     0,     0,     0,     0,
       0, -2094,     0,  2184,  3150,  2442,  2185,     0,     0,     0,
       0,     0,     0,     0,  3153,     0,  3155,     0,     0,  2186,
    1909,     0,  2187,     0,  3158,  3159,  3160,     0,  3162,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3185,  3186,  3187,     0,     0,     0,  1020,     0,     0,
       0,  3192,  3193,     0,     0,     0,     0,     0,     0,     0,
    2179,     0,     0,     0,  2180,     0,     0,     0,     0,     0,
   -2094,     0,     0,     0,     0,  1180,     0,     0,     0,     0,
       0,  1909,     0,     0,  1180,  2181,  2182,     0,     0,     0,
       0,     0,     0, -2094,     0, -2094, -2094,     0,  2188,     0,
    2183,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3256,     0,  1900,     0,     0,  1910,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1910,  2184, -2094,     0,
    2185, -2094, -2094,     0, -2094,     0,     0,     0,     0,     0,
       0,     0,     0,  2186,     0,     0,  2187,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2917,     0,     0,     0,     0,  2917,     0,
       0,  1180,     0,     0,     0,     0,     0,     0,     0,     0,
    2917,     0,     0,     0,     0,     0,  2189,  2190,  2191,     0,
    2192,  2193,  2194,  2195,  2196,  2197,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1180,  1180,     0,
       0,     0,     0,     0,     0,  1180,     0,     0,  1180,     0,
       0,  1180,  2188,     0,     0,     0,     0,     0,  1148,  1180,
    1180,     0,     0,  1910,     0,     0,  1902,  1180,     0,     0,
    1180,  1180,  1180,  1180,     0,     0,     0,     0,     0,     0,
    1180,  1180,     0,  1180,  1910,  1180,  1180,     0,     0,  1180,
       0,     0,     0,     0,     0,     0,  1910,  3381,     0,     0,
       0,     0,     0,  1909,  1180,     0,     0,     0,     0,  1180,
   -2106,     0,     0,  1180,     0,     0,     0,  1180,     0,  1180,
    1180,  1180,  1180,  1180,  1180,  1180,  1180,  1180,     0,  1180,
       0,     0,     0,     0,  1910,  1180,     0,     0,  1180,     0,
    2189,  2190,  2191,     0,  2192,  2193,  2194,  2195,  2196,  2197,
       0,     0,     0,     0,     0,     0,     0,     0, -2106,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2106,   708,     0,     0, -2106,     0,   722,     0,   722, -2106,
       0,     0,     0,     0, -2106,     0,     0, -2106,   722,     0,
   -2106,     0,     0,     0,     0,     0,     0,     0,     0,  1180,
       0,     0,  1900,     0,     0,     0,     0,  1900,  1900,     0,
       0,     0,     0,     0,   722,     0,     0, -2106,  1900,     0,
       0,     0,     0,     0,     0,   722,     0,     0,     0,  1902,
       0,     0,     0,     0,     0,   722,   722, -2106,     0,   722,
       0,     0,     0,     0,     0,   722,     0,     0,     0,  1008,
       0,     0,     0,  4506,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1008,
       0,     0,     0,     0,     0, -2106,     0,     0,     0,     0,
       0,     0,     0, -2106,     0,   722,     0,     0,     0,     0,
    1910,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1180,     0,     0,     0,     0,  1180,     0,     0,
   -2106,     0,     0,  1180,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3591,  3592,     0,     0,     0,     0,
    1900,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1909,     0,     0,     0,     0,  1909,  1909,
       0,     0,     0,     0,     0,     0,  1020,     0,     0,  1909,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3084,     0, -2106,
    3623,  3625,     0,     0,  3625,     0,     0,     0,  3632,  3633,
    3634,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1900,     0, -2106,     0, -2106, -2106,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3652,  3653,  3654,  3655,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2106,     0,     0,
   -2106, -2106,     0, -2106,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3680,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3084,  1902,     0,     0,     0,     0,
       0,   722,     0,     0,     0,     0,     0,     0,     0,  1180,
       0,  1909,     0,     0,     0,     0,     0,  1910,  1900,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3712,     0,     0,     0,     0,  3714,     0,     0,
       0,     0,  1902,     0,     0,     0,     0,  1910,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1902,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1909,     0,  1910,     0,     0,     0,  1910,  1910,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3801,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3808,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1180,     0,     0,     0,     0,     0,     0,  3827,     0,   926,
       0,  1902,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4506,     0,     0,     0,     0,     0,
    1902,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   926,     0,     0,  3867,     0,  1902,  1909,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3876,
       0,     0,     0,  1180,     0,     0,     0,  1180,     0,     0,
       0,     0,     0,     0,     0,     0,  1902,     0,     0,     0,
       0,  1180,  1180,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1180,  1180,     0,   722,     0,  1180,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1180,  1180,
    1180,  1180,     0,     0,     0,     0,     0,  1902,     0,     0,
       0,  1180,     0,     0,  1180,     0,  1180,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1180,  1180,     0,     0,
    1180,     0,     0,     0,   722,   722,     0,     0,     0,     0,
       0,     0,     0,  1180,     0,  1180,     0,     0,     0,  1180,
    1900,   722,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1180,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1180,     0,  1180,  1180,
    1180,     0,     0,     0,     0,     0,     0,     0,  1900,  1900,
       0,  1900,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1180,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1180,     0,     0,     0,     0,  1180,
       0,     0,     0,     0,     0,     0,  1180,     0,     0,     0,
       0,     0,  1180,     0,     0,     0,     0,     0,     0,     0,
       0,  1900,     0,  1900,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1900,     0,
       0,     0,  1180,     0,     0,     0,  4073,     0,     0,  1902,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1909,     0,  1900,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4094,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1900,     0,     0,     0,  1323,   722,     0,   722,     0,  1909,
    1909,     0,  1909,  1900,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4122,     0,     0,     0,     0,  4129,  4130,     0,  4132,  4133,
    4134,  4135,  4136,  4137,  4138,     0,     0,     0,     0,     0,
       0,     0,     0,  4145,     0,   722,     0,     0,   722,   722,
       0,     0,  1909,     0,  1909,     0,     0,     0,     0,     0,
       0,   708,     0,  1008,     0,  1008,     0,     0,  1900,     0,
       0,   708,     0,     0,     0,   722,     0,     0,     0,  1900,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1900,     0,  1008,  1008,     0,     0,     0,  1909,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4202,  4204,  4206,     0,     0,  4209,
       0,     0,     0,     0,  1909,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   722,     0,   722,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1909,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1900,     0,     0,  1909,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1900,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3625,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1900,     0,     0,     0,  1902,
       0,     0,   708,     0,  1902,  1902,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1902,   708,   708,     0,  1909,
    1684,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1909,  1900,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1909,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   708,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1180,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1180,
       0,     0,  1909,     0,     0,     0,     0,     0,  1180,     0,
       0,     0,     0,     0,  1180,     0,  1180,     0,     0,     0,
       0,  1909,  1180,     0,     0,  1180,  1180,  1180,  1180,  1180,
    1180,  1180,  1180,  1180,  1180,     0,     0,  1902,  1180,  1180,
       0,     0,     0,     0,     0,     0,  1909,     0,     0,     0,
       0,  1180,     0,     0,     0,  1180,     0,     0,     0,  1180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1180,
       0,     0,  1180,     0,  1180,     0,     0,     0,     0,     0,
       0,     0,  1909,  1180,  1180,  1180,     0,     0,     0,  1180,
       0,     0,  1180,     0,  4397,     0,     0,     0,     0,     0,
       0,     0,  1180,     0,  1900,     0,     0,  1902,     0,     0,
       0,     0,  1180,  4408,  4409,     0,     0,     0,     0,     0,
    1180,     0,  1180,     0,     0,  4418,  4419,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   708,     0,     0,     0,
       0,   722,     0,   722,     0,     0,   722,     0,   722,     0,
       0,   722,   722,   722,     0,     0,  1180,  2061,     0,     0,
       0,     0,  1180,     0,   722,     0,     0,     0,  1180,     0,
       0,     0,     0,     0,     0,     0,     0,   722,     0,   722,
       0,     0,     0,     0,   722,     0,     0,     0,     0,     0,
       0,     0,     0,  1180,     0,  1902,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4472,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1900,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4493,  1909,     0,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,  1900,     0,     0,     0,  4516,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2213,     0,     0,  1185,     0,     0,     0,     0,     0,   722,
     722,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   708,     0,     0,     0,
     708,   708,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,   725,
       0,     0,     0,     0,     0,     0,     0,     0,  1180,     0,
       0,     0,     0,  1900,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1900,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1909,     0,     0,     0,     0,     0,
       0,   722,     0,   708,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2341,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1909,  1180,  1180,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4624,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,   708,     0,     0,     0,  1902,     0,   708,
       0,     0,     0,     0,     0,  1180,     0,     0,     0,     0,
       0,  1900,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3625,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,  1900,     0,     0,  1902,  1902,     0,  1902,     0,
       0,  1180,     0,     0,  1900,     0,   708,     0,     0,   708,
     708,  1180,  1180,     0,  1909,     0,     0,     0,     0,  1180,
    1180,     0,     0,     0,  1180,  1909,     0,     0,     0,     0,
    1180,  1180,     0,     0,  1180,     0,     0,     0,     0,     0,
       0,     0,  1900,     0,     0,     0,     0,     0,  1902,  1180,
    1902,     0,     0,  1180,     0,     0,     0,     0,     0,     0,
       0,     0,  1180,     0,     0,     0,     0,  1180,     0,     0,
       0,     0,   708,     0,     0,     0,     0,     0,     0,  1180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1902,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1180,     0,     0,
    1902,     0,     0,     0,  4752,     0,     0,     0,     0,     0,
       0,     0,  1909,     0,     0,     0,  1185,     0,     0,  3625,
       0,     0,     0,     0,     0,     0,  1185,  1902,     0,     0,
       0,     0,     0,  1909,     0,     0,     0,     0,     0,     0,
    1902,     0,     0,     0,     0,  1909,     0,     0,     0,     0,
    1912,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1900,     0,
       0,     0,     0,  1909,     0,  1185,     0,  4808,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1902,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1902,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1902,
       0,     0,     0,   722,     0,   722,     0,  1543,     0,   722,
       0,   722,     0,     0,   722,     0,     0,  1180,   722,     0,
       0,     0,     0,  2213,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4863,
       0,  1613,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1900,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1902,     0,
       0,     0,  1909,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1912,     0,     0,     0,  1902,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1180,     0,     0,     0,  1909,
       0,  1185,  1902,     0,  1180,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1180,  1180,     0,     0,  1180,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,  1180,     0,  1902,     0,
       0,  1180,  1900,     0,  1180,     0,     0,     0,     0,  1180,
    1180,     0,     0,     0,     0,     0,  2061,  1185,  1185,     0,
    1185,     0,     0,  2919,     0,  1900,     0,     0,     0,     0,
       0,     0,  2341,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,  1180,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1900,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1909,     0,     0,     0,
    1180,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,     0,
       0,  1900,     0,     0,   708,  1900,  1900,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1180,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,     0,
       0,  1185,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   708,     0,     0,     0,   708,     0,     0,     0,
       0,     0,  2989,     0,  1684,     0,     0,   722,     0,     0,
       0,  1180,     0,  1909,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1902,     0,     0,     0,  1180,  1909,     0,  1180,     0,
    1180,     0,     0,     0,     0,     0,     0,     0,     0,  1912,
       0,     0,     0,     0,     0,     0,     0,  1180,     0,     0,
       0,  1180,     0,     0,     0,     0,  1909,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1912,     0,     0,     0,
       0,     0,  1909,     0,     0,     0,  1909,  1909,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2113,     0,
       0,     0,     0,     0,     0,  1912,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1180,     0,     0,     0,     0,  2136,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   708,     0,     0,
       0,     0,     0,     0,     0,   708,     0,   708,     0,     0,
       0,     0,     0,  1909,  2161,  2162,     0,  2164,     0,     0,
    1902,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2203,  1912,     0,     0,     0,     0,
       0,     0,     0,  1180,     0,     0,     0,     0,     0,     0,
    1902,     0,     0,     0,  1912,     0,     0,     0,  1180,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1912,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2256,     0,     0,     0,     0,
       0,  1180,     0,     0,     0,     0,     0,     0,     0,     0,
    1912,     0,     0,     0,     0,     0,     0,     0,  1180,     0,
       0,     0,     0,     0,  2278,     0,     0,     0,  2288,  2291,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1180,
    1180,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1180,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1185,     0,     0,     0,     0,
    1902,  1912,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,  1902,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1180,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1180,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   722,  2061,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   708,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,  1180,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1180,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1902,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,  1185,     0,
       0,     0,     0,     0,     0,  1185,     0,     0,  1185,  1902,
       0,  1185,     0,     0,     0,     0,     0,     0,     0,  1185,
    1185,  1902,     0,     0,     0,     0,     0,  1185,     0,     0,
    1185,  1185,  1185,  1185,     0,     0,     0,     0,     0,     0,
    1185,  1185,     0,  1185,     0,  1185,  1185,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1902,
       0,     0,     0,  1912,  1185,     0,     0,     0,     0,  1185,
       0,     0,     0,  1185,     0,     0,     0,  1185,     0,  1185,
    1185,  1185,  1185,  1185,  1185,  1185,  1185,  1185,     0,  1185,
       0,     0,     0,     0,     0,  1185,     0,     0,  1185,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     4,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2341,     0,     0,     0,     0,
     708,     0,     5,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     6,     7,     0,     0,     0,     0,     8,  1185,
       9,    10,     0,     0,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,     0,
      36,     0,    37,    38,    39,    40,    41,    42,    43,    44,
       0,     0,     0,    45,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1902,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2785,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1902,  1912,     0,     0,    47,     0,  1912,  1912,
       0,     0,     0,     0,  2807,     0,     0,  2809,     0,  1912,
    2820,     0,    48,     0,     0,     0,     0,  2827,  2832,     0,
       0,     0,     0,  2838,     0,     0,  2843,     0,     0,     0,
       0,     0,     0,    49,     0,     0,     0,     0,     0,     0,
       0,  2852,     0,     0,     0,     0,  2859,     0,     0,     0,
    2871,     0,     0,     0,  2878,    50,  2880,  2881,  2882,  2883,
    2884,  2885,  2886,  2887,  2888,     0,  2889,     0,     0,     0,
       0,     0,  1543,     0,     0,  2914,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    51,  1902,
       0,     0,    52,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    53,     0,
       0,     0,  1902,   708,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   708,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1613,     0,     0,  1185,
       0,  1912,  1902,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1902,   722,
       0,     0,  1902,  1902,     0,    54,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1912,     0,   722,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    55,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    56,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    57,     0,     0,     0,     0,  3034,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   708,     0,     0,     0,     0,     0,     0,     0,
      58,     0,     0,     0,     0,     0,    59,     0,     0,     0,
      60,    61,    62,    63,    64,     0,     0,    65,    66,    67,
      68,     0,    69,    70,    71,    72,    73,     0,     0,  1912,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1185,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,  1185,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,  1185,
    1185,  1185,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,  1185,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,  1185,     0,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1185,     0,  1185,     0,     0,  2199,  1185,
       0,     0,     0,     0,     0,     0,  3232,     0,     0,     0,
       0,     0,     0,     0,     0,  1185,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2989,  1185,     0,  1185,  1185,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1185,     0,     0,     0,  2199,  1185,
       0,     0,     0,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   708,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   708,     0,     0,     0,  3352,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1912,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   708,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1912,
    1912,     0,  1912,     0,     0,     0,     0,     0,     0,  3398,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1912,     0,  1912,  2832,     0,  2832,  2832,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3460,     0,
       0,  3463,     0,  3465,     0,     0,     0,     0,  1903,     0,
       0,     0,     0,     0,     0,  1905,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1912,
    3486,     0,  3488,     0,     0,     0,  3491,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1912,     0,     0,     0,   708,     0,
       0,     0,     0,     0,     0,  2914,  2914,  2914,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1912,     0,     0,     0,     0,     0,     0,     0,  3548,
       0,     0,     0,     0,  1912,     0,     0,     0,     0,     0,
       0,  2278,     0,     0,     0,     0,  3559,     0,     0,     0,
       0,     0,     0,  2291,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1912,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1912,  1903,     0,     0,     0,     0,     0,     0,  1905,  3600,
       0,     0,     0,  1912,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2341,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2199,
       0,     0,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,   708,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,     0,  1912,     0,     0,     0,     0,     0,  1185,     0,
       0,     0,   708,     0,  1185,     0,  1185,     0,     0,     0,
    1906,  1912,  1185,     0,     0,  1185,  1185,  1185,  1185,  1185,
    1185,  1185,  1185,  1185,  1185,     0,     0,     0,  1185,  1185,
       0,     0,     0,     0,     0,     0,  1912,     0,  2199,     0,
       0,  1185,     0,     0,     0,  1185,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,  2199,  1185,     0,  1185,     0,  2816,     0,     0,     0,
       0,     0,  1912,  1185,  1185,  1185,     0,     0,     0,  1185,
       0,     0,  1185,     0,     0,     0,  2199,  2199,     0,  2199,
       0,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,   708,     0,     0,     0,     0,     0,     0,
    1185,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2199,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,     0,     0,  1185,     0,
       0,     0,     0,  1906,     0,     0,     0,  1903,     0,     0,
       0,  2199,     0,     0,  1905,     0,     0,     0,     0,     0,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2199,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2199,     0,     0,  2199,     0,     0,     0,
       0,     0,     0,     0,  1903,     0,     0,     0,     0,     0,
       0,  1905,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1903,     0,  1912,     0,     0,     0,     0,
    1905,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   722,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3906,     0,     0,     0,
       0,     0,     0,     0,     0,  3909,     0,     0,     0,     0,
       0,  3910,     0,  3911,     0,     0,     0,     0,   708,     0,
       0,     0,     0,  1903,     0,     0,     0,     0,     0,     0,
    1905,     0,     0,     0,     0,  3929,  3930,     0,     0,     0,
       0,     0,  1903,     0,     0,     0,     0,     0,     0,  1905,
       0,     0,     0,     0,     0,     0,  2838,     0,     0,     0,
    1903,     0,     0,     0,     0,     0,  3958,  1905,     0,  3961,
       0,  3963,     0,     0,     0,     0,     0,     0,  1185,     0,
    3967,     0,     0,     0,     0,     0,  3972,     0,  1903,  3975,
       0,     0,     0,     0,     0,  1905,     0,     0,     0,     0,
       0,     0,     0,     0,  1912,     0,     0,     0,     0,  4004,
       0,     0,     0,     0,     0,     0,     0,  4016,     0,  2914,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1912,  1185,  1185,     0,     0,  1906,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1903,
       0,     0,     0,     0,     0,     0,  1905,     0,     0,     0,
       0,     0,     0,  4033,     0,     0,     0,     0,     0,  1543,
       0,     0,     0,     0,     0,  1613,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1906,     0,     0,     0,
       0,     0,     0,     0,     0,  1185,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1906,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,  1907,     0,     0,     0,
       0,  1185,  1185,     0,  1912,     0,     0,     0,     0,  1185,
    1185,     0,     0,     0,  1185,  1912,     0,     0,     0,     0,
    1185,  1185,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,     0,   708,  1185,     0,  1906,     0,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,     0,  1906,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1906,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1903,     0,     0,     0,     0,     0,  1185,  1905,     0,
    1906,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1912,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1912,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1912,     0,     0,     0,  1907,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2199,  1906,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2199,  1912,  2199,     0,  2816,  2816,  3434,     0,
       0,  2816,  4259,  4260,     0,  2199,     0,     0,     0,     0,
       0,     0,  2199,     0,     0,     0,     0,  2199,     0,     0,
       0,     0,     0,  2199,     0,     0,     0,     0,  2199,     0,
       0,     0,     0,     0,     0,     0,     0,  2199,     0,     0,
       0,  2816,  2816,     0,  2199,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2199,  1185,     0,     0,
       0,     0,  4291,  2199,     0,  2199,  2199,  2199,  2199,  2199,
    2199,  2199,  2199,  2199,  2199,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2199,
       0,     0,     0,     0,     0,     0,     0,     0,  4309,  4311,
       0,     0,  1912,     0,     0,     0,     0,     0,     0,     0,
       0,  4318,     0,     0,     0,     0,     0,  4323,  4324,     0,
       0,  4326,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1185,     0,     0,     0,  1912,
       0,     0,     0,     0,  1185,     0,     0,     0,     0,  2914,
       0,  1903,     0,  1906,  2914,     0,  1903,  1903,  1905,     0,
       0,  1185,  1185,  1905,  1905,  1185,  2914,  1903,     0,     0,
       0,     0,     0,     0,  1905,     0,  1185,     0,     0,     0,
       0,  1185,     0,     0,  1185,     0,     0,     0,     0,  1185,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4380,     0,     0,     0,     0,  2199,
       0,     0,     0,     0,     0,  1907,     0,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1912,     0,     0,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1907,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,     0,
       0,  1907,     0,     0,     0,     0,     0,     0,     0,  1903,
       0,     0,     0,     0,     0,     0,  1905,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,     0,  1912,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4459,     0,     0,     0,     0,     0,
       0,  1907,     0,     0,     0,  1185,  1912,     0,  1185,  1903,
    1185,     0,     0,     0,     0,     0,  1905,     0,     0,     0,
    1907,     0,     0,     0,     0,     0,     0,  1185,     0,     0,
       0,  1185,     0,     0,     0,     0,  1912,     0,  1907,     0,
       0,     0,     0,     0,     0,     0,     0,  2199,     0,     0,
       0,     0,     0,  1906,     0,     0,     0,     0,  1906,  1906,
       0,     0,     0,     0,     0,     0,  1907,     0,     0,  1906,
       0,     0,  1912,     0,     0,     0,  1912,  1912,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1903,     0,     0,
       0,  1185,  4542,     0,  1905,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1907,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4559,     0,     0,
       0,     0,     0,  1912,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2199,     0,     0,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1906,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2199,     0,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3434,  3434,     0,  2816,  1185,     0,
    2816,  2816,  2816,  2816,  2816,  2816,  2816,  2816,  2816,  2816,
    3434,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1906,  1185,     0,     0,  2199,     0,     0,  2199,     0,
    2199,     0,     0,     0,     0,  3434,  3434,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2816,
    2816,  2199,     0,  2199,     0,     0,  2199,     0,     0,     0,
       0,     0,     0,  1185,     0,  2838,     0,     0,     0,  1907,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4683,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2199,     0,     0,     0,     0,     0,  1906,
       0,     0,     0,     0,  2199,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,  1903,
       0,     0,     0,     0,     0,     0,  1905,     0,     0,     0,
       0,     0,     4,     0,     0,  2199,     0,     0,  4740,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     5,     0,     0,     0,     0,  1903,  1903,     0,
    1903,     0,     6,     7,  1905,  1905,     0,  1905,     0,     0,
       9,    10,     0,     0,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,     0,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1903,     0,  1903,    45,     0,  4791,     0,  1905,     0,  1905,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1903,     0,     0,
       0,     0,    46,     0,  1905,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1903,     0,     0,     0,  4836,  4836,     0,  1905,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1907,
       0,     0,     0,     0,  1907,  1907,     0,     0,     0,  1903,
       0,     0,     0,     0,     0,  1907,  1905,     0,     0,     0,
       0,     0,  1903,  2816,     0,     0,     0,     0,     0,  1905,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
    4836,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4883,     0,    48,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    49,     0,     0,     0,     0,     0,     0,
       0,  1906,     0,     0,     0,     0,     0,  1903,     0,     0,
       0,     0,     0,     0,  1905,    50,     0,     0,  1903,     0,
       0,     0,     0,     0,     0,  1905,     0,     0,     0,     0,
       0,  1903,     0,  4836,     0,     0,     0,     0,  1905,  1906,
    1906,     0,  1906,     0,     0,     0,     0,     0,    51,     0,
       0,     0,    52,     0,     0,     0,     0,     0,     0,     0,
       0,  2199,     0,     0,  2199,  2199,  2199,  1907,    53,  3434,
       0,     0,     0,     0,  3434,  3434,  3434,  3434,  3434,  3434,
    3434,  3434,  3434,  3434,  2199,  2199,     0,     0,     0,     0,
       0,     0,  1906,     0,  1906,     0,     0,     0,     0,     0,
    1903,     0,     0,     0,     0,     0,     0,  1905,     0,     0,
       0,     0,     0,  2199,  2816,  2816,  2199,     0,  2199,  1903,
       0,     0,  2199,  3434,  3434,     0,  1905,  2199,     0,     0,
    2199,     0,     0,     0,     0,     0,     0,  1907,     0,  1906,
       0,     0,     0,     0,  1903,    54,     0,     0,     0,     0,
       0,  1905,     0,     0,     0,     0,     0,     0,     0,  2199,
       0,     0,     0,     0,  1906,     0,     0,     0,     0,     0,
       0,  2199,     0,     0,     0,     0,     0,     0,     0,     0,
    1903,     0,     0,     0,     0,     0,    55,  1905,  2199,     0,
       0,  1906,     0,     0,     0,     0,     0,     0,     0,    56,
       0,     0,     0,     0,  1906,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    57,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1907,     0,     0,     0,     0,
      58,     0,     0,     0,     0,     0,    59,     0,     0,     0,
      60,    61,    62,    63,    64,     0,     0,    65,    66,  1372,
    2016,     0,     0,     0,    71,     0,     0,     0,     0,  1906,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1906,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1906,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1906,  1903,     0,  3434,     0,     0,     0,     0,
    1905,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1906,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1906,     0,     0,     0,
       0,     0,     0,     0,  2199,  2199,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1906,     0,     0,     0,  2199,     0,     0,     0,
    2816,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2199,     0,  2199,     0,     0,     0,
       0,  3434,  3434,  2199,     0,     0,  2816,  2816,  2199,  2199,
       0,  2199,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1903,     0,     0,     0,     0,     0,     0,  1905,
       0,     0,     0,     0,     0,     0,     0,  1907,     0,     0,
       0,     0,     0,     0,     0,  2199,     0,     0,     0,     0,
       0,     0,  1903,     0,     0,     0,     0,     0,     0,  1905,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1907,  1907,     0,  1907,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2199,     0,     0,     0,  1907,     0,
    1907,     0,     0,     0,     0,  1906,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1903,     0,     0,     0,     0,     0,     0,  1905,
       0,     0,     0,  1903,     0,  1907,     0,     0,     0,     0,
    1905,     0,     0,     0,     0,     0,     0,     0,     0,  3434,
    2816,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1907,     0,     0,     0,     0,  3434,  3434,  2199,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2199,     0,     0,  1907,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1907,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1903,     0,     0,     0,  1906,     0,     0,  1905,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1903,     0,     0,     0,  1907,     0,     0,  1905,     0,
       0,     0,     0,  1903,  1906,     0,  1907,     0,     0,     0,
    1905,     0,     0,     0,     0,     0,     0,     0,     0,  1907,
       0,     0,     0,     0,     0,     0,     0,     0,  3434,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2199,     0,
       0,  1903,     0,     0,     0,     0,     0,     0,  1905,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1907,     0,
       0,     0,     0,     0,     0,  2199,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1907,     0,     0,
       0,     0,     0,     0,  1906,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1906,     0,     0,     0,     0,
       0,     0,  1907,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2199,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1907,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2199,     0,     0,     0,     0,     0,  1903,     0,     0,
       0,     0,     0,     0,  1905,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1906,     0,     0,     0,     0,     0,  2199,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1906,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1906,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1906,  1903,     0,     0,     0,     0,     0,
       0,  1905,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1907,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1903,     0,     0,     0,     0,     0,     0,  1905,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1903,     0,     0,     0,     0,     0,
       0,  1905,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1903,     0,     0,     0,     0,  1906,
       0,  1905,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1903,     0,     0,     0,  1903,  1903,     0,  1905,     0,     0,
    1907,  1905,  1905,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    86,    87,
      88,     0,    90,    91,    92,     0,     0,     0,    95,     0,
    1907,    98,    99,   100,   101,   102,   103,     0,   104,   105,
       0,     0,     0,   107,   108,   109,   110,     0,   111,   112,
     113,   114,   115,     0,   116,   117,   118,     0,     0,     0,
       0,     0,   121,   122,     0,     0,  1906,     0,   123,     0,
       0,     0,     0,     0,     0,     0,     0,   124,     0,   125,
       0,   126,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,     0,
       0,     0,   135,   136,   137,   138,   139,     0,     0,     0,
    1907,     0,     0,     0,     0,     0,     0,     0,   140,     0,
       0,  1907,     0,     0,     0,     0,   145,     0,     0,     0,
       0,     0,     0,  1906,   148,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   151,     0,     0,     0,
       0,     0,   152,     0,     0,     0,  1906,     0,     0,     0,
       0,     0,   155,   156,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1906,     0,     0,     0,
       0,   162,     0,     0,     0,     0,     0,     0,   164,     0,
       0,     0,   166,     0,     0,     0,     0,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   172,  1906,     0,     0,     0,  1906,  1906,  1907,     0,
       0,   173,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   174,   175,     0,     0,     0,  1907,
       0,   176,     0,   177,     0,     0,   178,   179,     0,   180,
       0,  1907,     0,     0,     0,     0,     0,     0,   181,   182,
       0,   183,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   188,   189,   190,     0,     0,     0,   191,     0,  1907,
       0,   193,     0,     0,   194,     0,   195,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   196,
     197,   198,   199,   200,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   204,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   210,     0,
       0,     0,     0,   212,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     217,     0,     0,   219,     0,   220,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   224,
     225,     0,     0,     0,   226,     0,   227,     0,     0,     0,
       0,     0,     0,     0,   230,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   234,
       0,     0,   235,     0,     0,  1907,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   237,   238,   239,   240,
     241,   242,   243,   244,   245,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2979,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1907,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1907,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   731,
      86,    87,    88,   420,    90,    91,    92,   421,     0,   422,
      95,     0,  1907,    98,    99,   100,   101,   102,   103,   732,
     104,   105,   423,   733,     0,   107,   108,   109,   110,   734,
     735,   112,   113,   114,   115,     0,   116,   736,   737,   424,
     425,     0,  1907,     0,   426,   427,     0,     0,     0,     0,
     428,     0,     0,     0,     0,     0,     0,     0,     0,   429,
       0,   430,     0,   431,   432,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,  1907,     0,
       0,     0,  1907,  1907,     0,   434,   435,   436,   437,   438,
     439,   440,   441,   738,   442,   443,   444,   739,   740,   741,
     742,   743,   744,   745,   445,   446,   746,   447,   448,   133,
     449,   450,   451,   452,   135,   136,   137,   138,   139,   747,
     453,   454,   455,   456,   457,   748,   749,   458,   459,   750,
     140,   461,   751,   462,   463,   464,   465,   466,   145,   752,
     467,   753,   468,   469,   470,   471,   148,   472,   754,   755,
     474,   475,   476,   477,   478,   479,   480,   756,   151,   481,
     757,   758,   759,   760,   152,   761,   762,   763,   482,   483,
     484,   485,   486,   487,   155,   156,   488,   764,   489,   765,
     490,   491,   492,   493,   494,   766,   495,   496,   497,   498,
     767,   499,   768,   500,   501,   502,   503,   504,   769,   505,
     506,   507,   770,   508,   509,   771,   510,   511,   512,   513,
     164,   514,   515,   516,   166,   772,   517,   773,   518,   168,
     519,   774,   520,   775,   521,   169,   776,   170,   522,   523,
     524,   777,   525,   172,   778,   526,   527,   779,   528,   529,
     530,   531,   532,   173,   533,   534,   535,   780,   536,   537,
     538,   539,   540,   541,   781,   542,   174,   175,   782,   543,
     544,   545,   783,   176,   784,   177,   785,   546,   178,   179,
     547,   180,   548,   549,   550,   551,   552,   553,   554,   786,
     181,   182,   555,   183,   787,   556,   557,   558,   788,   789,
     559,   560,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   188,   189,   190,   572,   573,   574,   191,
     790,   575,   576,   193,   577,   791,   194,   578,   195,   579,
     580,   581,   792,   582,   793,   794,   583,   584,   585,   795,
     796,   196,   197,   198,   199,   200,   586,   587,   588,   589,
     590,   591,   592,   797,   593,   201,   594,   202,   595,   596,
     597,   598,   798,   599,   600,   601,   602,   603,   604,   605,
     204,   606,   607,   608,   609,   799,   610,   611,   612,   613,
     614,   615,   616,   617,   618,   619,   620,   800,   621,   622,
     210,   623,   624,   625,   626,   212,   627,   628,   629,   630,
     631,   632,   633,   634,   801,   635,   636,   637,   638,   639,
     802,   640,   217,   641,   642,   219,   643,   220,   803,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   222,
     804,   654,   655,   805,   656,   657,   658,   659,   660,   661,
     806,   224,   225,   807,   808,   663,   226,   664,   227,   809,
     665,   666,   667,   668,   669,   670,   810,   811,   671,   672,
     673,   674,   675,   812,   813,   676,   677,   678,   679,   680,
     814,   234,   815,   682,   235,   683,   684,   685,   816,   817,
     686,   818,   819,   687,   688,   689,   690,   691,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   692,   693,   694,
      85,     0,     0,    86,    87,    88,    89,    90,    91,    92,
      93,     0,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   969,   104,   105,   106,     0,     0,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115,     0,   116,
     117,   118,   119,   120,     0,     0,     0,   121,   122,     0,
       0,     0,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,   124,     0,   125,     0,   126,   127,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   129,     0,
     130,   131,     0,     0,     0,     0,     0,     0,     0,     0,
     132,     0,   133,     0,     0,     0,   134,   135,   136,   137,
     138,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   140,     0,     0,   141,     0,   142,   143,
     144,   145,     0,     0,     0,   146,     0,   147,     0,   148,
       0,     0,     0,     0,     0,     0,     0,     0,   149,     0,
     150,   151,     0,     0,     0,     0,     0,   152,     0,     0,
       0,     0,     0,     0,   153,     0,   154,   155,   156,   157,
       0,     0,     0,     0,     0, -1354,     0,     0,     0,     0,
       0,     0,   158,     0,     0,   159,     0,     0,     0,   160,
       0,     0,     0,     0,     0,   161,   162,     0,     0,     0,
       0,     0,   163,   164,   165,     0,     0,   166,     0,     0,
     167,     0,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,   171,     0,   172,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   173,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   174,
     175,     0,     0, -1354,     0,     0,   176,     0,   177,     0,
       0,   178,   179,     0,   180,     0,     0,     0,     0,     0,
       0,     0,     0,   181,   182,     0,   183,     0,   184,   185,
       0,     0,     0,     0,   186,     0,     0,     0,     0,     0,
       0,     0,     0,   187,     0,     0,   188,   189,   190,     0,
       0,     0,   191,     0,     0,   192,   193,     0,     0,   194,
       0,   195,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   196,   197,   198,   199,   200,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   201,     0,
     202,     0,     0,   203,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   204,   205,     0,     0,     0,     0,   206,
       0,   207,     0,     0,     0,     0,     0,   208,     0,     0,
       0,     0,   209,   210,     0,     0,   211,     0,   212,     0,
       0,   213,     0,     0,     0,     0,   214,   215,     0,     0,
       0,     0,     0,     0,   216,   217,     0,   218,   219,     0,
     220,     0,     0,     0,   221,     0,     0,     0,     0,     0,
       0,     0,   222,     0,     0,     0,   223,     0,     0,     0,
       0,     0,     0,     0,   224,   225,     0,     0,     0,   226,
       0,   227,     0,   228,     0,   229,     0,     0,     0,   230,
       0,     0,   231,     0,     0, -1354,     0,     0,   232,     0,
       0,     0,     0,   233,   234,     0,     0,   235,     0,     0,
       0,     0,     0,     0,     0,   236,     0,     0,     0,     0,
       0,   237,   238,   239,   240,   241,   242,   243,   244,   245,
      86,    87,    88,     0,    90,    91,    92,     0,     0,     0,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   246,
     104,   105,     0,  -140,     0,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   115,     0,   116,   117,   118,     0,
       0,     0,     0,     0,   121,   122,     0,     0,     0,     0,
     123,     0,     0,     0,     0,     0,     0,     0,     0,   124,
       0,   125,     0,   126,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   133,
       0,     0,     0,     0,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,     0,     0,     0,     0,     0,   145,     0,
       0,     0,     0,     0,     0,     0,   148,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,     0,   152,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,   156,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   162,     0,     0,     0,     0,     0,     0,
     164,     0,     0,     0,   166,     0,     0,     0,     0,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   172,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   173,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   174,   175,     0,     0,
       0,     0,     0,   176,     0,   177,     0,     0,   178,   179,
       0,   180,     0,     0,     0,     0,     0,     0,     0,     0,
     181,   182,     0,   183,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,     0,   191,
       0,     0,     0,   193,     0,     0,   194,     0,   195,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   196,   197,   198,   199,   200,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     204,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     210,     0,     0,     0,     0,   212,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   217,     0,     0,   219,     0,   220,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   222,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   224,   225,     0,     0,     0,   226,     0,   227,     0,
       0,     0,     0,     0,     0,     0,   230,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   234,     0,     0,   235,     0,     0,     0,     0,     0,
       0,     0,     4,     0,     0,     0,     0,     0,   237,   238,
     239,   240,   241,   242,   243,   244,   245,     0,     0,     0,
       0,     0,     5,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     6,     7,     0,     0,     0,     0,     0,     0,
       9,    10,     0,  2981,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,     0,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
       0,     0,     0,    45,     0,     0,     0,     0,     0,     0,
       0,     4,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     6,     7,     0,     0,     0,     0,     0,     0,     9,
      10,     0,    46,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    46,    48,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    49,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    50,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,    51,     0,
       0,     0,    52,     0,     0,     0,     0,     0,     0,     0,
       0,    48,     0,     0,     0,     0,     0,     0,    53,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    51,     0,     0,
       0,    52,     0,     0,     0,    54,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    53,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    55,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    56,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    57,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    54,     0,     0,     0,     0,     0,
      58,     0,     0,     0,     0,     0,    59,     0,     0,     0,
      60,    61,    62,    63,    64,     0,     0,    65,    66,  1372,
    2693,     0,     0,     0,    71,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    55,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    56,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    57,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    58,
       0,     0,     0,     0,     0,    59,     0,     0,     0,    60,
      61,    62,    63,    64,     0,     0,    65,    66,  1372,     0,
       0,     0,     0,    71,   731,    86,    87,    88,   420,    90,
      91,    92,   421,     0,   422,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   732,   104,   105,   423,   733,     0,
     107,   108,   109,   110,   734,   735,   112,   113,   114,   115,
       0,   116,   736,   737,   424,   425,     0,     0,     0,   426,
     427,     0,     0,     0,     0,   428,     0,     0,     0,     0,
       0,     0,     0,     0,   429,     0,   430,     0,   431,   432,
      35,   433,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1463,  1464,  1465,    45,  1466,     0,     0,     0,
     434,   435,   436,   437,   438,   439,   440,   441,  2908,   442,
     443,   444,     0,     0,     0,     0,  1467,     0,     0,   445,
     446,     0,   447,   448,   133,   449,   450,   451,   452,   135,
    1468,   137,  1469,  1470,     0,   453,   454,   455,   456,   457,
    1471,  1472,   458,   459,  1473,  1474,   461,     0,   462,   463,
     464,   465,   466,  1475,     0,   467,     0,   468,   469,   470,
     471,   148,   472,   473,     0,   474,   475,   476,   477,   478,
     479,   480,     0,   151,   481,     0,  1476,  1477,  1478,  1479,
    1480,  1481,  1482,   482,   483,   484,   485,   486,   487,  1483,
    1484,   488,     0,   489,     0,   490,   491,   492,   493,   494,
       0,   495,   496,   497,   498,  2909,   499,     0,   500,   501,
    1485,   503,   504,     0,   505,   506,   507,     0,   508,   509,
       0,   510,   511,   512,   513,  1486,   514,   515,   516,  1487,
    1488,   517,     0,   518,  1489,   519,     0,   520,     0,   521,
     169,     0,   170,   522,   523,   524,     0,   525,  1490,     0,
     526,   527,     0,   528,   529,   530,   531,   532,   173,   533,
     534,   535,     0,   536,   537,   538,   539,   540,   541,     0,
     542,   174,   175,     0,   543,   544,   545,  1491,  1492,     0,
    1493,     0,   546,   178,   179,   547,   180,   548,   549,   550,
     551,   552,   553,   554,     0,  1494,   182,   555,   183,     0,
     556,   557,   558,  1495,  1496,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,  1497,   189,
    1498,   572,   573,   574,   191,  1499,   575,   576,   193,   577,
    1500,  1501,   578,  1502,   579,   580,   581,     0,   582,     0,
       0,  1503,   584,   585,     0,     0,   196,   197,   198,   199,
    1504,   586,   587,   588,   589,   590,   591,   592,     0,   593,
    1505,   594,   202,   595,   596,   597,   598,     0,   599,   600,
     601,   602,   603,   604,   605,  1506,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,   615,   616,   617,   618,
     619,   620,     0,   621,   622,   210,   623,   624,   625,   626,
    1507,   627,   628,   629,   630,   631,   632,   633,   634,     0,
     635,   636,   637,   638,   639,  1508,   640,   217,   641,   642,
     219,   643,  1509,     0,   644,   645,   646,   647,   648,   649,
     650,   651,   652,   653,  1510,     0,   654,   655,     0,   656,
     657,   658,   659,   660,   661,     0,  1511,  1512,     0,     0,
     663,  1513,   664,  1514,  1515,   665,   666,   667,   668,   669,
     670,     0,  1516,   671,   672,   673,   674,   675,  1517,     0,
     676,   677,   678,   679,   680,   681,  1518,  2910,   682,   235,
     683,   684,   685,     0,     0,   686,     0,     0,   687,   688,
     689,   690,   691,   237,  1519,  1520,  1521,  1522,  1523,  1524,
    1525,  1526,   692,   693,   694,     0,     0,     0,     0,     0,
       0,     0,  1527,  1528,  2911,     0,     0,     0,     0,     0,
       0,  1530,  2912,   731,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   732,   104,   105,   423,   733,     0,   107,
     108,   109,   110,   734,   735,   112,   113,   114,   115,     0,
     116,   736,   737,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1463,  1464,  1465,    45,  1466,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,  1467,     0,     0,   445,   446,
       0,   447,   448,   133,   449,   450,   451,   452,   135,  1468,
     137,  1469,  1470,     0,   453,   454,   455,   456,   457,  1471,
    1472,   458,   459,  1473,  1474,   461,     0,   462,   463,   464,
     465,   466,  1475,     0,   467,     0,   468,   469,   470,   471,
     148,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,   151,   481,     0,  1476,  1477,  1478,  1479,  1480,
    1481,  1482,   482,   483,   484,   485,   486,   487,  1483,  1484,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,  1485,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,  1486,   514,   515,   516,  1487,  1488,
     517,     0,   518,  1489,   519,     0,   520,     0,   521,   169,
       0,   170,   522,   523,   524,     0,   525,  1490,     0,   526,
     527,     0,   528,   529,   530,   531,   532,   173,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
     174,   175,     0,   543,   544,   545,  1491,  1492,     0,  1493,
       0,   546,   178,   179,   547,   180,   548,   549,   550,   551,
     552,   553,   554,     0,  1494,   182,   555,   183,     0,   556,
     557,   558,  1495,  1496,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,  1497,   189,  1498,
     572,   573,   574,   191,  1499,   575,   576,   193,   577,  1500,
    1501,   578,  1502,   579,   580,   581,     0,   582,     0,     0,
    1503,   584,   585,     0,     0,   196,   197,   198,   199,  1504,
     586,   587,   588,   589,   590,   591,   592,     0,   593,  1505,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,  1506,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,   210,   623,   624,   625,   626,  1507,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,  1508,   640,   217,   641,   642,   219,
     643,  1509,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,  1510,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,  1511,  1512,     0,     0,   663,
    1513,   664,  1514,  1515,   665,   666,   667,   668,   669,   670,
       0,  1516,   671,   672,   673,   674,   675,  1517,     0,   676,
     677,   678,   679,   680,   681,  1518,     0,   682,   235,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,  1519,  1520,  1521,  1522,  1523,  1524,  1525,
    1526,   692,   693,   694,     0,     0,     0,     0,     0,     0,
       0,  1527,  1528,     0,     0,     0,     0,     0,     0,     0,
    1530,  2818,   731,    86,    87,    88,   420,    90,    91,    92,
     421,     0,   422,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   732,   104,   105,   423,   733,     0,   107,   108,
     109,   110,   734,   735,   112,   113,   114,   115,     0,   116,
     736,   737,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   434,   435,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
       0,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,   448,   133,   449,   450,   451,   452,     0,  1878,   137,
    1879,  1880,     0,   453,   454,   455,   456,   457,     0,     0,
     458,   459,  1881,  1882,   461,     0,   462,   463,   464,   465,
     466,     0,     0,   467,     0,   468,   469,   470,   471,   148,
     472,   473,     0,   474,   475,   476,   477,   478,   479,   480,
       0,   151,   481,     0,     0,     0,     0,   152,     0,     0,
       0,   482,   483,   484,   485,   486,   487,  1883,  1884,   488,
       0,   489,     0,   490,   491,   492,   493,   494,     0,   495,
     496,   497,   498,     0,   499,     0,   500,   501,  1485,   503,
     504,     0,   505,   506,   507,     0,   508,   509,     0,   510,
     511,   512,   513,     0,   514,   515,   516,     0,     0,   517,
       0,   518,  1885,   519,     0,   520,     0,   521,   169,     0,
     170,   522,   523,   524,     0,   525,     0,     0,   526,   527,
       0,   528,   529,   530,   531,   532,   173,   533,   534,   535,
    2430,   536,   537,   538,   539,   540,   541,     0,   542,   174,
    2431,     0,   543,   544,   545,  1491,  1886,     0,  1887,     0,
     546,   178,   179,   547,   180,   548,   549,   550,   551,   552,
     553,   554,     0,     0,   182,   555,   183,     0,   556,   557,
     558,     0,     0,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,  1888,   189,  1889,   572,
     573,   574,     0,     0,   575,   576,   193,   577,     0,     0,
     578,  1890,   579,   580,   581,     0,   582,     0,     0,   583,
     584,   585,     0,     0,  2432,   197,   198,   199,     0,   586,
     587,   588,   589,   590,   591,   592,     0,   593,     0,   594,
       0,   595,   596,   597,   598,     0,   599,   600,   601,   602,
     603,   604,   605,  1891,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
       0,   621,   622,   210,   623,   624,   625,   626,     0,   627,
     628,   629,   630,   631,   632,   633,   634,     0,   635,   636,
     637,   638,   639,     0,   640,  2433,   641,   642,   219,   643,
    1893,     0,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,     0,     0,   654,   655,     0,   656,   657,   658,
     659,   660,   661,     0,  1894,  1895,     0,     0,   663,     0,
     664,     0,     0,   665,   666,   667,   668,   669,   670,     0,
       0,   671,   672,   673,   674,   675,     0,     0,   676,   677,
     678,   679,   680,     0,  1896,  2434,   682,   235,   683,   684,
     685,     0,     0,   686,     0,     0,   687,   688,   689,   690,
     691,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     692,   693,   694,     0,     0,     0,     0,   731,    86,    87,
      88,   420,    90,    91,    92,   421,     0,   422,    95,     0,
    2435,    98,    99,   100,   101,   102,   103,   732,   104,   105,
     423,   733,     0,   107,   108,   109,   110,   734,   735,   112,
     113,   114,   115,     0,   116,   736,   737,   424,   425,     0,
       0,     0,   426,   427,     0,     0,     0,     0,   428,     0,
       0,     0,     0,     0,     0,     0,     0,   429,     0,   430,
       0,   431,   432,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   434,   435,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,     0,     0,     0,     0,     0,
       0,     0,   445,   446,     0,   447,   448,   133,   449,   450,
     451,   452,     0,  1878,   137,  1879,  1880,     0,   453,   454,
     455,   456,   457,     0,     0,   458,   459,  1881,  1882,   461,
       0,   462,   463,   464,   465,   466,     0,     0,   467,     0,
     468,   469,   470,   471,   148,   472,   473,     0,   474,   475,
     476,   477,   478,   479,   480,     0,   151,   481,     0,     0,
       0,     0,   152,     0,     0,     0,   482,   483,   484,   485,
     486,   487,  1883,  1884,   488,     0,   489,     0,   490,   491,
     492,   493,   494,     0,   495,   496,   497,   498,     0,   499,
       0,   500,   501,  1485,   503,   504,     0,   505,   506,   507,
       0,   508,   509,     0,   510,   511,   512,   513,     0,   514,
     515,   516,     0,     0,   517,     0,   518,  1885,   519,     0,
     520,     0,   521,   169,     0,   170,   522,   523,   524,     0,
     525,     0,     0,   526,   527,     0,   528,   529,   530,   531,
     532,   173,   533,   534,   535,  2430,   536,   537,   538,   539,
     540,   541,     0,   542,   174,  2431,     0,   543,   544,   545,
    1491,  1886,     0,  1887,     0,   546,   178,   179,   547,   180,
     548,   549,   550,   551,   552,   553,   554,     0,     0,   182,
     555,   183,     0,   556,   557,   558,     0,     0,   559,   560,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,  1888,   189,  1889,   572,   573,   574,     0,     0,   575,
     576,   193,   577,     0,     0,   578,  1890,   579,   580,   581,
       0,   582,     0,     0,   583,   584,   585,     0,     0,  2432,
     197,   198,   199,     0,   586,   587,   588,   589,   590,   591,
     592,     0,   593,     0,   594,     0,   595,   596,   597,   598,
       0,   599,   600,   601,   602,   603,   604,   605,  1891,   606,
     607,   608,   609,     0,   610,   611,   612,   613,   614,   615,
     616,   617,   618,   619,   620,     0,   621,   622,   210,   623,
     624,   625,   626,     0,   627,   628,   629,   630,   631,   632,
     633,   634,     0,   635,   636,   637,   638,   639,     0,   640,
    2433,   641,   642,   219,   643,  1893,     0,   644,   645,   646,
     647,   648,   649,   650,   651,   652,   653,     0,     0,   654,
     655,     0,   656,   657,   658,   659,   660,   661,     0,  1894,
    1895,     0,     0,   663,     0,   664,     0,     0,   665,   666,
     667,   668,   669,   670,     0,     0,   671,   672,   673,   674,
     675,     0,     0,   676,   677,   678,   679,   680,     0,  1896,
    2434,   682,   235,   683,   684,   685,     0,     0,   686,     0,
       0,   687,   688,   689,   690,   691,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   692,   693,   694,     0,     0,
       0,     0,   731,    86,    87,    88,   420,    90,    91,    92,
     421,     0,   422,    95,     0,  3314,    98,    99,   100,   101,
     102,   103,   732,   104,   105,   423,   733,     0,   107,   108,
     109,   110,   734,   735,   112,   113,   114,   115,     0,   116,
     736,   737,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,   433,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1463,  1464,  1465,    45,  1466,     0,     0,     0,   434,   435,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
       0,     0,     0,     0,  1467,     0,     0,   445,   446,     0,
     447,   448,   133,   449,   450,   451,   452,   135,  1468,   137,
    1469,  1470,  2828,   453,   454,   455,   456,   457,  1471,  1472,
     458,   459,  1473,  1474,   461,     0,   462,   463,   464,   465,
     466,  1475,     0,   467,     0,   468,   469,   470,   471,   148,
     472,   473,     0,   474,   475,   476,   477,   478,   479,   480,
       0,   151,   481,     0,  1476,  1477,  1478,  1479,  1480,  1481,
    1482,   482,   483,   484,   485,   486,   487,  1483,  1484,   488,
       0,   489,     0,   490,   491,   492,   493,   494,     0,   495,
     496,   497,   498,     0,   499,     0,   500,   501,  1485,   503,
     504,     0,   505,   506,   507,     0,   508,   509,     0,   510,
     511,   512,   513,  1486,   514,   515,   516,  1487,  1488,   517,
       0,   518,  1489,   519,     0,   520,     0,   521,   169,  2829,
     170,   522,   523,   524,     0,   525,  1490,     0,   526,   527,
       0,   528,   529,   530,   531,   532,   173,   533,   534,   535,
       0,   536,   537,   538,   539,   540,   541,     0,   542,   174,
     175,     0,   543,   544,   545,  1491,  1492,     0,  1493,     0,
     546,   178,   179,   547,   180,   548,   549,   550,   551,   552,
     553,   554,  2830,  1494,   182,   555,   183,     0,   556,   557,
     558,  1495,  1496,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,  1497,   189,  1498,   572,
     573,   574,   191,  1499,   575,   576,   193,   577,  1500,  1501,
     578,  1502,   579,   580,   581,     0,   582,     0,     0,  1503,
     584,   585,     0,     0,   196,   197,   198,   199,  1504,   586,
     587,   588,   589,   590,   591,   592,     0,   593,  1505,   594,
     202,   595,   596,   597,   598,     0,   599,   600,   601,   602,
     603,   604,   605,  1506,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
       0,   621,   622,   210,   623,   624,   625,   626,  1507,   627,
     628,   629,   630,   631,   632,   633,   634,     0,   635,   636,
     637,   638,   639,  1508,   640,   217,   641,   642,   219,   643,
    1509,     0,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,  1510,     0,   654,   655,     0,   656,   657,   658,
     659,   660,   661,     0,  1511,  1512,     0,  2831,   663,  1513,
     664,  1514,  1515,   665,   666,   667,   668,   669,   670,     0,
    1516,   671,   672,   673,   674,   675,  1517,     0,   676,   677,
     678,   679,   680,   681,  1518,     0,   682,   235,   683,   684,
     685,     0,     0,   686,     0,     0,   687,   688,   689,   690,
     691,   237,  1519,  1520,  1521,  1522,  1523,  1524,  1525,  1526,
     692,   693,   694,     0,     0,     0,     0,     0,     0,     0,
    1527,  1528,     0,     0,     0,     0,     0,     0,     0,  1530,
     731,    86,    87,    88,   420,    90,    91,    92,   421,     0,
     422,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     732,   104,   105,   423,   733,     0,   107,   108,   109,   110,
     734,   735,   112,   113,   114,   115,     0,   116,   736,   737,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,   433,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1463,  1464,
    1465,    45,  1466,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,     0,     0,
       0,     0,  1467,     0,     0,   445,   446,     0,   447,   448,
     133,   449,   450,   451,   452,   135,  1468,   137,  1469,  1470,
       0,   453,   454,   455,   456,   457,  1471,  1472,   458,   459,
    1473,  1474,   461,     0,   462,   463,   464,   465,   466,  1475,
       0,   467,     0,   468,   469,   470,   471,   148,   472,   473,
       0,   474,   475,   476,   477,   478,   479,   480,     0,   151,
     481,     0,  1476,  1477,  1478,  1479,  1480,  1481,  1482,   482,
     483,   484,   485,   486,   487,  1483,  1484,   488,     0,   489,
       0,   490,   491,   492,   493,   494,     0,   495,   496,   497,
     498,     0,   499,     0,   500,   501,  1485,   503,   504,     0,
     505,   506,   507,     0,   508,   509,     0,   510,   511,   512,
     513,  1486,   514,   515,   516,  1487,  1488,   517,     0,   518,
    1489,   519,     0,   520,     0,   521,   169,     0,   170,   522,
     523,   524,     0,   525,  1490,     0,   526,   527,     0,   528,
     529,   530,   531,   532,   173,   533,   534,   535,     0,   536,
     537,   538,   539,   540,   541,     0,   542,   174,   175,     0,
     543,   544,   545,  1491,  1492,     0,  1493,     0,   546,   178,
     179,   547,   180,   548,   549,   550,   551,   552,   553,   554,
       0,  1494,   182,   555,   183,     0,   556,   557,   558,  1495,
    1496,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,  1497,   189,  1498,   572,   573,   574,
     191,  1499,   575,   576,   193,   577,  1500,  1501,   578,  1502,
     579,   580,   581,     0,   582,     0,     0,  1503,   584,   585,
       0,     0,   196,   197,   198,   199,  1504,   586,   587,   588,
     589,   590,   591,   592,     0,   593,  1505,   594,   202,   595,
     596,   597,   598,     0,   599,   600,   601,   602,   603,   604,
     605,  1506,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,     0,   621,
     622,   210,   623,   624,   625,   626,  1507,   627,   628,   629,
     630,   631,   632,   633,   634,   215,   635,   636,   637,   638,
     639,  1508,   640,   217,   641,   642,   219,   643,  1509,     0,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
    1510,     0,   654,   655,   223,   656,   657,   658,   659,   660,
     661,     0,  1511,  1512,     0,     0,   663,  1513,   664,  1514,
    1515,   665,   666,   667,   668,   669,   670,     0,  1516,   671,
     672,   673,   674,   675,  1517,     0,   676,   677,   678,   679,
     680,  1389,  1518,     0,   682,   235,   683,   684,   685,     0,
       0,   686,     0,   236,   687,   688,   689,   690,   691,   237,
    1519,  1520,  1521,  1522,  1523,  1524,  1525,  1526,   692,   693,
     694,     0,     0,     0,     0,     0,     0,     0,  1527,  1528,
       0,     0,     0,     0,     0,     0,     0,  1530,   731,    86,
      87,    88,   420,    90,    91,    92,   421,     0,   422,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   732,   104,
     105,   423,   733,     0,   107,   108,   109,   110,   734,   735,
     112,   113,   114,   115,     0,   116,   736,   737,   424,   425,
       0,     0,     0,   426,   427,     0,     0,     0,     0,   428,
       0,     0,     0,     0,     0,     0,     0,     0,   429,     0,
     430,     0,   431,   432,    35,   433,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1463,  1464,  1465,    45,
    1466,     0,     0,     0,   434,   435,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,     0,     0,     0,     0,
    1467,     0,     0,   445,   446,     0,   447,   448,   133,   449,
     450,   451,   452,   135,  1468,   137,  1469,  1470,     0,   453,
     454,   455,   456,   457,  1471,  1472,   458,   459,  1473,  1474,
     461,     0,   462,   463,   464,   465,   466,  1475,     0,   467,
       0,   468,   469,   470,   471,   148,   472,   473,     0,   474,
     475,   476,   477,   478,   479,   480,     0,   151,   481,     0,
    1476,  1477,  1478,  1479,  1480,  1481,  1482,   482,   483,   484,
     485,   486,   487,  1483,  1484,   488,     0,   489,     0,   490,
     491,   492,   493,   494,     0,   495,   496,   497,   498,     0,
     499,     0,   500,   501,  1485,   503,   504,     0,   505,   506,
     507,     0,   508,   509,     0,   510,   511,   512,   513,  1486,
     514,   515,   516,  1487,  1488,   517,     0,   518,  1489,   519,
       0,   520,     0,   521,   169,     0,   170,   522,   523,   524,
       0,   525,  1490,     0,   526,   527,     0,   528,   529,   530,
     531,   532,   173,   533,   534,   535,     0,   536,   537,   538,
     539,   540,   541,     0,   542,   174,   175,     0,   543,   544,
     545,  1491,  1492,     0,  1493,     0,   546,   178,   179,   547,
     180,   548,   549,   550,   551,   552,   553,   554,     0,  1494,
     182,   555,   183,     0,   556,   557,   558,  1495,  1496,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,  1497,   189,  1498,   572,   573,   574,   191,  1499,
     575,   576,   193,   577,  1500,  1501,   578,  1502,   579,   580,
     581,     0,   582,     0,     0,  1503,   584,   585,     0,     0,
     196,   197,   198,   199,  1504,   586,   587,   588,   589,   590,
     591,   592,     0,   593,  1505,   594,   202,   595,   596,   597,
     598,     0,   599,   600,   601,   602,   603,   604,   605,  1506,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,     0,   621,   622,   210,
     623,   624,   625,   626,  1507,   627,   628,   629,   630,   631,
     632,   633,   634,     0,   635,   636,   637,   638,   639,  1508,
     640,   217,   641,   642,   219,   643,  1509,     0,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,  1510,     0,
     654,   655,     0,   656,   657,   658,   659,   660,   661,     0,
    1511,  1512,     0,     0,   663,  1513,   664,  1514,  1515,   665,
     666,   667,   668,   669,   670,     0,  1516,   671,   672,   673,
     674,   675,  1517,     0,   676,   677,   678,   679,   680,   681,
    1518,     0,   682,   235,   683,   684,   685,     0,     0,   686,
       0,     0,   687,   688,   689,   690,   691,   237,  1519,  1520,
    1521,  1522,  1523,  1524,  1525,  1526,   692,   693,   694,     0,
       0,     0,     0,     0,     0,     0,  1527,  1528,     0,     0,
       0,     0,     0,  2108,  2777,  1530,   731,    86,    87,    88,
     420,    90,    91,    92,   421,     0,   422,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   732,   104,   105,   423,
     733,     0,   107,   108,   109,   110,   734,   735,   112,   113,
     114,   115,     0,   116,   736,   737,   424,   425,     0,     0,
       0,   426,   427,     0,     0,     0,     0,   428,     0,     0,
       0,     0,     0,     0,     0,     0,   429,     0,   430,     0,
     431,   432,    35,   433,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1463,  1464,  1465,    45,  1466,     0,
       0,     0,   434,   435,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,     0,     0,     0,     0,  1467,     0,
       0,   445,   446,     0,   447,   448,   133,   449,   450,   451,
     452,   135,  1468,   137,  1469,  1470,     0,   453,   454,   455,
     456,   457,  1471,  1472,   458,   459,  1473,  1474,   461,     0,
     462,   463,   464,   465,   466,  1475,     0,   467,     0,   468,
     469,   470,   471,   148,   472,   473,     0,   474,   475,   476,
     477,   478,   479,   480,     0,   151,   481,     0,  1476,  1477,
    1478,  1479,  1480,  1481,  1482,   482,   483,   484,   485,   486,
     487,  1483,  1484,   488,     0,   489,     0,   490,   491,   492,
     493,   494,     0,   495,   496,   497,   498,     0,   499,     0,
     500,   501,  1485,   503,   504,     0,   505,   506,   507,     0,
     508,   509,     0,   510,   511,   512,   513,  1486,   514,   515,
     516,  1487,  1488,   517,     0,   518,  1489,   519,     0,   520,
       0,   521,   169,     0,   170,   522,   523,   524,     0,   525,
    1490,     0,   526,   527,     0,   528,   529,   530,   531,   532,
     173,   533,   534,   535,     0,   536,   537,   538,   539,   540,
     541,     0,   542,   174,   175,     0,   543,   544,   545,  1491,
    1492,     0,  1493,     0,   546,   178,   179,   547,   180,   548,
     549,   550,   551,   552,   553,   554,     0,  1494,   182,   555,
     183,     0,   556,   557,   558,  1495,  1496,   559,   560,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
    1497,   189,  1498,   572,   573,   574,   191,  1499,   575,   576,
     193,   577,  1500,  1501,   578,  1502,   579,   580,   581,     0,
     582,     0,     0,  1503,   584,   585,     0,     0,   196,   197,
     198,   199,  1504,   586,   587,   588,   589,   590,   591,   592,
       0,   593,  1505,   594,   202,   595,   596,   597,   598,     0,
     599,   600,   601,   602,   603,   604,   605,  1506,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,   615,   616,
     617,   618,   619,   620,     0,   621,   622,   210,   623,   624,
     625,   626,  1507,   627,   628,   629,   630,   631,   632,   633,
     634,     0,   635,   636,   637,   638,   639,  1508,   640,   217,
     641,   642,   219,   643,  1509,     0,   644,   645,   646,   647,
     648,   649,   650,   651,   652,   653,  1510,     0,   654,   655,
       0,   656,   657,   658,   659,   660,   661,     0,  1511,  1512,
       0,     0,   663,  1513,   664,  1514,  1515,   665,   666,   667,
     668,   669,   670,     0,  1516,   671,   672,   673,   674,   675,
    1517,     0,   676,   677,   678,   679,   680,   681,  1518,     0,
     682,   235,   683,   684,   685,     0,     0,   686,     0,     0,
     687,   688,   689,   690,   691,   237,  1519,  1520,  1521,  1522,
    1523,  1524,  1525,  1526,   692,   693,   694,     0,     0,     0,
       0,     0,     0,     0,  1527,  1528,  1529,     0,     0,     0,
       0,     0,     0,  1530,   731,    86,    87,    88,   420,    90,
      91,    92,   421,     0,   422,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   732,   104,   105,   423,   733,     0,
     107,   108,   109,   110,   734,   735,   112,   113,   114,   115,
       0,   116,   736,   737,   424,   425,     0,     0,     0,   426,
     427,     0,     0,     0,     0,   428,     0,     0,     0,     0,
       0,     0,     0,     0,   429,     0,   430,     0,   431,   432,
      35,   433,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1463,  1464,  1465,    45,  1466,     0,     0,     0,
     434,   435,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,     0,     0,     0,     0,  1467,     0,     0,   445,
     446,     0,   447,   448,   133,   449,   450,   451,   452,   135,
    1468,   137,  1469,  1470,     0,   453,   454,   455,   456,   457,
    1471,  1472,   458,   459,  1473,  1474,   461,     0,   462,   463,
     464,   465,   466,  1475,     0,   467,     0,   468,   469,   470,
     471,   148,   472,   473,     0,   474,   475,   476,   477,   478,
     479,   480,     0,   151,   481,     0,  1476,  1477,  1478,  1479,
    1480,  1481,  1482,   482,   483,   484,   485,   486,   487,  1483,
    1484,   488,  1612,   489,     0,   490,   491,   492,   493,   494,
       0,   495,   496,   497,   498,     0,   499,     0,   500,   501,
    1485,   503,   504,     0,   505,   506,   507,     0,   508,   509,
       0,   510,   511,   512,   513,  1486,   514,   515,   516,  1487,
    1488,   517,     0,   518,  1489,   519,     0,   520,     0,   521,
     169,     0,   170,   522,   523,   524,     0,   525,  1490,     0,
     526,   527,     0,   528,   529,   530,   531,   532,   173,   533,
     534,   535,     0,   536,   537,   538,   539,   540,   541,     0,
     542,   174,   175,     0,   543,   544,   545,  1491,  1492,     0,
    1493,     0,   546,   178,   179,   547,   180,   548,   549,   550,
     551,   552,   553,   554,     0,  1494,   182,   555,   183,     0,
     556,   557,   558,  1495,  1496,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,  1497,   189,
    1498,   572,   573,   574,   191,  1499,   575,   576,   193,   577,
    1500,  1501,   578,  1502,   579,   580,   581,     0,   582,     0,
       0,  1503,   584,   585,     0,     0,   196,   197,   198,   199,
    1504,   586,   587,   588,   589,   590,   591,   592,     0,   593,
    1505,   594,   202,   595,   596,   597,   598,     0,   599,   600,
     601,   602,   603,   604,   605,  1506,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,   615,   616,   617,   618,
     619,   620,     0,   621,   622,   210,   623,   624,   625,   626,
    1507,   627,   628,   629,   630,   631,   632,   633,   634,     0,
     635,   636,   637,   638,   639,  1508,   640,   217,   641,   642,
     219,   643,  1509,     0,   644,   645,   646,   647,   648,   649,
     650,   651,   652,   653,  1510,     0,   654,   655,     0,   656,
     657,   658,   659,   660,   661,     0,  1511,  1512,     0,     0,
     663,  1513,   664,  1514,  1515,   665,   666,   667,   668,   669,
     670,     0,  1516,   671,   672,   673,   674,   675,  1517,     0,
     676,   677,   678,   679,   680,   681,  1518,     0,   682,   235,
     683,   684,   685,     0,     0,   686,     0,     0,   687,   688,
     689,   690,   691,   237,  1519,  1520,  1521,  1522,  1523,  1524,
    1525,  1526,   692,   693,   694,     0,     0,     0,     0,     0,
       0,     0,  1527,  1528,     0,     0,     0,     0,     0,     0,
       0,  1530,   731,    86,    87,    88,   420,    90,    91,    92,
     421,     0,   422,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   732,   104,   105,   423,   733,     0,   107,   108,
     109,   110,   734,   735,   112,   113,   114,   115,     0,   116,
     736,   737,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,   433,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1463,  1464,  1465,    45,  1466,     0,     0,     0,   434,   435,
     436,   437,   438,   439,   440,   441,  2286,   442,   443,   444,
       0,     0,     0,     0,  1467,     0,     0,   445,   446,     0,
     447,   448,   133,   449,   450,   451,   452,   135,  1468,   137,
    1469,  1470,     0,   453,   454,   455,   456,   457,  1471,  1472,
     458,   459,  1473,  1474,   461,     0,   462,   463,   464,   465,
     466,  1475,     0,   467,     0,   468,   469,   470,   471,   148,
     472,   473,     0,   474,   475,   476,   477,   478,   479,   480,
       0,   151,   481,     0,  1476,  1477,  1478,  1479,  1480,  1481,
    1482,   482,   483,   484,   485,   486,   487,  1483,  1484,   488,
       0,   489,     0,   490,   491,   492,   493,   494,     0,   495,
     496,   497,   498,     0,   499,     0,   500,   501,  1485,   503,
     504,     0,   505,   506,   507,     0,   508,   509,     0,   510,
     511,   512,   513,  1486,   514,   515,   516,  1487,  1488,   517,
       0,   518,  1489,   519,     0,   520,     0,   521,   169,     0,
     170,   522,   523,   524,     0,   525,  1490,     0,   526,   527,
       0,   528,   529,   530,   531,   532,   173,   533,   534,   535,
       0,   536,   537,   538,   539,   540,   541,     0,   542,   174,
     175,     0,   543,   544,   545,  1491,  1492,     0,  1493,     0,
     546,   178,   179,   547,   180,   548,   549,   550,   551,   552,
     553,   554,     0,  1494,   182,   555,   183,     0,   556,   557,
     558,  1495,  1496,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,  1497,   189,  1498,   572,
     573,   574,   191,  1499,   575,   576,   193,   577,  1500,  1501,
     578,  1502,   579,   580,   581,     0,   582,     0,     0,  1503,
     584,   585,     0,     0,   196,   197,   198,   199,  1504,   586,
     587,   588,   589,   590,   591,   592,     0,   593,  1505,   594,
     202,   595,   596,   597,   598,     0,   599,   600,   601,   602,
     603,   604,   605,  1506,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
       0,   621,   622,   210,   623,   624,   625,   626,  1507,   627,
     628,   629,   630,   631,   632,   633,   634,     0,   635,   636,
     637,   638,   639,  1508,   640,   217,   641,   642,   219,   643,
    1509,     0,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,  1510,     0,   654,   655,     0,   656,   657,   658,
     659,   660,   661,     0,  1511,  1512,     0,     0,   663,  1513,
     664,  1514,  1515,   665,   666,   667,   668,   669,   670,     0,
    1516,   671,   672,   673,   674,   675,  1517,     0,   676,   677,
     678,   679,   680,   681,  1518,     0,   682,   235,   683,   684,
     685,     0,     0,   686,     0,     0,   687,   688,   689,   690,
     691,   237,  1519,  1520,  1521,  1522,  1523,  1524,  1525,  1526,
     692,   693,   694,     0,     0,     0,     0,     0,     0,     0,
    1527,  1528,     0,     0,     0,     0,     0,     0,     0,  1530,
     731,    86,    87,    88,   420,    90,    91,    92,   421,     0,
     422,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     732,   104,   105,   423,   733,     0,   107,   108,   109,   110,
     734,   735,   112,   113,   114,   115,     0,   116,   736,   737,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,   433,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1463,  1464,
    1465,    45,  1466,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,     0,     0,
       0,     0,  1467,     0,     0,   445,   446,     0,   447,   448,
     133,   449,   450,   451,   452,   135,  1468,   137,  1469,  1470,
       0,   453,   454,   455,   456,   457,  1471,  1472,   458,   459,
    1473,  1474,   461,     0,   462,   463,   464,   465,   466,  1475,
       0,   467,     0,   468,   469,   470,   471,   148,   472,   473,
       0,   474,   475,   476,   477,   478,   479,   480,     0,   151,
     481,     0,  1476,  1477,  1478,  1479,  1480,  1481,  1482,   482,
     483,   484,   485,   486,   487,  1483,  1484,   488,     0,   489,
       0,   490,   491,   492,   493,   494,     0,   495,   496,   497,
     498,     0,   499,     0,   500,   501,  1485,   503,   504,     0,
     505,   506,   507,     0,   508,   509,     0,   510,   511,   512,
     513,  1486,   514,   515,   516,  1487,  1488,   517,     0,   518,
    1489,   519,     0,   520,     0,   521,   169,  2829,   170,   522,
     523,   524,     0,   525,  1490,     0,   526,   527,     0,   528,
     529,   530,   531,   532,   173,   533,   534,   535,     0,   536,
     537,   538,   539,   540,   541,     0,   542,   174,   175,     0,
     543,   544,   545,  1491,  1492,     0,  1493,     0,   546,   178,
     179,   547,   180,   548,   549,   550,   551,   552,   553,   554,
       0,  1494,   182,   555,   183,     0,   556,   557,   558,  1495,
    1496,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,  1497,   189,  1498,   572,   573,   574,
     191,  1499,   575,   576,   193,   577,  1500,  1501,   578,  1502,
     579,   580,   581,     0,   582,     0,     0,  1503,   584,   585,
       0,     0,   196,   197,   198,   199,  1504,   586,   587,   588,
     589,   590,   591,   592,     0,   593,  1505,   594,   202,   595,
     596,   597,   598,     0,   599,   600,   601,   602,   603,   604,
     605,  1506,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,     0,   621,
     622,   210,   623,   624,   625,   626,  1507,   627,   628,   629,
     630,   631,   632,   633,   634,     0,   635,   636,   637,   638,
     639,  1508,   640,   217,   641,   642,   219,   643,  1509,     0,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
    1510,     0,   654,   655,     0,   656,   657,   658,   659,   660,
     661,     0,  1511,  1512,     0,     0,   663,  1513,   664,  1514,
    1515,   665,   666,   667,   668,   669,   670,     0,  1516,   671,
     672,   673,   674,   675,  1517,     0,   676,   677,   678,   679,
     680,   681,  1518,     0,   682,   235,   683,   684,   685,     0,
       0,   686,     0,     0,   687,   688,   689,   690,   691,   237,
    1519,  1520,  1521,  1522,  1523,  1524,  1525,  1526,   692,   693,
     694,     0,     0,     0,     0,     0,     0,     0,  1527,  1528,
       0,     0,     0,     0,     0,     0,     0,  1530,   731,    86,
      87,    88,   420,    90,    91,    92,   421,     0,   422,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   732,   104,
     105,   423,   733,     0,   107,   108,   109,   110,   734,   735,
     112,   113,   114,   115,     0,   116,   736,   737,   424,   425,
       0,     0,     0,   426,   427,     0,     0,     0,     0,   428,
       0,     0,     0,     0,     0,     0,     0,     0,   429,     0,
     430,     0,   431,   432,    35,   433,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1463,  1464,  1465,    45,
    1466,     0,     0,     0,   434,   435,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,     0,     0,     0,     0,
    1467,     0,     0,   445,   446,     0,   447,   448,   133,   449,
     450,   451,   452,   135,  1468,   137,  1469,  1470,     0,   453,
     454,   455,   456,   457,  1471,  1472,   458,   459,  1473,  1474,
     461,     0,   462,   463,   464,   465,   466,  1475,     0,   467,
       0,   468,   469,   470,   471,   148,   472,   473,     0,   474,
     475,   476,   477,   478,   479,   480,     0,   151,   481,     0,
    1476,  1477,  1478,  1479,  1480,  1481,  1482,   482,   483,   484,
     485,   486,   487,  1483,  1484,   488,     0,   489,     0,   490,
     491,   492,   493,   494,     0,   495,   496,   497,   498,     0,
     499,     0,   500,   501,  1485,   503,   504,     0,   505,   506,
     507,     0,   508,   509,     0,   510,   511,   512,   513,  1486,
     514,   515,   516,  1487,  1488,   517,     0,   518,  1489,   519,
       0,   520,     0,   521,   169,     0,   170,   522,   523,   524,
       0,   525,  1490,     0,   526,   527,     0,   528,   529,   530,
     531,   532,   173,   533,   534,   535,     0,   536,   537,   538,
     539,   540,   541,     0,   542,   174,   175,     0,   543,   544,
     545,  1491,  1492,     0,  1493,     0,   546,   178,   179,   547,
     180,   548,   549,   550,   551,   552,   553,   554,     0,  1494,
     182,   555,   183,     0,   556,   557,   558,  1495,  1496,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,  1497,   189,  1498,   572,   573,   574,   191,  1499,
     575,   576,   193,   577,  1500,  1501,   578,  1502,   579,   580,
     581,     0,   582,     0,     0,  1503,   584,   585,     0,     0,
     196,   197,   198,   199,  1504,   586,   587,   588,   589,   590,
     591,   592,     0,   593,  1505,   594,   202,   595,   596,   597,
     598,     0,   599,   600,   601,   602,   603,   604,   605,  1506,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,     0,   621,   622,   210,
     623,   624,   625,   626,  1507,   627,   628,   629,   630,   631,
     632,   633,   634,     0,   635,   636,   637,   638,   639,  1508,
     640,   217,   641,   642,   219,   643,  1509,     0,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,  1510,     0,
     654,   655,     0,   656,   657,   658,   659,   660,   661,     0,
    1511,  1512,     0,     0,   663,  1513,   664,  1514,  1515,   665,
     666,   667,   668,   669,   670,     0,  1516,   671,   672,   673,
     674,   675,  1517,     0,   676,   677,   678,   679,   680,   681,
    1518,  4019,   682,   235,   683,   684,   685,     0,     0,   686,
       0,     0,   687,   688,   689,   690,   691,   237,  1519,  1520,
    1521,  1522,  1523,  1524,  1525,  1526,   692,   693,   694,     0,
       0,     0,     0,     0,     0,     0,  1527,  1528,     0,     0,
       0,     0,     0,     0,     0,  1530,   731,    86,    87,    88,
     420,    90,    91,    92,   421,     0,   422,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   732,   104,   105,   423,
     733,     0,   107,   108,   109,   110,   734,   735,   112,   113,
     114,   115,     0,   116,   736,   737,   424,   425,     0,     0,
       0,   426,   427,     0,     0,     0,     0,   428,     0,     0,
       0,     0,     0,     0,     0,     0,   429,     0,   430,     0,
     431,   432,    35,   433,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1463,  1464,  1465,    45,  1466,     0,
       0,     0,   434,   435,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,     0,     0,     0,     0,  1467,     0,
       0,   445,   446,     0,   447,   448,   133,   449,   450,   451,
     452,   135,  1468,   137,  1469,  1470,     0,   453,   454,   455,
     456,   457,  1471,  1472,   458,   459,  1473,  1474,   461,     0,
     462,   463,   464,   465,   466,  1475,     0,   467,     0,   468,
     469,   470,   471,   148,   472,   473,     0,   474,   475,   476,
     477,   478,   479,   480,     0,   151,   481,  4032,  1476,  1477,
    1478,  1479,  1480,  1481,  1482,   482,   483,   484,   485,   486,
     487,  1483,  1484,   488,     0,   489,     0,   490,   491,   492,
     493,   494,     0,   495,   496,   497,   498,     0,   499,     0,
     500,   501,  1485,   503,   504,     0,   505,   506,   507,     0,
     508,   509,     0,   510,   511,   512,   513,  1486,   514,   515,
     516,  1487,  1488,   517,     0,   518,  1489,   519,     0,   520,
       0,   521,   169,     0,   170,   522,   523,   524,     0,   525,
    1490,     0,   526,   527,     0,   528,   529,   530,   531,   532,
     173,   533,   534,   535,     0,   536,   537,   538,   539,   540,
     541,     0,   542,   174,   175,     0,   543,   544,   545,  1491,
    1492,     0,  1493,     0,   546,   178,   179,   547,   180,   548,
     549,   550,   551,   552,   553,   554,     0,  1494,   182,   555,
     183,     0,   556,   557,   558,  1495,  1496,   559,   560,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
    1497,   189,  1498,   572,   573,   574,   191,  1499,   575,   576,
     193,   577,  1500,  1501,   578,  1502,   579,   580,   581,     0,
     582,     0,     0,  1503,   584,   585,     0,     0,   196,   197,
     198,   199,  1504,   586,   587,   588,   589,   590,   591,   592,
       0,   593,  1505,   594,   202,   595,   596,   597,   598,     0,
     599,   600,   601,   602,   603,   604,   605,  1506,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,   615,   616,
     617,   618,   619,   620,     0,   621,   622,   210,   623,   624,
     625,   626,  1507,   627,   628,   629,   630,   631,   632,   633,
     634,     0,   635,   636,   637,   638,   639,  1508,   640,   217,
     641,   642,   219,   643,  1509,     0,   644,   645,   646,   647,
     648,   649,   650,   651,   652,   653,  1510,     0,   654,   655,
       0,   656,   657,   658,   659,   660,   661,     0,  1511,  1512,
       0,     0,   663,  1513,   664,  1514,  1515,   665,   666,   667,
     668,   669,   670,     0,  1516,   671,   672,   673,   674,   675,
    1517,     0,   676,   677,   678,   679,   680,   681,  1518,     0,
     682,   235,   683,   684,   685,     0,     0,   686,     0,     0,
     687,   688,   689,   690,   691,   237,  1519,  1520,  1521,  1522,
    1523,  1524,  1525,  1526,   692,   693,   694,     0,     0,     0,
       0,     0,     0,     0,  1527,  1528,     0,     0,     0,     0,
       0,     0,     0,  1530,   731,    86,    87,    88,   420,    90,
      91,    92,   421,     0,   422,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   732,   104,   105,   423,   733,     0,
     107,   108,   109,   110,   734,   735,   112,   113,   114,   115,
       0,   116,   736,   737,   424,   425,     0,     0,     0,   426,
     427,     0,     0,     0,     0,   428,     0,     0,     0,     0,
       0,     0,     0,     0,   429,     0,   430,     0,   431,   432,
      35,   433,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1463,  1464,  1465,    45,  1466,     0,     0,     0,
     434,   435,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,     0,     0,     0,     0,  1467,     0,     0,   445,
     446,     0,   447,   448,   133,   449,   450,   451,   452,  4833,
    1468,   137,  1469,  1470,     0,   453,   454,   455,   456,   457,
    1471,  1472,   458,   459,  1473,  1474,   461,     0,   462,   463,
     464,   465,   466,  1475,     0,   467,     0,   468,   469,   470,
     471,   148,   472,   473,     0,   474,   475,   476,   477,   478,
     479,   480,     0,   151,   481,  4834,  1476,  1477,  1478,  1479,
    1480,  1481,  1482,   482,   483,   484,   485,   486,   487,  1483,
    1484,   488,     0,   489,     0,   490,   491,   492,   493,   494,
       0,   495,   496,   497,   498,     0,   499,     0,   500,   501,
    1485,   503,   504,     0,   505,   506,   507,     0,   508,   509,
       0,   510,   511,   512,   513,  1486,   514,   515,   516,  1487,
    1488,   517,     0,   518,  1489,   519,     0,   520,     0,   521,
     169,     0,   170,   522,   523,   524,     0,   525,  1490,     0,
     526,   527,     0,   528,   529,   530,   531,   532,   173,   533,
     534,   535,     0,   536,   537,   538,   539,   540,   541,     0,
     542,   174,   175,     0,   543,   544,   545,  1491,  1492,     0,
    1493,     0,   546,   178,   179,   547,   180,   548,   549,   550,
     551,   552,   553,   554,     0,  1494,   182,   555,   183,     0,
     556,   557,   558,  1495,  1496,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,  1497,   189,
    1498,   572,   573,   574,   191,  1499,   575,   576,   193,   577,
    1500,  1501,   578,  1502,   579,   580,   581,     0,   582,     0,
       0,  1503,   584,   585,     0,     0,   196,   197,   198,   199,
    1504,   586,   587,   588,   589,   590,   591,   592,     0,   593,
    1505,   594,   202,   595,   596,   597,   598,     0,   599,   600,
     601,   602,   603,   604,   605,  1506,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,   615,   616,   617,   618,
     619,   620,     0,   621,   622,   210,   623,   624,   625,   626,
    1507,   627,   628,   629,   630,   631,   632,   633,   634,     0,
     635,   636,   637,   638,   639,  1508,   640,   217,   641,   642,
     219,   643,  1509,     0,   644,   645,   646,   647,   648,   649,
     650,   651,   652,   653,  1510,     0,   654,   655,     0,   656,
     657,   658,   659,   660,   661,     0,  1511,  1512,     0,     0,
     663,  1513,   664,  1514,  1515,   665,   666,   667,  4835,   669,
     670,     0,  1516,   671,   672,   673,   674,   675,  1517,     0,
     676,   677,   678,   679,   680,   681,  1518,     0,   682,   235,
     683,   684,   685,     0,     0,   686,     0,     0,   687,   688,
     689,   690,   691,   237,  1519,  1520,  1521,  1522,  1523,  1524,
    1525,  1526,   692,   693,   694,     0,     0,     0,     0,     0,
       0,     0,  1527,  1528,     0,     0,     0,     0,     0,     0,
       0,  1530,   731,    86,    87,    88,   420,    90,    91,    92,
     421,     0,   422,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   732,   104,   105,   423,   733,     0,   107,   108,
     109,   110,   734,   735,   112,   113,   114,   115,     0,   116,
     736,   737,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,   433,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1463,  1464,  1465,    45,  1466,     0,     0,     0,   434,   435,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
       0,     0,     0,     0,  1467,     0,     0,   445,   446,     0,
     447,   448,   133,   449,   450,   451,   452,   135,  1468,   137,
    1469,  1470,     0,   453,   454,   455,   456,   457,  1471,  1472,
     458,   459,  1473,  1474,   461,     0,   462,   463,   464,   465,
     466,  1475,     0,   467,     0,   468,   469,   470,   471,   148,
     472,   473,     0,   474,   475,   476,   477,   478,   479,   480,
       0,   151,   481,  4834,  1476,  1477,  1478,  1479,  1480,  1481,
    1482,   482,   483,   484,   485,   486,   487,  1483,  1484,   488,
       0,   489,     0,   490,   491,   492,   493,   494,     0,   495,
     496,   497,   498,     0,   499,     0,   500,   501,  1485,   503,
     504,     0,   505,   506,   507,     0,   508,   509,     0,   510,
     511,   512,   513,  1486,   514,   515,   516,  1487,  1488,   517,
       0,   518,  1489,   519,     0,   520,     0,   521,   169,     0,
     170,   522,   523,   524,     0,   525,  1490,     0,   526,   527,
       0,   528,   529,   530,   531,   532,   173,   533,   534,   535,
       0,   536,   537,   538,   539,   540,   541,     0,   542,   174,
     175,     0,   543,   544,   545,  1491,  1492,     0,  1493,     0,
     546,   178,   179,   547,   180,   548,   549,   550,   551,   552,
     553,   554,     0,  1494,   182,   555,   183,     0,   556,   557,
     558,  1495,  1496,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,  1497,   189,  1498,   572,
     573,   574,   191,  1499,   575,   576,   193,   577,  1500,  1501,
     578,  1502,   579,   580,   581,     0,   582,     0,     0,  1503,
     584,   585,     0,     0,   196,   197,   198,   199,  1504,   586,
     587,   588,   589,   590,   591,   592,     0,   593,  1505,   594,
     202,   595,   596,   597,   598,     0,   599,   600,   601,   602,
     603,   604,   605,  1506,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
       0,   621,   622,   210,   623,   624,   625,   626,  1507,   627,
     628,   629,   630,   631,   632,   633,   634,     0,   635,   636,
     637,   638,   639,  1508,   640,   217,   641,   642,   219,   643,
    1509,     0,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,  1510,     0,   654,   655,     0,   656,   657,   658,
     659,   660,   661,     0,  1511,  1512,     0,     0,   663,  1513,
     664,  1514,  1515,   665,   666,   667,  4835,   669,   670,     0,
    1516,   671,   672,   673,   674,   675,  1517,     0,   676,   677,
     678,   679,   680,   681,  1518,     0,   682,   235,   683,   684,
     685,     0,     0,   686,     0,     0,   687,   688,   689,   690,
     691,   237,  1519,  1520,  1521,  1522,  1523,  1524,  1525,  1526,
     692,   693,   694,     0,     0,     0,     0,     0,     0,     0,
    1527,  1528,     0,     0,     0,     0,     0,     0,     0,  1530,
     731,    86,    87,    88,   420,    90,    91,    92,   421,     0,
     422,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     732,   104,   105,   423,   733,     0,   107,   108,   109,   110,
     734,   735,   112,   113,   114,   115,     0,   116,   736,   737,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,   433,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1463,  1464,
    1465,    45,  1466,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,     0,     0,
       0,     0,  1467,     0,     0,   445,   446,     0,   447,   448,
     133,   449,   450,   451,   452,   135,  1468,   137,  1469,  1470,
       0,   453,   454,   455,   456,   457,  1471,  1472,   458,   459,
    1473,  1474,   461,     0,   462,   463,   464,   465,   466,  1475,
       0,   467,     0,   468,   469,   470,   471,   148,   472,   473,
       0,   474,   475,   476,   477,   478,   479,   480,     0,   151,
     481,     0,  1476,  1477,  1478,  1479,  1480,  1481,  1482,   482,
     483,   484,   485,   486,   487,  1483,  1484,   488,     0,   489,
       0,   490,   491,   492,   493,   494,     0,   495,   496,   497,
     498,     0,   499,     0,   500,   501,  1485,   503,   504,     0,
     505,   506,   507,     0,   508,   509,     0,   510,   511,   512,
     513,  1486,   514,   515,   516,  1487,  1488,   517,     0,   518,
    1489,   519,     0,   520,     0,   521,   169,     0,   170,   522,
     523,   524,     0,   525,  1490,     0,   526,   527,     0,   528,
     529,   530,   531,   532,   173,   533,   534,   535,     0,   536,
     537,   538,   539,   540,   541,     0,   542,   174,   175,     0,
     543,   544,   545,  1491,  1492,     0,  1493,     0,   546,   178,
     179,   547,   180,   548,   549,   550,   551,   552,   553,   554,
       0,  1494,   182,   555,   183,     0,   556,   557,   558,  1495,
    1496,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,  1497,   189,  1498,   572,   573,   574,
     191,  1499,   575,   576,   193,   577,  1500,  1501,   578,  1502,
     579,   580,   581,     0,   582,     0,     0,  1503,   584,   585,
       0,     0,   196,   197,   198,   199,  1504,   586,   587,   588,
     589,   590,   591,   592,     0,   593,  1505,   594,   202,   595,
     596,   597,   598,     0,   599,   600,   601,   602,   603,   604,
     605,  1506,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,     0,   621,
     622,   210,   623,   624,   625,   626,  1507,   627,   628,   629,
     630,   631,   632,   633,   634,     0,   635,   636,   637,   638,
     639,  1508,   640,   217,   641,   642,   219,   643,  1509,     0,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
    1510,     0,   654,   655,     0,   656,   657,   658,   659,   660,
     661,     0,  1511,  1512,     0,     0,   663,  1513,   664,  1514,
    1515,   665,   666,   667,   668,   669,   670,     0,  1516,   671,
     672,   673,   674,   675,  1517,     0,   676,   677,   678,   679,
     680,   681,  1518,     0,   682,   235,   683,   684,   685,     0,
       0,   686,     0,     0,   687,   688,   689,   690,   691,   237,
    1519,  1520,  1521,  1522,  1523,  1524,  1525,  1526,   692,   693,
     694,     0,     0,     0,     0,     0,     0,     0,  1527,  1528,
       0,     0,     0,     0,     0,     0,     0,  1530,   731,    86,
      87,    88,   420,    90,    91,    92,   421,     0,   422,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   732,   104,
     105,   423,   733,     0,   107,   108,   109,   110,   734,   735,
     112,   113,   114,   115,     0,   116,   736,   737,   424,   425,
       0,     0,     0,   426,   427,     0,     0,     0,     0,   428,
       0,     0,     0,     0,     0,     0,     0,     0,   429,     0,
     430,     0,   431,   432,    35,   433,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1463,  1464,  1465,    45,
    1466,     0,     0,     0,   434,   435,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,     0,     0,     0,     0,
    1467,     0,     0,   445,   446,     0,   447,   448,   133,   449,
     450,   451,   452,   135,  1468,   137,  1469,  1470,     0,   453,
     454,   455,   456,   457,  1471,  1472,   458,   459,  1473,  1474,
     461,     0,   462,   463,   464,   465,   466,  1475,     0,   467,
       0,   468,   469,   470,   471,   148,   472,   473,     0,   474,
     475,   476,   477,   478,   479,   480,     0,   151,   481,     0,
    1476,  1477,  1478,  1479,  1480,  1481,  1482,   482,   483,   484,
     485,   486,   487,  1483,  1484,   488,     0,   489,     0,   490,
     491,   492,   493,   494,     0,   495,   496,   497,   498,     0,
     499,     0,   500,   501,  1485,   503,   504,     0,   505,   506,
     507,     0,   508,   509,     0,   510,   511,   512,   513,  1486,
     514,   515,   516,  1487,  1488,   517,     0,   518,  1489,   519,
       0,   520,     0,   521,   169,     0,   170,   522,   523,   524,
       0,   525,  1490,     0,   526,   527,     0,   528,   529,   530,
     531,   532,   173,   533,   534,   535,     0,   536,   537,   538,
     539,   540,   541,     0,   542,   174,   175,     0,   543,   544,
     545,  1491,  1492,     0,  1493,     0,   546,   178,   179,   547,
     180,   548,   549,   550,   551,   552,   553,   554,     0,  1494,
     182,   555,   183,     0,   556,   557,   558,  1495,  1496,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,  1497,   189,  1498,   572,   573,   574,   191,  1499,
     575,   576,   193,   577,  1500,  1501,   578,  1502,   579,   580,
     581,     0,   582,     0,     0,  1503,   584,   585,     0,     0,
     196,   197,   198,   199,  1504,   586,   587,   588,   589,   590,
     591,   592,     0,   593,  1505,   594,   202,   595,   596,   597,
     598,     0,   599,   600,   601,   602,   603,   604,   605,  1506,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,     0,   621,   622,   210,
     623,   624,   625,   626,  1507,   627,   628,   629,   630,   631,
     632,   633,   634,     0,   635,   636,   637,   638,   639,  1508,
     640,   217,   641,   642,   219,   643,  1509,     0,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,  1510,     0,
     654,   655,     0,   656,   657,   658,   659,   660,   661,     0,
    1511,  1512,     0,     0,   663,  1513,   664,  1514,  1515,   665,
     666,   667,   668,   669,   670,     0,  1516,   671,   672,   673,
     674,   675,  1517,     0,   676,   677,   678,   679,   680,   681,
    1518,     0,   682,   235,   683,   684,   685,     0,     0,   686,
       0,     0,   687,   688,   689,   690,   691,  4301,  1519,  1520,
    1521,  1522,  1523,  1524,  1525,  1526,   692,   693,   694,     0,
       0,     0,     0,     0,     0,     0,  1527,  1528,     0,     0,
       0,     0,     0,     0,     0,  1530,   731,    86,    87,    88,
     420,    90,    91,    92,   421,     0,   422,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   732,   104,   105,   423,
     733,     0,   107,   108,   109,   110,   734,   735,   112,   113,
     114,   115,     0,   116,   736,   737,   424,   425,     0,     0,
       0,   426,   427,     0,     0,     0,     0,   428,     0,     0,
       0,     0,     0,     0,     0,     0,   429,     0,   430,     0,
     431,   432,    35,   433,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1463,  1464,  1465,    45,  1466,     0,
       0,     0,   434,   435,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,     0,     0,     0,     0,  1467,     0,
       0,   445,   446,     0,   447,   448,   133,   449,   450,   451,
     452,   135,  1468,   137,  1469,  1470,     0,   453,   454,   455,
     456,   457,  1471,  1472,   458,   459,  1473,  1474,   461,     0,
     462,   463,   464,   465,   466,  1475,     0,   467,     0,   468,
     469,   470,   471,   148,   472,   473,     0,   474,   475,   476,
     477,   478,   479,   480,     0,   151,   481,     0,  1476,  1477,
    1478,  1479,  1480,  1481,  1482,   482,   483,   484,   485,   486,
     487,  1483,  1484,   488,     0,   489,     0,   490,   491,   492,
     493,   494,     0,   495,   496,   497,   498,     0,   499,     0,
     500,   501,  1485,   503,   504,     0,   505,   506,   507,     0,
     508,   509,     0,   510,   511,   512,   513,  1486,   514,   515,
     516,  1487,  1488,   517,     0,   518,  1489,   519,     0,   520,
       0,   521,   169,     0,   170,   522,   523,   524,     0,   525,
    1490,     0,   526,   527,     0,   528,   529,   530,   531,   532,
     173,   533,   534,   535,     0,   536,   537,   538,   539,   540,
     541,     0,   542,   174,   175,     0,   543,   544,   545,  1491,
    1492,     0,  1493,     0,   546,   178,   179,   547,   180,   548,
     549,   550,   551,   552,   553,   554,     0,  1494,   182,   555,
     183,     0,   556,   557,   558,  1495,  1496,   559,   560,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
    1497,   189,  1498,   572,  4310,   574,   191,  1499,   575,   576,
     193,   577,  1500,  1501,   578,  1502,   579,   580,   581,     0,
     582,     0,     0,  1503,   584,   585,     0,     0,   196,   197,
     198,   199,  1504,   586,   587,   588,   589,   590,   591,   592,
       0,   593,  1505,   594,   202,   595,   596,   597,   598,     0,
     599,   600,   601,   602,   603,   604,   605,  1506,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,   615,   616,
     617,   618,   619,   620,     0,   621,   622,   210,   623,   624,
     625,   626,  1507,   627,   628,   629,   630,   631,   632,   633,
     634,     0,   635,   636,   637,   638,   639,  1508,   640,   217,
     641,   642,   219,   643,  1509,     0,   644,   645,   646,   647,
     648,   649,   650,   651,   652,   653,  1510,     0,   654,   655,
       0,   656,   657,   658,   659,   660,   661,     0,  1511,  1512,
       0,     0,   663,  1513,   664,  1514,  1515,   665,   666,   667,
     668,   669,   670,     0,  1516,   671,   672,   673,   674,   675,
    1517,     0,   676,   677,   678,   679,   680,   681,  1518,     0,
     682,   235,   683,   684,   685,     0,     0,   686,     0,     0,
     687,   688,   689,   690,   691,   237,  1519,  1520,  1521,  1522,
    1523,  1524,  1525,  1526,   692,   693,   694,     0,     0,     0,
       0,     0,     0,     0,  1527,  1528,     0,     0,     0,     0,
       0,     0,     0,  1530,   731,    86,    87,    88,   420,    90,
      91,    92,   421,     0,   422,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   732,   104,   105,   423,   733,     0,
     107,   108,   109,   110,   734,   735,   112,   113,   114,   115,
       0,   116,   736,   737,   424,   425,     0,     0,     0,   426,
     427,     0,     0,     0,     0,   428,     0,     0,     0,     0,
       0,     0,     0,     0,   429,     0,   430,     0,   431,   432,
      35,   433,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1463,  1464,  1465,    45,  1466,     0,     0,     0,
     434,   435,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,     0,     0,     0,     0,  1467,     0,     0,   445,
     446,     0,   447,   448,   133,   449,   450,   451,   452,   135,
    1468,   137,  1469,  1470,     0,   453,   454,   455,   456,   457,
    1471,  1472,   458,   459,  1473,  1474,   461,     0,   462,   463,
     464,   465,   466,  1475,     0,   467,     0,   468,   469,   470,
     471,   148,   472,   473,     0,   474,   475,   476,   477,   478,
     479,   480,     0,   151,   481,     0,  1476,  1477,  1478,  1479,
    1480,  1481,  1482,   482,   483,   484,   485,   486,   487,  1483,
    1484,   488,     0,   489,     0,   490,   491,   492,   493,   494,
       0,   495,   496,   497,   498,     0,   499,     0,   500,   501,
    1485,   503,   504,     0,   505,   506,   507,     0,   508,   509,
       0,   510,   511,   512,   513,  1486,   514,   515,   516,  1487,
    1488,   517,     0,   518,  1489,   519,     0,   520,     0,   521,
     169,     0,   170,   522,   523,   524,     0,   525,  1490,     0,
     526,   527,     0,   528,   529,   530,   531,   532,   173,   533,
     534,   535,     0,   536,   537,   538,   539,   540,   541,     0,
     542,   174,   175,     0,   543,   544,   545,  1491,  1492,     0,
    1493,     0,   546,   178,   179,   547,   180,   548,   549,   550,
     551,   552,   553,   554,     0,  1494,   182,   555,   183,     0,
     556,   557,   558,  1495,  1496,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,  1497,   189,
    1498,   572,   573,   574,   191,     0,   575,   576,   193,   577,
    1500,  1501,   578,  1502,   579,   580,   581,     0,   582,     0,
       0,  1503,   584,   585,     0,     0,   196,   197,   198,   199,
    1504,   586,   587,   588,   589,   590,   591,   592,     0,   593,
    1505,   594,   202,   595,   596,   597,   598,     0,   599,   600,
     601,   602,   603,   604,   605,  1506,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,   615,   616,   617,   618,
     619,   620,     0,   621,   622,   210,   623,   624,   625,   626,
    1507,   627,   628,   629,   630,   631,   632,   633,   634,     0,
     635,   636,   637,   638,   639,  1508,   640,   217,   641,   642,
     219,   643,  1509,     0,   644,   645,   646,   647,   648,   649,
     650,   651,   652,   653,  1510,     0,   654,   655,     0,   656,
     657,   658,   659,   660,   661,     0,  1511,  1512,     0,     0,
     663,  1513,   664,  1514,  1515,   665,   666,   667,   668,   669,
     670,     0,     0,   671,   672,   673,   674,   675,  1517,     0,
     676,   677,   678,   679,   680,   681,  1518,     0,   682,   235,
     683,   684,   685,     0,     0,   686,     0,     0,   687,   688,
     689,   690,   691,   237,  1519,  1520,  1521,  1522,  1523,  1524,
    1525,  1526,   692,   693,   694,     0,     0,     0,     0,     0,
       0,     0,  2811,  2812,     0,     0,     0,     0,     0,     0,
       0,  1530,   731,    86,    87,    88,   420,    90,    91,    92,
     421,     0,   422,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   732,   104,   105,   423,   733,     0,   107,   108,
     109,   110,   734,   735,   112,   113,   114,   115,     0,   116,
     736,   737,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,   433,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1463,  1464,  1465,    45,  1466,     0,     0,     0,   434,   435,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
       0,     0,     0,     0,  1467,     0,     0,   445,   446,     0,
     447,   448,   133,   449,   450,   451,   452, -2583,  1468,   137,
    1469,  1470,     0,   453,   454,   455,   456,   457,  1471,  1472,
     458,   459,  1473,  1474,   461,     0,   462,   463,   464,   465,
     466,  1475,     0,   467,     0,   468,   469,   470,   471,   148,
     472,   473,     0,   474,   475,   476,   477,   478,   479,   480,
       0,   151,   481,  4834,  1476,  1477,  1478,  1479,  1480,  1481,
    1482,   482,   483,   484,   485,   486,   487,  1483,  1484,   488,
       0,   489,     0,   490,   491,   492,   493,   494,     0,   495,
     496,   497,   498,     0,   499,     0,   500,   501,  1485,   503,
     504,     0,   505,   506,   507,     0,   508,   509,     0,   510,
     511,   512,   513,  1486,   514,   515,   516,  1487,  1488,   517,
       0,   518,  1489,   519,     0,   520,     0,   521,   169,     0,
     170,   522,   523,   524,     0,   525,  1490,     0,   526,   527,
       0,   528,   529,   530,   531,   532,     0,   533,   534,   535,
       0,   536,   537,   538,   539,   540,   541,     0,   542,   174,
     175,     0,   543,   544,   545,  1491,  1492,     0,  1493,     0,
     546,   178,   179,   547,   180,   548,   549,   550,   551,   552,
     553,   554,     0,  1494,   182,   555,     0,     0,   556,   557,
     558,  1495,  1496,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,  1497,   189,  1498,   572,
     573,   574,   191,     0,   575,   576,   193,   577,  1500,  1501,
     578,  1502,   579,   580,   581,     0,   582,     0,     0,  1503,
     584,   585,     0,     0,   196,   197,   198,   199,  1504,   586,
     587,   588,   589,   590,   591,   592,     0,   593,  1505,   594,
     202,   595,   596,   597,   598,     0,   599,   600,   601,   602,
     603,   604,   605,  1506,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
       0,   621,   622,   210,   623,   624,   625,   626,  1507,   627,
     628,   629,   630,   631,   632,   633,   634,     0,   635,   636,
     637,   638,   639,  1508,   640,   217,   641,   642,     0,   643,
    1509,     0,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,  1510,     0,   654,   655,     0,   656,   657,   658,
     659,   660,   661,     0,  1511,  1512,     0,     0,   663,  1513,
     664,  1514,  1515,   665,   666,   667,  4835,   669,   670,     0,
    1516,   671,   672,   673,   674,   675,  1517,     0,   676,   677,
     678,   679,   680,   681,  1518,     0,   682,   235,   683,   684,
     685,     0,     0,   686,     0,     0,   687,   688,   689,   690,
     691,   237,  1519,  1520,  1521,  1522,  1523,  1524,  1525,  1526,
     692,   693,   694,     0,     0,     0,     0,     0,     0,     0,
    1527,  1528,     0,     0,     0,     0,     0,     0,     0,  1530,
     731,    86,    87,    88,   420,    90,    91,    92,   421,     0,
     422,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     732,   104,   105,   423,   733,     0,   107,   108,   109,   110,
     734,   735,   112,   113,   114,   115,     0,   116,   736,   737,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,   433,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1463,  1464,
       0,    45,  1466,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,     0,     0,
       0,     0,  1467,     0,     0,   445,   446,     0,   447,   448,
     133,   449,   450,   451,   452,   135,  1468,   137,  1469,  1470,
       0,   453,   454,   455,   456,   457,  1471,  1472,   458,   459,
    1473,  1474,   461,     0,   462,   463,   464,   465,   466,  1475,
       0,   467,     0,   468,   469,   470,   471,   148,   472,   473,
       0,   474,   475,   476,   477,   478,   479,   480,     0,   151,
     481,     0,  1476,  1477,  1478,  1479,  1480,  1481,  1482,   482,
     483,   484,   485,   486,   487,  1483,  1484,   488,     0,   489,
       0,   490,   491,   492,   493,   494,     0,   495,   496,   497,
     498,     0,   499,     0,   500,   501,  1485,   503,   504,     0,
     505,   506,   507,     0,   508,   509,     0,   510,   511,   512,
     513,  1486,   514,   515,   516,  1487,  1488,   517,     0,   518,
    1489,   519,     0,   520,     0,   521,   169,     0,   170,   522,
     523,   524,     0,   525,  1490,     0,   526,   527,     0,   528,
     529,   530,   531,   532,   173,   533,   534,   535,     0,   536,
     537,   538,   539,   540,   541,     0,   542,   174,   175,     0,
     543,   544,   545,  1491,  1492,     0,  1493,     0,   546,   178,
     179,   547,   180,   548,   549,   550,   551,   552,   553,   554,
       0,  1494,   182,   555,   183,     0,   556,   557,   558,  1495,
    1496,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,  1497,   189,  1498,   572,   573,   574,
     191,     0,   575,   576,   193,   577,  1500,  1501,   578,  1502,
     579,   580,   581,     0,   582,     0,     0,   583,   584,   585,
       0,     0,   196,   197,   198,   199,  1504,   586,   587,   588,
     589,   590,   591,   592,     0,   593,  1505,   594,   202,   595,
     596,   597,   598,     0,   599,   600,   601,   602,   603,   604,
     605,  1506,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,     0,   621,
     622,   210,   623,   624,   625,   626,  1507,   627,   628,   629,
     630,   631,   632,   633,   634,     0,   635,   636,   637,   638,
     639,  1508,   640,   217,   641,   642,   219,   643,  1509,     0,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
    1510,     0,   654,   655,     0,   656,   657,   658,   659,   660,
     661,     0,  1511,  1512,     0,     0,   663,  1513,   664,  1514,
    1515,   665,   666,   667,   668,   669,   670,     0,     0,   671,
     672,   673,   674,   675,  1517,     0,   676,   677,   678,   679,
     680,   681,  1518,     0,   682,   235,   683,   684,   685,     0,
       0,   686,     0,     0,   687,   688,   689,   690,   691,   237,
    1519,  1520,  1521,  1522,  1523,  1524,  1525,  1526,   692,   693,
     694,     0,     0,     0,   731,    86,    87,    88,   420,    90,
      91,    92,   421,     0,   422,    95,     0,  1530,    98,    99,
     100,   101,   102,   103,   732,   104,   105,   423,   733,     0,
     107,   108,   109,   110,   734,   735,   112,   113,   114,   115,
       0,   116,   736,   737,   424,   425,     0,     0,     0,   426,
     427,     0,     0,     0,     0,   428,     0,     0,     0,     0,
       0,     0,     0,     0,   429,     0,   430,     0,   431,   432,
      35,   433,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1463,  1464,     0,    45,  1466,     0,     0,     0,
     434,   435,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,     0,     0,     0,     0,  1467,     0,     0,   445,
     446,     0,   447,   448,   133,   449,   450,   451,   452,   135,
    1468,   137,  1469,  1470,     0,  3942,   454,   455,   456,   457,
    1471,  1472,   458,   459,  1473,  1474,   461,     0,   462,   463,
     464,   465,   466,  1475,     0,   467,     0,   468,   469,   470,
     471,   148,   472,   473,     0,   474,   475,   476,   477,   478,
     479,   480,     0,   151,   481,     0,  1476,  1477,  1478,  1479,
    1480,  1481,  1482,   482,   483,   484,   485,   486,   487,  1483,
    1484,   488,     0,   489,     0,   490,   491,   492,   493,   494,
       0,   495,   496,   497,   498,     0,   499,     0,   500,   501,
    1485,   503,   504,     0,   505,   506,   507,     0,   508,   509,
       0,   510,   511,   512,   513,  1486,   514,   515,   516,  1487,
    1488,   517,     0,   518,  1489,   519,     0,   520,     0,   521,
     169,     0,   170,   522,   523,   524,     0,   525,  1490,     0,
     526,   527,     0,   528,   529,   530,   531,   532,   173,   533,
     534,   535,     0,   536,   537,   538,   539,   540,   541,     0,
     542,   174,   175,     0,   543,   544,   545,  1491,  1492,     0,
    1493,     0,   546,   178,   179,   547,   180,   548,   549,   550,
     551,   552,   553,   554,     0,  1494,   182,   555,   183,     0,
     556,   557,   558,  1495,  1496,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,  1497,   189,
    1498,   572,   573,   574,   191,     0,   575,   576,   193,   577,
    1500,  1501,   578,  1502,   579,   580,   581,     0,   582,     0,
       0,   583,   584,   585,     0,     0,   196,   197,   198,   199,
    1504,   586,   587,   588,   589,   590,   591,   592,     0,   593,
    1505,   594,   202,   595,   596,   597,   598,     0,   599,   600,
     601,   602,   603,   604,   605,  1506,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,   615,   616,   617,   618,
     619,   620,     0,   621,   622,   210,   623,   624,   625,   626,
    1507,   627,   628,   629,   630,   631,   632,   633,   634,     0,
     635,   636,   637,   638,   639,  1508,   640,   217,   641,   642,
     219,   643,  1509,     0,   644,   645,   646,   647,   648,   649,
     650,   651,   652,   653,  1510,     0,   654,   655,     0,   656,
     657,   658,   659,   660,   661,     0,  1511,  1512,     0,     0,
     663,  1513,   664,  1514,  1515,   665,   666,   667,   668,   669,
     670,     0,     0,   671,   672,   673,   674,   675,  1517,     0,
     676,   677,   678,   679,   680,   681,  1518,     0,   682,   235,
     683,   684,   685,     0,     0,   686,     0,     0,   687,   688,
     689,   690,   691,   237,  1519,  1520,  1521,  1522,  1523,  1524,
    1525,  1526,   692,   693,   694,     0,     0,     0,   731,    86,
      87,    88,   420,    90,    91,    92,   421,     0,   422,    95,
       0,  1530,    98,    99,   100,   101,   102,   103,   732,   104,
     105,   423,   733,     0,   107,   108,   109,   110,   734,   735,
     112,   113,   114,   115,     0,   116,   736,   737,   424,   425,
       0,     0,     0,   426,   427,     0,     0,     0,     0,   428,
       0,     0,     0,     0,     0,     0,     0,     0,   429,     0,
     430,     0,   431,   432,    35,   433,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1463,  1464,  1465,    45,
    1466,     0,     0,     0,   434,   435,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,     0,     0,     0,     0,
    1467,     0,     0,   445,   446,     0,   447,   448,   133,   449,
     450,   451,   452,     0,  1468,   137,  1469,  1470,     0,   453,
     454,   455,   456,   457,  1471,  1472,   458,   459,  1473,  1474,
     461,     0,   462,   463,   464,   465,   466,  1475,     0,   467,
       0,   468,   469,   470,   471,   148,   472,   473,     0,   474,
     475,   476,   477,   478,   479,   480,     0,   151,   481,     0,
    1476,  1477,  1478,  1479,  1480,  1481,  1482,   482,   483,   484,
     485,   486,   487,  1483,  1484,   488,     0,   489,     0,   490,
     491,   492,   493,   494,     0,   495,   496,   497,   498,     0,
     499,     0,   500,   501,  1485,   503,   504,     0,   505,   506,
     507,     0,   508,     0,     0,   510,   511,   512,   513,  1486,
     514,   515,   516,  1487,  1488,   517,     0,   518,  1489,   519,
       0,   520,     0,   521,   169,     0,   170,   522,   523,   524,
       0,   525,  1490,     0,   526,   527,     0,   528,   529,   530,
     531,   532,     0,   533,   534,   535,     0,   536,   537,   538,
     539,   540,   541,     0,   542,   174,   175,     0,   543,   544,
     545,  1491,  1492,     0,  1493,     0,   546,   178,   179,   547,
     180,   548,   549,   550,   551,   552,   553,   554,     0,  1494,
     182,   555,     0,     0,   556,   557,   558,  1495,  1496,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,  1497,   189,  1498,   572,   573,   574,   191,     0,
     575,   576,   193,   577,  1500,  1501,   578,  1502,   579,   580,
     581,     0,   582,     0,     0,  1503,   584,   585,     0,     0,
     196,   197,   198,   199,  1504,   586,   587,   588,   589,   590,
     591,   592,     0,   593,  1505,   594,   202,   595,   596,   597,
     598,     0,   599,   600,   601,   602,   603,   604,   605,  1506,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,     0,   621,   622,   210,
     623,   624,   625,   626,  1507,   627,   628,   629,   630,   631,
     632,   633,   634,     0,   635,   636,   637,   638,   639,  1508,
     640,   217,   641,   642,     0,   643,  1509,     0,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,  1510,     0,
     654,   655,     0,   656,   657,   658,   659,   660,   661,     0,
    1511,  1512,     0,     0,   663,  1513,   664,  1514,  1515,   665,
     666,   667,   668,   669,   670,     0,  1516,   671,   672,   673,
     674,   675,  1517,     0,   676,   677,   678,   679,   680,   681,
    1518,     0,   682,   235,   683,   684,   685,     0,     0,   686,
       0,     0,   687,   688,   689,   690,   691,   237,  1519,  1520,
    1521,  1522,  1523,  1524,  1525,  1526,   692,   693,   694,     0,
       0,     0,     0,     0,     0,     0,  1527,  1528,     0,     0,
       0,     0,     0,     0,     0,  1530,   731,    86,    87,    88,
     420,    90,    91,    92,   421,     0,   422,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   732,   104,   105,   423,
     733,     0,   107,   108,   109,   110,   734,   735,   112,   113,
     114,   115,     0,   116,   736,   737,   424,   425,     0,     0,
       0,   426,   427,     0,     0,     0,     0,   428,     0,     0,
       0,     0,     0,     0,     0,     0,   429,     0,   430,     0,
     431,   432,    35,   433,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1463,  1464,  1465,    45,  1466,     0,
       0,     0,   434,   435,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,     0,     0,     0,     0,  1467,     0,
       0,   445,   446,     0,   447,   448,   133,   449,   450,   451,
     452,     0,  1468,   137,  1469,  1470,     0,   453,   454,   455,
     456,   457,  1471,  1472,   458,   459,  1473,  1474,   461,     0,
     462,   463,   464,   465,   466,  1475,     0,   467,     0,   468,
     469,   470,   471,   148,   472,   473,     0,   474,   475,   476,
     477,   478,   479,   480,     0,   151,   481,     0,  1476,  1477,
    1478,  1479,  1480,  1481,  1482,   482,   483,   484,   485,   486,
     487,  1483,  1484,   488,     0,   489,     0,   490,   491,   492,
     493,   494,     0,   495,   496,   497,   498,     0,   499,     0,
     500,   501,  1485,   503,   504,     0,   505,   506,   507,     0,
     508,     0,     0,   510,   511,   512,   513,  1486,   514,   515,
     516,  1487,  1488,   517,     0,   518,  1489,   519,     0,   520,
       0,   521,   169,     0,   170,   522,   523,   524,     0,   525,
    1490,     0,   526,   527,     0,   528,   529,   530,   531,   532,
       0,   533,   534,   535,     0,   536,   537,   538,   539,   540,
     541,     0,   542,   174,   175,     0,   543,   544,   545,  1491,
    1492,     0,  1493,     0,   546,   178,   179,   547,   180,   548,
     549,   550,   551,   552,   553,   554,     0,  1494,   182,   555,
       0,     0,   556,   557,   558,  1495,  1496,   559,   560,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
    1497,   189,  1498,   572,   573,   574,   191,     0,   575,   576,
     193,   577,  1500,  1501,   578,  1502,   579,   580,   581,     0,
     582,     0,     0,  1503,   584,   585,     0,     0,   196,   197,
     198,   199,  1504,   586,   587,   588,   589,   590,   591,   592,
       0,   593,  1505,   594,   202,   595,   596,   597,   598,     0,
     599,   600,   601,   602,   603,   604,   605,  1506,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,   615,   616,
     617,   618,   619,   620,     0,   621,   622,   210,   623,   624,
     625,   626,  1507,   627,   628,   629,   630,   631,   632,   633,
     634,     0,   635,   636,   637,   638,   639,  1508,   640,   217,
     641,   642,     0,   643,  1509,     0,   644,   645,   646,   647,
     648,   649,   650,   651,   652,   653,  1510,     0,   654,   655,
       0,   656,   657,   658,   659,   660,   661,     0,  1511,  1512,
       0,     0,   663,  1513,   664,  1514,  1515,   665,   666,   667,
     668,   669,   670,     0,     0,   671,   672,   673,   674,   675,
    1517,     0,   676,   677,   678,   679,   680,   681,  1518,     0,
     682,   235,   683,   684,   685,     0,     0,   686,     0,     0,
     687,   688,   689,   690,   691,   237,  1519,  1520,  1521,  1522,
    1523,  1524,  1525,  1526,   692,   693,   694,     0,     0,     0,
       0,     0,     0,     0,  2811,  2812,     0,     0,     0,     0,
       0,     0,     0,  1530,   731,    86,    87,    88,   420,    90,
      91,    92,   421,     0,   422,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   732,   104,   105,   423,   733,     0,
     107,   108,   109,   110,   734,   735,   112,   113,   114,   115,
       0,   116,   736,   737,   424,   425,     0,     0,     0,   426,
     427,     0,     0,     0,     0,   428,     0,     0,     0,     0,
       0,     0,     0,     0,   429,     0,   430,     0,   431,   432,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     434,   435,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,     0,     0,     0,     0,     0,     0,     0,   445,
     446,     0,   447,   448,   133,   449,   450,   451,   452,   135,
     136,   137,   138,   139,     0,   453,   454,   455,   456,   457,
       0,  1472,   458,   459,   460,   140,   461,     0,   462,   463,
     464,   465,   466,  1475,     0,   467,     0,   468,   469,   470,
     471,   148,   472,   473,     0,   474,   475,   476,   477,   478,
     479,   480,     0,   151,   481,     0,  1476,  1477,  1478,  1479,
    1480,  1481,  1482,   482,   483,   484,   485,   486,   487,   155,
     156,   488,     0,   489,     0,   490,   491,   492,   493,   494,
       0,   495,   496,   497,   498,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
       0,   510,   511,   512,   513,   164,   514,   515,   516,  1487,
       0,   517,     0,   518,   168,   519,     0,   520,     0,   521,
     169,     0,   170,   522,   523,   524,     0,   525,  1490,     0,
     526,   527,     0,   528,   529,   530,   531,   532,   173,   533,
     534,   535,     0,   536,   537,   538,   539,   540,   541,     0,
     542,   174,   175,     0,   543,   544,   545,     0,   176,     0,
     177,     0,   546,   178,   179,   547,   180,   548,   549,   550,
     551,   552,   553,   554,     0,  1494,   182,   555,   183,     0,
     556,   557,   558,  1495,  1496,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,   188,   189,
     190,   572,   573,   574,   191,     0,   575,   576,   193,   577,
       0,  1501,   578,   195,   579,   580,   581,     0,   582,     0,
    1082,   583,   584,   585,     0,     0,   196,   197,   198,   199,
    1504,   586,   587,   588,   589,   590,   591,   592,     0,   593,
    1505,   594,   202,   595,   596,   597,   598,     0,   599,   600,
     601,   602,   603,   604,   605,   204,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,   615,   616,   617,   618,
     619,   620,     0,   621,   622,   210,   623,   624,   625,   626,
     212,   627,   628,   629,   630,   631,   632,   633,   634,   215,
     635,   636,   637,   638,   639,  1508,   640,   217,   641,   642,
     219,   643,   220,     0,   644,   645,   646,   647,   648,   649,
     650,   651,   652,   653,  1510,     0,   654,   655,   223,   656,
     657,   658,   659,   660,   661,     0,   224,   225,     0,     0,
     663,  1513,   664,  1514,     0,   665,   666,   667,   668,   669,
     670,     0,     0,   671,   672,   673,   674,   675,  1517,     0,
     676,   677,   678,   679,   680,  1389,   234,     0,   682,   235,
     683,   684,   685,     0,     0,   686,     0,   236,   687,   688,
     689,   690,   691,   237,  1519,  1520,  1521,  1522,  1523,  1524,
    1525,  1526,   692,   693,   694,     0,     0,     0,   731,    86,
      87,    88,   420,    90,    91,    92,   421,     0,   422,    95,
       0,  3502,    98,    99,   100,   101,   102,   103,   732,   104,
     105,   423,   733,     0,   107,   108,   109,   110,   734,   735,
     112,   113,   114,   115,     0,   116,   736,   737,   424,   425,
       0,     0,     0,   426,   427,     0,     0,     0,     0,   428,
       0,     0,     0,     0,     0,     0,     0,     0,   429,     0,
     430,     0,   431,   432,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   434,   435,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,     0,     0,     0,     0,
       0,     0,     0,   445,   446,     0,   447,   448,   133,   449,
     450,   451,   452,   135,   136,   137,   138,   139,     0,   453,
     454,   455,   456,   457,     0,  1472,   458,   459,   460,   140,
     461,     0,   462,   463,   464,   465,   466,  1475,     0,   467,
       0,   468,   469,   470,   471,   148,   472,   473,     0,   474,
     475,   476,   477,   478,   479,   480,     0,   151,   481,     0,
    1476,  1477,  1478,  1479,  1480,  1481,  1482,   482,   483,   484,
     485,   486,   487,   155,   156,   488,     0,   489,     0,   490,
     491,   492,   493,   494,     0,   495,   496,   497,   498,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,     0,   510,   511,   512,   513,   164,
     514,   515,   516,  1487,     0,   517,     0,   518,   168,   519,
       0,   520,     0,   521,   169,     0,   170,   522,   523,   524,
       0,   525,  1490,     0,   526,   527,     0,   528,   529,   530,
     531,   532,   173,   533,   534,   535,     0,   536,   537,   538,
     539,   540,   541,     0,   542,   174,   175,     0,   543,   544,
     545,     0,   176,     0,   177,     0,   546,   178,   179,   547,
     180,   548,   549,   550,   551,   552,   553,   554,     0,  1494,
     182,   555,   183,     0,   556,   557,   558,  1495,  1496,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,   188,   189,   190,   572,   573,   574,   191,     0,
     575,   576,   193,   577,     0,  1501,   578,   195,   579,   580,
     581,     0,   582,     0,  1082,   583,   584,   585,     0,     0,
     196,   197,   198,   199,  1504,   586,   587,   588,   589,   590,
     591,   592,     0,   593,  1505,   594,   202,   595,   596,   597,
     598,     0,   599,   600,   601,   602,   603,   604,   605,   204,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,     0,   621,   622,   210,
     623,   624,   625,   626,   212,   627,   628,   629,   630,   631,
     632,   633,   634,     0,   635,   636,   637,   638,   639,  1508,
     640,   217,   641,   642,   219,   643,   220,     0,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,  1510,     0,
     654,   655,     0,   656,   657,   658,   659,   660,   661,     0,
     224,   225,     0,     0,   663,  1513,   664,  1514,     0,   665,
     666,   667,   668,   669,   670,     0,     0,   671,   672,   673,
     674,   675,  1517,     0,   676,   677,   678,   679,   680,   681,
     234,     0,   682,   235,   683,   684,   685,     0,     0,   686,
       0,     0,   687,   688,   689,   690,   691,   237,  1519,  1520,
    1521,  1522,  1523,  1524,  1525,  1526,   692,   693,   694,     0,
       0,     0,   731,    86,    87,    88,   420,    90,    91,    92,
     421,     0,   422,    95,     0,  3502,    98,    99,   100,   101,
     102,   103,   732,   104,   105,   423,   733,     0,   107,   108,
     109,   110,   734,   735,   112,   113,   114,   115,     0,   116,
     736,   737,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   434,   435,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
       0,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,   448,   133,   449,   450,   451,   452,   135,   136,   137,
     138,   139,     0,   453,   454,   455,   456,   457,     0,  1472,
     458,   459,   460,   140,   461,     0,   462,   463,   464,   465,
     466,  1475,     0,   467,     0,   468,   469,   470,   471,   148,
     472,   473,     0,   474,   475,   476,   477,   478,   479,   480,
       0,   151,   481,     0,  1476,  1477,  1478,  1479,  1480,  1481,
    1482,   482,   483,   484,   485,   486,   487,   155,   156,   488,
       0,   489,     0,   490,   491,   492,   493,   494,     0,   495,
     496,   497,   498,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,     0,   510,
     511,   512,   513,   164,   514,   515,   516,  1487,     0,   517,
       0,   518,   168,   519,     0,   520,     0,   521,   169,     0,
     170,   522,   523,   524,     0,   525,  1490,     0,   526,   527,
       0,   528,   529,   530,   531,   532,   173,   533,   534,   535,
       0,   536,   537,   538,   539,   540,   541,     0,   542,   174,
     175,     0,   543,   544,   545,     0,   176,     0,   177,     0,
     546,   178,   179,   547,   180,   548,   549,   550,   551,   552,
     553,   554,     0,  1494,   182,   555,   183,     0,   556,   557,
     558,  1495,  1496,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,   188,   189,   190,   572,
     573,   574,   191,     0,   575,   576,   193,   577,     0,  1501,
     578,   195,   579,   580,   581,     0,   582,     0,     0,   583,
     584,   585,     0,     0,   196,   197,   198,   199,  1504,   586,
     587,   588,   589,   590,   591,   592,     0,   593,  1505,   594,
     202,   595,   596,   597,   598,     0,   599,   600,   601,   602,
     603,   604,   605,   204,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
       0,   621,   622,   210,   623,   624,   625,   626,   212,   627,
     628,   629,   630,   631,   632,   633,   634,     0,   635,   636,
     637,   638,   639,  1508,   640,   217,   641,   642,   219,   643,
     220,     0,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,  1510,     0,   654,   655,     0,   656,   657,   658,
     659,   660,   661,     0,   224,   225,     0,     0,   663,  1513,
     664,  1514,     0,   665,   666,   667,   668,   669,   670,     0,
       0,   671,   672,   673,   674,   675,  1517,     0,   676,   677,
     678,   679,   680,   681,   234,     0,   682,   235,   683,   684,
     685,     0,     0,   686,     0,     0,   687,   688,   689,   690,
     691,   237,  1519,  1520,  1521,  1522,  1523,  1524,  1525,  1526,
     692,   693,   694,     0,     0,     0,   731,    86,    87,    88,
     420,    90,    91,    92,   421,     0,   422,    95,     0,  4057,
      98,    99,   100,   101,   102,   103,   732,   104,   105,   423,
     733,     0,   107,   108,   109,   110,   734,   735,   112,   113,
     114,   115,     0,   116,   736,   737,   424,   425,     0,     0,
       0,   426,   427,     0,     0,     0,     0,   428,     0,     0,
       0,     0,     0,     0,     0,     0,   429,     0,   430,     0,
     431,   432,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   434,   435,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,     0,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,   448,   133,   449,   450,   451,
     452,   135,   136,   137,   138,   139,     0,   453,   454,   455,
     456,   457,     0,     0,   458,   459,   460,   140,   461,     0,
     462,   463,   464,   465,   466,   145,     0,   467,     0,   468,
     469,   470,   471,   148,   472,   473,     0,   474,   475,   476,
     477,   478,   479,   480,     0,   151,   481,     0,     0,     0,
       0,   152,     0,     0,     0,   482,   483,   484,   485,   486,
     487,   155,   156,   488,     0,   489,     0,   490,   491,   492,
     493,   494,     0,   495,   496,   497,   498,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,     0,   510,   511,   512,   513,   164,   514,   515,
     516,   166,     0,   517,     0,   518,   168,   519,     0,   520,
       0,   521,   169,     0,   170,   522,   523,   524,     0,   525,
     172,     0,   526,   527,     0,   528,   529,   530,   531,   532,
     173,   533,   534,   535,     0,   536,   537,   538,   539,   540,
     541,     0,   542,   174,   175,     0,   543,   544,   545,     0,
     176,     0,   177,     0,   546,   178,   179,   547,   180,   548,
     549,   550,   551,   552,   553,   554,     0,   181,   182,   555,
     183,     0,   556,   557,   558,     0,     0,   559,   560,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
     188,   189,   190,   572,   573,   574,   191,     0,   575,   576,
     193,   577,     0,   194,   578,   195,   579,   580,   581,     0,
     582,     0,     0,   583,   584,   585,     0,     0,   196,   197,
     198,   199,   200,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   201,   594,   202,   595,   596,   597,   598,     0,
     599,   600,   601,   602,   603,   604,   605,   204,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,   615,   616,
     617,   618,   619,   620,     0,   621,   622,   210,   623,   624,
     625,   626,   212,   627,   628,   629,   630,   631,   632,   633,
     634,     0,   635,   636,   637,   638,   639,     0,   640,   217,
     641,   642,   219,   643,   220,     0,   644,   645,   646,   647,
     648,   649,   650,   651,   652,   653,   222,     0,   654,   655,
       0,   656,   657,   658,   659,   660,   661,     0,   224,   225,
       0,     0,   663,   226,   664,   227,     0,   665,   666,   667,
     668,   669,   670,     0,     0,   671,   672,   673,   674,   675,
       0,     0,   676,   677,   678,   679,   680,   681,   234,     0,
     682,   235,   683,   684,   685,     0,     0,   686,     0,     0,
     687,   688,   689,   690,   691,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   692,   693,   694,     0,     0,     0,
       0,    86,    87,    88,   420,    90,    91,    92,   421,     0,
     422,    95,     0,  4592,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   423,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,     0,     0,
       0,     0,     0,  3986,     0,   445,   446,     0,   447,   448,
       0,   449,   450,   451,   452,   135,   136,     0,   138,   139,
       0,   453,   454,   455,   456,   457,     0,     0,   458,   459,
     460,   140,   461,     0,   462,   463,   464,   465,   466,   145,
       0,   467,     0,   468,   469,   470,   471,     0,   472,   473,
       0,   474,   475,   476,   477,   478,   479,   480,     0, -1432,
     481,     0,     0,     0,     0,     0,     0,     0,     0,   482,
     483,   484,   485,   486,   487,   155,   156,   488,     0,   489,
       0,   490,   491,   492,   493,   494,     0,   495,   496,   497,
     498,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,     0,   510,   511,   512,
     513,   164,   514,   515,   516,   166,     0,   517,     0,   518,
     168,   519,     0,   520,     0,   521,     0,     0, -1432,   522,
     523,   524,     0,   525,   172,     0,   526,   527,     0,   528,
     529,   530,   531,   532,     0,   533,   534,   535,     0,   536,
     537,   538,   539,   540,   541,     0,   542, -1432,   175,     0,
     543,   544,   545,     0,   176,     0,   177,     0,   546,     0,
       0,   547, -1432,   548,   549,   550,   551,   552,   553,   554,
       0,   181, -1432,   555,     0,     0,   556,   557,   558,     0,
       0,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   188, -1432,   190,   572,   573,   574,
     191,     0,   575,   576,     0,   577,     0,   194,   578,   195,
     579,   580,   581,     0,   582,     0,     0,   583,   584,   585,
       0,     0,   196,     0,     0,     0,   200,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   201,   594,   202,   595,
     596,   597,   598,     0,   599,   600,   601,   602,   603,   604,
     605,   204,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,     0,   621,
     622, -1432,   623,   624,   625,   626,   212,   627,   628,   629,
     630,   631,   632,   633,   634,     0,   635,   636,   637,   638,
     639,     0,   640,   217,   641,   642,     0,   643,   220,     0,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
     222,     0,   654,   655,     0,   656,   657,   658,   659,   660,
     661,     0,   224,   225,     0,     0,   663,   226,   664,   227,
       0,   665,   666,   667,   668,   669,   670,     0,     0,   671,
     672,   673,   674,   675,     0,     0,   676,   677,   678,   679,
     680,   681,   234,     0,   682,     0,   683,   684,   685,     0,
       0,   686,     0,     0,   687,   688,   689,   690,   691,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   692,   693,
     694,     0,     0,     0,     0,     0,    86,    87,    88,   420,
      90,    91,    92,   421,     0,   422,    95,     0,  1620,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   423,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   424,   425,     0,     0,     0,
     426,   427,     0,     0,     0,     0,   428,     0,     0,     0,
       0,     0,     0,     0,     0,   429,     0,   430,     0,   431,
     432,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   434,   435,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,     0,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,   448,     0,   449,   450,   451,   452,
     135,   136,     0,   138,   139,     0,   453,   454,   455,   456,
     457,     0,     0,   458,   459,   460,   140,   461,     0,   462,
     463,   464,   465,   466,   145,     0,   467,     0,   468,   469,
     470,   471,     0,   472,   473,     0,   474,   475,   476,   477,
     478,   479,   480,     0,     0,   481,     0,     0,     0,     0,
       0,     0,     0,     0,   482,   483,   484,   485,   486,   487,
     155,   156,   488,     0,   489,     0,   490,   491,   492,   493,
     494,     0,   495,   496,   497,   498,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,     0,   510,   511,   512,   513,   164,   514,   515,   516,
     166,     0,   517,     0,   518,   168,   519,     0,   520,     0,
     521,     0,     0,     0,   522,   523,   524,     0,   525,   172,
       0,   526,   527,     0,   528,   529,   530,   531,   532,     0,
     533,   534,   535,     0,   536,   537,   538,   539,   540,   541,
       0,   542,     0,   175,     0,   543,   544,   545,     0,   176,
       0,   177,     0,   546,     0,     0,   547,     0,   548,   549,
     550,   551,   552,   553,   554,     0,   181,     0,   555,     0,
       0,   556,   557,   558,     0,     0,   559,   560,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   188,
       0,   190,   572,   573,   574,   191,     0,   575,   576,     0,
     577,     0,   194,   578,   195,   579,   580,   581,     0,   582,
       0,     0,   583,   584,   585,     0,     0,   196,     0,     0,
       0,   200,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   201,   594,   202,   595,   596,   597,   598,     0,   599,
     600,   601,   602,   603,   604,   605,   204,   606,   607,   608,
     609,     0,   610,   611,   612,   613,   614,   615,   616,   617,
     618,   619,   620,     0,   621,   622,     0,   623,   624,   625,
     626,   212,   627,   628,   629,   630,   631,   632,   633,   634,
       0,   635,   636,   637,   638,   639,     0,   640,   217,   641,
     642,     0,   643,   220,     0,   644,   645,   646,   647,   648,
     649,   650,   651,   652,   653,   222,     0,   654,   655,     0,
     656,   657,   658,   659,   660,   661,     0,   224,   225,     0,
       0,   663,   226,   664,   227,     0,   665,   666,   667,   668,
     669,   670,     0,     0,   671,   672,   673,   674,   675,     0,
       0,   676,   677,   678,   679,   680,   681,   234,     0,   682,
       0,   683,   684,   685,     0,     0,   686,     0,     0,   687,
     688,   689,   690,   691,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   692,   693,   694,     0,     0,     0,     0,
       0,    86,    87,    88,   420,    90,    91,    92,   421,     0,
     422,    95,     0,  3264,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   423,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,   433,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,     0,     0,
       0,     0,     0,     0,     0,   445,   446,     0,   447,   448,
       0,   449,   450,   451,   452,   135,   136,     0,   138,   139,
       0,   453,   454,   455,   456,   457,     0,     0,   458,   459,
     460,   140,   461,     0,   462,   463,   464,   465,   466,   145,
       0,   467,     0,   468,   469,   470,   471,     0,   472,   473,
       0,   474,   475,   476,   477,   478,   479,   480,     0,     0,
     481,     0,     0,     0,     0,     0,     0,     0,     0,   482,
     483,   484,   485,   486,   487,   155,   156,   488,     0,   489,
       0,   490,   491,   492,   493,   494,     0,   495,   496,   497,
     498,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,     0,   510,   511,   512,
     513,   164,   514,   515,   516,   166,  2033,   517,     0,   518,
     168,   519,     0,   520,     0,   521,     0,     0,     0,   522,
     523,   524,     0,   525,   172,     0,   526,   527,     0,   528,
     529,   530,   531,   532,     0,   533,   534,   535,     0,   536,
     537,   538,   539,   540,   541,     0,   542,     0,   175,     0,
     543,   544,   545,     0,   176,     0,   177,     0,   546,     0,
       0,   547,     0,   548,   549,   550,   551,   552,   553,   554,
       0,   181,     0,   555,     0,     0,   556,   557,   558,     0,
       0,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   188,     0,   190,   572,   573,   574,
     191,     0,   575,   576,     0,   577,     0,   194,   578,   195,
     579,   580,   581,     0,   582,  2034,     0,   583,   584,   585,
       0,     0,   196,     0,     0,     0,   200,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   201,   594,   202,   595,
     596,   597,   598,     0,   599,   600,   601,   602,   603,   604,
     605,   204,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,     0,   621,
     622,     0,   623,   624,   625,   626,   212,   627,   628,   629,
     630,   631,   632,   633,   634,     0,   635,   636,   637,   638,
     639,     0,   640,   217,   641,   642,     0,   643,   220,     0,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
     222,     0,   654,   655,     0,   656,   657,   658,   659,   660,
     661,     0,   224,   225,     0,     0,   663,   226,   664,   227,
    2035,   665,   666,   667,   668,   669,   670,     0,     0,   671,
     672,   673,   674,   675,     0,     0,   676,   677,   678,   679,
     680,   681,   234,     0,   682,     0,   683,   684,   685,     0,
       0,   686,     0,     0,   687,   688,   689,   690,   691,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   692,   693,
     694,     0,     0,     0,     0,     0,     0,     0,  1000,  1663,
    4165,     0,     0,     0,     0,     0,     0,  4166,    86,    87,
      88,   420,    90,    91,    92,   421,     0,   422,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     423,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   424,   425,     0,
       0,     0,   426,   427,     0,     0,     0,     0,   428,     0,
       0,     0,     0,     0,     0,     0,     0,   429,     0,   430,
       0,   431,   432,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,    45,     0,
       0,     0,     0,   434,   435,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,     0,     0,     0,     0,     0,
       0,     0,   445,   446,     0,   447,   448,     0,   449,   450,
     451,   452,   135,   136,     0,   138,   139,     0,   453,   454,
     455,   456,   457,     0,     0,   458,   459,   460,   140,   461,
       0,   462,   463,   464,   465,   466,   145,     0,   467,     0,
     468,   469,   470,   471,     0,   472,   473,     0,   474,   475,
     476,   477,   478,   479,   480,     0,     0,   481,     0,     0,
       0,     0,     0,     0,     0,     0,   482,   483,   484,   485,
     486,   487,   155,   156,   488,     0,   489,     0,   490,   491,
     492,   493,   494,     0,   495,   496,   497,   498,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,     0,   510,   511,   512,   513,   164,   514,
     515,   516,   166,     0,   517,     0,   518,   168,   519,     0,
     520,     0,   521,     0,     0,     0,   522,   523,   524,     0,
     525,   172,     0,   526,   527,     0,   528,   529,   530,   531,
     532,     0,   533,   534,   535,     0,   536,   537,   538,   539,
     540,   541,     0,   542,     0,   175,     0,   543,   544,   545,
       0,   176,     0,   177,     0,   546,     0,     0,   547,     0,
     548,   549,   550,   551,   552,   553,   554,     0,   181,     0,
     555,     0,     0,   556,   557,   558,     0,     0,   559,   560,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,   188,     0,   190,   572,   573,   574,   191,     0,   575,
     576,     0,   577,     0,   194,   578,   195,   579,   580,   581,
       0,   582,     0,     0,   583,   584,   585,     0,     0,   196,
       0,     0,     0,   200,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   201,   594,   202,   595,   596,   597,   598,
       0,   599,   600,   601,   602,   603,   604,   605,   204,   606,
     607,   608,   609,     0,   610,   611,   612,   613,   614,   615,
     616,   617,   618,   619,   620,     0,   621,   622,     0,   623,
     624,   625,   626,   212,   627,   628,   629,   630,   631,   632,
     633,   634,     0,   635,   636,   637,   638,   639,     0,   640,
     217,   641,   642,     0,   643,   220,     0,   644,   645,   646,
     647,   648,   649,   650,   651,   652,   653,   222,     0,   654,
     655,     0,   656,   657,   658,   659,   660,   661,     0,   224,
     225,     0,     0,   663,   226,   664,   227,     0,   665,   666,
     667,   668,   669,   670,     0,     0,   671,   672,   673,   674,
     675,     0,     0,   676,   677,   678,   679,   680,   681,   234,
       0,   682,     0,   683,   684,   685,     0,     0,   686,     0,
       0,   687,   688,   689,   690,   691,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   692,   693,   694,     0,     0,
       0,     0,    86,    87,    88,   420,    90,    91,    92,   421,
       0,   422,    95,  3766,  3767,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   423,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   424,   425,     0,     0,     0,   426,   427,     0,     0,
       0,     0,   428,     0,     0,     0,     0,     0,     0,     0,
       0,   429,     0,   430,     0,   431,   432,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   434,   435,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   130,
     131,     0,     0,     0,     0,     0,   445,   446,     0,   447,
     448,     0,   449,   450,   451,   452,   135,   136,     0,   138,
     139,     0,   453,   454,   455,   456,   457,     0,     0,   458,
     459,   460,   140,   461,     0,   462,   463,   464,   465,   466,
     145,     0,   467,     0,   468,   469,   470,   471,     0,   472,
     473,     0,   474,   475,   476,   477,   478,   479,   480,     0,
       0,   481,     0,     0,     0,     0,     0,     0,     0,     0,
     482,   483,   484,   485,   486,   487,   155,   156,   488,     0,
     489,     0,   490,   491,   492,   493,   494,     0,   495,   496,
     497,   498,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,     0,   510,   511,
     512,   513,   164,   514,   515,   516,   166,     0,   517,     0,
     518,   168,   519,     0,   520,     0,   521,     0,     0,     0,
     522,   523,   524,     0,   525,   172,     0,   526,   527,     0,
     528,   529,   530,   531,   532,     0,   533,   534,   535,     0,
     536,   537,   538,   539,   540,   541,     0,   542,     0,   175,
       0,   543,   544,   545,     0,   176,     0,   177,     0,   546,
       0,     0,   547,     0,   548,   549,   550,   551,   552,   553,
     554,     0,   181,     0,   555,     0,     0,   556,   557,   558,
       0,     0,   559,   560,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   188,     0,   190,   572,   573,
     574,   191,     0,   575,   576,     0,   577,     0,   194,   578,
     195,   579,   580,   581,     0,   582,     0,     0,   583,   584,
     585,     0,     0,   196,     0,     0,     0,   200,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   201,   594,   202,
     595,   596,   597,   598,     0,   599,   600,   601,   602,   603,
     604,   605,   204,   606,   607,   608,   609,     0,   610,   611,
     612,   613,   614,   615,   616,   617,   618,   619,   620,     0,
     621,   622,     0,   623,   624,   625,   626,   212,   627,   628,
     629,   630,   631,   632,   633,   634,   215,   635,   636,   637,
     638,   639,     0,   640,   217,   641,   642,     0,   643,   220,
       0,   644,   645,   646,   647,   648,   649,   650,   651,   652,
     653,   222,     0,   654,   655,   223,   656,   657,   658,   659,
     660,   661,     0,   224,   225,     0,     0,   663,   226,   664,
     227,     0,   665,   666,   667,   668,   669,   670,     0,     0,
     671,   672,   673,   674,   675,     0,     0,   676,   677,   678,
     679,   680,  1389,   234,     0,   682,  1390,   683,   684,   685,
       0,     0,   686,     0,   236,   687,   688,   689,   690,   691,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   692,
     693,   694,     0,     0,     0,     0,    86,    87,    88,   420,
      90,    91,    92,   421,     0,   422,    95,     0,   246,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   423,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   424,   425,     0,     0,     0,
     426,   427,     0,     0,     0,     0,   428,     0,     0,     0,
       0,     0,     0,     0,     0,   429,     0,   430,     0,   431,
     432,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,    45,     0,     0,     0,
       0,   434,   435,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,     0,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,   448,     0,   449,   450,   451,   452,
     135,   136,     0,   138,   139,     0,   453,   454,   455,   456,
     457,     0,     0,   458,   459,   460,   140,   461,     0,   462,
     463,   464,   465,   466,   145,     0,   467,     0,   468,   469,
     470,   471,     0,   472,   473,     0,   474,   475,   476,   477,
     478,   479,   480,     0,     0,   481,     0,     0,     0,     0,
       0,     0,     0,     0,   482,   483,   484,   485,   486,   487,
     155,   156,   488,     0,   489,     0,   490,   491,   492,   493,
     494,     0,   495,   496,   497,   498,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,     0,   510,   511,   512,   513,   164,   514,   515,   516,
     166,     0,   517,     0,   518,   168,   519,     0,   520,     0,
     521,     0,     0,     0,   522,   523,   524,     0,   525,   172,
       0,   526,   527,     0,   528,   529,   530,   531,   532,     0,
     533,   534,   535,     0,   536,   537,   538,   539,   540,   541,
       0,   542,     0,   175,     0,   543,   544,   545,     0,   176,
       0,   177,     0,   546,     0,     0,   547,     0,   548,   549,
     550,   551,   552,   553,   554,     0,   181,     0,   555,     0,
       0,   556,   557,   558,     0,     0,   559,   560,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   188,
       0,   190,   572,   573,   574,   191,     0,   575,   576,     0,
     577,     0,   194,   578,   195,   579,   580,   581,     0,   582,
       0,     0,   583,   584,   585,     0,     0,   196,     0,     0,
       0,   200,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   201,   594,   202,   595,   596,   597,   598,     0,   599,
     600,   601,   602,   603,   604,   605,   204,   606,   607,   608,
     609,     0,   610,   611,   612,   613,   614,   615,   616,   617,
     618,   619,   620,     0,   621,   622,     0,   623,   624,   625,
     626,   212,   627,   628,   629,   630,   631,   632,   633,   634,
       0,   635,   636,   637,   638,   639,     0,   640,   217,   641,
     642,     0,   643,   220,     0,   644,   645,   646,   647,   648,
     649,   650,   651,   652,   653,   222,     0,   654,   655,     0,
     656,   657,   658,   659,   660,   661,     0,   224,   225,     0,
       0,   663,   226,   664,   227,     0,   665,   666,   667,   668,
     669,   670,     0,     0,   671,   672,   673,   674,   675,     0,
       0,   676,   677,   678,   679,   680,   681,   234,     0,   682,
       0,   683,   684,   685,     0,     0,   686,     0,     0,   687,
     688,   689,   690,   691,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   692,   693,   694,     0,     0,     0,     0,
      86,    87,    88,   420,    90,    91,    92,   421,     0,   422,
      95,     0,  3767,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   423,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   424,
     425,     0,     0,     0,   426,   427,     0,     0,     0,     0,
     428,     0,     0,     0,     0,     0,     0,     0,     0,   429,
       0,   430,     0,   431,   432,    35,   433,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   434,   435,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,     0,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,   448,     0,
     449,   450,   451,   452,   135,   136,     0,   138,   139,     0,
     453,   454,   455,   456,   457,     0,     0,   458,   459,   460,
     140,   461,     0,   462,   463,   464,   465,   466,   145,     0,
     467,     0,   468,   469,   470,   471,     0,   472,   473,     0,
     474,   475,   476,   477,   478,   479,   480,     0,     0,   481,
       0,     0,     0,     0,     0,     0,     0,     0,   482,   483,
     484,   485,   486,   487,   155,   156,   488,     0,   489,     0,
     490,   491,   492,   493,   494,     0,   495,   496,   497,   498,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,     0,   510,   511,   512,   513,
     164,   514,   515,   516,   166,     0,   517,     0,   518,   168,
     519,     0,   520,     0,   521,     0,     0,     0,   522,   523,
     524,     0,   525,   172,     0,   526,   527,     0,   528,   529,
     530,   531,   532,     0,   533,   534,   535,     0,   536,   537,
     538,   539,   540,   541,     0,   542,     0,   175,     0,   543,
     544,   545,     0,   176,     0,   177,     0,   546,     0,     0,
     547,     0,   548,   549,   550,   551,   552,   553,   554,     0,
     181,     0,   555,     0,     0,   556,   557,   558,     0,     0,
     559,   560,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   188,     0,   190,   572,   573,   574,   191,
       0,   575,   576,     0,   577,     0,   194,   578,   195,   579,
     580,   581,     0,   582,     0,     0,   583,   584,   585,     0,
       0,   196,     0,     0,     0,   200,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   201,   594,   202,   595,   596,
     597,   598,     0,   599,   600,   601,   602,   603,   604,   605,
     204,   606,   607,   608,   609,     0,   610,   611,   612,   613,
     614,   615,   616,   617,   618,   619,   620,     0,   621,   622,
       0,   623,   624,   625,   626,   212,   627,   628,   629,   630,
     631,   632,   633,   634,   215,   635,   636,   637,   638,   639,
       0,   640,   217,   641,   642,     0,   643,   220,     0,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   222,
       0,   654,   655,   223,   656,   657,   658,   659,   660,   661,
       0,   224,   225,     0,     0,   663,   226,   664,   227,     0,
     665,   666,   667,   668,   669,   670,     0,     0,   671,   672,
     673,   674,   675,     0,     0,   676,   677,   678,   679,   680,
    1389,   234,     0,   682,     0,   683,   684,   685,     0,     0,
     686,     0,   236,   687,   688,   689,   690,   691,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   692,   693,   694,
       0,     0,     0,     0,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,   246,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,   215,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,   223,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,  1389,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,   236,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,     0,     0,     0,     0,    86,    87,
      88,   420,    90,    91,    92,   421,     0,   422,    95,     0,
     246,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     423,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   424,   425,     0,
       0,     0,   426,   427,     0,     0,     0,     0,   428,     0,
       0,     0,     0,     0,     0,     0,     0,   429,     0,   430,
       0,   431,   432,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   434,   435,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,     0,     0,     0,     0,     0,
       0,     0,   445,   446,     0,   447,   448,     0,   449,   450,
     451,   452,   135,   136,     0,   138,   139,     0,   453,   454,
     455,   456,   457,     0,     0,   458,   459,   460,   140,   461,
       0,   462,   463,   464,   465,   466,   145,     0,   467,     0,
     468,   469,   470,   471,     0,   472,   473,     0,   474,   475,
     476,   477,   478,   479,   480,     0,     0,   481,     0,     0,
       0,     0,     0,     0,     0,     0,   482,   483,   484,   485,
     486,   487,   155,   156,   488,     0,   489,     0,   490,   491,
     492,   493,   494,     0,   495,   496,   497,   498,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,     0,   510,   511,   512,   513,   164,   514,
     515,   516,   166,     0,   517,     0,   518,   168,   519,     0,
     520,     0,   521,     0,     0,     0,   522,   523,   524,     0,
     525,   172,     0,   526,   527,     0,   528,   529,   530,   531,
     532,     0,   533,   534,   535,     0,   536,   537,   538,   539,
     540,   541,     0,   542,     0,   175,     0,   543,   544,   545,
       0,   176,     0,   177,     0,   546,     0,     0,   547,     0,
     548,   549,   550,   551,   552,   553,   554,     0,   181,     0,
     555,     0,     0,   556,   557,   558,     0,     0,   559,   560,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,   188,     0,   190,   572,   573,   574,   191,     0,   575,
     576,     0,   577,     0,   194,   578,   195,   579,   580,   581,
       0,   582,     0,     0,   583,   584,   585,     0,     0,   196,
       0,     0,     0,   200,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   201,   594,   202,   595,   596,   597,   598,
       0,   599,   600,   601,   602,   603,   604,   605,   204,   606,
     607,   608,   609,     0,   610,   611,   612,   613,   614,   615,
     616,   617,   618,   619,   620,     0,   621,   622,     0,   623,
     624,   625,   626,   212,   627,   628,   629,   630,   631,   632,
     633,   634,     0,   635,   636,   637,   638,   639,     0,   640,
     217,   641,   642,     0,   643,   220,     0,   644,   645,   646,
     647,   648,   649,   650,   651,   652,   653,   222,     0,   654,
     655,     0,   656,   657,   658,   659,   660,   661,     0,   224,
     225,     0,     0,   663,   226,   664,   227,     0,   665,   666,
     667,   668,   669,   670,     0,     0,   671,   672,   673,   674,
     675,     0,     0,   676,   677,   678,   679,   680,   681,   234,
       0,   682,     0,   683,   684,   685,     0,     0,   686,     0,
       0,   687,   688,   689,   690,   691,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   692,   693,   694,     0,     0,
       0,     0,    86,    87,    88,   420,    90,    91,    92,   421,
       0,   422,    95,     0,  1595,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   423,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   424,   425,     0,     0,     0,   426,   427,     0,     0,
       0,     0,   428,     0,     0,     0,     0,     0,     0,     0,
       0,   429,     0,   430,     0,   431,   432,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   434,   435,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,     0,
       0,     0,     0,     0,     0,     0,   445,   446,     0,   447,
     448,     0,   449,   450,   451,   452,   135,   136,     0,   138,
     139,     0,   453,   454,   455,   456,   457,     0,     0,   458,
     459,   460,   140,   461,     0,   462,   463,   464,   465,   466,
     145,     0,   467,     0,   468,   469,   470,   471,     0,   472,
     473,     0,   474,   475,   476,   477,   478,   479,   480,     0,
       0,   481,     0,     0,     0,     0,     0,     0,     0,     0,
     482,   483,   484,   485,   486,   487,   155,   156,   488,     0,
     489,     0,   490,   491,   492,   493,   494,     0,   495,   496,
     497,   498,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,     0,   510,   511,
     512,   513,   164,   514,   515,   516,   166,     0,   517,     0,
     518,   168,   519,     0,   520,     0,   521,     0,     0,     0,
     522,   523,   524,     0,   525,   172,     0,   526,   527,     0,
     528,   529,   530,   531,   532,     0,   533,   534,   535,     0,
     536,   537,   538,   539,   540,   541,     0,   542,     0,   175,
       0,   543,   544,   545,     0,   176,     0,   177,     0,   546,
       0,     0,   547,     0,   548,   549,   550,   551,   552,   553,
     554,     0,   181,     0,   555,     0,     0,   556,   557,   558,
       0,     0,   559,   560,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   188,     0,   190,   572,   573,
     574,   191,     0,   575,   576,     0,   577,     0,   194,   578,
     195,   579,   580,   581,     0,   582,     0,     0,   583,   584,
     585,     0,     0,   196,     0,     0,     0,   200,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   201,   594,   202,
     595,   596,   597,   598,     0,   599,   600,   601,   602,   603,
     604,   605,   204,   606,   607,   608,   609,     0,   610,   611,
     612,   613,   614,   615,   616,   617,   618,   619,   620,     0,
     621,   622,     0,   623,   624,   625,   626,   212,   627,   628,
     629,   630,   631,   632,   633,   634,     0,   635,   636,   637,
     638,   639,     0,   640,   217,   641,   642,     0,   643,   220,
       0,   644,   645,   646,   647,   648,   649,   650,   651,   652,
     653,   222,     0,   654,   655,     0,   656,   657,   658,   659,
     660,   661,     0,   224,   225,     0,     0,   663,   226,   664,
     227,     0,   665,   666,   667,   668,   669,   670,     0,     0,
     671,   672,   673,   674,   675,     0,     0,   676,   677,   678,
     679,   680,   681,   234,     0,   682,     0,   683,   684,   685,
       0,     0,   686,     0,     0,   687,   688,   689,   690,   691,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   692,
     693,   694,     0,     0,     0,     0,    86,    87,    88,   420,
      90,    91,    92,   421,     0,   422,    95,     0,  2969,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   423,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   424,   425,     0,     0,     0,
     426,   427,     0,     0,     0,     0,   428,     0,     0,     0,
       0,     0,     0,     0,     0,   429,     0,   430,     0,   431,
     432,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   434,   435,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,     0,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,   448,     0,   449,   450,   451,   452,
     135,   136,     0,   138,   139,     0,   453,   454,   455,   456,
     457,     0,     0,   458,   459,   460,   140,   461,     0,   462,
     463,   464,   465,   466,   145,     0,   467,     0,   468,   469,
     470,   471,     0,   472,   473,     0,   474,   475,   476,   477,
     478,   479,   480,     0,     0,   481,     0,     0,     0,     0,
       0,     0,     0,     0,   482,   483,   484,   485,   486,   487,
     155,   156,   488,     0,   489,     0,   490,   491,   492,   493,
     494,     0,   495,   496,   497,   498,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,     0,   510,   511,   512,   513,   164,   514,   515,   516,
     166,     0,   517,     0,   518,   168,   519,     0,   520,     0,
     521,     0,     0,     0,   522,   523,   524,     0,   525,   172,
       0,   526,   527,     0,   528,   529,   530,   531,   532,     0,
     533,   534,   535,     0,   536,   537,   538,   539,   540,   541,
       0,   542,     0,   175,     0,   543,   544,   545,     0,   176,
       0,   177,     0,   546,     0,     0,   547,     0,   548,   549,
     550,   551,   552,   553,   554,     0,   181,     0,   555,     0,
       0,   556,   557,   558,     0,     0,   559,   560,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   188,
       0,   190,   572,   573,   574,   191,     0,   575,   576,     0,
     577,     0,   194,   578,   195,   579,   580,   581,     0,   582,
       0,     0,   583,   584,   585,     0,     0,   196,     0,     0,
       0,   200,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   201,   594,   202,   595,   596,   597,   598,     0,   599,
     600,   601,   602,   603,   604,   605,   204,   606,   607,   608,
     609,     0,   610,   611,   612,   613,   614,   615,   616,   617,
     618,   619,   620,     0,   621,   622,     0,   623,   624,   625,
     626,   212,   627,   628,   629,   630,   631,   632,   633,   634,
       0,   635,   636,   637,   638,   639,     0,   640,   217,   641,
     642,     0,   643,   220,     0,   644,   645,   646,   647,   648,
     649,   650,   651,   652,   653,   222,     0,   654,   655,     0,
     656,   657,   658,   659,   660,   661,     0,   224,   225,     0,
       0,   663,   226,   664,   227,     0,   665,   666,   667,   668,
     669,   670,     0,     0,   671,   672,   673,   674,   675,     0,
       0,   676,   677,   678,   679,   680,   681,   234,     0,   682,
       0,   683,   684,   685,     0,     0,   686,     0,     0,   687,
     688,   689,   690,   691,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   692,   693,   694,     0,     0,     0,     0,
      86,    87,    88,   420,    90,    91,    92,   421,     0,   422,
      95,     0,  4013,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   423,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   424,
     425,     0,     0,     0,   426,   427,     0,     0,     0,     0,
     428,     0,     0,     0,     0,     0,     0,     0,     0,   429,
       0,   430,     0,   431,   432,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   434,   435,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,     0,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,   448,     0,
     449,   450,   451,   452,   135,   136,     0,   138,   139,     0,
     453,   454,   455,   456,   457,     0,     0,   458,   459,   460,
     140,   461,     0,   462,   463,   464,   465,   466,   145,     0,
     467,     0,   468,   469,   470,   471,     0,   472,   473,     0,
     474,   475,   476,   477,   478,   479,   480,     0,     0,   481,
       0,     0,     0,     0,     0,     0,     0,     0,   482,   483,
     484,   485,   486,   487,   155,   156,   488,     0,   489,     0,
     490,   491,   492,   493,   494,     0,   495,   496,   497,   498,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,     0,   510,   511,   512,   513,
     164,   514,   515,   516,   166,     0,   517,     0,   518,   168,
     519,     0,   520,     0,   521,     0,     0,     0,   522,   523,
     524,     0,   525,   172,     0,   526,   527,     0,   528,   529,
     530,   531,   532,     0,   533,   534,   535,     0,   536,   537,
     538,   539,   540,   541,     0,   542,     0,   175,     0,   543,
     544,   545,     0,   176,     0,   177,     0,   546,     0,     0,
     547,     0,   548,   549,   550,   551,   552,   553,   554,     0,
     181,     0,   555,     0,     0,   556,   557,   558,     0,     0,
     559,   560,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   188,     0,   190,   572,   573,   574,   191,
       0,   575,   576,     0,   577,     0,   194,   578,   195,   579,
     580,   581,     0,   582,     0,     0,   583,   584,   585,     0,
       0,   196,     0,     0,     0,   200,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   201,   594,   202,   595,   596,
     597,   598,     0,   599,   600,   601,   602,   603,   604,   605,
     204,   606,   607,   608,   609,     0,   610,   611,   612,   613,
     614,   615,   616,   617,   618,   619,   620,     0,   621,   622,
       0,   623,   624,   625,   626,   212,   627,   628,   629,   630,
     631,   632,   633,   634,     0,   635,   636,   637,   638,   639,
       0,   640,   217,   641,   642,     0,   643,   220,     0,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   222,
       0,   654,   655,     0,   656,   657,   658,   659,   660,   661,
       0,   224,   225,     0,     0,   663,   226,   664,   227,     0,
     665,   666,   667,   668,   669,   670,     0,     0,   671,   672,
     673,   674,   675,     0,     0,   676,   677,   678,   679,   680,
     681,   234,     0,   682,     0,   683,   684,   685,     0,     0,
     686,     0,     0,   687,   688,   689,   690,   691,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   692,   693,   694,
       0,     0,     0,   731,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,  4345,    98,    99,   100,
     101,   102,   103,   732,   104,   105,   423,   733,     0,   107,
     108,   109,   110,   734,   735,   112,   113,   114,   115,     0,
     116,   736,   737,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,     0,     0,  1205,    45,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,   738,   442,   443,
     444,   739,   740,   741,   742,   743,   744,   745,   445,   446,
     746,   447,   448,   133,   449,   450,   451,   452,     0,  1878,
     137,  1879,  1880,   747,   453,   454,   455,   456,   457,   748,
     749,   458,   459,  1881,  1882,   461,   751,   462,   463,   464,
     465,   466,     0,   752,   467,   753,   468,   469,   470,   471,
     148,   472,   473,   755,   474,   475,   476,   477,   478,   479,
     480,   756,   151,   481,     0,   758,   759,   760,   152,   761,
     762,   763,   482,   483,   484,   485,   486,   487,  1883,  1884,
     488,   764,   489,   765,   490,   491,   492,   493,   494,   766,
     495,   496,   497,   498,   767,   499,   768,   500,   501,  1485,
     503,   504,   769,   505,   506,   507,   770,   508,   509,   771,
     510,   511,   512,   513,     0,   514,   515,   516,     0,   772,
     517,   773,   518,  1885,   519,   774,   520,   775,   521,   169,
     776,   170,   522,   523,   524,   777,   525,     0,   778,   526,
     527,   779,   528,   529,   530,   531,   532,   173,   533,   534,
     535,   780,   536,   537,   538,   539,   540,   541,   781,   542,
     174,     0,     0,   543,   544,   545,  1491,  1886,   784,  1887,
     785,   546,   178,   179,   547,   180,   548,   549,   550,   551,
     552,   553,   554,   786,     0,   182,   555,   183,   787,   556,
     557,   558,   788,   789,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,  1888,   189,  1889,
     572,   573,   574,     0,   790,   575,   576,   193,   577,   791,
       0,   578,  1890,   579,   580,   581,   792,   582,   793,   794,
    3753,   584,   585,   795,   796,     0,   197,   198,   199,     0,
     586,   587,   588,   589,   590,   591,   592,   797,   593,     0,
     594,     0,   595,   596,   597,   598,   798,   599,   600,   601,
     602,   603,   604,   605,  1891,   606,   607,   608,   609,   799,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   800,   621,   622,   210,   623,   624,   625,   626,     0,
     627,   628,   629,   630,   631,   632,   633,   634,   801,   635,
     636,   637,   638,   639,   802,   640,  2433,   641,   642,   219,
     643,  1893,   803,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,     0,   804,   654,   655,   805,   656,   657,
     658,   659,   660,   661,   806,  1894,  1895,     0,   808,   663,
       0,   664,     0,   809,   665,   666,   667,   668,   669,   670,
       0,   811,   671,   672,   673,   674,   675,   812,   813,   676,
     677,   678,   679,   680,     0,  1896,   815,   682,   235,   683,
     684,   685,   816,   817,   686,   818,   819,   687,   688,   689,
     690,   691,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   692,   693,   694,     0,     0,     0,  1208,  1209,  1210,
       0,  3754,  3755,  1213,  1214,  1215,  1216,    86,    87,    88,
     420,    90,    91,    92,   421,     0,   422,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   423,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   424,   425,     0,     0,
       0,   426,   427,     0,     0,     0,     0,   428,     0,     0,
       0,     0,     0,     0,     0,     0,   429,     0,   430,     0,
     431,   432,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,  1205,     0,     0,     0,
       0,     0,   434,   435,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,     0,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,   448,     0,   449,   450,   451,
     452,   135,   136,     0,   138,   139,     0,   453,   454,   455,
     456,   457,     0,     0,   458,   459,   460,   140,   461,     0,
     462,  1206,   464,   465,   466,   145,     0,   467,     0,   468,
     469,   470,   471,     0,   472,   473,     0,   474,   475,   476,
     477,   478,   479,   480,     0,     0,   481,     0,     0,     0,
       0,     0,     0,     0,     0,   482,   483,   484,   485,   486,
     487,   155,   156,   488,     0,   489,     0,   490,   491,   492,
     493,   494,     0,   495,   496,   497,   498,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,     0,   510,   511,   512,   513,   164,   514,   515,
     516,   166,     0,  1207,     0,   518,   168,   519,     0,   520,
       0,   521,     0,     0,     0,   522,   523,   524,     0,   525,
     172,     0,   526,   527,     0,   528,   529,   530,   531,   532,
       0,   533,   534,   535,     0,   536,   537,   538,   539,   540,
     541,     0,   542,     0,   175,     0,   543,   544,   545,     0,
     176,     0,   177,     0,   546,     0,     0,   547,     0,   548,
     549,   550,   551,   552,   553,   554,     0,   181,     0,   555,
       0,     0,   556,   557,   558,     0,     0,   559,   560,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
     188,     0,   190,   572,   573,   574,   191,     0,   575,   576,
       0,   577,     0,   194,   578,   195,   579,   580,   581,     0,
     582,     0,     0,   583,   584,   585,     0,     0,   196,     0,
       0,     0,   200,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   201,   594,   202,   595,   596,   597,   598,     0,
     599,   600,   601,   602,   603,   604,   605,   204,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,   615,   616,
     617,   618,   619,   620,     0,   621,   622,     0,   623,   624,
     625,   626,   212,   627,   628,   629,   630,   631,   632,   633,
     634,     0,   635,   636,   637,   638,   639,     0,   640,   217,
     641,   642,     0,   643,   220,     0,   644,   645,   646,   647,
     648,   649,   650,   651,   652,   653,   222,     0,   654,   655,
       0,   656,   657,   658,   659,   660,   661,     0,   224,   225,
       0,     0,   663,   226,   664,   227,     0,   665,   666,   667,
     668,   669,   670,     0,     0,   671,   672,   673,   674,   675,
       0,     0,   676,   677,   678,   679,   680,   681,   234,     0,
     682,     0,   683,   684,   685,     0,     0,   686,     0,     0,
     687,   688,   689,   690,   691,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   692,   693,   694,     0,     0,     0,
    1208,  1209,  1210,     0,  1211,  1212,  1213,  1214,  1215,  1216,
      86,    87,    88,   420,    90,    91,    92,   421,     0,   422,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   423,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   424,
     425,     0,     0,     0,   426,   427,     0,     0,     0,     0,
     428,     0,     0,     0,     0,     0,     0,     0,     0,   429,
       0,   430,     0,   431,   432,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,  1205,
       0,     0,     0,     0,     0,   434,   435,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,     0,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,   448,     0,
     449,   450,   451,   452,   135,   136,     0,   138,   139,     0,
     453,   454,   455,   456,   457,     0,     0,   458,   459,   460,
     140,   461,     0,   462,  1296,   464,   465,   466,   145,     0,
     467,     0,   468,   469,   470,   471,     0,   472,   473,     0,
     474,   475,   476,   477,   478,   479,   480,     0,     0,   481,
       0,     0,     0,     0,     0,     0,     0,     0,   482,   483,
     484,   485,   486,   487,   155,   156,   488,     0,   489,     0,
     490,   491,   492,   493,   494,     0,   495,   496,   497,   498,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,     0,   510,   511,   512,   513,
     164,   514,   515,   516,   166,     0,  1297,     0,   518,   168,
     519,     0,   520,     0,   521,     0,     0,     0,   522,   523,
     524,     0,   525,   172,     0,   526,   527,     0,   528,   529,
     530,   531,   532,     0,   533,   534,   535,     0,   536,   537,
     538,   539,   540,   541,     0,   542,     0,   175,     0,   543,
     544,   545,     0,   176,     0,   177,     0,   546,     0,     0,
     547,     0,   548,   549,   550,   551,   552,   553,   554,     0,
     181,     0,   555,     0,     0,   556,   557,   558,     0,     0,
     559,   560,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   188,     0,   190,   572,   573,   574,   191,
       0,   575,   576,     0,   577,     0,   194,   578,   195,   579,
     580,   581,     0,   582,     0,     0,   583,   584,   585,     0,
       0,   196,     0,     0,     0,   200,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   201,   594,   202,   595,   596,
     597,   598,     0,   599,   600,   601,   602,   603,   604,   605,
     204,   606,   607,   608,   609,     0,   610,   611,   612,   613,
     614,   615,   616,   617,   618,   619,   620,     0,   621,   622,
       0,   623,   624,   625,   626,   212,   627,   628,   629,   630,
     631,   632,   633,   634,     0,   635,   636,   637,   638,   639,
       0,   640,   217,   641,   642,     0,   643,   220,     0,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   222,
       0,   654,   655,     0,   656,   657,   658,   659,   660,   661,
       0,   224,   225,     0,     0,   663,   226,   664,   227,     0,
     665,   666,   667,   668,   669,   670,     0,     0,   671,   672,
     673,   674,   675,     0,     0,   676,   677,   678,   679,   680,
     681,   234,     0,   682,     0,   683,   684,   685,     0,     0,
     686,     0,     0,   687,   688,   689,   690,   691,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   692,   693,   694,
       0,     0,     0,  1208,  1209,  1210,     0,  1211,  1212,  1213,
    1214,  1215,  1216,    86,    87,    88,   420,    90,    91,    92,
     421,     0,   422,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   423,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,  1205,     0,     0,     0,     0,     0,   434,   435,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
       0,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,   448,     0,   449,   450,   451,   452,   135,   136,     0,
     138,   139,     0,   453,   454,   455,   456,   457,     0,     0,
     458,   459,   460,   140,   461,     0,   462,  1349,   464,   465,
     466,   145,     0,   467,     0,   468,   469,   470,   471,     0,
     472,   473,     0,   474,   475,   476,   477,   478,   479,   480,
       0,     0,   481,     0,     0,     0,     0,     0,     0,     0,
       0,   482,   483,   484,   485,   486,   487,   155,   156,   488,
       0,   489,     0,   490,   491,   492,   493,   494,     0,   495,
     496,   497,   498,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,     0,   510,
     511,   512,   513,   164,   514,   515,   516,   166,     0,  1350,
       0,   518,   168,   519,     0,   520,     0,   521,     0,     0,
       0,   522,   523,   524,     0,   525,   172,     0,   526,   527,
       0,   528,   529,   530,   531,  1351,     0,   533,   534,   535,
       0,   536,   537,   538,   539,   540,   541,     0,   542,     0,
     175,     0,   543,   544,   545,     0,   176,     0,   177,     0,
     546,     0,     0,   547,     0,   548,   549,   550,   551,   552,
     553,   554,     0,   181,     0,   555,     0,     0,   556,   557,
     558,     0,     0,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,   188,     0,   190,   572,
     573,   574,   191,     0,   575,   576,     0,   577,     0,   194,
     578,   195,   579,   580,   581,     0,   582,     0,     0,   583,
     584,   585,     0,     0,   196,     0,     0,     0,   200,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   201,   594,
     202,   595,   596,   597,   598,     0,   599,   600,   601,   602,
     603,   604,   605,   204,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
       0,   621,   622,     0,   623,   624,   625,   626,   212,   627,
     628,   629,   630,   631,   632,   633,   634,     0,   635,   636,
     637,   638,   639,     0,   640,   217,   641,   642,     0,   643,
     220,     0,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,   222,     0,   654,   655,     0,   656,   657,   658,
     659,   660,   661,     0,   224,   225,     0,     0,   663,   226,
     664,   227,     0,   665,   666,   667,   668,   669,   670,     0,
       0,   671,   672,   673,   674,   675,     0,     0,   676,   677,
     678,   679,   680,   681,   234,     0,   682,     0,   683,   684,
     685,     0,     0,   686,     0,     0,   687,   688,   689,   690,
     691,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     692,   693,   694,     0,     0,     0,  1208,  1209,  1210,     0,
    1211,  1212,  1213,  1214,  1215,  1216,    86,    87,    88,   420,
      90,    91,    92,   421,     0,   422,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   423,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   424,   425,     0,     0,     0,
     426,   427,     0,     0,     0,     0,   428,     0,     0,     0,
       0,     0,     0,     0,     0,   429,     0,   430,     0,   431,
     432,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,  1205,     0,     0,     0,     0,
       0,   434,   435,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,     0,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,   448,     0,   449,   450,   451,   452,
     135,   136,     0,   138,   139,     0,   453,   454,   455,   456,
     457,     0,     0,   458,   459,   460,   140,   461,     0,   462,
    1861,   464,   465,   466,   145,     0,   467,     0,   468,   469,
     470,   471,     0,   472,   473,     0,   474,   475,   476,   477,
     478,   479,   480,     0,     0,   481,     0,     0,     0,     0,
       0,     0,     0,     0,   482,   483,   484,   485,   486,   487,
     155,   156,   488,     0,   489,     0,   490,   491,   492,   493,
     494,     0,   495,   496,   497,   498,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,     0,   510,   511,   512,   513,   164,   514,   515,   516,
     166,     0,  1862,     0,   518,   168,   519,     0,   520,     0,
     521,     0,     0,     0,   522,   523,   524,     0,   525,   172,
       0,   526,   527,     0,   528,   529,   530,   531,   532,     0,
     533,   534,   535,     0,   536,   537,   538,   539,   540,   541,
       0,   542,     0,   175,     0,   543,   544,   545,     0,   176,
       0,   177,     0,   546,     0,     0,   547,     0,   548,   549,
     550,   551,   552,   553,   554,     0,   181,     0,   555,     0,
       0,   556,   557,   558,     0,     0,   559,   560,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   188,
       0,   190,   572,   573,   574,   191,     0,   575,   576,     0,
     577,     0,   194,   578,   195,   579,   580,   581,     0,   582,
       0,     0,   583,   584,   585,     0,     0,   196,     0,     0,
       0,   200,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   201,   594,   202,   595,   596,   597,   598,     0,   599,
     600,   601,   602,   603,   604,   605,   204,   606,   607,   608,
     609,     0,   610,   611,   612,   613,   614,   615,   616,   617,
     618,   619,   620,     0,   621,   622,     0,   623,   624,   625,
     626,   212,   627,   628,   629,   630,   631,   632,   633,   634,
       0,   635,   636,   637,   638,   639,     0,   640,   217,   641,
     642,     0,   643,   220,     0,   644,   645,   646,   647,   648,
     649,   650,   651,   652,   653,   222,     0,   654,   655,     0,
     656,   657,   658,   659,   660,   661,     0,   224,   225,     0,
       0,   663,   226,   664,   227,     0,   665,   666,   667,   668,
     669,   670,     0,     0,   671,   672,   673,   674,   675,     0,
       0,   676,   677,   678,   679,   680,   681,   234,     0,   682,
       0,   683,   684,   685,     0,     0,   686,     0,     0,   687,
     688,   689,   690,   691,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   692,   693,   694,     0,     0,     0,  1208,
    1209,  1210,     0,  1211,  1212,  1213,  1214,  1215,  1216,    86,
      87,    88,   420,    90,    91,    92,   421,     0,   422,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   423,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   424,   425,
       0,     0,     0,   426,   427,     0,     0,     0,     0,   428,
       0,     0,     0,     0,     0,     0,     0,     0,   429,     0,
     430,     0,   431,   432,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,  1205,     0,
       0,     0,     0,     0,   434,   435,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,     0,     0,     0,     0,
       0,     0,     0,   445,   446,     0,   447,   448,     0,   449,
     450,   451,   452,   135,   136,     0,   138,   139,     0,   453,
     454,   455,   456,   457,     0,     0,   458,   459,   460,   140,
     461,     0,   462,   463,   464,   465,   466,   145,     0,   467,
       0,   468,   469,   470,   471,     0,   472,   473,     0,   474,
     475,   476,   477,   478,   479,   480,     0,     0,   481,     0,
       0,     0,     0,     0,     0,     0,     0,   482,   483,   484,
     485,   486,   487,   155,   156,   488,     0,   489,     0,   490,
     491,   492,   493,   494,     0,   495,   496,   497,   498,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,     0,   510,   511,   512,   513,   164,
     514,   515,   516,   166,     0,   517,     0,   518,   168,   519,
       0,   520,     0,   521,     0,     0,     0,   522,   523,   524,
       0,   525,   172,     0,   526,   527,     0,   528,   529,   530,
     531,   532,     0,   533,   534,   535,     0,   536,   537,   538,
     539,   540,   541,     0,   542,     0,   175,     0,   543,   544,
     545,     0,   176,     0,   177,     0,   546,     0,     0,   547,
       0,   548,   549,   550,   551,   552,   553,   554,     0,   181,
       0,   555,     0,     0,   556,   557,   558,     0,     0,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,   188,     0,   190,   572,   573,   574,   191,     0,
     575,   576,     0,   577,     0,   194,   578,   195,   579,   580,
     581,     0,   582,     0,     0,   583,   584,   585,     0,     0,
     196,     0,     0,     0,   200,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   201,   594,   202,   595,   596,   597,
     598,     0,   599,   600,   601,   602,   603,   604,   605,   204,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,     0,   621,   622,     0,
     623,   624,   625,   626,   212,   627,   628,   629,   630,   631,
     632,   633,   634,     0,   635,   636,   637,   638,   639,     0,
     640,   217,   641,   642,     0,   643,   220,     0,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,   222,     0,
     654,   655,     0,   656,   657,   658,   659,   660,   661,     0,
     224,   225,     0,     0,   663,   226,   664,   227,     0,   665,
     666,   667,   668,   669,   670,     0,     0,   671,   672,   673,
     674,   675,     0,     0,   676,   677,   678,   679,   680,   681,
     234,     0,   682,     0,   683,   684,   685,     0,     0,   686,
       0,     0,   687,   688,   689,   690,   691,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   692,   693,   694,     0,
       0,     0,  1208,  1209,  1210,     0,  1211,  1212,  1213,  1214,
    1215,  1216,    86,    87,    88,   420,    90,    91,    92,   421,
       0,   422,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   423,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   424,   425,     0,     0,     0,   426,   427,     0,     0,
       0,     0,   428,     0,     0,     0,     0,     0,     0,     0,
       0,   429,     0,   430,     0,   431,   432,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,  1205,     0,     0,     0,     0,     0,   434,   435,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,     0,
       0,     0,     0,     0,     0,     0,   445,   446,     0,   447,
     448,     0,   449,   450,   451,   452,   135,   136,     0,   138,
     139,     0,   453,   454,   455,   456,   457,     0,     0,   458,
     459,   460,   140,   461,     0,   462,  3048,   464,   465,   466,
     145,     0,   467,     0,   468,   469,   470,   471,     0,   472,
     473,     0,   474,   475,   476,   477,   478,   479,   480,     0,
       0,   481,     0,     0,     0,     0,     0,     0,     0,     0,
     482,   483,   484,   485,   486,   487,   155,   156,   488,     0,
     489,     0,   490,   491,   492,   493,   494,     0,   495,   496,
     497,   498,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,     0,   510,   511,
     512,   513,   164,   514,   515,   516,   166,     0,  3049,     0,
     518,   168,   519,     0,   520,     0,   521,     0,     0,     0,
     522,   523,   524,     0,   525,   172,     0,   526,   527,     0,
     528,   529,   530,   531,   532,     0,   533,   534,   535,     0,
     536,   537,   538,   539,   540,   541,     0,   542,     0,   175,
       0,   543,   544,   545,     0,   176,     0,   177,     0,   546,
       0,     0,   547,     0,   548,   549,   550,   551,   552,   553,
     554,     0,   181,     0,   555,     0,     0,   556,   557,   558,
       0,     0,   559,   560,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   188,     0,   190,   572,   573,
     574,   191,     0,   575,   576,     0,   577,     0,   194,   578,
     195,   579,   580,   581,     0,   582,     0,     0,   583,   584,
     585,     0,     0,   196,     0,     0,     0,   200,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   201,   594,   202,
     595,   596,   597,   598,     0,   599,   600,   601,   602,   603,
     604,   605,   204,   606,   607,   608,   609,     0,   610,   611,
     612,   613,   614,   615,   616,   617,   618,   619,   620,     0,
     621,   622,     0,   623,   624,   625,   626,   212,   627,   628,
     629,   630,   631,   632,   633,   634,     0,   635,   636,   637,
     638,   639,     0,   640,   217,   641,   642,     0,   643,   220,
       0,   644,   645,   646,   647,   648,   649,   650,   651,   652,
     653,   222,     0,   654,   655,     0,   656,   657,   658,   659,
     660,   661,     0,   224,   225,     0,     0,   663,   226,   664,
     227,     0,   665,   666,   667,   668,   669,   670,     0,     0,
     671,   672,   673,   674,   675,     0,     0,   676,   677,   678,
     679,   680,   681,   234,     0,   682,     0,   683,   684,   685,
       0,     0,   686,     0,     0,   687,   688,   689,   690,   691,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   692,
     693,   694,     0,     0,     0,  1208,  1209,  1210,     0,  1211,
    1212,  1213,  1214,  1215,  1216,    86,    87,    88,   420,    90,
      91,    92,   421,     0,   422,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   423,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   424,   425,     0,     0,     0,   426,
     427,     0,     0,     0,     0,   428,     0,     0,     0,     0,
       0,     0,     0,     0,   429,     0,   430,     0,   431,   432,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,  1205,     0,     0,     0,     0,     0,
     434,   435,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,     0,     0,     0,     0,     0,     0,     0,   445,
     446,     0,   447,   448,     0,   449,   450,   451,   452,   135,
     136,     0,   138,   139,     0,   453,   454,   455,   456,   457,
       0,     0,   458,   459,   460,   140,   461,     0,   462,   463,
     464,   465,   466,   145,     0,   467,     0,   468,   469,   470,
     471,     0,   472,   473,     0,   474,   475,   476,   477,   478,
     479,   480,     0,     0,   481,     0,     0,     0,     0,     0,
       0,     0,     0,   482,   483,   484,   485,   486,   487,   155,
     156,   488,     0,   489,     0,   490,   491,   492,   493,   494,
       0,   495,   496,   497,   498,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
       0,   510,   511,   512,   513,   164,   514,   515,   516,   166,
       0,   517,     0,   518,   168,   519,     0,   520,     0,   521,
       0,     0,     0,   522,   523,   524,     0,   525,   172,     0,
     526,   527,     0,   528,   529,   530,   531,   532,     0,   533,
     534,   535,     0,   536,   537,   538,   539,   540,   541,     0,
     542,     0,   175,     0,   543,   544,   545,     0,   176,     0,
     177,     0,   546,     0,     0,   547,     0,   548,   549,   550,
     551,   552,   553,   554,     0,   181,     0,   555,     0,     0,
     556,   557,   558,     0,     0,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,   188,     0,
     190,   572,   573,   574,   191,     0,   575,   576,     0,   577,
       0,   194,   578,   195,   579,   580,   581,     0,   582,     0,
       0,  4579,   584,   585,     0,     0,   196,     0,     0,     0,
     200,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     201,   594,   202,   595,   596,   597,   598,     0,   599,   600,
     601,   602,   603,   604,   605,   204,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,   615,   616,   617,   618,
     619,   620,     0,   621,   622,     0,   623,   624,   625,   626,
     212,   627,   628,   629,   630,   631,   632,   633,   634,     0,
     635,   636,   637,   638,   639,     0,   640,   217,   641,   642,
       0,   643,   220,     0,   644,   645,   646,   647,   648,   649,
     650,   651,   652,   653,   222,     0,   654,   655,     0,   656,
     657,   658,   659,   660,   661,     0,   224,   225,     0,     0,
     663,   226,   664,   227,     0,   665,   666,   667,   668,   669,
     670,     0,     0,   671,   672,   673,   674,   675,     0,     0,
     676,   677,   678,   679,   680,   681,   234,     0,   682,     0,
     683,   684,   685,     0,     0,   686,     0,     0,   687,   688,
     689,   690,   691,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   692,   693,   694,     0,     0,     0,  1208,  1209,
    1210,     0,  1211,  1212,  1213,  1214,  1215,  1216,   731,    86,
      87,    88,   420,    90,    91,    92,   421,     0,   422,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   732,   104,
     105,   423,   733,     0,   107,   108,   109,   110,   734,   735,
     112,   113,   114,   115,     0,   116,   736,   737,   424,   425,
       0,     0,     0,   426,   427,     0,     0,     0,     0,   428,
       0,     0,     0,     0,     0,     0,     0,     0,   429,     0,
     430,     0,   431,   432,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   434,   435,   436,   437,   438,   439,
     440,   441,   738,   442,   443,   444,   739,   740,   741,   742,
     743,   744,   745,   445,   446,   746,   447,   448,   133,   449,
     450,   451,   452,   135,   136,   137,   138,   139,   747,   453,
     454,   455,   456,   457,   748,   749,   458,   459,   750,   140,
     461,   751,   462,   463,   464,   465,   466,   145,   752,   467,
     753,   468,   469,   470,   471,   148,   472,   754,   755,   474,
     475,   476,   477,   478,   479,   480,   756,   151,   481,   757,
     758,   759,   760,   152,   761,   762,   763,   482,   483,   484,
     485,   486,   487,   155,   156,   488,   764,   489,   765,   490,
     491,   492,   493,   494,   766,   495,   496,   497,   498,   767,
     499,   768,   500,   501,   502,   503,   504,   769,   505,   506,
     507,   770,   508,   509,   771,   510,   511,   512,   513,   164,
     514,   515,   516,   166,   772,   517,   773,   518,   168,   519,
     774,   520,   775,   521,   169,   776,   170,   522,   523,   524,
     777,   525,   172,   778,   526,   527,   779,   528,   529,   530,
     531,   532,   173,   533,   534,   535,   780,   536,   537,   538,
     539,   540,   541,   781,   542,   174,   175,   782,   543,   544,
     545,   783,   176,   784,   177,   785,   546,   178,   179,   547,
     180,   548,   549,   550,   551,   552,   553,   554,   786,   181,
     182,   555,   183,   787,   556,   557,   558,   788,   789,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,   188,   189,   190,   572,   573,   574,   191,   790,
     575,   576,   193,   577,   791,   194,   578,   195,   579,   580,
     581,   792,   582,   793,   794,   583,   584,   585,   795,   796,
     196,   197,   198,   199,   200,   586,   587,   588,   589,   590,
     591,   592,   797,   593,   201,   594,   202,   595,   596,   597,
     598,   798,   599,   600,   601,   602,   603,   604,   605,   204,
     606,   607,   608,   609,   799,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   800,   621,   622,   210,
     623,   624,   625,   626,   212,   627,   628,   629,   630,   631,
     632,   633,   634,   801,   635,   636,   637,   638,   639,   802,
     640,   217,   641,   642,   219,   643,   220,   803,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,   222,   804,
     654,   655,   805,   656,   657,   658,   659,   660,   661,   806,
     224,   225,   807,   808,   663,   226,   664,   227,   809,   665,
     666,   667,   668,   669,   670,   810,   811,   671,   672,   673,
     674,   675,   812,   813,   676,   677,   678,   679,   680,   814,
     234,   815,   682,   235,   683,   684,   685,   816,   817,   686,
     818,   819,   687,   688,   689,   690,   691,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   692,   693,   694,   731,
      86,    87,    88,   420,    90,    91,    92,   421,  2257,   422,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   732,
     104,   105,   423,   733,     0,   107,   108,   109,   110,   734,
     735,   112,   113,   114,   115,     0,   116,   736,   737,   424,
     425,     0,     0,     0,   426,   427,     0,     0,     0,     0,
     428,     0,     0,     0,     0,     0,     0,     0,     0,   429,
       0,   430,     0,   431,   432,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   434,   435,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,     0,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,   448,   133,
     449,   450,   451,   452,     0,  1878,   137,  1879,  1880,     0,
     453,   454,   455,   456,   457,     0,     0,   458,   459,  1881,
    1882,   461,     0,   462,   463,   464,   465,   466,     0,     0,
     467,     0,   468,   469,   470,   471,   148,   472,   473,     0,
     474,   475,   476,   477,   478,   479,   480,     0,   151,   481,
       0,     0,     0,     0,   152,     0,     0,     0,   482,   483,
     484,   485,   486,   487,  1883,  1884,   488,     0,   489,     0,
     490,   491,   492,   493,   494,     0,   495,   496,   497,   498,
       0,   499,     0,   500,   501,  1485,   503,   504,     0,   505,
     506,   507,     0,   508,   509,     0,   510,   511,   512,   513,
       0,   514,   515,   516,     0,     0,   517,     0,   518,  1885,
     519,     0,   520,     0,   521,   169,     0,   170,   522,   523,
     524,     0,   525,     0,     0,   526,   527,     0,   528,   529,
     530,   531,   532,   173,   533,   534,   535,     0,   536,   537,
     538,   539,   540,   541,     0,   542,   174,     0,     0,   543,
     544,   545,  1491,  1886,     0,  1887,     0,   546,   178,   179,
     547,   180,   548,   549,   550,   551,   552,   553,   554,     0,
       0,   182,   555,   183,     0,   556,   557,   558,     0,     0,
     559,   560,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,  1888,   189,  1889,   572,   573,   574,     0,
       0,   575,   576,   193,   577,     0,     0,   578,  1890,   579,
     580,   581,     0,   582,     0,     0,   583,   584,   585,     0,
       0,     0,   197,   198,   199,     0,   586,   587,   588,   589,
     590,   591,   592,     0,   593,     0,   594,     0,   595,   596,
     597,   598,     0,   599,   600,   601,   602,   603,   604,   605,
    1891,   606,   607,   608,   609,     0,   610,   611,   612,   613,
     614,   615,   616,   617,   618,   619,   620,     0,   621,   622,
     210,   623,   624,   625,   626,     0,   627,   628,   629,   630,
     631,   632,   633,   634,     0,   635,   636,   637,   638,   639,
       0,   640,  1892,   641,   642,   219,   643,  1893,     0,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,     0,
       0,   654,   655,     0,   656,   657,   658,   659,   660,   661,
       0,  1894,  1895,     0,     0,   663,     0,   664,     0,     0,
     665,   666,   667,   668,   669,   670,     0,     0,   671,   672,
     673,   674,   675,     0,     0,   676,   677,   678,   679,   680,
       0,  1896,     0,   682,   235,   683,   684,   685,     0,     0,
     686,     0,     0,   687,   688,   689,   690,   691,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   692,   693,   694,
       0,    86,    87,    88,   420,    90,    91,    92,   421,  2356,
     422,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   423,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,     0,     0,
       0,     0,     0,     0,     0,   445,   446,     0,   447,   448,
       0,   449,   450,   451,   452,   135,   136,     0,   138,   139,
       0,   453,   454,   455,   456,   457,     0,     0,   458,   459,
     460,   140,   461,     0,   462,   463,   464,   465,   466,   145,
       0,   467,     0,   468,   469,   470,   471,     0,   472,   473,
       0,   474,   475,   476,   477,   478,   479,   480,     0,     0,
     481,     0,     0,     0,     0,     0,     0,     0,     0,   482,
     483,   484,   485,   486,   487,   155,   156,   488,     0,   489,
       0,   490,   491,   492,   493,   494,     0,   495,   496,   497,
     498,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,     0,   510,   511,   512,
     513,   164,   514,   515,   516,   166,     0,   517,     0,   518,
     168,   519,     0,   520,     0,   521,     0,     0,     0,   522,
     523,   524,     0,   525,   172,     0,   526,   527,     0,   528,
     529,   530,   531,   532,     0,   533,   534,   535,     0,   536,
     537,   538,   539,   540,   541,     0,   542,     0,   175,     0,
     543,   544,   545,     0,   176,     0,   177,     0,   546,     0,
       0,   547,     0,   548,   549,   550,   551,   552,   553,   554,
       0,   181,     0,   555,     0,     0,   556,   557,   558,     0,
       0,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   188,     0,   190,   572,   573,   574,
     191,     0,   575,   576,     0,   577,     0,   194,   578,   195,
     579,   580,   581,     0,   582,     0,     0,   583,   584,   585,
       0,     0,   196,     0,     0,     0,   200,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   201,   594,   202,   595,
     596,   597,   598,     0,   599,   600,   601,   602,   603,   604,
     605,   204,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,     0,   621,
     622,     0,   623,   624,   625,   626,   212,   627,   628,   629,
     630,   631,   632,   633,   634,     0,   635,   636,   637,   638,
     639,     0,   640,   217,   641,   642,     0,   643,   220,     0,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
     222,     0,   654,   655,     0,   656,   657,   658,   659,   660,
     661,     0,   224,   225,     0,     0,   663,   226,   664,   227,
       0,   665,   666,   667,   668,   669,   670,     0,     0,   671,
     672,   673,   674,   675,     0,     0,   676,   677,   678,   679,
     680,   681,   234,     0,   682,     0,   683,   684,   685,     0,
       0,   686,     0,     0,   687,   688,   689,   690,   691,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   692,   693,
     694,     0,    86,    87,    88,   420,    90,    91,    92,   421,
    1089,   422,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   423,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   424,   425,     0,     0,     0,   426,   427,     0,     0,
       0,     0,   428,     0,     0,     0,     0,     0,     0,     0,
       0,   429,     0,   430,     0,   431,   432,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   434,   435,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,     0,
       0,     0,     0,     0,     0,     0,   445,   446,     0,   447,
     448,     0,   449,   450,   451,   452,   135,   136,     0,   138,
     139,     0,   453,   454,   455,   456,   457,     0,     0,   458,
     459,   460,   140,   461,     0,   462,   463,   464,   465,   466,
     145,     0,   467,     0,   468,   469,   470,   471,     0,   472,
     473,     0,   474,   475,   476,   477,   478,   479,   480,     0,
       0,   481,     0,     0,     0,     0,     0,     0,     0,     0,
     482,   483,   484,   485,   486,   487,   155,   156,   488,     0,
     489,     0,   490,   491,   492,   493,   494,     0,   495,   496,
     497,   498,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,     0,   510,   511,
     512,   513,   164,   514,   515,   516,   166,     0,   517,     0,
     518,   168,   519,     0,   520,     0,   521,     0,     0,     0,
     522,   523,   524,     0,   525,   172,     0,   526,   527,     0,
     528,   529,   530,   531,   532,     0,   533,   534,   535,     0,
     536,   537,   538,   539,   540,   541,     0,   542,     0,   175,
       0,   543,   544,   545,     0,   176,     0,   177,     0,   546,
       0,     0,   547,     0,   548,   549,   550,   551,   552,   553,
     554,     0,   181,     0,   555,     0,     0,   556,   557,   558,
       0,     0,   559,   560,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   188,     0,   190,   572,   573,
     574,   191,     0,   575,   576,     0,   577,     0,   194,   578,
     195,   579,   580,   581,     0,   582,     0,     0,   583,   584,
     585,     0,     0,   196,     0,     0,     0,   200,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   201,   594,   202,
     595,   596,   597,   598,     0,   599,   600,   601,   602,   603,
     604,   605,   204,   606,   607,   608,   609,     0,   610,   611,
     612,   613,   614,   615,   616,   617,   618,   619,   620,     0,
     621,   622,     0,   623,   624,   625,   626,   212,   627,   628,
     629,   630,   631,   632,   633,   634,     0,   635,   636,   637,
     638,   639,     0,   640,   217,   641,   642,     0,   643,   220,
       0,   644,   645,   646,   647,   648,   649,   650,   651,   652,
     653,   222,     0,   654,   655,     0,   656,   657,   658,   659,
     660,   661,     0,   224,   225,     0,     0,   663,   226,   664,
     227,     0,   665,   666,   667,   668,   669,   670,     0,     0,
     671,   672,   673,   674,   675,     0,     0,   676,   677,   678,
     679,   680,   681,   234,     0,   682,     0,   683,   684,   685,
       0,     0,   686,     0,     0,   687,   688,   689,   690,   691,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   692,
     693,   694,     0,    86,    87,    88,   420,    90,    91,    92,
     421,  4442,   422,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   423,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,   433,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
       0,     0,     0,    45,     0,     0,     0,     0,   434,   435,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
       0,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,   448,     0,   449,   450,   451,   452,   135,   136,     0,
     138,   139,     0,   453,   454,   455,   456,   457,     0,     0,
     458,   459,   460,   140,   461,     0,   462,   463,   464,   465,
     466,   145,     0,   467,     0,   468,   469,   470,   471,     0,
     472,   473,     0,   474,   475,   476,   477,   478,   479,   480,
       0,     0,   481,     0,     0,     0,     0,     0,     0,     0,
       0,   482,   483,   484,   485,   486,   487,   155,   156,   488,
    2245,   489,     0,   490,   491,   492,   493,   494,     0,   495,
     496,   497,   498,     0,   499,     0,   500,   501,   502,   503,
     504,     0,   505,   506,   507,     0,   508,   509,     0,   510,
     511,   512,   513,   164,   514,   515,   516,   166,  2033,   517,
       0,   518,   168,   519,     0,   520,     0,   521,     0,     0,
       0,   522,   523,   524,     0,   525,   172,     0,   526,   527,
       0,   528,   529,   530,   531,   532,     0,   533,   534,   535,
       0,   536,   537,   538,   539,   540,   541,     0,   542,     0,
     175,     0,   543,   544,   545,     0,   176,     0,   177,     0,
     546,     0,     0,   547,     0,   548,   549,   550,   551,   552,
     553,   554,     0,   181,     0,   555,     0,     0,   556,   557,
     558,     0,     0,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,   188,     0,   190,   572,
     573,   574,   191,     0,   575,   576,     0,   577,     0,   194,
     578,   195,   579,   580,   581,     0,   582,  2034,     0,   583,
     584,   585,     0,     0,   196,     0,     0,     0,   200,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   201,   594,
     202,   595,   596,   597,   598,     0,   599,   600,   601,   602,
     603,   604,   605,   204,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
       0,   621,   622,     0,   623,   624,   625,   626,   212,   627,
     628,   629,   630,   631,   632,   633,   634,     0,   635,   636,
     637,   638,   639,     0,   640,   217,   641,   642,     0,   643,
     220,     0,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,   222,     0,   654,   655,     0,   656,   657,   658,
     659,   660,   661,     0,   224,   225,     0,     0,   663,   226,
     664,   227,  2035,   665,   666,   667,   668,   669,   670,     0,
       0,   671,   672,   673,   674,   675,     0,     0,   676,   677,
     678,   679,   680,   681,   234,     0,   682,     0,   683,   684,
     685,     0,     0,   686,     0,     0,   687,   688,   689,   690,
     691,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     692,   693,   694,     0,     0,     0,     0,     0,     0,     0,
    1000,  1663,    86,    87,    88,   420,    90,    91,    92,   421,
       0,   422,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   423,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   424,   425,     0,     0,     0,   426,   427,     0,     0,
       0,     0,   428,     0,     0,     0,     0,     0,     0,     0,
       0,   429,     0,   430,     0,   431,   432,    35,   433,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,   434,   435,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,     0,
       0,     0,     0,     0,     0,     0,   445,   446,     0,   447,
     448,     0,   449,   450,   451,   452,   135,   136,     0,   138,
     139,     0,   453,   454,   455,   456,   457,     0,     0,   458,
     459,   460,   140,   461,     0,   462,   463,   464,   465,   466,
     145,     0,   467,     0,   468,   469,   470,   471,     0,   472,
     473,     0,   474,   475,   476,   477,   478,   479,   480,     0,
       0,   481,     0,     0,     0,     0,     0,     0,     0,     0,
     482,   483,   484,   485,   486,   487,   155,   156,   488,  2250,
     489,     0,   490,   491,   492,   493,   494,     0,   495,   496,
     497,   498,     0,   499,     0,   500,   501,   502,   503,   504,
       0,   505,   506,   507,     0,   508,   509,     0,   510,   511,
     512,   513,   164,   514,   515,   516,   166,  2033,   517,     0,
     518,   168,   519,     0,   520,     0,   521,     0,     0,     0,
     522,   523,   524,     0,   525,   172,     0,   526,   527,     0,
     528,   529,   530,   531,   532,     0,   533,   534,   535,     0,
     536,   537,   538,   539,   540,   541,     0,   542,     0,   175,
       0,   543,   544,   545,     0,   176,     0,   177,     0,   546,
       0,     0,   547,     0,   548,   549,   550,   551,   552,   553,
     554,     0,   181,     0,   555,     0,     0,   556,   557,   558,
       0,     0,   559,   560,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   188,     0,   190,   572,   573,
     574,   191,     0,   575,   576,     0,   577,     0,   194,   578,
     195,   579,   580,   581,     0,   582,  2034,     0,   583,   584,
     585,     0,     0,   196,     0,     0,     0,   200,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   201,   594,   202,
     595,   596,   597,   598,     0,   599,   600,   601,   602,   603,
     604,   605,   204,   606,   607,   608,   609,     0,   610,   611,
     612,   613,   614,   615,   616,   617,   618,   619,   620,     0,
     621,   622,     0,   623,   624,   625,   626,   212,   627,   628,
     629,   630,   631,   632,   633,   634,     0,   635,   636,   637,
     638,   639,     0,   640,   217,   641,   642,     0,   643,   220,
       0,   644,   645,   646,   647,   648,   649,   650,   651,   652,
     653,   222,     0,   654,   655,     0,   656,   657,   658,   659,
     660,   661,     0,   224,   225,     0,     0,   663,   226,   664,
     227,  2035,   665,   666,   667,   668,   669,   670,     0,     0,
     671,   672,   673,   674,   675,     0,     0,   676,   677,   678,
     679,   680,   681,   234,     0,   682,     0,   683,   684,   685,
       0,     0,   686,     0,     0,   687,   688,   689,   690,   691,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   692,
     693,   694,     0,     0,     0,     0,     0,     0,     0,  1000,
    1663,    86,    87,    88,   420,    90,    91,    92,   421,     0,
     422,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   423,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,   433,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,     0,     0,
       0,     0,     0,     0,     0,   445,   446,     0,   447,   448,
       0,   449,   450,   451,   452,   135,   136,     0,   138,   139,
       0,   453,   454,   455,   456,   457,     0,     0,   458,   459,
     460,   140,   461,     0,   462,   463,   464,   465,   466,   145,
       0,   467,     0,   468,   469,   470,   471,     0,   472,   473,
       0,   474,   475,   476,   477,   478,   479,   480,     0,     0,
     481,     0,     0,     0,     0,     0,     0,     0,     0,   482,
     483,   484,   485,   486,   487,   155,   156,   488,     0,   489,
       0,   490,   491,   492,   493,   494,     0,   495,   496,   497,
     498,     0,   499,     0,   500,   501,   502,   503,   504,     0,
     505,   506,   507,     0,   508,   509,     0,   510,   511,   512,
     513,   164,   514,   515,   516,   166,  2033,   517,     0,   518,
     168,   519,     0,   520,     0,   521,     0,     0,     0,   522,
     523,   524,     0,   525,   172,     0,   526,   527,     0,   528,
     529,   530,   531,   532,     0,   533,   534,   535,     0,   536,
     537,   538,   539,   540,   541,     0,   542,     0,   175,     0,
     543,   544,   545,     0,   176,     0,   177,     0,   546,     0,
       0,   547,     0,   548,   549,   550,   551,   552,   553,   554,
       0,   181,     0,   555,     0,     0,   556,   557,   558,     0,
       0,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   188,     0,   190,   572,   573,   574,
     191,     0,   575,   576,     0,   577,     0,   194,   578,   195,
     579,   580,   581,     0,   582,  2034,     0,   583,   584,   585,
       0,     0,   196,     0,     0,     0,   200,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   201,   594,   202,   595,
     596,   597,   598,     0,   599,   600,   601,   602,   603,   604,
     605,   204,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,     0,   621,
     622,     0,   623,   624,   625,   626,   212,   627,   628,   629,
     630,   631,   632,   633,   634,     0,   635,   636,   637,   638,
     639,     0,   640,   217,   641,   642,     0,   643,   220,     0,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
     222,     0,   654,   655,     0,   656,   657,   658,   659,   660,
     661,     0,   224,   225,     0,     0,   663,   226,   664,   227,
    2035,   665,   666,   667,   668,   669,   670,     0,     0,   671,
     672,   673,   674,   675,     0,     0,   676,   677,   678,   679,
     680,   681,   234,     0,   682,     0,   683,   684,   685,     0,
       0,   686,     0,     0,   687,   688,   689,   690,   691,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   692,   693,
     694,     0,     0,     0,     0,     0,     0,     0,  1000,  1663,
      86,    87,    88,   420,    90,    91,    92,   421,     0,   422,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   423,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   424,
     425,     0,     0,     0,   426,   427,     0,     0,     0,     0,
     428,     0,     0,     0,     0,     0,     0,     0,     0,   429,
       0,   430,     0,   431,   432,    35,   433,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,   434,   989,   436,   437,   438,
     439,   440,   441,   990,   442,   443,   444,     0,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,   448,     0,
     991,   450,   451,   452,   135,   136,     0,   138,   139,     0,
     453,   454,   455,   456,   457,     0,     0,   458,   459,   460,
     140,   461,     0,   462,   463,   464,   465,   466,   145,     0,
     467,     0,   468,   469,   470,   471,     0,   472,   473,     0,
     474,   475,   476,   477,   478,   479,   480,     0,     0,   481,
       0,     0,     0,     0,     0,     0,     0,     0,   482,   483,
     484,   485,   486,   487,   155,   156,   488,     0,   489,     0,
     490,   491,   492,   493,   494,     0,   495,   496,   497,   498,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,     0,   510,   511,   512,   513,
     164,   514,   515,   516,   166,     0,   517,     0,   992,   168,
     519,     0,   520,     0,   993,     0,   994,     0,   522,   523,
     524,     0,   525,   172,     0,   526,   527,     0,   528,   529,
     530,   531,   532,     0,   533,   534,   535,   995,   536,   537,
     538,   539,   540,   541,     0,   542,     0,   175,     0,   543,
     544,   545,     0,   176,     0,   177,     0,   546,     0,     0,
     547,     0,   548,   549,   550,   551,   996,   553,   554,     0,
     181,     0,   555,     0,     0,   556,   557,   558,     0,     0,
     559,   560,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   188,     0,   190,   997,   573,   574,   191,
       0,   575,   576,     0,   577,     0,   194,   578,   195,   579,
     580,   581,     0,   582,     0,     0,   583,   584,   585,     0,
       0,   196,     0,     0,     0,   200,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   201,   594,   202,   595,   596,
     597,   598,     0,   998,   600,   601,   602,   603,   604,   605,
     204,   606,   607,   608,   609,     0,   610,   999,   612,   613,
     614,   615,   616,   617,   618,   619,   620,     0,   621,   622,
       0,   623,   624,   625,   626,   212,   627,   628,   629,   630,
     631,   632,   633,   634,     0,   635,   636,   637,   638,   639,
       0,   640,   217,   641,   642,     0,   643,   220,     0,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   222,
       0,   654,   655,     0,   656,   657,   658,   659,   660,   661,
       0,   224,   225,     0,     0,   663,   226,   664,   227,     0,
     665,   666,   667,   668,   669,   670,     0,     0,   671,   672,
     673,   674,   675,     0,     0,   676,   677,   678,   679,   680,
     681,   234,     0,   682,     0,   683,   684,   685,     0,     0,
     686,     0,     0,   687,   688,   689,   690,   691,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   692,   693,   694,
       0,     0,     0,     0,     0,     0,     0,  1000,  1001,    86,
      87,    88,   420,    90,    91,    92,   421,     0,   422,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   423,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   424,   425,
       0,     0,     0,   426,   427,     0,     0,     0,     0,   428,
       0,     0,     0,     0,     0,     0,     0,     0,   429,     0,
     430,     0,   431,   432,    35,   433,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,    45,
       0,     0,     0,     0,   434,   989,   436,   437,   438,   439,
     440,   441,   990,   442,   443,   444,     0,     0,     0,     0,
       0,     0,     0,   445,   446,     0,   447,   448,     0,  1022,
     450,   451,   452,   135,   136,     0,   138,   139,     0,   453,
     454,   455,   456,   457,     0,     0,   458,   459,   460,   140,
     461,     0,   462,   463,   464,   465,   466,   145,     0,   467,
       0,   468,   469,   470,   471,     0,   472,   473,     0,   474,
     475,   476,   477,   478,   479,   480,     0,     0,   481,     0,
       0,     0,     0,     0,     0,     0,     0,   482,   483,   484,
     485,   486,   487,   155,   156,   488,     0,   489,     0,   490,
     491,   492,   493,   494,     0,   495,   496,   497,   498,     0,
     499,     0,   500,   501,   502,   503,   504,     0,   505,   506,
     507,     0,   508,   509,     0,   510,   511,   512,   513,   164,
     514,   515,   516,   166,     0,   517,     0,   992,   168,   519,
       0,   520,     0,  1023,     0,   994,     0,   522,   523,   524,
       0,   525,   172,     0,   526,   527,     0,   528,   529,   530,
     531,   532,     0,   533,   534,   535,   995,   536,   537,   538,
     539,   540,   541,     0,   542,     0,   175,     0,   543,   544,
     545,     0,   176,     0,   177,     0,   546,     0,     0,   547,
       0,   548,   549,   550,   551,   996,   553,   554,     0,   181,
       0,   555,     0,     0,   556,   557,   558,     0,     0,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,   188,     0,   190,   997,   573,   574,   191,     0,
     575,   576,     0,   577,     0,   194,   578,   195,   579,   580,
     581,     0,   582,     0,     0,   583,   584,   585,     0,     0,
     196,     0,     0,     0,   200,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   201,   594,   202,   595,   596,   597,
     598,     0,   998,   600,   601,   602,   603,   604,   605,   204,
     606,   607,   608,   609,     0,   610,   999,   612,   613,   614,
     615,   616,   617,   618,   619,   620,     0,   621,   622,     0,
     623,   624,   625,   626,   212,   627,   628,   629,   630,   631,
     632,   633,   634,     0,   635,   636,   637,   638,   639,     0,
     640,   217,   641,   642,     0,   643,   220,     0,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,   222,     0,
     654,   655,     0,   656,   657,   658,   659,   660,   661,     0,
     224,   225,     0,     0,   663,   226,   664,   227,     0,   665,
     666,   667,   668,   669,   670,     0,     0,   671,   672,   673,
     674,   675,     0,     0,   676,   677,   678,   679,   680,   681,
     234,     0,   682,     0,   683,   684,   685,     0,     0,   686,
       0,     0,   687,   688,   689,   690,   691,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   692,   693,   694,     0,
       0,     0,     0,     0,     0,     0,  1000,  1001,    86,    87,
      88,   420,    90,    91,    92,   421,     0,   422,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     423,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   424,   425,     0,
       0,     0,   426,   427,     0,     0,     0,     0,   428,     0,
       0,     0,     0,     0,     0,     0,     0,   429,     0,   430,
       0,   431,   432,    35,   433,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,    45,     0,
       0,     0,     0,   434,   435,   436,   437,   438,   439,   440,
     441,  1400,   442,   443,   444,     0,     0,     0,     0,     0,
       0,     0,   445,   446,     0,   447,   448,     0,   449,   450,
     451,   452,   135,   136,     0,   138,   139,     0,   453,   454,
     455,   456,   457,     0,     0,   458,   459,   460,   140,   461,
       0,   462,   463,   464,   465,   466,   145,     0,   467,     0,
     468,   469,   470,   471,     0,   472,   473,     0,   474,   475,
     476,   477,   478,   479,   480,     0,     0,   481,     0,     0,
       0,     0,     0,     0,     0,     0,   482,   483,   484,   485,
     486,   487,   155,   156,   488,     0,   489,     0,   490,   491,
     492,   493,   494,     0,   495,   496,   497,   498,     0,   499,
       0,   500,   501,   502,   503,   504,     0,   505,   506,   507,
       0,   508,   509,     0,   510,   511,   512,   513,   164,   514,
     515,   516,   166,     0,   517,     0,   518,   168,   519,     0,
     520,     0,   521,     0,   994,     0,   522,   523,   524,     0,
     525,   172,     0,   526,   527,     0,   528,   529,   530,   531,
     532,     0,   533,   534,   535,   995,   536,   537,   538,   539,
     540,   541,     0,   542,     0,   175,     0,   543,   544,   545,
       0,   176,     0,   177,     0,   546,     0,     0,   547,     0,
     548,   549,   550,   551,   552,   553,   554,     0,   181,     0,
     555,     0,     0,   556,   557,   558,     0,     0,   559,   560,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,   188,     0,   190,   572,   573,   574,   191,     0,   575,
     576,     0,   577,     0,   194,   578,   195,   579,   580,   581,
       0,   582,     0,     0,   583,   584,   585,     0,     0,   196,
       0,     0,     0,   200,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   201,   594,   202,   595,   596,   597,   598,
       0,   599,   600,   601,   602,   603,   604,   605,   204,   606,
     607,   608,   609,     0,   610,   611,   612,   613,   614,   615,
     616,   617,   618,   619,   620,     0,   621,   622,     0,   623,
     624,   625,   626,   212,   627,   628,   629,   630,   631,   632,
     633,   634,     0,   635,   636,   637,   638,   639,     0,   640,
     217,   641,   642,     0,   643,   220,     0,   644,   645,   646,
     647,   648,   649,   650,   651,   652,   653,   222,     0,   654,
     655,     0,   656,   657,   658,   659,   660,   661,     0,   224,
     225,     0,     0,   663,   226,   664,   227,     0,   665,   666,
     667,   668,   669,   670,     0,     0,   671,   672,   673,   674,
     675,     0,     0,   676,   677,   678,   679,   680,   681,   234,
       0,   682,     0,   683,   684,   685,     0,     0,   686,     0,
       0,   687,   688,   689,   690,   691,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   692,   693,   694,     0,     0,
       0,     0,     0,     0,     0,  1000,  1001,    86,    87,    88,
     420,    90,    91,    92,   421,     0,   422,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   423,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   424,   425,     0,     0,
       0,   426,   427,     0,     0,     0,     0,   428,     0,     0,
       0,     0,     0,     0,     0,     0,   429,     0,   430,     0,
     431,   432,    35,   433,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,    45,     0,     0,
       0,     0,   434,   435,   436,   437,   438,   439,   440,   441,
    1405,   442,   443,   444,     0,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,   448,     0,   449,   450,   451,
     452,   135,   136,     0,   138,   139,     0,   453,   454,   455,
     456,   457,     0,     0,   458,   459,   460,   140,   461,     0,
     462,   463,   464,   465,   466,   145,     0,   467,     0,   468,
     469,   470,   471,     0,   472,   473,     0,   474,   475,   476,
     477,   478,   479,   480,     0,     0,   481,     0,     0,     0,
       0,     0,     0,     0,     0,   482,   483,   484,   485,   486,
     487,   155,   156,   488,     0,   489,     0,   490,   491,   492,
     493,   494,     0,   495,   496,   497,   498,     0,   499,     0,
     500,   501,   502,   503,   504,     0,   505,   506,   507,     0,
     508,   509,     0,   510,   511,   512,   513,   164,   514,   515,
     516,   166,     0,   517,     0,   518,   168,   519,     0,   520,
       0,   521,     0,   994,     0,   522,   523,   524,     0,   525,
     172,     0,   526,   527,     0,   528,   529,   530,   531,   532,
       0,   533,   534,   535,   995,   536,   537,   538,   539,   540,
     541,     0,   542,     0,   175,     0,   543,   544,   545,     0,
     176,     0,   177,     0,   546,     0,     0,   547,     0,   548,
     549,   550,   551,   552,   553,   554,     0,   181,     0,   555,
       0,     0,   556,   557,   558,     0,     0,   559,   560,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
     188,     0,   190,   572,   573,   574,   191,     0,   575,   576,
       0,   577,     0,   194,   578,   195,   579,   580,   581,     0,
     582,     0,     0,   583,   584,   585,     0,     0,   196,     0,
       0,     0,   200,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   201,   594,   202,   595,   596,   597,   598,     0,
     599,   600,   601,   602,   603,   604,   605,   204,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,   615,   616,
     617,   618,   619,   620,     0,   621,   622,     0,   623,   624,
     625,   626,   212,   627,   628,   629,   630,   631,   632,   633,
     634,     0,   635,   636,   637,   638,   639,     0,   640,   217,
     641,   642,     0,   643,   220,     0,   644,   645,   646,   647,
     648,   649,   650,   651,   652,   653,   222,     0,   654,   655,
       0,   656,   657,   658,   659,   660,   661,     0,   224,   225,
       0,     0,   663,   226,   664,   227,     0,   665,   666,   667,
     668,   669,   670,     0,     0,   671,   672,   673,   674,   675,
       0,     0,   676,   677,   678,   679,   680,   681,   234,     0,
     682,     0,   683,   684,   685,     0,     0,   686,     0,     0,
     687,   688,   689,   690,   691,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   692,   693,   694,     0,     0,     0,
       0,     0,     0,     0,  1000,  1001,    86,    87,    88,   420,
      90,    91,    92,   421,     0,   422,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   423,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   424,   425,     0,     0,     0,
     426,   427,     0,     0,     0,     0,   428,     0,     0,     0,
       0,     0,     0,     0,     0,   429,     0,   430,     0,   431,
     432,    35,   433,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   434,   435,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,     0,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,   448,     0,   449,   450,   451,   452,
     135,   136,     0,   138,   139,     0,   453,   454,   455,   456,
     457,     0,     0,   458,   459,   460,   140,   461,     0,   462,
     463,   464,   465,   466,   145,     0,   467,     0,   468,   469,
     470,   471,     0,   472,   473,     0,   474,   475,   476,   477,
     478,   479,   480,     0,     0,   481,     0,     0,     0,     0,
       0,     0,     0,     0,   482,   483,   484,   485,   486,   487,
     155,   156,   488,   716,   489,     0,   490,   491,   492,   493,
     494,     0,   495,   496,   497,   498,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,     0,   510,   511,   512,   513,   164,   514,   515,   516,
     166,     0,   517,     0,   518,   168,   519,     0,   520,     0,
     521,     0,     0,     0,   522,   523,   524,     0,   525,   172,
       0,   526,   527,     0,   528,   529,   530,   531,   532,     0,
     533,   534,   535,     0,   536,   537,   538,   539,   540,   541,
       0,   542,     0,   175,     0,   543,   544,   545,     0,   176,
       0,   177,     0,   546,     0,     0,   547,     0,   548,   549,
     550,   551,   552,   553,   554,     0,   181,     0,   555,     0,
       0,   556,   557,   558,     0,     0,   559,   560,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   188,
       0,   190,   572,   573,   574,   191,     0,   575,   576,     0,
     577,     0,   194,   578,   195,   579,   580,   581,     0,   582,
       0,     0,   583,   584,   585,     0,     0,   196,     0,     0,
       0,   200,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   201,   594,   202,   595,   596,   597,   598,     0,   599,
     600,   601,   602,   603,   604,   605,   204,   606,   607,   608,
     609,     0,   610,   611,   612,   613,   614,   615,   616,   617,
     618,   619,   620,     0,   621,   622,     0,   623,   624,   625,
     626,   212,   627,   628,   629,   630,   631,   632,   633,   634,
       0,   635,   636,   637,   638,   639,     0,   640,   217,   641,
     642,     0,   643,   220,     0,   644,   645,   646,   647,   648,
     649,   650,   651,   652,   653,   222,     0,   654,   655,     0,
     656,   657,   658,   659,   660,   661,     0,   224,   225,  1567,
       0,   663,   226,   664,   227,     0,   665,   666,   667,   668,
     669,   670,     0,     0,   671,   672,   673,   674,   675,     0,
       0,   676,   677,   678,   679,   680,   681,   234,     0,   682,
       0,   683,   684,   685,     0,     0,   686,     0,     0,   687,
     688,   689,   690,   691,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   692,   693,   694,     0,     0,  1061,  1568,
      86,    87,    88,   420,    90,    91,    92,   421,  1062,   422,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   423,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   424,
     425,     0,     0,     0,   426,   427,     0,     0,     0,     0,
     428,     0,     0,     0,     0,     0,     0,     0,     0,   429,
       0,   430,     0,   431,   432,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   434,   435,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,     0,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,   448,     0,
     449,   450,   451,   452,   135,   136,     0,   138,   139,     0,
     453,   454,   455,   456,   457,     0,     0,  1063,   459,  1037,
     140,   461,     0,   462,   463,   464,   465,   466,   145,     0,
     467,     0,   468,   469,   470,   471,     0,   472,  1064,     0,
    1065,   475,   476,   477,   478,   479,   480,     0,     0,   481,
       0,     0,     0,     0,     0,     0,     0,     0,   482,   483,
     484,   485,   486,   487,   155,   156,   488,     0,   489,     0,
     490,   491,   492,   493,   494,     0,   495,   496,   497,   498,
       0,   499,     0,   500,   501,   502,   503,   504,     0,   505,
     506,   507,     0,   508,   509,     0,   510,   511,   512,   513,
     164,   514,   515,   516,   166,     0,   517,     0,   518,   168,
     519,     0,   520,     0,   521,     0,     0,     0,   522,   523,
     524,     0,   525,   172,     0,   526,   527,     0,   528,   529,
     530,   531,   532,     0,   533,   534,   535,     0,   536,   537,
     538,   539,   540,   541,     0,   542,     0,   175,     0,   543,
     544,   545,     0,   176,     0,   177,     0,   546,     0,     0,
     547,     0,   548,   549,   550,   551,   552,   553,   554,     0,
     181,     0,   555,     0,     0,   556,   557,  1066,     0,     0,
     559,   560,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,  1067,   188,     0,   190,   572,   573,   574,   191,
       0,   575,   576,     0,   577,     0,   194,   578,   195,   579,
     580,   581,     0,   582,     0,     0,   583,   584,   585,     0,
       0,   196,     0,     0,     0,   200,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   201,   594,   202,   595,   596,
     597,   598,     0,   599,   600,   601,   602,   603,   604,   605,
     204,   606,   607,   608,   609,     0,   610,   611,   612,   613,
     614,   615,   616,   617,   618,   619,   620,     0,   621,   622,
       0,   623,  1068,   625,   626,   212,   627,   628,   629,  1069,
     631,   632,   633,   634,     0,   635,   636,   637,   638,  1070,
       0,   640,   217,   641,   642,     0,   643,   220,     0,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   222,
       0,   654,   655,     0,   656,   657,   658,   659,   660,   661,
       0,  1071,   225,     0,     0,  1072,   226,   664,   227,     0,
     665,   666,   667,   668,   669,   670,     0,     0,   671,   672,
     673,   674,   675,     0,     0,   676,   677,   678,   679,   680,
    1041,   234,     0,   682,     0,   683,   684,   685,     0,     0,
     686,     0,     0,   687,   688,   689,   690,  1073,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   692,   693,   694,
     731,    86,    87,    88,   420,    90,    91,    92,   421,     0,
     422,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     732,   104,   105,   423,   733,     0,   107,   108,   109,   110,
     734,   735,   112,   113,   114,   115,     0,   116,   736,   737,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,     0,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,   738,   442,   443,   444,   739,   740,
     741,   742,   743,   744,   745,   445,   446,   746,   447,   448,
     133,   449,   450,   451,   452,   135,   136,   137,   138,   139,
     747,   453,   454,   455,   456,   457,   748,   749,   458,   459,
     750,   140,   461,   751,   462,   463,   464,   465,   466,   145,
     752,   467,   753,   468,   469,   470,   471,   148,   472,   754,
     755,   474,   475,   476,   477,   478,   479,   480,   756,   151,
     481,   757,   758,   759,   760,   152,   761,   762,   763,   482,
     483,   484,   485,   486,   487,   155,   156,   488,   764,   489,
     765,   490,   491,   492,   493,   494,   766,   495,   496,   497,
     498,   767,   499,   768,   500,   501,   502,   503,   504,   769,
     505,   506,   507,   770,   508,   509,   771,   510,   511,   512,
     513,   164,   514,   515,   516,   166,   772,   517,   773,   518,
     168,   519,   774,   520,   775,   521,   169,   776,   170,   522,
     523,   524,   777,   525,   172,   778,   526,   527,   779,   528,
     529,   530,   531,   532,   173,   533,   534,   535,   780,   536,
     537,   538,   539,   540,   541,   781,   542,   174,   175,   782,
     543,   544,   545,   783,   176,   784,   177,   785,   546,   178,
     179,   547,   180,   548,   549,   550,   551,   552,   553,   554,
     786,   181,   182,   555,   183,   787,   556,   557,   558,   788,
     789,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,   188,   189,   190,   572,   573,   574,
     191,   790,   575,   576,   193,   577,   791,   194,   578,   195,
     579,   580,   581,   792,   582,   793,   794,   583,   584,   585,
     795,   796,   196,   197,   198,   199,   200,   586,   587,   588,
     589,   590,   591,   592,   797,   593,   201,   594,   202,   595,
     596,   597,   598,   798,   599,   600,   601,   602,   603,   604,
     605,   204,   606,   607,   608,   609,   799,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,   800,   621,
     622,   210,   623,   624,   625,   626,   212,   627,   628,   629,
     630,   631,   632,   633,   634,   801,   635,   636,   637,   638,
     639,   802,   640,   217,   641,   642,   219,   643,   220,   803,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
     222,   804,   654,   655,   805,   656,   657,   658,   659,   660,
     661,   806,   224,   225,   807,   808,   663,   226,   664,   227,
     809,   665,   666,   667,   668,   669,   670,   810,   811,   671,
     672,   673,   674,   675,   812,   813,   676,   677,   678,   679,
     680,   814,   234,   815,   682,   235,   683,   684,   685,   816,
     817,   686,   818,   819,   687,   688,   689,   690,   691,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   692,   693,
     694,   731,    86,    87,    88,   420,    90,    91,    92,   421,
       0,   422,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   732,   104,   105,   423,   733,     0,   107,   108,   109,
     110,   734,   735,   112,   113,   114,   115,     0,   116,   736,
     737,   424,   425,     0,     0,     0,   426,   427,     0,     0,
       0,     0,   428,     0,     0,     0,     0,     0,     0,     0,
       0,   429,     0,   430,     0,   431,   432,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   434,   435,   436,
     437,   438,   439,   440,   441,   738,   442,   443,   444,   739,
     740,   741,   742,   743,   744,   745,   445,   446,   746,   447,
     448,   133,   449,   450,   451,   452,   135,   136,   137,   138,
     139,   747,   453,   454,   455,   456,   457,   748,   749,   458,
     459,   750,   140,   461,   751,   462,   463,   464,   465,   466,
     145,   752,   467,   753,   468,   469,   470,   471,   148,   472,
     754,   755,   474,   475,   476,   477,   478,   479,   480,   756,
     151,   481,   757,   758,   759,   760,   152,   761,   762,   763,
     482,   483,   484,   485,   486,   487,   155,   156,   488,   764,
     489,   765,   490,   491,   492,   493,   494,   766,   495,   496,
     497,   498,   767,   499,   768,   500,   501,   502,   503,   504,
     769,   505,   506,   507,   770,   508,   509,   771,   510,   511,
     512,   513,   164,   514,   515,   516,   166,   772,   517,   773,
     518,   168,   519,   774,   520,   775,   521,   169,   776,   170,
     522,   523,   524,   777,   525,   172,   778,   526,   527,   779,
     528,   529,   530,   531,   532,   173,   533,   534,   535,   780,
     536,   537,   538,   539,   540,   541,   781,   542,   174,   175,
     782,   543,   544,   545,   783,   176,   784,   177,   785,   546,
     178,   179,   547,   180,   548,   549,   550,   551,   552,   553,
     554,   786,   181,   182,   555,   183,   787,   556,   557,   558,
     788,   789,   559,   560,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   188,   189,   190,   572,   573,
     574,   191,   790,   575,   576,   193,   577,   791,   194,   578,
     195,   579,   580,   581,   792,   582,   793,   794,   583,   584,
     585,   795,   796,   196,   197,   198,   199,   200,   586,   587,
     588,   589,   590,   591,   592,   797,   593,   201,   594,   202,
     595,   596,   597,   598,   798,   599,   600,   601,   602,   603,
     604,   605,   204,   606,   607,   608,   609,   799,   610,   611,
     612,   613,   614,   615,   616,   617,   618,   619,   620,   800,
     621,   622,   210,   623,   624,   625,   626,   212,   627,   628,
     629,   630,   631,   632,   633,   634,   801,   635,   636,   637,
     638,   639,   802,   640,   217,   641,   642,   219,   643,   220,
     803,   644,   645,   646,   647,   648,   649,   650,   651,   652,
     653,   222,   804,   654,   655,   805,   656,   657,   658,   659,
     660,   661,   806,   224,   225,   807,   808,   663,   226,   664,
     227,   809,   665,   666,   667,   668,   669,   670,   810,   811,
     671,   672,   673,   674,   675,   812,   813,   676,   677,   678,
     679,   680,   814,   234,   815,   682,   235,   683,   684,   685,
     816,   817,   686,   818,   819,   687,   688,   689,   690,   691,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   692,
     693,   694,   731,    86,    87,    88,   420,    90,    91,    92,
     421,     0,   422,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   732,   104,   105,   423,   733,     0,   107,   108,
     109,   110,   734,   735,   112,   113,   114,   115,     0,   116,
     736,   737,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   434,   435,
     436,   437,  3109,   439,   440,   441,   738,   442,   443,   444,
     739,   740,   741,   742,   743,   744,   745,   445,   446,   746,
     447,   448,   133,   449,   450,   451,   452,   135,   136,   137,
     138,   139,   747,   453,   454,   455,   456,   457,   748,   749,
     458,   459,   750,   140,   461,   751,   462,   463,   464,   465,
     466,   145,   752,   467,   753,   468,   469,   470,   471,   148,
     472,   754,   755,   474,   475,   476,   477,   478,   479,   480,
     756,   151,   481,   757,   758,   759,   760,   152,   761,   762,
     763,   482,   483,   484,   485,   486,   487,   155,   156,   488,
     764,   489,   765,   490,   491,   492,   493,   494,   766,   495,
     496,   497,   498,   767,   499,   768,   500,   501,   502,  3110,
     504,   769,   505,   506,   507,   770,   508,   509,   771,   510,
     511,   512,   513,   164,   514,   515,   516,   166,   772,   517,
     773,   518,   168,   519,   774,   520,   775,   521,   169,   776,
     170,   522,   523,   524,   777,   525,   172,   778,   526,   527,
     779,   528,   529,   530,   531,   532,   173,   533,   534,   535,
     780,   536,   537,   538,   539,   540,   541,   781,   542,   174,
     175,   782,   543,   544,   545,   783,   176,   784,   177,   785,
     546,   178,   179,   547,   180,   548,   549,   550,   551,   552,
     553,   554,   786,   181,   182,   555,   183,   787,   556,   557,
     558,   788,   789,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,   188,   189,   190,   572,
     573,   574,   191,   790,   575,   576,   193,   577,   791,   194,
     578,   195,   579,   580,   581,   792,   582,   793,   794,   583,
     584,   585,   795,   796,   196,   197,   198,   199,   200,   586,
     587,   588,   589,   590,   591,   592,   797,   593,   201,   594,
     202,   595,   596,   597,   598,   798,   599,   600,   601,   602,
     603,   604,   605,   204,   606,   607,   608,   609,   799,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
     800,   621,   622,   210,   623,   624,   625,   626,   212,   627,
     628,   629,   630,   631,   632,   633,   634,   801,   635,   636,
     637,   638,   639,   802,  3111,   217,   641,   642,   219,   643,
     220,   803,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,   222,   804,   654,   655,   805,   656,   657,   658,
     659,   660,   661,   806,   224,   225,   807,   808,   663,   226,
     664,   227,   809,   665,   666,   667,   668,   669,   670,   810,
     811,   671,   672,   673,   674,   675,   812,   813,   676,   677,
     678,   679,   680,   814,   234,   815,   682,   235,   683,   684,
     685,   816,   817,   686,   818,   819,   687,   688,   689,   690,
     691,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     692,   693,   694,   731,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   732,   104,   105,   423,   733,     0,   107,
     108,   109,   110,   734,   735,   112,   113,   114,   115,     0,
     116,   736,   737,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,   133,   449,   450,   451,   452,   135,   136,
     137,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
     148,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,   151,   481,     0,     0,     0,     0,   152,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,   169,
       0,   170,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,   173,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
     174,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,   178,   179,   547,   180,   548,   549,   550,   551,
     552,   553,   554,     0,   181,   182,   555,   183,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,   189,   190,
     572,   573,   574,   191,     0,   575,   576,   193,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,   197,   198,   199,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,   210,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,   219,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,   235,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,   731,    86,    87,    88,   420,    90,
      91,    92,   421,     0,   422,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   732,   104,   105,   423,   733,     0,
     107,   108,   109,   110,   734,   735,   112,   113,   114,   115,
       0,   116,   736,   737,   424,   425,     0,     0,     0,   426,
     427,     0,     0,     0,     0,   428,     0,     0,     0,     0,
       0,     0,     0,     0,   429,     0,   430,     0,   431,   432,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     434,   435,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,     0,     0,     0,     0,     0,     0,     0,   445,
     446,     0,   447,   448,   133,   449,   450,   451,   452,   135,
     136,   137,   138,   139,     0,   453,   454,   455,   456,   457,
       0,     0,   458,   459,   460,   140,   461,     0,   462,   463,
     464,   465,   466,   145,     0,   467,     0,   468,   469,   470,
     471,   148,   472,   473,     0,   474,   475,   476,   477,   478,
     479,   480,     0,   151,   481,     0,     0,     0,     0,   152,
       0,     0,     0,   482,   483,   484,   485,   486,   487,   155,
     156,   488,     0,   489,     0,   490,   491,   492,   493,   494,
       0,   495,   496,   497,   498,     0,   499,     0,   500,   501,
     502,   503,   504,     0,   505,   506,   507,     0,   508,   509,
       0,   510,   511,   512,   513,   164,   514,   515,   516,   166,
       0,   517,     0,   518,   168,   519,     0,   520,     0,   521,
     169,     0,   170,   522,   523,   524,     0,   525,   172,     0,
     526,   527,     0,   528,   529,   530,   531,  1333,   173,   533,
     534,   535,     0,   536,   537,   538,   539,   540,   541,     0,
     542,   174,   175,     0,   543,   544,   545,     0,   176,     0,
     177,     0,   546,   178,   179,   547,   180,   548,   549,   550,
     551,   552,   553,   554,     0,   181,   182,   555,   183,     0,
     556,   557,   558,     0,     0,   559,   560,   561,   562,   563,
     564,   565,   566,   567,   568,   569,   570,   571,   188,   189,
     190,   572,   573,   574,   191,     0,   575,   576,   193,   577,
       0,   194,   578,   195,   579,   580,   581,     0,   582,     0,
       0,   583,   584,   585,     0,     0,   196,   197,   198,   199,
     200,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     201,   594,   202,   595,   596,   597,   598,     0,   599,   600,
     601,   602,   603,   604,   605,   204,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,   615,   616,   617,   618,
     619,   620,     0,   621,   622,   210,   623,   624,   625,   626,
     212,   627,   628,   629,   630,   631,   632,   633,   634,     0,
     635,   636,   637,   638,   639,     0,   640,   217,   641,   642,
     219,   643,   220,     0,   644,   645,   646,   647,   648,   649,
     650,   651,   652,   653,   222,     0,   654,   655,     0,   656,
     657,   658,   659,   660,   661,     0,   224,   225,     0,     0,
     663,   226,   664,   227,     0,   665,   666,   667,   668,   669,
     670,     0,     0,   671,   672,   673,   674,   675,     0,     0,
     676,   677,   678,   679,   680,   681,   234,     0,   682,   235,
     683,   684,   685,     0,     0,   686,     0,     0,   687,   688,
     689,   690,   691,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   692,   693,   694,   731,    86,    87,    88,   420,
      90,    91,    92,   421,     0,   422,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   732,   104,   105,   423,   733,
       0,   107,   108,   109,   110,   734,   735,   112,   113,   114,
     115,     0,   116,   736,   737,   424,   425,     0,     0,     0,
     426,   427,     0,     0,     0,     0,   428,     0,     0,     0,
       0,     0,     0,     0,     0,   429,     0,   430,     0,   431,
     432,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   434,   435,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,     0,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,   448,   133,   449,   450,   451,   452,
     135,   136,   137,   138,   139,     0,   453,   454,   455,   456,
     457,     0,     0,   458,   459,   460,   140,   461,     0,   462,
     463,   464,   465,   466,   145,     0,   467,     0,   468,   469,
     470,   471,   148,   472,   473,     0,   474,   475,   476,   477,
     478,   479,   480,     0,   151,   481,     0,     0,     0,     0,
     152,     0,     0,     0,   482,   483,   484,   485,   486,   487,
     155,   156,   488,     0,   489,     0,   490,   491,   492,   493,
     494,     0,   495,   496,   497,   498,     0,   499,     0,   500,
     501,   502,   503,   504,     0,   505,   506,   507,     0,   508,
     509,     0,   510,   511,   512,   513,   164,   514,   515,   516,
     166,     0,   517,     0,   518,   168,   519,     0,   520,     0,
     521,   169,     0,   170,   522,   523,   524,     0,   525,   172,
       0,   526,   527,     0,   528,   529,   530,   531,  1342,   173,
     533,   534,   535,     0,   536,   537,   538,   539,   540,   541,
       0,   542,   174,   175,     0,   543,   544,   545,     0,   176,
       0,   177,     0,   546,   178,   179,   547,   180,   548,   549,
     550,   551,   552,   553,   554,     0,   181,   182,   555,   183,
       0,   556,   557,   558,     0,     0,   559,   560,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   188,
     189,   190,   572,   573,   574,   191,     0,   575,   576,   193,
     577,     0,   194,   578,   195,   579,   580,   581,     0,   582,
       0,     0,   583,   584,   585,     0,     0,   196,   197,   198,
     199,   200,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   201,   594,   202,   595,   596,   597,   598,     0,   599,
     600,   601,   602,   603,   604,   605,   204,   606,   607,   608,
     609,     0,   610,   611,   612,   613,   614,   615,   616,   617,
     618,   619,   620,     0,   621,   622,   210,   623,   624,   625,
     626,   212,   627,   628,   629,   630,   631,   632,   633,   634,
       0,   635,   636,   637,   638,   639,     0,   640,   217,   641,
     642,   219,   643,   220,     0,   644,   645,   646,   647,   648,
     649,   650,   651,   652,   653,   222,     0,   654,   655,     0,
     656,   657,   658,   659,   660,   661,     0,   224,   225,     0,
       0,   663,   226,   664,   227,     0,   665,   666,   667,   668,
     669,   670,     0,     0,   671,   672,   673,   674,   675,     0,
       0,   676,   677,   678,   679,   680,   681,   234,     0,   682,
     235,   683,   684,   685,     0,     0,   686,     0,     0,   687,
     688,   689,   690,   691,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   692,   693,   694,   731,    86,    87,    88,
     420,    90,    91,    92,   421,     0,   422,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   732,   104,   105,   423,
     733,     0,   107,   108,   109,   110,   734,   735,   112,   113,
     114,   115,     0,   116,   736,   737,   424,   425,     0,     0,
       0,   426,   427,     0,     0,     0,     0,   428,     0,     0,
       0,     0,     0,     0,     0,     0,   429,     0,   430,     0,
     431,   432,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   434,   435,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,     0,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,   448,   133,   449,   450,   451,
     452,     0,  1878,   137,  1879,  1880,     0,   453,   454,   455,
     456,   457,     0,     0,   458,   459,  1881,  1882,   461,     0,
     462,   463,   464,   465,   466,     0,     0,   467,     0,   468,
     469,   470,   471,   148,   472,   473,     0,   474,   475,   476,
     477,   478,   479,   480,     0,   151,   481,     0,     0,     0,
       0,   152,     0,     0,     0,   482,   483,   484,   485,   486,
     487,  1883,  1884,   488,     0,   489,     0,   490,   491,   492,
     493,   494,     0,   495,   496,   497,   498,     0,   499,     0,
     500,   501,  1485,   503,   504,     0,   505,   506,   507,     0,
     508,   509,     0,   510,   511,   512,   513,     0,   514,   515,
     516,     0,     0,   517,     0,   518,  1885,   519,     0,   520,
       0,   521,   169,     0,   170,   522,   523,   524,     0,   525,
       0,     0,   526,   527,     0,   528,   529,   530,   531,   532,
     173,   533,   534,   535,  2430,   536,   537,   538,   539,   540,
     541,     0,   542,   174,  2431,     0,   543,   544,   545,  1491,
    1886,     0,  1887,     0,   546,   178,   179,   547,   180,   548,
     549,   550,   551,   552,   553,   554,     0,     0,   182,   555,
     183,     0,   556,   557,   558,     0,     0,   559,   560,   561,
     562,   563,   564,   565,   566,   567,   568,   569,   570,   571,
    1888,   189,  1889,   572,   573,   574,     0,     0,   575,   576,
     193,   577,     0,     0,   578,  1890,   579,   580,   581,     0,
     582,     0,     0,   583,   584,   585,     0,     0,  2432,   197,
     198,   199,     0,   586,   587,   588,   589,   590,   591,   592,
       0,   593,     0,   594,     0,   595,   596,   597,   598,     0,
     599,   600,   601,   602,   603,   604,   605,  1891,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,   615,   616,
     617,   618,   619,   620,     0,   621,   622,   210,   623,   624,
     625,   626,     0,   627,   628,   629,   630,   631,   632,   633,
     634,     0,   635,   636,   637,   638,   639,     0,   640,  2433,
     641,   642,   219,   643,  1893,     0,   644,   645,   646,   647,
     648,   649,   650,   651,   652,   653,     0,     0,   654,   655,
       0,   656,   657,   658,   659,   660,   661,     0,  1894,  1895,
       0,     0,   663,     0,   664,     0,     0,   665,   666,   667,
     668,   669,   670,     0,     0,   671,   672,   673,   674,   675,
       0,     0,   676,   677,   678,   679,   680,     0,  1896,  2434,
     682,   235,   683,   684,   685,     0,     0,   686,     0,     0,
     687,   688,   689,   690,   691,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   692,   693,   694,   731,    86,    87,
      88,   420,    90,    91,    92,   421,     0,   422,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   732,   104,   105,
     423,   733,     0,   107,   108,   109,   110,   734,   735,   112,
     113,   114,   115,     0,   116,   736,   737,   424,   425,     0,
       0,     0,   426,   427,     0,     0,     0,     0,   428,     0,
       0,     0,     0,     0,     0,     0,     0,   429,     0,   430,
       0,   431,   432,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   434,   435,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,     0,     0,     0,     0,     0,
       0,     0,   445,   446,     0,   447,   448,   133,   449,   450,
     451,   452,     0,  1878,   137,  1879,  1880,     0,   453,   454,
     455,   456,   457,     0,     0,   458,   459,  1881,  1882,   461,
       0,   462,   463,   464,   465,   466,     0,     0,   467,     0,
     468,   469,   470,   471,   148,   472,   473,     0,   474,   475,
     476,   477,   478,   479,   480,     0,   151,   481,     0,     0,
       0,     0,   152,     0,     0,     0,   482,   483,   484,   485,
     486,   487,  1883,  1884,   488,     0,   489,     0,   490,   491,
     492,   493,   494,     0,   495,   496,   497,   498,     0,   499,
       0,   500,   501,  1485,   503,   504,     0,   505,   506,   507,
       0,   508,   509,     0,   510,   511,   512,   513,     0,   514,
     515,   516,     0,     0,   517,     0,   518,  1885,   519,     0,
     520,     0,   521,   169,     0,   170,   522,   523,   524,     0,
     525,     0,     0,   526,   527,     0,   528,   529,   530,   531,
     532,   173,   533,   534,   535,     0,   536,   537,   538,   539,
     540,   541,     0,   542,   174,     0,     0,   543,   544,   545,
    1491,  1886,     0,  1887,     0,   546,   178,   179,   547,   180,
     548,   549,   550,   551,   552,   553,   554,     0,     0,   182,
     555,   183,     0,   556,   557,   558,     0,     0,   559,   560,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,  1888,   189,  1889,   572,   573,   574,     0,     0,   575,
     576,   193,   577,  2422,     0,   578,  1890,   579,   580,   581,
       0,   582,     0,     0,   583,   584,   585,     0,     0,     0,
     197,   198,   199,     0,   586,   587,   588,   589,   590,   591,
     592,     0,   593,     0,   594,     0,   595,   596,   597,   598,
       0,   599,   600,   601,   602,   603,   604,   605,  1891,   606,
     607,   608,   609,     0,   610,   611,   612,   613,   614,   615,
     616,   617,   618,   619,   620,     0,   621,   622,   210,   623,
     624,   625,   626,     0,   627,   628,   629,   630,   631,   632,
     633,   634,     0,   635,   636,   637,   638,   639,     0,   640,
    2433,   641,   642,   219,   643,  1893,     0,   644,   645,   646,
     647,   648,   649,   650,   651,   652,   653,     0,     0,   654,
     655,  3850,   656,   657,   658,   659,   660,   661,     0,  1894,
    1895,     0,     0,   663,     0,   664,     0,     0,   665,   666,
     667,   668,   669,   670,     0,     0,   671,   672,   673,   674,
     675,     0,     0,   676,   677,   678,   679,   680,     0,  1896,
       0,   682,   235,   683,   684,   685,     0,     0,   686,     0,
       0,   687,   688,   689,   690,   691,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   692,   693,   694,   731,    86,
      87,    88,   420,    90,    91,    92,   421,     0,   422,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   732,   104,
     105,   423,   733,     0,   107,   108,   109,   110,   734,   735,
     112,   113,   114,   115,     0,   116,   736,   737,   424,   425,
       0,     0,     0,   426,   427,     0,     0,     0,     0,   428,
       0,     0,     0,     0,     0,     0,     0,     0,   429,     0,
     430,     0,   431,   432,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   434,   435,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,     0,     0,     0,     0,
       0,     0,     0,   445,   446,     0,   447,   448,   133,   449,
     450,   451,   452,     0,  1878,   137,  1879,  1880,     0,   453,
     454,   455,   456,   457,     0,     0,   458,   459,  1881,  1882,
     461,     0,   462,   463,   464,   465,   466,     0,     0,   467,
       0,   468,   469,   470,   471,   148,   472,   473,     0,   474,
     475,   476,   477,   478,   479,   480,     0,   151,   481,     0,
       0,     0,     0,   152,     0,     0,     0,   482,   483,   484,
     485,   486,   487,  1883,  1884,   488,     0,   489,     0,   490,
     491,   492,   493,   494,     0,   495,   496,   497,   498,     0,
     499,     0,   500,   501,  1485,   503,   504,     0,   505,   506,
     507,     0,   508,   509,     0,   510,   511,   512,   513,     0,
     514,   515,   516,     0,     0,   517,     0,   518,  1885,   519,
       0,   520,     0,   521,   169,     0,   170,   522,   523,   524,
       0,   525,     0,     0,   526,   527,     0,   528,   529,   530,
     531,   532,   173,   533,   534,   535,     0,   536,   537,   538,
     539,   540,   541,     0,   542,   174,     0,     0,   543,   544,
     545,  1491,  1886,     0,  1887,     0,   546,   178,   179,   547,
     180,   548,   549,   550,   551,   552,   553,   554,     0,     0,
     182,   555,   183,     0,   556,   557,   558,     0,     0,   559,
     560,   561,   562,   563,   564,   565,   566,   567,   568,   569,
     570,   571,  1888,   189,  1889,   572,   573,   574,  2482,     0,
     575,   576,   193,   577,     0,     0,   578,  1890,   579,   580,
     581,     0,   582,     0,     0,   583,   584,   585,     0,     0,
       0,   197,   198,   199,     0,   586,   587,   588,   589,   590,
     591,   592,     0,   593,     0,   594,     0,   595,   596,   597,
     598,     0,   599,   600,   601,   602,   603,   604,   605,  1891,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,     0,   621,   622,   210,
     623,   624,   625,   626,     0,   627,   628,   629,   630,   631,
     632,   633,   634,     0,   635,   636,   637,   638,   639,     0,
     640,  1892,   641,   642,   219,   643,  1893,     0,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   653,     0,     0,
     654,   655,     0,   656,   657,   658,   659,   660,   661,     0,
    1894,  1895,     0,     0,   663,     0,   664,     0,     0,   665,
     666,   667,   668,   669,   670,     0,     0,   671,   672,   673,
     674,   675,     0,     0,   676,   677,   678,   679,   680,     0,
    1896,     0,   682,   235,   683,   684,   685,     0,     0,   686,
       0,     0,   687,   688,   689,   690,   691,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   692,   693,   694,   731,
      86,    87,    88,   420,    90,    91,    92,   421,     0,   422,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   732,
     104,   105,   423,   733,     0,   107,   108,   109,   110,   734,
     735,   112,   113,   114,   115,     0,   116,   736,   737,   424,
     425,     0,     0,     0,   426,   427,     0,     0,     0,     0,
     428,     0,     0,     0,     0,     0,     0,     0,     0,   429,
       0,   430,     0,   431,   432,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   434,   435,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,     0,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,   448,   133,
     449,   450,   451,   452,     0,  1878,   137,  1879,  1880,     0,
     453,   454,   455,   456,   457,     0,     0,   458,   459,  1881,
    1882,   461,     0,   462,   463,   464,   465,   466,     0,     0,
     467,     0,   468,   469,   470,   471,   148,   472,   473,     0,
     474,   475,   476,   477,   478,   479,   480,     0,   151,   481,
       0,     0,     0,     0,   152,     0,     0,     0,   482,   483,
     484,   485,   486,   487,  1883,  1884,   488,     0,   489,     0,
     490,   491,   492,   493,   494,     0,   495,   496,   497,   498,
       0,   499,     0,   500,   501,  1485,   503,   504,     0,   505,
     506,   507,     0,   508,   509,     0,   510,   511,   512,   513,
       0,   514,   515,   516,     0,     0,   517,     0,   518,  1885,
     519,     0,   520,     0,   521,   169,     0,   170,   522,   523,
     524,     0,   525,     0,     0,   526,   527,     0,   528,   529,
     530,   531,   532,   173,   533,   534,   535,     0,   536,   537,
     538,   539,   540,   541,     0,   542,   174,     0,     0,   543,
     544,   545,  1491,  1886,     0,  1887,     0,   546,   178,   179,
     547,   180,   548,   549,   550,   551,   552,   553,   554,     0,
       0,   182,   555,   183,     0,   556,   557,   558,     0,     0,
     559,   560,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,  1888,   189,  1889,   572,   573,   574,  3677,
       0,   575,   576,   193,   577,     0,     0,   578,  1890,   579,
     580,   581,     0,   582,     0,     0,   583,   584,   585,     0,
       0,     0,   197,   198,   199,     0,   586,   587,   588,   589,
     590,   591,   592,     0,   593,     0,   594,     0,   595,   596,
     597,   598,     0,   599,   600,   601,   602,   603,   604,   605,
    1891,   606,   607,   608,   609,     0,   610,   611,   612,   613,
     614,   615,   616,   617,   618,   619,   620,     0,   621,   622,
     210,   623,   624,   625,   626,     0,   627,   628,   629,   630,
     631,   632,   633,   634,     0,   635,   636,   637,   638,   639,
       0,   640,  1892,   641,   642,   219,   643,  1893,     0,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,     0,
       0,   654,   655,     0,   656,   657,   658,   659,   660,   661,
       0,  1894,  1895,     0,     0,   663,     0,   664,     0,     0,
     665,   666,   667,   668,   669,   670,     0,     0,   671,   672,
     673,   674,   675,     0,     0,   676,   677,   678,   679,   680,
       0,  1896,     0,   682,   235,   683,   684,   685,     0,     0,
     686,     0,     0,   687,   688,   689,   690,   691,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   692,   693,   694,
     731,    86,    87,    88,   420,    90,    91,    92,   421,     0,
     422,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     732,   104,   105,   423,   733,     0,   107,   108,   109,   110,
     734,   735,   112,   113,   114,   115,     0,   116,   736,   737,
     424,   425,     0,     0,     0,   426,   427,     0,     0,     0,
       0,   428,     0,     0,     0,     0,     0,     0,     0,     0,
     429,     0,   430,     0,   431,   432,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   434,   435,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,     0,     0,
       0,     0,     0,     0,     0,   445,   446,     0,   447,   448,
     133,   449,   450,   451,   452,     0,  1878,   137,  1879,  1880,
       0,   453,   454,   455,   456,   457,     0,     0,   458,   459,
    1881,  1882,   461,     0,   462,   463,   464,   465,   466,     0,
       0,   467,     0,   468,   469,   470,   471,   148,   472,   473,
       0,   474,   475,   476,   477,   478,   479,   480,     0,   151,
     481,     0,     0,     0,     0,   152,     0,     0,     0,   482,
     483,   484,   485,   486,   487,  1883,  1884,   488,     0,   489,
       0,   490,   491,   492,   493,   494,     0,   495,   496,   497,
     498,     0,   499,     0,   500,   501,  1485,   503,   504,     0,
     505,   506,   507,     0,   508,   509,     0,   510,   511,   512,
     513,     0,   514,   515,   516,     0,     0,   517,     0,   518,
    1885,   519,     0,   520,     0,   521,   169,     0,   170,   522,
     523,   524,     0,   525,     0,     0,   526,   527,     0,   528,
     529,   530,   531,   532,   173,   533,   534,   535,     0,   536,
     537,   538,   539,   540,   541,     0,   542,   174,     0,     0,
     543,   544,   545,  1491,  1886,     0,  1887,     0,   546,   178,
     179,   547,   180,   548,   549,   550,   551,   552,   553,   554,
       0,     0,   182,   555,   183,     0,   556,   557,   558,     0,
       0,   559,   560,   561,   562,   563,   564,   565,   566,   567,
     568,   569,   570,   571,  1888,   189,  1889,   572,   573,   574,
       0,     0,   575,   576,   193,   577,     0,     0,   578,  1890,
     579,   580,   581,     0,   582,     0,     0,   583,   584,   585,
       0,     0,     0,   197,   198,   199,     0,   586,   587,   588,
     589,   590,   591,   592,     0,   593,     0,   594,     0,   595,
     596,   597,   598,     0,   599,   600,   601,   602,   603,   604,
     605,  1891,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,   615,   616,   617,   618,   619,   620,     0,   621,
     622,   210,   623,   624,   625,   626,     0,   627,   628,   629,
     630,   631,   632,   633,   634,     0,   635,   636,   637,   638,
     639,     0,   640,  1892,   641,   642,   219,   643,  1893,     0,
     644,   645,   646,   647,   648,   649,   650,   651,   652,   653,
       0,     0,   654,   655,     0,   656,   657,   658,   659,   660,
     661,     0,  1894,  1895,     0,     0,   663,     0,   664,     0,
       0,   665,   666,   667,   668,   669,   670,     0,     0,   671,
     672,   673,   674,   675,     0,     0,   676,   677,   678,   679,
     680,     0,  1896,     0,   682,   235,   683,   684,   685,     0,
       0,   686,     0,     0,   687,   688,   689,   690,   691,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   692,   693,
     694,   731,    86,    87,    88,   420,    90,    91,    92,   421,
       0,   422,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   732,   104,   105,   423,   733,     0,   107,   108,   109,
     110,   734,   735,   112,   113,   114,   115,     0,   116,   736,
     737,   424,   425,     0,     0,     0,   426,   427,     0,     0,
       0,     0,   428,     0,     0,     0,     0,     0,     0,     0,
       0,   429,     0,   430,     0,   431,   432,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   434,   435,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,     0,
       0,     0,     0,     0,     0,     0,   445,   446,     0,   447,
     448,   133,   449,   450,   451,   452,     0,  1878,   137,  1879,
    1880,     0,   453,   454,   455,   456,   457,     0,     0,   458,
     459,  1881,  1882,   461,     0,   462,   463,   464,   465,   466,
       0,     0,   467,     0,   468,   469,   470,   471,   148,   472,
     473,     0,   474,   475,   476,   477,   478,   479,   480,     0,
     151,   481,     0,     0,     0,     0,   152,     0,     0,     0,
     482,   483,   484,   485,   486,   487,  1883,  1884,   488,     0,
     489,     0,   490,   491,   492,   493,   494,     0,   495,   496,
     497,   498,     0,   499,     0,   500,   501,  1485,   503,   504,
       0,   505,   506,   507,     0,   508,   509,     0,   510,   511,
     512,   513,     0,   514,   515,   516,     0,     0,   517,     0,
     518,  1885,   519,     0,   520,     0,   521,   169,     0,   170,
     522,   523,   524,     0,   525,     0,     0,   526,   527,     0,
     528,   529,   530,   531,   532,   173,   533,   534,   535,     0,
     536,   537,   538,   539,   540,   541,     0,   542,   174,     0,
       0,   543,   544,   545,  1491,  1886,     0,  1887,     0,   546,
     178,   179,   547,   180,   548,   549,   550,   551,   552,   553,
     554,     0,     0,   182,   555,   183,     0,   556,   557,   558,
       0,     0,   559,   560,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,  1888,   189,  1889,   572,   573,
     574,     0,     0,   575,   576,   193,   577,     0,     0,   578,
    1890,   579,   580,   581,     0,   582,     0,     0,   583,   584,
     585,     0,     0,     0,   197,   198,   199,     0,   586,   587,
     588,   589,   590,   591,   592,     0,   593,     0,   594,     0,
     595,   596,   597,   598,     0,   599,   600,   601,   602,   603,
     604,   605,  1891,   606,   607,   608,   609,     0,   610,   611,
     612,   613,   614,   615,   616,   617,   618,   619,   620,     0,
     621,   622,   210,   623,   624,   625,   626,     0,   627,   628,
     629,   630,   631,   632,   633,   634,     0,   635,   636,   637,
     638,   639,     0,   640,  2433,   641,   642,   219,   643,  1893,
       0,   644,   645,   646,   647,   648,   649,   650,   651,   652,
     653,     0,     0,   654,   655,     0,   656,   657,   658,   659,
     660,   661,     0,  1894,  1895,     0,     0,   663,     0,   664,
       0,     0,   665,   666,   667,   668,   669,   670,     0,     0,
     671,   672,   673,   674,   675,     0,     0,   676,   677,   678,
     679,   680,     0,  1896,     0,   682,   235,   683,   684,   685,
       0,     0,   686,     0,     0,   687,   688,   689,   690,   691,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   692,
     693,   694,   731,    86,    87,    88,   420,    90,    91,    92,
     421,     0,   422,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   732,   104,   105,   423,   733,     0,   107,   108,
     109,   110,   734,   735,   112,   113,   114,   115,     0,   116,
     736,   737,   424,   425,     0,     0,     0,   426,   427,     0,
       0,     0,     0,   428,     0,     0,     0,     0,     0,     0,
       0,     0,   429,     0,   430,     0,   431,   432,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   434,   435,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
       0,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,   448,   133,   449,   450,   451,   452,     0,  1878,   137,
    1879,  1880,     0,   453,   454,   455,   456,   457,     0,     0,
     458,   459,  1881,  1882,   461,     0,   462,   463,   464,   465,
     466,     0,     0,   467,     0,   468,   469,   470,   471,   148,
     472,   473,     0,   474,   475,   476,   477,   478,   479,   480,
       0,   151,   481,     0,     0,     0,     0,   152,     0,     0,
       0,   482,   483,   484,   485,   486,   487,  1883,  1884,   488,
       0,   489,     0,   490,   491,   492,   493,   494,     0,   495,
     496,   497,   498,     0,   499,     0,   500,   501,  1485,   503,
     504,     0,   505,   506,   507,     0,   508,   509,     0,   510,
     511,   512,   513,     0,   514,   515,   516,     0,     0,   517,
       0,   518,  1885,   519,     0,   520,     0,   521,   169,     0,
     170,   522,   523,   524,     0,   525,     0,     0,   526,   527,
       0,   528,   529,   530,   531,   532,   173,   533,   534,   535,
       0,   536,   537,   538,   539,   540,   541,     0,   542,   174,
       0,     0,   543,   544,   545,  1491,  1886,     0,  1887,     0,
     546,   178,   179,   547,   180,   548,   549,   550,   551,   552,
     553,   554,     0,     0,   182,   555,   183,     0,   556,   557,
     558,     0,     0,   559,   560,   561,   562,   563,   564,   565,
     566,   567,   568,   569,   570,   571,  1888,   189,  1889,   572,
     573,   574,     0,     0,   575,   576,   193,   577,     0,     0,
     578,  1890,   579,   580,   581,     0,   582,     0,     0,   583,
     584,   585,     0,     0,     0,   197,   198,   199,     0,   586,
     587,   588,   589,   590,   591,   592,     0,   593,     0,   594,
       0,   595,   596,   597,   598,     0,   599,   600,   601,   602,
     603,   604,   605,  1891,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,   615,   616,   617,   618,   619,   620,
       0,   621,   622,   210,   623,   624,   625,   626,     0,   627,
     628,   629,   630,   631,   632,   633,   634,     0,   635,   636,
     637,   638,   639,     0,   640,     0,   641,   642,   219,   643,
    1893,     0,   644,   645,   646,   647,   648,   649,   650,   651,
     652,   653,     0,     0,   654,   655,     0,   656,   657,   658,
     659,   660,   661,     0,  1894,  1895,     0,     0,   663,     0,
     664,     0,     0,   665,   666,   667,   668,   669,   670,     0,
       0,   671,   672,   673,   674,   675,     0,     0,   676,   677,
     678,   679,   680,     0,  1896,     0,   682,   235,   683,   684,
     685,     0,     0,   686,     0,     0,   687,   688,   689,   690,
     691,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     692,   693,   694,   731,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   732,   104,   105,   423,   733,     0,   107,
     108,   109,   110,   734,   735,   112,   113,   114,   115,     0,
     116,   736,   737,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,   133,   449,   450,   451,   452,     0,     0,
     137,     0,     0,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,     0,     0,   461,     0,   462,   463,   464,
     465,   466,     0,     0,   467,     0,   468,   469,   470,   471,
     148,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,   151,   481,     0,     0,     0,     0,   152,     0,
       0,     0,   482,   483,   484,   485,   486,   487,     0,     0,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,     0,   514,   515,   516,     0,     0,
     517,     0,   518,     0,   519,     0,   520,     0,   521,   169,
       0,   170,   522,   523,   524,     0,   525,     0,     0,   526,
     527,     0,   528,   529,   530,   531,   532,   173,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
     174,     0,     0,   543,   544,   545,     0,     0,     0,     0,
       0,   546,   178,   179,   547,   180,   548,   549,   550,   551,
     552,   553,   554,     0,     0,   182,   555,   183,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,     0,   189,     0,
     572,   573,   574,     0,     0,   575,   576,   193,   577,     0,
       0,   578,     0,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,     0,   197,   198,   199,     0,
     586,   587,   588,   589,   590,   591,   592,     0,   593,     0,
     594,     0,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,     0,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,   210,   623,   624,   625,   626,     0,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,     0,   641,   642,   219,
     643,     0,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,     0,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,     0,     0,     0,     0,   663,
       0,   664,     0,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,     0,     0,     0,   682,   235,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,   738,   442,   443,
     444,   739,   740,   741,   742,   743,   744,   745,   445,   446,
     746,   447,   448,   133,   449,   450,   451,   452,   135,   136,
     137,   138,   139,   747,   453,   454,   455,   456,   457,   748,
     749,   458,   459,     0,   140,   461,   751,   462,   463,   464,
     465,   466,   145,   752,   467,   753,   468,   469,   470,   471,
     148,   472,   754,   755,   474,   475,   476,   477,   478,   479,
     480,   756,   151,   481,     0,   758,   759,   760,   152,   761,
     762,   763,   482,   483,   484,   485,     0,   487,   155,   156,
     488,   764,   489,   765,   490,   491,   492,   493,   494,   766,
     495,   496,   497,   498,   767,   499,   768,   500,   501,   502,
     503,   504,   769,   505,   506,   507,   770,   508,   509,   771,
     510,   511,   512,   513,   164,   514,   515,   516,   166,   772,
     517,   773,   518,   168,   519,   774,   520,   775,   521,   169,
     776,   170,   522,   523,   524,   777,   525,   172,   778,   526,
     527,   779,   528,   529,     0,   531,   532,   173,   533,   534,
     535,   780,   536,   537,   538,   539,   540,   541,   781,   542,
     174,   175,     0,   543,   544,   545,     0,   176,   784,   177,
     785,   546,   178,   179,   547,   180,   548,   549,   550,   551,
     552,   553,   554,   786,   181,   182,   555,   183,   787,   556,
     557,   558,   788,   789,   559,   560,   561,   562,   563,     0,
     565,   566,   567,     0,   569,   570,   571,   188,   189,   190,
     572,   573,   574,   191,   790,   575,   576,   193,   577,   791,
     194,   578,   195,   579,   580,   581,   792,   582,   793,   794,
     583,   584,   585,   795,   796,   196,   197,   198,   199,   200,
     586,   587,   588,   589,   590,   591,   592,   797,   593,   201,
     594,   202,   595,   596,   597,   598,   798,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,   799,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,   800,   621,   622,   210,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,     0,   634,   801,   635,
     636,   637,   638,   639,   802,   640,   217,   641,   642,   219,
     643,   220,   803,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,   804,   654,   655,   805,   656,   657,
     658,   659,   660,   661,   806,   224,   225,     0,   808,   663,
     226,   664,   227,   809,   665,   666,   667,   668,   669,   670,
       0,   811,   671,   672,   673,   674,   675,   812,   813,   676,
     677,   678,   679,   680,     0,   234,   815,   682,   235,   683,
     684,   685,   816,   817,   686,   818,   819,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,     0,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,  2033,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,  2034,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,  2035,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,   662,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,  1151,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,  2231,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,  2380,   462,   463,   464,
     465,   466,   145,     0,   467,  2445,   468,   469,   470,   471,
       0,   472,   473,  2381,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
    2446,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,  2383,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,  2384,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,  2385,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,  2380,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,  2381,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
    2446,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,  2383,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,  3300,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,  2384,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,  2385,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,  1050,   440,   441,  1009,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,  1010,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,  1051,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,  1011,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,  1012,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  2011,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,  1009,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,  1010,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,  3020,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,  1011,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,  1012,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,  2380,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,  2381,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
    2446,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,  2383,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,  2384,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,  2385,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,   714,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,   715,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,   716,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,  1009,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,  1010,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,  1011,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,  1012,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,   923,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,   924,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   925,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,  2068,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,  2069,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,  2070,   521,     0,
       0,     0,  2071,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,  2072,  2073,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,  2074,   631,   632,   633,   634,     0,  2075,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,  2076,   656,  2077,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,  1010,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,  1011,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,  1012,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   130,   131,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,  1390,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,  2057,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,  2338,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,  2897,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,  2898,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,  2899,   656,   657,
    2900,   659,  2901,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,  2902,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,   723,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,   716,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,   873,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,  1325,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,  2533,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,  2534,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   130,   131,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,  3093,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,  3094,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,  3105,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,  3106,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   929,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   972,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   973,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
     433,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,  1026,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,  1082,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,  1294,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,  1347,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,  1570,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,  1964,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,  2057,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,  2338,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,  3367,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,  3986,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,  3999,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,  4148,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,  4201,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,  4203,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,  4205,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,  4582,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,  1034,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,  1036,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,  1037,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,     0,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,  1038,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,  1039,   225,     0,     0,  1040,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,  1041,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,  1076,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,  1037,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,     0,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,  1077,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,  1078,   225,     0,     0,  1079,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,  1041,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,  1096,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,  1230,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1285,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,  1308,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1338,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1344,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1354,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1356,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1358,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1360,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1363,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1365,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,  1366,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1369,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,  1581,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,  1063,   459,  1037,   140,  1582,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,     0,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,  1067,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,  1068,   625,   626,   212,
     627,   628,   629,  1069,   631,   632,   633,   634,     0,   635,
     636,   637,   638,  1574,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,  1071,   225,     0,     0,  1072,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,  1041,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,  1073,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,  1705,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1924,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1954,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1989,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  1991,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,  2103,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,  2305,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,   532,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,     0,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  2666,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   682,     0,   683,
     684,   685,     0,     0,   686,     0,     0,   687,   688,   689,
     690,   691,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   692,   693,   694,    86,    87,    88,   420,    90,    91,
      92,   421,     0,   422,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   423,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   424,   425,     0,     0,     0,   426,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0,   429,     0,   430,     0,   431,   432,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   434,
     435,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,   448,     0,   449,   450,   451,   452,   135,   136,
       0,   138,   139,     0,   453,   454,   455,   456,   457,     0,
       0,   458,   459,   460,   140,   461,     0,   462,   463,   464,
     465,   466,   145,     0,   467,     0,   468,   469,   470,   471,
       0,   472,   473,     0,   474,   475,   476,   477,   478,   479,
     480,     0,     0,   481,     0,     0,     0,     0,     0,     0,
       0,     0,   482,   483,   484,   485,   486,   487,   155,   156,
     488,     0,   489,     0,   490,   491,   492,   493,   494,     0,
     495,   496,   497,   498,     0,   499,     0,   500,   501,   502,
     503,   504,     0,   505,   506,   507,     0,   508,   509,     0,
     510,   511,   512,   513,   164,   514,   515,   516,   166,     0,
     517,     0,   518,   168,   519,     0,   520,     0,   521,     0,
       0,     0,   522,   523,   524,     0,   525,   172,     0,   526,
     527,     0,   528,   529,   530,   531,  3096,     0,   533,   534,
     535,     0,   536,   537,   538,   539,   540,   541,     0,   542,
       0,   175,     0,   543,   544,   545,     0,   176,     0,   177,
       0,   546,     0,     0,   547,     0,   548,   549,   550,   551,
     552,   553,   554,     0,   181,     0,   555,     0,     0,   556,
     557,   558,     0,     0,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   188,     0,   190,
     572,   573,   574,   191,     0,   575,   576,     0,   577,     0,
     194,   578,   195,   579,   580,   581,     0,   582,     0,     0,
     583,   584,   585,     0,     0,   196,     0,     0,     0,   200,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   201,
     594,   202,   595,   596,   597,   598,     0,   599,   600,   601,
     602,   603,   604,   605,   204,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,   615,   616,   617,   618,   619,
     620,     0,   621,   622,     0,   623,   624,   625,   626,   212,
     627,   628,   629,   630,   631,   632,   633,   634,     0,   635,
     636,   637,   638,   639,     0,   640,   217,   641,   642,     0,
     643,   220,     0,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   222,     0,   654,   655,     0,   656,   657,
     658,   659,   660,   661,     0,   224,   225,     0,     0,   663,
     226,   664,   227,     0,   665,   666,   667,   668,   669,   670,
       0,     0,   671,   672,   673,   674,   675,     0,     0,   676,
     677,   678,   679,   680,   681,   234,     0,   68