/*
 * MultiPoint.java
 * 
 * PostGIS extension for PostgreSQL JDBC driver - geometry model
 * 
 * (C) 2004 Paul Ramsey, pramsey@refractions.net
 * 
 * (C) 2005 Markus Schaber, markus@schabi.de
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 2.1 of the License.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA or visit the web at
 * http://www.gnu.org.
 * 
 * $Id: MultiPoint.java,v 1.5 2005/03/30 15:24:40 mschaber Exp $
 */

package org.postgis;

import java.sql.SQLException;

public class MultiPoint extends PointComposedGeom {
    /* JDK 1.5 Serialization */
    private static final long serialVersionUID = 0x100;

    public MultiPoint() {
        super(MULTIPOINT);
    }

    public MultiPoint(Point[] points) {
        super(MULTIPOINT, points);
    }

    public MultiPoint(String value) throws SQLException {
        this(value, false);
    }

    protected MultiPoint(String value, boolean haveM) throws SQLException {
        super(MULTIPOINT, value, haveM);
    }
}