/*
 * This file is part of the xTuple ERP: PostBooks Edition, a free and
 * open source Enterprise Resource Planning software suite,
 * Copyright (c) 1999-2014 by OpenMFG LLC, d/b/a xTuple.
 * It is licensed to you under the Common Public Attribution License
 * version 1.0, the full text of which (including xTuple-specific Exhibits)
 * is available at www.xtuple.com/CPAL.  By using this software, you agree
 * to be bound by its terms.
 */

#include "errorReporter.h"

#include <QApplication>
#include <QMap>
#include <QMessageBox>
#include <QRegExp>
#include <QSourceLocation>
#include <QVariant>

#include "storedProcErrorLookup.h"

// TODO: expose to scripting
// TOOD: allow extending the list to constraints in packages

enum StatementType { Unknown = 0, Select = 1, Delete = 2,
                     Update = 4,  Insert = 8, Upsert = 4 + 8 };

/* short term strategy: put messages here and use storedProcErrorLookup whenever possible.
   longer term: combine the lists of messages and have a single lookup table
 */
const struct {
  QString constraint;
  int     type;
  int     lookup;       // != 0 implies msg is a storedproc lookup key
  QString msg;
} dberrs[] = {
// TODO: fill in with appropriate text and uncomment
//{ "accnt_accnt_company_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "accnt_accnt_company_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "accnt_accnt_type_check",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "accnt_to_curr_symbol",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "accnt_to_curr_symbol",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "addr_addr_number_key",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Address already exists with this address number.") },
  { "addr_addr_number_check",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot set the address number to an empty value.") },
//{ "apapply_apapply_checkhead_id_fkey",Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "apapply_apapply_vend_id_fkey",     Delete, -6, "deleteVendor" },
  { "apapply_apapply_vend_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot create an A/P Application for an invalid Vendor.") },
//{ "apapply_to_curr_symbol",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "apapply_to_curr_symbol",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "apcreditapply_curr_symbol",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "apcreditapply_curr_symbol",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "apopen_apopen_status_check",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "apopen_apopen_status_notnull",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "apopen_apopen_status_notnull",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "apopen_apopen_vend_id_fkey",       Delete, -5, "deleteVendor" },
  { "apopen_apopen_vend_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot create an A/P Open Item for an invalid Vendor.") },
//{ "apopen_to_curr_symbol",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "apopen_to_curr_symbol",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "apopentax_taxhist_basis_tax_id_fkey", Delete, 0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "apopentax_taxhist_basis_tax_id_fkey", Upsert, 0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "apopentax_taxhist_parent_id_fkey", Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "apopentax_taxhist_parent_id_fkey", Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "apopentax_taxhist_tax_id_fkey",    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "apopentax_taxhist_tax_id_fkey",    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "apopentax_taxhist_taxtype_id_fkey",Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "apopentax_taxhist_taxtype_id_fkey",Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "apselect_apselect_apopen_id_key",  Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "apselect_to_curr_symbol",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "apselect_to_curr_symbol",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "arapply_to_curr_symbol",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "arapply_to_curr_symbol",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "arcreditapply_curr_symbol",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "arcreditapply_curr_symbol",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "aropen_aropen_cust_id_fkey",       Delete,  -5, "deleteCustomer" },
//{ "aropen_aropen_cust_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "aropen_aropen_salesrep_id_fkey",   Delete,  -3, "deleteSalesRep" },
//{ "aropen_aropen_salesrep_id_fkey",   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "aropen_to_curr_symbol",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "aropen_to_curr_symbol",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "aropentax_taxhist_basis_tax_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "aropentax_taxhist_basis_tax_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "aropentax_taxhist_parent_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "aropentax_taxhist_parent_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "aropentax_taxhist_tax_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "aropentax_taxhist_tax_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "aropentax_taxhist_taxtype_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "aropentax_taxhist_taxtype_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "asohist_asohist_taxtype_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "asohist_asohist_taxtype_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "asohist_asohist_taxzone_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "asohist_asohist_taxzone_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "asohist_to_curr_symbol",                   Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "asohist_to_curr_symbol",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "asohisttax_taxhist_basis_tax_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "asohisttax_taxhist_basis_tax_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "asohisttax_taxhist_parent_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "asohisttax_taxhist_parent_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "asohisttax_taxhist_tax_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "asohisttax_taxhist_tax_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "asohisttax_taxhist_taxtype_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "asohisttax_taxhist_taxtype_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "atlasmap_atlasmap_name_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Atlas Map name is required.") },
  { "atlasmap_atlasmap_name_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Atlas Map already exists with this name.") },
  { "bankaccnt_bankaccnt_name_check",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Bank Account name is required.") },
  { "bankaccnt_bankaccnt_name_key",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Bank Account already exists with this name.") },
//{ "bankaccnt_to_curr_symbol",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bankaccnt_to_curr_symbol",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bankadj_to_curr_symbol",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bankadj_to_curr_symbol",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "bankadjtype_bankadjtype_name_key", Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Bank Adjustment Type name is required.") },
  { "bankadjtype_bankadjtype_name_key", Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Bank Adjustment Type already exists with this name.") },
//{ "bomhead_bomhead_batchsize_check",  Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomhead_bomhead_item_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomhead_bomhead_item_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomhist_bomhist_char_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomhist_bomhist_char_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomitem_bomitem_char_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomitem_bomitem_char_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomitem_bomitem_issuemethod_check",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomitem_bomitem_item_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomitem_bomitem_item_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomitem_bomitem_parent_item_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomitem_bomitem_parent_item_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomitem_bomitem_subtype_check",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomitem_bomitem_uom_id_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomitem_bomitem_uom_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomitemsub_bomitemsub_bomitem_id_fkey",    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomitemsub_bomitemsub_bomitem_id_fkey",    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomitemsub_bomitemsub_item_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomitemsub_bomitemsub_item_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomwork_bomwork_char_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "bomwork_bomwork_char_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "budghead_budghead_name_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Budget name is required.") },
  { "budghead_budghead_name_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Budget already exists with this name.") },
//{ "budgitem_budgitem_budghead_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "budgitem_budgitem_budghead_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "budgitem_budgitem_period_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "budgitem_budgitem_period_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "calhead_calhead_name_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Calendar name is required.") },
  { "calhead_calhead_name_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Calendar already exists with this name.") },
//{ "cashrcpt_bankaccnt_bankaccnt_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cashrcpt_bankaccnt_bankaccnt_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "cashrcpt_cashrcpt_number_check",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Cash Receipt number is required.") },
  { "cashrcpt_cashrcpt_number_key",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Cash Receipt already exists with this number.") },
//{ "cashrcpt_cust_cust_id_fkey",               Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cashrcpt_cust_cust_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cashrcpt_to_curr_symbol",                  Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cashrcpt_to_curr_symbol",                  Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cashrcptitem_aropen_aropen_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cashrcptitem_aropen_aropen_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cashrcptitem_cashrcpt_cashrcpt_id_fkey",   Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cashrcptitem_cashrcpt_cashrcpt_id_fkey",   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cashrcptmisc_accnt_accnt_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cashrcptmisc_accnt_accnt_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cashrcptmisc_cashrcpt_cashrcpt_id_fkey",   Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cashrcptmisc_cashrcpt_cashrcpt_id_fkey",   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "ccard_ccard_cust_id_fkey",                 Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "The selected Customer cannot be deleted as it has Credit Cards defined for it.") },
//{ "ccard_ccard_cust_id_fkey",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ccbank_ccbank_bankaccnt_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ccbank_ccbank_bankaccnt_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ccbank_ccbank_ccard_type_check",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ccbank_ccbank_ccard_type_key",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
  { "char_char_name_check",                     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Characteristic name is required.") },
  { "char_char_name_key",                       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Characteristic already exists with this name.") },
//{ "charopt_charopt_char_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "charopt_charopt_char_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "checkhead_checkhead_amount_check",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "checkhead_checkhead_bankaccnt_id_fkey",    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "checkhead_checkhead_curr_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "checkhead_checkhead_expcat_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "checkhead_checkhead_recip_type_check",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "checkitem_check",                          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "checkitem_checkitem_apopen_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "checkitem_checkitem_aropen_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "checkitem_checkitem_checkhead_id_fkey",    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "checkitem_checkitem_curr_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "chk_wo_cosmethod",                         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "chk_wo_cosmethod",                         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "classcode_classcode_code_check",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Class Code is required.") },
  { "classcode_classcode_code_key",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Class Code already exists with this code.") },
//{ "cmdarg_cmdarg_cmd_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmdarg_cmdarg_cmd_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "cmhead_cmhead_cust_id_fkey",               Delete, -3, "deleteCustomer" },
//{ "cmhead_cmhead_cust_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmhead_cmhead_freighttaxtype_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmhead_cmhead_freighttaxtype_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "cmhead_cmhead_number_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Return number is required.") },
  { "cmhead_cmhead_number_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Return already exists with this number.") },
//{ "cmhead_cmhead_prj_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmhead_cmhead_prj_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "cmhead_cmhead_salesrep_id_fkey",           Delete, -3, "deleteSalesRep" },
//{ "cmhead_cmhead_salesrep_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmhead_cmhead_taxzone_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmhead_cmhead_taxzone_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmhead_to_curr_symbol",                    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmhead_to_curr_symbol",                    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmheadtax_taxhist_basis_tax_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmheadtax_taxhist_basis_tax_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmheadtax_taxhist_parent_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmheadtax_taxhist_parent_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmheadtax_taxhist_tax_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmheadtax_taxhist_tax_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmheadtax_taxhist_taxtype_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmheadtax_taxhist_taxtype_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmitem_cmhead_id_fkey",                    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmitem_cmhead_id_fkey",                    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmitem_cmhead_id_linenumber_unique",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmitem_cmhead_id_linenumber_unique",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmitem_cmitem_price_uom_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmitem_cmitem_price_uom_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmitem_cmitem_qty_uom_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmitem_cmitem_qty_uom_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmitem_cmitem_taxtype_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmitem_cmitem_taxtype_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmitemtax_taxhist_basis_tax_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmitemtax_taxhist_basis_tax_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmitemtax_taxhist_parent_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmitemtax_taxhist_parent_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmitemtax_taxhist_tax_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmitemtax_taxhist_tax_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmitemtax_taxhist_taxtype_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cmitemtax_taxhist_taxtype_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "cmnttype_cmnttype_name_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Comment Type name is required.") },
  { "cmnttype_cmnttype_name_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Comment Type already exists with this name.") },
//{ "cntct_cntct_addr_id_fkey",                 Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cntct_cntct_addr_id_fkey",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "cntct_cntct_crmacct_id_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot delete a Account with attached Contacts.") },
  { "cntct_cntct_crmacct_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot attach a Contact to an invalid Account.") },
  { "cntct_cntct_number_key",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Contact already exists with this number.") },
//{ "cntcteml_cntcteml_cntct_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cntcteml_cntcteml_cntct_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cntctmrgd_cntctmrgd_cntct_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cntctmrgd_cntctmrgd_cntct_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cntctsel_cntctsel_cntct_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cntctsel_cntctsel_cntct_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobill_cobill_invcitem_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobill_cobill_invcitem_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobill_cobill_taxtype_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobill_cobill_taxtype_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobilltax_taxhist_basis_tax_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobilltax_taxhist_basis_tax_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobilltax_taxhist_parent_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobilltax_taxhist_parent_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobilltax_taxhist_tax_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobilltax_taxhist_tax_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobilltax_taxhist_taxtype_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobilltax_taxhist_taxtype_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobmisc_cobmisc_invchead_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobmisc_cobmisc_invchead_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobmisc_cobmisc_taxtype_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobmisc_cobmisc_taxtype_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobmisc_cobmisc_taxzone_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobmisc_cobmisc_taxzone_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobmisc_to_curr_symbol",                   Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobmisc_to_curr_symbol",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobmisctax_taxhist_basis_tax_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobmisctax_taxhist_basis_tax_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobmisctax_taxhist_parent_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobmisctax_taxhist_parent_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobmisctax_taxhist_tax_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobmisctax_taxhist_tax_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobmisctax_taxhist_taxtype_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cobmisctax_taxhist_taxtype_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_billto_cntct_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_billto_cntct_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_cust_id_fkey",               Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_cust_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_misc_accnt_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_misc_accnt_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "cohead_cohead_number_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Sales Order number is required.") },
  { "cohead_cohead_number_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Sales Order already exists with this Sales Order number.") },
//{ "cohead_cohead_ophead_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_ophead_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_prj_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_prj_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "cohead_cohead_salesrep_id_fkey",           Delete, -3, "deleteSalesRep" },
//{ "cohead_cohead_salesrep_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_shipform_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_shipform_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_shipto_cntct_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_shipto_cntct_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "cohead_cohead_shipto_id_fkey",             Delete, -2, "deleteShipto" },
//{ "cohead_cohead_shipto_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_taxtype_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_taxtype_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_taxzone_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_taxzone_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_terms_id_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_terms_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_warehous_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_cohead_warehous_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "cohead_number_idx",                        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Sales Order already exists with this Sales Order number.") },
//{ "cohead_to_curr_symbol",                    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohead_to_curr_symbol",                    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "cohist_cohist_cust_id_fkey",               Delete, -2, "deleteCustomer" },
//{ "cohist_cohist_cust_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "cohist_cohist_salesrep_id_fkey",           Delete, -3, "deleteSalesRep" },
  { "cohist_cohist_salesrep_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot save Sales Order History for an invalid Sales Rep.") },
//{ "cohist_cohist_taxtype_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohist_cohist_taxtype_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohist_cohist_taxzone_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohist_cohist_taxzone_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohist_to_curr_symbol",                    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohist_to_curr_symbol",                    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohisttax_taxhist_basis_tax_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohisttax_taxhist_basis_tax_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohisttax_taxhist_parent_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohisttax_taxhist_parent_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohisttax_taxhist_tax_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohisttax_taxhist_tax_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohisttax_taxhist_taxtype_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cohisttax_taxhist_taxtype_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "coitem_coitem_cohead_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "coitem_coitem_cohead_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "coitem_coitem_cos_accnt_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "coitem_coitem_cos_accnt_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "coitem_coitem_itemsite_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "coitem_coitem_itemsite_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "coitem_coitem_price_uom_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "coitem_coitem_price_uom_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "coitem_coitem_qty_uom_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "coitem_coitem_qty_uom_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "coitem_coitem_status_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "coitem_coitem_substitute_item_id_fkey",    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "coitem_coitem_substitute_item_id_fkey",    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "coitem_coitem_taxtype_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "coitem_coitem_taxtype_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "comment_comment_cmnttype_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "comment_comment_cmnttype_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "company_company_curr_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "company_company_curr_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "company_company_dscrp_accnt_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "company_company_dscrp_accnt_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "company_company_gainloss_accnt_id_fkey",   Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "company_company_gainloss_accnt_id_fkey",   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "company_company_number_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Company Number is required.") },
  { "company_company_number_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Company already exists with this number.") },
//{ "company_company_unrlzgainloss_accnt_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "company_company_unrlzgainloss_accnt_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "company_company_yearend_accnt_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "company_company_yearend_accnt_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "costcat_costcat_code_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Cost Category code is required.") },
  { "costcat_costcat_code_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Cost Category already exists with this code.") },
  { "costelem_costelem_type_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Cost Element type is required.") },
  { "costelem_costelem_type_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Cost Element already exists with this type.") },
//{ "costhist_new_to_curr_symbol",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "costhist_new_to_curr_symbol",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "costhist_old_to_curr_symbol",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "costhist_old_to_curr_symbol",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "costupdate_costupdate_item_id_key",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
  { "country_country_abbr_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot set the country abbreviation to an empty string.") },
  { "country_country_abbr_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Country already exists with this abbreviation.") },
  { "country_country_name_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot set the country name to an empty string.") },
  { "country_country_name_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Country already exists with this name.") },
  { "crmacct_crmacct_cntct_id_1_fkey",          Delete, -1, "deleteContact" },
//{ "crmacct_crmacct_cntct_id_1_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "crmacct_crmacct_cntct_id_2_fkey",          Delete, -1, "deleteContact" },
//{ "crmacct_crmacct_cntct_id_2_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "crmacct_crmacct_cust_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot delete the Account since it is still associated with a Customer.") },
  { "crmacct_crmacct_cust_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot set the Account to an invalid Customer.") },
  { "crmacct_crmacct_emp_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot set the Account to an invalid Employee.") },
  { "crmacct_crmacct_number_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Account number is required.") },
  { "crmacct_crmacct_number_key",               Upsert, -1, "createCrmAcct" },
  { "crmacct_crmacct_parent_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot delete the Account because it is the parent of another Account.") },
  { "crmacct_crmacct_parent_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot save a Account with an invalid parent Account.") },
  { "crmacct_crmacct_prospect_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot delete the Account since it is still associated with a Prospect.") },
  { "crmacct_crmacct_prospect_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot set the Account to an invalid Prospect.") },
  { "crmacct_crmacct_salesrep_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "The Sales Rep cannot be deleted as s/he is still associated with a Account.") },
  { "crmacct_crmacct_salesrep_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot set the Account to an invalid Sales Rep.") },
  { "crmacct_crmacct_taxauth_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot set the Account to an invalid Tax Authority.") },
//{ "crmacct_crmacct_type_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "crmacct_crmacct_usr_username_check",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "crmacct_crmacct_vend_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot delete the Account since it is still associated with a Vendor.") },
  { "crmacct_crmacct_vend_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot set the Account to an invalid Vendor.") },
//{ "crmacct_owner_username_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "curr_rate_curr_id_key",                    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "curr_rate_curr_rate_check",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "curr_rate_to_curr_symbol",                 Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "curr_rate_to_curr_symbol",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "curr_symbol_curr_abbr_key",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "curr_symbol_curr_name_key",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "cust_creditlmt_to_curr_symbol",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cust_creditlmt_to_curr_symbol",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cust_to_curr_symbol",                      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "cust_to_curr_symbol",                      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "custgrp_custgrp_name_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Customer Group name is required.") },
  { "custgrp_custgrp_name_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Customer Gropu already exists with this name.") },
//{ "custinfo_balmethod_check",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "custinfo_creditstatus_check",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "custinfo_cust_cntct_id_fkey",              Delete, -2, "deleteContact" },
//{ "custinfo_cust_cntct_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "custinfo_cust_corrcntct_id_fkey",          Delete, -2, "deleteContact" },
//{ "custinfo_cust_corrcntct_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "custinfo_cust_custtype_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "custinfo_cust_custtype_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "custinfo_cust_number_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Customer number is required.") },
  { "custinfo_cust_number_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Customer already exists with this number.") },
  { "custinfo_cust_salesrep_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot save the Customer with an invalid Sales Rep." ) },
//{ "custinfo_cust_shipform_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "custinfo_cust_shipform_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "custinfo_cust_taxzone_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "custinfo_cust_taxzone_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "custinfo_cust_terms_fkey",                 Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "custinfo_cust_terms_fkey",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "custtype_custtype_code_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Customer Type code is required.") },
  { "custtype_custtype_code_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Customer Type already exists with this code.") },
  { "dept_dept_number_check",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Department number is required.") },
  { "dept_dept_number_key",                     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Department already exists with this number.") },
//{ "docass_docass_purpose_check",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "emp_check",                                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Employee Type is invalid.") },
  { "emp_emp_cntct_id_fkey",                    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "This Contact cannot be deleted as s/he is the Contact for an Employee.") },
  { "emp_emp_cntct_id_fkey",                    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "This Employee cannot be connected to what seems to be a non-existent Contact.") },
  { "emp_emp_code_check",                       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Employee code is required.") },
  { "emp_emp_code_key",                         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Employee already exists with this code.") },
//{ "emp_emp_dept_id_fkey",                     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "emp_emp_dept_id_fkey",                     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "emp_emp_image_id_fkey",                    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "emp_emp_image_id_fkey",                    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "emp_emp_mgr_emp_id_fkey",                  Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "emp_emp_mgr_emp_id_fkey",                  Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "emp_emp_number_check",                     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Employee number is required.") },
  { "emp_emp_number_key",                       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Employee already exists with this Employee Number.") },
//{ "emp_emp_shift_id_fkey",                    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "emp_emp_shift_id_fkey",                    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "emp_emp_wage_curr_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "emp_emp_wage_curr_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "emp_emp_wage_period_check",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The selected Employee Wage Period is invalid.") },
//{ "emp_emp_warehous_id_fkey",                 Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "emp_emp_warehous_id_fkey",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "empgrp_empgrp_name_check",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Employee Group name is required.") },
  { "empgrp_empgrp_name_key",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Employee Group already exists with this name.") },
//{ "empgrpitem_empgrpitem_emp_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "empgrpitem_empgrpitem_emp_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "empgrpitem_empgrpitem_empgrp_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "empgrpitem_empgrpitem_empgrp_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "evnttype_evnttype_name_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Event Type name is required.") },
  { "evnttype_evnttype_name_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Event Type already exists with this name.") },
  { "expcat_expcat_code_check",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Expense Category code is required.") },
  { "expcat_expcat_code_key",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Expense Category already exists with this code.") },
//{ "fkey_flcol_key",                           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
  { "flhead_flhead_name_check",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Financial Report name is required.") },
  { "flhead_flhead_name_key",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Financial Report already exists with this name.") },
//{ "flnotes_flnotes_flhead_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "flnotes_flnotes_flhead_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "flnotes_flnotes_flhead_id_key",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "flnotes_flnotes_period_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "flnotes_flnotes_period_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "form_form_name_check",                     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Form name is required.") },
  { "form_form_name_key",                       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Form already exists with this name.") },
  { "freightclass_freightclass_code_check",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Freight Class code is required.") },
  { "freightclass_freightclass_code_key",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Freight Class already exists with this code.") },
//{ "gltranssync_gltranssync_company_id_fkey",  Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "gltranssync_gltranssync_company_id_fkey",  Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "gltranssync_gltranssync_curr_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "gltranssync_gltranssync_curr_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "gltranssync_gltranssync_period_id_fkey",   Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "gltranssync_gltranssync_period_id_fkey",   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "grp_grp_name_check",                       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Group name is required.") },
  { "grp_grp_name_key",                         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Group already exists with this name.") },
//{ "grppriv_grppriv_grp_id_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "grppriv_grppriv_grp_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "hnfc_hnfc_code_check",                     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Honorific (Title) code is required.") },
  { "hnfc_hnfc_code_key",                       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Honorific (Title) already exists with this code.") },
  { "image_image_name_check",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Image name is required.") },
  { "image_image_name_key",                     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Image already exists with this name.") },
//{ "imageass_imageass_image_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "imageass_imageass_image_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "imageass_imageass_purpose_check",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "incdt_incdt_aropen_id_fkey",               Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "incdt_incdt_aropen_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "incdt_incdt_cntct_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "This Contact cannot be deleted as s/he is the Contact for an Incident.") },
//{ "incdt_incdt_cntct_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "incdt_incdt_crmacct_id_fkey",              Delete,  0, QT_TRANSLATE_NOOP("ErrorReporter", "The selected Account cannot be deleted as it has related Incidents.") },
  { "incdt_incdt_crmacct_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot save the Incident with an invalid Account.") },
//{ "incdt_incdt_incdtcat_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "incdt_incdt_incdtcat_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "incdt_incdt_incdtpriority_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "incdt_incdt_incdtpriority_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "incdt_incdt_incdtresolution_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "incdt_incdt_incdtresolution_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "incdt_incdt_incdtseverity_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "incdt_incdt_incdtseverity_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "incdt_incdt_item_id_fkey",                 Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "incdt_incdt_item_id_fkey",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "incdt_incdt_ls_id_fkey",                   Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "incdt_incdt_ls_id_fkey",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "incdt_incdt_number_key",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "incdt_incdt_prj_id_fkey",                  Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "incdt_incdt_prj_id_fkey",                  Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "incdt_incdt_recurring_incdt_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "incdt_incdt_recurring_incdt_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "incdtcat_incdtcat_name_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Incident Category name is required.") },
  { "incdtcat_incdtcat_name_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Incident Category already exists with this name.") },
//{ "incdthist_incdthist_incdt_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "incdthist_incdthist_incdt_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "incdtpriority_incdtpriority_name_check",   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Incident Priority name is required.") },
  { "incdtpriority_incdtpriority_name_key",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Incident Priority already exists with this name.") },
  { "incdtresolution_incdtresolution_name_check", Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Incident Resolution name is required.") },
  { "incdtresolution_incdtresolution_name_key",   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Incident Resolution already exists with this name.") },
  { "incdtseverity_incdtseverity_name_check",   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Incident Severity name is required.") },
  { "incdtseverity_incdtseverity_name_key",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Incident Severity already exists with this name.") },
//{ "invchead_invchead_taxzone_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invchead_invchead_taxzone_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "invchead_invchead_invcnumber_check",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Invoice number is required.") },
  { "invchead_invcnumber_unique",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Invoice already exists with this number.") },
//{ "invchead_to_curr_symbol",                  Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invchead_to_curr_symbol",                  Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcheadtax_taxhist_basis_tax_id_fkey",    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcheadtax_taxhist_basis_tax_id_fkey",    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcheadtax_taxhist_parent_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcheadtax_taxhist_parent_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcheadtax_taxhist_tax_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcheadtax_taxhist_tax_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcheadtax_taxhist_taxtype_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcheadtax_taxhist_taxtype_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcitem_invchead_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcitem_invchead_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcitem_invchead_id_linenumber_unique",   Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcitem_invchead_id_linenumber_unique",   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcitem_invcitem_price_uom_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcitem_invcitem_price_uom_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcitem_invcitem_qty_uom_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcitem_invcitem_qty_uom_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcitem_invcitem_taxtype_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcitem_invcitem_taxtype_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcitemtax_taxhist_basis_tax_id_fkey",    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcitemtax_taxhist_basis_tax_id_fkey",    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcitemtax_taxhist_parent_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcitemtax_taxhist_parent_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcitemtax_taxhist_tax_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcitemtax_taxhist_tax_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcitemtax_taxhist_taxtype_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invcitemtax_taxhist_taxtype_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invdetail_invdetail_ls_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "invdetail_invdetail_ls_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsass_ipsass_ipshead_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsass_ipsass_ipshead_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsass_ipsass_ipshead_id_key",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "ipsfreight_ipsfreight_freightclass_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsfreight_ipsfreight_freightclass_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsfreight_ipsfreight_ipshead_id_fkey",    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsfreight_ipsfreight_ipshead_id_fkey",    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsfreight_ipsfreight_shipzone_id_fkey",   Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsfreight_ipsfreight_shipzone_id_fkey",   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsfreight_ipsfreight_warehous_id_fkey",   Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsfreight_ipsfreight_warehous_id_fkey",   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "ipshead_ipshead_name_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Pricing Schedule name is required.") },
  { "ipshead_ipshead_name_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Pricing Schedule already exists with this name.") },
//{ "ipshead_to_curr_symbol",                   Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipshead_to_curr_symbol",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsitem_ipshead_id_fk",                    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsitem_ipshead_id_fk",                    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsitem_ipsitem_ipshead_id_key",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "ipsitem_ipsitem_price_uom_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsitem_ipsitem_price_uom_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsitem_ipsitem_qty_uom_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsitem_ipsitem_qty_uom_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsitem_item_id_fk",                       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsitem_item_id_fk",                       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsitemchar_ipsitemchar_char_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsitemchar_ipsitemchar_char_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsitemchar_ipsitemchar_ipsitem_id_fkey",  Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsitemchar_ipsitemchar_ipsitem_id_fkey",  Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ipsitemchar_ipsitemchar_ipsitem_id_key",   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "ipsitemchar_ipsitemchar_ipsitem_id_key1",  Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "ipsitemchar_ipsitemchar_ipsitem_id_key1",  Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "item_item_classcode_id_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "item_item_classcode_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "item_item_freightclass_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "item_item_freightclass_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "item_item_inv_uom_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "item_item_inv_uom_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "item_item_number_check",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Item number is required.") },
  { "item_item_number_key",                     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Item already exists with this number.") },
//{ "item_item_price_uom_id_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "item_item_price_uom_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "item_item_type_check",                     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "item_sold_check",                          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemalias_itemalias_item_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemalias_itemalias_item_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "itemalias_itemalias_number_check",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Item Alias number is required.") },
  { "itemalias_itemalias_item_id_key",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Item Alias with this number already exists with this item.") },
//{ "itemcost_itemcost_costelem_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemcost_itemcost_costelem_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemcost_itemcost_curr_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemcost_itemcost_curr_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemcost_itemcost_item_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemcost_itemcost_item_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemcost_to_curr_symbol",                  Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemcost_to_curr_symbol",                  Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "itemgrp_itemgrp_name_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Item Group name is required.") },
  { "itemgrp_itemgrp_name_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Item Group already exists with this name.") },
//{ "itemloc_itemloc_ls_id_fkey",               Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemloc_itemloc_ls_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemlocdist_itemlocdist_ls_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemlocdist_itemlocdist_ls_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsite_itemsite_abcclass_check",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsite_itemsite_controlmethod_check",    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsite_itemsite_costcat_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsite_itemsite_costcat_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsite_itemsite_costmethod_check",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsite_itemsite_item_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsite_itemsite_item_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsite_itemsite_ordergroup_check",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsite_itemsite_plancode_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsite_itemsite_plancode_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsite_itemsite_warehous_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsite_itemsite_warehous_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsrc_itemsrc_item_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsrc_itemsrc_item_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsrc_itemsrc_vend_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsrc_itemsrc_vend_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsrc_itemsrc_vend_id_key",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "itemsrcp_itemsrcp_itemsrc_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsrcp_itemsrcp_itemsrc_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsrcp_itemsrcp_itemsrc_id_key",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "itemsrcp_to_curr_symbol",                  Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsrcp_to_curr_symbol",                  Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsub_itemsub_parent_item_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsub_itemsub_parent_item_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsub_itemsub_parent_item_id_key",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "itemsub_itemsub_sub_item_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemsub_itemsub_sub_item_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemtax_itemtax_item_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemtax_itemtax_item_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemtax_itemtax_taxtype_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemtax_itemtax_taxtype_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemtax_itemtax_taxzone_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemtax_itemtax_taxzone_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemtrans_itemtrans_source_item_id_fkey",  Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemtrans_itemtrans_source_item_id_fkey",  Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemtrans_itemtrans_source_item_id_key",   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "itemtrans_itemtrans_target_item_id_fkey",  Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemtrans_itemtrans_target_item_id_fkey",  Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemuom_itemuom_itemuomconv_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemuom_itemuom_itemuomconv_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemuom_itemuom_uomtype_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemuom_itemuom_uomtype_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemuomconv_itemuomconv_from_uom_id_fkey", Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemuomconv_itemuomconv_from_uom_id_fkey", Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemuomconv_itemuomconv_item_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemuomconv_itemuomconv_item_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemuomconv_itemuomconv_to_uom_id_fkey",   Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemuomconv_itemuomconv_to_uom_id_fkey",   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemuomconv_uom",                  Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "itemuomconv_uom",                  Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "labelform_labelform_name_check",   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Label Form name is required.") },
  { "labelform_labelform_name_key",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Label Form already exists with this name.") },
  { "locale_locale_code_check",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Locale code is required.") },
  { "locale_locale_code_key",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Locale already exists with this code.") },
//{ "ls_ls_item_id_fkey",               Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ls_ls_item_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ls_ls_item_id_key",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "lsdetail_lsdetail_ls_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "lsdetail_lsdetail_ls_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "lsreg_lsreg_cntct_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "lsreg_lsreg_cntct_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "lsreg_lsreg_cohead_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "lsreg_lsreg_cohead_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "lsreg_lsreg_crmacct_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "lsreg_lsreg_crmacct_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "lsreg_lsreg_ls_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "lsreg_lsreg_ls_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "lsreg_lsreg_number_check",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Registration number is required.") },
  { "lsreg_lsreg_number_key",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Registration already exists with this number.") },
//{ "lsreg_lsreg_regtype_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "lsreg_lsreg_regtype_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "lsreg_lsreg_shiphead_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "lsreg_lsreg_shiphead_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "lsseq_lsseq_number_check",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Lot/Serial Sequence number is required.") },
  { "lsseq_lsseq_number_key",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Lot/Serial Sequence already exists with this number.") },
//{ "lsseq_lsseq_seqlen_check",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "lswarr_lswarr_crmacct_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "lswarr_lswarr_crmacct_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "lswarr_lswarr_regtype_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "lswarr_lswarr_regtype_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "metric_metric_name_check",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Metric name is required.") },
  { "metric_metric_name_key",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Metric already exists with this name.") },
  { "metricenc_metricenc_name_check",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Encrypted Metric name is required.") },
  { "metricenc_metricenc_name_key",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Encrypted Metric already exists with this name.") },
//{ "metasql_metasql_group_name_grade_key",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "mrghist_mrghist_cntct_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "mrghist_mrghist_cntct_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "mrgundo_mrgundo_schema_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "There is a merge in progress that overlaps with this one. Either complete all merges in progress, delete merge history, or both.") },
//{ "ophead_ophead_cntct_id_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ophead_ophead_cntct_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ophead_ophead_crmacct_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ophead_ophead_crmacct_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "ophead_ophead_number_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Opportunity number is required.") },
  { "ophead_ophead_number_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Opportunity already exists with this number.") },
//{ "ophead_ophead_opsource_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ophead_ophead_opsource_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ophead_ophead_opstage_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ophead_ophead_opstage_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ophead_ophead_optype_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ophead_ophead_optype_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ophead_ophead_priority_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "ophead_ophead_priority_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "opsource_opsource_name_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Opportunity Source name is required.") },
  { "opsource_opsource_name_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Opportunity Source already exists with this name.") },
  { "opstage_opstage_name_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Opportunity Stage name is required.") },
  { "opstage_opstage_name_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Opportunity Stage already exists with this name.") },
  { "optype_optype_name_check",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Opportunity Type name is required.") },
  { "optype_optype_name_key",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Opportunity Type already exists with this name.") },
  { "orderseq_orderseq_name_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Order Sequence name is required.") },
  { "orderseq_orderseq_name_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An Order Sequence already exists with this name.") },
//{ "pack_pack_head_type_check",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pack_pack_shiphead_id_fkey",               Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pack_pack_shiphead_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "payco_payco_ccpay_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "payco_payco_ccpay_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "payco_payco_cohead_id_fkey",               Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "payco_payco_cohead_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pkgdep_pkgdep_parent_pkghead_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pkgdep_pkgdep_parent_pkghead_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pkgdep_pkgdep_pkghead_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pkgdep_pkgdep_pkghead_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "pkghead_pkghead_name_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Package name is required.") },
  { "pkghead_pkghead_name_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Package already exists with this name.") },
//{ "pkgitem_pkgitem_pkghead_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pkgitem_pkgitem_pkghead_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pkgitem_pkgitem_pkghead_id_key",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "pkgitem_pkgitem_pkghead_id_key1",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "pkgitem_pkgitem_pkghead_id_key1",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "pkgitem_pkgitem_type_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "plancode_plancode_code_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Planner Code code is required.") },
  { "plancode_plancode_code_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Planner Code already exists with this code.") },
//{ "planord_planord_number_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
  { "pohead_pohead_cohead_id_fkey",             Delete,-10, "deleteSO" },
//{ "pohead_pohead_cohead_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "pohead_pohead_number_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Purchase Order number is required.") },
  { "pohead_pohead_number_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Purchase Order already exists with this number.") },
//{ "pohead_pohead_shipto_cntct_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pohead_pohead_shipto_cntct_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pohead_pohead_shiptoddress_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pohead_pohead_shiptoddress_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pohead_pohead_status_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pohead_pohead_taxtype_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pohead_pohead_taxtype_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pohead_pohead_taxzone_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pohead_pohead_taxzone_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pohead_pohead_terms_id_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pohead_pohead_terms_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pohead_pohead_vend_cntct_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pohead_pohead_vend_cntct_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "pohead_pohead_vend_id_fkey",               Delete, -1, "deleteVendor" },
  { "pohead_pohead_vend_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot save the Purchase Order with an invalid Vendor.") },
//{ "pohead_pohead_vendaddr_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pohead_pohead_vendaddr_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pohead_pohead_warehous_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pohead_pohead_warehous_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pohead_to_curr_symbol",                    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "pohead_to_curr_symbol",                    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "poitem_poitem_expcat_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "poitem_poitem_expcat_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "poitem_poitem_itemsite_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "poitem_poitem_itemsite_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "poitem_poitem_itemsrc_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "poitem_poitem_itemsrc_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "poitem_poitem_pohead_id_key",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "poitem_poitem_prj_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "poitem_poitem_prj_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "poitem_poitem_status_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "poitem_poitem_taxtype_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "poitem_poitem_taxtype_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "poitem_poitem_order_id_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "poitem_poitem_order_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "poreject_poreject_vend_id_fkey",           Delete, -3, "deleteVendor" },
  { "poreject_poreject_vend_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot save this P/O Return with an invalid Vendor.") },
  { "prftcntr_prftcntr_number_check",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Profit Center number is required.") },
  { "prftcntr_prftcntr_number_key",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Profit Center already exists with this number.") },
  { "priv_priv_name_check",                     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Privilege name is required.") },
  { "priv_priv_name_key",                       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Privilege already exists with this name.") },
  { "prj_prj_number_check",                     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Project number is required.") },
  { "prj_prj_number_key",                       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Project already exists with this number.") },
//{ "prj_prj_recurring_prj_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "prj_prj_recurring_prj_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "prj_prj_status_check",                     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "prjtask_prjtask_prj_id_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "prjtask_prjtask_prj_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "prjtask_prjtask_prj_id_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "prjtask_prjtask_status_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "prodcat_prodcat_code_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Product Category code is required.") },
  { "prodcat_prodcat_code_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Product Category already exists with this code.") },
//{ "prospect_prospect_cntct_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "prospect_prospect_cntct_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "prospect_prospect_number_check",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Prospect number is required.") },
  { "prospect_prospect_number_key",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Prospect already exists with this number.") },
  { "prospect_prospect_salesrep_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "The Sales Rep cannot be deleted as s/he is still assigned to one or more Prospects.") },
//{ "prospect_prospect_salesrep_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "prospect_prospect_taxzone_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "prospect_prospect_taxzone_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "prospect_prospect_warehous_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "prospect_prospect_warehous_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "qryhead_qryhead_name_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Query Head name is required.") },
  { "qryhead_qryhead_name_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Query Head already exists with this name.") },
//{ "qryitem_qryitem_detail_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "qryitem_qryitem_qryhead_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "qryitem_qryitem_qryhead_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "qryitem_qryitem_qryhead_id_key",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "qryitem_qryitem_qryhead_id_key1",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "qryitem_qryitem_qryhead_id_key1",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "qryitem_qryitem_src_check",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "quhead_check",                             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Miscellaneous Account and Miscellaneous Amount must either both be set or neither can be set when saving a Quote.") },
//{ "quhead_quhead_billto_cntct_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_quhead_billto_cntct_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_quhead_misc_accnt_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_quhead_misc_accnt_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "quhead_quhead_number_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Quote number is required.") },
  { "quhead_quhead_number_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Quote already exists with this number.") },
//{ "quhead_quhead_ophead_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_quhead_ophead_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_quhead_prj_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_quhead_prj_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "quhead_quhead_salesrep_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "The Sales Rep cannot be deleted as s/he is still associated with one or more Quotes.") },
//{ "quhead_quhead_salesrep_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_quhead_shipto_cntct_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_quhead_shipto_cntct_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "quhead_quhead_shipto_id_fkey",             Delete, -5, "deleteShipto" },
//{ "quhead_quhead_shipto_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_quhead_status_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_quhead_taxtype_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_quhead_taxtype_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_quhead_taxzone_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_quhead_taxzone_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_quhead_terms_id_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_quhead_terms_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_quhead_warehous_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_quhead_warehous_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_to_curr_symbol",                    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quhead_to_curr_symbol",                    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quitem_quitem_itemsrc_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quitem_quitem_itemsrc_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quitem_quitem_price_uom_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quitem_quitem_price_uom_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quitem_quitem_qty_uom_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quitem_quitem_qty_uom_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quitem_quitem_taxtype_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "quitem_quitem_taxtype_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_creditmethod_check",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_curr_id_fkey",               Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_curr_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_cust_id_fkey",               Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_cust_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_disposition_check",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_incdt_id_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_incdt_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_misc_accnt_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_misc_accnt_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "rahead_rahead_new_cohead_id_fkey",         Delete,        -103, "deleteSO" },
//{ "rahead_rahead_new_cohead_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "rahead_rahead_number_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Return Authorization number is required.") },
  { "rahead_rahead_number_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Return Authorization already exists with this number.") },
  { "rahead_rahead_orig_cohead_id_fkey",        Delete,        -103, "deleteSO" },
//{ "rahead_rahead_orig_cohead_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_prj_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_prj_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_rsncode_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_rsncode_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "rahead_rahead_salesrep_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "The Sales Rep cannot be deleted as s/he is still associated with one or more Return Authorizations.") },
//{ "rahead_rahead_salesrep_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_shipto_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_shipto_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_taxtype_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_taxtype_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_taxzone_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_taxzone_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahead_rahead_timing_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahist_rahist_curr_id_fkey",               Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahist_rahist_curr_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahist_rahist_itemsite_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahist_rahist_itemsite_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahist_rahist_uom_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "rahist_rahist_uom_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_coitem_itemsite_id_fkey",    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_coitem_itemsite_id_fkey",    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_cos_accnt_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_cos_accnt_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_disposition_check",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_itemsite_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_itemsite_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_new_coitem_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_new_coitem_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_orig_coitem_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_orig_coitem_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_price_uom_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_price_uom_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_qty_uom_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_qty_uom_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_rahead_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_rahead_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_rsncode_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_rsncode_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitem_raitem_status_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitemls_raitemls_ls_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitemls_raitemls_ls_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitemls_raitemls_raitem_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitemls_raitemls_raitem_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "raitemls_raitemls_raitem_id_key",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "recur_recur_parent_id_key",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "recur_recur_period_check",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "recurtype_recurtype_type_key",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "recv_recv_freight_curr_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "recv_recv_freight_curr_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "recv_recv_itemsite_id_fkey",               Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "recv_recv_itemsite_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "recv_recv_order_type_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "recv_recv_purchcost_curr_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "recv_recv_purchcost_curr_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "recv_recv_recvcost_curr_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "recv_recv_recvcost_curr_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "recv_recv_splitfrom_id_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "recv_recv_splitfrom_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "recv_recv_vend_id_fkey",                   Delete, -2, "deleteVendor" },
  { "recv_recv_vend_id_fkey",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot receive materials from an invalid Vendor.") },
//{ "recv_recv_vohead_id_fkey",                 Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "recv_recv_vohead_id_fkey",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "recv_recv_voitem_id_fkey",                 Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "recv_recv_voitem_id_fkey",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "regtype_regtype_code_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Registration Type code is required.") },
  { "regtype_regtype_code_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Registration Type already exists with this code.") },
//{ "rev_check",                                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "rev_rev_number_check",                     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Revision number is required.") },
  { "rev_rev_number_key",                       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Revision with this number already exists for this object.") },
  { "rjctcode_rjctcode_code_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Rejection code is required.") },
  { "rjctcode_rjctcode_code_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Rejection Code already exists with this code.") },
  { "rsncode_rsncode_code_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Reason code is required.") },
  { "rsncode_rsncode_code_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Reason Code already exists with this code.") },
  { "sale_sale_name_check",                     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Sale name is required.") },
  { "sale_sale_name_key",                       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Sale name already exists with this name.") },
  { "salescat_salescat_number_check",           Upsert,  0, QT_TRANSLATE_NOOP("errorcatorter", "The Sales Category number is required.") },
  { "salescat_salescat_number_key",             Upsert,  0, QT_TRANSLATE_NOOP("errorcatorter", "A Sales Category already exists with this number.") },
  { "salesrep_salesrep_emp_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot delete this Sales Rep as it is associated with an Employee.") },
//{ "salesrep_salesrep_emp_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "salesrep_salesrep_number_check",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Sales Rep number is required.") },
  { "salesrep_salesrep_number_key",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot save this Sales Rep as there is another Sales Rep with this number.") },
  { "schemaord_schemaord_name_check",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Schema name is required.") },
  { "schemaord_schemaord_name_key",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Schema Order record already exists with this name.") },
  { "schemaord_schemaord_order_key",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Schema Order record already exists with this order number.") },
//{ "scprp_scprp_screc_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "scprp_scprp_screc_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "screc_screc_create_priv_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "screc_screc_create_priv_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "screc_screc_delete_priv_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "screc_screc_delete_priv_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "screc_screc_edit_priv_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "screc_screc_edit_priv_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "screc_screc_view_priv_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "screc_screc_view_priv_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "screl_screl_screc_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "screl_screl_screc_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "screl_screl_screc_rel_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "screl_screl_screc_rel_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "shift_shift_number_check",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Shift number is required.") },
  { "shift_shift_number_key",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Shift already exists with this number.") },
  { "shipchrg_shipchrg_name_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Shipping Charge name is required.") },
  { "shipchrg_shipchrg_name_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Shipping Charge already exists with this name.") },
//{ "shipdata_shipdata_base_freight_curr_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipdata_shipdata_base_freight_curr_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipdata_shipdata_shiphead_number_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipdata_shipdata_shiphead_number_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipdata_shipdata_total_freight_curr_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipdata_shipdata_total_freight_curr_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipdatasum_shipdatasum_base_freight_curr_id_fkey",Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipdatasum_shipdatasum_base_freight_curr_id_fkey",Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipdatasum_shipdatasum_shiphead_number_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipdatasum_shipdatasum_shiphead_number_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipdatasum_shipdatasum_total_freight_curr_id_fkey",Delete,         0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipdatasum_shipdatasum_total_freight_curr_id_fkey",Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "shipform_shipform_name_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Shipping Form name is required.") },
  { "shipform_shipform_name_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Shipping Form already exists with this name.") },
//{ "shiphead_shiphead_freight_curr_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shiphead_shiphead_freight_curr_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "shiphead_shiphead_number_check",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Shipment number is required.") },
  { "shiphead_shiphead_number_key",                     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Shipment already exists with this number.") },
//{ "shiphead_shiphead_order_type_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shiphead_shiphead_sfstatus_check",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shiphead_shiphead_shipchrg_id_fkey",               Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shiphead_shiphead_shipchrg_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shiphead_shiphead_shipform_id_fkey",               Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shiphead_shiphead_shipform_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipitem_shipitem_invcitem_id_fkey",               Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipitem_shipitem_invcitem_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipitem_shipitem_invhist_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipitem_shipitem_invhist_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipitem_shipitem_shiphead_id_fkey",               Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipitem_shipitem_shiphead_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipitemlocrsrv_shipitemlocrsrv_itemsite_id_fkey", Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipitemlocrsrv_shipitemlocrsrv_itemsite_id_fkey", Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipitemlocrsrv_shipitemlocrsrv_location_id_fkey", Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipitemlocrsrv_shipitemlocrsrv_location_id_fkey", Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipitemlocrsrv_shipitemlocrsrv_ls_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipitemlocrsrv_shipitemlocrsrv_ls_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipitemlocrsrv_shipitemlocrsrv_shipitem_id_fkey", Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipitemlocrsrv_shipitemlocrsrv_shipitem_id_fkey", Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipitemrsrv_shipitemrsrv_shipitem_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipitemrsrv_shipitemrsrv_shipitem_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipto_num_cust_unique",                   Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shipto_num_cust_unique",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shiptoinfo_shipto_addr_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shiptoinfo_shipto_addr_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "shiptoinfo_shipto_cntct_id_fkey",          Delete, -4, "deleteContact" },
//{ "shiptoinfo_shipto_cntct_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "shiptoinfo_shipto_cust_id_fkey",           Delete, -1, "deleteCustomer" },
  { "shiptoinfo_shipto_cust_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot save this Ship-To with an invalid Customer.") },
  { "shiptoinfo_shipto_salesrep_fkey",          Delete, -2, "deleteSalesRep" },
  { "shiptoinfo_shipto_salesrep_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot save this Ship-To with an invalid Sales Rep.") },
  { "shiptoinfo_shipto_salesrep_id_fkey",       Delete, -2, "deleteSalesRep" },
  { "shiptoinfo_shipto_salesrep_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot save this Ship-To with an invalid Sales Rep.") },
//{ "shiptoinfo_shipto_shipform_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shiptoinfo_shipto_shipform_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shiptoinfo_shipto_shipform_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shiptoinfo_shipto_shipform_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shiptoinfo_shipto_shipzone_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shiptoinfo_shipto_shipzone_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shiptoinfo_shipto_taxzone_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "shiptoinfo_shipto_taxzone_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "shipvia_shipvia_code_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Ship-Via code is required.") },
  { "shipvia_shipvia_code_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Ship-Via already exists with this code.") },
  { "shipzone_shipzone_name_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Shipping Zone name is required.") },
  { "shipzone_shipzone_name_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Shipping Zone already exists with this name.") },
  { "sitetype_sitetype_name_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Site Type name is required.") },
  { "sitetype_sitetype_name_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Site Type already exists with this name.") },
  { "source_source_name_check",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Source name is required.") },
  { "source_source_name_key",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Source already exists with this name.") },
//{ "state_state_country_id_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "state_state_country_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "state_state_country_id_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A State with this name already exists for this Country.") },
  { "state_state_name_check",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The State name is required.") },
//{ "status_status_type_key",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
  { "stdjrnl_stdjrnl_name_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Standard Journal name is required.") },
  { "stdjrnl_stdjrnl_name_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Standard Journal already exists with this name.") },
  { "stdjrnlgrp_stdjrnlgrp_name_check",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Standard Journal Group name is required.") },
  { "stdjrnlgrp_stdjrnlgrp_name_key",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Standard Journal Group already exists with this name.") },
  { "subaccnt_subaccnt_number_check",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Subaccount number is required.") },
  { "subaccnt_subaccnt_number_key",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Subaccount already exists with this number.") },
//{ "tax_tax_basis_tax_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tax_tax_basis_tax_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tax_tax_sales_accnt_id_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tax_tax_sales_accnt_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "tax_tax_taxauth_id_fkey",                  Delete, -1, "deleteTaxAuthority" },
  { "tax_tax_taxauth_id_fkey",                  Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot save this Tax Code with an invalid Tax Authority.") },
//{ "tax_tax_taxclass_id_fkey",                 Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tax_tax_taxclass_id_fkey",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxass_taxass_tax_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxass_taxass_tax_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxass_taxass_taxtype_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxass_taxass_taxtype_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxass_taxass_taxzone_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxass_taxass_taxzone_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxass_taxass_taxzone_id_key",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "taxauth_taxauth_accnt_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxauth_taxauth_accnt_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxauth_taxauth_addr_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxauth_taxauth_addr_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxauth_taxauth_code_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "taxauth_taxauth_curr_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxauth_taxauth_curr_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "taxauth_taxauth_code_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Tax Authority code is required.") },
  { "taxauth_taxauth_code_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Tax Authority already exists with this code.") },
  { "taxclass_taxclass_code_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Tax Class code is required.") },
  { "taxclass_taxclass_code_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Tax Class already exists with this code.") },
//{ "taxhist_taxhist_curr_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxhist_taxhist_curr_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxhist_taxhist_tax_id_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxhist_taxhist_tax_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxhist_taxhist_taxtype_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxhist_taxhist_taxtype_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxrate_taxrate_curr_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxrate_taxrate_curr_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxrate_taxrate_tax_id_fkey",              Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxrate_taxrate_tax_id_fkey",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "taxreg_taxreg_number_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Tax Registration number is required.") },
  { "taxreg_taxreg_taxauth_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot delete this Tax Authority as there are still Tax Registrations associated with it.") },
//{ "taxreg_taxreg_taxauth_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxreg_taxreg_taxzone_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "taxreg_taxreg_taxzone_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "taxtype_taxtype_name_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Tax Type name is required.") },
  { "taxtype_taxtype_name_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Tax Type already exists with this name.") },
  { "taxzone_taxzone_code_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Tax Zone code is required.") },
  { "taxzone_taxzone_code_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Tax Zone already exists with this code.") },
  { "terms_terms_code_check",                   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Terms code is required.") },
  { "terms_terms_code_key",                     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Terms already exists with this code.") },
//{ "todoitem_todoitem_cntct_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "todoitem_todoitem_cntct_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "todoitem_todoitem_crmacct_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "The selected Account cannot be deleted as it has To-Do Items.") },
//{ "todoitem_todoitem_crmacct_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "todoitem_todoitem_incdt_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "todoitem_todoitem_incdt_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "todoitem_todoitem_ophead_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "todoitem_todoitem_ophead_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "todoitem_todoitem_recurring_todoitem_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "todoitem_todoitem_recurring_todoitem_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_check",                             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_dest_warehous_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_dest_warehous_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_destcntct_id_fkey",          Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_destcntct_id_fkey",          Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_freight_curr_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_freight_curr_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "tohead_tohead_number_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Transfer Order number is required.") },
  { "tohead_tohead_number_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Transfer Order already exists with this number.") },
//{ "tohead_tohead_prj_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_prj_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_shipchrg_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_shipchrg_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_shipform_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_shipform_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_src_warehous_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_src_warehous_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_srccntct_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_srccntct_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_taxzone_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_taxzone_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_trns_warehous_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "tohead_tohead_trns_warehous_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toheadtax_taxhist_basis_tax_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toheadtax_taxhist_basis_tax_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toheadtax_taxhist_parent_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toheadtax_taxhist_parent_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toheadtax_taxhist_tax_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toheadtax_taxhist_tax_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toheadtax_taxhist_taxtype_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toheadtax_taxhist_taxtype_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toitem_check",                             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toitem_toitem_freight_curr_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toitem_toitem_freight_curr_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toitem_toitem_item_id_fkey",               Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toitem_toitem_item_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toitem_toitem_prj_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toitem_toitem_prj_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toitem_toitem_status_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toitem_toitem_tohead_id_fkey",             Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toitem_toitem_tohead_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toitemtax_taxhist_basis_tax_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toitemtax_taxhist_basis_tax_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toitemtax_taxhist_parent_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toitemtax_taxhist_parent_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toitemtax_taxhist_tax_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toitemtax_taxhist_tax_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toitemtax_taxhist_taxtype_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "toitemtax_taxhist_taxtype_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "trgthist_trgthist_src_cntct_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "trgthist_trgthist_src_cntct_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "trgthist_trgthist_trgt_cntct_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "trgthist_trgthist_trgt_cntct_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "trialbalsync_trialbal_period_id_key",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "trialbalsync_trialbalsync_curr_id_fkey",   Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "trialbalsync_trialbalsync_curr_id_fkey",   Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "uom_uom_name_check",                       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The UOM name is required.") },
  { "uom_uom_name_key",                         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A UOM already exists with this name.") },
//{ "uomconv_uomconv_from_uom_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "uomconv_uomconv_from_uom_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "uomconv_uomconv_to_uom_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "uomconv_uomconv_to_uom_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "uomtype_uomtype_name_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The UOM Type name is required.") },
  { "uomtype_uomtype_name_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A UOM Type already exists with this name.") },
//{ "usr_usr_username_key",                     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "usrgrp_usrgrp_grp_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "usrgrp_usrgrp_grp_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "usrsite_usrsite_warehous_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "usrsite_usrsite_warehous_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vend_to_curr_symbol",                      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vend_to_curr_symbol",                      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vendaddrinfo_vendaddr_addr_id_fkey",       Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vendaddrinfo_vendaddr_addr_id_fkey",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "vendaddrinfo_vendaddr_cntct_id_fkey",      Delete, -5, "deleteContact" },
//{ "vendaddrinfo_vendaddr_cntct_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vendaddrinfo_vendaddr_taxzone_id_fkey",    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vendaddrinfo_vendaddr_taxzone_id_fkey",    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vendinfo_vend_ach_accnttype_check",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vendinfo_vend_addr_id_fkey",               Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vendinfo_vend_addr_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "vendinfo_vend_cntct1_id_fkey",             Delete, -3, "deleteContact" },
//{ "vendinfo_vend_cntct1_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "vendinfo_vend_cntct2_id_fkey",             Delete, -3, "deleteContact" },
//{ "vendinfo_vend_cntct2_id_fkey",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "vendinfo_vend_number_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Vendor Number is required.") },
  { "vendinfo_vend_number_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "This Vendor Number cannot be used as it is in use by another Vendor.") },
//{ "vendinfo_vend_taxzone_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vendinfo_vend_taxzone_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vendinfo_vend_vendtype_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vendinfo_vend_vendtype_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "vendtype_vendtype_code_check",             Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Vendor Type code is required.") },
  { "vendtype_vendtype_code_key",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Vendor Type already exists with this code.") },
//{ "vohead_to_curr_symbol",                    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vohead_to_curr_symbol",                    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vohead_vohead_adjtaxtype_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vohead_vohead_adjtaxtype_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vohead_vohead_freighttaxtype_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vohead_vohead_freighttaxtype_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vohead_vohead_number_key",                 Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A XXX already exists with this XXX.") },
//{ "vohead_vohead_taxtype_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vohead_vohead_taxtype_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vohead_vohead_taxzone_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "vohead_vohead_taxzone_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "vohead_vohead_vend_id_fkey",               Delete, -4, "deleteVendor" },
  { "vohead_vohead_vend_id_fkey",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "Cannot save this Voucher with an invalid Vendor.") },
//{ "voheadtax_taxhist_basis_tax_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "voheadtax_taxhist_basis_tax_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "voheadtax_taxhist_parent_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "voheadtax_taxhist_parent_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "voheadtax_taxhist_tax_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "voheadtax_taxhist_tax_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "voheadtax_taxhist_taxtype_id_fkey"         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "voheadtax_taxhist_taxtype_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "voitem_voitem_taxtype_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "voitem_voitem_taxtype_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "voitemtax_taxhist_basis_tax_id_fkey",      Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "voitemtax_taxhist_basis_tax_id_fkey",      Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "voitemtax_taxhist_parent_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "voitemtax_taxhist_parent_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "voitemtax_taxhist_tax_id_fkey",            Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "voitemtax_taxhist_tax_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "voitemtax_taxhist_taxtype_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "voitemtax_taxhist_taxtype_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "whsinfo_check",                            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "whsinfo_warehous_accnt_id_fkey",           Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "whsinfo_warehous_accnt_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "whsinfo_warehous_addr_id_fkey",            Delete, 0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "whsinfo_warehous_addr_id_fkey",            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "whsinfo_warehous_cntct_id_fkey",           Delete, -6, "deleteContact" },
//{ "whsinfo_warehous_cntct_id_fkey",           Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "whsinfo_warehous_code_check",              Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The Site code is required.") },
  { "whsinfo_warehous_code_key",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "A Site already exists with this code.") },
//{ "whsinfo_warehous_costcat_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "whsinfo_warehous_costcat_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "whsinfo_warehous_shipform_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "whsinfo_warehous_shipform_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "whsinfo_warehous_shipvia_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "whsinfo_warehous_shipvia_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "whsinfo_warehous_sitetype_id_fkey",        Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "whsinfo_warehous_sitetype_id_fkey",        Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "whsinfo_warehous_taxzone_id_fkey",         Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "whsinfo_warehous_taxzone_id_fkey",         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "wo_wo_womatl_id_fkey",                     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "wo_wo_womatl_id_fkey",                     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "womatl_womatl_uom_id_fkey",                Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "womatl_womatl_uom_id_fkey",                Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "womatlpost_womatlpost_invhist_id_fkey",    Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "womatlpost_womatlpost_invhist_id_fkey",    Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "womatlpost_womatlpost_womatl_id_fkey",     Delete,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "womatlpost_womatlpost_womatl_id_fkey",     Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "xsltmap_check",                            Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
  { "xsltmap_name_check",                       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "The XSLT Map name is required.") },
  { "xsltmap_name_key",                         Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "An XSLT Map already exists with this name.") },
//{ "xsltmap_xsltmap_importexport_check",       Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },
//{ "xsltmap_xsltmap_name_check",               Upsert,  0, QT_TRANSLATE_NOOP("errorReporter", "") },

};

// TODO: consider using a QAbstractMessageHandler instead of QMessageBox

class ErrorReporterPrivate : public QObject
{
  public:
    ErrorReporterPrivate(ErrorReporter *parent);
    ~ErrorReporterPrivate();

    static QRegExp           _xtupleError;

    QString text(QSqlError err, StatementType);
    QString text(QString   err, StatementType);

  private:
    ErrorReporter *_parent;
};

ErrorReporterPrivate::ErrorReporterPrivate(ErrorReporter *parent)
  : QObject(parent)
{
  _parent = parent;
}

ErrorReporterPrivate::~ErrorReporterPrivate()
{
}

/* look for [xtuple: majorkey, minorkey [, context [, ...] ] ]
   in first pass, majorkey is the stored proc name and
                  minorkey is the old negative return code indicating an error
                  one or more context values that can be inserted in the message
                      once the messages are expanded appropriately
 */
QRegExp ErrorReporterPrivate::_xtupleError(
//        "\\[\\s*xtuple\\s*:\\s*([^, ]+)\\s*,\\s*([^, \\]])\\s*(\\[^\\]]*)\\]"
          "\\[\\s*xtuple:\\s*([^, ]+),\\s*([^, \\]]+)(.*)\\]"
);

QString ErrorReporterPrivate::text(QSqlError err, StatementType type)
{
  return text(err.text(), type);
}

// TODO: find a better way to handle the lookups - binary search or hash table
QString ErrorReporterPrivate::text(QString msg, StatementType type)
{
  if (msg.isEmpty())
    return msg;

  if (_xtupleError.indexIn(msg) >= 0)
  {
    if (_xtupleError.cap(3).length() > 0)
      qWarning("ErrorReporterPrivate::text() found %d captures for error: %s",
               _xtupleError.captureCount(), qPrintable(_xtupleError.cap(3)));
    return storedProcErrorLookup(_xtupleError.cap(1),
                                 _xtupleError.cap(2).toInt());
  }
  else
  {
    for (unsigned int i = 0; i < sizeof(dberrs) / sizeof(dberrs[0]); i++)
    {
      if (dberrs[i].type & type && msg.contains(dberrs[i].constraint))
      {
        if (dberrs[i].lookup)
          return storedProcErrorLookup(dberrs[i].msg, dberrs[i].lookup);
        else if (! dberrs[i].msg.isEmpty())
          return dberrs[i].msg;
      }
    }
  }

  return msg;
}

///////////////////////////////////////////////////////////////////////////

ErrorReporter *ErrorReporter::_singleton = 0;

ErrorReporter *ErrorReporter::reporter()
{
  if (! _singleton)
    _singleton = new ErrorReporter(QApplication::instance());

  return _singleton;
}

ErrorReporter::ErrorReporter(QObject *parent)
  : QObject(parent)
{
  _private = new ErrorReporterPrivate(this);
}

ErrorReporter::~ErrorReporter()
{
}

bool ErrorReporter::error(const QString &err, const QString file, int line)
{
  if (err.isEmpty())
    return false;

  return error(QtCriticalMsg, 0, tr("Error"), err, QString(), file, line);
}

bool ErrorReporter::error(QtMsgType type,       QWidget *parent,
                          const QString title,
                          const QSqlError &err, const QString file, int line)
{
  if (err.type() == QSqlError::NoError)
    return false;

  return error(type, parent, title, QString(),
               reporter()->_private->text(err, Unknown), file, line);
}

bool ErrorReporter::error(QtMsgType type,       QWidget *parent,
                          const QString title,  const QString &userMessage,
                          const QSqlError &err, const QString file, int line)
{
  if (err.type() == QSqlError::NoError)
    return false;

  return error(type, parent, title, userMessage,
               reporter()->_private->text(err, Unknown), file, line);
}

bool ErrorReporter::error(QtMsgType type,       QWidget *parent,
                          const QString title,
                          const QSqlQuery &qry, const QString file, int line)
{
  return error(type, parent, title, QString(), qry, file, line);
}

bool ErrorReporter::error(QtMsgType type,       QWidget *parent,
                          const QString title,  const QString &userMessage,
                          const QSqlQuery &qry, const QString file, int line)
{
  if (qry.lastError().type() == QSqlError::NoError)
    return false;

  QMessageBox::Icon icon;
  switch (type)
  {
    case QtDebugMsg:   icon = QMessageBox::Information;  break;
    case QtWarningMsg: icon = QMessageBox::Warning;      break;

    case QtCriticalMsg:
    case QtFatalMsg:
    default:           icon = QMessageBox::Critical;     break;
  }

  StatementType stmttype = Unknown;
  QString querystr = qry.lastQuery();
  if (querystr.startsWith("SELECT", Qt::CaseInsensitive))
    stmttype = Select;
  else if (querystr.startsWith("DELETE", Qt::CaseInsensitive))
    stmttype = Delete;
  else if (querystr.startsWith("UPDATE", Qt::CaseInsensitive))
    stmttype = Update;
  else if (querystr.startsWith("INSERT", Qt::CaseInsensitive))
    stmttype = Insert;

  QMessageBox dlg(icon, title, userMessage,
                  QMessageBox::Ok, parent);
  if (! file.isEmpty())
  {
    if (line >= 0)
      dlg.setInformativeText(tr("File %1, line %2").arg(file).arg(line));
    else
      dlg.setInformativeText(tr("File %1").arg(file));
  }

  QStringList bindings;
  QMapIterator<QString, QVariant> i(qry.boundValues());
  while (i.hasNext())
  {
    i.next();
    bindings << QString("%1:\t%2").arg(i.key(), i.value().toString());
  }

  if (userMessage.isEmpty())
    dlg.setText(reporter()->_private->text(qry.lastError().text(), stmttype));

  dlg.setDetailedText(QString("%1\n\nThe Query:\n%2\n\nBound Values:\n%3")
                      .arg(qry.lastError().text(), querystr, bindings.join("\n")));

  dlg.exec();
  return true;
}

bool ErrorReporter::error(QtMsgType type,       QWidget *parent,
                          const QString title,
                          const QString &err,   const QString file, int line)
{
  return error(type, parent, title, QString(), err, file, line);
}

bool ErrorReporter::error(QtMsgType type,       QWidget *parent,
                          const QString title,  const QString &userMessage,
                          const QString &err,   const QString file, int line)
{
  if (err.isEmpty())
    return false;

  QMessageBox::Icon icon;
  switch (type)
  {
    case QtDebugMsg:   icon = QMessageBox::Information;  break;
    case QtWarningMsg: icon = QMessageBox::Warning;      break;

    case QtCriticalMsg:
    case QtFatalMsg:
    default:           icon = QMessageBox::Critical;     break;
  }

  QMessageBox dlg(icon, title, userMessage, QMessageBox::Ok, parent);
  if (! file.isEmpty())
  {
    if (line >= 0)
      dlg.setInformativeText(tr("File %1, line %2").arg(file).arg(line));
    else
      dlg.setInformativeText(tr("File %1").arg(file));
  }

  if (userMessage.isEmpty())
    dlg.setText(err);
  else
    dlg.setDetailedText(err);

  dlg.exec();
  return true;
}
