/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public Licen'se and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#include "polyxedit-ui-reportopt.h"



GtkWidget *
polyxedit_report_opt_wnd_setup (PxmEditCtxt *editctxt)
{
  GtkWidget *widget = NULL;
  GtkWidget *window = NULL;
  GtkWidget *seqed_widget = NULL;

  GladeXML *xml = NULL;

  gchar *gui_file = NULL;
  gchar *help = NULL;

  PxmProp *prop = NULL;
  
  PxmReportOpt *reportopt = NULL;
  PxmReportOpt *reportopt_new = NULL;
  

  g_assert (editctxt != NULL);

  
  seqed_widget = 
    g_object_get_data (G_OBJECT (editctxt->sequence_editor_wnd), "seqed_widget");
  g_assert (seqed_widget != NULL);
  


  gui_file = 
    g_strdup_printf ("%s/polyxedit-report.glade", userspec->gladedir);

  xml = glade_xml_new (gui_file, "report_options_wnd", 
		       PACKAGE);

  g_free (gui_file);
  
  if (xml == NULL)
    {
      g_error (_("%s@%d: failed to load the interface\n"),
	     __FILE__, __LINE__);

      g_free (gui_file);
      
      return NULL;
    }
  
  window = glade_xml_get_widget (xml, "report_options_wnd");
  
  if (window == NULL)
    {
      g_critical (_("%s@%d: failed to create the report options window\n"),
	     __FILE__, __LINE__);
      
      g_object_unref (G_OBJECT (xml));
      
      return NULL;
    }

  /* Immediately set to the window a pointer to the editctxt passed as
     parameter.
  */
  g_object_set_data (G_OBJECT (window), "editctxt", editctxt);

  /* If the editctxt has not a reportopt already, we create a new
     PxmReportOpt instance, that we'll set as a FULL datum to the
     editctxt.
  */
  prop = libpolyxmass_prop_find_prop (editctxt->propGPA,
				      NULL, NULL,
				      "REPORTOPT", 
				      NULL, PXM_CMP_NO_DEEP);
  
  if (prop == NULL)
    {
      /* There is no such property, thus we have to create one.
       */
      prop = libpolyxmass_reportopt_prop_new ();
      libpolyxmass_reportopt_set_default ((PxmReportOpt *) prop->data);
      g_ptr_array_add (editctxt->propGPA, prop);
    }

  /* Now we have a prop object that contains a PxmReportOpt * datum,
    be it totally new or already existing.
  */
  reportopt = (PxmReportOpt *) prop->data;

  /* Create a copy of the initial reportopt object, so that when the
     user makes modifications we only transfer the modifications to
     the original reportopt object upon clicking onto the Validation
     button. This way, we may have cancelling route...
  */
  reportopt_new = libpolyxmass_reportopt_dup (reportopt, PXM_DUP_DEEP);
  
  g_object_set_data_full (G_OBJECT (window), 
			  "reportopt_new", reportopt_new,
			  (GDestroyNotify) libpolyxmass_reportopt_free);



  /* The frame where the polymer sequence data are displayed:
   */
  widget = glade_xml_get_widget (xml, "polseq_prop_frame");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "polseq_prop_frame", widget);

  /* The button in the polymer sequence data frame, thanks to which we
     can hide/show the sequence data.
  */
  widget = glade_xml_get_widget (xml, "polseq_prop_show_hide_button");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "polseq_prop_show_hide_button", widget);

  /* Let's connect the button to a "clicked" signal.
  */
  g_signal_connect 
    (G_OBJECT (widget),
     "clicked",
     G_CALLBACK 
     (polyxedit_report_opt_wnd_polseq_prop_show_hide_button_clicked), 
     window);
  

  /* The vertical box where the polymer sequence data widgets are packed, 
     so that we make them invisible in one go.
  */
  widget = glade_xml_get_widget (xml, "polseq_prop_vbox");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "polseq_prop_vbox", widget);
  

  /* Set the name of the polymer sequence to its correspondent GtkEntry.
   */
  widget = glade_xml_get_widget (xml, "polseq_name_entry"); 
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "polseq_name_entry", widget);

  g_assert (editctxt->polymer->plminfo->name != NULL);
  
  gtk_entry_set_text (GTK_ENTRY (widget), 
		      editctxt->polymer->plminfo->name);

  /* Set the code of the polymer sequence to its correspondent GtkEntry.
   */
  widget = glade_xml_get_widget (xml, "polseq_code_entry"); 
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "polseq_code_entry", widget);

  g_assert (editctxt->polymer->plminfo->code != NULL);
  
  gtk_entry_set_text (GTK_ENTRY (widget), 
		      editctxt->polymer->plminfo->code);


  /* Set the identity number (actually the seqed_widget pointer) to 
   * its GtkEntry (this is useful when cleavages are made to identify
   * unambiguously the polymer from which results are displayed).
   */
  widget = glade_xml_get_widget (xml, "polseq_id_number_entry");
  g_object_set_data (G_OBJECT (window), 
		     "polseq_id_number_entry",
		     widget);
  help = g_strdup_printf ("%p", seqed_widget);
  gtk_entry_set_text (GTK_ENTRY (widget), help);
  g_free (help);



  /* AND now, while we set up the window, we'll be able to use the
     reportopt instance to initialize the widgets according to it !
   */

  /*
   */
  widget = glade_xml_get_widget (xml, "export_format_txt_radiobutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "export_format_txt_radiobutton", widget);

  if (reportopt->export_format == EXPORT_FORMAT_TEXT)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);
  
  
  
  /*
   */
  widget = glade_xml_get_widget (xml, "export_format_latex_radiobutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "export_format_latex_radiobutton", widget);

  if (reportopt->export_format == EXPORT_FORMAT_LATEX)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);


  /*
   */
  widget = glade_xml_get_widget (xml, "polymer_options_calcopt_checkbutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "polymer_options_calcopt_checkbutton", widget);

  if (reportopt->polymer_opt & PXM_PLM_REPORTOPT_CALCOPTIONS)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), FALSE);



  /*
   */
  widget = glade_xml_get_widget (xml, 
				 "polymer_options_wholeseq_masses_checkbutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "polymer_options_wholeseq_masses_checkbutton", widget);

  if (reportopt->polymer_opt & PXM_PLM_REPORTOPT_WHOLE_SEQ_MASSES)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);
  

  widget = glade_xml_get_widget (xml, "polymer_options_selseq_masses_checkbutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "polymer_options_selseq_masses_checkbutton", widget);

  if (reportopt->polymer_opt & PXM_PLM_REPORTOPT_SELECTION_MASSES)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);



  widget = glade_xml_get_widget (xml, "polymer_options_sequence_checkbutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "polymer_options_sequence_checkbutton", widget);

  if (reportopt->polymer_opt & PXM_PLM_REPORTOPT_SEQUENCE)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);



  widget = glade_xml_get_widget (xml, "polymer_options_prop_checkbutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "polymer_options_prop_checkbutton", widget);

  if (reportopt->polymer_opt & PXM_PLM_REPORTOPT_PROP)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);



  widget = glade_xml_get_widget (xml, "polymer_options_author_checkbutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "polymer_options_author_checkbutton", widget);

  if (reportopt->polymer_opt & PXM_PLM_REPORTOPT_AUTHOR)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);



  widget = glade_xml_get_widget (xml, "polymer_options_date_checkbutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "polymer_options_date_checkbutton", widget);

  if (reportopt->polymer_opt & PXM_PLM_REPORTOPT_DATE)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);



  widget = glade_xml_get_widget (xml, "oligomer_options_calcopt_checkbutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "oligomer_options_calcopt_checkbutton", widget);

  if (reportopt->oligomer_opt & PXM_OLM_REPORTOPT_CALCOPTIONS)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);


  widget = glade_xml_get_widget (xml, "oligomer_options_mono_mass_checkbutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "oligomer_options_mono_mass_checkbutton", widget);

  if (reportopt->oligomer_opt & PXM_OLM_REPORTOPT_MONO_MASS)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);


  widget = glade_xml_get_widget (xml, "oligomer_options_avg_mass_checkbutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "oligomer_options_avg_mass_checkbutton", widget);

  if (reportopt->oligomer_opt & PXM_OLM_REPORTOPT_AVG_MASS)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);


  widget = glade_xml_get_widget (xml, "oligomer_options_sequence_checkbutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "oligomer_options_sequence_checkbutton", widget);


  if (reportopt->oligomer_opt & PXM_OLM_REPORTOPT_SEQUENCE)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);


  widget = glade_xml_get_widget (xml, "oligomer_options_prop_checkbutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "oligomer_options_prop_checkbutton", widget);


  if (reportopt->oligomer_opt & PXM_OLM_REPORTOPT_PROP)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);


  widget = glade_xml_get_widget (xml, "monomer_options_prop_checkbutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "monomer_options_prop_checkbutton", widget);

  if (reportopt->monomer_opt & PXM_MNM_REPORTOPT_PROP)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);



  widget = glade_xml_get_widget (xml, "report_options_polymer_apply_button");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "report_options_polymer_apply_button", widget);

  g_signal_connect (G_OBJECT (widget),
		    "clicked",
		    G_CALLBACK
		    (polyxedit_report_opt_wnd_polymer_apply_button), 
		    window);

  widget = glade_xml_get_widget (xml, "report_options_oligomer_apply_button");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "report_options_oligomer_apply_button", widget);

  g_signal_connect (G_OBJECT (widget),
		    "clicked",
		    G_CALLBACK 
		    (polyxedit_report_opt_wnd_oligomer_apply_button), 
		    window);

  widget = glade_xml_get_widget (xml, "report_options_monomer_apply_button");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "report_options_monomer_apply_button", widget);

  g_signal_connect (G_OBJECT (widget),
		    "clicked",
		    G_CALLBACK 
		    (polyxedit_report_opt_wnd_monomer_apply_button), 
		    window);


  widget = glade_xml_get_widget (xml, "report_options_validate_button");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "report_options_validate_button", widget);

  g_signal_connect (G_OBJECT (widget),
		    "clicked",
		    G_CALLBACK 
		    (polyxedit_report_opt_wnd_validate_button), 
		    window);

  widget = glade_xml_get_widget (xml, "report_options_cancel_button");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window),
		     "report_options_cancel_button", widget);

  g_signal_connect (G_OBJECT (widget),
		    "clicked",
		    G_CALLBACK 
		    (polyxedit_report_opt_wnd_cancel_button), 
		    window);



  gtk_widget_show_all (GTK_WIDGET (window));


  /* Signal / callback connections.
   */
  g_signal_connect (G_OBJECT (window),
		    "delete_event",
		    G_CALLBACK (polyxedit_report_opt_wnd_delete_event), 
		    editctxt);
  
  /* Signal / callback connections.
   */
  g_signal_connect (G_OBJECT (window),
		    "destroy_event",
		    G_CALLBACK (polyxedit_report_opt_wnd_destroy_event), 
		    editctxt);
  


  /* We have finished setting up the window, and so also using the xml
     data, unref them.
   */
  g_object_unref (G_OBJECT (xml));
  
  /* Set this window pointer as a full datum to the polymer sequence
     editor window, so that when it is closed, this window is closed
     also.
  */
  g_object_set_data_full 
    (G_OBJECT (editctxt->sequence_editor_wnd),
     "report_opt_wnd", GTK_WIDGET (window), 
     (GDestroyNotify)polyxedit_report_opt_wnd_really_close);
  
  
  return window;
}


gint
polyxedit_report_opt_wnd_polymer_apply_button (GtkWidget *button,
					       gpointer data)
{
  /* The data parameter is the window.
   */
  GtkWidget *window = data;
  GtkWidget *widget = NULL;

  PxmEditCtxt *editctxt = NULL;
  PxmReportOpt *reportopt_new = NULL;
    

  g_assert (window != NULL);

  editctxt = g_object_get_data (G_OBJECT (window), "editctxt");
  g_assert (editctxt != NULL);

  /* Get a pointer to the "new" reportopt_new instance where we'll
     set the new values from what we see in the window.
  */
  reportopt_new = g_object_get_data (G_OBJECT (window), "reportopt_new");
  g_assert (reportopt_new != NULL);
  
  /**/
  widget = g_object_get_data (G_OBJECT (window),
			      "polymer_options_calcopt_checkbutton");
  g_assert (widget != NULL);
  
  if (TRUE == gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    {
      reportopt_new->polymer_opt |= PXM_PLM_REPORTOPT_CALCOPTIONS;
    }
  else
    {
      reportopt_new->polymer_opt = 
	reportopt_new->polymer_opt & ~PXM_PLM_REPORTOPT_CALCOPTIONS;
    }
  

  widget = g_object_get_data (G_OBJECT (window),
			      "polymer_options_wholeseq_masses_checkbutton");
  g_assert (widget != NULL);
  
  if (TRUE == gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    {
      reportopt_new->polymer_opt |= PXM_PLM_REPORTOPT_WHOLE_SEQ_MASSES;
    }
  else
    {
      if ((reportopt_new->polymer_opt & PXM_PLM_REPORTOPT_WHOLE_SEQ_MASSES) ==
	  PXM_PLM_REPORTOPT_WHOLE_SEQ_MASSES)
	reportopt_new->polymer_opt ^= PXM_PLM_REPORTOPT_WHOLE_SEQ_MASSES;
    }
  

  widget = g_object_get_data (G_OBJECT (window),
			      "polymer_options_selseq_masses_checkbutton");
  g_assert (widget != NULL);
  
  if (TRUE == gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    {
      reportopt_new->polymer_opt |= PXM_PLM_REPORTOPT_SELECTION_MASSES;
    }
  else
    {
      if ((reportopt_new->polymer_opt & PXM_PLM_REPORTOPT_SELECTION_MASSES) ==
	  PXM_PLM_REPORTOPT_SELECTION_MASSES)
	reportopt_new->polymer_opt ^= PXM_PLM_REPORTOPT_SELECTION_MASSES;
    }
  

  widget = g_object_get_data (G_OBJECT (window),
			      "polymer_options_sequence_checkbutton");
  g_assert (widget != NULL);
  
  if (TRUE == gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    {
      reportopt_new->polymer_opt |= PXM_PLM_REPORTOPT_SEQUENCE;
    }
  else
    {
      if ((reportopt_new->polymer_opt & PXM_PLM_REPORTOPT_SEQUENCE) ==
	  PXM_PLM_REPORTOPT_SEQUENCE)
	reportopt_new->polymer_opt ^= PXM_PLM_REPORTOPT_SEQUENCE;
    }
  

  widget = g_object_get_data (G_OBJECT (window),
			      "polymer_options_prop_checkbutton");
  g_assert (widget != NULL);
  
  if (TRUE == gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    {
      reportopt_new->polymer_opt |= PXM_PLM_REPORTOPT_PROP;
    }
  else
    {
      if ((reportopt_new->polymer_opt & PXM_PLM_REPORTOPT_PROP) ==
	  PXM_PLM_REPORTOPT_PROP)
	reportopt_new->polymer_opt ^= PXM_PLM_REPORTOPT_PROP;
    }
  

  widget = g_object_get_data (G_OBJECT (window),
			      "polymer_options_author_checkbutton");
  g_assert (widget != NULL);
  
  if (TRUE == gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    {
      reportopt_new->polymer_opt |= PXM_PLM_REPORTOPT_AUTHOR;
    }
  else
    {
      if ((reportopt_new->polymer_opt & PXM_PLM_REPORTOPT_AUTHOR) ==
	  PXM_PLM_REPORTOPT_AUTHOR)
	reportopt_new->polymer_opt ^= PXM_PLM_REPORTOPT_AUTHOR;
    }
  

  widget = g_object_get_data (G_OBJECT (window),
			      "polymer_options_date_checkbutton");
  g_assert (widget != NULL);
  
  if (TRUE == gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    {
      reportopt_new->polymer_opt |= PXM_PLM_REPORTOPT_DATE;
    }
  else
    {
      if ((reportopt_new->polymer_opt & PXM_PLM_REPORTOPT_DATE) ==
	  PXM_PLM_REPORTOPT_DATE)
	reportopt_new->polymer_opt ^= PXM_PLM_REPORTOPT_DATE;
    }
  
  /* At this point we have finished doing the task... we can return.
   */ 
  return 1;
}


gint
polyxedit_report_opt_wnd_oligomer_apply_button (GtkWidget *button,
					       gpointer data)
{
  /* The data parameter is the window.
   */
  GtkWidget *window = data;
  GtkWidget *widget = NULL;

  PxmEditCtxt *editctxt = NULL;
  PxmReportOpt *reportopt_new = NULL;
    

  g_assert (window != NULL);

  editctxt = g_object_get_data (G_OBJECT (window), "editctxt");
  g_assert (editctxt != NULL);

  /* Get a pointer to the "new" reportopt_new instance where we'll
     set the new values from what we see in the window.
  */
  reportopt_new = g_object_get_data (G_OBJECT (window), "reportopt_new");
  g_assert (reportopt_new != NULL);
  
  /**/
  widget = g_object_get_data (G_OBJECT (window),
			      "oligomer_options_calcopt_checkbutton");
  g_assert (widget != NULL);
  
  if (TRUE == gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    {
      reportopt_new->oligomer_opt |= PXM_OLM_REPORTOPT_CALCOPTIONS;
    }
  else
    {
      if ((reportopt_new->oligomer_opt & PXM_OLM_REPORTOPT_CALCOPTIONS) ==
	  PXM_OLM_REPORTOPT_CALCOPTIONS)
	reportopt_new->oligomer_opt ^= PXM_OLM_REPORTOPT_CALCOPTIONS;
    }

  /**/
  widget = g_object_get_data (G_OBJECT (window),
			      "oligomer_options_mono_mass_checkbutton");
  g_assert (widget != NULL);
  
  if (TRUE == gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    {
      reportopt_new->oligomer_opt |= PXM_OLM_REPORTOPT_MONO_MASS;
    }
  else
    {
      if ((reportopt_new->oligomer_opt & PXM_OLM_REPORTOPT_MONO_MASS) ==
	  PXM_OLM_REPORTOPT_MONO_MASS)
	reportopt_new->oligomer_opt ^= PXM_OLM_REPORTOPT_MONO_MASS;
    }
  
  
  /**/
  widget = g_object_get_data (G_OBJECT (window),
			      "oligomer_options_avg_mass_checkbutton");
  g_assert (widget != NULL);
  
  if (TRUE == gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    {
      reportopt_new->oligomer_opt |= PXM_OLM_REPORTOPT_AVG_MASS;
    }
  else
    {
      if ((reportopt_new->oligomer_opt & PXM_OLM_REPORTOPT_AVG_MASS) ==
	  PXM_OLM_REPORTOPT_AVG_MASS)
	reportopt_new->oligomer_opt ^= PXM_OLM_REPORTOPT_AVG_MASS;
    }
  

  /**/
  widget = g_object_get_data (G_OBJECT (window),
			      "oligomer_options_sequence_checkbutton");
  g_assert (widget != NULL);
  
  if (TRUE == gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    {
      reportopt_new->oligomer_opt |= PXM_OLM_REPORTOPT_SEQUENCE;
    }
  else
    {
      if ((reportopt_new->oligomer_opt & PXM_OLM_REPORTOPT_SEQUENCE) ==
	  PXM_OLM_REPORTOPT_SEQUENCE)
	reportopt_new->oligomer_opt ^= PXM_OLM_REPORTOPT_SEQUENCE;
    }
  
  
  /**/
  widget = g_object_get_data (G_OBJECT (window),
			      "oligomer_options_prop_checkbutton");
  g_assert (widget != NULL);
  
  if (TRUE == gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    {
      reportopt_new->oligomer_opt |= PXM_OLM_REPORTOPT_PROP;
    }
  else
    {
      if ((reportopt_new->oligomer_opt & PXM_OLM_REPORTOPT_PROP) ==
	  PXM_OLM_REPORTOPT_PROP)
	reportopt_new->oligomer_opt ^= PXM_OLM_REPORTOPT_PROP;
    }
    
  /* At this point we have finished doing the task... we can return.
   */ 
  return 1;
}


gint
polyxedit_report_opt_wnd_monomer_apply_button (GtkWidget *button,
					       gpointer data)
{
  /* The data parameter is the window.
   */
  GtkWidget *window = data;
  GtkWidget *widget = NULL;

  PxmEditCtxt *editctxt = NULL;
  PxmReportOpt *reportopt_new = NULL;
    

  g_assert (window != NULL);

  editctxt = g_object_get_data (G_OBJECT (window), "editctxt");
  g_assert (editctxt != NULL);

  /* Get a pointer to the "new" reportopt_new instance where we'll
     set the new values from what we see in the window.
  */
  reportopt_new = g_object_get_data (G_OBJECT (window), "reportopt_new");
  g_assert (reportopt_new != NULL);
  
  
  /**/
  widget = g_object_get_data (G_OBJECT (window),
			      "monomer_options_prop_checkbutton");
  g_assert (widget != NULL);
  
  if (TRUE == gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    {
      reportopt_new->monomer_opt |= PXM_MNM_REPORTOPT_PROP;
    }
  else
    {
      if ((reportopt_new->monomer_opt & PXM_MNM_REPORTOPT_PROP) ==
	  PXM_MNM_REPORTOPT_PROP)
	reportopt_new->monomer_opt ^= PXM_MNM_REPORTOPT_PROP;
    }

  /* At this point we have finished doing the task... we can return.
   */ 
  return 1;
}


gint
polyxedit_report_opt_wnd_validate_button (GtkWidget *button,
					  gpointer data)
{
  /* The data parameter is the window.
   */
  GtkWidget *window = data;
  GtkWidget *widget = NULL;

  PxmEditCtxt *editctxt = NULL;

  PxmReportOpt *reportopt = NULL;
  PxmReportOpt *reportopt_new = NULL;
    
  PxmProp *prop = NULL;
  
  g_assert (window != NULL);

  editctxt = g_object_get_data (G_OBJECT (window), "editctxt");
  g_assert (editctxt != NULL);

  /* Get a pointer to the "new" reportopt_new instance where we'll
     set the new values from what we see in the window.
  */
  reportopt_new = g_object_get_data (G_OBJECT (window), "reportopt_new");
  g_assert (reportopt_new != NULL);
  
  prop = libpolyxmass_prop_find_prop (editctxt->propGPA,
				      NULL, NULL,
				      "REPORTOPT", 
				      NULL, PXM_CMP_NO_DEEP);

  /* It cannot be that we do not find the prop object at this point.
   */
  g_assert (prop != NULL);
  
  reportopt = (PxmReportOpt *) prop->data;
  g_assert (reportopt != NULL);

  /* When the user clicked onto the "Apply" buttons for
     polymer/oligomer/monomer options, the new values were transferred
     to the reportopt_new instance. 

     We still have to make sure the other options not "governed" by
     the three "Apply" buttons be transferred to the reportopt
     instance: this is specifically the case for the format of the
     string to be returned:
  */
  widget = g_object_get_data (G_OBJECT (window),
			      "export_format_txt_radiobutton");
  g_assert (widget != NULL);
  
  if (TRUE == gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    reportopt_new->export_format = EXPORT_FORMAT_TEXT;
  else
    reportopt_new->export_format = EXPORT_FORMAT_LATEX;
  

  /* And now, all we do is to copy from the reportopt_new instance to
     the reportopt one all the elements that were not in the propGPA
     array.
  */
  libpolyxmass_reportopt_copy_not_deep (reportopt, reportopt_new);

  /* OK, at this point, we have to close the window, which will have
     as a side effect the freeing of the reportopt_new instance.
  */
  return polyxedit_report_opt_wnd_delete_event (window, NULL, editctxt);
}

void
polyxedit_report_opt_wnd_polseq_prop_show_hide_button_clicked (GtkWidget *widget,
							      gpointer data)
{
  /* Parameter data is the window.
   */
  GtkWidget *window = data;
  
  GtkWidget *vbox = NULL;
  
  g_assert (widget != NULL);
  g_assert (window != NULL);
  
  /* Get the vertical box where the polymer sequence data displaying
     widgets are packed.
  */
  vbox = g_object_get_data (G_OBJECT (window),
			    "polseq_prop_vbox");
  g_assert (vbox != NULL);
  
  /* If the vbox is visible we make it invisible, and vice-versa.
   */
  if (GTK_WIDGET_VISIBLE (vbox))
    gtk_widget_hide (vbox);
  else
    gtk_widget_show (vbox);
  
  return ;
}


gint
polyxedit_report_opt_wnd_cancel_button (GtkWidget *button,
					gpointer data)
{
  /* The data parameter is the window.
   */
  GtkWidget *window = data;

  PxmEditCtxt *editctxt = NULL;

  g_assert (window != NULL);

  editctxt = g_object_get_data (G_OBJECT (window), "editctxt");
  g_assert (editctxt != NULL);

  /* OK, at this point, we have to close the window, which will have
     as a side effect the freeing of the reportopt_new instance.
  */
  return polyxedit_report_opt_wnd_delete_event (window, NULL, editctxt);
}














/* WINDOW LIFE-CYCLE FUNCTIONS.
 */
void
polyxedit_report_opt_wnd_really_close (GtkWidget *window)
{
  
  g_assert (window != NULL);

  gtk_widget_destroy (window);
}


gint
polyxedit_report_opt_wnd_delete_event  (GtkWidget *window, 
				      GdkEventAny *event, 
				      gpointer data)
{
  PxmEditCtxt *editctxt = data;
  
  g_assert (window != NULL);
  g_assert (editctxt != NULL);
  
  
  /* We set the datum to NULL, then the GDestroyNotify callback that
     was specified when the datum was set first (that is
     xxx_wnd_really_close () function above) will be called, thus
     destroying *this window, which is exactly what we want !
  */
  g_object_set_data (G_OBJECT (editctxt->
			       sequence_editor_wnd), 
		     "report_opt_wnd", NULL);
    
  return TRUE;
}


gint
polyxedit_report_opt_wnd_destroy_event  (GtkWidget *window, 
				       GdkEventAny *event, 
				       gpointer data)
{
  return FALSE;
}

