/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef POLYXMASS_UI_FILECHOOSERS_H
#define POLYXMASS_UI_FILECHOOSERS_H

#include "polyxmass-globals.h"

enum
  {
    COLUMN_ATOMSPEC_ATOMDEF = 0,
    COLUMN_ATOMSPEC_FILE,

    COLUMN_ATOMSPEC_POINTER,
	   
    COLUMN_ATOMSPEC_VISIBLE,

    COLUMN_ATOMSPEC_COL_COUNT
  };

enum
  {
    COLUMN_POLCHEMSPEC_TYPE = 0,
    COLUMN_POLCHEMSPEC_FILE,
    COLUMN_POLCHEMSPEC_DIR,

    COLUMN_POLCHEMSPEC_POINTER,
	   
    COLUMN_POLCHEMSPEC_VISIBLE,

    COLUMN_POLCHEMSPEC_COL_COUNT
  };


typedef enum _PxmFileChooseConfig PxmFileChooseConfig;

enum _PxmFileChooseConfig
  {
    PXM_FILE_CHOOSE_NONE = 0,

    /* This one allows for selecting an atom definition file only as an
       item in a treeview of available atomdef files (NOT as a random
       file picked from the disk in the GtkFileChooseWidget).
    */
    PXM_FILE_CHOOSE_ATOMDEF = 1 << 0,

    /* This one allows for selecting a polymer chemistry definition
       file only as an item in a treeview of available polchemdef
       files (NOT as a random file picked from the disk in the
       GtkFileChooseWidget).
    */
    PXM_FILE_CHOOSE_POLCHEMDEF = 1 << 2,

    /* If any of the above is |'ed with the one below, then it will be
       made possible to show a GtkFileChooserWidget in which the user
       will be able to select a random file from disk.
    */
    PXM_FILE_CHOOSE_GTK = 1 << 3,

    /* Below will allow the user to set some data about a new polymer
       sequence. To use in combination with PXM_FILE_CHOOSE_POLCHEMDEF
       for selection of an existing polymer chemistry
       definition. There will be a GtkFileChooserWidget there,
       allowing for the selection of an unexistent file on disk for
       saving the polymer sequence. (Not to mistake with the
       GtkFileChooserWidget that is used to select a random polymer
       chemistry definition file.
    */
    PXM_FILE_CHOOSE_POLSEQDATA_INIT = 1 << 4,

    /* 
       Values 1 << 5 and 1 << 6 and 1 << 7 are reserved.
    */
  };




GtkWidget *
polyxmass_filechoosers_show_wnd (GtkWidget *parent, 
				 PxmFileChooseConfig config);

GtkWidget *
polyxmass_filechoosers_setup_atomdef_wnd (PxmFileChooseConfig config);

GtkWidget *
polyxmass_filechoosers_setup_polchemdef_wnd (PxmFileChooseConfig config);

GtkWidget *
polyxmass_filechoosers_setup_polseq_init_wnd (PxmFileChooseConfig config);




void
polyxmass_filechoosers_atomdef_validate_button_clicked (GtkWidget *widget,
							 gpointer data);
void
polyxmass_filechoosers_atomdef_cancel_button_clicked (GtkWidget *widget,
							 gpointer data);

void
polyxmass_filechoosers_polchemdef_validate_button_clicked (GtkWidget *widget,
							 gpointer data);
void
polyxmass_filechoosers_polchemdef_cancel_button_clicked (GtkWidget *widget,
							 gpointer data);



void
polyxmass_filechoosers_polseq_init_validate_button_clicked (GtkWidget *
							    widget,
							    gpointer 
							    data);
void
polyxmass_filechoosers_polseq_init_cancel_button_clicked (GtkWidget *
							  widget,
							  gpointer 
							  data);






/* WINDOW CLOSING FUNCTIONS
 */
gboolean
polyxmass_filechoosers_atomdef_wnd_delete_event (GtkWidget *window,
						     GdkEvent *event,
						    gpointer data);

gboolean
polyxmass_filechoosers_atomdef_wnd_destroy_event (GtkWidget *window,
						      GdkEvent *event,
						     gpointer data);

gboolean
polyxmass_filechoosers_polchemdef_wnd_delete_event (GtkWidget *window,
						     GdkEvent *event,
						    gpointer data);

gboolean
polyxmass_filechoosers_polchemdef_wnd_destroy_event (GtkWidget *window,
						      GdkEvent *event,
						     gpointer data);

gboolean
polyxmass_filechoosers_polseq_init_wnd_delete_event (GtkWidget *window,
							   GdkEvent *event,
							   gpointer data);

gboolean
polyxmass_filechoosers_polseq_init_wnd_destroy_event (GtkWidget *window,
						      GdkEvent *event,
						      gpointer data);















#endif /* POLYXMASS_UI_FILECHOOSERS_H */
