/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#ifndef POLYXEDIT_UI_PKA_PH_PI_H
#define POLYXEDIT_UI_PKA_PH_PI_H

#include "polyxedit-globals.h"
#include "polyxedit-editctxt.h"
#include "polyxmass-window-mngmt.h"


GtkWidget *
polyxedit_pka_ph_pi_wnd_setup (PxmEditCtxt *editctxt);

gboolean
polyxedit_pka_ph_pi_wnd_get_sequence_interval (GtkWidget *window,
						gint *start_idx,
					       gint *end_idx);
void
polyxedit_pka_ph_pi_wnd_sequence_region_button (GtkWidget *button,
						gpointer data);

gint
polyxedit_pka_ph_pi_wnd_calculate_net_charge_button (GtkWidget *button,
						   gpointer data);

gint
polyxedit_pka_ph_pi_wnd_calculate_pi_button (GtkWidget *button,
					   gpointer data);




/* REPORTING FUNCTIONS.
 */
gchar *
polyxedit_pka_ph_pi_wnd_make_report (PxmReportOpt* reportopt,
				     PxmWinMngmt* winmngmt);

gchar *
polyxedit_pka_ph_pi_wnd_make_report_text_format (PxmReportOpt* reportopt,
						 PxmWinMngmt* winmngmt);

gchar *
polyxedit_pka_ph_pi_wnd_make_report_latex_format (PxmReportOpt* reportopt,
						  PxmWinMngmt* winmngmt);





/* WINDOW LIFE-CYCLE FUNCTIONS.
 */
void
polyxedit_pka_ph_pi_wnd_really_close (GtkWidget *window);

gint
polyxedit_pka_ph_pi_wnd_delete_event  (GtkWidget *window, 
					GdkEventAny *event, 
				       gpointer data);
gint
polyxedit_pka_ph_pi_wnd_destroy_event  (GtkWidget *window, 
					 GdkEventAny *event, 
					gpointer data);

















#endif /* POLYXEDIT_UI_PKA_PH_PI_H */
