/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef POLYXEDIT_RENDERING_H
#define POLYXEDIT_RENDERING_H


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "polyxedit-globals.h"
#include "polyxedit-monicon.h"
#include "polyxedit-editctxt.h"
#include "polyxmass-polchemdefctxt.h"

GdkPixbuf *
polyxedit_rendering_pixbuf_render_no_modif (gchar *code, 
					    gint monicon_size,
					    PxmEditCtxt *editctxt);


GdkPixbuf *
polyxedit_rendering_pixbuf_render_modif (gchar *code,
					 gchar *modif,
					 gint monicon_size,
					 PxmEditCtxt *editctxt);



gboolean
polyxedit_rendering_cursor_monicon_render (PxmEditCtxt *editctxt,
					   gboolean rerender);


GdkPixbuf *
polyxedit_rendering_pixbuf_get_from_data_list (gchar *code, 
					       gchar *modif,
					       PxmEditCtxt *editctxt);

gboolean
polyxedit_rendering_pixbuf_set_to_data_list (GdkPixbuf *pixbuf, 
					     gchar *code, 
					     gchar *modif,
					     PxmEditCtxt *editctxt);

GdkPixbuf *
polyxedit_rendering_pixbuf_make_with_vector (gchar *code, 
					     gint monicon_size,
					     PxmEditCtxt *editctxt);

GdkPixbuf *
polyxedit_rendering_pixbuf_make_with_raster (gchar *code, 
					     gint monicon_size,
					     PxmEditCtxt *editctxt);

gboolean
polyxedit_rendering_monicon_make_canvas_item (PxmMonicon *monicon,
					      gint monicon_size,
					      GdkPixbuf *pixbuf,
					      gint idx,
					      PxmEditCtxt *editctxt);








#endif /* POLYXEDIT_RENDERING_H */
