/***************************************************************************
**                                                                        **
**  Polyphone, a soundfont editor                                         **
**  Copyright (C) 2013-2019 Davy Triponney                                **
**                                                                        **
**  This program is free software: you can redistribute it and/or modify  **
**  it under the terms of the GNU General Public License as published by  **
**  the Free Software Foundation, either version 3 of the License, or     **
**  (at your option) any later version.                                   **
**                                                                        **
**  This program is distributed in the hope that it will be useful,       **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of        **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          **
**  GNU General Public License for more details.                          **
**                                                                        **
**  You should have received a copy of the GNU General Public License     **
**  along with this program. If not, see http://www.gnu.org/licenses/.    **
**                                                                        **
****************************************************************************
**           Author: Davy Triponney                                       **
**  Website/Contact: https://www.polyphone-soundfonts.com                 **
**             Date: 01.01.2013                                           **
***************************************************************************/

#include "sf2pdtapart_phdr.h"
#include <QDataStream>

Sf2PdtaPart_phdr::Sf2PdtaPart_phdr() :
    _isValid(false),
    _preset(0),
    _bank(0),
    _pBagIndex(0),
    _library(0),
    _genre(0),
    _morphology(0)
{

}

QDataStream & operator >> (QDataStream &in, Sf2PdtaPart_phdr &phdr)
{
    // Name
    int length = 20;
    QByteArray buffer(length, Qt::Uninitialized);
    if (in.readRawData(buffer.data(), length) != length)
        return in;
    phdr._name = QString::fromLatin1(buffer);

    // Preset, bank
    in >> phdr._preset;
    in >> phdr._bank;

    // Min index for pBag
    in >> phdr._pBagIndex;

    // Characteristics
    in >> phdr._library;
    in >> phdr._genre;
    in >> phdr._morphology;

    phdr._isValid = true;
    return in;
}
