
/* Web Polygraph       http://www.web-polygraph.org/
 * (C) 2003-2006 The Measurement Factory
 * Licensed under the Apache License, Version 2.0 */

#include "xstd/xstd.h"

#include "xstd/h/string.h"

#include "xstd/BitMask.h"
#include "xstd/Assert.h"


Size BitMask::size() const {
	return BinCount(theCapacity) * sizeof(*theBins);
}

void BitMask::resize(int aCapacity) {
	if (aCapacity == theCapacity)
		return;

	delete[] theBins;
	if (aCapacity > 0) {
		theBins = new Bin[BinCount(aCapacity)];
		theCapacity = aCapacity;
		clear();
	} else {
		theBins = 0;
		theCapacity = 0;
	}
}

void BitMask::grow(int aCapacity, int offset) {
	Assert(aCapacity > theCapacity);

	BitMask old;
	old.takeOver(*this);
	this->resize(aCapacity);

	const int y = offset + old.capacity();
	for (int x = offset; x < y; ++x) {
		if (old.isSet(x % old.capacity()))
			this->beSet(x % capacity());
	}
}

void BitMask::clear() {
	if (theBins)
		memset(theBins, 0, size());
}

void BitMask::takeOver(BitMask &from) {
	Assert(!theBins);
	theBins = from.theBins;
	theCapacity = from.theCapacity;

	from.theBins = 0;
	from.theCapacity = 0;
}
