
/* Web Polygraph       http://www.web-polygraph.org/
 * (C) 2003-2006 The Measurement Factory
 * Licensed under the Apache License, Version 2.0 */

#ifndef POLYGRAPH__CACHE_CACHEENTRY_H
#define POLYGRAPH__CACHE_CACHEENTRY_H

#include "xstd/Queue.h"
#include "base/ObjId.h"

class Cache;
class DistrPoint;

// a central point for information about all objects handled by the cache

class CacheEntry: public QueueItem {
	public:
		friend class DistrPoint;

	public:
		CacheEntry();
		CacheEntry(const ObjId &anId);
		~CacheEntry();

		void reset();

		const ObjId &id() const { return theId; }
		DistrPoint *distrPoint() { return theDistrPoint; }
		Size objSize() const { return theObjSize; }
		bool cached() const { return !isolated(); }
		bool stray() const { return isolated() && !theDistrPoint; }

		DistrPoint *startDistributing(Cache *cache);
		void stopDistributing(DistrPoint *dp);

		void id(const ObjId &anId) { theId = anId; }
		void objSize(Size sz) { theObjSize = sz; }

	public: /* XXX */
		CacheEntry *nextInIdx; // next entry in cache index

	protected:
		DistrPoint *theDistrPoint;   // for active entries only
		ObjId theId;
		Size theObjSize;             // negative if yet unknown

};

#endif
