
/* Web Polygraph       http://www.web-polygraph.org/
 * (C) 2003-2006 The Measurement Factory
 * Licensed under the Apache License, Version 2.0 */

#ifndef POLYGRAPH__BASE_OPT_H
#define POLYGRAPH__BASE_OPT_H

#include "xstd/Array.h"
#include "xstd/String.h"

class Opt;
class CmdLine;


// a group of command line options
class OptGrp: public Array<Opt*> {
	public:
		virtual ~OptGrp() {}

		virtual ostream &printAnonym(ostream &os) const { return os; }
		virtual bool parseAnonym(const Array<const char *> &) { return true; }
		virtual bool canParseAnonym() const { return false; }

		virtual bool validate() const { return true; }

		void share(OptGrp *other);
};

// a generic option
class Opt {
	public:
		Opt(OptGrp *aGrp, const char *aName, const char *aDescr);
		virtual ~Opt();

		void cmdLine(CmdLine *aCmdLine) { theCmdLine = aCmdLine; }

		virtual bool parse(const String &name, const String &val) = 0;
		virtual void report(ostream &) const = 0;
		virtual bool visible() const { return true; } // use in reports

		const String &name() const { return theName; }
		const String &type() const { return theType; }
		const String &descr() const { return theDescr; }

	protected:
		OptGrp *theGrp;
		CmdLine *theCmdLine;
		String theName;
		String theType;
		String theDescr;
};


#endif
