/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Vincent Caron <zerodeux@gnu.org>
 *  Henry Precheur <henry@precheur.org
 *
 */
/*
 *
 * wncdesktop/XwncDesktop.cxx --
 *
 * Copyright (C) Nicolas Roussel
 * Copyright (C) Olivier Chapuis
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#include "mafStdAfx.h"

#ifndef MAF_USE_VS_PCH
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef WIN32
#include "config_win32.h"
#endif

#include <maf/maferror.h>
#include <maf/animate2d.h>
#include <maf/wnc_source.h>
#include <maf/wnc_desktop.h>
#include <maf/wnc_window.h>
#include <maf/url.h>

#include <cstdio> // for snprintf
#include <algorithm>

#endif

// uncomment this to enable debug output in xwnc
// #define _DEBUG_XWNC_

#ifdef	_DEBUG_XWNC_
#	ifdef __GNUC__
#		define XWNC_FUNC()	g_debug("%s %lX", __PRETTY_FUNCTION__, id)
#	else // __GNUC__
#		define XWNC_FUNC()	g_debug("%s %lX", __FUNCTION__, id)
#	endif // __GNUC__
#else	// !_DEBUG_XWNC_
#	define XWNC_FUNC()
#endif	// _DEBUG_XWNC_

template<typename It>
static void	redo_group(It begin, It end,
			   XwncDesktop::WindowMapping& windows,
			   osg::Group* grp)
{
  grp->removeChild(0, grp->getNumChildren());

  for (It i = begin;
       i != end;
       i++)
    {
      XwncDesktop::WindowMapping::iterator	it = windows.find(*i);
      g_assert(it != windows.end());
      XwncWindow*	group = it->second.get();
      if (group->IsMapped())
	grp->addChild(group);
    }
}

void	XwncDesktop::_redoGroup()
{
  redo_group<WindowOrder::iterator>(_wo.begin(),
				    _wo.end(),
				    _windows,
				    mDisplayGroup.get());
  redo_group<WindowOrder::reverse_iterator>(_wo.rbegin(),
					    _wo.rend(),
					    _windows,
					    mHitGroup.get());
}

void	XwncDesktop::_restack(Window up, Window down)
{
  WindowOrder::iterator	up_it = find(_wo.begin(), _wo.end(), up);
  WindowOrder::iterator	down_it = find(_wo.begin(), _wo.end(), down);

  if (_windows.find(up) == _windows.end())
    g_critical("XwncDesktop::_restack: unknown window id %ld", (unsigned long)up);
  else if(_windows[up]->isRootWindow())  // FIXME evil hack to get rid of
				     // root window
    return;

  if (down == 0)
    _up(up);
  else
    {
      g_assert(up_it != _wo.end() && down_it != _wo.end());
      
      std::swap(*up_it, *down_it);
      _redoGroup();
    }
}

void	XwncDesktop::_down(Window id)
{
  WindowOrder::iterator	it = find(_wo.begin(), _wo.end(), id);
  
  g_assert(it != _wo.end());
  
  _wo.erase(it);
  _wo.push_front(id);
  _redoGroup();
}

void	XwncDesktop::_up(Window id)
{
  WindowOrder::iterator	it = find(_wo.begin(), _wo.end(), id);
  
  g_assert(it != _wo.end());
  
  _wo.erase(it);
  _wo.push_back(id);
  _redoGroup();
}

void	XwncDesktop::_add(Window id)
{
  _wo.push_back(id);
  _redoGroup();
}

void	XwncDesktop::_remove(Window id)
{
  WindowOrder::iterator	it = find(_wo.begin(), _wo.end(), id);
  
  g_assert(it != _wo.end());
  
  _wo.erase(it);
  _redoGroup();
}

XwncWindow*	XwncDesktop::GetWindow(const std::string& name)
{
  for (WindowMapping::iterator	i = _windows.begin(); i != _windows.end(); i++) {
    if(i->second.valid()) {
      if (i->second->GetTitle() == name)
	return i->second.get();
    } else {
      g_debug("null window for id %ld", i->first);
    }
  }
  return 0;
}

XwncWindow*	XwncDesktop::GetWindow(Window id)
{
  return _windows.find(id) != _windows.end() ? _windows.find(id)->second.get() : 0;
}

void XwncDesktop::_addWindow(Window id,
			     int x, int y,
			     unsigned int width, unsigned int height,
			     bool map,
			     const char* window_name)
{
  g_assert(_wncServer);

  XwncWindow*	window = new XwncWindow(window_name, id, _wncServer,
					x, y, width, height);

  if (!window)
    {
      g_warning("Unable to create XwncWindow for %lx", id);
      return;
    }

  _windows[id] = window;

  if (map)
    window->setMapped(true);
  else
    window->setMapped(false);
  _add(id); // add and focus new window
}

void XwncDesktop::handleConfigureWindow(Window id, int isroot,
					int x, int y,
					int width, int height,
					const char* window_name)
{
  XWNC_FUNC();
  WindowMapping::iterator i = _windows.find(id);

  osg::ref_ptr<XwncWindow> win = GetWindow(id);

  if (!win)
    {
      if (! isroot)
	{
	  _addWindow(id, x, y, width, height, true, window_name);
	}
      else
	{
	  _addWindow(id, x, y, width, height, false, window_name);
	  g_assert(_windows.find(id) != _windows.end());
	  _windows[id]->setRootWindow();
	}
    }
  else
    {
      win->configure(x, y, width, height);
    }

  if(mName2Animate.find(window_name) != mName2Animate.end()) {
    MAFApplication2DAnimate* animate = mName2Animate[window_name];
    if(_windows.find(id) != _windows.end()) {
      unsigned int width;
      unsigned int height;
      int x;
      int y;
      int window_width;
      int window_height;
  
      getSize(&width, &height);
      _windows[id]->getSize(&window_width, &window_height);
      _windows[id]->getPosition(&x, &y, height);

      animate->Configure(GetMappedWindows()->getParent(0), _windows[id].get(), osg::Vec2(x, y), osg::Vec2(window_width, window_height), osg::Vec2(width, height));
    }
  }
}

void XwncDesktop::handleImageFramebufferUpdate(XwncWindow* win, bool isRoot,
					       WncImage *img, int x, int y,
					       unsigned int w, unsigned int h)
{
  if (!win)
    {
      g_warning("handleImageFramebufferUpdate for a window we do not know");
      return;
    }

  float wH, wW;
  win->getSize(&wW, &wH);
  if (!(x + w > (unsigned int)wW || y + h > (unsigned int)wH))
    win->updateTexture(img, x, y, w, h);
}

// FIXME
#if 0
void XwncDesktop::handleWindowShape(XwncWindow *win, CARD16 *buf, int nrecs)
{
  if (!win)
    {
      g_warning("handleWindowShape for a window we do not know");
      if (buf)
	free(buf);
      return;
    }
  win->getRenderer()->setShape(buf, nrecs);
}
#endif

void XwncDesktop::handleUnmapWindow(Window id)
{
  XWNC_FUNC();
  WindowMapping::iterator i = _windows.find(id);

  if (i == _windows.end())
    {
      g_warning("Trying to unmap a window we don't know (%lX)", id);
      return;
    }

  osg::ref_ptr<XwncWindow> win = (*i).second ;

  if (win->IsMapped())
    {
      const std::string& window_name = win->GetTitle();
      if(mName2Animate.find(window_name) != mName2Animate.end()) {
	MAFApplication2DAnimate* animate = mName2Animate[window_name];
	animate->Unmap(GetMappedWindows()->getParent(0));
      }
      win->setMapped(false);
      _redoGroup();
//       _down(id);
//       mDisplayGroup->removeChild(win.get());
//       mHitGroup->removeChild(win.get());
    }
}

void XwncDesktop::handleDestroyWindow(Window id)
{
  XWNC_FUNC();
  WindowMapping::iterator i = _windows.find(id) ;
  if (i==_windows.end())
    {
      g_warning("Trying to remove a window we don't know (%lX)", id);
      return ;
    }

  osg::ref_ptr<XwncWindow> win = (*i).second ;

  const std::string& window_name = win->GetTitle();
  if(mName2Animate.find(window_name) != mName2Animate.end()) {
    MAFApplication2DAnimate* animate = mName2Animate[window_name];
    osg::ref_ptr<osg::MatrixTransform> window = win->staticCopy();
    animate->Destroy(GetMappedWindows()->getParent(0), window.get());
  }

  _windows.erase(id);
  _remove(id);
  mDisplayGroup->removeChild(win.get());
  mHitGroup->removeChild(win.get());
}

void	XwncDesktop::handleRestackWindow(Window id,
					 Window nextId,
					 Window transientFor,
					 unsigned long flags)
{
  XWNC_FUNC();
  WindowMapping::iterator i = _windows.find(id);
  WindowMapping::iterator j = _windows.find(nextId);

  // g_debug("id %lx / nextid %lx / transientfor %lx", id, nextId, transientFor);

  if (i == _windows.end())
    {
      g_warning("Trying to restack a window we don't know (%lX)", id);
      return;
    }

  osg::ref_ptr<XwncWindow> win = (*i).second;
  // osg::ref_ptr<XwncWindow> nextWin = (*j).second;

//   if ((flags & rfbWindowFlagsOverrideRedirect) ||
//       (flags & rfbWindowFlagsUnmanaged))
//     win->setUnmanaged();

//   if (flags & rfbWindowFlagsEwmhDesktop)
//     win->setEwmhDesktop();

//   if (flags & rfbWindowFlagsNetChecking)
//     win->hide();

//   if (flags & rfbWindowFlagsTransient)
//     win->setTransientFor(transientFor);

  if (flags & rfbWindowFlagsInputOnly)
    g_warning("Input Only window %lX", id);

  // FIXME
  if (win->IsMapped())
    {
      //		_ascr->root->restack(win, nextWin, false);
      //		_ascr->draw(false);
      //		_ascr->resetSelection(true);
    }
  else
    {
#if 0
      win->mapCorrection();
#endif
      //		_ascr->root->restack(win, nextWin, true);
      //		if (!win->isUnmanaged() && win->neverMapped())
      //			_ascr->root->translateForWindow(win);
      if (!win->isRootWindow())
	{
	  const std::string& window_name = win->GetTitle();
	  if(mName2Animate.find(window_name) != mName2Animate.end()) {
	    MAFApplication2DAnimate* animate = mName2Animate[window_name];
	    animate->Map(GetMappedWindows()->getParent(0));
	  }
	  win->setMapped(true);
	  // _redoGroup();
	}
      //		_ascr->draw(false);
      //		_ascr->resetSelection(true);
    }
  _restack(id, nextId);
}

// ----------------------------------------------------------------------------

void	XwncDesktop::rootPointerEvent(int x, int y, unsigned long button_mask)
{
  _wncServer->pointerEvent(0, x, y, button_mask);
}

void	XwncDesktop::rootKeyEvent(unsigned long key, bool down_flag)
{
  _wncServer->keyEvent(key, down_flag);
}

#if 0
// FIXME
void	XwncDesktop::setModifiers(SDL_Event e, bool down_flag)
{
  if (IsModifierKey(e.keysym))
    {
      KeyCode kc = XKeysymToKeycode(_xdisplay, e.keysym);
      if ((int)kc < 256)
	{
	  _modifierPressed[(int)kc] = down_flag;
	}
    }
}

void	XwncDesktop::releaseModifiers(void)
{
  int i;
  for (i = 0; i < 256; i++)
    if (_modifierPressed[i])
      {
	_wncServer->keyEvent(XKeycodeToKeysym(_xdisplay, i, 0), false);
	_modifierPressed[i] = false;
      }
}
#endif

void	XwncDesktop::getSize(unsigned int*	width, unsigned int* height)
{
  _wncServer->getSize(width, height);
}

// -------------------------------------------------------------------------

void	XwncDesktop::startRequest(void)
{
  _wncServer->updateRequest(true);
}

XwncDesktop::XwncDesktop(const std::string& rfburl, const std::string& style)
{
  _style = style ;
  //  _xdisplay = 0 ;

  URL url(rfburl) ;

  std::string	vncdisplay = url.getHost() + std::string(":") + url.getPort();

  _wncServer = new wncSource(this, WncImage::RGBA, url);
  if (!_wncServer)
    throw new MAFError(UNDERWARE_MAF_ERROR_DATALOAD,
		       "[XwncDesktop] Can't create wncSource");

  if (!_wncServer->start())
    throw new MAFError(UNDERWARE_MAF_ERROR_DATALOAD,
		       "unable to connect to wnc server %s",
		       rfburl.c_str());

  mDisplayGroup = new osg::Group;
  mDisplayGroup->setName("wncDesktop");
  mHitGroup = new osg::Group;
  mHitGroup->setName("wncDesktop");

#if 0
  addNode(_wncServer);

  for (int i = 0; i < 256; i++)
    {
      _modifierPressed[i] = false;
    }
#endif
}

XwncDesktop::~XwncDesktop()
{
  delete _wncServer;
}

// --------------------------------------------------------------------------
#if 0
void	XwncDesktop::prepare(MultiplexRoot *root)
{
  // as a child node, _wncServer is automatically prepared...
  //if (_xdisplay)
  //  root->watchFd(ConnectionNumber(_xdisplay), Multiplexing::READABLE) ;
}

void	XwncDesktop::check(MultiplexRoot *root)
{
  //_wncServer->_readWNCServer();
}

// --------------------------------------------------------------------------

/* Copied from Xvnc/lib/font/util/utilbitmap.c */
static unsigned char _reverse_byte[0x100] = {
	0x00, 0x80, 0x40, 0xc0, 0x20, 0xa0, 0x60, 0xe0,
	0x10, 0x90, 0x50, 0xd0, 0x30, 0xb0, 0x70, 0xf0,
	0x08, 0x88, 0x48, 0xc8, 0x28, 0xa8, 0x68, 0xe8,
	0x18, 0x98, 0x58, 0xd8, 0x38, 0xb8, 0x78, 0xf8,
	0x04, 0x84, 0x44, 0xc4, 0x24, 0xa4, 0x64, 0xe4,
	0x14, 0x94, 0x54, 0xd4, 0x34, 0xb4, 0x74, 0xf4,
	0x0c, 0x8c, 0x4c, 0xcc, 0x2c, 0xac, 0x6c, 0xec,
	0x1c, 0x9c, 0x5c, 0xdc, 0x3c, 0xbc, 0x7c, 0xfc,
	0x02, 0x82, 0x42, 0xc2, 0x22, 0xa2, 0x62, 0xe2,
	0x12, 0x92, 0x52, 0xd2, 0x32, 0xb2, 0x72, 0xf2,
	0x0a, 0x8a, 0x4a, 0xca, 0x2a, 0xaa, 0x6a, 0xea,
	0x1a, 0x9a, 0x5a, 0xda, 0x3a, 0xba, 0x7a, 0xfa,
	0x06, 0x86, 0x46, 0xc6, 0x26, 0xa6, 0x66, 0xe6,
	0x16, 0x96, 0x56, 0xd6, 0x36, 0xb6, 0x76, 0xf6,
	0x0e, 0x8e, 0x4e, 0xce, 0x2e, 0xae, 0x6e, 0xee,
	0x1e, 0x9e, 0x5e, 0xde, 0x3e, 0xbe, 0x7e, 0xfe,
	0x01, 0x81, 0x41, 0xc1, 0x21, 0xa1, 0x61, 0xe1,
	0x11, 0x91, 0x51, 0xd1, 0x31, 0xb1, 0x71, 0xf1,
	0x09, 0x89, 0x49, 0xc9, 0x29, 0xa9, 0x69, 0xe9,
	0x19, 0x99, 0x59, 0xd9, 0x39, 0xb9, 0x79, 0xf9,
	0x05, 0x85, 0x45, 0xc5, 0x25, 0xa5, 0x65, 0xe5,
	0x15, 0x95, 0x55, 0xd5, 0x35, 0xb5, 0x75, 0xf5,
	0x0d, 0x8d, 0x4d, 0xcd, 0x2d, 0xad, 0x6d, 0xed,
	0x1d, 0x9d, 0x5d, 0xdd, 0x3d, 0xbd, 0x7d, 0xfd,
	0x03, 0x83, 0x43, 0xc3, 0x23, 0xa3, 0x63, 0xe3,
	0x13, 0x93, 0x53, 0xd3, 0x33, 0xb3, 0x73, 0xf3,
	0x0b, 0x8b, 0x4b, 0xcb, 0x2b, 0xab, 0x6b, 0xeb,
	0x1b, 0x9b, 0x5b, 0xdb, 0x3b, 0xbb, 0x7b, 0xfb,
	0x07, 0x87, 0x47, 0xc7, 0x27, 0xa7, 0x67, 0xe7,
	0x17, 0x97, 0x57, 0xd7, 0x37, 0xb7, 0x77, 0xf7,
	0x0f, 0x8f, 0x4f, 0xcf, 0x2f, 0xaf, 0x6f, 0xef,
	0x1f, 0x9f, 0x5f, 0xdf, 0x3f, 0xbf, 0x7f, 0xff
};

Bool XwncDesktop::HandleXCursor(
		   int xhot, int yhot, int width, int height, char *buf,
		   rfbXCursorColors colors)
{
  size_t bytesPerRow, bytesData;
  XColor bg, fg;
  Drawable dr;
  Display *dpy;
  unsigned int wret = 0, hret = 0;
  Pixmap source, mask;
  Cursor cursor;
  int i;
  static Bool prevXCursorSet = False;
  static Cursor prevXCursor;

  dpy = (Display*)_ascr->ametista->getDisplay();
  dr = DefaultRootWindow(dpy);
  bytesPerRow = (width + 7) / 8;
  bytesData = bytesPerRow * height;

  if (width * height)
    {
      XQueryBestCursor(dpy, dr, width, height, &wret, &hret);
    }

  if (width * height == 0 || wret < width || hret < height)
    {
      /* Free resources */
      if (buf != NULL)
	{
	  free(buf);
	}
      if (prevXCursorSet)
	{
	  XFreeCursor(dpy, prevXCursor);
	  prevXCursorSet = False;
	}
      return True;
    }

  bg.red   = (unsigned short)colors.backRed   << 8 | colors.backRed;
  bg.green = (unsigned short)colors.backGreen << 8 | colors.backGreen;
  bg.blue  = (unsigned short)colors.backBlue  << 8 | colors.backBlue;
  fg.red   = (unsigned short)colors.foreRed   << 8 | colors.foreRed;
  fg.green = (unsigned short)colors.foreGreen << 8 | colors.foreGreen;
  fg.blue  = (unsigned short)colors.foreBlue  << 8 | colors.foreBlue;

  for (i = 0; i < bytesData * 2; i++)
    {
      buf[i] = (char)_reverse_byte[(int)buf[i] & 0xFF];
    }

  source = XCreateBitmapFromData(dpy, dr, buf, width, height);
  mask = XCreateBitmapFromData(
			       dpy, dr, &buf[bytesData], width, height);
  cursor = XCreatePixmapCursor(
			       dpy, source, mask, &fg, &bg, xhot, yhot);
  XFreePixmap(dpy, source);
  XFreePixmap(dpy, mask);
  free(buf);

  if (_ascr->ametista->getWindowID())
    {
      XDefineCursor(dpy, _ascr->ametista->getWindowID(), cursor);
    }
  if (prevXCursorSet)
    {
      XFreeCursor(dpy, prevXCursor);
      prevXCursorSet = False;
    }
  prevXCursor = cursor;
  prevXCursorSet = True;

  return True;
}
#endif
