/*
*
* Copyright (C) 2004 Mekensleep
*
*	Mekensleep
*	24 rue vieille du temple
*	75004 Paris
*       licensing@mekensleep.com
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*
* Authors:
*  Igor Kravtchenko <igor@obraz.net>
*
*/

#include "mafStdAfx.h"

#ifndef WIN32
#include <maf/mafexport.h>
#include <maf/shader.h>
#endif // WIN32

//
//
// TEXTURE1 * DIFFUSE + TEXTURE2 * SPECULAR
// Only fragment program, vertex still use FFP
//

char MAFFP_TEX1xDIFFUSE_ADD_TEX2xSPECULAR[] = 
"!!ARBfp1.0\n"\
"TEMP	tmp, tmp2;\n"\
"TXP	tmp, fragment.texcoord[0], texture[0], 2D;\n"\
"TXP	tmp2, fragment.texcoord[1], texture[1], 2D;\n"\
"MUL	tmp, tmp, fragment.color.primary;\n"\
"MUL	tmp2, tmp2, fragment.color.secondary;\n"\
"ADD	tmp, tmp, tmp2;\n"\
"MOV	result.color, tmp;\n"\
"\n"\
"END\n";


//
//
// TEXTURE1 * DIFFUSE + TEXTURE2 * SPECULAR
// Use both vertex and fragment program to apply per pixel lighting

/*
char MAFVP_TEST[] =
"!!ARBvp1.0\n"\
"ATTRIB	pos = vertex.position;\n"\
"PARAM	mv[4] = { state.matrix.modelview };\n"\
"PARAM	mvp[4] = { state.matrix.mvp };\n"\
"PARAM	mvinv[4] = { state.matrix.modelview.invtrans };\n"\
"TEMP	tmp, S, vtx;\n"\
"# vertex to clip space\n"\
"DP4	result.position.x, mvp[0], vertex.position;\n"\
"DP4	result.position.y, mvp[1], vertex.position;\n"\
"DP4	result.position.z, mvp[2], vertex.position;\n"\
"DP4	result.position.w, mvp[3], vertex.position;\n"\
"# local normal to eye space\n"\
"DP3	result.texcoord[2].x, mvinv[0], vertex.normal;\n"\
"DP3	result.texcoord[2].y, mvinv[1], vertex.normal;\n"\
"DP3	result.texcoord[2].z, mvinv[2], vertex.normal;\n"\
"# vertex to eye space\n"\
"DP4	vtx.x, mv[0], vertex.position;\n"\
"DP4	vtx.y, mv[1], vertex.position;\n"\
"DP4	vtx.z, mv[2], vertex.position;\n"\
"DP4	vtx.w, mv[3], vertex.position;\n"\
"# light to vertex vector\n"\
"SUB	result.texcoord[3], state.light[0].position, vtx;\n"\
"# V\n"\
"MOV	result.texcoord[4], -vtx;\n"\
"# diffuse color\n"\
"MOV	result.color, state.lightprod[0].diffuse;\n"\
"# tex coords 0 & 1\n"\
"MOV	result.texcoord[0], vertex.texcoord[0];\n"\
"MOV	result.texcoord[1], vertex.texcoord[1];\n"\
"\n"\
"END\n";

char MAFFP_TEST[] = 
"!!ARBfp1.0\n"\
"TEMP	tex1, tex2, tmp, tmp2, S, V;\n"\
"TXP	tex1, fragment.texcoord[0], texture[0], 2D;\n"\
"TXP	tex2, fragment.texcoord[1], texture[1], 2D;\n"\
"MOV	tex2, 1;\n"\
"MOV	tmp, fragment.texcoord[3];\n"\
"DP3	tmp.w, tmp, tmp;\n"\
"RSQ	tmp.w, tmp.w;\n"\
"MUL	tmp.xyz, tmp.w, tmp;\n"\
"DP3	tmp.x, fragment.texcoord[2], tmp;\n"\
"MOV	S, fragment.texcoord[3];\n"\
"MOV	V, fragment.texcoord[4];\n"\
"DP3	S.w, S, S;\n"\
"RSQ	S.w, S.w;\n"\
"MUL	S.xyz, S.w, S;\n"\
"DP3	V.w, V, V;\n"\
"RSQ	V.w, V.w;\n"\
"MUL	V.xyz, V.w, V;\n"\
"ADD	S, S, V;\n"\
"MUL	S, S, 0.5;\n"\
"DP3	tmp.y, S, V;\n"\
"MOV	tmp.w, 0.1;\n"\
"LIT	tmp, tmp;\n"\
"MUL	tmp2, tex1, tmp.y;\n"\
"MAD	tmp2, tex2, tmp.z, tmp2;\n"\
"MOV	result.color, tmp2;\n"\
"END\n";
*/

/*
char MAFVP_TEST[] =
"!!ARBvp1.0\n"\
"ATTRIB	pos = vertex.position;\n"\
"PARAM	mv[4] = { state.matrix.modelview };\n"\
"PARAM	mvp[4] = { state.matrix.mvp };\n"\
"PARAM	mvinv[4] = { state.matrix.modelview.invtrans };\n"\
"TEMP	tmp, S, vtx;\n"\
"# vertex to clip space\n"\
"DP4	result.position.x, mvp[0], vertex.position;\n"\
"DP4	result.position.y, mvp[1], vertex.position;\n"\
"DP4	result.position.z, mvp[2], vertex.position;\n"\
"DP4	result.position.w, mvp[3], vertex.position;\n"\
"# local normal to eye space\n"\
"DP3	result.texcoord[2].x, mvinv[0], vertex.normal;\n"\
"DP3	result.texcoord[2].y, mvinv[1], vertex.normal;\n"\
"DP3	result.texcoord[2].z, mvinv[2], vertex.normal;\n"\
"# vertex to eye space\n"\
"DP4	vtx.x, mv[0], vertex.position;\n"\
"DP4	vtx.y, mv[1], vertex.position;\n"\
"DP4	vtx.z, mv[2], vertex.position;\n"\
"DP4	vtx.w, mv[3], vertex.position;\n"\
"# light to vertex vector\n"\
"SUB	result.texcoord[3], state.light[0].position, vtx;\n"\
"# V\n"\
"MOV	result.texcoord[4], state.light[0].half;\n"\
"# diffuse color\n"\
"MOV	result.color, state.lightprod[0].diffuse;\n"\
"# tex coords 0 & 1\n"\
"MOV	result.texcoord[0], vertex.texcoord[0];\n"\
"MOV	result.texcoord[1], vertex.texcoord[1];\n"\
"\n"\
"END\n";

char MAFFP_TEST[] = 
"!!ARBfp1.0\n"\
"TEMP	tex1, tex2, tmp, tmp2, alf, norm;\n"\
"TXP	tex1, fragment.texcoord[0], texture[0], 2D;\n"\
"TXP	tex2, fragment.texcoord[1], texture[1], 2D;\n"\
"MOV	norm, fragment.texcoord[2];\n"\
"DP3	norm.w, norm, norm;\n"\
"RSQ	norm.w, norm.w;\n"\
"MUL	norm.xyz, norm.w, norm;\n"\
"MOV	tmp, fragment.texcoord[3];\n"\
"DP3	tmp.w, tmp, tmp;\n"\
"RSQ	tmp.w, tmp.w;\n"\
"MUL	tmp.xyz, tmp.w, tmp;\n"\
"DP3	tmp.x, norm, tmp;\n"\
"MOV	alf, fragment.texcoord[4];\n"\
"DP3	alf.w, alf, alf;\n"\
"RSQ	alf.w, alf.w;\n"\
"MUL	alf.xyz, alf.w, alf;\n"\
"DP3	tmp.y, norm, alf;\n"\
"MOV	tmp.w, 2.0;\n"\
"LIT	tmp, tmp;\n"\
"MUL	tmp2, tex1, tmp.y;\n"\
"MAD	tmp2, tex2, tmp.z, tmp2;\n"\
"MOV	result.color, tmp2;\n"\
"END\n";
*/

char MAFVP_TEST[] =
"!!ARBvp1.0\n"\
"ATTRIB	pos = vertex.position;\n"\
"PARAM	mv[4] = { state.matrix.modelview };\n"\
"PARAM	mvp[4] = { state.matrix.mvp };\n"\
"PARAM	mvinv[4] = { state.matrix.modelview.invtrans };\n"\
"TEMP	tmp, vtx;\n"\
"# vertex to clip space\n"\
"DP4	result.position.x, mvp[0], vertex.position;\n"\
"DP4	result.position.y, mvp[1], vertex.position;\n"\
"DP4	result.position.z, mvp[2], vertex.position;\n"\
"DP4	result.position.w, mvp[3], vertex.position;\n"\
"# local normal to eye space\n"\
"DP3	result.texcoord[2].x, mvinv[0], vertex.normal;\n"\
"DP3	result.texcoord[2].y, mvinv[1], vertex.normal;\n"\
"DP3	result.texcoord[2].z, mvinv[2], vertex.normal;\n"\
"# vertex to eye space\n"\
"DP4	vtx.x, mv[0], vertex.position;\n"\
"DP4	vtx.y, mv[1], vertex.position;\n"\
"DP4	vtx.z, mv[2], vertex.position;\n"\
"DP4	vtx.w, mv[3], vertex.position;\n"\
"# light to vertex vector\n"\
"SUB	tmp, state.light[0].position, vtx;\n"\
"MOV	result.texcoord[3], tmp;\n"\
"# half\n"\
"SUB	tmp, tmp, vtx;\n"\
"MUL	result.texcoord[4], tmp, 0.5;\n"\
"# diffuse color\n"\
"MOV	result.color, state.lightprod[0].diffuse;\n"\
"# tex coords 0 & 1\n"\
"MOV	result.texcoord[0], vertex.texcoord[0];\n"\
"MOV	result.texcoord[1], vertex.texcoord[1];\n"\
"\n"\
"END\n";

char MAFFP_TEST[] = 
"!!ARBfp1.0\n"\
"TEMP	tex1, tex2, tmp, tmp2, alf, norm;\n"\
"TXP	tex1, fragment.texcoord[0], texture[0], 2D;\n"\
"TXP	tex2, fragment.texcoord[1], texture[1], 2D;\n"\
"MOV	tex2, 1;\n"\
"MOV	norm, fragment.texcoord[2];\n"\
"DP3	norm.w, norm, norm;\n"\
"RSQ	norm.w, norm.w;\n"\
"MUL	norm.xyz, norm.w, norm;\n"\
"MOV	tmp, fragment.texcoord[3];\n"\
"DP3	tmp.w, tmp, tmp;\n"\
"RSQ	tmp.w, tmp.w;\n"\
"MUL	tmp.xyz, tmp.w, tmp;\n"\
"DP3	tmp.x, norm, tmp;\n"\
"MOV	alf, fragment.texcoord[4];\n"\
"DP3	alf.w, alf, alf;\n"\
"RSQ	alf.w, alf.w;\n"\
"MUL	alf.xyz, alf.w, alf;\n"\
"DP3	tmp.y, norm, alf;\n"\
"MOV	tmp.w, 0.7;\n"\
"LIT	tmp, tmp;\n"\
"MUL	tmp2, tex1, tmp.y;\n"\
"MAD	tmp2, tex2, tmp.z, tmp2;\n"\
"MOV	result.color, tmp2;\n"\
"END\n";



void MAFShader::get(int flags, char **vertex_program, char **fragment_program)
{
	if (fragment_program)
		*fragment_program = MAFFP_TEST;

	if (vertex_program)
		*vertex_program = MAFVP_TEST;
}
