/*
*
* Copyright (C) 2004 Mekensleep
*
*	Mekensleep
*	24 rue vieille du temple
*	75004 Paris
*       licensing@mekensleep.com
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*
* Authors:
*  Igor Kravtchenko <igor@obraz.net>
*
*/

#include "mafStdAfx.h"

// Big/Little Endian MakeID
#define BI_MID(a,b,c,d)		( ((a)<<24) + ((b)<<16) + ((c)<<8) + (d) )
#define LI_MID(a,b,c,d)		( ((d)<<24) + ((c)<<16) + ((b)<<8) + (a) )
#define MID					BI_MID

union UnionType {
	char c;
	short s;
	int Int;
	float Float;
	char *pC;
	short *pS;
	int *pI;
	float *pF;
};

#ifndef USE_VS_PCH
#include <glib.h>
#include <maf/radixsort.h>
#include <maf/flyingitem.h>
#endif

struct RdxFloat32ByteMarker {
	int mask;
	int shift;
} rdxFloat32ByteMarker[5] = { 0xff, 0, 0xff, 8, 0x7f, 16, 0xff, 23, 0x1, 31};

FloatRadix::FloatRadix(int nbItems)
{
	nbItems_ = nbItems;
	pTmpListPtr1_ = new RadixFloatItem*[nbItems];
	pTmpListPtr2_ = new RadixFloatItem*[nbItems];
}

FloatRadix::~FloatRadix()
{
	delete [] pTmpListPtr1_;
	delete [] pTmpListPtr2_;
}

RadixFloatItem** FloatRadix::sort(RadixFloatItem *pItemList, int nbItems)
{
	int radixIndex[257];
	UnionType un;
	int i;

	RadixFloatItem **src = pTmpListPtr1_;
	RadixFloatItem **dst = pTmpListPtr2_;

	for (i = 0; i < nbItems; i++)
		src[i] = &pItemList[i];

	for (int iPass = 0; iPass < 5; iPass++) {
		int mask = rdxFloat32ByteMarker[iPass].mask;
		int shift = rdxFloat32ByteMarker[iPass].shift;

		memset(radixIndex, 0, sizeof radixIndex);
		for (i = 0; i < nbItems; i++) {
			un.Float = src[i]->value;
			int n = (un.Int >> shift) & mask;
			if (iPass == 4)
				n = 1 - n;
			radixIndex[n + 1]++;
		}

		for (i = 1; i < 257; i++)
			radixIndex[i] += radixIndex[i - 1];

		for (i = 0; i < nbItems; i++) {
			un.Float = src[i]->value;
			int n = (un.Int >> shift) & mask;
			if (iPass == 4)
				n = 1 - n;
			int index = radixIndex[n]++;
			dst[index] = src[i];
		}

		RadixFloatItem **tmp = src;
		src = dst;
		dst = tmp;
	}

	// final very quick pass to reverse the order of negative values

	int nbNegative = radixIndex[0];
	if (nbNegative > 1){
		int a = 0;
		int b = nbNegative - 1;
		nbNegative >>= 1;
		while(nbNegative--) {
			RadixFloatItem *tmp;
			tmp = src[a];
			src[a] = src[b];
			src[b] = tmp;
			a++; b--;
		}
	}

	return src;
}

// =======================

ByteRadix::ByteRadix(int nbItems)
{
	nbItems_ = nbItems;
	pTmpListPtr1_ = new RadixByteItem*[nbItems];
	pTmpListPtr2_ = new RadixByteItem*[nbItems];
}

ByteRadix::~ByteRadix()
{
	delete [] pTmpListPtr1_;
	delete [] pTmpListPtr2_;
}

RadixByteItem** ByteRadix::sort(RadixByteItem *pItemList, int nbItems)
{
	unsigned radixIndex[257];
	int i;

	RadixByteItem **src = pTmpListPtr1_;
	RadixByteItem **dst = pTmpListPtr2_;

	for (i = 0; i < nbItems; i++)
		src[i] = &pItemList[i];

	memset(radixIndex, 0, sizeof radixIndex);
	for (i = 0; i < nbItems; i++) {
		int n = src[i]->value & 0xff;
		radixIndex[n + 1]++;
	}
	
	for (i = 1; i < 257; i++)
		radixIndex[i] += radixIndex[i - 1];
	
	for (i = 0; i < nbItems; i++) {
		int n = src[i]->value & 0xff;
		int index = radixIndex[n]++;
		dst[index] = src[i];
	}

	return dst;
}


// =======================

ShortRadix::ShortRadix(int nbItems)
{
	nbItems_ = nbItems;
	pTmpListPtr1_ = new RadixShortItem*[nbItems];
	pTmpListPtr2_ = new RadixShortItem*[nbItems];
}

ShortRadix::~ShortRadix()
{
	delete [] pTmpListPtr1_;
	delete [] pTmpListPtr2_;
}

RadixShortItem** ShortRadix::sort(RadixShortItem *pItemList, int nbItems)
{
	unsigned radixIndex[257];
	int i;

	RadixShortItem **src = pTmpListPtr1_;
	RadixShortItem **dst = pTmpListPtr2_;

	for (i = 0; i < nbItems; i++)
		src[i] = &pItemList[i];

	for (int numPass = 0; numPass < 2; numPass++) {
		int shift = numPass << 3;

		memset(radixIndex, 0, sizeof radixIndex);
		for (i = 0; i < nbItems; i++) {
			int n = (src[i]->value >> shift) & 0xff;
			radixIndex[n + 1]++;
		}

		for (i = 1; i < 257; i++)
			radixIndex[i] += radixIndex[i - 1];

		for (i = 0; i < nbItems; i++) {
			int n = (src[i]->value >> shift) & 0xff;
			int index = radixIndex[n]++;
			dst[index] = src[i];
		}

		RadixShortItem **tmp = src;
		src = dst;
		dst = tmp;
	}

	return src;
}


// =======================

IntRadix::IntRadix(int nbItems)
{
	nbItems_ = nbItems;
	pTmpListPtr1_ = new RadixIntItem*[nbItems];
	pTmpListPtr2_ = new RadixIntItem*[nbItems];
}

IntRadix::~IntRadix()
{
	delete [] pTmpListPtr1_;
	delete [] pTmpListPtr2_;
}

RadixIntItem** IntRadix::sort(RadixIntItem *pItemList, int nbItems)
{
	unsigned radixIndex[257];
	int i;

	RadixIntItem **src = pTmpListPtr1_;
	RadixIntItem **dst = pTmpListPtr2_;

	for (i = 0; i < nbItems; i++)
		src[i] = &pItemList[i];

	for (int numPass = 0; numPass < 4; numPass++) {
		int shift = numPass << 3;

		memset(radixIndex, 0, sizeof radixIndex);
		for (i = 0; i < nbItems; i++) {
			int n = (src[i]->value >> shift) & 0xff;
			radixIndex[n + 1]++;
		}

		for (i = 1; i < 257; i++)
			radixIndex[i] += radixIndex[i - 1];

		for (i = 0; i < nbItems; i++) {
			int n = (src[i]->value >> shift) & 0xff;
			int index = radixIndex[n]++;
			dst[index] = src[i];
		}

		RadixIntItem **tmp = src;
		src = dst;
		dst = tmp;
	}

	return src;
}

// =======================

BigRadix::BigRadix(int nbItems)
{
	nbItems_ = nbItems;
	pTmpListPtr1_ = new RadixBigItem*[nbItems];
	pTmpListPtr2_ = new RadixBigItem*[nbItems];
}

BigRadix::~BigRadix()
{
	delete pTmpListPtr1_;
	delete pTmpListPtr2_;
}

RadixBigItem** BigRadix::sort(RadixBigItem *pItemList, int nbItems)
{
	int radixIndex[257];
	int i;

	RadixBigItem **src = pTmpListPtr1_;
	RadixBigItem **dst = pTmpListPtr2_;

	for (i = 0; i < nbItems; i++)
		src[i] = &pItemList[i];

	for (int iPass = 0; iPass < RADIX_SIZEBIGITEM; iPass++) {
		memset(radixIndex, 0, sizeof radixIndex);
		for (i = 0; i < nbItems; i++) {
			int n = src[i]->value[iPass];
			radixIndex[n + 1]++;
		}

		for (i = 1; i < 257; i++)
			radixIndex[i] += radixIndex[i - 1];

		for (i = 0; i < nbItems; i++) {
			int n = src[i]->value[iPass];
			int index = radixIndex[n]++;
			dst[index] = src[i];
		}

		RadixBigItem **tmp = src;
		src = dst;
		dst = tmp;
	}

	return src;
}

