
#include "mafStdAfx.h"

#ifndef USE_VS_PCH
#include <osg/Matrix>

#include <maf/flyingitem.h>
#endif

void MAFFlyingItem::goForward(osg::Matrixf &_mat, float _step)
{
	_mat(3, 0) -= _mat(2, 0) * _step;
	_mat(3, 1) -= _mat(2, 1) * _step;
	_mat(3, 2) -= _mat(2, 2) * _step;
}

void MAFFlyingItem::goBackward(osg::Matrixf &_mat, float _step)
{
	_mat(3, 0) += _mat(2, 0) * _step;
	_mat(3, 1) += _mat(2, 1) * _step;
	_mat(3, 2) += _mat(2, 2) * _step;
}

void MAFFlyingItem::goLeft(osg::Matrixf &_mat, float _step)
{
	_mat(3, 0) -= _mat(0, 0) * _step;
	_mat(3, 1) -= _mat(0, 1) * _step;
	_mat(3, 2) -= _mat(0, 2) * _step;
}

void MAFFlyingItem::goRight(osg::Matrixf &_mat, float _step)
{
	_mat(3, 0) += _mat(0, 0) * _step;
	_mat(3, 1) += _mat(0, 1) * _step;
	_mat(3, 2) += _mat(0, 2) * _step;
}

void MAFFlyingItem::goUp(osg::Matrixf &_mat, float _step)
{
	_mat(3, 0) += _mat(1, 0) * _step;
	_mat(3, 1) += _mat(1, 1) * _step;
	_mat(3, 2) += _mat(1, 2) * _step;
}

void MAFFlyingItem::goDown(osg::Matrixf &_mat, float _step)
{
	_mat(3, 0) -= _mat(1, 0) * _step;
	_mat(3, 1) -= _mat(1, 1) * _step;
	_mat(3, 2) -= _mat(1, 2) * _step;
}
